// ========================================================================
//  TODB LIBRARY
//    cpperr.h
//
//    Object for reporting errors
//    ErrReporter class, DosErrReporter class
//
//    Version: see TODB.H file
//
//    Copyright 1993 Christian Thrien
//    All rights reserved
//
//  See Scott R. Ladd reference in the documentation manual for a
//  complete implementation of these classes.
//
//  Complete implementation is:
//	Copyright 1992 Scott Robert Ladd
//	All Rights Reserved
//
// ========================================================================

#ifndef _CPPERR_H
#define _CPPERR_H

class ErrReporter;
#include "strn.h"
#include <iostream.h>

//-------------------------------------------------------------------------
// ErrReporter class
//    Error message generator
//-------------------------------------------------------------------------

class ErrReporter
{
public:
    virtual ~ErrReporter();

    virtual void Abort( const String & msg ) = 0;
    virtual void Fatal( const String & msg ) = 0;

protected:
    virtual void MsgOut( const String & msg ) = 0;
};

inline ErrReporter::~ErrReporter()
{
}

//-------------------------------------------------------------------------
// DosErrReporter class
//    Error message generator for DOS
//-------------------------------------------------------------------------

class DosErrReporter : public ErrReporter
{
public:
    DosErrReporter( ostream * strm = NULL );

    ~DosErrReporter();

    void Abort( const String & msg );
    void Fatal( const String & msg );

protected:
    void MsgOut( const String & msg );

private:
    ostream * destination_;
};

inline DosErrReporter::~DosErrReporter()
{
}

#endif // _CPPERR_H
