// ========================================================================
//  TODB LIBRARY
//    schema.h
//
//    Schema
//
//    Version: see TODB.H file
//
//    Copyright 1993 Christian Thrien
//    All rights reserved
// ========================================================================

#ifndef _SCHEMA_H
#define _SCHEMA_H

#include "todb.h"
#include "icoll.h"
#include "kspersis.h"

extern Boolean LoadBibNote( char * fn );
Boolean DeleteBibNote( char * fn );
extern TODB * ksDB;

//-------------------------------------------------------------------------
// MakeTokenUW class
//     "Upper case Word" token generator
//-------------------------------------------------------------------------

class MakeTokenUW : public MakeToken
{
public:
    MakeTokenUW();
    ~MakeTokenUW();
    void Put( const char * s );
    int First( char * token );
    int Next( char * token );

private:
    char * buf_;
    char * postoken_;
    int length_;

    int AcceptToken( char * token );
};

inline MakeTokenUW::~MakeTokenUW()
{
    delete [] buf_;
}

//-------------------------------------------------------------------------
// Persistent classes identification (cid)
//-------------------------------------------------------------------------

enum ClassId
{
    // Count class identification
    COUNT,
    // BibNote class identification
    BIBNOTE
};

//-------------------------------------------------------------------------
// Indexes identification (idxid)
//-------------------------------------------------------------------------

// BibNote class
enum BibNote_idxid
{
    AUTHOR,	    // index field
    DATE,
    KEYWORDS,
    PUBLISHER,
    PUB_PLACE,

// common indexes identification
    TITLES,	    // index identification (idxid) for
		    // common indexation of
		    // title and article_title
    SUBTITLES	    // index identification for
		    // common indexation of
		    // subtitle and article_subtitle
};

//-------------------------------------------------------------------------
// Count class
//-------------------------------------------------------------------------
// Only one instance of this class is placed at the beginning of the file.
// This instance keeps the state of a counter.	This counter is used as a
// single (primary or auxiliary) key generator (RECORD-ID generator).

class Count : public KSPersistent
{
public:
    Count();
    Count( KeyType countno );
    ~Count();

    KeyType CNote();
    void SetCNote( KeyType cn );
    KeyType IncCNote();
    void SetVersion( String & vs );
    Boolean Dirty();
    void SetDirty();
    void ResetDirty();

private:
    String version_;
    unsigned int dirty_;
    KeyType cnote_;

    void Read();
    void Write();
};

inline KeyType Count::CNote()
{
    return cnote_;
}

inline KeyType Count::IncCNote()
{
    return ++cnote_;
}

//-------------------------------------------------------------------------
// BibNote class
//-------------------------------------------------------------------------
// The indexed object!

class BibNote : private IdxColl
{
friend Boolean LoadBibNote( char * fn );
friend Boolean DeleteBibNote( char * fn );

public:
    BibNote( KeyType nno );

    ~BibNote();

    void Delete();

private:
    KeyType noteno;	  // single (primary or auxiliary) key

    IdxString author;	  // index field; idxid is AUTHOR
    String    shelf_mark; // this field is not indexed
    IdxString date;	  // index field; idxid is DATE
    IdxString keywords;   // and so on
    IdxString publisher;
    String    issn;
    String    isbn;
    IdxString publishing_place;
    String    paging;
    IdxString title;
    IdxString subtitle;
    IdxString article_title;
    IdxString article_subtitle;

    MakeTokenUW UW_token;

    void Index();
};

inline BibNote::~BibNote()
{
    SaveIdx();
}

#endif	// _SCHEMA_H
