// ========================================================================
//  TODB LIBRARY
//    tindex.h
//
//    TIndex class
//    B-Plus interface
//
//    Version: see TODB.H file
//
//    Copyright 1993 Christian Thrien
//    All rights reserved
// ========================================================================

#ifndef _TINDEX_H
#define _TINDEX_H

#include "strn.h"
#include "boolean.h"

extern "C"
{
#include "bplus.h"
}

class ErrReporter;

enum DupKeys
{
    NO_DUP,	     // duplicate key not allowed (normal state for TODB)
    DUP 	     // duplicate key allowed
};

enum TIndexError
{
    TIE_CLOSED,	     // file already closed
};

class TIndex
{
public:
    // constructors
    TIndex();
    TIndex( DupKeys dk, String & fn );

    // destructor
    ~TIndex();

    // index file manipulators
    int OpenExist( DupKeys dk, String & fn );
    int OpenNew( DupKeys dk, String & fn );
    int CloseIndex();

    // index operators
    int FindKey( const char * key, RECPOS * addr );
    int LocateKey( char * key, RECPOS	* addr );
    int AddKey( const char * key, RECPOS addr );
    int DeleteKey( const char * key, RECPOS addr );
    int NextKey( char * key, RECPOS * addr );
    void BufferFlush();

    // error control
    static void SetErrOut( ErrReporter * er );

    // not implemented
#ifdef ALL_TINDEX
    int FirstKey();
    int LastKey();
    int PrevKey();
    int FindExact();
#endif // ALL_TINDEX

private:
    IX_DESC pix_;
    ENTRY   ee_;
    String  fname_;
    int     dupKeys_;
    Boolean open_;

    //	disable (meaningless for this class)
    TIndex( const TIndex & bp );
    TIndex & operator = ( const TIndex & bp );

    // error control
    static ErrReporter * ErrOut;
    static void ErrorHandler( TIndexError err );
};

#endif // _TINDEX_H
