





                              WILD CARDS



OVERVIEW

Wild is a tool for used by C programmers, to create utilities for end
users.

Wild is a set of C source code that you can compile and link with your
own C programs.  It can turn a utility that processes a single file to
one that processes multiple wildcards, both positive and negative,
with the /S option to handle all subdirectories as well.


END USER VIEW

Let us say you wrote a program called TabOut.Exe.  It expands tabs to
spaces in a file.  By modifying your program to use Wild you could
then say:

     Tabout *.C *.H

to invoke Tabout on all the *.C and *.H files in the current
directory.

Wild supports multiple positive and negative wildcards.  Thus you
could say:

     Tabout *.C *.H -Spec.C -X*.H

That would process all the *.C *.H files except for file Spec.C and
any X*.H files.

You may specify a mixture of wildcards and individual filenames.
e.g.:

     Tabout X.Txt Y.Txt *.C

You may also specify full pathnames, and you may add the /S option to
process all subdirectories as well.  For example you could say:

     Tabout D:\MyDir\*.C/S

The /S normally directly follows the file it applies to, but you may
separate it with a space.


SHORTCUTS

It would be tedious to have to write:





 C:\AB1\UTIL\WILD.DOC last updated by Roedy Green 93/11/11









     Tabout D:\MyDir\*.C/S  D:\MyDir\*.H/S -D:\MyDir\X*.*/S

so there is a shortcut.  If you leave off the directory, the directory
on the preceding wildcard is presumed.  Further, any /S is presumed as
well.  So you could abbreviate the above to:

     Tabout D:\MyDir\*.C/S  *.H -X*.*

The /S turns off once you specify a drive or directory.  So:

     Tabout D:\MyDir\*.C/S  D:\MyDir\*.H/S  -D:\MyDir\X*.*

could be abbreviated:

     Tabout D:\MyDir\*.C/S  *.H  -D:\MyDir\X*.*


PROGRAMMER'S VIEW

Wild is much like argc argv[] command line options. except the user
can specify both individual files and also wildcards.  You give Wild a
set of wildcard strings, (argc and argv[] will do.).  It then
generates a an expanded set of filename strings and hands them back to
you.  You can then process them almost identically to the way you
would process filenames on the command line.

Wild is much like SETARGV, except that Wild gives you more control.
For example, you can preprocess the command line, and pass only the
wildcards onto Wild for expansion, processing the option switches
yourself.


COMPILATION

To use Wild you must first compile Wild.C using the same model as you
use for your own program e.g. /AT for tiny, /AS for small, /AC for
compact, /AM for medium, /AL for large, or /AH for huge.  /AC and /AM
can handle more files.  The total size of the filename strings can
exceed 64K in the compact and large models.  For small utilities, you
would probably usually use /AC which allows for multiple data segments
and one code segment.

Then you include Wild.H in your program, and compile and link it with
Wild.Obj.

You need to write two callback routines : one for filtering and one
for processing the filenames.

The filter routine defines which file attributes are of interest to
you.  I have provided a suite of sample such routines in WildFilt.H,
so you probably won't have to actually write one from scratch, just
copy one or modify one of these samples.




 C:\AB1\UTIL\WILD.DOC last updated by Roedy Green 93/11/11









The routine to process the filenames looks very much like the code you
would write in a mainline routine to process argc and argv.

I have included a sample program called WILDSAM1.C that uses wild to
implement a very simple DIR command that supports multiple positive
and negative wildcards.  Looking at that will tell you far more about
the details than reading this documentation.  I have also shown a
slightly fancier version called WILDSAM2.C that sorts the strings
before displaying them.


PROCESSING THE STRINGS

Your routine to process the filenames can do anything it wants with
the filename pointers.  It can set them some pointers to null.  It can
sort the pointers.  It can use Wild_Free to free the storage taken by
the pointers and the strings themselves.  It can squirrel away a
static pointer to the filename pointers to be used after the callback
function to process the filenames terminates.


IMPROVING OTHER PEOPLE'S UTILITIES

Wild was designed to be added to a program you wrote yourself.  What
if you want to improve a utility that processes only one file, when
you only have the executable code?  You can use Wild to generate the
full list of filenames, then use the C spawn function to invoke the
utility with each of the filenames.  This is slow, since the spawned
utility must be freshly loaded for each file.  However, I have shown
you how to do that in my third example WILDSAM3.C.  It adds multiple
positive and negative WildCards to DOS PRINT.EXE.

For example, with a little cleverness you could add positive and
negative wildcards to DOS ATTRIB.  You would have to strip out the
command line options destined for ATTRIB and avoid feeding them to
WILD, then insert them on the spawn.

-30-


















 C:\AB1\UTIL\WILD.DOC last updated by Roedy Green 93/11/11



