/***************************************************************************
  Windows Sockets FTP Client Application Support Module

  Written by:
      John A. Junod             Internet: <junodj@gordon-emh2.army.mil>
      267 Hillwood Street                 <zj8549@trotter.usma.edu>
      Martinez, GA 30907      Compuserve: 72321,366 

  This program executable and all source code is released into the public
  domain.  It would be nice (but is not required) to give me a little 
  credit for any use of this code.

  THE INFORMATION AND CODE PROVIDED IS PROVIDED AS IS WITHOUT WARRANTY 
  OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
  PURPOSE. IN NO EVENT SHALL JOHN A. JUNOD BE LIABLE FOR ANY DAMAGES 
  WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL, CONSEQUENTIAL, LOSS 
  OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF JOHN A. JUNOD HAS BEEN 
  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

*****************************************************************************/
/*
  MODULE: WS_FTP.H   (main program header file)
*/

#include <windows.h>

// **** Dialog box names
// #define DLG_ABOUT                 510
// #define DLG_HOST                  520
// #define DLG_INPUT                 530
// #define DLG_STATUS                540

// **** debug window menu definitions
// may be used by other functions!

// under COMMAND popup menu
#define CMD_CONNECT                 1010
#define CMD_CLOSE                   1020

#define CMD_CWD                     1040
#define CMD_DELE                    1050
#define CMD_HELP                    1060
#define CMD_LIST                    1070
#define CMD_MKD                     1080
#define CMD_NLST                    1090
#define CMD_PWD                     1100
#define CMD_QUOTE                   1110
#define CMD_RETR                    1120
#define CMD_RMD                     1130
#define CMD_STATUS                  1140
#define CMD_STOR                    1150

#define CMD_TYPE_I                  1170
#define CMD_TYPE_A                  1180

#define CMD_SHFLAGS                 1200

// under OPTIONS popup menu
#define OPT_SETVIEWER               1410

#define IDM_ABOUT                   1500
#define IDM_EXIT                    1600

// **** main window child window identifiers
// TXT = static text windows
// LST = list boxes
// BTN = push buttons
// RB  = radio buttons

// local side child windows
#define TXT_LDIRECTORY              2110
#define LST_LDIRS                   2120
#define LST_LFILES                  2130
#define BTN_LCHANGE                 2140
#define BTN_LMKDIR                  2150
#define BTN_LRMDIR                  2160
#define BTN_LDISPLAY                2170
#define BTN_LRENAME                 2180
#define BTN_LDELETE                 2190

// lgk new windows for directory selection

#define TXT_LDIRSEL                2191
#define TXT_RDIRSEL                2192

// remote side child windows
#define TXT_HOSTNAME                2200
#define TXT_RDIRECTORY              2210
#define LST_RDIRS                   2220
#define LST_RFILES                  2230
#define BTN_RCHANGE                 2240
#define BTN_RMKDIR                  2250
#define BTN_RRMDIR                  2260
#define BTN_RDISPLAY                2270
#define BTN_RRENAME                 2280
#define BTN_RDELETE                 2290

// transfer buttons
#define BTN_LOCAL_TO_REMOTE         2310
#define BTN_REMOTE_TO_LOCAL         2320
#define BTN_LOCAL_DIRS_TO_REMOTE    2330
#define BTN_REMOTE_DIRS_TO_LOCAL    2340

// configuration buttons
#define RB_ASCII                    2410
#define RB_BINARY                   2411
#define RB_L8                       2412

// information text windows
#define TXT_STATUS                  2510
#define TXT_RBYTES                  2520
#define TXT_LBYTES                  2530

// control buttons
#define BTN_CONNECT                 2610
#define BTN_CLOSE                   2620
// lgk new abort button
#define BTN_ABORT                   2625
#define BTN_LONG                    2630
#define BTN_OPTION                  2635
#define BTN_ABOUT                   2640
#define BTN_EXIT                    2650

// input dialog controls
#define DLG_PROMPT                  3010
#define DLG_EDIT                    3020

// **** connect dialog box controls
#define DLG_EDT_HOST                4010
#define DLG_EDT_USERID              4020
#define DLG_EDT_PASSWD              4030
#define DLG_HOST_TIMEOUT            4040
#define DLG_ABT_L1                  4050
#define DLG_ABT_L2                  4060
#define DLG_VERSION                 4070


// **** status dlg identifiers
#define CKB_BELL                    5010
#define CKB_CRSTRIP                 5020
#define CKB_GLOBBING                5030
#define CKB_HASH                    5040
#define CKB_PROMPT                  5050
#define CKB_INTERACTIVE             5060
#define CKB_MCASE                   5070
#define CKB_PORT_CMDS               5080
#define CKB_RECV_UNIQUE             5090
#define CKB_STOR_UNIQUE             5100
#define CKB_VERBOSE                 5110
#define CKB_AUTOSTART               5120
#define BTN_OPTIONS                 5130
#define DLG_MAILADDR                5250

#define RB_SHOWCHECKS 8100

// **** misc definitions
#define TYPE_I 'I'
#define TYPE_A 'A'
#define TYPE_E 'E'
#define TYPE_L 'L'

#define FORM_N 'N'
#define FORM_T 'T'
#define FORM_C 'C'

#define MODE_S 'S'
#define MODE_B 'B'
#define MODE_C 'C'

#define DBUGWNDCLASS "WSDBUGWNDCLASS"

struct win_info {
  HWND hWnd;
  int nLineHeight;
  int nScreenRows;
  int nMemPtr;
  int nVpos;
  GLOBALHANDLE hGMem[100];
};

// **** function prototypes

int MakeLocalName(LPSTR,LPSTR,LPSTR);
void SaveHostName(LPSTR);
void LoadUserInfo(void);
void DoMainPaint(HWND);
void SaveUserInfo(void);
int StdInput(LPSTR,LPSTR,...);
int StdInputPassword(LPSTR,LPSTR,...);
int GPPS(LPSTR,LPSTR,LPSTR,int);
int WPPS(LPSTR,LPSTR);

// in ws_child.c
int CreateSubWindows(HWND,HWND);
int GetLocalDirForWnd(HWND);
LPSTR FindName(LPSTR);
int GetRemoteDirForWnd(HWND);
void ShowOurFlags(void);
int ReadProcessHelp(SOCKET);
void ScrollStatus(int);
void SetStatus(LPSTR);

// in ws_con.c
int getreply(SOCKET,LPSTR);
int command(SOCKET socket, char *fmt,...);
char *onoff(BOOL);
int DoSTAT(SOCKET);
int DoCHMOD(SOCKET,LPSTR,LPSTR);
int DoCWD(SOCKET,LPSTR);
int DoDirList(SOCKET,LPSTR);
int DoDELE(SOCKET,LPSTR);
int DoMKD(SOCKET,LPSTR);
int DoPWD(SOCKET);
int DoQUOTE(SOCKET,LPSTR);
int DoRMD(SOCKET,LPSTR);
volatile SOCKET DoConnect(LPSTR);
int DoDirList(SOCKET,LPSTR);
int SendFile(SOCKET,LPSTR,LPSTR,char);
int RetrieveFile(SOCKET,LPSTR,LPSTR,LPSTR,char);
volatile SOCKET DoClose(SOCKET sockfd);
int SendPacket(SOCKET,LPSTR);
int ReadDisplayLine(SOCKET);
DWORD waitfor550();
void closefilesonabort();
int ReadLine(SOCKET);
volatile SOCKET GetFTPListenSocket(SOCKET sockfd);
int SendMass(SOCKET,LPSTR filename,BOOL);
int ReadMass(SOCKET,LPSTR filename,LPSTR shortname,BOOL);

// in ws_ip.c
volatile SOCKET connectsock(char *host,char *service,char *protocol);
volatile SOCKET connectTCP(char *host,char *service);
volatile SOCKET connectUDP(char *host,char *service);
int sendstr(SOCKET sockfd,LPSTR ptr,int nbytes);

int CreateDebugWindow(HWND hMainWnd,HWND hInst);
LRESULT CALLBACK DebugWndProc(HWND hWnd,UINT Message,WPARAM wParam,LPARAM lParam);

// in ws_error.c
LPSTR ReturnWSError(UINT Err,LPSTR lpszBuf);
void ReportWSError(LPSTR lpszMsg,UINT Err);
VOID ReportWindowWSError(struct win_info *Window,LPSTR lpszMsg,UINT nErr);

// in ws_main.c
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK WS_AboutMsgProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK WS_HostMsgProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK WS_InputMsgProc(HWND, UINT, WPARAM, LPARAM);
BOOL CALLBACK WS_StatMsgProc(HWND, UINT, WPARAM, LPARAM);
int nCwRegisterClasses(void);
void cwCenter(HWND, int);
void CwUnRegisterClasses(void);

// in ws_paint.c
int GetLocalInfo(void);
void ReleaseDisplayMem(VOID);
void ReleaseWindowMem(struct win_info *);
void DoAddLine(LPSTR);
void DoAddWindowLine(struct win_info *,LPSTR);
void DoPrintf(char *fmt,...);
void DoWindowPrintf(struct win_info *,char *,...);
void DoWindowPaint(struct win_info *);

#define DLG_HOST_NAME               105
#define DLG_HOST_ADDRESS            106
#define DLG_HOST_TYPE               107
#define DLG_HOST_USERID             108
#define DLG_HOST_PASSWORD           109
#define DLG_HOST_DIR                110
#define DLG_HOST_ANONY              111
#define DLG_HOST_SAVE               112
#define DLG_HOST_PWD                113
#define DLG_HOST_GATEWAY            114
#define DLG_HOST_RETRIES            115
#define DLG_HOST_FTP_PORT           116

#define HOST_TYPE_AUTO               6000
#define HOST_TYPE_CHAMELEON          6001
#define HOST_TYPE_PCTCP              6002
#define HOST_TYPE_IBM_TCP            6003
#define HOST_TYPE_IBM_VM             6004
#define HOST_TYPE_NOS                6005
#define HOST_TYPE_NCSA               6006
#define HOST_TYPE_SINTFTPD           6007
#define HOST_TYPE_SUPER              6008
#define HOST_TYPE_U5000              6009
#define HOST_TYPE_UNIX               6010
#define HOST_TYPE_VMS_MULTINET       6011
#define HOST_TYPE_VMS_UCX            6012
#define HOST_TYPE_QVT                6013
#define HOST_TYPE_WINDOWS_NT         6014
#define HOST_TYPE_SOLARIS            6015
#define HOST_TYPE_INNOV_WINDOWS_NT   6016


#define DLG_BTN_SAVE                101
#define DLG_BTN_DEL                 102
#define IDC_STATIC                  -1
