{$V-,N+,E+,X+}

{ EXAMPLE4.PAS - demonstrate Btrieve data conversion routines

  Requires Turbo Pascal version 6.0, 7.0
}

USES
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  {$IFDEF VER70}
  WinDos,
  {$ELSE}
  Dos,
  {$ENDIF}
  BtvConst,
  Btv,
  BtvType;


TYPE
  DataRec = record
    Str   : Array[1..25] of Char;
    Ch    : Char;
    Int2  : Integer;
    Int4  : LongInt;
    Flt4  : Single;
    Flt8  : Double;
    Date  : BDateRec;
    Time  : BTimeRec;
    Dec6  : Array[1..6] of Byte;
    Dec10 : Array[1..10] of Byte;
    Mony2 : Array[1..2] of Byte;
    Mony10: Array[1..10] of Byte;
    Logic1: Byte;
    Logic2: Word;
    Num1  : Char;
    Num4  : Array[1..4] of Char;
    Num9  : Array[1..9] of Char;
    BFlt4 : Array[1..4] of Byte;
    BFlt8 : Array[1..8] of Byte;
    LStr  : String[15];
    ZStr  : Array[1..10] of Char;
    Auto  : Word;
  end;


VAR
  F   : BtrieveFile;
  Dat : DataRec;
  Tmp : String;


Procedure CheckIO;
  begin
    if (F.bResult <> bOkay) and (F.bResult <> bEOF) then
    begin
      Writeln('ERROR #', F.bResult);
      Halt;
    end;
  end;


BEGIN
  { this file has a field of each Btrieve type }
  F.Init('TYPES.DAT', nil, @Dat, SizeOf(Dat));
  F.Open(bNormal, '');
  CheckIO;

  F.Get(bStepFirst, bNoLock);

  While (F.bResult = bOkay) do
  begin
    ClrScr;

    with Dat do
    begin
      { Convert to strings, then convert from the string to the type and
        display both values for comparison
      }
      Tmp := StringToStr(Str, SizeOf(Str));
      StrToString(Tmp, Str);
      Writeln('STRING   : [', Tmp, ']  [', StringToStr(Str, SizeOf(Str)), ']');

      Tmp := StringToStr(Ch, SizeOf(Ch));
      StrToString(Tmp, Ch);
      Writeln('CHAR     : [', Tmp, ']  [', StringToStr(Ch, SizeOf(Ch)), ']');

      Tmp := IntegerToStr(Int2, SizeOf(Int2), 5);
      StrToInteger(Tmp, Int2, SizeOf(Int2));
      Writeln('INTEGER  : [', Tmp, ']  [', IntegerToStr(Int2, SizeOf(Int2), 5), ']');

      Tmp := IntegerToStr(Int4, SizeOf(Int4), 8);
      StrToInteger(Tmp, Int4, SizeOf(Int4));
      Writeln('INTEGER  : [', Tmp, ']  [', IntegerToStr(Int4, SizeOf(Int4), 8), ']');

      Tmp := DecimalToStr(Dec6, SizeOf(Dec6));
      StrToDecimal(Tmp, Dec6, SizeOf(Dec6));
      Writeln('DECIMAL  : [', Tmp, ']  [', DecimalToStr(Dec6, SizeOf(Dec6)), ']');

      Tmp := DecimalToStr(Dec10, SizeOf(Dec10));
      StrToDecimal(Tmp, Dec10, SizeOf(Dec10));
      Writeln('DECIMAL  : [', Tmp, ']  [', DecimalToStr(Dec10, SizeOf(Dec10)), ']');

      Tmp := NumericToStr(Num1, SizeOf(Num1));
      StrToNumeric(Tmp, Num1, SizeOf(Num1));
      Writeln('NUMERIC  : [', Tmp, ']  [', NumericToStr(Num1, SizeOf(Num1)), ']');

      Tmp := NumericToStr(Num4, SizeOf(Num4));
      StrToNumeric(Tmp, Num4, SizeOf(Num4));
      Writeln('NUMERIC  : [', Tmp, ']  [', NumericToStr(Num4, SizeOf(Num4)), ']');

      Tmp := NumericToStr(Num9, SizeOf(Num9));
      StrToNumeric(Tmp, Num9, SizeOf(Num9));
      Writeln('NUMERIC  : [', Tmp, ']  [', NumericToStr(Num9, SizeOf(Num9)), ']');

      Tmp := BFloatToStr(BFlt4, SizeOf(BFlt4), 8,3);
      StrToBFloat(Tmp, BFlt4, SizeOf(BFlt4));
      Writeln('BFLOAT    : [', Tmp, ']  [', BFloatToStr(BFlt4, SizeOf(BFlt4), 8,2), ']');

      Tmp := BFloatToStr(BFlt8, SizeOf(BFlt8), 8,2);
      StrToBFloat(Tmp, BFlt8, SizeOf(BFlt8));
      Writeln('BFLOAT    : [', Tmp, ']  [', BFloatToStr(BFlt8, SizeOf(BFlt8), 8,2), ']');

      Tmp := DecimalToStr(Mony2, SizeOf(Mony2));
      StrToDecimal(Tmp, Mony2, SizeOf(Mony2));
      Writeln('MONEY    : [', Tmp, ']  [', DecimalToStr(Mony2, SizeOf(Mony2)), ']');

      Tmp := DecimalToStr(Mony10, SizeOf(Mony10));
      StrToDecimal(Tmp, Mony10, SizeOf(Mony10));
      Writeln('MONEY    : [', Tmp, ']  [', DecimalToStr(Mony10, SizeOf(Mony10)), ']');

      Writeln('DATE     : [', DateToStr(Date), ']');

      Writeln('TIME     : [', TimeToStr(Time), ']');

      Tmp := FloatToStr(Flt4, SizeOf(Flt4), 8, 2);
      StrToFloat(Tmp, Flt4, SizeOf(Flt4));
      Writeln('FLOAT    : [', Tmp, ']  [', FloatToStr(Flt4, SizeOf(Flt4), 8, 2), ']');

      Tmp := FloatToStr(Flt8, SizeOf(Flt8), 8, 2);
      StrToFloat(Tmp, Flt8, SizeOf(Flt8));
      Writeln('FLOAT    : [', Tmp, ']  [', FloatToStr(Flt8, SizeOf(Flt8), 8, 2), ']');

      Tmp := LStringToStr(LStr);
      StrToLString(Tmp, LStr);
      Writeln('LSTRING  : [', Tmp, ']  [', LStringToStr(LStr), ']');

      Tmp := ZStringToStr(ZStr);
      StrToZString(Tmp, ZStr);
      Writeln('ZSTRING  : [', Tmp, ']  [', ZStringToStr(ZStr), ']');

      Writeln('LOGICAL  : [', LogicalToStr(Logic1, SizeOf(Logic1)), ']');

      Writeln('LOGICAL  : [', LogicalToStr(Logic2, SizeOf(Logic2)), ']');
    end;

    Writeln;
    Writeln('Press a KEY ...');
    ReadKey;
    F.Get(bStepNext, bNoLock);
  end;

  CheckIO;

  F.Close;
END.
