{$V-,N+,E+,X+}

{ EXAMPLE5.PAS - Demonstrates accessing a file using the key info stored by
                 Btrieve.

  Requires Turbo Pascal version 6.0, 7.0
}

USES
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  {$IFDEF VER70}
  WinDos,
  {$ELSE}
  Dos,
  {$ENDIF}
  BtvConst,
  Btv;


TYPE
  DataRec = record
    Int   : Integer;
    Str   : String[15];
  end;

  ErrorType = Object(ErrorDisplay)
    Function    Display(Error     : Integer;
                        ErrorMsg  : String;
                        OpCode    : Integer;
                        OpCodeMsg : String;
                        FileName  : PathStr
                        ): ErrorAction;             Virtual;
  end;


VAR
  F   : BtrieveFile;
  Buff: DataRec;
  Seg0: Integer;
  Seg1: String[15];
  ErrHandler  : ErrorHandler;
  ErrDisplay  : ErrorType;


{ Heres our error display object  }
Function ErrorType.Display(Error     : Integer;
                           ErrorMsg  : String;
                           OpCode    : Integer;
                           OpCodeMsg : String;
                           FileName  : PathStr
                           ): ErrorAction;
  begin
    ClrScr;
    Writeln('Btrieve IO error for ' + FileName);
    Writeln(Error,  ' - ', ErrorMsg);
    Writeln(Opcode, ' - ', OpCodeMsg);
    Writeln('Press any key ....');
    ReadKey;
    ClrScr;
    Display := erAbort;
  end;


BEGIN
  { first make a error display }
  ErrDisplay.Init;
  { make an error handler, it needs a display object  }
  ErrHandler.Init(@ErrDisplay);

  ClrScr;
  Writeln('Creating a file called TEST5.DAT');

  { init the file passing it the error handler and
    address of our data buffer
  }
  F.Init('TEST5.DAT', @ErrHandler, @Buff, SizeOf(Buff));

  { the first thing to do is define the key  }
  { key is an integer }
  F.AddKeySegment(1, 2, bExtended + bSegmented, bInteger, 0, bNormal);
  { key is a Pascal type String }
  { notice there is no justification, when we reopen the file we
    wouldn't have that info, since that is not a Btrieve function
  }
  F.AddKeySegment(3, 16, bExtended, bLstring, 0, bNormal);
  { create the file }
  F.Create(bNormal, SizeOf(Buff), 1024, 0, bNormal);
  F.Open(bNormal, '');
  { add some records }
  F.ClearBuffer;
  Buff.Int := 0;
  Buff.Str := 'ZERO';
  F.Insert;
  Buff.Int := 1;
  Buff.Str := 'ONE';
  F.Insert;
  Buff.Int := 2;
  Buff.Str := 'TWO';
  F.Insert;
  Buff.Int := 3;
  Buff.Str := 'THREE';
  F.Insert;
  Buff.Int := 4;
  Buff.Str := 'FOUR';
  F.Insert;
  Buff.Int := 5;
  Buff.Str := 'FIVE';
  F.Insert;
  Buff.Int := 6;
  Buff.Str := 'SIX';
  F.Insert;
  { close the file and dispose the object }
  F.Close;
  F.Done;

  { reopen the file }
  F.Init('TEST5.DAT', @ErrHandler, @Buff, SizeOf(Buff));
  F.Open(bNormal, '');
  { read and display a couple records }
  F.ClearBuffer;
  Seg0 := 3;
  Seg1 := 'THREE';
  { read by first key (Only key in this case)}
  F.SetKeyPath(0);
  { make sure key segments are in correct order }
  F.MakeKey(@Seg0, @Seg1, nil,nil,nil,nil);
  F.Get(bGetEqual, bNoLock);
  Writeln('READING : ', Seg0, ' ', Seg1);
  Writeln('FOUND   : ', Buff.Int, ' ', Buff.Str);
  Writeln;

  Seg0 := 6;
  Seg1 := 'SIX';
  F.MakeKey(@Seg0, @Seg1, nil,nil,nil,nil);
  F.Get(bGetEqual, bNoLock);
  Writeln('READING : ', Seg0, ' ', Seg1);
  Writeln('FOUND   : ', Buff.Int, ' ', Buff.Str);

  F.Close;
  F.Done;
END.

