{$X+}
{$V-}
{ OWNER.PAS - demonstrate file creation with owner name (password)
  Requires Turbo Pascal version 6.0, 7.0
}

Uses
  {$IFDEF WINDOWS}
  WinCrt,
  {$ELSE}
  Crt,
  {$ENDIF}
  {$IFDEF VER70}
  WinDos,
  {$ELSE}
  Dos,
  {$ENDIF}
  BtvConst,
  Btv;


type
  ErrorType = Object(ErrorDisplay)
    Function    Display(Error     : Integer;
                        ErrorMsg  : String;
                        OpCode    : Integer;
                        OpCodeMsg : String;
                        FileName  : PathStr
                        ): ErrorAction;             Virtual;
  end;


var
  F           : BtrieveFile;
  ErrHandler  : ErrorHandler;
  ErrDisplay  : ErrorType;
  Buff        : Longint;

{ Heres our error display object  }
Function ErrorType.Display(Error     : Integer;
                           ErrorMsg  : String;
                           OpCode    : Integer;
                           OpCodeMsg : String;
                           FileName  : PathStr
                           ): ErrorAction;
  begin
    ClrScr;
    Writeln('Btrieve IO error for ' + FileName);
    Writeln(Error,  ' - ', ErrorMsg);
    Writeln(Opcode, ' - ', OpCodeMsg);
    Writeln('Press any key ....');
    ReadKey;
    Display := erDone;  { just let the program continue }
    ClrScr;
  end;

begin
  ClrScr;
  CheckForBtrieve;

  { first make a error display }
  ErrDisplay.Init;
  { make an error handler, it needs a display object  }
  ErrHandler.Init(@ErrDisplay);

  Writeln('Creating a file called PASSWORD.DAT');

  { init the file passing it the error handler and
    address of our data buffer
  }
  F.Init('PASSWORD.DAT', @ErrHandler, @Buff, SizeOf(Buff));
  { add a simple key }
  F.AddKeySegment(1, 2, bExtended, bInteger, 0, 0);
  { create the file }
  F.Create(bNormal, SizeOf(Buff), 1024, 0, bNormal);
  { open and assign an owner then close }
  F.Open(bNormal, '');
  F.SetOwner('DEMO', bNoAccess);
  F.Close;

  { now open the file with the wrong owner name }
  F.Open(bNormal, 'XXXX');
  F.Close;

  { now open the file with the right owner name and
    clear the owner name
  }
  F.Open(bNormal, 'DEMO');
  F.ClearOwner;
  F.Close;

  { now open the file with NO owner name }
  F.Open(bNormal, '');
  F.Close;
end.
