UNIT NWTOOLS;

{ Tool libary for nw311.pas - a unit to capture a printer with NW311,
  without using port's

  Autor : Michael Fiel

  Use it if you like it, but usage at your own risk.
  please read nw311.txt.

}

INTERFACE

{---------------------- OutPut ----------------------------------------------}

  procedure OwnError(S:String);
    { Output of String <S> in TurboVision with MsgBox else writeln }

{---------------------- Strings ---------------------------------------------}

  function Trim(Line:String) : String;
    { Pads a String from End }
  function MkStr(Len,Val:Byte): String;
    { returns a String of length <len> and fills it with <val> }
  function LenStr(S:String;len:Integer) : String;
    { returns string S with length(len) }

{----------------------- Memory ---------------------------------------------}

  Procedure move16 (var source,dest;count:word);
    { 16 BIT MOVE }
  Procedure fillchar16 (var dest;count:word;value:byte);
    { 16 BIT FILLCHAR }

{$IFDEF DPMI}

  function  SIToReal (var RealSeg, RealOfs: word;var ProtSrc; Size: word) :pointer;
    { allocate size bytes in realmode memmory, copy <ProtSrc> to this memory
       and set segment and offset in <RealSeg>,<RealOfs>.
       returns a pointer to this memory }
  procedure SIToProt (var ProtDst; ProtPtr: pointer; Size: word);
    { Copy Size bytes from <ProtPtr> (= pointer returned by SIToReal) to
       <ProtDst> and free <ProtPtr> }
  procedure SIFree (ProtPtr: pointer);
    { free <ProtPtr> ---> Realmode memmory only ! }

{$ENDIF}

IMPLEMENTATION
  USES

    {$IFDEF DPMI}
    EzDPMI,       { EZDPMI is Copyright (c) 1993 by  Julian M. Bucknall }
    {$ENDIF}
    App,MsgBox;

  procedure OwnError(S:String);
    { Output of String <S> in TurboVision with MsgBox else writeln }
    begin
      if Application<>NIL then
        MessageBox(S,nil,mfError + mfOkButton)
      else
        WriteLn(S);
    end;

  function Trim(Line:String) : String;
    { Pads a String from End }
    var
      Len: Byte ABSOLUTE Line;
    begin
      while (Len > 0) AND (Line[Len] = ' ') DO Dec(Len);
      Trim := Line;
    end ;

  function MkStr (Len,Val:Byte): String;
    { returns a String of length <len> and fills it with <val> }
    var
      S:String;
    begin
       S[0]:=chr(Len);
       fillchar16 (S[1],Len,Val);
       MkStr:=s;
    end;

  function LenStr(S:String;len:Integer) : String;
    { returns string S with length(len) }
    var
      l:Integer;
    begin
      l:=length(S);
      if (l>len) then S[0]:=char(len) else if (l<len) then S:=S+mkstr(len-l,32);
      LenStr:=S;
    end;


  Procedure move16 (var source,dest;count:word);

    { 16 bit move command,
      Thanks to Andreas Stiller c't 6/93 page 155 }

    begin
    asm
       push    ds
       lds     si,source
       les     di,dest
       mov     cx,count
       cld
       shr     cx,1
       rep     movsw
       jnc     @exit
       movsb
    @exit:
       pop     ds
       end;
    end;

  Procedure fillchar16 (var dest;count:word;value:byte);

    { 16 bit fillchar command,
      Thanks to Andreas Stiller c't 6/93 page 155 }

    begin
    asm
       les     di,dest
       mov     cx,count
       mov     al,value
       mov     ah,al
       cld
       shr     cx,1
       rep     stosw
       jnc     @exit
       stosb
    @exit:
       end;
    end;

{$IFDEF DPMI}


  function SIToReal(var RealSeg,RealOfs:Word;var ProtSrc;Size:Word) : Pointer;
    { allocate size bytes in realmode memmory, copy <ProtSrc> to this memory
       and set segment and offset in <RealSeg>,<RealOfs>.
       returns a pointer to this memory }
    type
      PtrRec = record Ofs, Seg : Word; end;

    var
       RPtr, PPtr: Pointer;
    begin
       SIToReal := NIL;
       if (Size < 1) then Size := 1;		     { minimim allocate 1 }
       if (DosGetMem (RPtr, PPtr, Size)) then begin  { unit EZDPMI }
	  RealSeg := PtrRec(RPtr).Seg;
	  RealOfs := PtrRec(RPtr).Ofs;
	  move16 (ProtSrc, PPtr^, Size);
	  SIToReal := PPtr;
       end else
	  OwnError('SICopyToRealMem(): error allocating memory!');
    end;

  procedure SIToProt (var ProtDst;ProtPtr:Pointer;Size:Word);
    { Copy <Size> bytes from <ProtPtr> (= pointer returned by SIToReal) to
       <ProtDst> and free <ProtPtr> }
    begin
       if (ProtPtr = NIL) then exit;
       if (Size > 0) then move16 (ProtPtr^, ProtDst, Size);
       SIFree(ProtPtr);
    end;

  procedure SIFree (ProtPtr: pointer);
    { deallocates memory used by <ProtPtr> --> Realmode memory only }
    begin
      if (ProtPtr <> NIL) then
         if (not DosFreeMem (ProtPtr)) then        { free size 0 also }
            OwnError('DosFreeMem() sifree: not freed ...');
    end;


{$ENDIF}

END.