{ ========================================================================== }
{ QWIK71A.PAS - Unit for direct/virtual screen writing    ver 7.1a, 09-23-93 }
{                                                                            }
{ For documentation on this file see QWIK71A.DOC and QWIKREF.DOC.            }
{ Only 48 bytes of global data is used.                                      }
{   Copyright (c) 1986,1993 James H. LeMay, Eagle Performance Software       }
{ ========================================================================== }

{ Note: you MUST use $A- for this unit. }
{ $A-,B-,D+,E-,F-,G-,I-,L+,N-,O-,P-,Q-,R-,S-,T-,V-,X-}
{$A-,B-,D-,E-,F-,G-,I-,L-,N-,O-,P-,Q-,S-,T-,V-,X-}

UNIT Qwik;

INTERFACE

const
  SystemID:   byte = 0;       { Equipment ID.  See QWIKREF.DOC }
  SubModelID: byte = 0;       { Equipment ID.  See QWIKREF.DOC }

var
  VideoMode:   byte absolute $0040:$0049; { Video mode: Mono=7, Color=0-3 }
  VideoPage:   byte absolute $0040:$0062; { Video page number }
  EgaRows:     byte absolute $0040:$0084; { Rows on screen (0-based) }
  EgaFontSize: word absolute $0040:$0085; { Character cell height (1-based) }
  EgaInfo:     byte absolute $0040:$0087; { EGA info.  See QWIKREF.DOC }
  CrtColumns:  word absolute $0040:$004A; { Number of CRT columns (1-based) }

  CpuID,                      { Model number of Intel CPU }
  QvideoMode:        byte;    { Video mode detected by QWIK }

  { Keep the following seven variables in order for save pointers! }
  CrtRows,                    { Global variable of Rows/EgaRows (1-based!)}
  CrtCols:           byte;    { Global variable of CrtColumns (1-based) }
  CrtSize:           word;    { Essentially size of CRT video buffer in bytes }
  QEosOfs,                    { End Of String offset after QWIK writing }
  QScrOfs,                    { Screen offset  for QWIK writing, normally = 0 }
  QScrSeg:           word;    { Screen segment for QWIK writing }
  Qsnow:             boolean; { Wait-for-retrace (snow) while QWIK writing }

  QvideoPage,                 { Video page to which QWIK is writing }
  MaxPage:           byte;    { Maximum possible page }
  Page0seg:          word;    { Segment for page 0 for video card/buffer }
  CardSeg:           word;    { Segment for page 0 for video card }
  CardSnow,                   { Wait-for-retrace (snow) for video card }
  HavePS2,                    { Using some type of IBM PS/2 equip }
  Have3270:          boolean; { Using IBM 3270 PC workstation hard/software }
  EgaSwitches,                { EGA card and monitor setup }
  ActiveDispDev,              { Active Display Device }
  ActiveDispDev3270,          { Active Display Device for IBM 3270 PC }
  AltDispDev:        byte;    { Alternate Display Device }
  AltDispDevPCC:     word;    { Alt Display Device for PC Convertible }
  HercModel:         byte;    { Model of Hercules card. }
  ScrollAttr:        integer; { Attribute used to clear row in QEosLn }

type
  VScrRecType =
    record
      Vrows,                  { Equivalent to CrtRows }
      Vcols:       byte;      { Equivalent to CrtCols }
      Vsize:       word;      { Equivalent to CrtSize }
      VEosOfs:     word;      { Equivalent to QEosOfs }
      VScrPtr:     pointer;   { Equivalent to QScrPtr }
      Vsnow:       boolean;   { Equivalent to Qsnow   }
    end;

var
  QScrRec:  VScrRecType absolute CrtRows;
  QScrPtr:  pointer     absolute QScrOfs;

const
  { Constants assigned by IBM:      }   { Arbitrarily assigned constants: }
  NoDisplay = $00;   VgaMono   = $07;   NoHerc       = 0;
  MdaMono   = $01;   VgaColor  = $08;   HgcMono      = 1;
  CgaColor  = $02;   DCC9      = $09;   HgcPlus      = 2;
  DCC3      = $03;   DCC10     = $0A;   HercInColor  = 3;
  EgaColor  = $04;   McgaMono  = $0B;
  EgaMono   = $05;   McgaColor = $0C;
  PgcColor  = $06;   Unknown   = $FF;

  Cpu8086    = $00;
  Cpu80186   = $01;
  Cpu80286   = $02;
  Cpu80386   = $03;
  Cpu80486   = $04;
  CpuPentium = $05;

  { The following duplicates the CRT unit text color constants which }
  { will automatically be used if the CRT unit is not used. }
  Black        = $00;       DarkGray     = $08;
  Blue         = $01;       LightBlue    = $09;
  Green        = $02;       LightGreen   = $0A;
  Cyan         = $03;       LightCyan    = $0B;
  Red          = $04;       LightRed     = $0C;
  Magenta      = $05;       LightMagenta = $0D;
  Brown        = $06;       Yellow       = $0E;
  LightGray    = $07;       White        = $0F;
  Blink        = $80;

  { These are convenient background constants: }
  BlackBG      = $00;   { Only needed for source code clarity. }
  BlueBG       = $10;
  GreenBG      = $20;
  CyanBG       = $30;
  RedBG        = $40;
  MagentaBG    = $50;
  BrownBG      = $60;
  LightGrayBG  = $70;
  SameAttr     =  -1;   { Suppresses attribute changes to the screen }

  { The following are constants used in SetCursor and ModCursor }
  CursorOn     = $0000; { Turns cursor on  with same shape }
  CursorOff    = $2000; { Turns cursor off with same shape }
  CursorBlink  = $6000; { Creates erratic blinking for MDA/CGA }

  InMultiTask:  boolean = false;  { True if SetMultiTask detects MT environ. }
  QscrollBlank: boolean = true;   { True to clear blank line after scroll. }
  SegF000:      word    = $F000;  { For selector use for DOS/DPMI platforms }

var
  { These Cursor modes are set by Qinit as detected for the video card: }
  CursorInitial,              { Cursor detected at startup }
  CursorUnderline,            { Standard underline cursor }
  CursorHalfBlock,            { Usually used for Insert editing }
  CursorBlock:       word;    { For those who have to squint }

procedure Qinit;

procedure QwriteV    (Row,Col: byte; Attr: integer; aStr: string);
procedure QwriteVC   (RowT,RowB,Col: byte; Attr: integer; aStr: string);
procedure QwriteC    (Row,ColL,ColR: byte; Attr: integer; aStr: string);
procedure QwriteSub  (Row,Col: byte; Attr: integer; Count: word; var Chars);
procedure QwriteSubC (Row,ColL,ColR: byte; Attr: integer; Count: word;
                      var Chars);
procedure QwriteEos    (Attr: integer; aStr: string);
procedure QwriteEosV   (Attr: integer; aStr: string);
procedure QwriteEosSub (Attr: integer; Count: word; var Chars);

procedure Qfill  (Row,Col,Rows,Cols: byte; Attr: integer; Ch: char);
procedure Qattr  (Row,Col,Rows,Cols: byte; Attr: integer);
procedure QfillC (Row,ColL,ColR,Rows,Cols: byte; Attr: integer; Ch: char);
procedure QattrC (Row,ColL,ColR,Rows,Cols: byte; Attr: integer);
procedure QfillEos (Rows,Cols: byte; Attr: integer; Ch: char);
procedure QattrEos (Rows,Cols: byte; Attr: integer);

procedure QstoreToMem (Row,Col,Rows,Cols: byte; var Dest);
procedure QstoreToScr (Row,Col,Rows,Cols: byte; var Source);
procedure QScrToVscr  (Row,Col,Rows,Cols,Vrow,Vcol,Vwidth: byte; var VscrPtr);
procedure QVscrToScr  (Row,Col,Rows,Cols,Vrow,Vcol,Vwidth: byte; var VscrPtr);

procedure QreadStr  (Row,Col,Cols: byte; var aStr: string);
function  QreadChar (Row,Col: byte): char;
function  QreadAttr (Row,Col: byte): byte;

procedure QscrollUp   (Row,Col,Rows,Cols: byte; BlankAttr: integer);
procedure QscrollDown (Row,Col,Rows,Cols: byte; BlankAttr: integer);

procedure QviewPage  (PageNum: byte);
procedure QwritePage (PageNum: byte);

function  GetCursor: word;
Inline(
  $8E/$06/>SEG0040/      { mov   es,[>Seg0040] ; Get video segment}
  $26/                   { es:                 ; Seg override}
  $A1/$60/$00);          { mov   ax,[$0060]    ; Get current cursor word}

procedure SetCursor (Cursor: word);
procedure ModCursor (Bits13_14: word);
procedure GotoRC (Row,Col: byte);
function  WhereR: byte;
function  WhereC: byte;

procedure GotoEos;
function  EosR: byte;
function  EosC: byte;
procedure EosToRC    (Row,Col: byte);
procedure EosToRCrel (Row,Col: integer);
procedure EosToCursor;
procedure EosLn;
procedure QEosLn;

procedure GetSubModelID;  { Read docs before using. }
procedure SetMultiTask;
procedure Qwrite     (Row,Col: byte; Attr: integer; aStr: string);


IMPLEMENTATION

{$ifdef DPMI } { Needed for Qinit }
uses WinAPI;
{$endif }

const
  TestedHerc: boolean = false;  { True if Hercules test has been done. }

{$ifdef DPMI } { Needed for Qinit }
{$L qinit.obp}
procedure __F000H; far;   external 'KERNEL' index 194;  {173 }
{$else }
{$L qinit.obj}
{$endif }
procedure Qinit;          external;

{$L QwDsp.obj    }
{$L Qwrite.obj   }
{$L QwriteC.obj  }
{$L QwSub.obj    }
{$L QwSubC.obj   }
{$L QwEos.obj    }
{$L QwEosSub.obj }
procedure QwDsp1;         external;  { local subroutine }
procedure QwDsp2;         external;  { local subroutine }
procedure Qwrite;         external;
procedure QwriteV;        external;
procedure QwriteC;        external;
procedure QwriteSub;      external;
procedure QwriteSubC;     external;
procedure QwriteEos;      external;
procedure QwriteEosSub;   external;

{$L QwDspV.obj   }
{$L QwriteV.obj  }
{$L QwriteVC.obj }
{$L QwEosV.obj   }
procedure QwDspV1;        external;  { local subroutine }
procedure QwDspV2;        external;  { local subroutine }
procedure QwriteVC;       external;
procedure QwriteEosV;     external;

{$L QfDsp.obj    }
{$L Qfill.obj    }
{$L QfillC.obj   }
{$L QfillEos.obj }
{$L Qattr.obj    }
{$L QattrC.obj   }
{$L QattrEos.obj }
procedure Qfill;          external;
procedure Qattr;          external;
procedure QfillC;         external;
procedure QattrC;         external;
procedure QfillEos;       external;
procedure QattrEos;       external;
procedure QfDsp;          external;  { local for Qattrs / Qfills }
procedure QfDsp2;         external;  { local for QattrEos.obj / QfillEos.obj }
procedure QfDsp3;         external;  { local for Qscroll.obj only }

{$L Qstore.obj }
{$L QstoreV.obj }
procedure QstoreToMem;    external;
procedure QstoreToScr;    external;
procedure SetRegs;        external;  { local for QstoreV.obj }
procedure MemDsp;         external;  { local for QstoreV.obj }
procedure ScrDsp;         external;  { local for QstoreV.obj }
procedure QScrToVscr;     external;
procedure QVscrToScr;     external;

{$L Qread.obj    }
{$L QreadStr.obj }
{$L QreadChr.obj }
procedure Qread;          external;  { local for QreadStr.obj / QreadChr.obj }
procedure QreadStr;       external;
function  QreadChar;      external;
function  QreadAttr;      external;

{$L qscrolls.obj}
procedure QscrollUp;      external;
procedure QscrollDown;    external;

{$L qpages.obj}
procedure QviewPage;      external;
procedure QwritePage;     external;

{$L Cursor.obj }
{$L Where.obj  }
{$L GotoRC.obj   }
procedure SetCursor;      external;
procedure ModCursor;      external;
procedure GotoRC;         external;
function  WhereR;         external;
function  WhereC;         external;

{$L EosRC.obj    }
{$L GotoEos.obj  }
{$L EosR.obj     }
{$L EosC.obj     }
{$L EosToRC.obj  }
{$L EosToRCr.obj }
{$L EosToCur.obj }
{$L EosLn.obj}
procedure EosRC;          external;   { local subroutine only }
procedure GotoEos;        external;
function  EosR;           external;
function  EosC;           external;
procedure EosToRC;        external;
procedure EosToRCrel;     external;
procedure EosToCursor;    external;
procedure EosLn;          external;

{$L QEosLn.obj}
procedure QEosLn;         external;

{$L CpuIdent.obj}
procedure GetCpuID;       external;  { Near }

{$L GetSubID.obj}
procedure GetSubModelID;  external;  { Read docs before using! }

{$L SetMulti.obj }
procedure SetMultiTask;   external;


BEGIN
  Qinit;
  GetCpuID;           { Required for Qscroll* }
END.
