{***************************************************************************}
{** Program : BLIST.PAS                                                   **}
{***************************************************************************}
{** Version : 1.0             ** Started :           ** Ended :           **}
{***************************************************************************}
{******************************** Description ******************************}
{***************************************************************************}
{** BLIST will simply list all the objects in the bindery of a specified  **}
{** type.                                                                 **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}
{******************************** Information ******************************}
{***************************************************************************}
{** USAGE :                                                               **}
{**                                                                       **}
{**   BLIST SearchSpec BinderyObjectType                                  **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}

program BLIST;

USES

  {$IFDEF WINDOWS}
  wincrt,
  {$ENDIF}
  nwvar,
  nwerror,
  nwmisc,
  objects;

VAR

  MiscFunc    : MiscFuncOBJ;
  CommandLine : STRING;
  BObjectType : OT_BinderyType;
  BSearchSpec : TObjectName;

procedure GetCommandLine;

BEGIN

  if paramcount < 2 then
    begin

      writeln;
      writeln ('You must supply two parameters :');
      writeln;
      writeln ('BINDLIST <searchspec> <ObjectType>');
      writeln;
      writeln ('Examples : Users        = 1');
      writeln ('         : Groups       = 2');
      writeln ('         : PrintQueues  = 3');
      writeln ('         : FileServers  = 4');
      writeln ('         : PrintServers = 7');

      halt;

    end;

  BSearchSpec := MiscFunc.UppercaseNW (PARAMSTR (1));
  BObjectType := MiscFunc.StrToInt (paramstr (2));

END; {GetCommandLine}

{***}

procedure DisplayBinderyObjects;

var

  AllObjects  : PStringCollection;
  NoOfObjects : word;
  Count       : word;

BEGIN

  AllObjects := new (PStringCollection, Init (10, 5));
  MiscFunc.GetAllObjects (BSearchSpec, BObjectType, AllObjects, NoOfObjects);
  for Count := 0 to pred (NoOfObjects) do
    writeln (pstring (AllObjects^.At (Count))^);

  dispose (AllObjects, Done);

END; {DisplayBinderyObjects}

{***}

BEGIN

  MiscFunc.Init (true);
  GetCommandLine;
  DisplayBinderyObjects;
  MiscFunc.Done;

END.


