{***************************************************************************}
{** Program : SETLOGIN.PAS                                                **}
{***************************************************************************}
{** Version : 1.0             ** Started : 19/12/90  ** Ended : 19/12/90  **}
{***************************************************************************}
{******************************** Description ******************************}
{***************************************************************************}
{** SETLOGIN allows the SUPERVISOR or a console operator to enable or     **}
{** disable login on a file server.  The user must be sitting on the file **}
{** server where login is to be enabled or disabled.                      **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}
{******************************** Information ******************************}
{***************************************************************************}
{** To enable login use  : SETLOGIN TRUE                                  **}
{** To disable login     : SETLOGIN FALSE                                 **}
{**                                                                       **}
{** The user will be informed if the operation was sucessful or not.      **}
{**                                                                       **}
{***************************************************************************}

program SETLOGIN;

USES

  nwvar, nwerror, nwfsserv;

CONST

  ProgramName = 'SETLOGIN.EXE';
  Version     = '1.0';
  Description = 'Allows SUPERVISOR or CONSOLE operator to enable / disable login';

VAR

  FileServer  : ^FileServerOBJ;
  CommandLine : STRING;
  OK          : BOOLEAN;

{******}

FUNCTION GetCommandLine : BOOLEAN;

BEGIN

  OK := TRUE;
  IF (PARAMCOUNT < 1) OR (FileServer^.CheckConsolePrivileges <> Successful) THEN
    OK := FALSE
  ELSE
    BEGIN

      CommandLine := FileServer^.UppercaseNW (PARAMSTR (1) );
      IF (CommandLine <> 'TRUE') AND (CommandLine <> 'FALSE') THEN
        OK := FALSE;

    END;

  IF NOT OK THEN
    BEGIN

      WRITELN;
      WRITELN ('Program : ', ProgramName);
      WRITELN ('Version : ', Version);
      WRITELN ('Description : ', Description);
      WRITELN;
      WRITELN;
      WRITELN ('USAGE : ');
      WRITELN;
      WRITELN ('SETLOGIN [TRUE] [FALSE]');
      WRITELN;
      WRITELN ('[TRUE]  allow users to login');
      WRITELN ('[FALSE] do not allow users to login');
      WRITELN;
      WRITELN ('You must be SUPERVISOR or a CONSOLE operator!');
      HALT (1);

    END;

  IF CommandLine = 'TRUE' THEN
    GetCommandLine := TRUE
  ELSE
    GetCommandLine := FALSE;

END; {procedure GetCommandLine}

{******}

BEGIN

  NEW (FileServer, Init (true));

  IF GetCommandLine THEN
    WRITELN ('Enabling login : ', FileServer^.EnableFileServerLogin = 0)
  ELSE
    WRITELN ('Disabling login : ', FileServer^.DisableFileServerLogin = 0);

  DISPOSE (FileServer, Done);

END.
