{***************************************************************************}
{** Program : WAMI.PAS                                                    **}
{***************************************************************************}
{** Version : 1.0             ** Started :           ** Ended :           **}
{***************************************************************************}
{******************************** Description ******************************}
{***************************************************************************}
{** WAMI is a simple replacement for WHOAMI.  It will not display a time  **}
{** unless you incorporate your own formatting strings.                   **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}
{******************************** Information ******************************}
{***************************************************************************}
{** USAGE :                                                               **}
{**                                                                       **}
{**   WAMI                                                                **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}

program WAMI;

{ $DEFINE OPRO} {define this to use OPRO date/time formatting routines}

USES

  {$IFDEF WINDOWS}
  wincrt,
  {$ENDIF}
  {$IFDEF OPRO}
  opdate,
  {$ENDIF}
  nwvar,
  nwerror,
  nwconn,
  nwfsserv,
  nwwrkstn;

VAR

  Count       : BYTE;
  DefConnID   : WORD;
  Connection  : ConnectionOBJ;
  FileServer  : FileServerOBJ;
  WorkStation : WorkStationOBJ;


procedure DisplayInfo (ConnectionID : WORD);

VAR

  ServerName        : TObjectName;
  ConnectionNumber  : WORD;
  TempConnectionID  : WORD;
  NetworkError      : WORD;
  CompanyName       : TString80;
  Revision          : TString80;
  RevisionDate      : TString24;
  Copyright         : TString255;
  LoginTime         : TByte7Array;
  ObjectName        : TObjectName;
  ObjectID          : OT_BinderyID;
  ObjectType        : OT_BinderyType;

BEGIN

  WorkStation.SetPreferredConnectionID (ConnectionID);
  WorkStation.GetFileServerName (ConnectionID, ServerName);
  ConnectionNumber := Connection.GetConnectionNumber;
  NetworkError := FileServer.GetFileServerDescriptionStrings (CompanyName, Revision,
                                                              RevisionDate, Copyright);

  NetworkError := FileServer.GetFileServerDateAndTime (LoginTime);
  WITH Connection DO
    NetworkError := GetConnectionInformation (ConnectionNumber, ObjectName, ObjectType,
                                              ObjectID, LoginTime);

  WRITELN;
  IF NetworkError = Successful THEN
    WRITELN ('You are user ', ObjectName, ' attached to server ', ServerName,
             ', connection ', ConnectionNumber, '.')
  ELSE
    WRITELN ('You are attached to server ', ServerName, ', connection ',
             ConnectionNumber, ', but not logged in.');

  WRITELN ('Server ', ServerName, ' is running ', Revision, '.');

  {$IFDEF OPRO}
  write ('Login time : ');
  {$ELSE}
  WRITELN ('Login time : N/A'); {PUT YOUR OWN TIME FORMATTING ROUTINES HERE}
                                {LOGINTIME IS A 7 BYTE ARRAY}
  {$ENDIF}

  {$IFDEF OPRO}
  write (DMYtoDateString ('wwwwwwwww nnnnnnnnn dd, yyyy', LoginTime [2], LoginTime [1], LoginTime [0]));
  writeln (' ':2, TimeToAmPmString ('hh:mm te', HMStoTime (LoginTime [3], LoginTime [4], LoginTime [5])));
  {$ENDIF}

END;

procedure Init;

BEGIN

  Connection.Init (true);
  FileServer.Init (true);
  WorkStation.Init (true);

END;

procedure Done;

BEGIN

  Connection.Done;
  FileServer.Done;
  WorkStation.Done;

END;

BEGIN

  Init;
  DefConnID := WorkStation.GetDefaultConnectionID;
  WRITELN;
  FOR Count := 1 TO 8 DO
    IF WorkStation.IsConnectionIDInUse (Count) = 0 THEN
      DisplayInfo (Count);

  WorkStation.SetPreferredConnectionID (DefConnID);
  Done;

END.