{***************************************************************************}
{** Program : CAPQUEUE                                                    **}
{***************************************************************************}
{** Version : 1.0             ** Started :           ** Ended :           **}
{***************************************************************************}
{******************************** Description ******************************}
{***************************************************************************}
{** Program to show direct printing to a Netware print queue.             **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}
{******************************** Information ******************************}
{***************************************************************************}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}

{$X+}

program CAPQUEUE;

uses

  nwvar,
  nwbindry,
  nwqueue,
  nwmisc,
  objects
  ;

var

  MNW    : MiscFuncOBJ;
  QS     : QueueOBJ;
  BS     : BinderyOBJ;
  JS     : JobStruct286;
  FileH  : FileOfText;
  Queues : PStringCollection;
  NoOfQs : word;
  QueueID: OT_binderyID;

begin

  QS.Init (true);
  BS.Init (true);
  MNW.Init (true);

  Queues := new (PStringCollection, Init (5, 10));
  MNW.GetAllObjects ('*', OT_PrintQueue, Queues, NoOfQs);
  BS.GetBinderyObjectID (PString (Queues^.At (0))^, OT_PrintQueue, QueueID);
  with JS do
    begin

      fillchar (JS, sizeof (JS), 0);
      TargetServerObjectID := -1;
      fillchar (TargetExecutionTime, 6, 255);
      JobType := 0;
      JobControlFlags := $8;

    end;

  QS.CreateQueueJobAndFileText (QueueID, JS, FileH);
  writeln (FileH, 'THIS IS A TEST PRINT OUT DIRECT TO A FILE IN A PRINT QUEUE.');
  writeln (FileH, 'CHECK OUT CAPQUEUE.PAS');
  QS.CloseFileAndStartQueueJobText (QueueID, JS.JobNumber, FileH);

  QS.Done;
  BS.Done;
  MNW.Done;

end.

