{***************************************************************************}
{** Program : CPASS                                                       **}
{***************************************************************************}
{** Version : 1.0             ** Started :           ** Ended :   /  /    **}
{***************************************************************************}
{******************************** Description ******************************}
{***************************************************************************}
{** Program which will allow a user to change their password from the     **}
{** command line.                                                         **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}
{******************************** Information ******************************}
{***************************************************************************}
{** USAGE : CPASS oldpassword newpassword                                 **}
{**                                                                       **}
{** This program does not do much error checking.  It is meant only as a  **}
{** guide to using TPAPI.                                                 **}
{**                                                                       **}
{***************************************************************************}

program CPASS;

USES

  NWVAR,
  NWERROR,
  NWBINDRY,
  NWMISC;

CONST

  ProgramName = 'CPASS.EXE';
  Version     = '1.0';
  Description = 'Allows a user to change their password';

VAR

  BinderyServices : pBinderyOBJ;
  MiscFunc        : pMiscFuncOBJ;
  OldPassword,
  NewPassword     : TPassword;

procedure Initialise;

BEGIN

  BinderyServices := new (pBinderyOBJ, Init (true));
  MiscFunc := new (pMiscFuncOBJ, Init (true));
  IF PARAMCOUNT < 2 THEN
    BEGIN

      WRITELN;
      WRITELN ('Program : ', ProgramName);
      WRITELN ('Version : ', Version);
      WRITELN ('Description : ', Description);
      WRITELN;
      WRITELN;
      WRITELN ('USAGE : ');
      WRITELN;
      WRITELN ('CPASS oldpassword newpassword');
      WRITELN;
      HALT (1);

    END;

  OldPassword := BinderyServices^.UppercaseNW (PARAMSTR (1) );
  NewPassword := BinderyServices^.UppercaseNW (PARAMSTR (2) );

END; {procedure Initialise}

{******}

procedure ChangePassword;

VAR

  NetError : WORD;
  ObjectName : TObjectName;
  ObjectType : OT_BinderyType;
  ObjectID   : OT_BinderyID;

BEGIN

  WITH MiscFunc^ DO
    NetError := GetObjectNameID (GetDefaultFileServerName, ObjectName, ObjectType, ObjectID);
  NetError := BinderyServices^.ChangeBinderyObjectPassword (ObjectName, ObjectType,
              OldPassword, NewPassword);

  WRITELN (GetBinderyServicesError (NetError) );

END; {procedure ChangePassword}

{******}

BEGIN

  Initialise;
  ChangePassword;
  DISPOSE (BinderyServices, Done);
  DISPOSE (MiscFunc, Done);

END.

