{***************************************************************************}
{** Program : DLOGOUT                                                     **}
{***************************************************************************}
{** Version : 1.0             ** Started :           ** Ended :   /  /    **}
{***************************************************************************}
{******************************** Description ******************************}
{***************************************************************************}
{** Program which will logout of all servers accept the default.          **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}
{******************************** Information ******************************}
{***************************************************************************}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}

program DLOGOUT;

USES

  NWVAR,
  NWWRKSTN,
  NWMISC;

CONST

  ProgramName = 'DLOGOUT.EXE';
  Version     = '1.0';
  Description = 'Logs out of all servers except the default';

VAR

  PrimaryConnectionID   : WORD;
  WorkStatServ          : WorkStationOBJ;
  MiscServ              : MiscFuncOBJ;

procedure Initialise;

BEGIN

  WorkStatServ.Init (true);
  MiscServ.Init (true);
  PrimaryConnectionID := WorkStatServ.GetPrimaryConnectionID;
  WRITELN;
  WRITELN ('Program : ', ProgramName);
  WRITELN ('Version : ', Version);
  WRITELN ('Description : ', Description);
  WRITELN;

END; {procedure Initialise}

{**********}

procedure LogoutServers;

VAR

  TempCount : WORD;

BEGIN

  FOR TempCount := 1 TO MaxSlotsInShell DO
    IF TempCount <> PrimaryConnectionID THEN
      BEGIN

        WorkStatServ.SetPreferredConnectionID (TempCount);
        WorkStatServ.EndOfJob ($FFFF);
        WorkStatServ.SetPreferredConnectionID (PrimaryConnectionID);
        MiscServ.LogoutAndDetachFromFileServer ('', TempCount);

      END;

END; {procedure LogoutServers}

{**********}

BEGIN

  Initialise;
  LogoutServers;
  WorkStatServ.Done;
  MiscServ.Done;

END.

