{***************************************************************************}
{** Program : SEMAPHOR                                                    **}
{***************************************************************************}
{** Version : 1.0             ** Started :           ** Ended :           **}
{***************************************************************************}
{******************************** Description ******************************}
{***************************************************************************}
{** Program to demonstrate using semaphores for limiting how many users   **}
{** can run this program.  This program can only have one copy of itself  **}
{** running on a particular server.                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}
{******************************** Information ******************************}
{***************************************************************************}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{**                                                                       **}
{***************************************************************************}

{$X+}

program SEMAPHOR;

uses

  nwvar,
  nwsynch
  ;

const

  InstancesAllowedToRun = 1;

var

  SS      : SynchronisationOBJ;
  SHandle : longint;
  OCount  : byte;

begin

  SS.Init (true);
  SS.OpenSemaphore ('SEMAPHOR', 0, SHandle, OCount);
  if OCount > InstancesAllowedToRun then
    writeln ('This program is already at the user limit.')
  else
    begin

      writeln ('This program is only running on this pc');
      writeln ('Go and attempt to run this program on another pc on');
      writeln ('the same file server!');
      writeln ('Please press enter to end.');
      readln;

    end;

  SS.Done;

end.
