{ This is a demonstration of the expression evaluator
  provided by the Pascal Wizard's Library }



{$M $2000,0,0 }          { stack size, min heap, max heap (bytes) }
{$D-}                    { debug info off }
{$A-}                    { word alignment off (so use byte alignment) }
{$I-}                    { don't crash on errors }



USES
   ExtMath;

VAR
   Expr, StrResult: String;
   Result: Real;
   tmp, ErrCode: Integer;

BEGIN
   IF (ParamCount = 0) THEN BEGIN
      WriteLn('CALC  Demo for the PasWiz Library expression evaluator');
      WriteLn;
      WriteLn('Syntax:');
      WriteLn('   CALC expression');
      WriteLn;
      WriteLn('Expressions may use the following operators:');
      WriteLn('   +      add');
      WriteLn('   /      divide');
      WriteLn('   *      multiply');
      WriteLn('   -      subtract');
      WriteLn('   ^      raise to a power (** also works)');
      WriteLn;
      WriteLn('A number of functions are also provided:');
      WriteLn('   ABS    absolute value         INT    integer');
      WriteLn('   ACOS   inverse cosine         LOG    natural log');
      WriteLn('   ASIN   inverse sine           PI     3.141593');
      WriteLn('   ATAN   inverse tangent        SIN    sine');
      WriteLn('   COS    cosine                 SQRT   square root');
      WriteLn('   FRAC   fraction               TAN    tangent');
      WriteLn;
      WriteLn('Trig functions expect angles in radians.');
   END
   ELSE BEGIN
      Expr := '';
      FOR tmp := 1 TO ParamCount DO
         Expr := Expr + ParamStr(tmp);
      Evaluate(Expr, Result, ErrCode);
      IF (ErrCode = 0) THEN BEGIN
         Str(Result:10:6, StrResult);
         WHILE (StrResult[Length(StrResult)] = '0') DO
            Delete(StrResult, Length(StrResult), 1);
         IF (Length(StrResult) = 0) THEN
            StrResult := '0';
         IF (StrResult[Length(StrResult)] = '.') THEN
            Delete(StrResult, Length(StrResult), 1);
         IF (StrResult[1] = ' ') THEN BEGIN
            Delete(StrResult, 1, 1);
            IF (StrResult[1] = ' ') THEN
               Delete(StrResult, 1, 1);
         END;
         WriteLn(Expr, ' = ', StrResult);
      END
      ELSE
         CASE ErrCode OF
            1: WriteLn('Argument expected');
            2: WriteLn('Missing number');
            3: WriteLn('Unknown function');
            4: WriteLn('Unbalanced parentheses');
            9: WriteLn('Division by zero');
            ELSE WriteLn('Error');
         END;
   END;
END.
