{      "The PC Sound Programmer" version 2.0 by Foyal S. Carter, Jr.

    This program was written for Pascal programmers to use as a tool for
    writing source code which allows music to be composed or transposed
    to be played on the PC speaker. Little or no error checking is done
    and this program has not been tested on all types of computer systems.

           A Pascal compiler is required to use this program.

    While it works well for me, it might not for you. This program is
    being distributed as freeware, but if you find it is of use all
    donations will be accepted. It is fully functional and will write
    usable source code for Pascal. You may distribute this program as
    you see fit as long as it remains completely intact. For your own use,
    please feel free to modify this source as you see fit. Do not distribute
    any form of this program you have modified without completely removing
    all references to me!!!

    "I will assume absolutely no liability for the use or misuse of this
     program by anyone."
                                Foyal S. Carter, Jr.

     Turbo Pascal is a registered trademark of Borland International.
     This program was written using Turbo Pascal v 7.0.

     To print the source code while using the program use PRN as your
     filename and recover the file from PCSTEMP.BAK to use for compilation.
     Remember that the .bak file is overwritten on each run so if you
     need the source change it's name immediately on using the program.

     For Units don't use an extension or, if you do, modify the source so
     that the unit name does not contain a period (.), otherwise you will
     get an error when compiling. To use a unit written with this program
     you must identify it in a Uses statement immediately following the
     program statement in your source code. (just like any other unit).

     Have Fun!!!
}
program Music;
 uses crt;

var  {since the program is relatively small, all variables used are global}
     {extremely large compositions may not be possible}
 Rword:string;
 HzC,T1C:string[3];
 FileName:string[15];
 Title:string[30];
 Codeline:array [1..250] of string[40];  {add to the size of these arrays if}
 NoteA:array [1..250] of string[2];      {you need more than 250 notes.     }
 N1,N2,N3,N4,N5,N6,N7,N8,y,z,Sec,
 Tempo,Style,Ctr,Mn,X,I,T,T1,AT,Notecount,
 Octave,Hz,Duration,Pitch,LineCount:integer;

 ATP,TA,MT:real;

 Outfile,Bakfile:text;

 Validation:boolean;

 Selection,Choice:char;


procedure Initialize;{Sets starting values of Validation, the array index(I),}
 begin               {linecount (LineCount), and Codeline count (Ctr)        }
  Validation:=false; {and other variables}
  I:=0;
  Ctr:=0;
  LineCount:=0;
  Notecount:=0;
  AT:=0;
  ATP:=0;
  MT:=0;
  TA:=0;
  Mn:=1;
  y:=0;
  z:=1;
  Sec:=0;
end;

procedure Note;   {Assigns a frequency value to the Hz variable }
 begin
  case pitch of
    1: Hz:=262;    {C}
    2: Hz:=278;    {C#/Db}
    3: Hz:=294;    {D}
    4: Hz:=312;    {D#/Eb}
    5: Hz:=330;    {E}
    6: Hz:=349;    {F}
    7: Hz:=370;    {F#/Gb}
    8: Hz:=392;    {G}
    9: Hz:=416;    {G#/Ab}
   10: Hz:=440;    {A}
   11: Hz:=467;    {A#/Bb}
   12: Hz:=494;    {B}
  end;
end;

procedure Modulate;  {Modulates the frequency of the Hz variable in order}
 begin               {to facilitate playing notes in a seven octave range}
  case octave of
    1:Hz:=Hz div 8;
    2:Hz:=Hz div 4;
    3:Hz:=Hz div 2;
    4:Hz:=Hz;
    5:Hz:=Hz * 2;
    6:Hz:=Hz * 4;
    7:Hz:=Hz * 8;
  end;
end;

procedure Time;     {Adjusts the millisecond value of the base duration}
 begin              {variable (t) based on the notation and assigns the}
  case duration of  {new value to the secondary duration variable (t1)}
    1: begin
        t1:= t;                          {Whole}
        MT:=100;
       end;
    2: begin
        t1:= (t div 2) + (t div 4);      {Dotted Half}
        MT:=75;
       end;
    3: begin
        t1:= t div 2;                     {Half}
        MT:=50;
       end;
    4: begin
        t1:= (t div 4) + (t div 8);       {Dotted Quarter}
        MT:=37.5;
       end;
    5: begin
        t1:= t div 4;                     {Quarter}
        MT:=25;
       end;
    6: begin
        t1:= (t div 8) + (t div 16);      {Dotted Eighth}
        MT:=18.75;
       end;
    7: begin
        t1:= t div 8;                     {Eighth}
        MT:=12.5;
       end;
    8: begin
        t1:= (t div 16) + (t div 32);     {Dotted Sixteenth}
        MT:=9.375;
       end;
    9: begin
        t1:= t div 16;                    {Sixteenth}
        MT:=6.25;
       end;
   10: begin
        t1:= (t div 32) + (t div 64);    {Dotted Thirty-second}
        MT:=4.6875;
       end;
   11: begin
        t1:= t div 32;                    {Thirty-second}
        MT:=3.125;
        end;
   12:  begin
         t1:= (t div 64) + (t div 128);    {Dotted Sixty-fourth}
         MT:=2.34375;
        end;
   13:  begin
         t1:= t div 64;                    {Sixty-fourth}
         MT:=1.5625;
        end;
  end;
end;

procedure Rate;  {Sets the time delay (in milliseconds) of the}
 begin           {base duration variable (t)}
  case tempo of
    1: t:= 4800;   {Largo:    Slow;}
    2: t:= 3600;   {Andante:  Moderately slow;}
    3: t:= 2400;   {Moderato: Moderate; 1/4 note = 1/100 minute}
    4: t:= 1200;   {Allegro:  Moderately quick;}
    5: t:=  900;   {Vivo:     Rapid;}
    6: t:=  600;   {Presto:   Very rapid;}
  end;
end;

procedure ErrorMessage;     {writes the user input error message}
begin
 gotoxy(19,21);
 write('Your selection is invalid please try again.');
end;

procedure ClearErrorMessage; {erases the user input error message}
begin
 gotoxy(19,21);
 write('                                           ');
 validation:=false;
end;


procedure DrawNote;{draws each on-screen note for the intermediate screens}
 begin
  write(#255#219#10#8#8);
  delay(10);
  write(#255#219#220#10#8#8#8);
  delay(10);
  write(#255#219#219#219#10#8#8#8#8);
  delay(10);
  write(#255#219#255#222#10#8#8#8#8);
  delay(10);
  write(#255#219#10#8#8);
  delay(10);
  write(#255#219#10#8#8);
  delay(10);
  write(#255#219#10#8#8#8#8#8);
  delay(10);
  write(#220#219#219#219#219#10#8#8#8#8#8#8);
  delay(10);
  write(#255#219#219#219#219#219#10#8#8#8#8#8);
  delay(10);
  write(#223#219#219#219#223);
  textcolor(black);
  gotoxy(80,25);
  delay(50);
end;

procedure Line;   {draws each line for the musical staff}
 begin
  for x:=5 to 75 do
   write(#220);
end;

procedure DrawStaff;  {draws the musical staff}
 begin
  textcolor(white);
  gotoxy(5,5);
  Line;
  gotoxy(5,9);
  Line;
  gotoxy(5,13);
  Line;
  gotoxy(5,17);
  Line;
  gotoxy(5,20);
  Line;
end;

procedure MidScreen; {Calls the DrawStaff procedures}
begin
 textbackground(black);
 clrscr;
 DrawStaff;
 textcolor(blue);
 gotoxy(9,1);
 drawnote;
 sound(N1);
 textcolor(red);
 gotoxy(18,5);
 drawnote;
 sound(N2);
 textcolor(green);
 gotoxy(27,12);
 drawnote;
 sound(N3);
 textcolor(magenta);
 gotoxy(36,9);
 drawnote;
 sound(N4);
 textcolor(yellow);
 gotoxy(45,3);
 drawnote;
 sound(N5);
 textcolor(brown);
 gotoxy(54,14);
 drawnote;
 sound(N6);
 textcolor(cyan);
 gotoxy(63,12);
 drawnote;
 sound(N7);
 textcolor(lightblue);
 gotoxy(72,1);
 drawnote;
 sound(N8);
 delay(140);
 nosound;
 gotoxy(80,25);
 delay(500);
 textbackground(blue);
 clrscr;
 textcolor(white);
end;

Procedure Ditty1;   {a little tune}
 begin
  N1:=524;
  N2:=494;
  N3:=440;
  N4:=392;
  N5:=349;
  N6:=330;
  N7:=294;
  N8:=262;
end;

Procedure Ditty2;   {another little tune}
 begin
  N1:=262;
  N2:=294;
  N3:=330;
  N4:=294;
  N5:=330;
  N6:=262;
  N7:=392;
  N8:=524;
end;

Procedure Ditty3;   {still another...}
 begin
  N1:=330;
  N2:=330;
  N3:=392;
  N4:=416;
  N5:=494;
  N6:=494;
  N7:=556;
  N8:=660;
end;

Procedure Ditty4;   {and yet another.}
 begin
  N1:=262;
  N2:=294;
  N3:=330;
  N4:=349;
  N5:=392;
  N6:=440;
  N7:=494;
  N8:=524;
end;

procedure ScreenHeader;   {displays the header for all other screens}
 begin
  write(#201:26);
   for x:=1 to 27 do
    write(#205);
  writeln(#187);
  write(#186:26);
  textcolor(yellow);
  write(' "The PC Sound Programmer" ');
  textcolor(white);
  writeln(#186);
  write(#186:26);
  textcolor(yellow);
  write('        Version 2.0        ');
  textcolor(white);
  writeln(#186);
  write(#200:26);
   for x:=1 to 27 do
    write(#205);
  writeln(#188);
end;

procedure DisplayScreen1;   {displays the initial startup screen}
 begin
  textbackground(blue);
  clrscr;
  textcolor(white);
  writeln;
  writeln;
  writeln;
  writeln;
  ScreenHeader;
  write(#201:26);
   for x:=1 to 27 do
    write(#205);
  writeln(#187);
  write(#186:26);
  write('      December,  1994      ');
  writeln(#186);
  write(#186:26);
  write('            by             ');
  writeln(#186);
  write(#186:26);
  write('       APS Toolworks       ');
  writeln(#186);
  write(#186:26);
  write('                           ');
  writeln(#186);
  write(#186:26);
  write('  Al''s Programming Service ');
  writeln(#186);
  write(#186:26);
  write('      85 Hamilton St.      ');
  writeln(#186);
  write(#186:26);
  write('   Daleville, AL  36322    ');
  writeln(#186);
  write(#186:26);
  write('      (205) 598-0086       ');
  writeln(#186);
  write(#200:26);
   for x:=1 to 27 do
    write(#205);
  writeln(#188);
  writeln;
  writeln;
  writeln;
  writeln;
  writeln;
  writeln;
end;

procedure DisplayScreen2;   {displays the format selection screen  }
 begin                      {gets user data for assignment of the  }
  clrscr;                   {style variable in the module procedure}
  writeln;
  writeln;
  writeln;
  writeln;
  ScreenHeader;
  write(#201:26);
   for x:=1 to 27 do
    write(#205);
  writeln(#187);
  write(#186:26);
  write('  Please select a format   ');
  writeln(#186);
  write(#186:26);
  write('  for your source code:    ');
  writeln(#186);
  write(#186:26);
  write('                           ');
  writeln(#186);
  write(#186:26);
  textcolor(lightred);
  write(' 1: Turbo Pascal Program   ');
  textcolor(white);
  writeln(#186);
  write(#186:26);
  write('                           ');
  writeln(#186);
  write(#186:26);
  textcolor(magenta);
  write(' 2: Turbo Pascal Unit      ');
  textcolor(white);
  writeln(#186);
  write(#186:26);
  write('                           ');
  writeln(#186);
  write(#186:26);
  textcolor(green);
  write(' 3: Turbo Pascal Procedure ');
  textcolor(white);
  writeln(#186);
  write(#200:26);
   for x:=1 to 27 do
    write(#205);
  writeln(#188);
  writeln;
  writeln;
  writeln;
  writeln;
  writeln;
   repeat
    gotoxy(51,11);
    selection:=readkey;
    gotoxy(51,11);
      case selection of
         '1': begin
               style:=1;
               validation:=true;
              end;
         '2': begin
               style:=2;
               validation:=true;
              end;
         '3': begin
               style:=3;
               validation:=true;
              end;
           else
            gotoxy(51,11);
            write('  ',#8#8);
            ErrorMessage;
      end;
   until validation=true;
  validation:=false;
end;

procedure DisplayScreen3;   {displays the tempo selection screen }
 begin                      {gets user data for assignment of the}
  clrscr;                   {tempo variable in the rate procedure}
  writeln;
  writeln;
  writeln;
  writeln;
  ScreenHeader;
  write(#201:16);
   for x:=1 to 47 do
    write(#205);
  writeln(#187);
  write(#186:16);
  write('           Please select a tempo:              ');
  writeln(#186);
  write(#186:16);
  write('                                               ');
  writeln(#186);
  write(#186:16);
  write(' 1: Largo:    Slow                             ');
  writeln(#186);
  write(#186:16);
  write(' 2: Andante:  Moderately Slow                  ');
  writeln(#186);
  write(#186:16);
  write(' 3: Moderato: Moderate(1/4 note = 1/100 minute)');
  writeln(#186);
  write(#186:16);
  write(' 4: Allegro:  Moderately Quick                 ');
  writeln(#186);
  write(#186:16);
  write(' 5: Vivo:     Rapid                            ');
  writeln(#186);
  write(#186:16);
  write(' 6: Presto:   Very Rapid                       ');
  writeln(#186);
  write(#200:16);
   for x:=1 to 47 do
    write(#205);
  writeln(#188);
  writeln;
  writeln;
  writeln;
  writeln;
  writeln;
   repeat
    gotoxy(51,10);
    selection:=readkey;
    gotoxy(51,10);
     case selection of
      '1': begin
            tempo:=1;
            rate;
            validation:=true;
            end;
      '2': begin
            tempo:=2;
            rate;
            validation:=true;
            end;
      '3': begin
            tempo:=3;
            rate;
            validation:=true;
            end;
      '4': begin
            tempo:=4;
            rate;
            validation:=true;
            end;
      '5': begin
            tempo:=5;
            rate;
            validation:=true;
            end;
      '6': begin
            tempo:=6;
            rate;
            validation:=true;
            end;
      '7': begin
            tempo:=7;
            rate;
            validation:=true;
            end;
          else
           gotoxy(51,10);
           write('  ',#8#8);
           ErrorMessage;
     end;
   until validation=true;
  validation:=false;
end;

procedure DisplayScreen4;   {displays the song composition screen;}
 begin                      {items displayed are for selection in }
  clrscr;                   {the GetCompositionInfo procedure.    }
  writeln;
  ScreenHeader;
  write(#201:10);
   for x:=1 to 60 do
    write(#205);
  writeln(#187);
  write(#186:10);
  write('  C: C        W: Whole     1: Low Bass                      ');
  writeln(#186);
  write(#186:10);
  write('  d: C#/Db    H: 1/2+      2: Bass                          ');
  writeln(#186);
  write(#186:10);
  write('  D: D        h: 1/2       3: Low Midrange                  ');
  writeln(#186);
  write(#186:10);
  write('  e: D#/Eb    Q: 1/4+      4: Midrange                      ');
  writeln(#186);
  write(#186:10);
  write('  E: E        q: 1/4       5: High Midrange                 ');
  writeln(#186);
  write(#186:10);
  write('  F: F        E: 1/8+      6: Treble                        ');
  writeln(#186);
  write(#186:10);
  write('  g: F#/Gb    e: 1/8       7: High Treble                   ');
  writeln(#186);
  write(#186:10);
  write('  G: G        S: 1/16+                                      ');
  writeln(#186);
  write(#186:10);
  write('  a: G#/Ab    s: 1/16                                       ');
  writeln(#186);
  write(#186:10);
  write('  A: A        T: 1/32+     Measure               % Full     ');
  writeln(#186);
  write(#186:10);
  write('  b: A#/Bb    t: 1/32      Accumulated Time:       Secs.    ');
  writeln(#186);
  write(#186:10);
  write('  B: B        F: 1/64+     Note Count:                      ');
  writeln(#186);
  write(#186:10);
  write('  R: Rest     f: 1/64                                       ');
  writeln(#186);
  write(#186:10);
  write('                                                            ');
  writeln(#186);
  write(#186:10);
  write('                                                            ');
  writeln(#186);
  write(#186:10);
  write('                                                            ');
  writeln(#186);
  write(#204:10);
   for x:=1 to 60 do
    write(#205);
  writeln(#185);
  write(#186:10);
  write('                                                            ');
  writeln(#186);
  write(#200:10);
   for x:=1 to 60 do
    write(#205);
  writeln(#188);
  gotoxy(51,11);
end;

procedure ConvertHz;    {converts the integer value of the Hz variable    }
 begin                  {to its string representation in the HzC variable.}
  Str(Hz,HzC);
end;

procedure ConvertT1;    {converts the integer value of the T1 variable    }
 begin                  {to its string representation in the T1C variable.}
  Str(T1,T1C);
end;

procedure DisplayNoteA; {displays all selected notes along bottom of screen}
 begin                  {(scrolls when line is full)}
  textbackground(black);
  textcolor(green);
  repeat
  x:=y;
  gotoxy(13,23);
  repeat
  write(' ',NoteA[x]);
  x:=x+1;
  until (x = z) or (x = y+18);
   if x = y+18 then
     y:=y+1;
  until (x = z);
  textbackground(blue);
  textcolor(white);
end;




procedure DisplayMeasureTime; {displays accumulated time for each measure}
 begin
  textcolor(lightblue);
  textbackground(black);
  ATP:=ATP+MT;
  if ATP>=100.0 then
   begin
    ATP:= ATP-100.0;
    Mn:=Mn+1;
    gotoxy(38,15);
    write(' Measure #',Mn,' is:   ',ATP:5:2,' % full  ');
   end
   else
    begin
      gotoxy(38,15);
      write(' Measure #',Mn,' is:   ',ATP:5:2,' % full  ');
     end;
    textcolor(white);
    textbackground(blue);
end;

procedure DisplayTotalTime;   {displays total time of composition}
 begin
  textbackground(black);
  textcolor(magenta);
  AT:=AT+T1;
  if (AT < 1000) and (Sec = 0) then
   begin
    gotoxy(38,16);
    write(' Total time is:   ',AT:5,'   msec. ');
   end
    else
     if AT >= 1000 then
      begin
       Sec:=Sec+1;
       AT:= AT-1000;
       gotoxy(38,16);
       write(' Total time is:  ',Sec:3,'.',AT:2,'  sec.  ':7);
      end
       else
        begin
         gotoxy(38,16);
         write(' Total time is:  ',Sec:3,'.',AT:2,'  sec.  ':7);
        end;
  textbackground(blue);
  textcolor(white);
end;

procedure DisplayNoteCount;   {displays number of notes in composition}
 begin
  textbackground(black);
  textcolor(red);
  Notecount:=Notecount+1;
  gotoxy(38,17);
  write(' Note Count is:   ',Notecount:5,'         ');
  textbackground(blue);
  textcolor(white);
end;

procedure GetCompositionInfo;   {gets user input to compose melody...}
 begin                          {includes assignment data for note,  }
   repeat                       {modulate and time procedures        }
    gotoxy(13,19);
    textcolor(red+blink);
    write(#24);
    gotoxy(13,20);
    textcolor(white);
    write('Select Note:');
    selection:=readkey;
    gotoxy(25,20);
     case selection of
       'C': begin
             pitch:=1;
             note;
             validation:=true;
             Rword:='Sound';
             NoteA[z]:='C ';
            end;
       'd': begin
             pitch:=2;
             note;
             validation:=true;
             Rword:='Sound';
             NoteA[z]:='C#';
            end;
       'D': begin
             pitch:=3;
             note;
             validation:=true;
             Rword:='Sound';
             NoteA[z]:='D ';
            end;
       'e': begin
             pitch:=4;
             note;
             validation:=true;
             Rword:='Sound';
             NoteA[z]:='Eb';
            end;
       'E': begin
             pitch:=5;
             note;
             validation:=true;
             Rword:='Sound';
             NoteA[z]:='E ';
            end;
       'F': begin
             pitch:=6;
             note;
             validation:=true;
             Rword:='Sound';
             NoteA[z]:='F ';
            end;
       'g': begin
             pitch:=7;
             note;
             validation:=true;
             Rword:='Sound';
             NoteA[z]:='F#';
            end;
       'G': begin
             pitch:=8;
             note;
             validation:=true;
             Rword:='Sound';
             NoteA[z]:='G ';
            end;
       'a': begin
             pitch:=9;
             note;
             validation:=true;
             Rword:='Sound';
             NoteA[z]:='G#';
            end;
       'A': begin
             pitch:=10;
             note;
             validation:=true;
             Rword:='Sound';
             NoteA[z]:='A ';
            end;
       'b': begin
             pitch:=11;
             note;
             validation:=true;
             Rword:='Sound';
             NoteA[z]:='Bb';
            end;
       'B': begin
             pitch:=12;
             note;
             validation:=true;
             Rword:='Sound';
             NoteA[z]:='B ';
            end;
       'R','r': begin
                 pitch:=13;
                 validation:=true;
                 Rword:='NoSound';
                 NoteA[z]:='R ';
                end;
           else
            ErrorMessage;
        end;
    gotoxy(13,19);
    write(' ');
    gotoxy(13,20);
    write('              ');
   until validation=true;
   z:=z+1;
   ClearErrorMessage;
   repeat
    gotoxy(25,19);
    textcolor(red+blink);
    write(#24);
    gotoxy(25,20);
    textcolor(white);
    write('Select Duration:');
    selection:=readkey;
    gotoxy(41,20);
     case selection of
       'W','w': begin
                 duration:=1;
                 Time;
                 ConvertT1;
                 validation:=true;
                end;
       'H': begin
             duration:=2;
             Time;
             ConvertT1;
             validation:=true;
            end;

       'h': begin
             duration:=3;
             Time;
             ConvertT1;
             validation:=true;
            end;
       'Q': begin
             duration:=4;
             Time;
             ConvertT1;
             validation:=true;
            end;
       'q': begin
             duration:=5;
             Time;
             ConvertT1;
             validation:=true;
            end;
       'E': begin
             duration:=6;
             Time;
             ConvertT1;
             validation:=true;
            end;
       'e': begin
             duration:=7;
             Time;
             ConvertT1;
             validation:=true;
            end;
       'S': begin
             duration:=8;
             Time;
             ConvertT1;
             validation:=true;
            end;
       's': begin
             duration:=9;
             Time;
             ConvertT1;
             validation:=true;
            end;
       'T': begin
             duration:=10;
             Time;
             ConvertT1;
             validation:=true;
            end;
       't': begin
             duration:=11;
             Time;
             ConvertT1;
             validation:=true;
            end;
       'F': begin
             duration:=12;
             Time;
             ConvertT1;
             validation:=true;
            end;
       'f': begin
             duration:=13;
             Time;
             ConvertT1;
             validation:=true;
            end;
          else
           ErrorMessage;
     end;
    gotoxy(25,19);
    write(' ');
    gotoxy(25,20);
    write('                  ');
   until validation=true;
  ClearErrorMessage;
   if pitch<>13 then
    begin
     repeat
      gotoxy(38,13);
      textcolor(red+blink);
      write(#24);
      gotoxy(38,14);
      textcolor(white);
      write('Select Range:');
      selection:=readkey;
      gotoxy(51,14);
       case selection of
         '1': begin
                octave:=1;
                Modulate;
                ConvertHz;
                validation:= true;
               end;
         '2': begin
                octave:=2;
                Modulate;
                ConvertHz;
                validation:= true;
               end;
         '3': begin
                octave:=3;
                Modulate;
                ConvertHz;
                validation:= true;
               end;
         '4': begin
                octave:=4;
                Modulate;
                ConvertHz;
                validation:= true;
               end;
         '5': begin
                octave:=5;
                Modulate;
                ConvertHz;
                validation:= true;
               end;
         '6': begin
                octave:=6;
                Modulate;
                ConvertHz;
                validation:= true;
               end;
         '7': begin
                octave:=7;
                Modulate;
                ConvertHz;
                validation:= true;
               end;
             else
             ErrorMessage;
       end;
      gotoxy(38,13);
      write(' ');
      gotoxy(38,14);
      write('               ');
     until validation=true;
     ClearErrorMessage;
    end;
  DisplayMeasureTime;
  DisplayTotalTime;
  DisplayNoteCount;
  DisplayNoteA;
  gotoxy(13,21);
  write('Press <E> to End or any other key to continue');
  choice:=readkey;
  gotoxy(13,21);
  write('                                             ');
  gotoxy(80,25);
end;

procedure DisplayScreen5;     {gets user input for filename}
 begin
  clrscr;
  writeln;
  ScreenHeader;
  write(#201:16);
   for x:=1 to 47 do
    write(#205);
  writeln(#187);
  write(#186:16);
  write(' Please enter a filename for your source code: ');
  writeln(#186);
  write(#186:16);
  write(' Include the full path and up to 8 characters. ');
  writeln(#186);
  write(#186:16);
  write('                                               ');
  writeln(#186);
  write(#186:16);
  write(' For Example:                                  ');
  writeln(#186);
  write(#186:16);
  write('                 C:\Sounds\Boogie              ');
  writeln(#186);
  write(#186:16);
  write('                 ',#24,'     ',#24,'     ',#24,'                 ');
  writeln(#186);
  write(#186:16);
  write('               Drive \ Dir \ Filename          ');
  writeln(#186);
  write(#186:16);
  write('                                               ');
  writeln(#186);
  write(#200:16);
   for x:=1 to 47 do
    write(#205);
  writeln(#188);
  writeln;
  write(#201:16);
   for x:=1 to 47 do
    write(#205);
  writeln(#187);
  write(#186:16);
  write('                                               ');
  writeln(#186);
  write(#200:16);
   for x:=1 to 47 do
    write(#205);
  writeln(#188);
  gotoxy(20,18);
  readln(FileName);
  gotoxy(20,18);
end;

procedure DisplayScreen6; {gets user input for title of composition}
 begin
  clrscr;
  writeln;
  writeln;
  writeln;
  ScreenHeader;
  write(#201:16);
   for x:=1 to 47 do
    write(#205);
  writeln(#187);
  write(#186:16);
  write('  Please enter a title for your composition.   ');
  writeln(#186);
  write(#186:16);
  write('Use the underline for spaces. DO NOT USE BLANKS');
  writeln(#186);
  write(#186:16);
  write('  The title you have selected will be placed   ');
  writeln(#186);
  write(#186:16);
  write('     appropriately in the Program, Unit or     ');
  writeln(#186);
  write(#186:16);
  write('      Procedure source code output file.       ');
  writeln(#186);
  write(#200:16);
   for x:=1 to 47 do
    write(#205);
  writeln(#188);
  writeln;
  write(#201:16);
   for x:=1 to 47 do
    write(#205);
  writeln(#187);
  write(#186:16);
  write('                                               ');
  writeln(#186);
  write(#200:16);
   for x:=1 to 47 do
    write(#205);
  writeln(#188);
  gotoxy(25,17);
  readln(Title);
  gotoxy(80,25);
end;

procedure DisplayScreen7;  {notification of backup file creation}
 begin
  clrscr;
  writeln;
  writeln;
  writeln;
  writeln;
  ScreenHeader;
  write(#201:16);
   for x:=1 to 47 do
    write(#205);
  writeln(#187);
  write(#186:16);
  write('           Your File Has Been Created!         ');
  writeln(#186);
  write(#186:16);
  write('   If, for some reason, you can''t locate it,   ');
  writeln(#186);
  write(#186:16);
  write(' a temporary back-up has been created for you. ');
  writeln(#186);
  write(#186:16);
  write('        You can recover your source from       ');
  writeln(#186);
  write(#186:16);
  write('                   PCSTEMP.BAK                 ');
  writeln(#186);
  write(#186:16);
  textcolor(red+blink);
  textbackground(yellow);
  write(' WARNING! PCSTEMP.BAK IS OVERWRITTEN EACH TIME ');
  textcolor(white);
  textbackground(blue);
  writeln(#186);
  write(#186:16);
  textcolor(red+blink);
  textbackground(yellow);
  write('     YOU RUN THIS PROGRAM, SO DON''T DELAY!!!   ');
  textcolor(white);
  textbackground(blue);
  writeln(#186);
  write(#186:16);
  write('                                               ');
  writeln(#186);
  write(#200:16);
   for x:=1 to 47 do
    write(#205);
  writeln(#188);
  writeln('                         Press Any Key to Continue');
  gotoxy(80,25);
  selection:=readkey;
end;

procedure DisplayScreen8;  {Thanks and bye-bye}
 begin
  DisplayScreen1;
  gotoxy(31,3);
  textcolor(white+blink);
  write('Thank You For Using');
  textcolor(white);
  gotoxy(80,25);
end;

procedure MakeCodeline;  {Concatenates strings for writing the body of   }
 begin                   {the source code (using the HzC and T1C variable}
  I:= I + 1;             {content) and loads them into the Codeline array}
  If Rword='Sound' then
   begin
    if (length(HzC) < 3) and (length(T1C) < 3) then
     begin
     Codeline[I]:=( '  '+Rword+'('+HzC+');  Delay('+T1C+');    {'+NoteA[z-1]+'}');
     end
     else
    if (length(HzC) < 3) or (length(T1C) < 3) then
     begin
     Codeline[I]:=( '  '+Rword+'('+HzC+');  Delay('+T1C+');   {'+NoteA[z-1]+'}');
     end
     else
     Codeline[I]:=( '  '+Rword+'('+HzC+'); Delay('+T1C+');   {'+NoteA[z-1]+'}');
   end
   else
    if length(T1C) < 3 then
     begin
     Codeline[I]:=( '  '+Rword+';    Delay('+T1C+');    {REST}');
     end
     else
     Codeline[I]:=( '  '+Rword+';    Delay('+T1C+');   {REST}');
  Ctr:=Ctr+1;
end;

procedure OpenFile;      {opens the files for output and backup}
 begin
  assign(Outfile,FileName);
  rewrite(Outfile);
  assign(Bakfile,'PCSTEMP.BAK');
  rewrite(Bakfile);
end;


procedure WriteCommentary;  {puts my name in your code.   }
 begin                      { (you can always delete it!) }
  writeln(Outfile);
  writeln(Outfile);
  writeln(Outfile,' {****************************************************************************');
  writeln(Outfile,'  *        The following source code was developed and written using:        *');
  writeln(Outfile,'  *                       *****************************                      *');
  writeln(Outfile,'  *                       * "The PC Sound Programmer" *                      *');
  writeln(Outfile,'  *                       *        Version 2.0        *                      *');
  writeln(Outfile,'  *                       *     * APS Toolworks *     *                      *');
  writeln(Outfile,'  *                       *      December, 1994       *                      *');
  writeln(Outfile,'  *                       *****************************                      *');
  writeln(Outfile,'  *                       * Al''s Programming Service  *                      *');
  writeln(Outfile,'  *                       *       85 Hamilton St.     *                      *');
  writeln(Outfile,'  *                       *   Daleville, AL   36322   *                      *');
  writeln(Outfile,'  *                       *****************************                      *');
  writeln(Outfile,'  *                 For more infomation about this program or                *');
  writeln(Outfile,'  *    for information about custom designed programs please contact:        *');
  writeln(Outfile,'  *                   Foyal S. Carter, Jr. at (205) 598-0086                 *');
  writeln(Outfile,'  ****************************************************************************}');
end;

procedure WriteProgramHeader; {just what it says}
 begin
  writeln(Outfile);
  writeln(Outfile,'Program ',Title,';');
  writeln(Outfile,'uses CRT;');
  writeln(Outfile);
  writeln(Outfile,'begin');
end;

procedure WriteUnitHeader;    {same}
 begin
  writeln(Outfile);
  writeln(Outfile,'Unit ',FileName,';');
  writeln(Outfile,'Interface');
  writeln(Outfile);
  writeln(Outfile,'Procedure ',Title,';');
  writeln(Outfile);
  writeln(Outfile,'Implementation');
  writeln(Outfile,'Uses CRT;');
  writeln(Outfile);
  writeln(Outfile,'Procedure ',Title,';');
  writeln(Outfile,' begin');
end;

procedure WriteProcedureHeader;  {once again}
 begin
  writeln(Outfile);
  writeln(Outfile,'Procedure ',Title,';');
  writeln(Outfile,' begin');
end;

procedure WriteBody; {writes body of source from the codeline array}
 begin
  I:=0;
   repeat
    I:=I+1;
    writeln(Outfile,Codeline[I]);
   until I=ctr;
  I:=0;
   repeat
    I:=I+1;
    writeln(Bakfile,Codeline[I]);
   until I=ctr;
end;

procedure WriteEnd;  {writes the end, imagine that}
 begin
  if style=1 then
   begin
    writeln(Outfile,'  Nosound;');
    writeln(Outfile,'end.');
    writeln(Outfile);
    writeln(Outfile,'{The preceding source code is ready to compile and execute. Note commentary  }');
    writeln(Outfile,'{has been provided to make editing easier should you desire to block and copy}');
    writeln(Outfile,'{sections or simply adjust certain note frequencies or durations.            }');
    writeln(Bakfile,'  Nosound;');
    writeln(Bakfile,'end.');
    writeln(Bakfile);
    writeln(Bakfile,'{The preceding source code is ready to compile and execute. Note commentary  }');
    writeln(Bakfile,'{has been provided to make editing easier should you desire to block and copy}');
    writeln(Bakfile,'{sections or simply adjust certain note frequencies or durations.            }');
   end
  else
   if style=2 then
    begin
     writeln(Outfile,'  Nosound;');
     writeln(Outfile,'end;');
     writeln(Outfile);
     writeln(Outfile,'begin');
     writeln(Outfile,title,';');
     writeln(Outfile,'end.');
     writeln(Outfile);
     writeln(Outfile,'{The preceding source code is ready to compile and call. Note that commentary}');
     writeln(Outfile,'{has been provided to make editing easier should you desire to block and copy}');
     writeln(Outfile,'{sections or simply adjust certain note frequencies or durations.            }');
     writeln(Bakfile,'  Nosound;');
     writeln(Bakfile,'end;');
     writeln(Bakfile);
     writeln(Bakfile,'begin');
     writeln(Bakfile,title,';');
     writeln(Bakfile,'end.');
     writeln(Bakfile);
     writeln(Bakfile,'{The preceding source code is ready to compile and call. Note that commentary}');
     writeln(Bakfile,'{has been provided to make editing easier should you desire to block and copy}');
     writeln(Bakfile,'{sections or simply adjust certain note frequencies or durations.            }');
    end
     else
      begin
       writeln(Outfile,'  Nosound;');
       writeln(Outfile,'end;');
       writeln(Outfile);
       writeln(Outfile,'{In order to call this procedure it must be moved into a compileable}');
       writeln(Outfile,'{program. The statement ''Uses CRT;'' must be placed immediately      }');
       writeln(Outfile,'{following the program statement at the beginning of the source.    }');
       writeln(Bakfile,'  Nosound;');
       writeln(Bakfile,'end;');
       writeln(Bakfile);
       writeln(Bakfile,'{In order to call this procedure it must be moved into a compileable}');
       writeln(Bakfile,'{program. The statement ''Uses CRT;'' must be placed immediately      }');
       writeln(Bakfile,'{following the program statement at the beginning of the source.    }');
      end;
end;


procedure WriteCommentaryB;  {backup file stuff}
 begin
  writeln(Bakfile);
  writeln(Bakfile);
  writeln(Bakfile,' {****************************************************************************');
  writeln(Bakfile,'  *        The following source code was developed and written using:        *');
  writeln(Bakfile,'  *                       *****************************                      *');
  writeln(Bakfile,'  *                       * "The PC Sound Programmer" *                      *');
  writeln(Bakfile,'  *                       *        Version 2.0        *                      *');
  writeln(Bakfile,'  *                       *     * APS Toolworks *     *                      *');
  writeln(Bakfile,'  *                       *      December, 1994       *                      *');
  writeln(Bakfile,'  *                       *****************************                      *');
  writeln(Bakfile,'  *                       * Al''s Programming Service  *                      *');
  writeln(Bakfile,'  *                       *      85 Hamilton St.      *                      *');
  writeln(Bakfile,'  *                       *   Daleville, AL   36322   *                      *');
  writeln(Bakfile,'  *                       *****************************                      *');
  writeln(Bakfile,'  *               For more infomation about this program or for              *');
  writeln(Bakfile,'  *       information about custom designed programs please contact:         *');
  writeln(Bakfile,'  *                  Foyal S. Carter, Jr. at (205) 598-0086                  *');
  writeln(Bakfile,'  ****************************************************************************}');
end;

procedure WriteProgramHeaderB;  {more backup...just a repeat}
 begin
  writeln(Bakfile);
  writeln(Bakfile,'Program ',Title,';');
  writeln(Bakfile,'uses CRT;');
  writeln(Bakfile);
  writeln(Bakfile,'begin');
end;

procedure WriteUnitHeaderB;     {again and again}
 begin
  writeln(Bakfile);
  writeln(Bakfile,'Unit ',FileName,';');
  writeln(Bakfile,'Interface');
  writeln(Bakfile);
  writeln(Bakfile,'Procedure Play',Title,';');
  writeln(Bakfile);
  writeln(Bakfile,'Implementation');
  writeln(Bakfile,'Uses CRT;');
  writeln(Bakfile);
  writeln(Bakfile,'Procedure Play',Title,';');
  writeln(Bakfile,' Begin');
end;

procedure WriteProcedureHeaderB; {and again...}
 begin
  writeln(Bakfile);
  writeln(Bakfile,'Procedure Play',Title,';');
  writeln(Bakfile,' begin');
end;

procedure WriteHeader;          {calls all header routines}
 begin
  WriteCommentary;
  WriteCommentaryB;
   case style of
     1:begin
        WriteProgramHeader;
        WriteProgramHeaderB;
       end;
     2:begin
        WriteUnitHeader;
        WriteUnitHeaderB;
       end;
     3:begin
        WriteProcedureHeader;
        WriteProcedureHeaderB;
       end;
   end;
end;

procedure CloseFile;       {closes the output and backup files}
 begin
  close(Outfile);
  close(Bakfile);
end;

begin                      {the main program module}
 Initialize;
 DisplayScreen1;
 delay(2500);
 Ditty1;
 MidScreen;
 DisplayScreen2;
 Ditty2;
 MidScreen;
 DisplayScreen3;
 Ditty3;
 MidScreen;
 DisplayScreen4;
  repeat
   GetCompositionInfo;
   MakeCodeline;
   LineCount:=LineCount+1;
  until (Choice='e') or (Choice='E');
 Ditty3;
 MidScreen;
 Displayscreen5;
 Ditty2;
 MidScreen;
 DisplayScreen6;
 OpenFile;
 WriteHeader;
 WriteBody;
 WriteEnd;
 CloseFile;
 Ditty2;
 MidScreen;
 DisplayScreen7;
 Ditty4;
 MidScreen;
 DisplayScreen8;
 Readln;
 gotoxy(1,1);
 textbackground(black);
 clrscr;
end.                       {THE END.}