/* Modified by Shamim Islam to demonstrate switch45.ch, switch45.obj        */
/* NOTE: Switch assumes non C_LIKE syntax unless this macro is defined  */
/* Therefore there is no need for a break between individual cases      */
/* Please see switch v4.5 documentation (current revision level) for    */
/* more information                                                     */
/*                                                                      */
/* Original routine: copyright (c) CA Intl (sample directory)           */
/*                                                                      */
#include "switch45.ch"
/*                                                                      */
/* Switch is only compatible with Clipper v5.0 and above                */
/* Non C_LIKE demo                                                      */

// Remainder of file omitted for brevity


/***
*
*  GetFiles() --> NIL
*
*
*/
STATIC FUNCTION GetFiles()

    LOCAL lDone         := .F.                // Primary loop point
    LOCAL nCurrent     := 0                  // ACHOICE() result
    LOCAL nLastKey     := 0                  // Last value in LASTKEY()

    DO WHILE !lDone
        IF lReloadDir
            nEl    := 1
            nRel  := 1
            IF !LoadFiles()

                // A problem occured loading the file names; tell the user
                ErrorBeep()
                Message( "ERROR: No files found!  Press any key..." )
                INKEY( 300 )
                IF YesOrNo( "Would you like to try another path? (Y/N)", "Y" )
                    GetNewPath( aFileMan[ FM_PATH ] )
                    IF LASTKEY() == K_ESC
                        lDone := .T.
                    ELSE
                        LOOP
                    ENDIF
                ELSE
                    lDone := .T.
                ENDIF
            ELSE
                lReloadDir := .F.
            ENDIF
        ENDIF

        // Time to display the files and act on the response's
        TabUpdate( hScrollBar, nEl, LEN( aFileList ), .T. )
        nCurrent := ACHOICE( aFileMan[ FM_ROWTOP ] + 3, ;
                             aFileMan[ FM_COLTOP ] + 2, ;
                             aFileMan[ FM_ROWBOTTOM ] - 3, ;
                             aFileMan[ FM_COLBOTTOM ] - 4, ;
                             aFileList, .T., "ProcessKey", nEl, nRel )

        nFileItem := nCurrent
        nLastKey  := LASTKEY()

        IF UPPER(CHR(nLastKey)) $ "LCRDPO"
             // They selected a menu item ; move the highlight
             nMenuItem := AT( UPPER(CHR(nLastKey)), "LCRDPO" )
             DisplayMenu()
        ELSE

            // Brackets are not a must
            switch nLastKey

                // Switch type case
                CASE K_RIGHT:
                    nMenuItem++
                    IF nMenuItem > 6
                        TONE( 900, 1 )
                        nMenuItem := 6
                    ENDIF
                    DisplayMenu()

                CASE K_LEFT:
                    nMenuItem--
                    IF nMenuItem < 1
                        TONE( 900, 1 )
                        nMenuItem := 1
                    ENDIF
                    DisplayMenu()

                CASE K_ESC :
                    aFileMan[ FM_RETURNFILE ] := ""
                    lDone := .T.

                CASE K_ENTER:

                    // First let's assign the filename and path to aFileMan
                    aFileMan[ FM_RETURNFILE ] := ;
                                SUBSTR( aFileMan[ FM_PATH ], 1, ;
                                RAT( "\", aFileMan[ FM_PATH ] ) ) + ;
                                TRIM( SUBSTR( aFileList[ nCurrent ], ;
                                1, 12 ) )

                    // Ok, here's the biggee
                    switch(nMenuItem)
                        CASE MN_LOOK:  LookAtFile()
                        CASE MN_COPY:  CopyFile()
                        CASE MN_RENAME:RenameFile()
                        CASE MN_DELETE:DeleteFile()
                        CASE MN_PRINT: PrintFile()
                        CASE MN_OPEN:
                            IF AT( '<dir>', aFileList[ nFileItem ] ) = 0
                                lDone := .T.
                            ELSE
                                LookAtFile()
                            ENDIF

                    endswitch

                CASE K_DEL: DeleteFile()

                CASE K_F5:  TagAllFiles()

                CASE K_F6:  UnTagAllFiles()

                CASE K_SPACE:
                    // Can't tag directories
                    IF AT( "D", SUBSTR( aFileList[ nCurrent ], 43, 6 ) ) ;
                            == 0
                        IF SUBSTR( aFileList[ nCurrent ], 14, 1 ) == " "
                            // It isn't tagged, let's tag it
                            aFileList[ nCurrent ] := ;
                                    STUFF( aFileList[ nCurrent ], ;
                                            14, 1, FM_CHECK )
                            nTagged++
                        ELSE
                            // It's already tagged, let's remove
                            // the check mark
                            aFileList[ nCurrent ] := ;
                            STUFF( aFileList[ nCurrent ], ;
                                  14, 1, " " )
                            nTagged--
                        ENDIF
                    ENDIF

            endswitch
        ENDIF

    ENDDO

    RETURN ( NIL )


// Loadfiles omitted for brevity

/***
*
*  ProcessKey( <nStatus>, <nElement>, <nRelative> ) --> nReturnValue
*
*
*/
FUNCTION ProcessKey( nStatus, nElement, nRelative )

    LOCAL nReturnValue := AC_CONT     // Set the default handler to continue

    // Update the global element/relative with the passed versions
    nEl  := nElement
    nRel := nRelative

    switch(nStatus)
        CASE AC_IDLE:
            // Update the scroll bar
            TabUpdate( hScrollBar, nElement, LEN( aFileList ) )
            Message( aFileMan[ FM_PATH ] )

        CASE AC_HITTOP,AC_HITBOTTOM:
            // Tried to go too far!
            TONE( 900, 1 )

        CASE AC_EXCEPT:

          IF UPPER(CHR(LASTKEY())) $ ;
                "ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890 " .OR. ;
                LASTKEY() == K_DEL .OR. LASTKEY() == K_ENTER .OR. ;
                LASTKEY() == K_F5 .OR. LASTKEY() == K_F6

                nReturnValue := AC_SELECT
          ELSE

              // Keystroke exception
              Switch(Lastkey())
              CASE K_ESC:
                  nReturnValue := AC_ABORT

              CASE K_HOME:
                  KEYBOARD CHR( K_CTRL_PGUP )
                  nReturnValue := AC_CONT

              CASE K_END:
                  KEYBOARD CHR( K_CTRL_PGDN )
                  nReturnValue := AC_CONT

              CASE K_LEFT,K_RIGHT:
                  nReturnValue := AC_SELECT

              ENDSWITCH
          ENDIF

    ENDSWITCH

RETURN ( nReturnValue )

// Message omitted
// GetNewPat omitted
// YesOrNo omitted
// ClearMessage omitted
// ErrorBeep omitted
// CreateScreen omitted

/***
*
*  DisplayMenu() --> NIL
*
*
*/
STATIC FUNCTION DisplayMenu()

    LOCAL cOldColor := SETCOLOR()
    LOCAL nCol        := aFileMan[ FM_COLTOP ] + 2
    LOCAL cItemName

    @ aFileMan[ FM_ROWTOP ] + 1, aFileMan[ FM_COLTOP ] + 2 SAY ;
      "Look  Copy  Rename  Delete  Print  Open"

    SETCOLOR( "I" )

    switch nMenuItem
        CASE MN_LOOK:
            nCol := aFileMan[ FM_COLTOP ] + 2
            cItemName := "Look"

        CASE MN_COPY:
            nCol := aFileMan[ FM_COLTOP ] + 8
            cItemName := "Copy"

        CASE MN_RENAME:
            nCol := aFileMan[ FM_COLTOP ] + 14
            cItemName := "Rename"

        CASE MN_DELETE:
            nCol := aFileMan[ FM_COLTOP ] + 22
            cItemName := "Delete"

        CASE MN_PRINT:
            nCol := aFileMan[ FM_COLTOP ] + 30
            cItemName := "Print"

        CASE MN_OPEN:
            nCol := aFileMan[ FM_COLTOP ] + 37
            cItemName := "Open"

    ENDSWITCH

    @ aFileMan[ FM_ROWTOP ] + 1, nCol SAY cItemName

    Message( aFileMan[ FM_PATH ] )

    SETCOLOR( cOldColor )

    RETURN ( NIL )

// Remainder of file omitted for brevity
