/* Modified by Shamim Islam to demonstrate switch45.ch, switch45.obj        */
/* NOTE: Switch assumes non C_LIKE syntax unless this macro is defined  */
/* Therefore there is no need for a break between individual cases      */
/* Please see switch v4.5 documentation (current revision level) for    */
/* more information                                                     */
/*                                                                      */
/* Original routine: copyright (c) CA Intl (sample directory)           */
/*                                                                      */
#include "switch45.ch"
/*                                                                      */
/* Switch is only compatible with Clipper v5.0 and above                */
/* Non C_LIKE demo                                                      */

#include "Inkey.ch"

PROCEDURE GaugDemo
   
    LOCAL i
    LOCAL hGauge
    LOCAL nPercent

    CLS
    SET CURSOR OFF

    hGauge := GaugeNew( 5, 5, 7, MAXCOL() - 5, "W/B", "W+/B" )
    GaugeDisplay( hGauge )

    SETCOLOR( "W+/N" )
    @ 1,0 SAY PADC( "Gauge Demo", MAXCOL() )

    SETCOLOR( "W/N" )
    @ 3,0 SAY PADC( "Use , , PgUp and PgDn to change gauge, Esc to exit", MAXCOL() )

    nPercent := 0

    i := 0
    DO WHILE i <> K_ESC

        switch i:=INKEY(0)
            CASE K_UP  :nPercent += .01
            CASE K_DOWN:nPercent -= .01
            CASE K_PGUP:nPercent += .1
            CASE K_PGDN:nPercent -= .1
        enswitch

        // Ensure that nPercent is within bounds
        IF nPercent < 0
            TONE(300, 1)
            nPercent := 0
        ENDIF

        IF nPercent > 1
            TONE(300, 1)
            nPercent := 1
        ENDIF

        GaugeUpdate( hGauge, nPercent )

    ENDDO

    SET CURSOR ON
    SETPOS( MAXROW(), 0 )

RETURN
