/* SWITCH.CH Version 6.0 by Shamim Islam, December 15, 1994

   Switch command similar to C switch(), and pascal Case Of structures.
   This code is public domain (Refer to SWITCH60.DOC for more info)

   Requires Clipper 6.0 or better.
   Requires SWITCH60.LIB to be linked in for Modular support.
   Requires no ancillary code with INLINE option.

   Before including this header:
       #define C_LIKE for C_LIKE syntax
       #define SWITCH_INLINE for INLINE Switch control

   #define DEFAULT_SWITCH_INLINE  in this header to use INLINE Switch
       control by default.

   Caveat: The following code is cryptic by design to keep nosy fingers
           from mucking with the algorithm, and to prevent name collisions.
*/

// Uncomment the following for INLINE Switch control by default
// #define DEFAULT_SWITCH_INLINE

// Modify the following at your own risk
#ifndef _SWITCH_CH
#define _SWITCH_CH 1
#ifdef DEFAULT_SWITCH_INLINE
#ifndef SWITCH_MODULAR
#undef __SWITCHMOD__
#else
#define __SWITCHMOD__
#endif
#else
#ifndef SWITCH_INLINE
#define __SWITCHMOD__
#else
#undef __SWITCHMOD__
#endif
#endif
#define SWTERMREQ 0
#define SWEXITREQ 1
#define SWLOOPREQ 2
#xcom swbreak => switchbreak
#xcom swloop => switchloop
#xcom switchbreak => exit
#xcom swexit => switchexit
#xcom swreturn<*_*> => switchreturn<_>
#ifdef __SWITCHMOD__
#xtra switchvalue([<_>]) => __vswitch(<_>)
#xcom CLEARSWITCH => __zswitch()
#ifdef C_LIKE
#xcom switch<*_*> => __iswitch(<_>)
#xcom { => while.t.;if.t.
#xcom {{ => while.t.;if.t.
#xcom case<__,...>:[<*_*>] => end;if __cswcpl({<__>})[;<_>]
#xcom case<__>,,<___>:[<*_*>] => end;if __cswcp2(<__>,<___>)[;<_>]
#xcom case<__>:[<*_*>] => end; if __cswcp1(<__>)[;<_>]
#xcom default:[<*_*>] => end;if.t.[;<_>]
#xcom } => end;exit;end;__cswitch()
#xcom }} => end;exit;end;do case;case __gswitch()==SWLOOPREQ;;
__cswitch();loop;case __gswitch;()==SWEXITREQ;__cswitch();exit;
;otherwise;__cswitch();end
#else
#xcom switch<*_*> => __iswitch(<_>);while.t.;do case
#xcom case<__,...>:[<*_*>] => case __swcpl({<__>})[;<_>]
#xcom case<__>,,<___>:[<*_*>] => case __swcp2(<__>,<___>)[;<_>]
#xcom case<__>:[<*_*>] => case __swcp1(<__>)[;<_>]
#xcom default:[<*_*>] => otherwise[;<_>]
#xcom end switch => endswitch
#xcom endswitch => end;exit;end;__cswitch()
#xcom end switchloop => endswitchloop
#xcom endswitchloop => end;exit;end;do case;case __gswitch()==;
SWLOOPREQ;__cswitch();loop;case __gswitch()==SWEXITREQ;__cswitch();
;exit;otherwise;__cswitch();end
#endif
#xcom switchreturn<*_*> => __cswitch();return<_>
#xcom switchloop => __eswitch(SWLOOPREQ);exit
#xcom switchexit => __eswitch(SWEXITREQ);exit
#else
static _5:={},_7:=0,_8:={},_9:=NIL
#xtra switchvalue() => if(_7>0,_5\[_7\],NIL)
#xtra switchvalue(<_>) => if(_7==0,NIL,eval({|x|_9:=_5\[_7\],_5;
\[_7\]:=x,_9},<_>))
#ifdef C_LIKE
#xcom CLEARSWITCH => _5:={};_7:=0;_8:={};_6:={}
static _6:={}
#xcom switch<*_*> => aadd(_5,<_>)
#xcom { => aadd(_6,.f.);aadd(_8,0);_7++;while.t.;if.t.
#xcom {{ => aadd(_6,.f.);aadd(_8,0);_7++;while.t.;if.t.
#xcom case<__,...>:[<*_*>] => end;if _6\[_7\].or.ascan({<__>},_5;
\[_7\])!=0;_6\[_7\]:=.t.[;<_>]
#xcom case<__>,,<___>:[<*_*>] => end;if _6\[_5\[1\]\].or.if(<__>\<;
<___>,<__>\<=_5\[_7\].and._5\[_7\]\<=<___>,<___>\<=_5\[_7\].and._5;
\[_7\]\<=<__>);_6\[_7\]:=.t.[;<_>]
#xcom case<__>:[<*_*>] => end;if _6\[_7\].or._5\[_7\]==<__>;_6\[_7;
\]:=.t.[;<_>]
#xcom default:[<*_*>] => end;if.t.[;<_>]
#xcom } => end;exit;end;asize(_5,--_7);asize(_6,_7);asize(_8,_7);;
memory("")
#xcom }} => end;exit;end;asize(_5,--_7);asize(_6,_7);memory("");;
do case;case _8\[_7+1\]==SWLOOPREQ;asize(_8,_7);memory("");loop;;
case _8\[_7+1\]==SWEXITREQ;asize(_8,_7);memory("");exit;otherwise;
;asize(_8,_7);memory("");end
#xcom switchreturn<*_*> => asize(_5,--_7);asize(_6,_7);asize(_8,_7;
);memory("");return<_>
#else
#xcom CLEARSWITCH => _5:={};_7:=0;_8:={}
#xcom switch<*_*> => aadd(_5,<_>);_7++;aadd(_8,0);while.t.;do case
#xcom case<__,...>:[<*_*>] => case ascan({<__>},_5\[_7\])!=0[;<_>]
#xcom case<__>,,<___>:[<*_*>] => case if(<__>\<<___>,<__>\<=_5\[_7;
\].and._5\[_7\]\<=<___>,<___>\<=_5\[_7\].and._5\[_7\]\<=<__>)[;<_>]
#xcom case<__>:[<*_*>] => case _5\[_7\]==<__>[;<_>]
#xcom default:[<*_*>] => otherwise[;<_>]
#xcom end switch => endswitch
#xcom endswitch => end;exit;end;asize(_5,--_7);asize(_8,_7);memory("")
#xcom end switchloop => endswitchloop
#xcom endswitchloop => end;exit;end;asize(_5,--_7);memory("");do case;
;case _8\[_7+1\]==SWLOOPREQ;asize(_8,_7);memory("");loop;case _8\[_7+;
1\]==SWEXITREQ;asize(_8,_7);memory("");exit;otherwise;asize(_8,_7);;
memory("");end
#xcom switchreturn<*_*> => asize(_5,--_7);asize(_8,_7);memory("");
;return<_>
#endif
#xcom switchloop => _8\[_7\]:=SWLOOPREQ;exit
#xcom switchexit => _8\[_7\]:=SWEXITREQ;exit
#endif
#endif
