$IF %IO.DIRECT ' The following IO subroutines are for direct hardware access

SUB BOZOPRINT (X$)
        PRINT X$;
END SUB


FUNCTION BOZOINPUT$
        LINE INPUT X$
        BOZOINPUT$=X$
END FUNCTION


FUNCTION BOZOINKEY$
        BOZOINKEY$=INKEY$
END FUNCTION


SUB BOZOCLS
	CLS
END SUB


SUB BOZOLOCATE(Row%, Col%)
	LOCATE Row%, Col%
END SUB


SUB BOZOCOLOR (Fg%, Bg%)
	COLOR Fg%, Bg%
END SUB

FUNCTION BOZOCSRLIN
	BOZOCSRLIN=CSRLIN
END FUNCTION

FUNCTION BOZOPOS
	BOZOPOS=POS(0)
END FUNCTION


$ENDIF

$IF %IO.BIOS

SUB BOZOLOCATE (Row%, Col%)
        REG 1, &H0200  ' AH contains function 2 = set cursor position
        REG 2, 0       ' BX contains text page 0
        REG 4, ((Row%+1) * 256) + (Col%+1)  ' DX contains coordinates
        CALL INTERRUPT &H10 ' call BIOS
END SUB

SUB BOZOCOLOR (Fg%, Bg%)
        SHARED Attribute%
        Attribute% = (Bg% * 16) + Fg%
END SUB

SUB BOZOPRINT (X$)
        SHARED Attribute%
        IF Attribute%=0 THEN Attribute%=&H07
        FOR Character% = 1 TO LEN(X$)
                C$=MID$(X$,Character%, 1)
                IF C$=CHR$(13) THEN
                	CR
                ELSE
	        	REG 2, Attribute%  ' set color for next write
        		REG 3, 1           ' set repeat rate per char to 1
                	REG 1, &H0900 + ASCII(C$)
                	CALL INTERRUPT &H10
                	CALL BIOS.ADVANCE.CURSOR
                END IF
        NEXT Character%
END SUB

FUNCTION BOZOINPUT$ (Prompt$)
IF LEN(Prompt$) THEN BIOSPRINT Prompt$
        I$=""
        DO
                K$=BOZOINKEY$
                IF K$=CHR$(13) THEN EXIT DO
                IF LEN(K$)=1 THEN I$=I$+K$:BOZOPRINT K$
                ' add possible hot key checks here
        LOOP
        CR      ' carriage return
BOZOINPUT$=I$
END

FUNCTION BOZOINKEY$
        REG 1, 0 ' AX = keyboard BIOS function 0, read character
        CALL INTERRUPT &H16 ' call keyboard BIOS
        AL%=(REG(1) AND &HFF)
        IF AL%=0 THEN BOZOINKEY$="" ELSE BOZOINKEY$=CHR$(AL%)
END FUNCTION

SUB BIOS.ADVANCE.CURSOR
SHARED Attribute%
	' get cursor position
        REG 1, &H0300
        REG 2, 0
        CALL INTERRUPT &H10
        Row% = REG(4) \ 256
        Col% = (REG(4) AND &HFF)


        ' establish new cursor position and scroll if necessary
        INCR Col%
        IF Col%=80 THEN
        	Col%=0
                INCR Row%
                IF Row%=24 THEN
                	Row%=23
                        ' Scroll window up
                        REG 1, &H0601
                        REG 2, Attribute%
                        REG 3, 0
                        REG 4, (23 * 256) + 79
                        CALL INTERRUPT &H10
                END IF
        END IF

        ' locate new cursor position

        REG 1, &H0200  ' AH contains function 2 = set cursor position
        REG 2, 0       ' BX contains text page 0
        REG 4, (Row% * 256) + Col%  ' DX contains coordinates
        CALL INTERRUPT &H10 ' call BIOS

END SUB

SUB CR
	SHARED Attribute%
	' simulates a carriage return
	' get cursor position
        REG 1, &H0300
        REG 2, 0
        CALL INTERRUPT &H10
        Row% = REG(4) \ 256
        Col% = (REG(4) AND &HFF)


        ' establish new cursor position and scroll if necessary
	Col%=0
        INCR Row%
        IF Row%=24 THEN
          	Row%=23
                ' Scroll window up
                REG 1, &H0601
                REG 2, Attribute%*256
                REG 3, 0
                REG 4, (23 * 256) + 79
                CALL INTERRUPT &H10
        END IF

        ' locate new cursor position

        REG 1, &H0200  ' AH contains function 2 = set cursor position
        REG 2, 0       ' BX contains text page 0
        REG 4, (Row% * 256) + Col%  ' DX contains coordinates
        CALL INTERRUPT &H10 ' call BIOS
END SUB

SUB BOZOCLS
SHARED Attribute%
	' scroll function with 0 in AL makes CLS
        REG 1, &H0600
        REG 2, Attribute%*256  ' clear with this attribute
        REG 3, 0
        REG 4, (23 * 256) + 79 ' using 23 protects line 25
                                       ' change to 24 for full screen cls
        CALL INTERRUPT &H10

        ' locate new cursor position
        REG 1, &H0200  ' AH contains function 2 = set cursor position
        REG 2, 0       ' BX contains text page 0
        REG 4, 0 ' DX contains coordinates 0,0 (or 1,1)
        CALL INTERRUPT &H10 ' call BIOS
END SUB
$ENDIF

$IF %IO.ANSI

SUB BOZOCLS
CALL BOZOPRINT(CHR$(27) + "[2J" + CHR$(27) + "[;f")
END SUB

SUB BOZOLOCATE (row%, col%)
CALL BOZOPRINT(CHR$(27) + "[" + MID$(STR$(row%), 2) + ";" + MID$(STR$(col%), 2) + "f")
END SUB

SUB BOZOCOLOR (fg%, bg%)
CALL BOZOPRINT(CHR$(27) + "[" + MID$(STR$(fg%), 2) + ";" + MID$(STR$(bg%), 2) + "m")
END SUB

SUB BOZOPrint(Oput$)

For i%=1 to len(Oput$)
	Reg 1,&h200
	Reg 4,asc(Mid$(OPut$,i%,1))
	CALL INTERRUPT &H21
Next i%
END SUB


FUNCTION BOZOINPUT$
        DO
        	C$=BOZOINKEY$
                IF C$=CHR$(13) THEN EXIT DO
                IF LEN(C$) THEN BOZOPRINT C$
                X$=X$+C$
	LOOP
        BOZOPRINT CrLf$
        BOZOINPUT$=X$
END FUNCTION


FUNCTION BOZOINKEY$
       ' REG 1, &H0600 ' DOS function 6, direct character input no echo
	'REG 4, &HFF
        'CALL INTERRUPT &H21
        'Flags%=REG(0)
        'IF BIT(Flags%,6) THEN BOZOINKEY$=CHR$(REG(1) AND &HFF)
        BOZOINKEY$=INKEY$
END FUNCTION

$ENDIF