DECLARE SUB QuitFunctions (xk%)
DECLARE SUB BrowseRecords (krs%, ky$, rec$, status%)
DECLARE SUB RecordFunctions (xk%)
DECLARE SUB PrintFunctions (xk%)
DECLARE SUB MiscFunctions (xk%)
DECLARE SUB FileFunctions (xk%)
DECLARE SUB Display (rec$)
DECLARE SUB Help ()
DECLARE SUB FindRecord (krs%, ky$, rec$, status%)
DECLARE SUB AddRecord (krs%, ky$, rec$, status%)
DECLARE SUB DeleteRecord (krs%, ky$, rec$, status%)
DECLARE SUB ChangeRecord (krs%, ky$, rec$, status%)
DECLARE SUB PrintML1 (rec$)
DECLARE SUB PrintML0 ()
DECLARE SUB PrintML9 ()
DECLARE SUB PrintML2 (rec$)
DECLARE SUB ReIndexFile ()
DECLARE SUB CloseFiles ()
DECLARE SUB OpenFiles ()
' IMDEMO.BAS   by  Marty Francom
' This program is demonstrates the use of Index Manager. Each index record
' consists of a key and a pointer to the data file. Such that the key file
' record (KyF$) is defined:
'  ky$ = KeyString$   rn& = Pointer to data record   krs% = KeyRecordSet
'  Rec$= DataRecord   Rfn%= data record file number  Rfl%= Data record Length
'
' For the purpose of this demo I open only 1 index and data file however
' it is a simple matter to open additional index and data files.
DECLARE FUNCTION ColorAttribute% (row%, col%)
DECLARE FUNCTION CurToDollar$ (Cur@, L%)
DECLARE FUNCTION DayOfWeek$ ()
DECLARE FUNCTION FILEXISTS% (FILNAM$)
DECLARE FUNCTION GetBackGround% (row%, col%)
DECLARE FUNCTION GetForeGround% (row%, col%)
DECLARE FUNCTION GetVideoSegment& ()
DECLARE FUNCTION IntgrToDollar$ (Intgr&, L%)
DECLARE FUNCTION KeyIn% ()
DECLARE FUNCTION NumDays& (dt1$, dt2$)
DECLARE FUNCTION NumToString$ (n#, dp%, Ln%)
DECLARE SUB Cdate (dt$)
DECLARE SUB DateEdit (row%, col%, colr%, vk$, dt$, xk%)
DECLARE SUB FastPrint (row%, col%, st$, colr%)
DECLARE SUB EditField (row%, col%, colr%, vk$, st$, xk%)
DECLARE SUB Julian (dt$)
DECLARE SUB PhoneEdit (row%, col%, colr%, vk$, pn$, xk%)
DECLARE SUB PopWindow (TopRow%, LeftCol%, BottomRow%, RightCol%, colr%)
DECLARE SUB PutScreen (file$)
DECLARE SUB RestoreScrn (Scrn$)
DECLARE SUB SaveScrn (Scrn$)
DECLARE SUB Wipe (top%, bottom%, lft%, rght%, colr%)

DECLARE SUB AddKeyRec (krs%, ky$, rec$, rn&, status%)
DECLARE SUB CreateOpenClose (krs%)
DECLARE SUB DeleteKeyRec (krs%, ky$, rec$, status%)
DECLARE SUB GetEqual (krs%, ky$, rec$, rn&, status%)
DECLARE SUB GetNext (krs%, ky$, rec$, status%)
DECLARE SUB GetPrev (krs%, ky$, rec$, status%)
DECLARE SUB IndexError (rc%)
DECLARE SUB Info (krs%, xn%, kl%, Rfn%, Rfl%)
'
' Link in the Index Manager subprogram
DECLARE SUB im (ndx%, opcode$, ndxfn$, keylen%, ky$, datarn&, rc%)
$LINK "IMOB.OBJ"                 ' this must be in main program
$LINK "C:\PB3\UNIT\MYLIB.PBU"    '  "    "   "  "   "      "
' IMOB.OBJ is an assembly language B-Tree index manager for PowerBasic. As
'many as 10 index files can be opened, manipulated and maintained all at the
'same time. IMOB.OBJ is copyright of FRED LEPOW of CDP Consultants. Several
'versions of IMOB.OBJ are available. For further Information about Index
'Manager contact Fred Lepow at:
'                     CDP Consultants
'                     1700 Circo Del Cielo Drive
'                     El Cajon, CA.   90202
'                     (619) 440-6482

'           Required for Index Manager
DIM xn as shared integer
DIM kl as shared integer
DIM Rfn as shared integer
DIM Rfl as shared integer
DIM ky as shared string
'DIM Rec as shared string
DIM status as shared integer

' ******************* Beginning Main Program Code **********************
CLS
CALL PutScreen("MailList.Img")
'krs% = 3: CALL CreateOpenClose(krs%)  'contains pointers to deleted records
krs% = 2: CALL CreateOpenClose(krs%)  'Zip+Name Index
krs% = 1: CALL CreateOpenClose(krs%)  'Name Index + Data Record
xk% = -20
DO
  LOCATE 1, 1, 0
  IF xk% = 0 THEN CALL Display(rec$): xk% = KeyIn%
  SELECT CASE xk%
    CASE -59  'F1 key
      CALL Help: xk% = 0
    CASE 102, 70, -20, -18, -33, -25, -49, -48, -72, -80   'Ff
      IF xk% = 102 OR xk% = 70 THEN CALL FileFunctions(xk%)
      SELECT CASE (xk%)
        CASE -18  'Alt E  goto end of file
          ky$ = STRING$(kl%, 254)
          CALL GetEqual(krs%, ky$, rec$, rn&, status%): xk% = 0
        CASE -20  'Alt T  goto top of file
          ky$ = STRING$(kl%, 32)
          CALL GetEqual(krs%, ky$, rec$, rn&, status%): xk% = 0
        CASE -33  'Alt F  Find a record
          CALL FindRecord(krs%, ky$, rec$, status%): xk% = 0
        CASE -48  'Alt B  browse records
          CALL BrowseRecords(krs%, ky$, rec$, status%): xk% = 0
        CASE -25, -72  'Alt P  UpArrow   get previous record
          CALL GetPrev(krs%, ky$, rec$, status%): xk% = 0
        CASE -49, -80  'Alt N  DnArrow   get next record
          CALL GetNext(krs%, ky$, rec$, status%): xk% = 0
      END SELECT
    CASE 114, 82, -30, -32, -46
      IF xk% = 114 OR xk% = 82 THEN CALL RecordFunctions(xk%)
      SELECT CASE (xk%)
        CASE -30  'Alt A  Add a record
          CALL AddRecord(krs%, ky$, rec$, status%): xk% = 0
          CALL PutScreen("MailList.IMG")
        CASE -32  'Alt D  Delete current record
          CALL DeleteRecord(krs%, ky$, rec$, status%): xk% = 0
          CALL PutScreen("MailList.IMG")
        CASE -46  'Alt C  Change/Edit current record
          CALL ChangeRecord(krs%, ky$, rec$, status%): xk% = 0
          CALL PutScreen("MailList.IMG")
      END SELECT
    CASE 112, 80, -120, -121, -122, -123
      IF xk% = 112 OR xk% = 80 THEN CALL PrintFunctions(xk%)
      SELECT CASE (xk%)
        CASE -120  ' Alt 1  Print current record to mailing label
          CALL PrintML1(rec$): xk% = 0
        CASE -129  ' Alt 0  Print mailing labels of all records
          CALL PrintML0: xk% = 0
        CASE -121  ' Alt 2  Print mailing labels by zip code
          CALL PrintML9: xk% = 0
        CASE -128  ' Alt 9  Print hard copy of current record
          CALL PrintML2(rec$): xk% = 0
      END SELECT
    CASE 109, 77
       CALL MiscFunctions(xk%)
       SELECT CASE (xk%)
         CASE -10  ' ReIndex Current Data File
           CALL ReIndexFile: xk% = 0
         CASE -11  ' Create New Data File & Index
           CALL CloseFiles: xk% = 0
         CASE -12  ' Load New Data File & Index
           CALL OpenFiles: xk% = 0
       END SELECT
    CASE 113, 81, -16, 27
      CALL QuitFunctions(xk%)
      IF xk% = -16 THEN
        CALL CloseFiles: EXIT DO
      END IF
    CASE ELSE
      BEEP: xk% = 0
  END SELECT
LOOP
CLS : END

SUB AddRecord (krs%, ky$, rec$, status%)
  st$ = "MailList.Img": CALL PutScreen(st$)
  new$ = SPACE$(683): cn% = 1
  DO
    SELECT CASE cn%
      CASE 1
        st$ = MID$(new$, 2, 28)
        xk% = 11: CALL EditField(6, 20, 79, "", st$, xk%)
        MID$(new$, 2, 16) = st$
      CASE 2
        st$ = MID$(new$, 31, 30)
        xk% = 11: CALL EditField(8, 20, 79, "", st$, xk%)
        MID$(new$, 31, 30) = st$
      CASE 3
        st$ = MID$(new$, 61, 30)
        xk% = 11: CALL EditField(10, 20, 79, "", st$, xk%)
        MID$(new$, 61, 30) = st$
      CASE 4
        st$ = MID$(new$, 91, 14)
        xk% = 11: CALL EditField(12, 20, 79, "", st$, xk%)
        MID$(new$, 91, 14) = st$
      CASE 5
        st$ = MID$(new$, 105, 2)
        xk% = 11: CALL EditField(12, 45, 79, "", st$, xk%)
        MID$(new$, 105, 2) = st$
      CASE 6
        st$ = MID$(new$, 107, 5)
        xk% = 2: CALL EditField(12, 58, 79, "", st$, xk%)
        MID$(new$, 107, 5) = st$
        st$ = MID$(new$, 112, 4)
        xk% = 2: CALL EditField(12, 64, 79, "", st$, xk%)
        MID$(new$, 112, 4) = st$
      CASE 7
        st$ = MID$(new$, 116, 3)
        xk% = 2: CALL EditField(14, 21, 79, "", st$, xk%)
        MID$(new$, 116, 3) = st$
        st$ = MID$(new$, 119, 3)
        xk% = 2: CALL EditField(14, 26, 79, "", st$, xk%)
        MID$(new$, 119, 3) = st$
        st$ = MID$(new$, 122, 4)
        xk% = 2: CALL EditField(14, 30, 79, "", st$, xk%)
        MID$(new$, 122, 4) = st$
      CASE 8
        st$ = MID$(new$, 126, 62)
        xk% = 1: CALL EditField(16, 10, 79, "", st$, xk%)
        MID$(new$, 126, 62) = st$
      CASE 9
        st$ = MID$(new$, 188, 62)
        xk% = 1: CALL EditField(17, 10, 79, "", st$, xk%)
        MID$(new$, 188, 62) = st$
      CASE 10
        st$ = MID$(new$, 250, 62)
        xk% = 1: CALL EditField(18, 10, 79, "", st$, xk%)
        MID$(new$, 250, 62) = st$
      CASE 11
        st$ = MID$(new$, 312, 62)
        xk% = 1: CALL EditField(19, 10, 79, "", st$, xk%)
        MID$(new$, 312, 62) = st$
      CASE 12
        st$ = MID$(new$, 374, 62)
        xk% = 1: CALL EditField(20, 10, 79, "", st$, xk%)
        MID$(new$, 374, 62) = st$
      CASE 13
        st$ = MID$(new$, 436, 62)
        xk% = 1: CALL EditField(21, 10, 79, "", st$, xk%)
        MID$(new$, 436, 62) = st$
      CASE 14
        st$ = MID$(new$, 498, 62)
        xk% = 1: CALL EditField(22, 10, 79, "", st$, xk%)
        MID$(new$, 498, 62) = st$
      CASE 15
        st$ = MID$(new$, 560, 62)
        xk% = 1: CALL EditField(23, 10, 79, "", st$, xk%)
        MID$(new$, 560, 62) = st$
      CASE 16
        st$ = MID$(new$, 622, 62)
        xk% = 1: CALL EditField(24, 10, 79, "", st$, xk%)
        MID$(new$, 622, 62) = st$
    END SELECT
    IF xk% = 27 THEN
     CALL SaveScrn(Scrn$)
     CALL PopWindow(3, 30, 5, 52, 78)
     st$ = "Save Record? (Y/n)": CALL FastPrint(4, 31, st$, 78)
     DO
       xk% = 22: st$ = "Y": CALL EditField(4, 50, 79, "YyNn", st$, xk%)
       IF (xk% = 13 AND st$ <> "Y") OR xk% = 27 THEN EXIT DO
       IF xk% = 13 THEN
         tb% = 32: rec$ = new$: ky$ = MID$(rec$, 2, 28) + CHR$(tb%)
         DO
           CALL AddKeyRec(krs%, ky$, rec$, rn&, status%)
           IF status% = 109 THEN
             IF tb% > 253 THEN EXIT SUB
             tb% = tb% + 1:  ky$ = MID$(rec$, 2, 28) + CHR$(tb%)
           END IF
         LOOP UNTIL status% = 0
         krs1% = krs%
         ky2$ = MID$(rec$, 107, 5) + ky$
         krs% = krs1% + 1: CALL AddKeyRec(krs%, ky2$, "", rn&, status%)
         CALL CreateOpenClose(krs%)
         krs% = krs1%: CALL CreateOpenClose(krs%)
       END IF
     LOOP UNTIL status% = 0
     CALL RestoreScrn(Scrn$)
     EXIT SUB
    END IF
    IF xk% = -72 AND cn% > 1 THEN cn% = cn% - 1
    IF (xk% = -80 OR xk% = 13) AND cn% < 16 THEN cn% = cn% + 1
  LOOP
END SUB

SUB BrowseRecords (krs%, ky$, rec$, status%)
  CALL SaveScrn(Scrn$)
  CALL PopWindow(8, 7, 23, 73, 78)
  st$ = " Press  Up/Dn  PgUp/PgDn  to Move Thru File ": CALL FastPrint(23, 13, st$, 78)
  DO
    GOSUB BrowseDisplay
    LOCATE 23, 26, 0: xk% = KeyIn%
    IF xk% = -72 THEN
      CALL GetPrev(krs%, ky$, rec$, status%)
      IF status% <> 0 THEN CALL IndexError(status%)
    END IF
    IF xk% = -80 THEN
      CALL GetNext(krs%, ky$, rec$, status%)
      IF status% <> 0 THEN CALL IndexError(status%)
    END IF
    IF xk% = -73 THEN
      FOR c% = 1 TO 14
        CALL GetPrev(krs%, ky$, rec$, status%)
      NEXT
    END IF
    IF xk% = -81 THEN
      FOR c% = 1 TO 14
        CALL GetNext(krs%, ky$, rec$, status%)
      NEXT
    END IF
  LOOP UNTIL xk% = 27
  ky$ = bky$: rec$ = ""
  CALL GetEqual(krs%, ky$, rec$, rn&, status%)
  CALL RestoreScrn(Scrn$)
  EXIT SUB

BrowseDisplay:
  bky$ = MID$(rec$, 2, 29)
  FOR b% = 9 TO 22
    st$ = MID$(rec$, 2, 28) + MID$(rec$, 91, 14)
    st$ = st$ + " " + MID$(rec$, 107, 5) + " (" + MID$(rec$, 116, 3) + ") "
    st$ = st$ + MID$(rec$, 119, 3) + "-" + MID$(rec$, 122, 4)
    CALL FastPrint(b%, 9, st$, -1)
    CALL GetNext(krs%, ky$, rec$, status%)
    IF status% = 116 THEN rec$ = SPACE$(683)
  NEXT b%
  CALL GetEqual(krs%, bky$, rec$, rn&, status%)
 RETURN
END SUB

SUB ChangeRecord (krs%, ky$, rec$, status%)
  cn% = 2:
  CALL GetEqual(krs%, ky$, new$, rn&, status%)
  IF status% <> 0 THEN EXIT SUB
  DO
    SELECT CASE cn%
      'CASE 1
      '  st$ = MID$(new$, 2, 28)
      '  xk% = 12: CALL EditField(6, 20, 79, "", st$, xk%)
      '  MID$(new$, 2, 16) = st$
      CASE 2
        st$ = MID$(new$, 31, 30)
        xk% = 11: CALL EditField(8, 20, 79, "", st$, xk%)
        MID$(new$, 31, 30) = st$
      CASE 3
        st$ = MID$(new$, 61, 30)
        xk% = 11: CALL EditField(10, 20, 79, "", st$, xk%)
        MID$(new$, 61, 30) = st$
      CASE 4
        st$ = MID$(new$, 91, 14)
        xk% = 11: CALL EditField(12, 20, 79, "", st$, xk%)
        MID$(new$, 91, 14) = st$
      CASE 5
        st$ = MID$(new$, 105, 2)
        xk% = 11: CALL EditField(12, 45, 79, "", st$, xk%)
        MID$(new$, 105, 2) = st$
      CASE 6
        st$ = MID$(new$, 107, 5)
        xk% = 2: CALL EditField(12, 58, 79, "", st$, xk%)
        MID$(new$, 107, 5) = st$
        st$ = MID$(new$, 112, 4)
        xk% = 2: CALL EditField(12, 64, 79, "", st$, xk%)
        MID$(new$, 112, 4) = st$
      CASE 7
        st$ = MID$(new$, 116, 3)
        xk% = 2: CALL EditField(14, 21, 79, "", st$, xk%)
        MID$(new$, 116, 3) = st$
        st$ = MID$(new$, 119, 3)
        xk% = 2: CALL EditField(14, 26, 79, "", st$, xk%)
        MID$(new$, 119, 3) = st$
        st$ = MID$(new$, 122, 4)
        xk% = 2: CALL EditField(14, 30, 79, "", st$, xk%)
        MID$(new$, 122, 4) = st$
      CASE 8
        st$ = MID$(new$, 126, 62)
        xk% = 1: CALL EditField(16, 10, 79, "", st$, xk%)
        MID$(new$, 126, 62) = st$
      CASE 9
        st$ = MID$(new$, 188, 62)
        xk% = 1: CALL EditField(17, 10, 79, "", st$, xk%)
        MID$(new$, 188, 62) = st$
      CASE 10
        st$ = MID$(new$, 250, 62)
        xk% = 1: CALL EditField(18, 10, 79, "", st$, xk%)
        MID$(new$, 250, 62) = st$
      CASE 11
        st$ = MID$(new$, 312, 62)
        xk% = 1: CALL EditField(19, 10, 79, "", st$, xk%)
        MID$(new$, 312, 62) = st$
      CASE 12
        st$ = MID$(new$, 374, 62)
        xk% = 1: CALL EditField(20, 10, 79, "", st$, xk%)
        MID$(new$, 374, 62) = st$
      CASE 13
        st$ = MID$(new$, 436, 62)
        xk% = 1: CALL EditField(21, 10, 79, "", st$, xk%)
        MID$(new$, 436, 62) = st$
      CASE 14
        st$ = MID$(new$, 498, 62)
        xk% = 1: CALL EditField(22, 10, 79, "", st$, xk%)
        MID$(new$, 498, 62) = st$
      CASE 15
        st$ = MID$(new$, 560, 62)
        xk% = 1: CALL EditField(23, 10, 79, "", st$, xk%)
        MID$(new$, 560, 62) = st$
      CASE 16
        st$ = MID$(new$, 622, 62)
        xk% = 1: CALL EditField(24, 10, 79, "", st$, xk%)
        MID$(new$, 622, 62) = st$
    END SELECT
    IF xk% = 27 THEN
     CALL PopWindow(3, 30, 5, 55, 78)
     st$ = "Save Changes? (Y/n)": CALL FastPrint(4, 32, st$, 78)
     DO
       xk% = 22: st$ = "Y": CALL EditField(4, 53, 79, "YyNn", st$, xk%)
       IF (xk% = 13 AND st$ <> "Y") OR xk% = 27 THEN EXIT DO
       IF xk% = 13 THEN
         CALL Info(krs%, xn%, kl%, Rfn%, Rfl%)
         IF LEN(new$) < Rfl% THEN new$ = new$ + SPACE$(Rfl% - LEN(new$))
         PUT #Rfn%, rn&, new$: rec$ = new$: EXIT DO
       END IF
     LOOP
     EXIT SUB
    END IF
    IF xk% = -72 AND cn% > 2 THEN cn% = cn% - 2
    IF (xk% = -80 OR xk% = 13) AND cn% < 12 THEN cn% = cn% + 1
  LOOP

END SUB

SUB CloseFiles
 'krs% = -3: CreateOpenClose (krs%)  'Not being used
 krs% = -2: CreateOpenClose (krs%)
 krs% = -1: CreateOpenClose (krs%)
END SUB

SUB CreateOpenClose (krs%) 'public
  IF krs% > 100 AND krs% < 105 THEN GOSUB CreateFile: EXIT SUB
  IF krs% > 0 AND krs% < 5 THEN GOSUB OpenFile: EXIT SUB
  IF krs% < 0 AND krs% > -5 THEN GOSUB CloseFile: EXIT SUB
  EXIT SUB

  ' Close key-record files (if open)
CloseFile:
  ' get information about key-record-set (krs%)
  krs% = ABS(krs%)
  CALL Info(krs%, xn%, kl%, Rfn%, Rfl%)
  fc$ = "C": CALL im(xn%, fc$, ifn$, kl%, ky$, rn&, rc%)
  IF rc% <> 0 THEN CALL IndexError(rc%)
  CLOSE Rfn%
  xn% = 0: kl% = 0: Rfn% = 0: Rfl% = 0
  ' store information about key-record-set (krs%)
  S% = -1 * krs%: CALL Info(S%, xn%, kl%, Rfn%, Rfl%)
 RETURN

  ' Open key-record file (if not already open)
OpenFile:
  ' get information about key-record-set (krs%)
  CALL Info(krs%, xn%, kl%, Rfn%, Rfl%)
  ' If key/data records open close first then re-open
  IF xn% <> 0 THEN GOSUB CloseFile
  IF krs% = 1 THEN xn% = 1: ifn$ = "ML1.ndx": kl% = 29: df$ = "ML1.Dat": Rfl% = 683
  IF krs% = 2 THEN xn% = 2: ifn$ = "ML2.ndx": kl% = 34: df$ = "": Rfl% = 0
  IF krs% = 3 THEN xn% = 3: ifn$ = "ML3.ndx": kl% = 7: df$ = "": Rfl% = 0
  fc$ = "O": CALL im(xn%, fc$, ifn$, kl%, ky$, rn&, rc%)
  IF rc% <> 0 THEN krs% = krs% + 100: GOTO CreateFile
  IF df$ <> "" THEN Rfn% = FREEFILE: OPEN df$ FOR RANDOM AS #Rfn% LEN = Rfl%
  ' store information about key-record-set (krs%)
  S% = -1 * krs%: CALL Info(S%, xn%, kl%, Rfn%, Rfl%)
 RETURN

CreateFile:
  ' Initialize key-record file (if not already open)
  ' If df$="" then create only a index file
  CALL SaveScrn(Scrn$)
  CALL PopWindow(5, 23, 9, 67, 78)
  st$ = "Initializing File Will Delete": CALL FastPrint(5, 25, st$, -1)
  st$ = "All Data In The File": CALL FastPrint(6, 25, st$, -1)
  st$ = "ESC to Abort...CR to Continue": CALL FastPrint(7, 25, st$, -1)
  DO
    t% = KeyIn%
    IF t% = 27 THEN CALL RestoreScrn(Scrn$): RETURN
    IF t% = 13 THEN CALL RestoreScrn(Scrn$): EXIT DO
  LOOP
  krs% = krs% - 100
  ' get information about key-record-set (krs%)
  CALL Info(krs%, xn%, kl%, Rfn%, Rfl%)
  IF xn% = 0 THEN
    IF krs% = 1 THEN xn% = 1: ifn$ = "ML1.ndx": kl% = 29: df$ = "ML1.Dat": Rfl% = 683
    IF krs% = 2 THEN xn% = 2: ifn$ = "ML2.ndx": kl% = 34: df$ = "": Rfl% = 0
    IF krs% = 3 THEN xn% = 3: ifn$ = "ML3.ndx": kl% = 7: df$ = "": Rfl% = 0
    Rfn% = FREEFILE
    IF df$ <> "" THEN OPEN df$ FOR BINARY AS Rfn%: CLOSE Rfn%: KILL df$
    IF ifn$ <> "" THEN OPEN ifn$ FOR BINARY AS Rfn%: CLOSE Rfn%: KILL ifn$
    fc$ = "I": CALL im(xn%, fc$, ifn$, kl%, ky$, rn&, rc%)
    fc$ = "C": CALL im(xn%, fc$, ifn$, kl%, ky$, rn&, rc%)
    fc$ = "O": CALL im(xn%, fc$, ifn$, kl%, ky$, rn&, rc%)
    IF rc% <> 0 THEN CALL IndexError(rc%)
    Rfn% = FREEFILE
    IF df$ <> "" THEN OPEN df$ FOR RANDOM AS #Rfn% LEN = Rfl%
    ' store information about key-record-set (krs%)
    S% = -1 * krs%: CALL Info(S%, xn%, kl%, Rfn%, Rfl%)
  ELSE
    rc% = 112: CALL IndexError(rc%)
  END IF
 RETURN

END SUB

SUB DeleteRecord (krs%, ky$, rec$, status%)
  CALL PopWindow(3, 20, 5, 60, 78)
  st$ = "Delete Current Record? (y/N)"
  CALL FastPrint(4, 22, st$, 78)
  DO
    xk% = 22: st$ = "N": CALL EditField(4, 51, 79, "YyNn", st$, xk%)
    IF xk% = 13 AND st$ = "Y" THEN
      'CALL GetEqual(krs%, ky$, rec$, rn&, status%)
      'ky3$ = "ML1" + MKL$(rn&)
      'krs% = 3: CALL AddRecord(krs$, ky3$, "", rn&, status)
      ky2$ = MID$(rec$, 107, 5) + MID$(rec$, 2, 29)
      krs% = 2: CALL DeleteKeyRec(krs%, ky2$, "", status%)
      CALL CreateOpenClose(krs%)
      krs% = 1: CALL DeleteKeyRec(krs%, ky$, rec$, status%)
      CALL CreateOpenClose(krs%)
      CALL GetPrev(krs%, ky$, rec$, status%)
    END IF
  LOOP UNTIL xk% = 27 OR xk% = 13
END SUB

SUB Display (rec$)
  IF LEN(rec$) < 683 THEN rec$ = SPACE$(683)
  st$ = MID$(rec$, 2, 28): CALL FastPrint(6, 20, st$, -1)
  'st$ = MID$(rec$, 30, 1): CALL FastPrint(6, 67, st$, -1) 'tie breaker
  st$ = MID$(rec$, 31, 30): CALL FastPrint(8, 20, st$, -1)
  st$ = MID$(rec$, 61, 30): CALL FastPrint(10, 20, st$, -1)
  st$ = MID$(rec$, 91, 14): CALL FastPrint(12, 20, st$, -1)
  st$ = MID$(rec$, 105, 2): CALL FastPrint(12, 45, st$, -1)
  st$ = MID$(rec$, 107, 5): CALL FastPrint(12, 58, st$, -1)
  st$ = MID$(rec$, 112, 4): CALL FastPrint(12, 64, st$, -1)
  st$ = MID$(rec$, 116, 3): CALL FastPrint(14, 21, st$, -1)
  st$ = MID$(rec$, 119, 3): CALL FastPrint(14, 26, st$, -1)
  st$ = MID$(rec$, 122, 4): CALL FastPrint(14, 30, st$, -1)
  st$ = MID$(rec$, 126, 62): CALL FastPrint(16, 10, st$, -1)
  st$ = MID$(rec$, 188, 62): CALL FastPrint(17, 10, st$, -1)
  st$ = MID$(rec$, 250, 62): CALL FastPrint(18, 10, st$, -1)
  st$ = MID$(rec$, 312, 62): CALL FastPrint(19, 10, st$, -1)
  st$ = MID$(rec$, 374, 62): CALL FastPrint(20, 10, st$, -1)
  st$ = MID$(rec$, 436, 62): CALL FastPrint(21, 10, st$, -1)
  st$ = MID$(rec$, 498, 62): CALL FastPrint(22, 10, st$, -1)
  st$ = MID$(rec$, 560, 62): CALL FastPrint(23, 10, st$, -1)
  st$ = MID$(rec$, 622, 62): CALL FastPrint(24, 10, st$, -1)
END SUB

SUB FileFunctions (xk%)
  CALL SaveScrn(Scrn$)
  st$ = "FileFunctions": CALL FastPrint(1, 3, st$, 14)
  CALL PopWindow(2, 3, 9, 31, 78)
  c% = 1: xk% = 0: GOSUB DisplayFFchoice
  DO
    t% = KeyIn%
    SELECT CASE t%
       CASE -80  'up arrow
         c% = c% + 1: IF c% > 6 THEN c% = 1
         GOSUB DisplayFFchoice
       CASE -72  'dn arrow
         c% = c% - 1: IF c% < 1 THEN c% = 6
         GOSUB DisplayFFchoice
       CASE -18, -20, -33, -48, -25, -49
         xk% = t%: EXIT DO
       CASE 13
         IF xk% <> 0 THEN EXIT DO
       CASE 27
         xk% = 0: EXIT DO
       CASE -75
         xk% = 113: EXIT DO
       CASE -77
         xk% = 114: EXIT DO
       CASE 70, 102, 82, 114, 80, 112, 77, 109, 81, 113, -59
         xk% = t%: EXIT DO
    END SELECT
  LOOP
CALL RestoreScrn(Scrn$)
EXIT SUB

DisplayFFchoice:
  st$ = "Browse Records    Alt-B"
  IF c% = 1 THEN colr% = 14: xk% = -48 ELSE colr% = 78
  CALL FastPrint(3, 5, st$, colr%)
  st$ = "Find A Record     Alt-F"
  IF c% = 2 THEN colr% = 14: xk% = -33 ELSE colr% = 78
  CALL FastPrint(4, 5, st$, colr%)
  st$ = "Goto Top Of File  Alt-T"
  IF c% = 3 THEN colr% = 14: xk% = -20 ELSE colr% = 78
  CALL FastPrint(5, 5, st$, colr%)
  st$ = "Goto End Of File  Alt-E"
  IF c% = 4 THEN colr% = 14: xk% = -18 ELSE colr% = 78
  CALL FastPrint(6, 5, st$, colr%)
  st$ = "Get Prev. Record  Alt-P"
  IF c% = 5 THEN colr% = 14: xk% = -25 ELSE colr% = 78
  CALL FastPrint(7, 5, st$, colr%)
  st$ = "Get Next Record   Alt-N"
  IF c% = 6 THEN colr% = 14: xk% = -49 ELSE colr% = 78
  CALL FastPrint(8, 5, st$, colr%)
RETURN
END SUB

SUB FindRecord (krs%, ky$, rec$, status%)
  CALL SaveScrn(Scrn$)
  CALL PopWindow(3, 15, 5, 66, 78)
  st$ = "Enter Name to Find:": CALL FastPrint(4, 17, st$, 78)
  DO
    xk% = 11: st$ = SPACE$(29): CALL EditField(4, 37, 15, "", st$, xk%)
    IF xk% = 13 AND st$ <> SPACE$(29) THEN EXIT DO
    IF xk% = 27 THEN GOTO EndFindRecord
  LOOP
  ky$ = st$: rec$ = ""
  CALL GetEqual(krs%, ky$, rec$, rn&, status%)
EndFindRecord:
  CALL RestoreScrn(Scrn$)
  IF status% <> 0 THEN CALL IndexError(status%)
END SUB

SUB Help
  CALL SaveScrn(Scrn$)
  CALL PopWindow(8, 14, 16, 66, 78)
  st$ = "Pressing the Highlighted  Letter  (F,R,P,M,Q,F1)"
  CALL FastPrint(10, 17, st$, 79)
  st$ = "will cause  a pull down selection box to appear."
  CALL FastPrint(11, 17, st$, 79)
  st$ = "Make a  selection  by  moving the  highlight  to"
  CALL FastPrint(12, 17, st$, 79)
  st$ = "the selection you want and press enter. Or press"
  CALL FastPrint(13, 17, st$, 79)
  st$ = "the 'Hot' key as indicated (i.e.  Alt-B)"
  CALL FastPrint(14, 17, st$, 79)
  DO
    xk% = KeyIn%
  LOOP UNTIL xk% = 27
  CALL RestoreScrn(Scrn$)
END SUB

SUB MiscFunctions (xk%)
  CALL SaveScrn(Scrn$)
  st$ = "Misc.": CALL FastPrint(1, 53, st$, 14)
  CALL PopWindow(2, 53, 6, 78, 78)
  c% = 1: xk% = 0: GOSUB DisplayMFchoice
  DO
    t% = KeyIn%
    SELECT CASE t%
       CASE -80  'up arrow
         c% = c% + 1: IF c% > 3 THEN c% = 1
         GOSUB DisplayMFchoice
       CASE -72  'dn arrow
         c% = c% - 1: IF c% < 1 THEN c% = 3
         GOSUB DisplayMFchoice
       CASE -30, -32, -46
         xk% = t%: EXIT DO
       CASE 13
         IF xk% <> 0 THEN EXIT DO
       CASE 27
         xk% = 0: EXIT DO
       CASE -75
         xk% = 112: EXIT DO
       CASE -77
         xk% = 113: EXIT DO
       CASE 70, 102, 82, 114, 80, 112, 77, 109, 81, 113, -59
         xk% = t%: EXIT DO
    END SELECT
  LOOP
CALL RestoreScrn(Scrn$)
EXIT SUB

DisplayMFchoice:
  st$ = "ReIndex Key/Data File"
  IF c% = 1 THEN colr% = 14: xk% = -10 ELSE colr% = 78
  CALL FastPrint(3, 54, st$, colr%)
  st$ = "Close Key/Data Files "
  IF c% = 2 THEN colr% = 14: xk% = -11 ELSE colr% = 78
  CALL FastPrint(4, 54, st$, colr%)
  st$ = "Open Key/Data Files  "
  IF c% = 3 THEN colr% = 14: xk% = -12 ELSE colr% = 78
  CALL FastPrint(5, 54, st$, colr%)
 RETURN


END SUB

SUB OpenFiles
 'krs% = 3: CreateOpenClose (krs%)  'Not being used
 krs% = 2: CreateOpenClose (krs%)
 krs% = 1: CreateOpenClose (krs%)
END SUB

SUB PrintFunctions (xk%)
  CALL SaveScrn(Scrn$)
  st$ = "PrintFunctions": CALL FastPrint(1, 37, st$, 14)
  CALL PopWindow(2, 37, 7, 66, 78)
  c% = 1: xk% = 0: GOSUB DisplayPFchoice
  DO
    t% = KeyIn%
    SELECT CASE t%
       CASE -80  'up arrow
         c% = c% + 1: IF c% > 4 THEN c% = 1
         GOSUB DisplayPFchoice
       CASE -72  'dn arrow
         c% = c% - 1: IF c% < 1 THEN c% = 4
         GOSUB DisplayPFchoice
       CASE -30, -32, -46
         xk% = t%: EXIT DO
       CASE 13
         IF xk% <> 0 THEN EXIT DO
       CASE 27
         xk% = 0: EXIT DO
       CASE -75
         xk% = 114: EXIT DO
       CASE -77
         xk% = 109: EXIT DO
       CASE 70, 102, 82, 114, 80, 112, 77, 109, 81, 113, -59
         xk% = t%: EXIT DO
    END SELECT
  LOOP
CALL RestoreScrn(Scrn$)
EXIT SUB

DisplayPFchoice:
  st$ = "Print a Mailing Label     "
  IF c% = 1 THEN colr% = 14: xk% = -120 ELSE colr% = 78
  CALL FastPrint(3, 39, st$, colr%)
  st$ = "Print All Mailing Label   "
  IF c% = 2 THEN colr% = 14: xk% = -129 ELSE colr% = 78
  CALL FastPrint(4, 39, st$, colr%)
  st$ = "Print Mailing Label by ZIP"
  IF c% = 3 THEN colr% = 14: xk% = -128 ELSE colr% = 78
  CALL FastPrint(5, 39, st$, colr%)
  st$ = "Print HardCopy Of Record  "
  IF c% = 4 THEN colr% = 14: xk% = -121 ELSE colr% = 78
  CALL FastPrint(6, 39, st$, colr%)
 RETURN

END SUB

SUB PrintML0
  CALL SaveScrn(Scrn$)
  CALL PopWindow(3, 15, 6, 45, 78)
  st$ = "Start Printing Lables?": CALL FastPrint(4, 17, st$, 78)
  st$ = "ESC to Quit...CR to Print": CALL FastPrint(5, 17, st$, 78)
  DO
    xk% = KeyIn%
    IF xk% = 13 THEN GOSUB ML0Print: EXIT DO
  LOOP UNTIL xk% = 27
  CALL RestoreScrn(Scrn$)
  EXIT SUB

ML0Print:
  st$ = SPACE$(29)
  CALL GetEqual(krs%, ky$, rec$, rn&, status%)
  DO
    IF status% <> 0 THEN EXIT DO
    st$ = MID$(rec$, 2, 28): LPRINT st$
    st$ = MID$(rec$, 31, 30): LPRINT st$
    st$ = MID$(rec$, 61, 30): LPRINT st$
    st$ = MID$(rec$, 91, 14) + ", " + MID$(rec$, 105, 2)
    st$ = st$ + MID$(rec$, 107, 5) + "-" + MID$(rec$, 112, 4)
    LPRINT st$
    LPRINT : LPRINT
    CALL GetNext(krs%, ky$, rec$, status%)
  LOOP
 RETURN
END SUB

SUB PrintML1 (rec$)
  CALL SaveScrn(Scrn$)
  CALL PopWindow(3, 15, 6, 45, 78)
  st$ = "Print How Many Lables?": CALL FastPrint(4, 17, st$, 78)
  st$ = "ESC to Quit...CR to Print": CALL FastPrint(5, 17, st$, 78)
  DO
    xk% = 2: st$ = "1 ": CALL EditField(4, 40, 15, "", st$, xk%)
    IF xk% = 13 THEN GOSUB ML1Print: EXIT DO
  LOOP UNTIL xk% = 27
  CALL RestoreScrn(Scrn$)
  EXIT SUB

ML1Print:
  DO
    c% = c% + 1
    st$ = MID$(rec$, 2, 28): LPRINT st$
    st$ = MID$(rec$, 31, 30): LPRINT st$
    st$ = MID$(rec$, 61, 30): LPRINT st$
    st$ = MID$(rec$, 91, 14) + ", " + MID$(rec$, 105, 2)
    st$ = st$ + MID$(rec$, 107, 5) + "-" + MID$(rec$, 112, 4)
    LPRINT st$
    LPRINT : LPRINT
  LOOP UNTIL c% >= VAL(st$)
 RETURN

END SUB

SUB PrintML2 (rec$)
  CALL SaveScrn(Scrn$)
  CALL PopWindow(3, 15, 6, 45, 78)
  st$ = "Start Printing Lables?": CALL FastPrint(4, 17, st$, 78)
  st$ = "ESC to Quit...CR to Print": CALL FastPrint(5, 17, st$, 78)
  DO
    xk% = KeyIn%
    IF xk% = 13 THEN GOSUB ML2Print: EXIT DO
  LOOP UNTIL xk% = 27
  CALL RestoreScrn(Scrn$)
  EXIT SUB

ML2Print:
  st$ = SPACE$(34)
  krs1% = krs% + 1: CALL GetEqual(krs1%, ky2$, rec$, rn&, status%)
  DO
    IF status% <> 0 THEN EXIT DO
    st$ = MID$(rec$, 2, 28): LPRINT st$
    st$ = MID$(rec$, 31, 30): LPRINT st$
    st$ = MID$(rec$, 61, 30): LPRINT st$
    st$ = MID$(rec$, 91, 14) + ", " + MID$(rec$, 105, 2)
    st$ = st$ + MID$(rec$, 107, 5) + "-" + MID$(rec$, 112, 4)
    LPRINT st$
    LPRINT : LPRINT
    CALL GetNext(krs1%, ky2$, rec$, status%)
  LOOP
 RETURN

END SUB

SUB PrintML9
  CALL SaveScrn(Scrn$)
  CALL PopWindow(3, 15, 6, 45, 78)
  st$ = "Print Current Record?": CALL FastPrint(4, 17, st$, 78)
  st$ = "ESC to Quit...CR to Print": CALL FastPrint(5, 17, st$, 78)
  DO
    xk% = KeyIn%
    IF xk% = 13 THEN GOSUB ML9Print: EXIT DO
  LOOP UNTIL xk% = 27
  CALL RestoreScrn(Scrn$)
  EXIT SUB

ML9Print:
  FOR c% = 81 TO LEN(Scrn$) STEP 2
    LPRINT MID$(Scrn$, c%, 1);
  NEXT
 RETURN


END SUB

SUB QuitFunctions (xk%)
  CALL SaveScrn(Scrn$)
  st$ = "Quit": CALL FastPrint(1, 61, st$, 14)
  CALL PopWindow(2, 61, 5, 76, 78)
  xk% = 0
  DO
    st$ = "Press Alt-Q": CALL FastPrint(3, 64, st$, -1)
    st$ = "  To QUIT  ": CALL FastPrint(4, 64, st$, -1)
    t% = KeyIn%
    SELECT CASE t%
       CASE -75
         xk% = 109: EXIT DO
       CASE -77
         xk% = 102: EXIT DO
       CASE -16, 70, 102, 82, 114, 80, 112, 77, 109, 81, 113, -59
         xk% = t%: EXIT DO
       CASE 27
         xk% = 0: EXIT DO
    END SELECT
  LOOP
  CALL RestoreScrn(Scrn$)
END SUB

SUB RecordFunctions (xk%)
  CALL SaveScrn(Scrn$)
  st$ = "RecordFunctions": CALL FastPrint(1, 19, st$, 14)
  CALL PopWindow(2, 19, 6, 45, 78)
  c% = 1: xk% = 0: GOSUB DisplayRFchoice
  DO
    t% = KeyIn%
    SELECT CASE t%
       CASE -80  'up arrow
         c% = c% + 1: IF c% > 3 THEN c% = 1
         GOSUB DisplayRFchoice
       CASE -72  'dn arrow
         c% = c% - 1: IF c% < 1 THEN c% = 3
         GOSUB DisplayRFchoice
       CASE -30, -32, -46
         xk% = t%: EXIT DO
       CASE 13
         IF xk% <> 0 THEN EXIT DO
       CASE 27
         xk% = 0: EXIT DO
       CASE -75
         xk% = 102: EXIT DO
       CASE -77
         xk% = 112: EXIT DO
       CASE 70, 102, 82, 114, 80, 112, 77, 109, 81, 113, -59
         xk% = t%: EXIT DO
    END SELECT
  LOOP
CALL RestoreScrn(Scrn$)
EXIT SUB

DisplayRFchoice:
  st$ = "Add a record     Alt-A"
  IF c% = 1 THEN colr% = 14: xk% = -30 ELSE colr% = 78
  CALL FastPrint(3, 21, st$, colr%)
  st$ = "Delete Record    Alt-D"
  IF c% = 2 THEN colr% = 14: xk% = -32 ELSE colr% = 78
  CALL FastPrint(4, 21, st$, colr%)
  st$ = "Change Record    Alt-C"
  IF c% = 3 THEN colr% = 14: xk% = -46 ELSE colr% = 78
  CALL FastPrint(5, 21, st$, colr%)
 RETURN
END SUB

SUB ReIndexFile
 'IF krs% = 1 THEN xn% = 1: ifn$ = "ML1.ndx": kl% = 29: df$ = "ML1.Dat": Rfl% = 683
 'IF krs% = 2 THEN xn% = 2: ifn$ = "ML2.ndx": kl% = 34: df$ = "": Rfl% = 0
 'IF krs% = 3 THEN xn% = 3: ifn$ = "ML3.ndx": kl% = 6: df$ = "": Rfl% = 0
 'krs% = -3: CreateOpenClose (krs%)   'Not yet in use
 krs% = -2: CreateOpenClose (krs%)
 krs% = -1: CreateOpenClose (krs%)
 IF FILEXISTS%("ML1.ndx") THEN KILL "ML1.ndx"
 IF FILEXISTS%("ML2.ndx") THEN KILL "ML2.ndx"
 IF FILEXISTS%("ML3.ndx") THEN KILL "ML3.ndx"
 IF FILEXISTS%("ML1.OLD") THEN KILL "ML1.OLD"
 IF FILEXISTS%("ML1.Dat") THEN NAME "ML1.DAT" AS "ML1.OLD" ELSE EXIT SUB
 n% = FREEFILE
 OPEN "ML1.OLd" FOR RANDOM AS n% LEN = 683
 'krs% = 3: CreateOpenClose (krs%)    'Not yet in use
 krs% = 2: CreateOpenClose (krs%)
 krs% = 1: CreateOpenClose (krs%)
 DO
   c& = c& + 1
   rec$ = SPACE$(683): GET #n%, c&, rec$
   IF EOF(n%) THEN EXIT DO
   tb% = 32: ky$ = MID$(rec$, 2, 28) + CHR$(tb%)
   IF MID$(rec$, 2, 28) > SPACE$(28) THEN
     DO
       krs% = 1: CALL AddKeyRec(krs%, ky$, rec$, rn&, status%)
       IF status% = 109 THEN
       IF tb% > 253 THEN EXIT SUB
         tb% = tb% + 1:  ky$ = MID$(rec$, 2, 28) + CHR$(tb%)
       END IF
     LOOP UNTIL status% = 0
     ky2$ = MID$(rec$, 107, 5) + ky$
     krs% = 2: CALL AddKeyRec(krs%, ky2$, "", rn&, status%)
   END IF
 LOOP
 krs% = 2: CALL CreateOpenClose(krs%)
 krs% = 1: CALL CreateOpenClose(krs%)
END SUB

