$CPU 8086
$LIB ALL OFF
$ERROR ALL OFF
$OPTIMIZE SIZE
$COMPILE EXE

$INCLUDE "PBTCLASS.DEC"

InitPBScreen

DIM Temp$(1:1000), L$(8), LL$$(8)
MAP Tmp$$ * 320, 40 AS LL$$(1), 40 AS LL$$(2), 40 AS LL$$(3), 40 AS LL$$(4),_
	40 AS LL$$(5), 40 AS LL$$(6), 40 AS LL$$(7), 40 as LL$$(8)

Xpos = POS(0)
Ypos = CSRLIN

Ver$ = "v3.01"

Fil$ = COMMAND$
IF Fil$ = "" THEN Fil$ = "PHBK.DAT"
IF DIR$(Fil$) = "" THEN
  OPEN "O", 1, Fil$:
  PRINT #1, SPACE$(321)
  CLOSE #1
END IF

OPEN "B", 1, Fil$
  K = (LOF(1)-1)/320
  FOR I = 0 TO K-1
	SEEK 1, I*320
	GET$ 1, 320, Temp$(I+1)
  NEXT I
CLOSE

SkipIt:
FOR I = 1 TO K-1
  Temp$(I) = MID$(Temp$(I), 2)+LEFT$(Temp$(I+1), 1)
NEXT I

Temp$(K) = MID$(Temp$(K), 2)+" "
CLR$ = SPACE$(47)

OpenWin 7, 17, 12, 50, 1, Attr(14, 4), Attr(15, 1), 3, 1, 0
WPrintC 2, "PHBK "+Ver$, 0
WPrintC 4, "Command Line Phone Book", 0
WPrintC 5, "(c) Copyright 1991, 93 by Dave Navarro,  Jr.", 0
WPrintC 6, "All Rights Reserved", 0
WPrintC 9, "Written using PBTools:Classic 1.32", 0
SLEEP 3
ClearWin
WPrint 1, 2, "Name", Attr(14, 1)
WPrint 2, 2, "Addr", Attr(14, 1)
WPrint 5, 2, "Phone", Attr(14, 1)
WPrint 6, 2, "Notes", Attr(14, 1)
WPrint 9, 2, STRING$(46, ""), Attr(14, 1)
COLOR 15, 1
Current = 1

Cur:
  Tmp$$ = Temp$(Current)
  GOSUB Display
  WPrint 10, 1, CLR$, Attr(14, 1)
  WPrintC 10, "F1-New  F2-Edit  F3-Del  F4-Search  F5-Print ", Attr(14, 1)
  Title 1, Attr(14, 4), "["+STR$(Current)+" of"+STR$(K)+" ]"

GetAKey:
  I$ = GetKey$
  IF I$ = CHR$(27) THEN Quit
  IF I$ = CHR$(0, 81) THEN PgDn
  IF I$ = CHR$(0, 73) THEN PgUp
  IF I$ = CHR$(0, 59) THEN New
  IF I$ = CHR$(0, 63) THEN PrinLab
  IF I$ = CHR$(0, 60) THEN EdLab
  IF I$ = CHR$(0, 62) THEN Strt = 1:GOTO Search
  IF I$ = CHR$(0, 61) THEN DelRec
  GOTO GetAKey

PrinLab:
  LPRINT " "+LL$$(1)
  LPRINT " "+LL$$(2)
  LPRINT " "+LL$$(3)
  LPRINT " "+LL$$(4)
  LPRINT
  LPRINT
  GOTO Cur

DelRec:
  WPrint 10, 1, CLR$, Attr(14, 1)
  WPrintC 10, "Press ENTER to delete,  ESC to abort", Attr(14, 1)
  KeyLoop:
	I$ = GetKey$
	IF I$ = CHR$(27) THEN Cur
	IF I$<>CHR$(13) THEN KeyLoop
	ARRAY DELETE Temp$(Current)
	DECR K
	IF Current>K THEN Current = 1
	GOTO SaveIt

Search:
  WPrint 10, 1, CLR$, Attr(14, 1)
  WPrint 10, 2, "Find: ", Attr(14, 1)
  T$ = CHR$(13)+CHR$(27):IF Sch$ = "" THEN Sch$ = SPACE$(40)
  TextEd Ypos(1)+10, Xpos(1)+10, 0, Attr(15, 1), Attr(15, 1), Sch$, T$
  IF T$ = CHR$(27) THEN Cur
  Look:
	FOR I = Strt TO K
	  IF INSTR(UCASE$(Temp$(I)), UCASE$(Trim$(Sch$))) THEN Skip
	NEXT I
	WPrint 10, 1, CLR$, Attr(14, 1)
	WPrintC 10, "All Records Searched", Attr(14, 1)
	DELAY 2
	GOTO Cur
	Skip:
	  Tmp$$ = Temp$(I)
	  GOSUB Display
	  Strt = I+1:Current = Strt-1
	  Title 1, Attr(14, 4), "["+STR$(Current)+" of"+STR$(K)+" ]"
	  WPrint 10, 1, CLR$, Attr(14, 1)
	  WPrintC 10, "Press ENTER to continue,  ESC to END", Attr(14, 1)
	  GetAKee:
		I$ = GetKey$
		IF I$ = CHR$(27) THEN Cur
		IF I$<>CHR$(13) THEN GetAKee
		GOTO Look

SaveIt:
  WPrint 10, 1, CLR$, Attr(14, 1)
  WPrintC 10, "Saving:"+Fil$, Attr(14, 1)
  OPEN "O", 1, Fil$
  IF K<256 THEN PRINT#1,  CHR$(K); ELSE  PRINT#1,  CHR$(255);
  FOR I = 1 TO K
	PRINT #1, Temp$(I);
  NEXT I
  CLOSE
  GOTO Cur

New:
  WPrint 10, 1, CLR$, Attr(14, 1)
  WPrintC 10, "Press F1 to validate entry", Attr(14, 1)
  Title 1, Attr(14, 4), "["+STR$(K+1)+" of"+STR$(K)+" ]"
  Tmp$$ = SPACE$(320)
  Cpos = 0
  GOSUB Display
  TL = 1
  WHILE TL<>-1
	GOSUB GetInput
  WEND
  Validate:
	L$ = ""
	FOR X = 1 TO 8
	  L$ = L$+L$(X)
	NEXT
	IF L$ = SPACE$(320) THEN Cur
	INCR K
	Temp$(K) = L$
	ARRAY SORT Temp$(1) FOR K
	FOR Current = 1 TO K
	  IF Temp$(Current)<>L$ THEN NEXT Current
	GOTO SaveIt

EdLab:
  WPrint 10, 1, CLR$, Attr(14, 1)
  WPrintC 10, "Press F1 to validate entry", Attr(14, 1)
  Cpos = 0
  GOSUB Display
  TL = 1
  Ed = 1
  WHILE TL<>-1
	GOSUB GetInput
  WEND
  Validate2:
	L$ = ""
	FOR X = 1 TO 8
	  L$ = L$+L$(X)
	NEXT
	Temp$(Current) = L$
	GOTO SaveIt

PgUp:
  DECR Current
  IF Current<1 THEN Current = K
  GOTO Cur

PgDn:
  INCR Current
  IF Current>K THEN Current = 1
  GOTO Cur

Quit:
  CloseWin
  COLOR 7, 0
  LOCATE Ypos, Xpos, 0
  PRINT "PHBK "+Ver$+"  Command Line Phone Book"
  PRINT "(c) Copyright 1991,93 by Dave Navarro, Jr."
  END

Display:
  FOR X = 1 TO 8
	L$(X) = LL$$(X)
    WPrint X, 8, L$(X), Attr(15, 1)
  NEXT
  RETURN

GetInput:
  TextEd TL+7, 27, Cpos, Attr(15, 1), 0, L$(TL), T$
  IF T$ = CHR$(27) THEN RETURN Cur
  IF T$ = CHR$(0, 59) THEN TL = -1:RETURN
  IF T$ = CHR$(13) THEN Cpos = 0:INCR TL
  IF T$ = CHR$(8) THEN MID$(L$(TL-1), 40, 1) = " ":Cpos = 39:DECR TL
  IF T$ = CHR$(0, 72) THEN DECR TL
  IF T$ = CHR$(0, 75) THEN CPos = 39:DECR TL
  IF T$ = CHR$(0, 77) THEN Cpos = 0:INCR TL
  IF T$ = CHR$(0, 80) THEN INCR TL
  IF TL>8 THEN TL = 1 ELSE IF TL<1 THEN TL = 8
  RETURN