'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |       PBClone  Copyright (c) 1990-1994  Thomas G. Hanlin III         |
'   |                                                                      |
'   +----------------------------------------------------------------------+

' This is another simple demo of the PBClone routines.  It allows you to
' view the files in an archive (.ARC, .ARJ, .LZH, .PAK, .ZIP, or .ZOO).

' Syntax:
'   ARCVIEW arcname[.ext] [/V]

' The file extension for the archive is optional, although you may want to
' specify it if there is a possibility that you have two archives of the
' same name but different extensions (e.g., FOO.ARJ and FOO.ZIP).  The /V
' option allows you to specify a full listing-- without it, you will get
' a "wide format" display containing just the file names in the archive.

' Typically, this would be converted to an .EXE file using these steps:
'    BC ARCVIEW/O;
'    LINK ARCVIEW/EX,,NUL,PBCLONE;

   DECLARE SUB CloseA ()
   DECLARE SUB DateN2S (MonthNr%, DayNr%, YearNr%, DateSt$)
   DECLARE SUB FindFirstA (Archive$, FileName$, ErrCode%)
   DECLARE SUB FindNextA (ErrCode%)
   DECLARE SUB GetCRCAL (CRC32&)
   DECLARE SUB GetDateA (MonthNr%, DayNr%, YearNr%)
   DECLARE SUB GetNameA (FileName$, FileNameLen%)
   DECLARE SUB GetSizeAL (OriginalSize&, CurrentSize&)
   DECLARE SUB GetTimeA (HourNr%, MinuteNr%, SecondNr%)
   DECLARE SUB TimeN2S (HourNr%, MinuteNr%, SecondNr%, TimeSt$)

   DECLARE SUB PrintComma (Number&, FieldLen%)

   DEFINT A-Z

   Cmd$ = LTRIM$(RTRIM$(UCASE$(COMMAND$)))
   IF LEN(Cmd$) = 0 OR INSTR(Cmd$, "/?") > 0 THEN
      PRINT "ARCVIEW: View Archive Demo for PBClone by Thomas G. Hanlin III"
      PRINT
      PRINT "Syntax:"
      PRINT "  ARCVIEW arcname[.ext] [/V]
      PRINT
      PRINT "Use /V for a full listing, as opposed to just a list of the files contained"
      PRINT "in the archive.  ARCVIEW currently supports ARC, ARJ, LZH, PAK, ZIP, and ZOO."
      END
   END IF
   tmp = INSTR(Cmd$, "/V")
   IF tmp THEN
      FullView = -1
      Cmd$ = LTRIM$(RTRIM$(LEFT$(Cmd$, tmp - 1) + MID$(Cmd$, tmp + 2)))
   END IF
   IF LEN(Cmd$) THEN
      Arc$ = Cmd$
   ELSE
      PRINT "Please specify the name of an archive."
      END
   END IF

   FindFirstA Arc$, "*.*", ErrCode
   IF ErrCode THEN
      PRINT "Unable to open archive "; CHR$(34); Arc$; CHR$(34)
      END
   END IF

   IF FullView THEN
      PRINT "Filename              Date       Time    CRC        Curr. Size    Orig. Size"
      PRINT "-------------------   --------   -----   --------   -----------   -----------"
   END IF

   FileName$ = SPACE$(80)
   DO
      GetNameA FileName$, FLen
      IF FullView THEN
         IF FLen > 22 THEN
            F$ = "..." + RIGHT$(LEFT$(FileName$, FLen), 19)
            FLen = 22
         ELSE
            F$ = LEFT$(FileName$, FLen)
         END IF
         PRINT F$; SPACE$(22 - FLen);
         GetDateA MonthNr, DayNr, YearNr
         DateSt$ = "xx/xx/xx"
         DateN2S MonthNr, DayNr, YearNr, DateSt$
         PRINT DateSt$; "   ";
         GetTimeA HourNr, MinuteNr, SecondNr
         TimeSt$ = "xx:xx"
         TimeN2S HourNr, MinuteNr, SecondNr, TimeSt$
         PRINT TimeSt$; "   ";
         GetCRCAL CRC32&
         HexCRC$ = RIGHT$("00000000" + HEX$(CRC32&), 8)
         PRINT HexCRC$;
         GetSizeAL OriginalSize&, CurrentSize&
         PrintComma CurrentSize&, 14
         PrintComma OriginalSize&, 14
         PRINT
      ELSE
         IF FLen > 15 THEN
            F$ = "..." + RIGHT$(LEFT$(FileName$, FLen), 12)
            FLen = 15
         ELSE
            F$ = LEFT$(FileName$, FLen)
         END IF
         PRINT F$; SPACE$(16 - FLen);
      END IF
      FindNextA ErrCode
   LOOP UNTIL ErrCode

   CloseA

SUB PrintComma (Number&, FieldLen)
   N$ = LTRIM$(STR$(Number&))
   R$ = ""
   DO WHILE LEN(N$) > 3
      R$ = RIGHT$(N$, 3) + "," + R$
      N$ = LEFT$(N$, LEN(N$) - 3)
   LOOP
   IF LEN(N$) THEN R$ = N$ + "," + R$
   IF RIGHT$(R$, 1) = "," THEN R$ = LEFT$(R$, LEN(R$) - 1)
   IF LEN(R$) < FieldLen THEN
      R$ = SPACE$(FieldLen - LEN(R$)) + R$
   END IF
   PRINT R$;
END SUB
