'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |       PBClone  Copyright (c) 1990-1994  Thomas G. Hanlin III         |
'   |                                                                      |
'   +----------------------------------------------------------------------+

'  NOTE: Do not LINK with the /E (/EXEPACK) switch.

   DECLARE SUB FindPatch (FileName$, SearchSt$, ErrCode%)
   DECLARE SUB SetPatch (St$)
   DECLARE SUB PatchDone ()

   DEFINT A-Z

   ' --- We read SearchSt$ to avoid duplicating it in an assignment statement.
   ' --- The ConfigSt$ is the value we patched in last time.
   READ SearchSt$, ConfigSt$

   ' --- Get the value to patch in this time.
   St$ = LTRIM$(RTRIM$(COMMAND$))

   ' --- Make it the right length (this is important)!
   IF LEN(St$) < LEN(ConfigSt$) THEN
      St$ = St$ + SPACE$(LEN(ConfigSt$) - LEN(St$))
   ELSE
      St$ = LEFT$(St$, LEN(ConfigSt$))
   END IF

   ' --- Tell 'em what's up.
   PRINT "This is a demo of the PBClone routines which allow a program to patch itself."
   PRINT "It patches itself with whatever you enter on the command line."
   PRINT
   PRINT "The last entry was: "; CHR$(34); RTRIM$(ConfigSt$); CHR$(34)
   PRINT "Next time it'll be: "; CHR$(34); RTRIM$(St$); CHR$(34)

   ' --- Here we do the actual patching.
   ' --- Note that the ".EXE" extension is optional.
   FindPatch "PATCHER", SearchSt$, ErrCode
   IF ErrCode THEN
      PRINT "Unable to patch PATCHER.EXE-- error code: "; ErrCode
      END
   END IF
   SetPatch St$
   PatchDone

   ' --- Here's the data: one quoted string per statement, with the first
   ' --- statement containing a unique string.  The first statement won't be
   ' --- patched, since we may need it again another time.  The second data
   ' --- statement will be the first patched.  There is no limit to the
   ' --- number of data statements which may be patched.
   DATA "UniqueString"
   DATA "This space intentionally left blank!                             "
