       PBClone 3.0  (c) 1990-1994  Thomas G. Hanlin III

Name  : AddMatI              (Add Matrix Integer)
Class : Array management
Level : Any

This routine adds an integer to as many elements of an integer
array as you like, starting at a specified place in the array.
It can also be used to subtract (just specify a negative value).
If there was a numeric overflow at any point in the operation,
an error code will be returned.

   AddMatI DSeg%, DOfs%, Elements%, Value%, ErrCode%

DSeg%      segment of the first array element to add
DOfs%      offset of the first array element to add
Elements%  number of array elements to which to add
Value%     value to add to each array element
-------
ErrCode%   error code: 0 if no error

Name  : AddMatL              (Add Matrix Long integer)
Class : Array management
Level : Any

This routine adds a long integer to as many elements of an long
integer array as you like, starting at a specified place in the
array. It can also be used to subtract (just specify a negative
value). If there was a numeric overflow at any point in the
operation, an error code will be returned.

   AddMatL DSeg%, DOfs%, Elements%, Value&, ErrCode%

DSeg%      segment of the first array element to add
DOfs%      offset of the first array element to add
Elements%  number of array elements to which to add
Value&     value to add to each array element
-------
ErrCode%   error code: 0 if no error

Name  : AllExtMem&           (All Extended Memory)
Class : Equipment
Level : Clone (AT)

This routine returns the amount of extended memory installed in
the system, as reported by the power-on self-test (POST) routine
at boot time. This does not tell you how much extended memory is
actually available, since extended memory may be carved up by
users of BIOS-level extended memory or XMS memory, converted to
expanded memory, etc. It only tells you the amount of physical
extended memory that is installed.

Do not use this routine on PC/XT machines. It is only for
AT-class computers.

   TotalKb& = AllExtMem&

-------
TotalKb&      kilobytes of extended memory installed

Name  : AltKey               (Alt Key)
Class : Input
Level : Any

This routine works in conjunction with a key input routine, such
as INKEY$ or the CheckKey and GetKey routines. Given the ASCII
code and scan code of a key, AltKey returns the associated key
letter, if any. For instance, it returns "A" if you pass it
ASCII code 0 and scan code 30, because those codes represent
Alt-A.

   AltKey ASCIICode%, ScanCode%, Ky$

ASCIICode%   ASCII code of the key
ScanCode%    scan code of the key
-------
Ky$          associated key letter ("" if none)

Name  : AndSt                (AND String)
Class : String
Level : Any

This routine ANDs each byte in one string with the corresponding
byte in a second string. The strings must be the same length.

   AndSt St1$, St2$

St1$      string to AND
St2$      string to AND with
-------
St1$      result

Name  : Any2Dec              (Any to Decimal)
Class : Numeric
Level : Any

This routine converts a number in any base to a normal (base 10)
integer. It works like the &H and &O prefixes in BASIC, but
rather than working only in hexadecimal (base 16) and octal
(base 8), it can be used for binary, octal, or almost anything
else. The base may range from 2-35.

The input number may be in either signed or unsigned integer
form, and will be converted to a signed integer. For example,
the base 16 (hexadecimal) number FFFF would be converted to -1,
as would the base 10 (decimal) number 65535. This may not seem
to make sense if you're not familiar with the internal format
for integers, but is the standard approach to converting
unsigned numbers (0-65535) to signed numbers (-32768 to 32767).
BASIC always uses signed integers, so the numbers will always be
what you expect so long as they are kept in the range -32768 to
32767. They "wrap around" for 32768 to 65535.

The most common bases used on computers are base 2 (binary),
base 8 (octal), base 10 (decimal), and base 16 (hexadecimal).

   Any2Dec Number$, NrBase%, DecNr%, ErrCode%

Number$   any-base number to convert to an integer
NrBase%   number base to convert from
-------
DecNr%    resulting integer
ErrCode%  error code: 0 if no error

Name  : AscI%                (ASC Integer)
Class : String
Level : Any

This is a replacement for the ASC function provided by BASIC. It
is smaller than ASC, however, and also somewhat faster.

Unlike BASIC or ProBas, the PBClone AscI function returns -1 as
an error condition if you try to use it on a null string. This
convention owes its origin to the similar routine in Crescent's
libraries.

See also AscM%, which returns the ASCII code of a character at a
specific location within a string.

   Value% = AscI%(St$)

St$        string for which to return ASCII code
-------
Value%     code of the first string char or -1 if null string

Name  : AscM%                (ASC MID$)
Class : String
Level : Any

This function works like a combination of the BASIC functions
ASC and MID$. It returns the ASCII code of a character at a
specified position in a string. If the specified position is
outside the string, -1 will be returned.

See also AscI%, which returns the ASCII code of the character at
the beginning of a string.

   Value% = AscM%(St$, Posn%)

St$        string to examine
Posn%      character position to examine
-------
Value%     code of the specified character or -1 if error

Name  : BarMenu              (Bar Menu)
Class : Input
Level : Clone

This is a bar menu routine. It allows the user to select one of
a list of items given on a single menu row or "bar". The current
item is highlighted in your choice of colors; user selection can
be done either by moving this highlight and pressing return or
by entering the letter associated with the desired item. Only
text mode is supported.

The highlight may be moved with the left and right arrow keys,
tab and backtab, or space and backspace. Selection is done with
<CR>, the enter key.

The letter used to select an item is the first character of the
item that is not lowercase or a space. If the item is all
lowercase, the first character of the item will be used. For
example, suppose you want the user to select one of "list" or
"log". By passing the options to BarMenu as "List" and "lOg",
you allow the user to press "L" for "List" and "O" for "lOg".

The user's choice will be returned to you as a number, with the
first choice being numbered 1. If <ESC> was pressed, 0 will be
returned.

   BarMenu Pick$(), Row%, LCol%, RCol%, VAttr%, HiAttr%, Prompt$

Pick$()       list of items to choose from
Row%          row on which to display the bar
LCol%         leftmost column of the bar
RCol%         rightmost column of the bar (use -1 for autosize)
VAttr%        bar color/attribute (see CalcAttr)
HiAttr%       bar highlight color/attribute (see CalcAttr)
Prompt$       prompt text (displayed at left side of the bar)
-------
Row%          # of the chosen item (1-items, or 0 if <ESC>)

Name  : BarMenuM             (Bar Menu with Mouse)
Class : Input, Mouse
Level : Clone

This is a bar menu routine. It functions just like BarMenu, but
supports the use of a mouse as well as the keyboard. Make sure
the mouse cursor is visible before calling this routine!

   BarMenuM PickList$(), Row%, LeftCol%, RightCol%, VAttr%, _
      HiAttr%, Prompt$, Mouse%, ShowCursor%

PickList$()   list of items to choose from
Row%          row on which to display the bar
LeftCol%      leftmost column of the bar
RightCol%     rightmost column of the bar (use -1 for auto-sizing)
VAttr%        bar color/attribute (see CalcAttr)
HiAttr%       bar highlight color/attribute (see CalcAttr)
Prompt$       prompt text (displayed at the left side of the bar)
Mouse%        whether a mouse is available (0 no)
ShowCursor%   not used
-------
Row%          number of the chosen item (1-items, or 0 if <ESC>)

Name  : Bickel               (Bickel comparison)
Class : String
Level : Any

A string comparison routine, Bickel allows you to see how
closely two strings match. The better the match, the larger the
returned value will be. Since there is no constant minimum or
maximum value, this routine is best used for applications
involving dictionary searches. You would scan the dictionary and
make a list of the best matches. This is appropriate for a
spelling checker, for instance.

See also Bickel2%, the function version of this routine.

   Bickel St1$, St2$, Result%

St1$      first string to compare
St2$      second string to compare
-------
Result%   resulting "match magnitude" value

Name  : Bickel2%             (Bickel comparison)
Class : String
Level : Any

A string comparison function, Bickel2% allows you to see how
closely two strings match. The better the match, the larger the
returned value will be. Since there is no constant minimum or
maximum value, this routine is best used for applications
involving dictionary searches. You would scan the dictionary and
make a list of the best matches. This is appropriate for a
spelling checker, for instance.

See also Bickel, the subprogram version of this routine.

   Result% = Bickel2%(St1$, St2$)

St1$      first string to compare
St2$      second string to compare
-------
Result%   resulting "match magnitude" value

Name  : BigPrint             (Big Print)
Class : Display
Level : BIOS

As the name suggests, this routine displays text in large
characters. How large? Eight times as high and as wide as
normal! Each "big character" will be composed of many
normal-sized characters. You may choose the normal character
used to create the big characters (the default is a CHR$(219)
solid block character, if you pass a null string here).

You should avoid using CHR$(128) to CHR$(255) when in either of
the CGA graphics modes, as many CGAs are unable to display these
characters when in graphics mode.

   BigPrint St$, FormCh$, Row%, Column%, VAttr%

St$       string to display in big characters
FormCh$   character used to compose the big characters
Row%      starting row
Column%   starting column
VAttr%    color/attribute of big characters (see CalcAttr)

Name  : BinSeekD             (Binary Seek Double precision)
Class : Array management
Level : Any

This routine uses binary search techniques to locate a specific
number in a sorted double-precision array. Each number in the
array must be unique (no duplicates) for this to work. This is a
very, very fast routine and is especially handy for look-up
tables.

The array is expected to begin at element 1. You may specify the
maximum element to search, allowing use of only part of an
array.

A single number is returned in Posn%. If Posn% is greater than
zero, the target number was found and Posn% is the position in
the array where it was found. If Posn% is negative, the target
number was not found, but it could be inserted into the array at
the -Posn% element. If the number is zero, the target number was
not found and there is no room in the array to add any more
values.

   BinSeekD Array#(), Elements%, Target#, Posn%

Array#()    array of sorted, unique values to search
Elements%   maximum array element to search
Target#     value to look for
-------
Posn%       whether and where the target was found (see above)

Name  : BinSeekI             (Binary Seek Integer)
Class : Array management
Level : Any

This routine uses binary search techniques to locate a specific
number in a sorted integer array. Each number in the array must
be unique (no duplicates) for this to work. This is a very, very
fast routine and is especially handy for look-up tables.

The array is expected to begin at element 1. You may specify the
maximum element to search, allowing use of only part of an
array.

A single number is returned in Posn%. If Posn% is greater than
zero, the target number was found and Posn% is the position in
the array where it was found. If Posn% is negative, the target
number was not found, but it could be inserted into the array at
the -Posn% element. If the number is zero, the target number was
not found and there is no room in the array to add any more
values.

   BinSeekI Array%(), Elements%, Target%, Posn%

Array%()    array of sorted, unique values to search
Elements%   maximum array element to search
Target%     value to look for
-------
Posn%       whether and where the target was found (see above)

Name  : BinSeekL             (Binary Seek Long integer)
Class : Array management
Level : Any

This routine uses binary search techniques to locate a specific
number in a sorted long integer array. Each number in the array
must be unique (no duplicates) for this to work. This is a very,
very fast routine and is especially handy for look-up tables.

The array is expected to begin at element 1. You may specify the
maximum element to search, allowing use of only part of an
array.

A single number is returned in Posn%. If Posn% is greater than
zero, the target number was found and Posn% is the position in
the array where it was found. If Posn% is negative, the target
number was not found, but it could be inserted into the array at
the -Posn% element. If the number is zero, the target number was
not found and there is no room in the array to add any more
values.

   BinSeekL Array&(), Elements%, Target&, Posn%

Array&()    array of sorted, unique values to search
Elements%   maximum array element to search
Target&     value to look for
-------
Posn%       whether and where the target was found (see above)

Name  : BinSeekS             (Binary Seek Single precision)
Class : Array management
Level : Any

This routine uses binary search techniques to locate a specific
number in a sorted single-precision array. Each number in the
array must be unique (no duplicates) for this to work. This is a
very, very fast routine and is especially handy for look-up
tables.

The array is expected to begin at element 1. You may specify the
maximum element to search, allowing use of only part of an
array.

A single number is returned in Posn%. If Posn% is greater than
zero, the target number was found and Posn% is the position in
the array where it was found. If Posn% is negative, the target
number was not found, but it could be inserted into the array at
the -Posn% element. If the number is zero, the target number was
not found and there is no room in the array to add any more
values.

   BinSeekS Array!(), Elements%, Target!, Posn%

Array!()    array of sorted, unique values to search
Elements%   maximum array element to search
Target!     value to look for
-------
Posn%       whether and where the target was found (see above)

Name  : BinSeekSt            (Binary Seek String)
Class : Array management
Level : Any

This routine uses binary search techniques to locate a specific
string in a sorted string array. Each string in the array must
be unique (no duplicates) for this to work. This is a very, very
fast routine and is especially handy for look-up tables.

The string array is expected to begin at element 1. You may
specify the maximum element to search, allowing use of only part
of an array. You must specify whether capitalization matters--
set CapsCount% to 0 if it doesn't.

A single number is returned in Posn%. If the number is greater
than zero, the target string was found, and the number is the
position in the array where it was found. If the number is
negative, the target string was not found, but it could be
inserted into the array at the -Posn% element. If the number is
zero, the target string was not found and there is no room in
the array to add any more values.

   BinSeekSt Array$(), Elements%, Target$, CapsCount%, Posn%

Array$()    array of sorted, unique values to search
Elements%   maximum array element to search
Target$     string to look for
CapsCount%  0 if capitalization doesn't matter
-------
Posn%       whether and where the target was found (see above)

Name  : BIOSInkey            (BIOS INKEY$)
Class : Input
Level : BIOS

BIOSInkey works like INKEY$, but it gets its key directly by
asking the BIOS. The primary advantage of this is that you get
the "scan" code as well as the ASCII code of the key. The scan
code is independent of the shift status-- for instance, the scan
code for "A" is the same as the scan code for "a" or Control-A
or Alt-A. This can be very handy.

If there is no key available, both the scan code and ASCII code
will be zero.

   BIOSInkey AscCode%, ScanCode%

-------
AscCode%    ASCII code of the key, if any
ScanCode%   scan code of the key, if any

Name  : BkScroll             (Backward Scroll)
Class : Display
Level : BIOS

This routine scrolls any selected part of the display down-- it
does a backwards scroll. You may scroll as many times as you
like, or scroll "zero" times to totally clear the selected part
of the display.

Note that BIOS-level scrolling can cause the screen to flicker
on some CGAs due to a combination of unfortunate design factors.

   BkScroll TopRow%, LeftCol%, BottomRow%, RightCol%, Times%

TopRow%      top row of the area to scroll
LeftCol%     left column of the area to scroll
BottomRow%   top row of the area to scroll
RightCol%    left column of the area to scroll
Times%       number of times (or rows) to scroll

Name  : BkSpace              (Backspace)
Class : Display
Level : BIOS

Although CHR$(8) is supposed to mean "backspace", it shows up as
a graphics character when BASIC prints it. This routine does an
actual backspace with full wrap-- if it's at the beginning of
the line, it will move back to the previous line (if there is
one). It backspaces destructively (erasing the previous
character) from the current cursor position. The new cursor is
returned to you, since QuickBASIC may ignore the new status.

   BkSpace Row%, Column%       ' do the backspace
   LOCATE Row%, Column%        ' inform QuickBASIC

-------
Row%      new row
Column%   new column

Name  : Blink                (Blink toggle)
Class : Display
Level : BIOS / Clone (see text)

It is possible to make characters in text mode blink by giving
them an appropriate "color". I wouldn't mention something so
obvious but for another possibility which is less widely known:
blinking can be turned off, in which case the characters that
would have otherwise blinked will instead have a bright
background. In other words, turn off blinking, and you double
the possible number of background colors.

This technique will always work with EGA and VGA displays. It
can also be used with MDA/Hercules and CGA displays, on which it
will almost always work... unfortunately, on some
less-than-perfect PC clones, it will cause the computer to lock
up instead. So, be careful with this one!

   Blink SetBlink%

SetBlink%    use blink (-1) or intense backgrounds (0)

Name  : BlockMove            (Block memory Move)
Class : Memory
Level : Clone

This routine allows you to copy or "move" a block of data from
one memory location to another. It isn't very bright, so if the
memory areas overlap, you will have to tell the routine to "move
backwards" instead of forwards. In that case, you will also have
to change the offsets to point to the ends of the memory areas
instead of the beginnings.

Normally, you can use forward moves. In that case, the offsets
you specify are those of the beginning of the memory areas. If
backward moves are required, the offsets specified are those of
the end of the memory areas.

If you are familiar with assembly language, you may recognize
this as a straightforward implementation of the "REP MOVSB"
instruction.

You may move up to 65,520 bytes at a time, provided that the
addresses are in normalized form (if you don't know what this
means, you probably don't need to worry about it).

This routine can be used to copy information to an array from
any area of memory (the BIOS data area, the screen, another
array, etc), or vice versa. It can also be used to do things
like insert/delete elements from an array, scroll the screen,
fill the screen with a specified character, and so on.

   BlockMove FromSeg%, FromOfs%, ToSeg%, ToOfs%, Bytes&, Dirn%

FromSeg%    segment of the area from which to copy
FromOfs%    offset of the area from which to copy
ToSeg%      segment of the area to which to copy
ToOfs%      offset of the area to which to copy
Bytes&      number of bytes to copy (0-65,520)
Dirn%       direction to copy (0 if forward, else backward)

Name  : BootDrive            (get Boot Drive)
Class : Disk
Level : DOS

This routine tells you which drive was used to boot the system.
See also BootDrive2, a function version of this routine.

One use for BootDrive would be in installation programs, to
determine the most likely destination drive for your software.

   Drive$ = "x"
   BootDrive Drive$

-------
Drive$   boot drive-- set it to at least one char beforehand!

Name  : BootDrive2$          (get Boot Drive)
Class : Disk
Level : DOS

This routine tells you which drive was used to boot the system.

One use for BootDrive2 would be in installation programs, to
determine the most likely destination drive for your software.

   Drive$ = BootDrive2$

-------
Drive$   boot drive (null if wrong DOS version)

Name  : BoxMenu              (Box Menu)
Class : Input
Level : Clone

This routine displays a list of items you pass it as a string
array. The list is displayed in a window in a single column. If
there are more items than will fit in the window, the items may
be scrolled as necessary. The user may pick a single item from
the list.

Many of the usual WindowManager parameters are used here-- top
row, left column, and bottom row (right column is calculated for
you), window frame color and frame type, growth, shadow, title
string and title color-- see the WindowManager routine for
details.

If you allow using the mouse, be sure the mouse is initialized
(MMCheck or MMCheck2%) and the mouse cursor is visible
(MMCursorOn) before calling this routine.

This routine automatically saves and restores the underlying
screen.

See CalcAttr if you're not familiar with color/attributes. See
also BoxMenu1 if you need to allow multiple selections.

   BoxMenu Mouse%, PickList$(), TopRow%, LeftCol%, _
      BottomRow%, Frame%, FrameAttr%, ItemListAttr%, _
      HiliteAttr%, TitleFore%, Title$, Grow%, Shade%, Result%

Mouse%          whether to support the mouse (0 no, -1 yes)
PickList$()     items to pick from (starting at PickList$(1))
TopRow%         top row of pick window
LeftCol%        left column of pick window
BottomRow%      bottom row of pick window
Frame%          frame type
FrameAttr%      frame color/attribute
ItemListAttr%   item list color/attribute
HiliteAttr%     highlight bar color/attribute
TitleFore%      title foreground color (backgnd is frame color)
Title$          title (use "" for no title)
Grow%           window growth
Shade%          window shadow
-------
Result%         number of item picked (0 if none)

Name  : BoxMenu1             (Box Menu variant 1)
Class : Input
Level : Clone

This routine displays a list of items you pass it as a string
array. The list is displayed in a window in a single column. If
there are more items than will fit in the window, the items may
be scrolled as necessary. The user may pick multiple items from
the list, using the space bar to toggle selection. All items may
be selected with Ctrl-Enter, or deselected with Ctrl-Backspace.

Many of the usual WindowManager parameters are used here-- top
row, left column, and bottom row (right column is calculated for
you), window frame color and frame type, growth, shadow, title
string and title color-- see the WindowManager routine for
details.

If you allow using the mouse, be sure the mouse is initialized
(MMCheck or MMCheck2%) and the mouse cursor is visible
(MMCursorOn) before calling this routine.

BoxMenu1 automatically saves and restores the underlying screen.

See CalcAttr if you're not familiar with color/attributes. See
also BoxMenu if you only need single-item selection.

You must pass an integer array corresponding to the pick list
array. Each of the integers flags whether the corresponding item
is picked-- 0 if no, -1 if yes. You may initialize this array
according to the selection defaults you prefer.

The Marker$ value is two characters which specify the left and
right characters to use to mark an item as selected. If you
leave Marker$ = "", the default will be "<>".

   BoxMenu1 Mouse%, PickList$(), Picked%(), Marker$, TopRow%, _
      LeftCol%, BottomRow%, Frame%, FrameAttr%, _
      ItemListAttr%, HiliteAttr%, TitleFore%, Title$, Grow%, _
      Shade%, Picks%

Mouse%          whether to support the mouse (0 no, -1 yes)
PickList$()     items to pick from (starting at PickList$(1))
Picked%()       if corresponding PickList$() item is picked
Marker$         left and right pick markers ("" for default)
TopRow%         top row of pick window
LeftCol%        left column of pick window
BottomRow%      bottom row of pick window
Frame%          frame type
FrameAttr%      frame color/attribute
ItemListAttr%   item list color/attribute
HiliteAttr%     highlight bar color/attribute
TitleFore%      title foreground color (backgnd is frame color)
Title$          title (use "" for no title)
Grow%           window growth
Shade%          window shadow
-------
Picked%()       if corresponding PickList$() item is picked
Picks%          number of items picked (0 if none)

Name  : BRead                (Byte Read)
Class : Disk
Level : DOS

This routine reads a byte from a file into an integer. The byte
is zero-extended into the integer, providing a value that may
range from 0-255.

The file must have been opened using FCreate or FOpen1.

   BRead Handle%, Value%, ErrCode%

Handle%    file handle
-------
Value%     byte read from file
ErrCode%   DOS error code (0 if no error)

Name  : BreakCheck%          (Break key Check)
Class : Input
Level : BIOS

This routine is for use after BreakOff. It allows you to see
whether the Break key has been pressed since you last checked.
The Break status is cleared after the value is returned.

   Brk% = BreakCheck%
   IF Brk% THEN
      PRINT "** Break key pressed **"
      GOTO EndProgram
   END IF

-------
Brk%    whether Break was pressed (0 no, -1 yes)

Name  : BreakOff             (Break key Off)
Class : Input
Level : BIOS

This routine disables the Break key. It is not effective in the
QB or QBX environments, as these use their own keyboard handler.
It is also not effective if your program was compiled with
Debugging on (/D switch).

Note that BreakOff installs a routine to intercept some
interrupt vectors. You MUST use the BreakOffDone routine to
reverse this process before your program ends, or the computer
will be left in an indeterminate state and will probably crash
the next time Break is pressed!

   BreakOff

Name  : BreakOffDone         (Break key Off routine Done)
Class : Input
Level : BIOS

This routine is used after BreakOff to restore the original
interrupt vectors. If you use BreakOff, you MUST call
BreakOffDone before your program ends! Otherwise, the computer
will probably crash the next time someone presses Break.

   BreakOffDone

Name  : BSq                  (Blank Squeeze)
Class : String
Level : Any

A simple compression routine, BSq "squeezes" the blank spaces in
a string. It is designed expressly for use with text data. The
text may not contain more than 131 spaces in a row, or CHR$(128)
through CHR$(255), which are used in the compression.

Average text files are liable to be compressed by around 16%.
Files that contain more spaces, such as structured programs,
will benefit more. The compression algorithm is simple but
extremely fast, adding no noticeable overhead to string
processing.

See also BUsq, BUsqLen.

   BSq St$, StLen%
   St$ = LEFT$(St$, StLen%)

St$     string to compress
-------
St$     compressed string
StLen%  length of the compressed string

Name  : BUsq                 (Blank Unsqueeze)
Class : String
Level : Any

This routine is used to uncompress strings that were processed
by BSq. Before uncompression, the BUsqLen routine must be used
to find out how long the resulting string will be.

See also BSq, BUsqLen.

   BUsqLen St$, StLen%
   IF StLen% < 0 THEN
      PRINT "Error in compressed string"
   ELSE
      Result$ = SPACE$(StLen%)
      BUsq St$, Result$
   END IF

St$      string to uncompress
-------
Result$  uncompressed string

Name  : BUsqLen              (Blank Unsqueeze Length)
Class : String
Level : Any

This routine is used in coordination with BUsq to uncompress
strings that were processed by BSq. It determines what the
length of the uncompressed string will be, which is necessary to
initialize the string for BUsq.

See also BSq, BUsq.

   BUsqLen St$, StLen%
   IF StLen% < 0 THEN
      PRINT "Error in compressed string"
   ELSE
      Result$ = SPACE$(StLen%)
      BUsq St$, Result$
   END IF

St$      string to uncompress
-------
StLen%   length of the uncompressed string

Name  : BWrite               (Byte Write)
Class : Disk
Level : DOS

This routine writes a byte to a file from an integer. The least
significant byte of the integer is written.

The file must have been opened using FCreate or FOpen1.

   BWrite Handle%, Value%, ErrCode%

Handle%    file handle
Value%     byte to write to file
-------
ErrCode%   DOS error code (0 if no error)

Name  : CalcAttr             (Calculate Attribute)
Class : Display
Level : Any

Many of the display routines in this library require an
"attribute" rather than foreground and background colors. An
attribute is a combination of the foreground and background
colors in a format which is used by all types of displays when
in text mode.

Foreground colors are usually specified as 0-31, with
backgrounds as 0-7. If you turn blinking off (see Blink), it may
be more convenient to express the same thing as foreground 0-15,
background 0-15. The CalcAttr routine will accept either way of
expressing it.

Note, however, that UnCalcAttr will always return the former
pair of results, since it has no way of knowing whether Blink
has been used (foreground 0-31, background 0-15). See UnCalcAttr
for more details and a solution.

See also CalcAttr2, the FUNCTION version of this routine.

   CalcAttr Foreground%, Background%, VAttr%

Foreground%  foreground color
Background%  background color
-------
VAttr%       color "attribute"

Name  : CalcAttr2%           (Calculate Attribute)
Class : Display
Level : Any

Many of the display routines in this library require an
"attribute" rather than foreground and background colors. An
attribute is a combination of the foreground and background
colors in a format which is used by all types of displays when
in text mode.

Foreground colors are usually specified as 0-31, with
backgrounds as 0-7. If you turn blinking off (see Blink), it may
be more convenient to express the same thing as foreground 0-15,
background 0-15. The CalcAttr2 routine will accept either way of
expressing it.

Note, however, that UnCalcAttr will always return the former
pair of results, since it has no way of knowing whether Blink
has been used (foreground 0-31, background 0-15). See UnCalcAttr
for more details and a solution.

See also CalcAttr, the SUB version of this routine.

   VAttr% = CalcAttr2%(Foreground%, Background%)

Foreground%  foreground color
Background%  background color
-------
VAttr%       color "attribute"

Name  : CalcDate             (Calculate Date)
Class : Time
Level : Any

This routine calculates what the date will be a given number of
days from now, either in the past or the future. Actually, you
may use any starting date, not just the current date. An error
code is returned if the starting date or resulting date are not
valid. Dates may not preceed January 1, 1900.

CalcDate accepts the date in any standard form ("01/30/91" or
"01-30-1991", for example) and returns its results in the same
format.

   CalcDate StartDate$, Days&, Direction%, NewDate$, ErrCode%

StartDate$   starting date
Days&        number of days from the current date (0 or more)
Direction%   return future result (0) or past (nonzero)
-------
NewDate$     resulting date
ErrCode%     whether the dates are valid (0 yes)

Name  : CalcSize             (Calculate array Size)
Class : Display
Level : Any

This routine calculates the necessary DIM size for an integer
array, assuming that you intend to store display data in the
array. This is most useful in conjunction with DGetScreen and
GetScreen.

   CalcSize TopRow%, LeftCol%, BottomRow%, RightCol%, Elements%
   DIM Array%(1 TO Elements%)

TopRow%      top row of the display area
LeftCol%     left column of the display area
BottomRow%   top row of the display area
RightCol%    left column of the display area
-------
Elements%    required size of the integer array

Name  : CalcVGAColor         (Calculate VGA palette Color)
Class : Display
Level : Any

The QuickBASIC manual gives a cumbersome formula for calculating
VGA palette colors. This routine does it faster and with less
fuss. All you need to do is pass it the appropriate intensity
values (0-63) and you get back a long integer, just the way
BASIC wants it.

   CalcVGAColor Red%, Green%, Blue%, Colour&

Red%      red   intensity
Green%    green intensity
Blue%     blue  intensity
-------
Colour&   color value for use in the PALETTE statement

Name  : Carrier              (detect Carrier)
Class : Serial
Level : Clone

If you write communications programs, particularly things like
doors and BBSes, you probably want to keep an eye on the
carrier. BASIC won't do it, but we will!

   Carrier CommPort%, CarrierHigh%

CommPort%     serial port (1-4, though BASIC only handles 1-2)
-------
CarrierHigh%  zero if no carrier

Name  : CatchError           (Catch Error from SHELL)
Class : Miscellaneous
Level : Clone

NOTE: You should use the GetError2% function in preference to
this set of routines.

The CatchError routine is used in conjunction with GetError. It
lets you get the exit code (error level) returned by a program
to which you have SHELLed. Since CatchError hooks an interrupt
to do its work, you must always make sure to use GetError
afterwards to "clean up". See also GetError.

Note that differences in DOS mean that this routine will not
always work. In some versions of DOS, you can only get the error
level if a batch file was executed; in others, you can't get the
error level from a batch file at all. Sorry about that. I don't
know of any way to work around it.

   CatchError
   SHELL ProgramName$
   GetError ExitCode%

Name  : CDROM                (check for CD-ROM)
Class : Disk / Equipment
Level : DOS

This routine tells you whether the Microsoft CD-ROM Extensions
are installed. If so, it tells you what the letter of the first
CD-ROM logical drive is and how many logical drives exist.

Note: The CD-ROM installation check conflicts with the
GRAPHICS.COM installation check for DOS 4.0, due to some
screw-up at IBM or Microsoft. This may cause unexpected results.

   FirstDrive$ = "x"
   CDROM FirstDrive$, Drives%

-------
FirstDrive$   letter of first logical drive (init to >= 1 char)
Drives%       number of logical drives (0 if no CD-ROM)

Name  : CDROM2%              (check for CD-ROM)
Class : Disk / Equipment
Level : DOS

This routine tells you whether the Microsoft CD-ROM Extensions
are installed. If so, it tells you how many logical drives
exist.

Note: The CD-ROM installation check conflicts with the
GRAPHICS.COM installation check for DOS 4.0, due to some
screw-up at IBM or Microsoft. This may cause unexpected results.

   Drives% = CDROM2%

-------
Drives%       number of logical drives (0 if no CD-ROM)

Name  : CeilD#               (Ceiling, Double-precision)
Class : String
Level : Any

This function returns the smallest integer greater than or equal
to the number you give it. This is most often used for rounding.

   Result# = CeilD#(Nr#)

Nr#          number to process
-------
Result#      result

Name  : CeilS!               (Ceiling, Single-precision)
Class : String
Level : Any

This function returns the smallest integer greater than or equal
to the number you give it. This is most often used for rounding.

   Result! = CeilS!(Nr!)

Nr!          number to process
-------
Result!      result

Name  : CenterSt$            (Center String)
Class : String
Level : Any

This function returns a string centered in a field of spaces.

   Result$ = CenterSt$(StToCenter$, Columns%)

StToCenter$   string to center
Columns%      width of field in which to center string
-------
Result$       field of spaces with string centered in it

Name  : CheckCAS%            (Check CAS driver)
Class : Serial
Level : BIOS

This function tells you whether a CAS driver is installed. CAS
is the DCA/Intel "Communicating Applications Specification"
(apparently named by someone whose prolonged wearing of ties cut
off the flow of blood to his brain) used by a number of
faxmodems. CheckCAS% returns -1 if CAS is available, 0 if not.

   CAS% = CheckCAS%

-------
CAS%        whether a CAS driver is installed (0 no, -1 yes)

Name  : CheckDate            (Check Date validity)
Class : Time
Level : Any

This routine checks a date to see if it is valid.

   CheckDate MonthNr%, DayNr%, YearNr%, ErrCode%

MonthNr%     month number (1-12)
DayNr%       day number (1-31)
YearNr%      year number (1900 on; years <100 assumed 1900s)
-------
ErrCode%     whether the date is valid (0 yes)

Name  : CheckDisk            (Check Disk readiness)
Class : Disk
Level : DOS

The CheckDisk routine determines whether a disk is ready. About
the only thing it won't tell you is if a disk is write-protected
or out of space. Since the PBClone disk routines all contain
critical error handling, which reports back an appropriate error
code for all such problems, this routine isn't really needed any
more. It's included for compatibility with old ProBas programs.

Results will normally be returned as one of the following,
although not all DOS versions report the exact cause of the
error, in which case the error number may not mean what you
expect.

   0   no error
   1   unformatted disk
   2   open drive door
   3   bad drive spec

   CheckDisk Drive$, ErrCode%

Drive$    letter of the drive to check
-------
ErrCode%  0 if no error, nonzero for error (see above)

Name  : CheckDsk%            (Check Disk readiness)
Class : Disk
Level : DOS

The CheckDsk% function determines whether a disk is ready. About
the only thing it won't tell you is if a disk is write-protected
or out of space. Since the PBClone disk routines all contain
critical error handling, which reports back an appropriate error
code for all such problems, this routine isn't really needed any
more. It's included for compatibility with old ProBas programs.

Note that DOS versions before 3.0 do not return as useful error
codes as later versions. Under such circumstances, both
"unformatted disk" and "open drive door" will be returned as
"open drive door".

   ErrCode% = CheckDsk%(Drive$)

Drive$    letter of the drive to check

Name  : CheckKey             (Check for Key or mouse)
Class : Input, Mouse
Level : BIOS

This routine is kind of an extended version of INKEY$. It checks
the keyboard to see if any key is available and gets the key if
it is. At your option, it can also check the mouse to see if a
button has been pressed.

   CheckKey Mouse%, ASCIIcode%, ScanCode%, LButton%, RButton%

Mouse%        whether to check the mouse (0: no)
-------
ASCIIcode%    ASCII code of the key pressed
ScanCode%     scan code of the key pressed (0 if none)
LButton%      whether the left  mouse button was pressed
RButton%      whether the right mouse button was pressed

Name  : CheckKey3            (Check for Key or 3-button mouse)
Class : Input, Mouse
Level : BIOS

This routine is kind of an extended version of INKEY$. It checks
the keyboard to see if any key is available and gets the key if
it is. At your option, it can also check the mouse to see if a
button has been pressed.

   CheckKey3 Mouse%, ASCIIcode%, ScanCode%, LButton%,
      MButton%, RButton%

Mouse%        whether to check the mouse (0: no)
-------
ASCIIcode%    ASCII code of the key pressed
ScanCode%     scan code of the key pressed (0 if none)
LButton%      whether the left   mouse button was pressed
MButton%      whether the middle mouse button was pressed
RButton%      whether the right  mouse button was pressed

Name  : CheckShare           (Check for SHARE)
Class : Disk
Level : DOS

The CheckShare routine determines whether SHARE.EXE is active.
This is particularly helpful before using the BASIC OPEN
statement, which will fail if you request file sharing when it's
not available. The PBClone file routines handle such situations
automatically, so CheckShare is not needed for them.

   CheckShare ShareActive%

-------
ShareActive%   whether SHARE is active (0 if no)

Name  : CheckShare2%         (Check for SHARE)
Class : Disk
Level : DOS

The CheckShare2% function determines whether SHARE.EXE is
active. This is particularly helpful before using the BASIC OPEN
statement, which will fail if you request file sharing when it's
not available. The PBClone file routines handle such situations
automatically, so CheckShare2% is not needed for them.

   ShareActive% = CheckShare2%

-------
ShareActive%   whether SHARE is active (0 if no)

Name  : Checksum             (calculate Checksum)
Class : Serial
Level : Any

The Checksum routine calculates a checksum on a string. The
resulting number is compatible with Xmodem and Ymodem checksum
routines and will vary from 0-255. This checksum provides a
minimal, but fast, check of what characters are contained in the
string. See also Checksum2%, the function version of this
routine, and CRC1.

   Checksum St$, ChkSum%

St$       string to process
-------
ChkSum%   checksum of the characters in the string

Name  : Checksum2%           (calculate Checksum)
Class : Serial
Level : Any

The Checksum2% function calculates a checksum on a string. The
resulting number is compatible with Xmodem and Ymodem checksum
routines and will vary from 0-255. This checksum provides a
minimal, but fast, check of what characters are contained in the
string. See also Checksum, the sub version of this function, and
CRC1.

   ChkSum% = Checksum2% (St$)

St$       string to process
-------
ChkSum%   checksum of the characters in the string

Name  : Cipher               (Cipher)
Class : String
Level : Any

This is a very simple text encryption routine. It isn't
particularly hard to crack, but will provide a basic level of
security for undemanding applications. The same routine can be
used either to encrypt or decrypt text. The original text may
contain any character; likewise, the resulting text. This is not
well suited for use with sequential files-- if such is required,
see CipherP.

I'd suggest using a long password composed of an unlikely string
of characters, e.g. "#*@@!A^%x{.'".

   Cipher St$, Password$

St$        string to encrypt or decrypt
Password$  password
-------
St$        encrypted or decrypted string

Name  : CipherP              (Cipher Printable)
Class : String
Level : Any

This is a very simple text encryption routine. It isn't
particularly hard to crack, but will provide a basic level of
security for undemanding applications. The same routine can be
used either to encrypt or decrypt text. The original text may
contain any character below CHR$(128), as may the password. The
resulting text will be printable, if bizarre (all characters
will be above CHR$(127)), and may be used with sequential files.

This routine is potentially less secure than the Cipher routine
(see).

I'd suggest using a long password composed of an unlikely string
of characters, e.g. "#*@@!A^%x{.'".

   CipherP St$, Password$

St$        string to encrypt or decrypt
Password$  password
-------
St$        encrypted or decrypted string

Name  : ClearArea            (Clear a screen Area)
Class : Display
Level : Clone

This routine clears an area of the screen to a specified color.
The clearing is done by removing random characters until the
area is totally clear.

   ClearArea TRow%, LCol%, BRow%, RCol%, VAttr%, Fast%

TRow%       top row of area to clear
LCol%       left column of area to clear
BRow%       bottom row of area to clear
RCol%       right column of area to clear
VAttr%      color/attribute to clear to
Fast%       whether to use fast displays (0 no)

Name  : Clock                (Clock)
Class : Display / Time
Level : Clone

This routine allows you to turn a visible time display on or
off. When on, the time will be continuously displayed at a
selected location while your program continues processing. The
clock is managed as a background process, in effect doing some
simple multitasking.

You should turn the clock off before you terminate your program,
including any time you execute another program with RUN. The
clock can be safely kept on when you SHELL to another program,
however, as long as you can be sure that control will return to
your program when the other is done.

The clock must also be turned off if you change any of its
parameters with the ClockSet routine (see).

The clock will only be visible when the display is in text mode.
The use of PLAY or SOUND statements may shut off the clock,
depending on your version of the BASIC compiler.

   Clock DisplayOn%

DisplayOn%   whether to display the clock (0 if no)

Name  : ClockSet             (Clock Settings)
Class : Display / Time
Level : Clone

The ClockSet routine is used in conjunction with Clock (see). It
should only be used when the clock is turned off.

This routine allows you to set 12-hour or 24-hour time, whether
to display the seconds or not, how often to update the clock
display (in 1/18th seconds; 9 is usually the best choice), where
to display the clock and in what color, and whether to use
flicker-free displays (needed for cheap CGAs only). The defaults
are 12-hour time, display seconds, put the time (in white on
black) in the upper right corner, and display quickly (may
flicker on some CGAs).

   ClockSet Hours24%, Seconds%, Updates%, Row%, Column%, _
      VAttr%, Fast%

Hours24%   whether to display 24-hour time (0 if no)
Seconds%   whether to display seconds (0 if no)
Updates%   display update frequency in 1/18th seconds
Row%       row on which to display the clock
Col%       column at which to display the clock
VAttr%     color/attribute to use (see CalcAttr)
Fast%      whether to use fast mode (0 no)

Name  : CloseA               (Close Archive)
Class : Disk / Time
Level : DOS

This routine closes an archive opened by FindFirstA or
FindNextA. It must be used when you are done searching the
archive.

Routines in this series include:
   FindFirstA, FindNextA, GetNameA, GetCRCA, GetCRCAL,
   GetDateA, GetTimeA, GetSizeAL, GetStoreA

   CloseA

Name  : ClrCols              (Clear Columns)
Class : Display
Level : BIOS

This routine clears the current row between the specified
columns, inclusive. It does not affect the cursor position.

   ClrCols StartCol%, EndCol%

StartCol%  starting column
EndCol%    ending column

Name  : ClrEOL               (Clear to End Of Line)
Class : Display
Level : BIOS

This routine clears from the cursor to the end of the line,
inclusive. It does not affect the current cursor position.

   ClrEOL

Name  : ClrEOP               (Clear to End Of Page)
Class : Display
Level : BIOS

This routine clears from the cursor to the end of the display,
inclusive. It does not affect the current cursor position.

   ClrEOP

Name  : ClrKbd               (Clear Keyboard buffer)
Class : Input
Level : DOS

ClrKbd clears the keyboard buffer, discarding any keys that may
be waiting. This is a good idea for situations where an
unexpected input is made and you don't want to chance it being
answered accidentally by keys that were typed beforehand-- for
instance, in the event of an error or other condition where it
is important that the user see a message or take an action
before pressing a key.

   ClrKbd

Name  : ClrSOL               (Clear to Start Of Line)
Class : Display
Level : BIOS

This routine clears from the start of the line to the cursor,
inclusive. It does not affect the current cursor position.

   ClrSOL

Name  : ClrSOP               (Clear to Start Of Page)
Class : Display
Level : BIOS

This routine clears from the start of the display to the cursor,
inclusive. It does not affect the current cursor position.

   ClrSOP

Name  : Command2$            (Command line)
Class : Miscellaneous
Level : DOS

This function returns the original DOS command line. It works
like COMMAND$, but does not trim or capitalize the command line.

The area in which the command line is stored may be recycled for
other purposes, so you should use Command2$ as near to the start
of your program as possible.

NOTE that this function returns the actual command line. If you
use it in the editor/environment, it will return the command
line you used to start QB/QBX/VB-DOS, rather than any imitation
command line you installed while in the editor. The BASIC
editor/environment does not set the actual command line with
your choice, unfortunately-- it fakes out COMMAND$ instead. It
is not able to fool Command2$ in the same way.

   CmdLine$ = Command2$

-------
CmdLine$    original DOS command line

Name  : CopyFile             (Copy a File)
Class : Disk
Level : DOS

This works like the DOS COPY command, although it does not allow
wildcards. One file is copied to another, retaining the same
date and time. Full path specifications are supported, including
drive and subdirectory specs.

See also FileCopy, which supports wildcards.

   CopyFile FromFile$, ToFile$, ErrCode%

FromFile$   name of file to copy
ToFile$     name of new file to create
-------
ErrCode%    0 if no error, else DOS Error

Name  : CPrintScreen1        (CGA Print Screen [SCREEN 1])
Class : Display / Printer
Level : Clone

This routine dumps a SCREEN 1 display (CGA 320x200) to the
printer. It uses the stdprn device (normally PRN or LPT1) by
default, although this can be altered with the PrtSwap routine.

   CPrintScreen1

Name  : CPrintScreen2        (CGA Print Screen [SCREEN 2])
Class : Display / Printer
Level : Clone

This routine dumps a SCREEN 2 display (CGA 640x200) to the
printer. It uses the stdprn device (normally PRN or LPT1) by
default, although this can be altered with the PrtSwap routine.

   CPrintScreen2

Name  : CPUSpeed%            (CPU Speed)
Class : Equipment
Level : Clone

This function returns the approximate CPU speed in MHz. It may
take several seconds to find the speed of slower processors, so
don't expect an immediate response. Results can be skewed by
multitasking and background processing.

   MHz% = CPUSpeed%

-------
MHz%       approximate CPU speed

Name  : CRC                  (calculate CRC)
Class : String / Serial
Level : Any

This routine has become obsolete; the CRC1 routine is much
faster. However, CRC is still included for backwards
compatibility.

This routine calculates a complex 16-bit checksum, called a
Cyclical Redundancy Check (or CRC) on a string. The results are
compatible with Xmodem and Ymodem CRC routines. The CRC provides
a fairly reliable check of what characters are contained in the
string. See also Checksum.

If you are using this routine for Xmodem or Ymodem, note that
the string should be padded with two null characters before
calculating a "send" CRC: St$ = St$ + STRING$(2, 0). On receive,
you should calculate the CRC on the entire data block, plus the
received CRC; if the block was received correctly, the
calculated CRC will be zero in both lsb and msb.

Although Intel notation uses "lsb, msb" order, the Xmodem/Ymodem
CRC uses the opposite format, which is why the parameters are
ordered in this fashion.

   CRC St$, CRCmsb%, CRClsb%

St$       string to process
-------
CRCmsb%   most significant byte of CRC
CRClsb%   least significant byte of CRC

Name  : CRC1                 (calculate CRC)
Class : String / Serial
Level : Any

This routine calculates a complex 16-bit checksum, called a
Cyclical Redundancy Check (or CRC) on a string. The results are
compatible with Xmodem and Ymodem CRC routines. The CRC provides
a fairly reliable check of what characters are contained in the
string. See also Checksum.

Note that CRC1 does not work like the older CRC routine. You
should not pad outgoing strings with a STRING$(2, 0) sequence.

Although Intel notation uses "lsb, msb" order, the Xmodem/Ymodem
CRC uses the opposite format, which is why the parameters are
ordered in this fashion.

   CRC1 St$, CRCmsb%, CRClsb%

St$       string to process
-------
CRCmsb%   most significant byte of CRC
CRClsb%   least significant byte of CRC

Name  : CRC32Calc            (CRC 32-bit Calculation)
Class : String / Serial
Level : Any

This routine calculates a complex 32-bit checksum, called a
Cyclical Redundancy Check (or CRC) on a string. The results are
compatible with Zmodem CRC routines as well as those used by
popular archive utilities. The CRC provides a fairly reliable
check of what characters are contained in the string.

This routine must be used with two others. Before starting a CRC
calculation, call CRC32Init. You can then use CRC32Calc on one
or more strings for which you desire a CRC calculation. When
you're done, you call CRC32Done&, which returns the final
result. This approach allows you to calculate CRCs for data
which may be stored in more than one string.

   CRC32Calc St$

St$       string to process
-------

Name  : CRC32Done&           (CRC 32-bit Done)
Class : String / Serial
Level : Any

This routine returns the result of a 32-bit CRC calculation for
a string. See also CRC32Init and CRC32Calc.

   Result& = CRC32Done&

-------
Result&     32-bit CRC

Name  : CRC32Init            (CRC 32-bit Initialize)
Class : String / Serial
Level : Any

This routine initializes a 32-bit CRC calculation for a string.
See also CRC32Done& and CRC32Calc.

   CRC32Init

Name  : CreditCard$          (Credit Card validation)
Class : Miscellaneous
Level : Any

USE AT YOUR OWN RISK. This function has worked in my tests, but
I can't guarantee it will work for you. This is true of all
PBClone routines, but I feel it important to re-emphasize this
for this particular function. If you're not comfortable with
this lack of warranty, DON'T USE PBCLONE.

This function checks a credit card number for consistency, to
see if it is possibly valid. If the number seems reasonable, the
card type is returned as a four-character code:

   AMEX    American Express
   DINE    Diner's Club
   DISC    Discover
   MCAR    MasterCard
   VISA    Visa

Otherwise, a null string ("") is returned. The number is checked
according to length and self-consistency according to a
validation formula. Non-numeric characters are ignored.

NOTE that this function cannot ensure that a credit card number
-is- really valid. It can only tell you whether a card number is
-not- valid, to the best of its understanding. Its intended use
is in data-entry routines and similar operations which may
benefit from a "sanity check". *** USE AT YOUR OWN RISK ***

   CardName$ = CreditCard$(CardNumber$)
   IF LEN(CardName$) = 0 THEN PRINT "Error in card number"

CardNumber$    credit card number
-------
CardName$      type of credit card ("" if invalid)

Name  : Crunch               (Crunch repeated characters)
Class : String
Level : Any

It was hard to decide on a name for this routine, and I don't
know if I've done the best job. What Crunch does is to eliminate
repeated sequences of the same character. For instance, if you
gave it "This is a test" and asked it to crunch spaces, it would
return "This is a test". I use this to filter information from
the COMMAND$ function, but it's a good general purpose input
filter.

   Crunch St$, Ch$, StLen%
   St$ = LEFT$(St$, StLen%)

St$       string to be processed
Ch$       character to crunch out of the string
-------
St$       crunched string
StLen%    length of the crunched string

Name  : CtrlKey              (Control Key)
Class : Input
Level : Any

This routine works in conjunction with a key input routine, such
as INKEY$ or the CheckKey and GetKey routines. Given the ASCII
code of a key, CtrlKey returns the associated key letter, if
any. For instance, it returns "A" if you pass it ASCII code 1,
because that code represents Ctrl-A.

   CtrlKey ASCIICode%, Ky$

ASCIICode%   ASCII code of the key
-------
Ky$          associated key letter ("" if none)

Name  : CursorInfo           (Cursor Information)
Class : Input
Level : Clone

While BASIC allows you to set the size and shape of the cursor
with LOCATE, it's fairly hazardous to do so. There is no way to
find out the maximum size of the cursor, so your cursor may end
up a peculiar shape on some adapters. If you change the cursor
size or visibility in a subprogram, you may be screwing up the
main program.

CursorInfo offers a solution to these problems. It returns the
current cursor visibility and size, plus the maximum size
possible with the current video adapter. The minimum size will
always be zero, so it is not reported.

   CursorInfo Visible%, StartLine%, EndLine%, MaxLine%

-------
Visible%      whether the cursor is visible (0 no, 1 yes)
StartLine%    starting scan line of cursor
EndLine%      ending scan line of cursor
MaxLine%      maximum possible scan line for cursor

Name  : CWindowManager       (CGA Window Manager)
Class : Display
Level : Clone

CWindowManager displays a pop-up window on a CGA graphics
screen. It is intended for SCREEN 1, although it can be used on
SCREEN 2 as well (it will still have 40 columns and will display
shades rather than colors). The window may have any of a variety
of frames, a title, or a shadow, and it may appear instantly or
"grow" onto the screen.

These are the available frame types:
    0   no frame
    1   single lines
    2   double lines
    3   single horizontal, double vertical lines
    4   double horizontal, single vertical lines
    5   block graphic lines

Options for growing windows are as follows:
   -1   grow as fast as possible
    0   pop onto the screen
   1+   grow with delay given in milliseconds (15 works for me)

Note that this routine is different from its ProBas equivalent
in a number of respects. The grow delay time is different.
Growing is done more smoothly. The shadow and title parameters
are not changed by this routine. A new frame type (5) was added.
If a title is too long, it is truncated instead of being ignored
completely. Using a -1 as the title foreground color will not
turn off the title; instead, use a null title string.

   CWindowManager TRow%, LCol%, BRow%, RCol%, Frame%,
      Fore%, Back%, Grow%, Shade%, TFore%, Title$, Fast%

TRow%       top row of window
LCol%       left column of window
BRow%       bottom row of window
RCol%       right column of window
Frame%      frame type (see above)
Fore%       frame foreground color
Back%       frame background color
Grow%       window growing option (see above)
Shade%      window shadow option (0 for none)
TFore%      title foreground color
Title$      window title ("" if none)
Fast%       whether to use fast mode (0 no)

Name  : Cylinders%           (Cylinders)
Class : Disk
Level : DOS 3.3+

This function returns the number of cylinders for a given disk
drive. If the drive does not exist or is not a physical drive,
-1 will be returned. Note that the number of cylinders may be a
virtual number in some cases (such as drives compressed by the
DBLSPACE driver included with MS-DOS 6.0).

You may use "" to denote the current drive.

   Cyls% = Cylinders% (Drive$)

Drive$    drive for which to return cylinders
-------
Cyls%     number of cylinders (-1 if error)

Name  : DataSeg              (Data Segment)
Class : Memory
Level : Any

It's rare that you need to know the data segment used by BASIC,
but it does happen. DataSeg tells you that value. This is the
segment used by (near) strings, static arrays (except in the
QuickBASIC environment), some COMMON data, BASIC internal
variables and so forth. It is also the area specified by a plain
"DEF SEG", though not (usually) by "DEF SEG=xxxx".

There is also a function version of this routine, DataSeg2%.

   DataSeg DSeg%

-------
DSeg%     data segment for BASIC

Name  : DataSeg2%            (Data Segment)
Class : Memory
Level : Any

It's rare that you need to know the data segment used by BASIC,
but it does happen. DataSeg2% tells you that value. This is the
segment used by (near) strings, static arrays (except in the
QuickBASIC environment), some COMMON data, BASIC internal
variables and so forth. It is also the area specified by a plain
"DEF SEG", though not (usually) by "DEF SEG=xxxx".

There is also a sub version of this routine, DataSeg.

   DSeg% = DataSeg2%

-------
DSeg%     data segment for BASIC

Name  : Date2Int             (Date to Integer)
Class : Time
Level : Any

This routine compresses a date into a single integer. Note that
this integer is not in a format that lends itself to simple
computation-- you cannot subtract one from another to find out
the length of time between them. However, as long as the year is
in the range 1980-2042, you can compare the two integers to see
if one date is before or after another.

You may express the year as either a two-digit or four-digit
number.

The ProBas and PBClone versions of this routine do not work the
same way in regards to the year. ProBas assumed that any
two-digit year was in the 1900s. In contrast, PBClone assumes
that years 80-99 should be converted to 1980-1999 and that 0-79
should be converted to 2000-2079. I consider the PBClone method
more appropriate, with the turn of the century moving closer.
The date format used does not allow dates before 1980 anyway, so
nothing is being lost by this change.

   Date2Int MonthNr%, DayNr%, YearNr%, IntDate%

MonthNr%     month number (1-12)
DayNr%       day (1-31)
YearNr%      year (1980-2079; see above for two-digit years)
-------
IntDate%     date compressed into an integer

Name  : DateA2R              (Date Actual to Relative)
Class : Time
Level : Any

This routine converts an actual date to a relative date,
expressed as a number of days. This allows you to compare dates,
find out what the date will be in a given number of days (or
what it was a given number of days ago), see how many days
passed between two dates, and so forth.

I've frequently seen routines of this nature called "Julian
date" routines. I'm not sure where that nomenclature originated,
as it has nothing to do with the Julian calendar. Most of these
routines rely on approximations through floating point math, and
may or may not handle leap years and centuries appropriately.
The DateA2R routine takes no such shortcuts and may be relied
upon to return accurate results.

   DateA2R MonthNr%, DayNr%, YearNr%, RelDate&

MonthNr%     month number (1-12)
DayNr%       day number (1-31)
YearNr%      year number (1900 on; years <100 assumed in 1900s)
-------
RelDate&     relative date

Name  : DateN2S              (Date Numbers to String)
Class : Time
Level : Any / DOS

Many of the PBClone routines return the date as a set of
numbers. This routine provides an easy way to convert those
numbers into string form. The date format used (year length and
delimiter) will be based on the string which you pass to the
routine. For instance, "xx-xx-xxxx" will return a date like
"11-26-1990", whereas "xx.xx.xxxx" would return "11.26.1990",
and "xx/xx/xx" would return "11/26/90".

If you pass zeroes for the MonthNr%, DayNr%, and YearNr% values,
the current date will be returned in the format that you
specified.

The ProBas and PBClone versions of this routine do not work the
same way in regards to the year. ProBas assumed that any
two-digit year was in the 1900s. In contrast, PBClone assumes
that years 80-99 should be converted to 1980-1999 and that 0-79
should be converted to 2000-2079.

   DateSt$ = "xx-xx-xxxx"
   DateN2S MonthNr%, DayNr%, YearNr%, DateSt$

MonthNr%  month
DayNr%    day
YearNr%   year
-------
DateSt$   date string.  Init to 8 or 10 chars (see above).

Name  : DateR2A              (Date Relative to Actual)
Class : Time
Level : Any

This is the opposite of the DateA2R routine-- it takes a
"relative" date and converts it back to the usual form.

   DateR2A MonthNr%, DayNr%, YearNr%, RelDate&

RelDate&     relative date
-------
MonthNr%     month number (1-12)
DayNr%       day number (1-31)
YearNr%      year number (1900 on)

Name  : DateS2N              (Date String to Numbers)
Class : Time
Level : Any

Many of the PBClone routines need to be passed the date as a set
of numbers. This routine provides an easy way to convert a date
from string form into numbers. You may use either "xx/xx/xx" or
"xx-xx-xxxx" form to specify the date (the string length is
important, but the delimiter and contents of the string are
ignored).

The ProBas and PBClone versions of this routine do not work the
same way in regards to the year. ProBas assumed that any
two-digit year was in the 1900s. In contrast, PBClone assumes
that years 80-99 should be converted to 1980-1999 and that 0-79
should be converted to 2000-2079.

   DateS2N MonthNr%, DayNr%, YearNr%, DateSt$

DateSt$   date string.  Init to 8 or 10 characters (see above).
-------
MonthNr%  month
DayNr%    day
YearNr%   year

Name  : DblSpace%            (DBLSPACE check)
Class : Disk
Level : BIOS

This function returns whether DBLSPACE, the disk space doubler
that debuted in MS-DOS 6.0, is installed.

   Dbl% = DblSpace%

-------
Dbl%        whether DBLSPACE is installed (0 no, -1 yes)

Name  : DCal                 (Direct-to-memory Calendar)
Class : Time
Level : Any

This routine draws a calendar for a specific month and year. The
results are placed in an array which can be displayed using
ScrRest or the other PBClone routines to restore a screen image.

You must supply an integer array large enough to hold the image
generated by DCal, which expects a 25x80 screen. DIM Scrn%(1 TO
2000) will do it. If you supply a null date, the current date
will be used.

   DCal Scrn%(), CalDate$

Scrn%()      array to hold screen image
CalDate$     date for the calendar
Page%        ignored
Fast%        ignored

Name  : DCalendar            (Direct-to-memory Calendar)
Class : Time
Level : Clone

This routine displays a calendar for a specific month and year.
It waits for input and acts accordingly, allowing the user to
move to different dates via the arrow keys or by entering the
date directly. The bottom row of the screen gives a list of the
available key commands.

Screen handling is largely done by writing to an array, then
dumping the entire array to the display with DScrRest. This
provides for very smooth displays. You must supply an integer
array large enough to hold the image generated by DCalendar,
which expects a 25x80 screen. DIM Scrn%(1 TO 2000) will do it.
Only text mode is supported by this routine.

If you supply a null date, the current date will be used.

   DCalendar Scrn%(), CalDate$, Page%, Fast%

Scrn%()      array to hold screen image
CalDate$     date for the calendar
Page%        page on which to display (normally zero)
Fast%        whether to use fast mode (0 no)

Name  : DClear               (Direct-to-memory Clear)
Class : Display
Level : Any

The DClear routine allows you to clear a text-mode display.

This routine does not necessarily work on the display itself.
Instead, it allows you to specify the memory location (segment
and offset) of the "screen", which may be an actual screen, a
saved screen in an array, a multitasker's virtual screen, etc.
Among other things, this makes it easy to work with two displays
at once: use a segment of &HB000 for the mono display and &HB800
for the color display (the offset in each case is zero).

   DClear DSeg%, DOfs%, VAttr%

DSeg%    segment of "screen" memory
DOfs%    offset of "screen" memory
VAttr%   color/attribute to use (see CalcAttr)

Name  : DClearSS             (Direct Clear for Specified Size)
Class : Display
Level : Any

Like the CLS statement, this routine allows you to clear a text
display. However, rather than clearing the actual screen,
DClearSS clears a screen that is stored in an array. This allows
you to design a screen in memory, then flash it onto the display
using PutScreen or a similar routine.

This routine is designed for a text screen of any specified
size.

   DClearSS DSeg%, DOfs%, VAttr%, Rows%, Columns%

DSeg%     segment of the array that holds the screen
DOfs%     offset of the array that holds the screen
VAttr%    color/attribute to use (see CalcAttr)
Rows%     length of the screen
Columns%  width of the screen

Name  : Dec2Any              (Decimal to Any base)
Class : Numeric
Level : Any

This routine converts a normal integer to a number in any base.
It works like the HEX$ function in BASIC, but rather than
working only in hexadecimal (base 16), it can be used for
binary, octal, or almost anything else.

The result will be right-justified in the string you provide. If
you use zeroes, this allows you to ignore the NumberLen% spec
and just trim the string to the desired length, leaving nothing
worse than possible leading zeroes.

The length needed by the return string will vary according to
the number, with a maximum length depending on the number base
chosen. For integers, this will be at most 16 characters (worst
case: base 2 or binary).

   Number$ = STRING$(16, "0")
   Dec2Any DecimalNr%, NrBase%, Number$, NumberLen%
   Number$ = RIGHT$(Number$, NumberLen%)

DecimalNr   integer to convert to another base
NrBase%     desired number base (2-31)
-------
Number$     resulting number in desired base (init >= 16 chars)
NumberLen%  length of the result (-1 if string too short)

Name  : Delay                (Delay for seconds)
Class : Time
Level : Clone

This routine delays for a given number of seconds. The timing
will be the same from an 8088 PC through an 80486 AT-- it's
entirely independent of the processor. See also Delay18th.

   Delay Seconds%

Seconds%   number of seconds for which to delay

Name  : Delay18th            (Delay for 1/18th seconds)
Class : Time
Level : Clone

This routine delays for a given number of 18ths of seconds. The
timing will be the same from an 8088 PC through an 80486 AT--
it's entirely independent of the processor. See also Delay.

   Delay WaitTime%

WaitTime%  number of 18ths of seconds for which to delay

Name  : DelayV               (Delay based on Video timing)
Class : Time
Level : Clone

This routine delays for a given number of milliseconds. The
timing is based on a signal from the video adapter and may vary
somewhat depending on the adapter. The delay is largely
independent of the cpu type and speed, however.

For anyone unfamiliar with the metric system: there are 1000
milliseconds in one second. Depending on the specific display
adapter, this routine may well be fairly inaccurate; it is
intended for providing small delays for animation and similar
purposes, not as a reliable timer.

   DelayV MilliSeconds%

MilliSeconds%   number of milliseconds for which to delay

Name  : DelChr               (Delete Character)
Class : Display
Level : Clone

The DelChr routine deletes the character at the specified screen
location.

   DelChr Row%, Column%

Row%      row of character
Column%   column of character

Name  : DelFile              (Delete File)
Class : Disk
Level : DOS

This works like the DOS DEL (or ERASE) command, although it does
not allow wildcards. The specified file is deleted. Full path
specifications are supported, including drive and subdirectory
specs.

   DelFile FileName$, ErrCode%

FileName$   name of the file to delete
-------
ErrCode%    0 if no error, else DOS Error

Name  : DelLine              (Delete Line)
Class : Display
Level : BIOS

This routine deletes the specified row from the screen.

   DelLine Row%, VAttr%

Row%      row to delete
VAttr%    color/attr to use on new bottom row (see CalcAttr)

Name  : DelSub               (Delete Subdirectory)
Class : Disk
Level : DOS

This works like the DOS RD (or RMDIR) command. It does not allow
wildcards. The specified subdirectory is deleted. Note that you
may not delete a subdirectory that you're located in, or a
subdirectory which contains files, or the root directory.

   DelSub SubDir$, ErrCode%

SubDir$     name of the subdirectory to delete
-------
ErrCode%    0 if no error, else DOS Error

Name  : DFRead               (Direct-to-memory File Read)
Class : Disk
Level : DOS

This routine reads data into an array from a file that was
opened by FOpen1 or FCreate. If it wasn't possible to read it
all from the file, an error code will be returned and the
BytesRead% value will tell you how many bytes were actually
read.

   DFRead Handle%, DSeg%, DOfs%, Bytes%, BytesRead%, ErrCode%

Handle%     handle of the file from which to read
DSeg%       segment of the array into which to read the file
DOfs%       offset of the array into which to read the file
Bytes%      number of bytes to read
-------
BytesWrit%  # of bytes actually read from the file (if error)
ErrCode%    error code: 0 if no error, else DOS Error

Name  : DFWrite              (Direct-from-memory File Write)
Class : Disk
Level : DOS

This routine writes data from an array to a file that was opened
by FOpen1 or FCreate. If it wasn't possible to write it all to
the file, an error code will be returned and the BytesWrit%
value will tell you how many bytes were actually written.

   DFWrite Handle%, DSeg%, DOfs%, Bytes%, BytesWrit%, ErrCode%

Handle%     handle of the file to which to write
DSeg%       segment of the data to write to the file
DOfs%       offset of the data to write to the file
Bytes%      number of bytes to write
-------
BytesWrit%  # of bytes actually written to the file (if error)
ErrCode%    error code: 0 if no error, else DOS Error

Name  : DGClear              (Direct-to-memory Graphics Clear)
Class : Display
Level : Any

This routine works like the CLS statement, clearing a CGA
graphics display. However, rather than clearing the actual
screen, DClearSS clears a screen that is stored in an array.
This allows you to design a screen in memory, then flash it onto
the display using GrafRest.

This routine is designed for use with SCREEN 1 or SCREEN 2 (CGA
graphics).

   DGClear DSeg%, DOfs%, Colour%

DSeg%     segment of the array that holds the screen
DOfs%     offset of the array that holds the screen
Colour%   color to use

Name  : DGetRec              (Direct-from-memory Get Record)
Class : String
Level : Clone

The DGetRec routine allows you to get a string from a specified
area of memory (numeric array, BIOS data area, display memory,
or whatever). The string should be initialized to the desired
record length in advance.

This works somewhat like an array of fixed length strings or a
random file, treating memory as a contiguous series of records
of a specified length.

   DGetRec DSeg%, DOfs%, RecNr%, St$

DSeg%      segment of the array to read from
DOfs%      offset of the array to read from
RecNr%     record number (starting at 1)
-------
St$        returned string.  Init to record length (see above).

Name  : DGetScreen           (Direct memory Get Screen image)
Class : Display
Level : Clone

This routine saves any portion of the display to an array. Only
text modes are supported. If your program uses multiple display
pages, you can get an image from any of those pages. A special
"slow" mode is supported for the CGA, to prevent flickering (a
problem only with some CGAs).

The size of the integer array needed to store a specific area of
the screen can be calculated using the CalcSize routine (see).

The GetScreen routine works the same way as this, but has a
simpler calling convention. Also, if you wish to save the entire
screen, you may find ScrSave easier.

   DGetScreen DSeg%, DOfs%, TRow%, LCol%, BRow%, RCol%,
      Page%, Fast%

DSeg%      segment of the array in which to store the image
DOfs%      offset of the array in which to store the image
TRow%      top row of the desired screen area
LCol%      left column of the desired screen area
BRow%      bottom row of the desired screen area
RCol%      right column of the desired screen area
Page%      page from which to get the display area
Fast%      whether to use fast mode (0 no)

Name  : DGetSt               (Direct-from-memory Get String)
Class : String
Level : Clone

The DGetSt routine allows you to get a string from a specified
area of memory (numeric array, BIOS data area, display memory,
or whatever). The string should be initialized to the desired
length in advance.

You may specify an additional offset from the initial location,
which itself is specified as a segment and an offset. The second
offset begins with position 1. The combined total of the two
offsets must be under 65,536. With normalized segment and offset
specifications, which is usually the case, this allows you to
specify a number from 1-65,521 for the second offset.

   DGetSt DSeg%, DOfs%, Posn&, St$

DSeg%      segment of the array to read from
DOfs%      offset of the array to read from
Posn&      location relative to the start of the array
-------
St$        returned string.  Init to # of chars desired.

Name  : DGQPrint             (Direct Graphics Quick Print)
Class : Display
Level : Any

This is a simple high-speed replacement for the PRINT statement
which works on a CGA virtual graphics screen (SCREEN 2). It does
not interpret control codes or support graphics characters
(ASCII 128-255).

DGQPrint allows you to display to a CGA even if it isn't the
active display (use a segment of &HB800 and offset of 0). Its
intended use, however, is to display to a virtual screen kept in
an array or other memory area. The results can then be displayed
using GrafRest.

   DGQPrint DSeg%, DOfs%, St$, Row%, Column%

DSeg%    segment of CGA virtual screen
DOfs%    offset of CGA virtual screen
St$      string to display
Row%     row (1-25)
Column%  column (1-80)

Name  : DGXQPrint            (Direct Graphics Extended Q Print)
Class : Display
Level : Any

This is a simple high-speed replacement for the PRINT statement
which works on a CGA virtual graphics screen (SCREEN 1). It does
not interpret control codes or support graphics characters
(ASCII 128-255).

This routine can also be used on a SCREEN 2 display, where it
will display the string in shades instead of in color (using 40
columns/row).

DGXQPrint allows you to display to a CGA even if it isn't the
active display (use a segment of &HB800 and offset of 0). Its
intended use, however, is to display to a virtual screen kept in
an array or other memory area. The results can then be displayed
using GrafRest.

The results of this routine are not redirectable by DOS.

   DGXQPrint DSeg%, DOfs%, St$, Row%, Column%, Fore%

DSeg%    segment of CGA virtual screen
DOfs%    offset of CGA virtual screen
St$      string to display
Row%     row (1-25)
Column%  column (1-40)
Fore%    foreground color (0-3)

Name  : DGXQPrint1           (Direct Graphics Extended Q Print)
Class : Display
Level : Any

This is a high-speed replacement for the PRINT statement which
works on a CGA virtual graphics screen (SCREEN 1). It does not
interpret control codes.

This routine can also be used on a SCREEN 2 display, where it
will display the string in shades instead of in color (using 40
columns/row).

DGXQPrint1 allows you to display to a CGA even if it isn't the
active display (use a segment of &HB800 and offset of 0). Its
intended use, however, is to display to a virtual screen kept in
an array or other memory area. The results can then be displayed
using GrafRest.

The results of this routine are not redirectable by DOS.

   DGXQPrint1 DSeg%, DOfs%, St$, Row%, Column%, Fore%, Back%

DSeg%    segment of CGA virtual screen
DOfs%    offset of CGA virtual screen
St$      string to display
Row%     row (1-25)
Column%  column (1-40)
Fore%    foreground color (0-3)
Back%    background color (0-3)

Name  : DInput               (Dollar Input)
Class : Input
Level : Clone

This routine provides formatted input of a dollar amount. You
specify the format and an initial value (may be zero). You may
also specify whether to allow negation-- if so, the user may
press the "-" key to toggle the number between negative and
positive. The numeric keypad will automatically be locked into
the numeric state. Since the decimal point is implicit, the "."
key functions as a delete or backspace operation, for convenient
one-handed data entry and correction.

The dollar amount is kept in a long integer as a number of
pennies, to avoid the possibility of round-off errors which
might result from use of floating point math. The results are
returned to you both as a long integer and as a formatted
number.

The format string works just like a PRINT USING format string.
Editing is not as flexible as for SInput, but is quite adequate.
The SInputSet routines will work for DInput as well as SInput.
The ExitCode% returned is the same as for SInput, but left and
right arrows may also be returned.

   DInput Format$, St&, St$, MinusOk%, VAttr%, ExitCode%

Format$    numeric format (just like PRINT USING format)
St&        dollar amount (in pennies)
MinusOk%   whether negation is allowed (0 if no)
VAttr%     color/attribute to use (see CalcAttr)
-------
St&        dollar amount (in pennies)
St$        formatted dollar amount
ExitCode%  key used to exit (ASCII code if +, scan code if -)

Name  : DiskStat             (Disk Statistics)
Class : Disk
Level : DOS

DiskStat gives you statistics on the memory usage of a specified
disk drive: the total number of clusters, the number of
available or free clusters, the number of sectors per cluster,
and the number of bytes per sector.

From this information, you can determine how much total disk
space there is, how much space is left and how much is used, the
size of a cluster, et al.

A few formulas for you:

   ClusterSize% = BytesPerSec% * SecsPerClus%
   FreeSpace& = FreeClus& * ClusterSize%
   TotalSpace& = TotalClus& * ClusterSize%
   UsedSpace& = TotalSpace& - FreeSpace&

A "cluster" is the minimum amount of disk space that can be
allocated at a time. A typical cluster size for a medium-sized
hard drive is 2048 bytes, which means that any file from 1-2048
bytes in length is actually taking up a full 2048 bytes on the
disk. Large cluster sizes improve file access times but can
waste a lot of disk space.

   DiskStat Drive$, FreeClus&, TotalClus&, BytesPerSec%,
      SecsPerClus%

Drive$        letter of the drive to examine
-------
FreeClus&     number of free or available clusters
TotalClus&    total number of clusters
BytesPerSec%  bytes per sector
SecsPerClus%  sectors per cluster (-1 if bad drive, etc)

Name  : Dissolve             (Dissolve)
Class : Display
Level : Clone

Like CLS, but a bit more fancy, this routine provides an
interesting way to clear the screen. See also FadeOut.

This routine may cause heavy flickering on some CGA displays.

   Dissolve VAttr%

VAttr%   color/attribute to which to clear (see CalcAttr)

Name  : DMPrint              (DOS Message Print)
Class : Display
Level : DOS

This routine is similar to PRINT, but goes through DOS output
services, which allows your program to support output
redirection, filters, CTTY and other handy things. See DOSInkey
for a DOS input service.

Note that the use of DMPrint means that you should avoid using
BASIC display handling (CLS, INPUT, LINE INPUT, PRINT, LOCATE,
CSRLIN, POS, etc). Instead, you should use ANSI escape sequences
to control the display. This requires that an ANSI driver (like
ANSI.SYS, DVANSI.SYS, NANSI.SYS, or ZANSI.SYS) be installed on
your system. See your DOS manual for details on ANSI sequences,
or grab the documentation on ANSI from one of your friendly
local BBSes.

It is -possible- to use BASIC display handling in conjunction
with DMPrint, but that tends to defeat the purpose of using
DMPrint in the first place.

Note that the DMPrint routine does not add a carriage
return/linefeed to the end of a string. If you want that, add
CHR$(13) + CHR$(10) to the end of the string.

   DMPrint St$

St$    string to display

Name  : DOSClrEol            (DOS Clear to End Of Line)
Class : Display
Level : DOS

This routine clears from the cursor position to the end of the
row using DOS output functions. It requires that ANSI.SYS or
another ANSI driver be installed.

   DOSClrEol

Name  : DOSCls               (DOS Clear Screen)
Class : Display
Level : DOS

This routine clears the screen using DOS output functions. It
requires that ANSI.SYS or another ANSI driver be installed.

   DOSCls

Name  : DOSColor             (DOS Color)
Class : Display
Level : DOS

This routine sets the screen colors using DOS output functions.
It requires that ANSI.SYS or another ANSI driver be installed.

   DOSColor Fore%, Back%

Fore%    foreground color
Back%    background color

Name  : DOSErrM$             (DOS Error Message)
Class : Miscellaneous
Level : DOS

Of the many PBClone routines that return error codes, most
simply pass the code back from DOS without any processing. You
can see what the codes mean by checking the chart in
PBClone.DOC, or it may be more convenient to use DOSErrM$
instead. This routine returns a short text description of the
error in question.

   ErrMsg$ = DOSErrM$(ErrCode%)

ErrCode%     error code to translate
-------
ErrMsg$      brief explanation of the error

Name  : DOSInkey             (DOS INKEY$)
Class : Input
Level : DOS

This routine is similar to INKEY$, but goes through DOS input
services, which allows your program to support input
redirection, filters, CTTY and other handy things. See DMPrint
for a DOS output service. See also DOSInky$.

   DOSInkey CharCode%, CharType%

-------
CharType%    0 if no key, 1 if normal key, 2 if extended key
CharCode%    ASCII code if normal key, scan code if extended key

Name  : DOSInky$             (DOS INKEY$)
Class : Input
Level : DOS

This routine works just like INKEY$, but goes through DOS input
services, which allows your program to support input
redirection, filters, CTTY and other handy things. See DMPrint
for a DOS output service. See also DOSInkey.

   ky$ = DOSInky$

-------
ky$      key, if any was waiting (0-2 chars/key, like INKEY$)

Name  : DOSInt%              (DOS Interrupt)
Class : Miscellaneous
Level : DOS

This routine provides you with easy access to DOS functions via
INT 21H, the major DOS interrupt. It works like the CALL
INTERRUPT routines provided with QuickBASIC but is easier to
use, at the expense of some flexibility.

CAUTION: This routine works directly with DOS, bypassing most of
BASIC's safety precautions. Possible chaos may result if you
don't know what you're doing! A few specific caveats:

   1) Do Not use this routine to exit your program or execute
      another. BASIC needs to clean up after itself before these
      tasks, and bypassing its handling is liable to make the
      system unstable at best.

   2) If you expect to use a string or array as a buffer, make
      sure it is long enough to handle the maximum amount of
      information anticipated. Strings and arrays can move about
      in memory, so be sure to get their addresses Just Before
      using DOSInt%.

If you wish to specify BASIC's data segment for DS, you can find
out what that is using the DataSeg routine (q.v.).

Normally, the CarryFlag% will be set if there is an error, in
which case AX will return the error code.

   CarryFlag% = DOSInt%(AX%, BX%, CX%, DX%, DS%)

AX%         desired setting of the AX register
BX%         desired setting of the BX register
CX%         desired setting of the CX register
DX%         desired setting of the DX register
DS%         desired setting of the DS and ES registers
-------
AX%         returned setting of the AX register
BX%         returned setting of the BX register
CX%         returned setting of the CX register
DX%         returned setting of the DX register
DS%         returned setting of the DS and ES registers
CarryFlag%  returned carry flag (0 no error, else code in AX)

Name  : DOSLocate            (DOS Locate)
Class : Display
Level : DOS

This routine sets the cursor position using DOS output
functions. It requires that ANSI.SYS or another ANSI driver be
installed.

Note that many ANSI drivers do not fully support EGA or VGA
modes in that they are limited to a maximum of 25 rows.

   DOSLocate Row%, Column%

Row%      row
Column%   column

Name  : DPutRec              (Direct-to-memory Put Record)
Class : String
Level : Clone

The DPutRec routine allows you to put a string into a specified
area of memory (numeric array, BIOS data area, display memory,
or whatever). The string should be initialized to the desired
record length in advance.

This works somewhat like an array of fixed length strings or a
random file, treating memory as a contiguous series of records
of a specified length.

   DPutRec DSeg%, DOfs%, RecNr%, St$

DSeg%      segment of the array to write into
DOfs%      offset of the array to write into
RecNr%     record number (starting at 1)
St$        string to write.  Init to record length (see above).

Name  : DPutScreen           (Direct-from-memory Put Screen)
Class : Display
Level : Clone

This routine restores a portion of the display (which was saved
to an array by DGetScreen or GetScreen) to the screen. Only text
modes are supported. If your program uses multiple display
pages, you can put the image onto any of those pages. A special
"slow" mode is supported for the CGA, to prevent flickering (a
problem only with some CGAs).

The PutScreen routine works the same way as this, but has a
simpler calling convention. Also, if you wish to restore the
entire screen, you may find ScrRest easier (see).

   DPutScreen DSeg%, DOfs%, TRow%, LCol%, BRow%, RCol%,
      Page%, Fast%

DSeg%      segment of the array from which to restore the image
DOfs%      offset of the array from which to restore the image
TRow%      top row of the desired screen area
LCol%      left column of the desired screen area
BRow%      bottom row of the desired screen area
RCol%      right column of the desired screen area
Page%      page on which to restore the display
Fast%      whether to use fast mode (0 no)

Name  : DPutSt               (Direct-to-memory Put String)
Class : String
Level : Clone

The DPutSt routine allows you to put a string into a specified
area of memory (numeric array, BIOS data area, display memory,
or whatever).

You may specify an additional offset from the initial location,
which itself is specified as a segment and an offset. The second
offset begins with position 1. The combined total of the two
offsets must be under 65,536. With normalized segment and offset
specifications, which is usually the case, this allows you to
specify a number from 1-65,521 for the second offset.

   DPutSt DSeg%, DOfs%, Posn&, St$

DSeg%      segment of the array to write to
DOfs%      offset of the array to write to
Posn&      location relative to the start of the array
St$        string to write into memory

Name  : DReadAbs             (Disk Read Absolute)
Class : Disk
Level : DOS

This routine reads an absolute disk sector. This is about as
low-level as you can get-- the disk is read directly at the byte
level, bypassing higher-level notions like filenames and
directories.

The DReadAbs routine works with any version of DOS, but will not
work properly with disk partitions of over 32 megabytes. If you
need to work with large disks, see the DReadAbsBig routine.

The results from the read will be stored in an array or other
memory area you specify. Be sure to make the area large enough
to hold everything! A sector is usually 512 bytes, but you can
use the DiskStat routine to make sure. Logical sector numbering
is used, with sector numbers beginning at zero.

   DReadAbs Drive$, Sector&, DSeg%, DOfs%, Sectors%, ErrCode%

Drive$     drive letter
Sector&    starting sector (0-65534 [or less on most disks])
DSeg%      segment of the array
DOfs%      offset of the array
Sectors%   number of sectors to read
-------
ErrCode%   error code (0 if no error, else DOS error code)

Name  : DReadAbsBig          (Disk Read Absolute, Big)
Class : Disk
Level : DOS

This routine reads an absolute disk sector. This is about as
low-level as you can get-- the disk is read directly at the byte
level, bypassing higher-level notions like filenames and
directories.

The DReadAbsBig routine works with DOS 3.31 and later. It will
work on disks of any size. If a limit of 32M is sufficient, you
might prefer the DReadAbs routine, which works with any DOS
version.

The results from the read will be stored in an array or other
memory area you specify. Be sure to make the area large enough
to hold everything! A sector is usually 512 bytes, but you can
use the DiskStat routine to make sure. Logical sector numbering
is used, with sector numbers beginning at zero.

   DReadAbsBig Driv$, Sector&, DSeg%, DOfs%, Sectors%, ErrCode%

Driv$      drive letter
Sector&    starting sector (0-65534 [or less on most disks])
DSeg%      segment of the array
DOfs%      offset of the array
Sectors%   number of sectors to read
-------
ErrCode%   error code (0 if no error, else DOS error code)

Name  : DRecDel              (Direct-to-memory Record Deletion)
Class : Array management
Level : Any

This routine allows you to delete an item from an array. The
item may consist of one or more array elements. The size of the
array isn't actually changed, but the array elements are moved
as if a deletion took place.

   DRecDel DSeg%, DOfs%, RecNr%, RecLen%, Records%

DSeg%      segment of the array
DOfs%      offset of the array
RecNr%     record/element number (starting at 1)
RecLen%    record/element length in bytes
Records%   total number of records/elements in the array

Name  : DRecIns              (Direct-to-mem Record Insertion)
Class : Array management
Level : Any

This routine allows you to insert an item into an array. The
item may consist of one or more array elements. The size of the
array isn't actually changed, but the array elements are moved
as if an insertion took place. You must of course make sure that
the array is DIMed large enough to handle this.

   DRecIns DSeg%, DOfs%, RecNr%, RecLen%, Records%

DSeg%      segment of the array
DOfs%      offset of the array
RecNr%     record/element number (starting at 1)
RecLen%    record/element length in bytes
Records%   total number of records/elements in the array

Name  : DRecolor             (Direct-to-memory Recolor)
Class : Display
Level : Any

The DRecolor routine changes all text in one color to another
color. It works only in text modes. The colors are specified as
attributes (see CalcAttr).

This routine does not necessarily work on the display itself.
Instead, it allows you to specify the memory location (segment
and offset) of the "screen", which may be an actual screen, a
saved screen in an array, a multitasker's virtual screen, etc.
Among other things, this makes it easy to work with two displays
at once: use a segment of &HB000 for the mono display and &HB800
for the color display (the offset in each case is zero).

   DRecolor DSeg%, DOfs%, OldAttr%, NewAttr%

DSeg%      segment of "screen" memory
DOfs%      offset of "screen" memory
OldAttr%   color to be changed
NewAttr%   color to which to change

Name  : DRecolorArea         (Direct-to-memory Recolor Area)
Class : Display
Level : Clone

The DRecolorArea routine changes a specified area of the screen
to a specified color. It works only in text modes. The color is
specified as an attribute (see CalcAttr).

One of the more common applications for this routine is marking
an area of the screen, e.g. menu highlight bars.

   DRecolorArea DSeg%, DOfs%, TRow%, LCol%, BRow%, RCol%, _
     VAttr%

This routine does not necessarily work on the display itself.
Instead, it allows you to specify the memory location (segment
and offset) of the "screen", which may be an actual screen, a
saved screen in an array, a multitasker's virtual screen, etc.
Among other things, this makes it easy to work with two displays
at once: use a segment of &HB000 for the mono display and &HB800
for the color display (the offset in each case is zero).

DSeg%       segment of "screen" memory
DOfs%       offset of "screen" memory
TRow%       top row of area to recolor
LCol%       left column of area to recolor
BRow%       bottom row of area to recolor
RCol%       right column of area to recolor
VAttr%      desired color

Name  : DriveSpace&          (Drive Space free)
Class : Disk
Level : DOS

This routine tells you how many bytes are free on a specified
disk drive.

   BytesFree& = DriveSpace&(Drive$)

Drive$      letter of the drive to examine
-------
BytesFree&  free bytes on the specified drive, or -1 if error

Name  : DrvSpaceL            (Drive Space free as Long integer)
Class : Disk
Level : DOS

This routine tells you how many bytes are free on a specified
disk drive. See also DriveSpace, a function-type version of this
routine.

   DrvSpaceL Drive$, BytesFree&

Drive$      letter of the drive to examine
-------
BytesFree&  free bytes on the specified drive, or -1 if error

Name  : DrvType              (Drive Type)
Class : Disk
Level : DOS 3.1+

The DrvType routine tells you whether a specified drive is fixed
or removable, and whether it is local or a remote (network)
drive. Since NetWare doesn't intercept the appropriate DOS call,
DrvType now tests for NetWare and uses its calls for the local
vs remote info if possible. The local/remote info may not be
accurate with networks other than NetWare and Microsoft.

Microsoft's ubiquitous MSCDEX driver for CD-ROM drives presents
some intriguing anomalies. It pretends that CD-ROMs are fixed,
remote devices. Some MSCDEX versions also return an error flag
for CD-ROM drives for no apparent reason. I've revised error
checking accordingly, so this should not present a problem with
the current DrvType routine.

   DrvType Drive$, Removable%, Remote%, ErrCode%

Drive$       letter of the drive to examine
-------
Removable%   whether the disk can be removed (0 if no)
Remote%      whether this is a remote drive (0 if no)
ErrCode%     error code: 0 if none, else DOS error

Name  : DScrRest             (Direct-from-mem Screen Restore)
Class : Display
Level : Clone

The DScrRest routine restores a display that was saved using
ScrSave or a similar routine. It only works in text modes. See
also ScrRest.

   DScrRest DSeg%, DOfs%, Page%, Fast%

DSeg%      segment of info to restore to the screen
DOfs%      offset of info to restore to the screen
Page%      page on which to restore the display
Fast%      whether to use fast mode (0 no)

Name  : DScrSave             (Direct-from-memory Screen Save)
Class : Display
Level : Clone

The DScrSave routine saves the display to an array or other
storage area. Only text modes are supported. For an 80x25
display, the array must hold 4,000 bytes (4,000 string
characters or 2,000 integers). See also ScrSave.

   DScrSave DSeg%, DOfs%, Page%, Fast%

DSeg%      segment of place to store the display
DOfs%      offset of place to store the display
Page%      page from which to get the display
Fast%      whether to use fast mode (0 no)

Name  : DTR                  (Data Terminal Ready signal)
Class : Serial
Level : Clone

Just as IBM provided the standard for personal computers, Hayes
provided the standard for modem commands. Unfortunately, the
command method of dropping carrier (hanging up the phone) was
badly designed, and all Hayes-compatible modems have a hard time
recognizing that command under certain line conditions.

Fortunately, there's a more reliable way of hanging up: the DTR
serial signal. Turning this signal off will cause the modem to
hang up very quickly. Most Hayes-compatible modems are
factory-set to pay attention to the DTR; those that aren't can
be made to do so either by flipping a hardware switch or with a
special initialization command. See your modem manual for
details.

BASIC will drop the DTR when you CLOSE the comm port, but this
isn't always a convenient way to do it. As a matter of fact,
this can be a decided nuisance, so many people have patched
their version of BASIC to avoid it. If you would like to do so,
check your local BBS for the method! With the PBClone DTR
routine, you can get full control over the DTR without having to
CLOSE the comm port.

Note: it may be wise to include a brief delay after dropping the
DTR, to give the modem a chance to react. Try Delay18th (see)
with a wait of around 4.

   DTR CommPort%, TurnOn%

CommPort%    serial port (1-4, though BASIC only handles 1-2)
TurnOn%      whether to raise (turn on) the DTR (0 if no)

Name  : DupeVar              (Duplicate Variable)
Class : Miscellaneous
Level : Any

This routine allows you to copy the contents of one variable
into another, even if the variables are not of the same type.
You may specify any variable type EXCEPT variable-length
strings: integer, long integer, single, double, fixed-length
string, TYPEd variable, etc.

Most languages that provide TYPEd variables also provide for
variant records, that is, more than one way of looking at the
same information. Curiously, BASIC doesn't. This routine allows
you to map one variable into another, essentially providing the
lacking capability.

The only caveat for DupeVar is that both variables must be the
same length in bytes.

   DupeVar FromVar, ToVar

FromVar     variable from which to copy
-------
ToVar       variable to which to copy

Name  : DWindowMan2          (Direct-to-memory Window Manager)
Class : Display
Level : Any

This routine is identical to DWindowManager but for the fact
that it allows you to design your own custom window frames.
Please see the description of DWindowManager for general
information.

These are the additional frame types:
    6   custom frame composed of a single character
    7   custom frame composed of the specified 7-character list:
        top left corner, top middle, top right corner,
        left middle, right middle,
        bottom left corner, bottom middle, bottom right corner

 /------------------------------------------------------------\
 | A custom frame like this would be defined as frame type 7, |
 | with a frame string of "/-\||\-/", for instance.           |
 \------------------------------------------------------------/

 *************************************************
 * On the other hand, a frame like this would be *
 * frame type 6, with a frame string of "*".     *
 *************************************************

Note that this routine differs from the ProBas equivalent in
that it supports full frame definitions through frame type 7.
Differences mentioned under WindowManager are also relevant.

   DWindowMan2 DSeg%, DOfs%, TRow%, LCol%, BRow%, RCol%,
      Frame%, FSt$, Fore%, Back%, Grow%, Shade%, TFore%, Title$

DSeg%       segment of "screen" memory
DOfs%       offset of "screen" memory
TRow%       top row of window
LCol%       left column of window
BRow%       bottom row of window
RCol%       right column of window
Frame%      frame type (see above)
FSt$        frame definition string (see above)
Fore%       frame foreground color
Back%       frame background color
Grow%       window growing option (see above)
Shade%      window shadow option (see above)
TFore%      title foreground color
Title$      window title ("" if none)

Name  : DWindowMan3          (Direct-to-memory Window Manager)
Class : Display
Level : Any

This routine is identical in function to DWindowManager. The
parameters are mostly passed as an array, however, instead of
one by one. Please see the description of DWindowManager for
general information.

   DWindowMan3 Parm%(), Title$

DSeg%       segment of "screen" memory
DOfs%       offset of "screen" memory
Parm%(1)    top row of window
Parm%(2)    left column of window
Parm%(3)    bottom row of window
Parm%(4)    right column of window
Parm%(5)    frame type (see above)
Parm%(6)    frame foreground color
Parm%(7)    frame background color
Parm%(8)    window growing option (see above)
Parm%(9)    window shadow option (see above)
Parm%(10)   title foreground color
Title$      window title ("" if none)

Name  : DWindowMan4          (Direct-to-memory Window Manager)
Class : Display
Level : Any

This is an extremely cut-down version of DWindowManager,
providing no more than a simple frame generator.

These are the available frame types:
    0   no frame
    1   single lines
    2   double lines
    3   single horizontal, double vertical lines
    4   double horizontal, single vertical lines
    5   block graphic lines

   DWindowMan4 DSeg%, DOfs%, TRow%, LCol%, BRow%, RCol%, _
      Frame%, VAttr%

DSeg%       segment of "screen" memory
DOfs%       offset of "screen" memory
TRow%       top row of window
LCol%       left column of window
BRow%       bottom row of window
RCol%       right column of window
Frame%      frame type (see above)
VAttr%      frame color/attribute (use CalcAttr)

Name  : DWindowManager       (Direct-to-memory Window Manager)
Class : Display
Level : Any

DWindowManager displays a pop-up window according to your
specifications. The window may have any of a variety of frames,
a title, or a shadow, and it may appear instantly or "grow" onto
the screen.

These are the available frame types:
    0   no frame
    1   single lines
    2   double lines
    3   single horizontal, double vertical lines
    4   double horizontal, single vertical lines
    5   block graphic lines

These are the available shadows:
   -3   transparent shadow on the right
   -2   transparent shadow on the left
   -1   solid black shadow on the left
    0   no shadow
   1+   shadow attribute (use CalcAttr) for a colored shadow

Options for growing windows are as follows:
   -1   grow as fast as possible
    0   pop onto the screen
   1+   grow with delay given in milliseconds (15 works for me)

Note that this routine is different from its ProBas equivalent
in a number of respects. The grow delay time is different.
Growing is done more smoothly. The shadow and title parameters
are not changed by this routine. A new frame type (5) was added.
If a title is too long, it is truncated instead of being ignored
completely. Using a -1 as the title foreground color will not
turn off the title; instead, use a null title string.

   DWindowManager DSeg%, DOfs%, TRow%, LCol%, BRow%, RCol%,
      Frame%, Fore%, Back%, Grow%, Shade%, TFore%, Title$

This routine does not necessarily work on the display itself.
Instead, it allows you to specify the memory location (segment
and offset) of the "screen", which may be an actual screen, a
saved screen in an array, a multitasker's virtual screen, etc.
Among other things, this makes it easy to work with two displays
at once: use a segment of &HB000 for the mono display and &HB800
for the color display (the offset in each case is zero).

DSeg%       segment of "screen" memory
DOfs%       offset of "screen" memory
TRow%       top row of window
LCol%       left column of window
BRow%       bottom row of window
RCol%       right column of window
Frame%      frame type (see above)
Fore%       frame foreground color
Back%       frame background color
Grow%       window growing option (see above)
Shade%      window shadow option (see above)
TFore%      title foreground color
Title$      window title ("" if none)

Name  : DWriteAbs             (Disk Write Absolute)
Class : Disk
Level : DOS

This routine writes an absolute disk sector. This is about as
low-level as you can get-- the disk is written directly at the
byte level, bypassing higher-level notions like filenames and
directories. This is DANGEROUS! If you screw up, DOS may not be
able to read the disk any more, and it may need to be
reformatted. Back up your data before trying this routine!

The DWriteAbs routine works with any version of DOS, but will
not work properly with disk partitions of over 32 megabytes. If
you need to work with large disks, see the DWriteAbsBig routine.

The write will be done from an array or other memory area you
specify. Be sure to make the area the right size! A sector is
usually 512 bytes, but you can use the DiskStat routine to make
sure. Logical sector numbering is used, with sector numbers
beginning at zero.

   DWriteAbs Drive$, Sector&, DSeg%, DOfs%, Sectors%, ErrCode%

Drive$     drive letter
Sector&    starting sector (0-65534 [or less on most disks])
DSeg%      segment of the array
DOfs%      offset of the array
Sectors%   number of sectors to write
-------
ErrCode%   error code (0 if no error, else DOS error code)

Name  : DWriteAbsBig          (Disk Write Absolute, Big)
Class : Disk
Level : DOS

This routine writes an absolute disk sector. This is about as
low-level as you can get-- the disk is written directly at the
byte level, bypassing higher-level notions like filenames and
directories. This is DANGEROUS! If you screw up, DOS may not be
able to read the disk any more, and it may need to be
reformatted. Back up your data before trying this routine!

The DWriteAbsBig routine works with DOS 3.31 and later. It will
work on disks of any size. If a limit of 32M is sufficient, you
might prefer the DWriteAbs routine, which works with any DOS
version.

The write will be done from an array or other memory area you
specify. Be sure to make the area the right size! A sector is
usually 512 bytes, but you can use the DiskStat routine to make
sure. Logical sector numbering is used, with sector numbers
beginning at zero.

   DWriteAbsBig Drv$, Sector&, DSeg%, DOfs%, Sectors%, ErrCode%

Drv$       drive letter
Sector&    starting sector (0-65534 [or less on most disks])
DSeg%      segment of the array
DOfs%      offset of the array
Sectors%   number of sectors to write
-------
ErrCode%   error code (0 if no error, else DOS error code)

Name  : DXQPrint             (Direct Extended Quick Print)
Class : Display
Level : Any

This routine provides a rather crude, but very fast, display
capability. It works like the PRINT statement in BASIC, except
that it doesn't move the cursor or process control codes. It
works only in text modes.

This routine does not necessarily work on the display itself.
Instead, it allows you to specify the memory location (segment
and offset) of the "screen", which may be an actual screen, a
saved screen in an array, a multitasker's virtual screen, etc.
Among other things, this makes it easy to work with two displays
at once: use a segment of &HB000 for the mono display and &HB800
for the color display (the offset in each case is zero).

The results of this routine are not redirectable by DOS.

   DXQPrint DSeg%, DOfs%, St$, Row%, Column%, VAttr%

DSeg%     segment of "screen" memory
DOfs%     offset of "screen" memory
St$       string to display
Row%      starting row
Column%   starting column
VAttr%    color/attribute (see CalcAttr)

Name  : EGARest7             (EGA Restore for SCREEN 7)
Class : Display
Level : Clone

This routine allows you to restore a SCREEN 7 (EGA, 320x200, 16
color) display that was saved using EGASave7 (see).

   EGARest7 DSeg%, DOfs%

DSeg%        segment of storage array, returned by VARSEG
DOfs%        offset  of storage array, returned by VARPTR

Name  : EGARest8             (EGA Restore for SCREEN 8)
Class : Display
Level : Clone

This routine allows you to restore a SCREEN 8 (EGA, 640x200, 16
color) display that was saved using EGASave8 (see).

   EGARest8 DSeg%, DOfs%

DSeg%        segment of storage array, returned by VARSEG
DOfs%        offset  of storage array, returned by VARPTR

Name  : EGARest9             (EGA Restore for SCREEN 9)
Class : Display
Level : Clone

This routine allows you to restore a SCREEN 9 (EGA, 640x350, 16
color) display that was saved using EGASave9 (see).

   EGARest9 DSeg1%, DOfs1%, DSeg2%, DOfs2%

DSeg1%       segment of storage array #1, returned by VARSEG
DOfs1%       offset  of storage array #1, returned by VARPTR
DSeg2%       segment of storage array #2, returned by VARSEG
DOfs2%       offset  of storage array #2, returned by VARPTR

Name  : EGASave7             (EGA Save for SCREEN 7)
Class : Display
Level : Clone

This routine allows you to save a SCREEN 7 (EGA, 320x200, 16
color) display that can be restored using EGARest7 (see).

The array used to hold the screen must contain 32,000 bytes. For
an integer array, this means that you must create the array by
DIM Array%(1 TO 16000).

   EGASave7 DSeg%, DOfs%

DSeg%        segment of storage array, returned by VARSEG
DOfs%        offset  of storage array, returned by VARPTR

Name  : EGASave8             (EGA Save for SCREEN 8)
Class : Display
Level : Clone

This routine allows you to save a SCREEN 8 (EGA, 640x200, 16
color) display that can be restored using EGARest8 (see).

The array used to hold the screen must contain 64,000 bytes. For
an integer array, this means that you must create the array by
DIM Array%(1 TO 32000).

   EGASave8 DSeg%, DOfs%

DSeg%        segment of storage array, returned by VARSEG
DOfs%        offset  of storage array, returned by VARPTR

Name  : EGASave9             (EGA Save for SCREEN 9)
Class : Display
Level : Clone

This routine allows you to save a SCREEN 9 (EGA, 640x350, 16
color) display that can be restored using EGARest9 (see).

Two arrays must be used to hold the screen, for a total of
112,000 bytes. If you use integer arrays, each array must be
created by DIM Array%(1 TO 28000).

   EGASave9 DSeg%, DOfs%

DSeg1%       segment of storage array #1, returned by VARSEG
DOfs1%       offset  of storage array #1, returned by VARPTR
DSeg2%       segment of storage array #2, returned by VARSEG
DOfs2%       offset  of storage array #2, returned by VARPTR

Name  : Elapsed              (Elapsed time)
Class : Time
Level : Any

This routine tells you the amount of time elapsed between a
given starting time and ending time. The difference between the
times must be less than 24 hours for the results to be
meaningful.

See also ElapsedTime, the FUNCTION version of this routine.

   Elapsed TimeStart$, TimeStop$, TimeDiff$

TimeStart$   starting time
TimeStop$    ending time
-------
TimeDiff$    elapsed time

Name  : ElapsedTime$         (Elapsed time)
Class : Time
Level : Any

This routine tells you the amount of time elapsed between a
given starting time and ending time. The difference between the
times must be less than 24 hours for the results to be
meaningful.

See also Elapsed, the SUB version of this routine.

   TimeDiff$ = ElapsedTime$(TimeStart$, TimeStop$)

TimeStart$   starting time
TimeStop$    ending time
-------
TimeDiff$    elapsed time

Name  : EMSBuffer            (EMS Buffer size)
Class : Memory
Level : BIOS

EMSBuffer tells you how many bytes are needed to save the state
of the EMS array routines. Used in conjunction with EMSSave and
EMSRest, it allows you to preserve EMS arrays across a CHAIN to
another part of your program.

   EMSBuffer Bytes%
   EMSState$ = SPACE$(Bytes%)
   EMSSave EMSState$

-------
Bytes%       bytes needed to save EMS array state

Name  : EMSClose             (EMS Close)
Class : Memory
Level : BIOS

The EMSClose routine is used when you are finished with an EMS
array. It frees the array handle and EMS memory for other uses.
If you don't close all EMS arrays before your program ends, the
memory will be lost until the system is rebooted, so it is
important to remember EMSClose.

   EMSClose ArrayHandle%

ArrayHandle%    handle of an EMS array

Name  : EMSGet               (EMS Get)
Class : Memory
Level : BIOS

This routine gets an element from an EMS array created by
EMSOpen. Element numbers start at 0. Be sure to use the right
numeric type for the array-- for instance, if you opened the
array for SINGLE precision, use "Value!".

   EMSGet ArrayHandle%, ElementNr&, Value

ArrayHandle%    handle of an EMS array
ElementNr&      element number to get
-------
Value           result (must be correct type for array)

Name  : EMSOpen              (EMS Open)
Class : Memory
Level : BIOS

This routine allows you to open a block of EMS (expanded) memory
which can then be accessed like a numeric array. The array size
is limited only by available EMS memory (use GetLIMM to find out
how much is available). You may specify any numeric type:

    1   INTEGER
    2   LONG or SINGLE
    3   DOUBLE

When the array is opened, you are returned an "array handle"
which is used to access that array. Access to the array is done
via EMSGet and EMSPut. When you are finished with the array, you
must close it with EMSClose.

As many as 25 EMS arrays can be in use at one time, subject to
limitations which may be imposed by your EMS driver (each array
requires one EMS handle).

   EMSOpen Elements&, ElementType%, ArrayHandle%, ErrCode%

Elements&       number of elements in array (like DIM size)
ElementType%    numeric type of array (see above)
-------
ArrayHandle%    handle of an EMS array
ErrCode%        whether an error occurred (0 no)

Name  : EMSPut               (EMS Put)
Class : Memory
Level : BIOS

This routine puts an element into an EMS array created by
EMSOpen. Element numbers start at 0. Be sure to use the right
numeric type for the array-- for instance, if you opened the
array for SINGLE precision, use "Value!".

   EMSPut ArrayHandle%, ElementNr&, Value

ArrayHandle%    handle of an EMS array
ElementNr&      element number to set
Value           value to store (must be correct type for array)

Name  : EMSRest              (EMS Restore state)
Class : Memory
Level : BIOS

This routine allows you to restore the state of the EMS array
handler. Used in conjunction with EMSBuffer and EMSSave, it
allows you to preserve EMS arrays across a CHAIN to another part
of your program.

   EMSRest EMSState$

EMSState$    saved EMS array state

Name  : EMSSave              (EMS Save state)
Class : Memory
Level : BIOS

This routine allows you to save the state of the EMS array
handler. Used in conjunction with EMSBuffer and EMSRest, it
allows you to preserve EMS arrays across a CHAIN to another part
of your program.

   EMSBuffer Bytes%
   EMSState$ = SPACE$(Bytes%)
   EMSSave EMSState$

-------
EMSState$    saved EMS array state

Name  : EnhKbd               (Enhanced Keyboard)
Class : Input
Level : BIOS

By default, the PBClone routines assume an old-style keyboard is
in use, for greatest compatibility. EnhKbd allows you to turn on
enhanced keyboard handling for the current generation of
(usually) 101-key keyboards. This allows access to the F11 and
F12 function keys as well as codes for key combinations that
used to be ignored, among other things.

The KbdType or KbdType2% routine can be used to determine if an
enhanced keyboard is available (recommended).

Note that EnhKbd works by intercepting the BIOS keyboard
handler. All calls to the BIOS keyboard interrupt are converted
from the old keyboard functions to the new ones. YOU MUST
DISABLE EnhKbd BEFORE YOUR PROGRAM ENDS, so it can restore the
old setup. Otherwise, the computer will most probably crash.

A list of the new key codes is given in PBClone.DOC.

   EnhKbd Enable%

Enable%     turn on enhanced keyboard support (0 disable)

Name  : Equipment            (Equipment information)
Class : Equipment
Level : BIOS

This routine gives you some information about the basic
equipment in your computer. Note that the "game port"
information is not reliable, due to changes in the meaning of
this particular area of the BIOS over many years.

   Equipment Memory%, Parallel%, Serial%, Game%

-------
Memory%    kilobytes of conventional memory installed (16 - 640)
Parallel%  parallel (printer) ports installed (0-4)
Serial%    serial (communications) ports installed (0-4)
Game%      game (joystick) ports installed (0-1).  See remarks, above.

Name  : EuropeDate           (European Date format)
Class : Time
Level : Any

This routine takes a date in one of the American formats
("MM/DD/YY" or "MM-DD-YYYY") and converts it to the European
convention ("DD.MM.YY" or "DD.MM.YYYY"). The date is formatted
according to a format string which provides the desired
delimiter and year length, e.g. "##-##-##" specifies a delimiter
of "-" and a year length of two digits.

An error code is returned if the date is not valid.

   EuropeDate DateSt$, Format$, Result$, ErrCode%

DateSt$     date to format (month, day, year order)
Format$     format for the date
-------
Result$     resulting date (day, month, year order)
ErrCode     whether the date is valid (0 ok)

Name  : EWindowManagerC      (EGA Window Manager w Char coords)
Class : Display
Level : Clone

EWindowManagerC displays a pop-up window according to your
specifications. The window may have any of a variety of frames,
a title, or a shadow, and it may appear instantly or "grow" onto
the screen. EGA and VGA graphics modes (SCREEN 7 through SCREEN
12) are supported.

These are the available frame types:
    0   no frame
    1   single lines
    2   double lines
    3   single horizontal, double vertical lines
    4   double horizontal, single vertical lines
    5   block graphic lines

These are the available shadows:
    0   no shadow
   1+   shadow attribute (use CalcAttr) for a colored shadow

Options for growing windows are as follows:
   -1   grow as fast as possible
    0   pop onto the screen
   1+   grow with delay given in milliseconds (not recommended)

The differences between this routine and its ProBas equivalent
are the same as mentioned in the description for WindowManager.
Also, growing windows are supported, but are not recommended
(too slow). Colored shadows work as in WindowManager. "True"
shadows are not yet supported.

   EWindowManagerC TRow%, LCol%, BRow%, RCol%, Frame%,
      Fore%, Back%, Grow%, Shade%, S1%, S2%, TFore%, Title$

TRow%       top row of window
LCol%       left column of window
BRow%       bottom row of window
RCol%       right column of window
Frame%      frame type (see above)
Fore%       frame foreground color
Back%       frame background color
Grow%       window growing option (see above)
Shade%      window shadow option (see above)
S1%         unused
S2%         unused
TFore%      title foreground color
Title$      window title ("" if none)

Name  : Exist                (file Existence)
Class : Disk
Level : DOS

Most versions of BASIC give you no way of seeing if a file
exists before you try to OPEN it, so you end up taking your
chances. The Exist routine allows you to test to see if the file
exists beforehand. It isn't really necessary for the PBClone
file routines, which will return an appropriate error code, but
it's an important safeguard when using the BASIC OPEN statement.

The Exist routine does not support wildcards. If you need that
feature, try the FindFirstFx and FindNextFx routines instead.

See also Exist2, the FUNCTION version of this routine.

   Exist FileName$, Found%

FileName$   name of the file to look for
-------
Found%      whether the file was found (0 if no)

Name  : Exist2%              (file Existence)
Class : Disk
Level : DOS

Most versions of BASIC give you no way of seeing if a file
exists before you try to OPEN it, so you end up taking your
chances. The Exist2% function allows you to test to see if the
file exists beforehand. It isn't really necessary for the
PBClone file routines, which will return an appropriate error
code, but it's an important safeguard when using the OPEN
statement.

The Exist2% routine does not support wildcards. If you need that
feature, try the FindFirstFx and FindNextFx routines instead.

See also Exist, the SUB version of this routine.

   Found% = Exist2%(FileName$)

FileName$   name of the file to look for
-------
Found%      whether the file was found (0 if no)

Name  : ExplainFAttr$        (Explain File Attribute)
Class : Disk
Level : Any

This function returns a string explaining what a file attribute
means, using a specified level of abbreviation. A single space
is used between each word, e.g. a hidden subdirectory at
abbreviation level 2 would be "Hid Dir".

Abbreviation Levels:
        1           2              3
   ---------------------------------------
 1      R          R-O         Read-Only
 2      H          Hid         Hidden
 4      S          Sys         System
 8      V          Vol         Volume
16      D          Dir         Directory
32      A          Arc         Archive

This function is convenient in conjunction with any of the
routines which return a file attribute: GetAttrF, GetAttrFx,
GetFAttr, LoadDirAll.

   Info$ = ExplainFAttr$(FilAttr%, AbbrevLevel%)

We use FilAttr% instead of FileAttr%, since BASIC has a built-in
FILEATTR function.

FilAttr%      file attribute
-------
AbbrevLevel%  how much to abbreviate the result (1-3)

Name  : EXQPrintC            (EGA Extended Quick Print, Char)
Class : Display
Level : Clone

This routine provides a rather crude, but very fast, display
capability. It works like the PRINT statement in BASIC, except
that it doesn't move the cursor or process control codes. It
works in EGA and VGA graphics modes (SCREEN 7 through SCREEN
12).

The results of this routine are not redirectable by DOS.

   EXQPrintC St$, Row%, Column%, Fore%, Back%

St$       string to display
Row%      starting row
Column%   starting column
Fore%     foreground color
Back%     background color

Name  : ExtendFSpec          (Extend File Specification)
Class : Disk
Level : DOS

The ExtendFSpec routine combines a number of handy services
together. It is intended for processing user-entered file
specifications. It does the following:

   1) Makes sure the filespec is valid
   2) Formats the filespec to normal DOS standards
   3) Tells you whether the drive and subdirectories
      specified exist
   4) Fills out any drive or subdirectory information that
      was left out (optionally includes adding an extension
      to files which lack one)

The error codes returned are as follows:
   -1    Invalid file specification
    0    No error
    1    Specified drive does not exist (warning only)
    2    Specified subdirectory does not exist (warning only)

The ExtendFSpec routine mimics DOS filename handling exactly, to
the best of my knowledge.

   ExtendFSpec File$, Ext$, FullFile$, ErrCode%

File$      file specification to process
Ext$       extension to add to files that don't have extensions
-------
FullFile$  processed file specification
ErrCode%   error code

Name  : ExtGet               (Extended memory Get)
Class : Memory
Level : BIOS (AT)

This routine allows you to get information from extended memory.
It should only be used on AT-class computers, since older PCs do
not support extended memory.

You may get up to 32,766 words (just under 64 kilobytes) at a
time from a specified location in extended memory. The location
is specified as the distance from the start of extended memory,
starting at 1 for the first location. One word is equivalent to
one integer.

See ExtMem for information on extended memory constraints.

   ExtGet DSeg%, DOfs%, Posn&, Words%, ErrCode%

DSeg%       segment of array to place data from extended memory
DOfs%       offset of array to place data from extended memory
Posn&       location of data in extended memory (starting at 1)
Words%      # of words to transfer (1 int = 1 word = 2 byte)
-------
ErrCode%    error code (0 if no error)

Name  : ExtMem               (Extended Memory)
Class : Memory / Equipment
Level : BIOS (AT)

This routine allows you to find out how much extended memory is
available. It should only be used on AT-class computers, since
older PCs do not support extended memory.

The amount of memory returned may be either the total amount of
extended memory installed or just the amount available at this
time, depending on how previously-installed programs (if any)
make use of extended memory. Unfortunately, there is no standard
which defines how a program should use extended memory as there
is with EMS (expanded memory), so there is no way for a program
to determine whether or how another program is using extended
memory. Microsoft is trying to clear up this situation with its
HIMEM driver (available at your local BBS, or [last I looked]
free from Microsoft), but this approach hasn't really become
standard yet.

   ExtMem KBytes%

-------
KBytes%     the number of kilobytes of extended memory

Name  : ExtPut               (Extended memory Put)
Class : Memory
Level : BIOS (AT)

This routine allows you to put information into extended memory.
It should only be used on AT-class computers, since older PCs do
not support extended memory.

You may put up to 32,766 words (just under 64 kilobytes) at a
time into a specified location in extended memory. The location
is specified as the distance from the start of extended memory,
starting at 1 for the first location. One word is equivalent to
one integer.

Note that you can't rely on extended memory being available just
because it exists. There is no automatic way to determine if
another program is also trying to use the same extended memory.
If in doubt, allow a user-installed option to enable/disable the
use of extended memory by your program.

   ExtPut DSeg%, DOfs%, Posn&, Words%, ErrCode%

DSeg%       segment of data to store in extended memory
DOfs%       offset of data to store in extended memory
Posn&       location to place data in extended memory
Words%      # of words to transfer (1 int = 1 word = 2 bytes)
-------
ErrCode%    error code (0 if no error)

Name  : Extract              (Extract delimited substring)
Class : String
Level : Any

Extract allows you to remove any one of a list of delimited
substrings in a string. It's useful for input parsing and
database work. You pass it the string, delimiter, and the number
of the desired substring (numbers start at one). It returns the
starting position of the substring within the string and the
length of the substring (0 if not found).

Just for example, let's assume we have a string as follows:
   St$ = "Tom Hanlin=3544 E. Southern Ave #104=Mesa, AZ 85204"

If we selected a delimiter of "=" and substring number three,
the results would be "Mesa, AZ 85204".

Delimiters of more than one character are fine. This can be
handy for locating carriage return/linefeed pairs, among other
things.

   Extract St$, Delimiter$, SubStrNr%, StartPosn%, SLen%
   SubSt$ = MID$(St$, StartPosn%, SLen%)

St$         string from which to extract
Delimiter$  delimiter between substrings
SubStrNr%   number of the desired substring
-------
StartPosn%  starting position of substring within the string
SLen%       length of the substring (0 if none)

Name  : FadeOut              (Fade Out)
Class : Display
Level : Clone

Like CLS, but a bit more fancy, this routine provides an
interesting way to clear the screen. See also Dissolve.

   FadeOut VAttr%

VAttr%   color/attribute to which to clear (see CalcAttr)

Name  : FarPeek%             (Far memory Peek)
Class : Memory
Level : Clone

This is like the BASIC PEEK function, but expects both a segment
and an offset, thus doing away with the need for DEF SEG. This
is especially handy for use in subprograms which might otherwise
inadvertently change the DEF SEG value expected by the main
program.

   Value% = FarPeek%(DSeg%, DOfs%)

Related routines include FarPeekI%, FarPeekL&, DGetSt, DGetRec.

DSeg%    segment of the location to look at
DOfs%    offset of the location to look at
-------
Value%   value at the specified memory location (byte: 0-255)

Name  : FarPeekI%            (Far memory Peek Integer)
Class : Memory
Level : Clone

This is like the BASIC PEEK function, but expects both a segment
and an offset, thus doing away with the need for DEF SEG. This
is especially handy for use in subprograms which might otherwise
inadvertently change the DEF SEG value expected by the main
program. Unlike PEEK, this routine returns a word (integer)
rather than a byte.

   Value% = FarPeekI%(DSeg%, DOfs%)

Related routines include FarPeek%, FarPeekL&, DGetSt, DGetRec.

DSeg%    segment of the location to look at
DOfs%    offset of the location to look at
-------
Value%   value at the specified memory location (word)

Name  : FarPeekL&            (Far memory Peek Long integer)
Class : Memory
Level : Clone

This is like the BASIC PEEK function, but expects both a segment
and an offset, thus doing away with the need for DEF SEG. This
is especially handy for use in subprograms which might otherwise
inadvertently change the DEF SEG value expected by the main
program. Unlike PEEK, this routine returns a dword (long
integer) rather than a byte.

   Value& = FarPeekL&(DSeg%, DOfs%)

Related routines include FarPeek%, FarPeekI%, DGetSt, DGetRec.

DSeg%    segment of the location to look at
DOfs%    offset of the location to look at
-------
Value&   value at the specified memory location (dword)

Name  : FarPoke              (Far memory Poke)
Class : Memory
Level : Clone

This is like the BASIC POKE statement, but expects both a
segment and an offset, thus doing away with the need for DEF
SEG. This is especially handy for use in subprograms which might
otherwise inadvertently change the DEF SEG value expected by the
main program.

   FarPoke DSeg%, DOfs%, Value%

Related routines include FarPokeI, FarPokeL, DPutSt, DPutRec.

DSeg%    segment of the location to look at
DOfs%    offset of the location to look at
Value%   value to store in the given memory posn (byte: 0-255)

Name  : FarPokeI             (Far memory Poke Integer)
Class : Memory
Level : Clone

This is like the BASIC POKE statement, but expects both a
segment and an offset, thus doing away with the need for DEF
SEG. This is especially handy for use in subprograms which might
otherwise inadvertently change the DEF SEG value expected by the
main program. Unlike POKE, this routine stores a word or
integer.

   FarPokeI DSeg%, DOfs%, Value%

Related routines include FarPoke, FarPokeL, DPutSt, DPutRec.

DSeg%    segment of the location to look at
DOfs%    offset of the location to look at
Value%   value to store in the given memory posn (word)

Name  : FarPokeL             (Far memory Poke Long integer)
Class : Memory
Level : Clone

This is like the BASIC POKE statement, but expects both a
segment and an offset, thus doing away with the need for DEF
SEG. This is especially handy for use in subprograms which might
otherwise inadvertently change the DEF SEG value expected by the
main program. Unlike POKE, this routine stores a dword or long
integer.

   FarPokeL DSeg%, DOfs%, Value&

Related routines include FarPoke, FarPokeI, DPutSt, DPutRec.

DSeg%    segment of the location to look at
DOfs%    offset of the location to look at
Value&   value to store in the given memory posn (dword)

Name  : FClose1              (File Close)
Class : Disk
Level : DOS

This routine closes a file that was opened by FOpen1 or FCreate.
It can also be used to close any of the predefined device
handles.

These are the predefined device handles that are always
available:

   0    CON     stdin     standard input, normally the keyboard
   1    CON     stdout    standard output, normally the display
   2    CON     stderr    standard error, almost always display
   3    AUX     stdaux    auxiliary device, generally COM1
   4    PRN     stdprn    standard printer, generally LPT1

If you are running short of handles, you can always close stdaux
to free up a handle. The stdprn device can also be closed as
long as you don't use the printer or if you only access the
printer through LPRINT. It is not a good idea to close stdin,
stdout, or stderr under normal circumstances.

   FClose1 Handle%

Handle%    handle of the file to close

Name  : FCreate              (File Create)
Class : Disk
Level : DOS

This routine creates a file and opens it for use by the PBClone
file handling routines. If the file already existed, it will be
wiped out, so you may want to check beforehand if this is a
problem. Try the Exist routine.

The file is opened in read/write mode, allowing both input and
output.

You may create the file using any of the following attributes:

   Normal          0      (nothing special)
   Read Only       1      file can be read, but not written to
   Hidden          2      file is "invisible"
   System          4      special DOS system file

The attributes can be combined by adding them together. Don't
use the System attribute unless you know what you're doing!

Note that this routine does not support file sharing. If that is
a problem, close the file just after it is created and reopen it
using FOpen1.

   FCreate FileName$, FAttr%, Handle%, ErrCode%

FileName$  name of the file to create
FAttr%     attribute(s) of the file
-------
Handle%    handle by which to access the file (if no error)
ErrCode%   error code: 0 if no error, else DOS Error

Name  : FDescRead$           (File Description Read)
Class : Disk
Level : DOS

This routine reads a 4DOS-style file description from disk. If
there is no description or an error occurs, the result will be a
null string.

   FileDesc$ = FDescRead$(FileName$)

FileName$   file name
-------
FileDesc$   description of file, if any

Name  : FGetLoc              (File Get Location)
Class : Disk
Level : DOS

This routine tells you the position of the file pointer of a
file that was opened using FOpen1 or FCreate. This pointer is
used to specify where the next item should be read from or
written to the file. The first location of the file is at 1.

See also FGetLoc2, the FUNCTION version of this routine.

   FGetLoc Handle%, Posn&

Handle%    handle of the file
-------
Posn&      location of the file pointer

Name  : FGetLoc2&            (File Get Location)
Class : Disk
Level : DOS

This routine tells you the position of the file pointer of a
file that was opened using FOpen1 or FCreate. This pointer is
used to specify where the next item should be read from or
written to the file. The first location of the file is at 1.

See also FGetLoc, the SUB version of this routine.

   Posn& = FGetLoc2&(Handle%)

Handle%    handle of the file
-------
Posn&      location of the file pointer

Name  : FileCopy             (File Copy)
Class : Disk
Level : DOS

This routine copies one or more files, just like the DOS command
"COPY".

FileCopy works exactly like the DOS COPY command, except it
won't append files. You may use wildcards in both source and
destination file specifications. In the event of an error,
normal DOS error codes are returned, with two exceptions:

  -2  attempt to copy files over themselves
  -1  attempt to copy multiple sources to a single dest file

See also CopyFile, a simpler routine which doesn't support
wildcards.

   FileCopy SrcFile$, DestFile$, FCount%, ByteCount&, ErrCode%

SrcFile$    source file name(s)
DestFile$   destination file name(s)
-------
FCount%     number of files copied
ByteCount&  number of bytes copied
ErrCode%    error code (0 if no error)

Name  : FileCount            (File Count)
Class : Disk
Level : DOS

This routine returns the number of files which match a given
file specification and attribute. You need to use this routine
before LoadDir or LoadDirAll in order to DIM the array to the
appropriate size.

The attribute can be any of the usual file attributes:
   1   Read-Only
   2   Hidden
   4   System
  16   Directory

You can combine attributes by adding their values. For instance,
to search for hidden directories, you'd use an attribute of 18.
By default, DOS returns normal files as well as files which have
the specified attributes, so an attribute of 18 would get you
normal files, hidden files, directories, and hidden directories.
However, FileCount can be made to screen out unwanted files--
just negate the attribute to force only files of that attribute
to be counted. For example, an attribute of -18 would return
only hidden subdirectories.

   FileCount FileSpec$, FilAttr%, Count%, ErrCode%

We use FilAttr% instead of FileAttr%, since BASIC has a built-in
FILEATTR function.

FileSpec$   search filename (may contain wildcards)
FilAttr%    search file attribute
-------
Count%      number of matching files found
ErrCode%    error code (0 if no error)

Name  : FileCRC              (File CRC)
Class : Disk
Level : DOS

This routine calculates a 32-bit CRC for a file. This CRC is
derived by a formula which takes each character of the file into
consideration. It provides a powerful (although not 100%
foolproof) way to verify that a file hasn't changed since you
last checked.

   FileCRC FileName$, Result&, ErrCode%

FileName$   source file name(s)
-------
Result&     32-bit CRC of the file
ErrCode%    error code (0 if no error)

Name  : FileMenu             (File Menu)
Class : Input
Level : Clone

This routine provides a list of files according to the filespec
and attribute you pass it and allows the user to pick a single
file from the resulting list. The filespec may contain a full
path and wildcards. The attribute may be negated if you insist
on an exact match (directories only, for example), or use a
normal attribute for multiple matches (directories and files,
for instance). Many of the usual WindowManager parameters are
used here-- top row, left column, and bottom row (right column
is calculated for you), window frame color and frame type,
growth, shadow, title string and title color-- see the
WindowManager routine for details. For a description of file
search attributes, see the FindFirstFx routine.

If you allow using the mouse, be sure the mouse is initialized
(MMCheck or MMCheck2%) and the mouse cursor is visible
(MMCursorOn) before calling this routine.

This routine automatically saves and restores the underlying
screen. It can handle up to 2,048 files in a window. See
CalcAttr if you're not familiar with color/attributes.

   FileMenu Mouse%, FileSpec$, SeekAttr%, TopRow%, LeftCol%, _
      BottomRow%, Frame%, FrameAttr%, FileListAttr%, _
      HiliteAttr%, TitleFore%, Title$, Grow%, Shade%

Mouse%          whether to support the mouse (0 no, -1 yes)
FileSpec$       filespec to use in creating the file list
SeekAttr%       file search attribute to use in creating list
TopRow%         top row of pick window
LeftCol%        left column of pick window
BottomRow%      bottom row of pick window
Frame%          frame type
FrameAttr%      frame color/attribute
FileListAttr%   file list color/attribute
HiliteAttr%     highlight bar color/attribute
TitleFore%      title foreground color (backgnd is frame color)
Title$          title (use "" for no title)
Grow%           window growth
Shade%          window shadow
-------
FileSpec$       file picked ("" if none)

Name  : FindFirstA           (Find First file in an Archive)
Class : Disk
Level : DOS

The FindFirstA routine is used to find the first file that
matches search parameters which you specify. Various information
about the file that matches (if any) can be retrieved by other
routines.

Rather than working on a directory, this routine works on files
in an archive. Supported archive formats include ARC, ARJ, LZH,
PAK, ZIP and ZOO. Self-extracting archives in ARJ, LHARC, and
PKZIP (ZIP2EXE) form are also supported, as either .COM or .EXE
files. If no extension is given, a search will be made through
each valid archive extension, and the first matching archive
will be used for the file search.

Archive names may contain drive and subdirectory specs, but not
wildcards. File names may contain wildcards, but not drive or
subdir specs.

When you are done searching, be sure to use CloseA to terminate
the search.

Routines in this series include:
   FindFirstA, FindNextA, GetNameA, GetCRCA, GetCRCAL,
   GetDateA, GetTimeA, GetSizeAL, GetStoreA

   FindFirstA ArcName$, FileName$, ErrCode%

ArcName$    name of archive to search through
FileName$   name of file(s) for which to search
-------
ErrCode%    error code (0 if no error, else no matching files)

Name  : FindFirstF           (Find First File)
Class : Disk
Level : DOS

This is part of a set of routines included for compatibility
with ADVBAS and ProBas. A better solution may be found in
FindFirstFx.

The FindFirstF routine is used to find the first file that
matches search parameters which you specify. Various information
about the file that matches (if any) can be retrieved by other
routines. See also FindNextF.

The file name specified may contain a drive and subdirectory
specification. Wildcards are also allowed.

Possible search attributes are as follows:

   Normal          0      (nothing special)
   Hidden          2      file is "invisible"
   System          4      special DOS system file
   Subdirectory   16      subdirectory

You can combine the attributes by adding them together. All
searches will match if any of the specified attributes are
found, so if you're looking only for a specific attribute, you
will need to test the results using GetAttrF.

Routines in this series include:
   FindFirstF, FindNextF, GetNameF, GetAttrF, GetDateF,
   GetTimeF, GetSizeFL

   FindFirstF FileName$, FAttr%, ErrCode%

FileName$   name of file(s) for which to search
FAttr%      file attribute(s) to seek
-------
ErrCode%    error code (0 if no error, else no matching files)

Name  : FindFirstFx          (Find First File, Extended)
Class : Disk
Level : DOS

The FindFirstFx routine is used to find the first file that
matches search parameters which you specify. Various information
about the file that matches (if any) can be retrieved by other
routines.

The file name specified may contain a drive and subdirectory
specification. Wildcards are also allowed.

Possible search attributes are as follows:

   Normal          0      (nothing special)
   Read Only       1      file can be read, but not written to
   Hidden          2      file is "invisible"
   System          4      special DOS system file
   Subdirectory   16      subdirectory

You can combine the attributes by adding them together. All
searches will match if any of the specified attributes are
found, so if you're looking only for a specific attribute, you
will need to test the results using GetAttrFx.

Routines in this series include:
   FindFirstFx, FindNextFx, GetNameFx$, GetAttrFx%, GetDateFx$,
   GetTimeFx$, GetSizeFx&

These routines differ from the older FindFirstF-based series in
two major respects. They include a Buffer$ parameter, which
allows you to have more than one search going on at a time. This
makes it safe to use these routines in subprograms without
conflict with the main program. It also allows you to search
entire subdirectory trees recursively. The other major
difference is that many of these routines are coded as functions
for greater convenience.

   Buffer$ = SPACE$(64)
   FindFirstFx Buffer$, FileName$, FAttr%, ErrCode%

FileName$   name of file(s) for which to search
FAttr%      file attribute(s) to seek
-------
Buffer$     buffer used in search (init to 64 characters)
ErrCode%    error code (0 if no error, else no matching files)

Name  : FindNextA            (Find Next file in an Archive)
Class : Disk
Level : DOS

This routine is for use after FindFirstA, to find any additional
archived files which may match your search specifications.

Routines in this series include:
   FindFirstA, FindNextA, GetNameA, GetCRCA, GetCRCAL,
   GetDateA, GetTimeA, GetSizeAL, GetStoreA

   FindNextA ErrCode%

-------
ErrCode%    error code (0 if no error, else no matching files)

Name  : FindNextF            (Find Next File)
Class : Disk
Level : DOS

This routine is for use after FindFirstF, to find any additional
files which may match your search specifications.

Routines in this series include:
   FindFirstF, FindNextF, GetNameF, GetAttrF, GetDateF,
   GetTimeF, GetSizeFL

   FindNextF ErrCode%

-------
ErrCode%    error code (0 if no error, else no matching files)

Name  : FindNextFx           (Find Next File, Extended)
Class : Disk
Level : DOS

This routine is for use after FindFirstFx, to find any
additional files which may match your search specifications.

Routines in this series include:
   FindFirstFx, FindNextFx, GetNameFx$, GetAttrFx%, GetDateFx$,
   GetTimeFx$, GetSizeFx&

   FindNextFx Buffer$, ErrCode%

Buffer$     buffer used in search
-------
Buffer$     updated buffer
ErrCode%    error code (0 if no error, else no matching files)

Name  : FindPatch            (Find Patch location)
Class : Disk
Level : DOS

This is one of a set of routines that allow you to write
self-modifying code. Your program can patch DATA statements in
itself or in another program, allowing you to save configuration
information (for example) without having to create additional
data files.

In order for this routine to work, you must have a series of
DATA statements containing quoted strings of the maximum desired
length. The first DATA statement must contain a unique string,
as FindPatch will use it to locate the data block. Note that if
your program is patching itself, you must READ the unique string
rather than assigning it directly, to make sure it's unique. The
string must exist at only one place in the program.

See the PATCHER.BAS file if you would like clarification. This
little demo program, when compiled, will patch itself with
whatever you enter on the command line. For instance, if you
type PATCHER BANANA, it will store "BANANA" in its DATA
statement. PDEMO will not work in the QuickBASIC environment, of
course. You must compile it to an .EXE file.

You may compile the program using any switches. You may not use
the /E (/EXEPACK) switch for LINK, though, as this may alter the
program DATA area. Likewise, you must not use compression
utilities such as PKLite on the program.

Routines in this set include FindPatch, SetPatch, PatchDone.

   FindPatch FileName$, SearchSt$, ErrCode%

FileName$     name of the file to patch
SearchSt$     value of the first DATA statement
MoveBack%     not used
-------
ErrCode%      whether search worked (0 yes, <0 no, >0 Error)

Name  : FLock                (File Lock)
Class : Disk
Level : DOS

This routine locks any part of a file. It will typically be used
for random-access files in circumstances where the file needs to
be accessed by multiple programs at the same time. This routine
lets you lock just the part of the file you need to access,
allowing other programs to work with other parts of the file at
the same time. It is best to maintain the lock for the shortest
time possible, in case someone else needs the same data. The
ideal technique is to lock the area, read what data you need,
write any changes, and unlock the area as a single program
block.

Note that it is IMPORTANT to unlock the locked area before the
file is closed and before your program terminates. If the file
is not properly unlocked, it may be damaged. See also FUnlock.

This routine is used for occasions where you expect multiple
accesses to a single file, under networking or multitasking
conditions. For less demanding file sharing, it is safer to
simply lock the entire file when you open it-- see FOpen.

   FLock FileHandle%, StartPosn&, Bytes&, ErrCode%

FileHandle%    file handle
StartPosn&     starting offset (1 for first position)
Bytes&         number of bytes to lock
-------
ErrCode%       error code (0 if no error, else DOS error code)

Name  : FloorD#              (Floor, Double-precision)
Class : String
Level : Any

This function returns the largest integer less than or equal to
the number you give it. This is most often used for rounding.

   Result# = FloorD#(Nr#)

Nr#          number to process
-------
Result#      result

Name  : FloorS!              (Floor, Single-precision)
Class : String
Level : Any

This function returns the largest integer less than or equal to
the number you give it. This is most often used for rounding.

   Result! = FloorS!(Nr!)

Nr!          number to process
-------
Result!      result

Name  : Floppies             (Floppies installed)
Class : Equipment / Disk
Level : BIOS

The Floppies routine tells you how many floppy drives are
installed (0-4). See also Floppies2, a function version of this
routine.

   Floppies Drives%

-------
Drives%  number of floppy disk drives installed

Name  : Floppies2%           (Floppies installed)
Class : Equipment / Disk
Level : BIOS

The Floppies2 routine tells you how many floppy drives are
installed (0-4).

   Drives% = Floppies2%

-------
Drives%  number of floppy disk drives installed

Name  : FloppyType           (Floppy drive Type)
Class : Equipment / Disk
Level : Clone (AT)

This routine tells you what kinds of floppy drives are
installed, if any. A code is returned for each drive, as
follows:

   0    no drive
   1    5 1/4"    360K
   2    5 1/4"    1.2M
   3    3 1/2"    720K
   4    3 1/2"    1.44M
   5    3 1/2"    2.88M

Note that this routine supports a maximum of only two drives. It
is possible for a machine to have up to four drives, but there
is not currently any good way to find out about them.

FloppyType should only be used on AT-class machines. It will not
work on PC/XT computers and may cause unusual results if used on
such machines. It will also not work on some of the earliest AT
clone machines which didn't adhere to the standard CMOS format.

   FloppyType DriveA%, DriveB%

-------
DriveA%    drive type of first floppy drive
DriveB%    drive type of second floppy drive

Name  : FlushToDisk          (Flush file buffers To Disk)
Class : Disk
Level : DOS

This is a "file safety" routine for use with files opened by
FOpen1 or FCreate. Files are normally buffered by DOS, which
makes file handling faster but creates the danger of losing the
file if there is a crash or power outage. By flushing the file
to disk, you insure that it is updated to the current moment.

Note: this routine will need to temporarily create a new file
handle if DOS versions before 4.0 are used.

   FlushToDisk Handle%, ErrCode%

Handle%    handle of the file to flush
-------
ErrCode%   error code: 0 if none, else DOS Error

Name  : FOpen1               (File Open)
Class : Disk
Level : DOS

This routine opens an existing file for use with the PBClone
file handling routines. If you need to create a file that
doesn't already exist, use the FCreate routine instead.

The file may be opened for reading, writing, or both:

   0   Read
   1   Write
   2   Read/Write

You may specify a file sharing mode for use with networks and
multitaskers. This will only take effect if the DOS version is
3.0 or later and if the DOS SHARE utility has been executed.
Otherwise, it will be ignored.

   0   Normal       compatibility mode: no file sharing
   1   Exclusive    no one else may access the file
   2   Deny Write   no one else may write to the file
   3   Deny Read    no one else may read from the file
   4   Deny None    anyone else may read from or write to file

Most of the time, "Deny Write" will be appropriate. This allows
others to read the file, but not to modify the file on you
unexpectedly.

See the discussion of predefined device handles at FClose1.

   FOpen1 FileName$, ReadWrite%, Sharing%, Handle%, ErrCode%

FileName$   name of the file to open
ReadWrite%  whether you want input, output, or both (see above)
Sharing%    file sharing mode (see above)
-------
Handle%    handle by which to access the file (if no error)
ErrCode%   error code: 0 if no error, else DOS Error

Name  : ForceMatch$          (Force Match of file to wildcard)
Class : Disk
Level : Any

The ForceMatch$ function allows you to mimic DOS commands that
operate on source file(s) and destination file(s). It forces a
source file name to match a specified pattern (which may contain
wildcards), producing an appropriate destination file name.

For example, if the source is "TESTNAME.BAS" and the pattern is
"?RUE*.*", the result would be "TRUENAME.BAS".

Consider the DOS command "COPY *.BAS A:*.BAK". The "*.BAK" part
is the desired pattern. The "*.BAS" part specifies which files
to copy to the new pattern. Each filename that matches "*.BAS"
is translated through the "*.BAK" pattern to give the
destination filename. The ForceMatch$ function is designed to do
this sort of translation for you.

   DestFile$ = ForceMatch$(Pattern$, SrcFile$)

Pattern$   pattern of desired file name (may contain wildcards)
SrcFile$   file name to force through the pattern
-------
DestFile$  resulting file name

Name  : FormatDate           (Format Date)
Class : Time
Level : Any

This is a highly flexible date formatting routine. It accepts a
date in one of the usual American formats ("03-22-1990",
"03/22/90", or even "3/22/90") and converts it according to a
format string. This format string allows you to normalize the
date, select a new delimiter, choose between two-digit and
four-digit years, and even change the order from month/day/year
to anything else. An error code will be returned if the date is
not valid.

The format string can be as simple as "##/##/##", which
specifies that the usual month/day/year order be used, with a
delimiter of "/" and a two-digit year. If you want to change the
date order, you would need a format like "DD.MM.YYYY" instead.
For sorting or storage, you might want to convert the date to a
plain number, using a format string like "YYYYMMDD". The result
could then be converted to a LONG with the BASIC VAL function.

   FormatDate DateSt$, Format$, Result$, ErrCode%

DateSt$     date to format (month, day, year order)
Format$     format for the date
-------
Result$     resulting date
ErrCode     whether the date is valid (0 ok)

Name  : FormatPhone$         (Format Phone number)
Class : String
Level : Any

This function formats a phone number using the standard U.S.
notation. The phone number is passed as a string. This string is
screened of any invalid phone number characters and is then
formatted according to its length into one of the following:

   "1234"
   "555-1234"
   "(303) 555-1234"

Valid characters are all digits and letters except for Q and Z.
Letters are capitalized by the routine. A leading "1" may be
present if there is an area code-- if so, it is removed. Phone
numbers which are the wrong length will cause a null string ("")
to be returned.

See also StripChar, which will allow you to undo formatting.

   Phone$ = FormatPhone$(RawNr$)

RawNr$      unformatted phone number
-------
Phone$      formatted phone number ("" if invalid)

Name  : FReadLine            (File Read Line)
Class : Disk
Level : DOS

This routine works like LINE INPUT-- it reads in an entire line
of text from a file. The Dest$ variable must be set to the
desired maximum length beforehand. On return, the number of
characters is returned in DLen%, and TooLong% will be set if the
Dest$ variable is full and a carriage return/linefeed pair was
not (yet?) found.

   Dest$ = SPACE$(MaxLength%)
   FReadLine Handle%, Dest$, DLen%, TooLong%, ErrCode%
   Dest$ = LEFT$(Dest$, DLen%)

Handle%    handle of the file
-------
Dest$      result (init to max length first)
DLen%      number of characters in result
TooLong%   zero if we read it all, -1 if CR/LF not found
ErrCode%   zero if no error, else DOS error code

Name  : FromPostal$          (From Postal Abbreviation)
Class : String
Level : Any

This function returns the state name corresponding to a given
two-letter postal abbreviation. It handles all U.S. postal
abbreviations, including states (e.g., "AZ" = "Arizona") and a
number of other countries (e.g., "PR" = "Puerto Rico"). A null
string ("") is returned if the specified abbreviation is not a
valid code.

The conversion can also be done the other way around-- see the
ToPostal$ function.

   PlaceName$ = FromPostal$(Abbrev$)

Abbrev$      two-letter postal abbreviation
-------
PlaceName$   place name corresponding with abbreviation

Name  : FSetEnd              (File Set to End)
Class : Disk
Level : DOS

This moves the file pointer to the end of the file. It is for
use with files opened by FOpen1 or FCreate. The usual purpose
for this is to append information to an existing file.

Note that some text files may have a Control-Z or CHR$(26) on
the end. For historical reasons, this character is sometimes
used as an "end of file" marker. When dealing with text files,
you may want to examine the last character of the file to make
sure it isn't a Control-Z.

Some of Microsoft's BASIC compilers are among the programs
which, unfortunately, put a Control-Z at the end of a file (if
you OPEN for OUTPUT).

   FSetEnd Handle%

Handle%    handle of the file

Name  : FSetLoc              (File Set Location to byte)
Class : Disk
Level : DOS

This moves the file pointer to a specified position in the file.
It is for use with files opened by FOpen1 or FCreate. File
positions are considered to start at 1.

   FSetLoc Handle%, Posn&

Handle%    handle of the file
Posn&      location to which to move

Name  : FSetOfs              (File Set location by Offset)
Class : Disk
Level : DOS

This moves the file pointer backwards or forwards in the file.
It is for use with files opened by FOpen1 or FCreate.

   FSetOfs Handle%, Offset&

Handle%    handle of the file
Offset&    number of bytes by which to move

Name  : FSetRec              (File Set location to Record)
Class : Disk
Level : DOS

This sets the file pointer to a specific record in the file. It
is for use with files opened by FOpen1 or FCreate.

This routine provides the same function as FSetLoc, but is a bit
more convenient for dealing with files composed of fixed-length
records.

   FSetRec Handle%, RecSize%, RecNr%

Handle%    handle of the file
RecSize%   number of bytes per record
RecNr%     number of record (starting at 1)

Name  : FSetSize             (File Set Size)
Class : Disk
Level : DOS

Many people have asked how to delete information from a file.
Well, there's no straightforward way to do it most of the time,
but if the record is at the end of the file, you can chop it
right off.

This routine can also be used to make a file larger, perhaps
pre-allocating space that will be used later (for better speed).

The file in question must have been opened by FCreate or FOpen1.

   FSetSize Handle%, Bytes&

Handle%    handle of the file
Bytes&     desired file size, in bytes

Name  : FSize                (File get Size)
Class : Disk
Level : DOS

This routine allows you to get the size of a file that was
opened by FOpen1 or FCreate.

See also FSize2, the FUNCTION version of this routine.

   FSize Handle%, Bytes&

Handle%    handle of the file
-------
Bytes&     file size, in bytes

Name  : FSize2&              (File get Size)
Class : Disk
Level : DOS

This routine allows you to get the size of a file that was
opened by FOpen1 or FCreate.

See also FSize, the Sub version of this routine.

   Bytes& = FSize2&(Handle%)

Handle%    handle of the file
-------
Bytes&     file size, in bytes

Name  : FUnlock              (File Unlock)
Class : Disk
Level : DOS

This routine unlocks any part of a file. It is used to undo the
effects of FLock, which locks any part of a file. It is
important to pass the exact same parameters to FUnlock as you
did to FLock. See also FLock.

Note that it is IMPORTANT to unlock the locked area before the
file is closed and before your program terminates. If the file
is not properly unlocked, it may be damaged.

   FUnlock FileHandle%, StartPosn&, Bytes&, ErrCode%

FileHandle%    file handle
StartPosn&     starting offset (1 for first position)
Bytes&         number of bytes to unlock
-------
ErrCode%       error code (0 if no error, else DOS error code)

Name  : Get4DOSv             (Get 4DOS Version)
Class : Equipment
Level : DOS

The Get4DOSv routine returns the version of 4DOS being used. It
returns the results as two integers containing the major and
minor version numbers. For instance, 4DOS 4.0 would return a
major number of 4, minor 0. If 4DOS is not installed, both
version numbers will be zero.

If you're not familiar with 4DOS, it's a terrific improved
replacement for COMMAND.COM. For more information, write JP
Software Inc., P.O. Box 1470, Arlington MA 02174, or call your
local BBS.

   Get4DOSv MajorV%, MinorV%

-------
MajorV%   major part of the 4DOS version
MinorV%   minor part of the 4DOS version

Name  : GetAttrF             (Get Attribute of File)
Class : Disk
Level : DOS

The GetAttrF routine returns the attributes of a file matched by
FindFirstF or FindNextF.

   Normal          0      (nothing special)
   Read Only       1      file can be read, but not written to
   Hidden          2      file is "invisible"
   System          4      special DOS system file
   Subdirectory   16      subdirectory
   Archive        32      (used by some backup utilities)

You can see if a certain value is set using the AND operator:

   IF FAttr% AND 16 THEN PRINT "Subdirectory"

Since the values are all powers of two, the AND operator makes
for a convenient way of decoding the results.

See also the ExplainFAttr$ function, which decodes the meanings
of the attribute for you.

Routines in this series include:
   FindFirstF, FindNextF, GetNameF, GetAttrF, GetDateF,
   GetTimeF, GetSizeFL

   GetAttrF FAttr%

-------
FAttr%   attributes that are set

Name  : GetAttrFx%           (Get Attribute of File, Extended)
Class : Disk
Level : DOS

The GetAttrFx% function returns the attributes of a file matched
by FindFirstFx or FindNextFx.

   Normal          0      (nothing special)
   Read Only       1      file can be read, but not written to
   Hidden          2      file is "invisible"
   System          4      special DOS system file
   Subdirectory   16      subdirectory
   Archive        32      (used by some backup utilities)

You can see if a certain value is set using the AND operator:

   IF FAttr% AND 16 THEN PRINT "Subdirectory"

Since the values are all powers of two, the AND operator makes
for a convenient way of decoding the results.

See also the ExplainFAttr$ function, which decodes the meanings
of the attribute for you.

Routines in this series include:
   FindFirstFx, FindNextFx, GetNameFx$, GetAttrFx%, GetDateFx$,
   GetTimeFx$, GetSizeFx&

   FAttr% = GetAttrFx%(Buffer$)

Buffer$   buffer used in search
-------
FAttr%    file attributes

Name  : GetColor             (Get Color)
Class : Display
Level : Clone

This routine tells you the current default foreground and
background colors being used by BASIC. It should be used only in
text modes.

   GetColor Foreground%, Background%

-------
Foreground%   foreground color
Background%   background color

Name  : GetCommAddr          (Get Comm Address)
Class : Serial
Level : Clone

This routine allows you to determine the base port address of a
serial port. You tell it the COM port number (1-4) and it
returns the port address. If there is no port installed, zero
will be returned.

Note that ports are "supposed" to be assigned sequentially-- in
other words, if you find a "zero" port address, there will be no
ports after that. This is not necessarily the case, however.
Some semi-standard machines may have a COM2 without a COM1, for
instance. QuickBASIC gets confused in that case, but it's no
problem with my PBClone or BasWiz libraries.

Aside from purely informational purposes, this routine can be
useful in conjunction with SetCommAddr in manipulating the
serial ports.

   GetCommAddr PortNr%, PortAddr%

PortNr%     COM port number (1-4)
-------
PortAddr%   port address

Name  : GetCRCA              (Get CRC of Archive file)
Class : Disk / Time
Level : DOS

GetCRCA returns the 16-bit CRC of an archived file matched by
the FindFirstA or FindNextA routines. Since some archives use
32-bit CRCs, you may wish to use the more generic version of
this routine, GetCRCAL.

Routines in this series include:
   FindFirstA, FindNextA, GetNameA, GetCRCA, GetCRCAL,
   GetDateA, GetTimeA, GetSizeAL, GetStoreA

   GetCRCA CRC16%

-------
CRC16%     16-bit CRC

Name  : GetCRCAL             (Get CRC of Archive file as Long)
Class : Disk / Time
Level : DOS

GetCRCAL returns the 32-bit CRC of an archived file matched by
the FindFirstA or FindNextA routines. If the archive only has a
16-bit CRC, the result is converted to 32 bits, so this routine
works with all archives.

Routines in this series include:
   FindFirstA, FindNextA, GetNameA, GetCRCA, GetCRCAL,
   GetDateA, GetTimeA, GetSizeAL, GetStoreA

   GetCRCAL CRC32%

-------
CRC32%     32-bit CRC

Name  : GetCRT               (Get CRT)
Class : Display / Equipment
Level : Clone

The GetCRT routine simply tells you whether the current display
is capable of handling colors or not. An unsophisticated
routine, GetCRT assumes that if the display is an MDA/Hercules,
it can't do color, but otherwise it can.

See also GetEGA, GetHGA and GetVGA.

   GetCRT Colour%

-------
Colour%   whether the display is color (0 if no)

Name  : GetCRT2%             (Get CRT)
Class : Display / Equipment
Level : Clone

The GetCRT2 routine simply tells you whether the current display
is capable of handling colors or not. An unsophisticated
routine, GetCRT2 assumes that if the display is an MDA/Hercules,
it can't do color, but otherwise it can.

See also GetEGA, GetHGA and GetVGA.

   Colour% = GetCRT%

-------
Colour%   whether the display is color (0 if no)

Name  : GetDateA             (Get Date of Archive file)
Class : Disk / Time
Level : DOS

GetDateA returns the date of a archived file matched by the
FindFirstA or FindNextA routines.

Routines in this series include:
   FindFirstA, FindNextA, GetNameA, GetCRCA, GetCRCAL,
   GetDateA, GetTimeA, GetSizeAL, GetStoreA

   GetDateA MonthNr%, DayNr%, YearNr%

-------
MonthNr%    month
DayNr%      day
YearNr%     year

Name  : GetDateAT            (Get Date from AT clock)
Class : Time
Level : BIOS (AT)

This routine gets the date from the hardware real-time clock in
AT-class computers. Depending on the DOS version, this date may
be partially or completely independent of the date kept by DOS
in software. DOS always reads the date from the hardware clock
when it starts up. However, use of the DATE command in DOS (and
the DATE$ function in QuickBASIC) may relate only to the
software copy of the date, which is not always guaranteed to be
the same as the date in the hardware clock due to certain
discrepancies in DOS.

   GetDateAT MonthNr%, DayNr%, YearNr%, ErrCode%

-------
MonthNr%     month number (1-12)
DayNr%       day (1-31)
YearNr%      year (1980-2079)
ErrCode%     error code: 0 if no error, else clock has stopped

Name  : GetDateF             (Get Date of File)
Class : Disk / Time
Level : DOS

The GetDateF routine returns the date of a file matched by
FindFirstF or FindNextF.

Routines in this series include:
   FindFirstF, FindNextF, GetNameF, GetAttrF, GetDateF,
   GetTimeF, GetSizeFL

   GetDateF MonthNr%, DayNr%, YearNr%

-------
MonthNr%    month
DayNr%      day
YearNr%     year

Name  : GetDateFx$           (Get Date of File, Extended)
Class : Disk / Time
Level : DOS

The GetDateFx$ function returns the date of a file matched by
FindFirstFx or FindNextFx.

Routines in this series include:
   FindFirstFx, FindNextFx, GetNameFx$, GetAttrFx%, GetDateFx$,
   GetTimeFx$, GetSizeFx&

   FileDate$ = GetDateFx$(Buffer$)

Buffer$     buffer used in search
-------
FileDate$   date of file (e.g., "02-28-1991")

Name  : GetDOSv              (Get DOS Version)
Class : Equipment
Level : DOS

The GetDOSv routine tells you what version of DOS you're using.
It returns the results as two integers containing the major and
minor version numbers. For instance, MS-DOS 2.11 would return a
major number of 2, minor 11.

The OS/2 compatibility box returns version numbers beginning at
10.00. For instance, OS/2 v1.1 returns 10.10 and OS/2 v2.0
returns 20.00.

   GetDOSv MajorV%, MinorV%

-------
MajorV%   major part of the DOS version
MinorV%   minor part of the DOS version

Name  : GetDrive$            (Get default Drive)
Class : Disk
Level : DOS

This routine tells you the letter of the current default drive.

See also GetDrv, the SUB version of this routine.

   Drive$ = GetDrive$

-------
Drive$    default drive letter.

Name  : GetDrv               (Get default Drive)
Class : Disk
Level : DOS

This routine tells you the letter of the current default drive.

See also GetDrive, the FUNCTION version of this routine.

   Drive$ = "x"
   GetDrv Drive$

-------
Drive$    default drive letter.  Init to at least one character.

Name  : GetDView             (Get DESQview version)
Class : Miscellaneous
Level : DOS

The GetDView routine tells you what version of DESQview is
loaded. It returns the results as two integers containing the
major and minor version numbers. For instance, DESQview 2.0
would return a major number of 2 and a minor number of 0. If
DESQview is not loaded, zeroes are returned.

See also GetTView, GetTVScreen, UpdTVScreen.

   GetDView MajorV%, MinorV%

-------
MajorV%   major part of the DESQview version (0 if no DESQview)
MinorV%   minor part of the DESQview version

Name  : GetEGA               (Get EGA information)
Class : Display / Equipment
Level : BIOS

This routine tells you whether an EGA (or VGA) is available, and
if so, what kind. It tells you whether the attached display is
monochrome or color, and how many kilobytes of RAM are installed
in the adapter.

Many early EGAs had only 64K of RAM. Current adapters have 256K
or more. Since there are some limitations attached to having
only 64K, it's a good idea to see if this is the case-- most
PBClone EGA routines won't work properly on 64k adapters.

See also GetCRT, GetHGA and GetVGA.

See also GetEGA2, the FUNCTION version of this routine.

   GetEGA Display%, KBytes%

-------
Display%  EGA display type: 0 no EGA, 1 EGA color, 2 EGA mono
KBytes%   kilobytes of display memory

Name  : GetEGA2%             (Get EGA information)
Class : Display / Equipment
Level : BIOS

This routine tells you whether an EGA (or VGA) is available.

See also GetCRT2, GetHGA and GetVGA2.

See also GetEGA, the SUB version of this routine. It returns
additional information.

   IsEGA% = GetEGA2%

-------
IsEGA%    whether the display is an EGA (0 if no)

Name  : GetError             (Get Error code from DOS)
Class : Miscellaneous
Level : Clone

NOTE: The GetError2% function should be used in preference to
this routine.

The GetError routine is used in conjunction with CatchError. It
lets you get the exit code (error level) returned by a program
to which you have SHELLed. Since CatchError hooks an interrupt
to do its work, you must always make sure to use GetError
afterwards to "clean up". See also CatchError.

Note that differences in DOS mean that this routine will not
always work. In some versions of DOS, you can only get the error
level if a batch file was executed; in others, you can't get the
error level from a batch file at all. Sorry about that. I don't
know of any way to work around it.

   CatchError
   SHELL ProgramName$
   GetError ExitCode%

-------
ExitCode%   exit code returned by SHELLed-to program (0-255)

Name  : GetError2%           (Get Error code from DOS)
Class : Miscellaneous
Level : DOS

The GetError2% function gets the exit code (error level)
returned by a program to which you have SHELLed. It should be
used as soon as possible after the SHELL, and its value will
only be meaningful on the first call after the SHELL.

This routine should be used in preference to CatchError and
GetError.

   SHELL ProgramName$
   ExitCode% = GetError2%

-------
ExitCode%   exit code returned by SHELLed-to program (0-255)

Name  : GetExecPath          (Get Execution Path of program)
Class : Disk
Level : DOS 3.0+

This routine returns the full path of your program, i.e., the
drive, subdirectory, and name of the program. It does not rely
on the current drive and subdirectory settings or look at the
PATH setting-- DOS tells it directly. This makes it an excellent
way to find the program's "home" directory, where (hopefully)
any data files associated with the program will also be stored.

   SelfName$ = SPACE$(80)
   GetExecPath SelfName$, SelfLen%
   SelfName$ = LEFT$(SelfName$, SelfLen%)

-------
SelfName$   full path for current program.  Init to 80+ chars.
SelfLen%    length of the full path spec.

Name  : GetExtM              (Get Extended Memory)
Class : Memory / Equipment
Level : BIOS (AT)

This routine allows you to find out how much extended memory is
available. It should only be used on AT-class computers, since
older PCs do not support extended memory. Note that some of the
very early AT machines will return erroneous results.

The amount of memory returned may be either the total amount of
extended memory installed or just the amount available at this
time, depending on how previously-installed programs (if any)
make use of extended memory. Unfortunately, there is no standard
which defines how a program should use extended memory as there
is with EMS (expanded memory), so there is no way for a program
to determine whether or how another program is using extended
memory. Microsoft is trying to clear up this situation with its
HIMEM driver (available at your local BBS, or [last I looked]
free from Microsoft), but this approach hasn't really become
standard yet.

   GetExtM KBytes%

-------
KBytes%    the number of kilobytes of extended memory

Name  : GetFAttr             (Get File Attribute)
Class : Disk
Level : DOS

This routine lets you read the attributes of a file or
subdirectory. The attributes may contain a combination of any of
the following:

   Normal          0      (nothing special)
   Read Only       1      file can be read, but not written to
   Hidden          2      file is "invisible"
   System          4      special DOS system file
   Subdirectory   16      subdirectory
   Archive        32      (used by some backup utilities)

You can see if a certain value is set by using the AND operator:

   IF FAttr% AND 2 THEN PRINT "Hidden file"

Since the values are all powers of two, the AND operator makes
for a convenient way of decoding the results.

See also the ExplainFAttr$ function, which decodes the meanings
of the attribute for you.

   GetFAttr FileName$, FAttr%

FileName$   name of the file (or subdirectory) to examine
-------
FAttr%      attributes that are set

Name  : GetFDate             (Get File Date)
Class : Disk / Time
Level : DOS

This routine gets the date of a file.

   GetFDate FileName$, MonthNr%, DayNr%, YearNr%

FileName$   name of the file to examine
-------
MonthNr%    month
DayNr%      day
YearNr%     year

Name  : GetFSize             (Get File Size)
Class : Disk
Level : DOS

This function gets the size of a file.

   FileSize& = GetFSize&(FileName$)

FileName$   name of the file to examine
-------
FileSize&   size of the file, in bytes

Name  : GetFTime             (Get File Time)
Class : Disk / Time
Level : DOS

This routine gets the time of a file.

   GetFTime FileName$, HourNr%, MinuteNr%, SecondNr%

FileName$     name of the file to examine
-------
HourNr%       hour
MinuteNr%     minute
SecondNr%     second (always even, due to DOS storage techniques)

Name  : GetHGA%              (Get Hercules Adapter info)
Class : Display / Equipment
Level : Clone

This routine tells you whether a Hercules-compatible monochrome
graphics adapter is in use.

See also GetCRT2, GetEGA and GetVGA2.

   IsHGA% = GetHGA%

-------
IsHGA%    whether the display is Hercules mono graphics (0 no)

Name  : GetKbd               (Get Keyboard toggles)
Class : Input
Level : Clone

The GetKbd routine allows you to get the state of the four
keyboard toggles: Insert, Caps lock, Num lock, and Scroll Lock.

   GetKbd Insert%, Caps%, Num%, Scrl%

-------
Insert%    whether "insert" mode is on (0 if no)
Caps%      whether "caps lock" is on (0 if no)
Num%       whether "num lock" is on (0 if no)
Scrl%      whether "scroll lock" is on (0 if no)

Name  : GetKbd1              (Get Keyboard Shifts)
Class : Input
Level : Clone

The GetKbd1 routine allows you to get the state of the four
keyboard shift keys: Left shift, Right shift, Control and Alt.

   GetKbd1 LShift%, RShift%, Control%, Alt%

-------
LShift%    whether the left shift key is depressed (0 if no)
RShift%    whether the right shift key is depressed (0 if no)
Control%   whether a control key is depressed (0 if no)
Alt%       whether an alt key is depressed (0 if no)

Name  : GetKbd2              (Get Keyboard Shifts)
Class : Input
Level : AT BIOS

The GetKbd2 routine allows you to get the state of the six
keyboard shift keys on an "enhanced" keyboard: Left shift, Right
shift, Left Control, Right Control, Left Alt and Right Alt.

Normally, the BIOS only lets you see one key at a time, which
can be a barrier when you need more input. This is a particular
problem with action games and other real-time applications which
have complex input requirements. Due to the special way the BIOS
treats shift keys, GetKbd2 can tell if the the various shift
keys are pressed simultaneously, allowing more flexibility.

   GetKbd2 LShift%, RShift%, LCtrl%, RCtrl%, LAlt%, RAlt%

-------
LShift%    whether the left shift key is depressed (0 if no)
RShift%    whether the right shift key is depressed (0 if no)
LCtrl%     whether the left control key is depressed (0 if no)
RCtrl%     whether the right control key is depressed (0 if no)
LAlt%      whether the left alt key is depressed (0 if no)
RAlt%      whether the right alt key is depressed (0 if no)

Name  : GetKey               (Get Key or mouse)
Class : Input, Mouse
Level : BIOS

This routine is kind of an extended version of INPUT$. It waits
until a key is available at the keyboard and returns the key
pressed. At your option, it can also return if a mouse button is
pressed.

See also the LClickLoc and RClickLoc routines, which allow you
to determine what the mouse position was at the last click.

   GetKey Mouse%, ASCIIcode%, ScanCode%, LButton%, RButton%

Mouse%        whether to check the mouse (0: no)
-------
ASCIIcode%    ASCII code of the key pressed
ScanCode%     scan code of the key pressed (0 if none)
LButton%      whether the left  mouse button was pressed
RButton%      whether the right mouse button was pressed

Name  : GetKey3              (Get Key or 3-button mouse)
Class : Input, Mouse
Level : BIOS

This routine is kind of an extended version of INPUT$. It waits
until a key is available at the keyboard and returns the key
pressed. At your option, it can also return if a mouse button is
pressed.

See also the LClickLoc, MClickLoc and RClickLoc routines, which
allow you to determine what the mouse position was at the last
click.

   GetKey3 Mouse%, ASCIIcode%, ScanCode%, LButton%,
      MButton%, RButton%

Mouse%        whether to check the mouse (0: no)
-------
ASCIIcode%    ASCII code of the key pressed
ScanCode%     scan code of the key pressed (0 if none)
LButton%      whether the left   mouse button is pressed
MButton%      whether the middle mouse button is pressed
RButton%      whether the right  mouse button is pressed

Name  : GetLabel             (Get disk volume Label)
Class : Disk
Level : DOS

This routine gets the volume label from a specified drive. See
also GetLabel2$.

   Label$ = SPACE$(11)
   GetLabel Drive$, Label$, LabelLen%, ErrCode%
   Label$ = LEFT$(Label$, LabelLen%)

Drive$     letter of the drive to examine
-------
Label$     volume label of drive.  Init to >= 11 chars.
LabelLen%  length of the volume label
ErrCode%   error code: 0 if no error, else DOS Error

Name  : GetLabel2$           (Get disk volume Label)
Class : Disk
Level : DOS

This routine gets the volume label from a specified drive. See
also GetLabel, a subprogram version of this routine. The
GetLabel subprogram is preferable in that it returns an error
code, but you may find the function version more convenient if
error checking is not desired.

   Label$ = GetLabel2$(Drive$)

Drive$     letter of the drive to examine
-------
Label$     volume label of the specified drive.

Name  : GetLIMHandles        (Get L/I/M expanded mem Handles)
Class : Memory
Level : DOS

Early Lotus/Intel/Microsoft expanded memory revisions provided a
limited number of "handles" which could be used to access
expanded memory-- often as few as 15 or so. If your program uses
expanded memory and the EMS driver is one of the older versions,
you may want to make sure that enough handles are available.
This routine tells you how many handles are in use.

Note that this routine expects an EMS driver to be installed. If
you can't be sure of that, use GetLIMM first to avoid an
unpleasant surprise.

   GetLIMHandles Handles%

-------
Handles%  number of EMS handles in use

Name  : GetLIMM              (Get L/I/M expanded Memory)
Class : Memory / Equipment
Level : DOS

This routine tells you how much expanded memory is installed. If
there is none, or if the EMS driver hasn't been installed, it
returns zeroes. You should use this routine before any other of
the PBClone routines that access expanded memory, since the
other routines expect EMS to be available.

The results are returned in terms of EMS pages. Each page is 16
kilobytes.

   GetLIMM TotalPages%, FreePages%

-------
TotalPages%  number of EMS pages installed
FreePages%   number of EMS pages available for use

Name  : GetLIMV              (Get L/I/M expanded mem Version)
Class : Memory / Equipment
Level : DOS

The GetLIMV routine tells you the version of EMS driver that is
being used. The version number is separated into major and minor
parts. For example, an EMS 3.1 driver would return a major
number of 3 and minor number of 1.

Note that this routine expects an EMS driver to be installed. If
you can't be sure of that, use GetLIMM first to avoid an
unpleasant surprise.

   GetLIMV MajorVer%, MinorVer%

-------
MajorVer%  major part of the EMS version number
MinorVer%  minor part of the EMS version number

Name  : GetLine              (Get Line of text)
Class : Display
Level : Any

This routine retrieves a row of text from a saved (or virtual)
screen.

You can use GetLine with a saved screen of any size. The St$
parameter must be initialized to the width of the saved screen
(in columns).

See also ReadScreen, which allows you to read a string of any
length directly from the display.

   St$ = SPACE$(ScrWidth%)   ' init to v. screen width
   GetLine DSeg%, DOfs%, Row%, St$, SLen%
   St$ = LEFT$(St$, SLen%)

DSeg%      segment of saved screen
DOfs%      offset of saved screen
Row%       row of saved screen (starting at 1)
-------
St$        text at given row (init to width of saved screen)
SLen       logical length of text

Name  : GetLogiDrive$        (Get Logical Drive)
Class : Disk
Level : DOS 3.2+

This routine is useful for systems which only have a single
floppy drive. In such cases, DOS connects both drive letters A:
and B: to the same drive. However, only one drive letter is
active, and when you try to access the "other" drive, DOS
displays the message:

  "Insert diskette for drive x: and press any key when ready."

This function allows you to determine whether a drive is
remapped, and if so, which letter is currently active for the
drive in question. The result will be a null string ("") if the
drive is not multiply mapped; or, if the drive is multiply
mapped, the letter which currently refers to the drive is
returned. For example, if you check drive "A" on a dual-floppy
system, you'll get back ""; but on a single-floppy system,
you'll get back "A" or "B", depending on which letter was last
used to access the drive.

See also SetLogiDrive, which allows you to set the active drive
letter for a given drive.

   ActiveDrv$ = GetLogiDrive$(Drive$)

Drive$       drive letter to check (use "" for current drive)
-------
ActiveDrv$   active drive letter, or "" if no remapping is done

Name  : GetMemBox            (Get Memory Box info)
Class : Memory
Level : DOS

The PBClone library comes with a TSR called MEMBOX.COM. This TSR
reserves an area of memory which can be used as a transfer area
for communication between multiple programs-- the data remains
as long as the TSR is installed.

The GetMemBox routine tells you whether MEMBOX is installed, how
much memory it has, and the location of that memory. You can
access the MEMBOX memory using any PBClone routine that accepts
segment and offset pointers. The DGetSt and DPutSt routines will
probably be most helpful for general use.

NOTE that MEMBOX expects to be the last TSR installed. If any
other TSR or program alters the INT 2Fh interrupt vector while
MEMBOX is active, the results are liable to be messy at best.

   GetMemLoc DSeg%, DOfs%, Bytes%

-------
DSeg%      memory segment
DOfs%      memory offset
Bytes%     bytes available (0 if MEMBOX is not installed)

Name  : GetMouseLoc          (Get Mouse Location)
Class : Mouse
Level : BIOS

This routine allows you to get the current location of the mouse
cursor. It doesn't matter if the cursor is visible or invisible.
GetMouseLoc is only for use in text mode.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

See also MMGetLoc, which returns the coordinates for graphics
mode.

   GetMouseLoc Row%, Column%

-------
Row%       mouse cursor row
Column%    mouse cursor column

Name  : GetMouseVer          (Get Mouse driver Version)
Class : Mouse
Level : BIOS

This routine retrieves various information about the mouse,
including the driver version number, mouse type, and IRQ used by
the mouse.

Note that this is among the mouse routines that makes you wonder
what Microsoft was thinking when they designed the mouse driver.
The mouse driver has no provision for error codes and the "get
version" function was added comparatively recently, so there is
no way of knowing with certainty whether this routine worked or
what the mouse driver version is. If that could be a problem,
you can reduce the risk by checking the returned values to make
sure they appear reasonable.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

The mouse type may be any of the following:
   1   bus mouse
   2   serial mouse
   3   InPort mouse
   4   PS/2 mouse
   5   Hewlett-Packard mouse

The IRQ will be 0 on the PS/2. Otherwise, it will be 2-5 or 7 on
Microsoft mice. A mouse designed to take advantage of the AT
interrupt controller may use higher IRQs (to perhaps 15, I'm not
sure), so be generous if you do range checking here.

The version number is divided into two parts. For instance,
mouse driver 8.20 would return a major version number of 8 and a
minor version number of 20.

   GetMouseVer MajorV%, MinorV%, MType%, IRQ%

-------
MajorV%    mouse driver major version number
MinorV%    mouse driver minor version number
MType%     mouse type
IRQ%       IRQ used by mouse

Name  : GetNameA             (Get Name of file in Archive)
Class : Disk
Level : DOS

GetNameA returns the name of an archived file matched by the
FindFirstA or FindNextA routines. Since some archives may
include subdirectory specs along with the file name, it is
recommended that you initialize the return string to 80
characters (at least 12 are required).

When parsing filenames which may contain subdirectory specs,
keep in mind that the forward slash "/" may be used instead of
the backslash "\" for delimiting subdirectories.

In order to reach the very widest audience, you may also wish to
take into account filenames which may have originated on non-PC
systems. In such filenames, the length of any part of the path
will not necessarily be restricted to the 11-plus-dot of MS-DOS,
the dot character may not mean anything special,
uppercase/lowercase distinctions may be significant, and
characters may be present which are not valid in MS-DOS names.

Routines in this series include:
   FindFirstA, FindNextA, GetNameA, GetCRCA, GetCRCAL,
   GetDateA, GetTimeA, GetSizeAL, GetStoreA

   FileName$ = SPACE$(80)
   GetNameA FileName$, NameLen%
   FileName$ = LEFT$(FileName$, NameLen%)

-------
FileName$   file name (init to >= 12 characters, preferably 80)
NameLen%    length of file name

Name  : GetNameF             (Get Name of File)
Class : Disk
Level : DOS

The GetNameF routine returns the name of a file matched by
FindFirstF or FindNextF. The name will not contain a drive or
subdirectory specification.

Routines in this series include:
   FindFirstF, FindNextF, GetNameF, GetAttrF, GetDateF,
   GetTimeF, GetSizeFL

   FileName$ = SPACE$(12)
   GetNameF FileName$, NameLen%
   FileName$ = LEFT$(FileName$, NameLen%)

-------
FileName$   file name (init to at least 12 characters)
NameLen%    length of file name

Name  : GetNameFx$           (Get Name of File, Extended)
Class : Disk
Level : DOS

The GetNameFx$ function returns the name of a file matched by
FindFirstFx or FindNextFx. The name will not contain a drive or
subdirectory specification.

Routines in this series include:
   FindFirstFx, FindNextFx, GetNameFx$, GetAttrFx%, GetDateFx$,
   GetTimeFx$, GetSizeFx&

   FileName$ = GetNameFx$(Buffer$)

Buffer$       buffer used in search
-------
FileName$     file name

Name  : GetPath$             (Get default Path)
Class : Disk
Level : DOS

This function returns the current drive and subdirectory as an
absolute path specification.

See also GetDrv, GetDrive$, GetSub, GetSub1, and GetSub2$.

   Path$ = GetPath$

-------
Path$      name of the current drive and subdirectory

Name  : GetPrtAddr           (Get Printer Address)
Class : Printer
Level : Clone

This routine allows you to determine the base port address of a
parallel port. You tell it the LPT port number (1-4) and it
returns the port address. If there is no port installed, zero
will be returned.

Note that up to four printer ports are (theoretically) supported
on most machines. On PS/2 computers, only three ports are
allowed, and the fourth port data area is used for other
purposes. So, it would probably be a good idea to restrict your
program to ports 1-3.

Aside from purely informational purposes, this routine can be
useful in conjunction with SetPrtAddr in manipulating the
parallel ports.

   GetPrtAddr PortNr%, PortAddr%

PortNr%     LPT port number (1-4 or 1-3 [see above])
-------
PortAddr%   port address

Name  : GetPrtSc%            (Get PrtSc press)
Class : Input
Level : BIOS

This function only works when the "print screen" key is
disabled, which you can accomplish via the PrtSc routine. It
returns whether the print screen key was pressed since you last
checked. Like INKEY$, it clears the value after you read it.

   Pressed% = GetPrtSc%

-------
Pressed%    whether the print screen key was pressed (0 if no)

Name  : GetPSP%              (Get Program Segment Prefix)
Class : Memory
Level : DOS

This function returns the segment of the Program Segment Prefix,
which is a sort of header at the beginning of every program that
contains assorted information. You can find out more about the
PSP in any DOS technical reference.

   PSeg% = GetPSP%

-------
PSeg%      segment of the Program Segment Prefix

Name  : GetRows              (Get Rows on screen)
Class : Display
Level : Clone

This routine tells you how many rows are on the display. This is
normally 25, but it may be greater on an EGA or VGA. Only text
modes are supported.

   GetRows Rows%

-------
Rows%    text rows on the display

Name  : GetRows2%            (Get Rows on screen)
Class : Display
Level : Clone

This routine tells you how many rows are on the display. This is
normally 25, but it may be greater on an EGA or VGA. Only text
modes are supported.

   Rows% = GetRows2%

-------
Rows%    text rows on the display

Name  : GetScreen            (Get Screen)
Class : Display
Level : Clone

This routine saves any portion of the display to an array. Only
text modes are supported. If your program uses multiple display
pages, you can get an image from any of those pages. A special
"slow" mode is supported for the CGA, to prevent flickering (a
problem only with some CGAs).

The size of the integer array needed to store a specific area of
the screen can be calculated using the CalcSize routine (see).

If you wish to save the entire screen, you may find ScrSave
easier (see).

   GetScreen Array%(), TRow%, LCol%, BRow%, RCol%, Page%, Fast%

TRow%      top row of the desired screen area
LCol%      left column of the desired screen area
BRow%      bottom row of the desired screen area
RCol%      right column of the desired screen area
Page%      page from which to get the display area
Fast%      whether to use fast mode (0 no)
-------
Array%()   stored image of the selected area of the screen

Name  : GetSerial$           (Get disk Serial number)
Class : Disk
Level : DOS 4.0+

The GetSerial function returns the serial number of the
specified disk. If there is no serial number, it returns
"0000-0000".

   SerialNr$ = GetSerial$(Drive$)

Drive$       drive to get serial # from ("" for current drive)
-------
SerialNr$    serial number of the specified drive

Name  : GetSizeAL            (Get Size of file in Archive Long)
Class : Disk
Level : DOS

GetSizeAL returns the size of an archived file matched by the
FindFirstA or FindNextA routines.

Routines in this series include:
   FindFirstA, FindNextA, GetNameA, GetCRCA, GetCRCAL,
   GetDateA, GetTimeA, GetSizeAL, GetStoreA

   GetSizeAL OrigSize&, CurrSize&

-------
OrigSize&    original (uncompressed) file size
CurrSize&    current (compressed) file size

Name  : GetSizeFL            (Get Size of File as Long)
Class : Disk
Level : DOS

The GetSizeFL routine returns the size of a file matched by
FindFirstF or FindNextF.

Routines in this series include:
   FindFirstF, FindNextF, GetNameF, GetAttrF, GetDateF,
   GetTimeF, GetSizeFL

   GetSizeFL FileSize&

-------
FileSize&   file size

Name  : GetSizeFx&           (Get Size of File, Extended)
Class : Disk
Level : DOS

The GetSizeFx& function returns the size of a file matched by
FindFirstFx or FindNextFx.

Routines in this series include:
   FindFirstFx, FindNextFx, GetNameFx$, GetAttrFx%, GetDateFx$,
   GetTimeFx$, GetSizeFx&

   FileSize& = GetSizeFx&(Buffer$)

Buffer$     buffer used in search
-------
FileSize&   file size

Name  : GetStoreA            (Get Storage of file in Archive)
Class : Disk / Time
Level : DOS

GetStoreA returns the method used to compress an archived file
matched by the FindFirstA or FindNextA routines.

Routines in this series include:
   FindFirstA, FindNextA, GetNameA, GetCRCA, GetCRCAL,
   GetDateA, GetTimeA, GetSizeAL, GetStoreA

   Storage$ = SPACE$(8)
   GetStoreA Storage$

-------
Storage$    storage method (init to 8 characters)

Name  : GetSub               (Get default Subdirectory)
Class : Disk
Level : DOS

The GetSub routine gets the current subdirectory on the default
drive. It does not put a backslash at the start of the
subdirectory, so you should add this yourself.

See also GetPath$, GetSub1, and GetSub2$.

   SubDir$ = SPACE$(64)
   GetSub SubDir$, SubLen%
   SubDir$ = "\" + LEFT$(SubDir$, SubLen%)

-------
SubDir$    name of the current subdirectory. Init to 64+ chars
SubLen%    length of the subdirectory name

Name  : GetSub1              (Get default Subdirectory)
Class : Disk
Level : DOS

The GetSub1 routine gets the current subdirectory on a specified
drive. Unlike GetSub, it places a backslash at the start of the
name. It also returns an error code, which allows you to see if
there was a disk error.

See also GetPath$, GetSub, and GetSub2$.

   SubDir$ = SPACE$(65)
   GetSub1 Drive$, SubDir$, SubLen%, ErrCode%
   SubDir$ = LEFT$(SubDir$, SubLen%)

Drive$     letter of the drive to check
-------
SubDir$    name of the current subdirectory. Init to 65+ chars
SubLen%    length of the subdirectory name
ErrCode%   error code: 0 if no error, else DOS Error

Name  : GetSub2$             (Get default Subdirectory)
Class : Disk
Level : DOS

The GetSub2 routine gets the current subdirectory on a specified
drive. Unlike GetSub, it places a backslash at the start of the
name.

See also GetPath$, GetSub, and GetSub1.

If you just want the subdirectory of the current drive, you can
use a null string ("") as the drive letter, or use GetPath$.

   SubDir$ = GetSub2$(Drive$)

Drive$     letter of the drive to check
-------
SubDir$    name of the current subdirectory. Init to 65+ chars

Name  : GetSwitch            (Get Switch character)
Class : Miscellaneous
Level : DOS

An undocumented capability in many DOS versions allows you to
set the DOS "switch character", which is the delimiter used to
identify a switch on the DOS command line. This is normally a
slash, as in "DIR /W". However, many people prefer to change it
to a "-", which is the switch character used by Unix.

With the normal "/" delimiter, a backslash "\" is used in
subdirectory specifications. DOS itself will recognize either
one as a subdirectory delimiter, but the command line won't
unless the switch char was changed.

The upshot of all this is, whereas you might normally use a
command like:
   DIR /W C:\GAMES

Someone with a different switch character might use something
like this:
   DIR -W C:/GAMES

This is exactly the sort of syntax that Unix commands use.

If you design your program to recognize the different
delimiters, you will make some people very happy! The GetSwitch
routine will detect changed delimiters on those versions of DOS
which support it, and will return an ordinary "/" on those
versions of DOS which don't.

   Switch$ = "x"
   GetSwitch Switch$

-------
Switch$    the DOS switch character.  Init to one character.

Name  : GetSwitch2$          (Get Switch character)
Class : Miscellaneous
Level : DOS

This does exactly the same thing as the GetSwitch routine, but
it is a FUNCTION rather than a SUB. For more information, see
GetSwitch.

   Switch$ = GetSwitch2$

-------
Switch$    the DOS switch character

Name  : GetTick&             (Get Tick)
Class : Time
Level : Clone

This function returns the system time. This value represents the
time after midnight. There are about 18.2 ticks per second,
providing sufficiently fine resolution for most purposes.

If you use this function as part of a delay loop, keep in mind
that the value will wrap around at midnight, and that any given
value may be "skipped" due to causes beyond your control--
multitasking or background operations such as communications or
print spooling, for example. So, DO NOT check for a specific
"end time"-- it may never come! Instead, decrement a counter
whenever you notice that the time has changed since you last
checked. This disassociates the delay from a specific time,
preventing lockups.

   Tick& = GetTick&

-------
Tick&        time after midnight (1/18.2 seconds)

Name  : GetTime              (Get Time)
Class : Time
Level : DOS

This routine tells you the time according to DOS.

The main difference between getting the time from BASIC and
getting it from DOS is the "hundredths of seconds" value.
However, this value is not available on some machines, in which
case it will be set to zero. It is not accurate on most
machines, being calculated instead using a semi-random approach;
it is more of a novelty than a useful value.

   GetTime HourNr%, MinuteNr%, SecondNr%, Hundredth%

-------
HourNr%      hour (0-23)
MinuteNr%    minute
SecondNr%    second
Hundredth%   hundredth of a second.  See remarks, above.

Name  : GetTimeA             (Get Time of file in Archive)
Class : Disk / Time
Level : DOS

GetTimeA returns the time of an archived file matched by the
FindFirstA or FindNextA routines.

Routines in this series include:
   FindFirstA, FindNextA, GetNameA, GetCRCA, GetCRCAL,
   GetDateA, GetTimeA, GetSizeAL, GetStoreA

   GetTimeA HourNr%, MinuteNr%, SecondNr%

-------
HourNr%     hour
MinuteNr%   minute
SecondNr%   second

Name  : GetTimeAT            (Get Time from AT clock)
Class : Time
Level : BIOS (AT)

This routine gets the time from the hardware real-time clock in
AT-class computers. Depending on the DOS version, this time may
be partially or completely independent of the time kept by DOS
in software. DOS always reads the time from the hardware clock
when it starts up. However, use of the TIME command in DOS (and
the TIME$ function in QuickBASIC) may relate only to the
software copy of the time, which is not always guaranteed to be
the same as the time in the hardware clock due to certain
discrepancies in DOS.

   GetTimeAT HourNr%, MinuteNr%, SecondNr%, ErrCode%

-------
HourNr%      hour (0-23)
MinuteNr%    minute
SecondNr%    second
ErrCode%     error code: 0 if no error, else clock has stopped

Name  : GetTimeF             (Get Time of File)
Class : Disk / Time
Level : DOS

The GetTimeF routine returns the time of a file matched by
FindFirstF or FindNextF.

Routines in this series include:
   FindFirstF, FindNextF, GetNameF, GetAttrF, GetDateF,
   GetTimeF, GetSizeFL

   GetTimeF HourNr%, MinuteNr%, SecondNr%

-------
HourNr%     hour
MinuteNr%   minute
SecondNr%   second

Name  : GetTimeFx$           (Get Time of File, Extended)
Class : Disk / Time
Level : DOS

The GetTimeFx$ function returns the time of a file matched by
FindFirstFx or FindNextFx.

Routines in this series include:
   FindFirstFx, FindNextFx, GetNameFx$, GetAttrFx%, GetDateFx$,
   GetTimeFx$, GetSizeFx&

   FileTime$ = GetTimeFx$(Buffer$)

Buffer$      buffer used in search
-------
FileTime$    file time (e.g., "17:53:20")

Name  : GetTView             (Get TopView)
Class : Miscellaneous
Level : BIOS

This routine tells you whether TopView or a compatible
multitasker (such as TaskView or DESQview) is loaded.

See also GetDView, GetTVScreen, UpdTVScreen.

   GetTView Installed%

-------
Installed%   whether a TopView-type multitasker is loaded

Name  : GetTVScreen          (Get TopView Screen address)
Class : Display / Miscellaneous
Level : BIOS

GetTVScreen returns the address of the screen buffer used by a
TopView-type multitasker. This allows you to use direct screen
access while remaining within the windows allocated to your
program by the multitasker.

You must tell the multitasker the address of the screen you
would be writing to if the multitasker was not installed.
Specify a segment of &HB000 if using an MDA or Hercules, or a
segment of &HB800 for CGA, EGA, MCGA or VGA. The offset should
always be 0. This is for use in text modes.

The routine will return with the new segment and offset for you
to use. These values can be used with any PBClone screen routine
that accepts a segment and offset-- DQPrint and DXQPrint, for
example.

Note that not all TopView-compatible multitaskers will
automatically update the screen from the buffer. The UpdTVScreen
routine allows you to force a screen update.

See also GetDView, GetTView, UpdTVScreen.

   GetTVScreen DSeg%, DOfs%

DSeg%       segment of desired screen
DOfs%       offset of desired screen
-------
DSeg%       segment of screen buffer
DOfs%       offset of screen buffer

Name  : GetValidKey          (Get Valid Key)
Class : Input
Level : DOS

This one is useful for getting one of a list of keys from the
keyboard. You give it a list of keys (letters should be
uppercase) to accept. It will wait until one of the listed keys
is pressed; for letters, it will accept either lowercase or
uppercase keys, but will convert the letter to uppercase before
it returns to you. If you pass it a blank list, it will accept
any key.

The Result$ string needs to be initialized to one character
before you call the routine, due to limitations on what assembly
language routines are allowed to do with BASIC strings.

This routine is handy for when you want to allow one of a list
of choices from a menu, for instance.

   Result$ = "x"
   GetValidKey GoodList$, Result$

GoodList$    list of acceptable keys.  See above for remarks.
-------
Result$      the key that was accepted (uppercase if letter)

Name  : GetVerify            (Get Verify setting)
Class : Disk
Level : DOS

The GetVerify routine tells you the state of the DOS VERIFY
flag. When VERIFY is on, some checking is done to make sure that
writing to the disk works as requested. The checks are not very
good, however, and VERIFY slows down disk handling, so it is
usually better to have VERIFY off.

You can change the state of VERIFY by using the DOS VERIFY
command or with the SetVerify routine in PBClone.

   GetVerify VerifyOn%

-------
VerifyOn%   whether VERIFY is on (0 if no)

Name  : GetVGA               (Get VGA information)
Class : Display / Equipment
Level : BIOS

This routine tells you whether a VGA is available.

See also GetCRT, GetEGA and GetHGA.

   GetVGA IsVGA%

-------
IsVGA%    whether a VGA is installed (0 if no)

Name  : GetVGA2%             (Get VGA information)
Class : Display / Equipment
Level : BIOS

This routine tells you whether a VGA is available.

See also GetCRT, GetEGA and GetHGA.

   IsVGA% = GetVGA2%

-------
IsVGA%    whether a VGA is installed (0 if no)

Name  : GetVGAColor          (Get VGA Color)
Class : Display
Level : BIOS

This routine gets the components of a single VGA palette color.
It returns the color value associated with a given color number.

If you are dealing with more than one color at a time, you may
find GetVGAPalette more appropriate.

   GetVGAColor ColorNr%, Red%, Green%, Blue%

ColorNr%   color number (1-16 or 1-255, depending on VGA mode)
-------
Red%       red intensity (0-63)
Green%     green intensity (0-63)
Blue%      blue intensity (0-63)

Name  : GetVGAPalette        (Get VGA Palette)
Class : Display
Level : BIOS

This routine allows you to get any number of the VGA palette
settings into a TYPEd array. The TYPE for the array should be
defined like this:

   TYPE Palet
      IRed AS STRING * 1
      IBlue AS STRING * 1
      IGreen AS STRING * 1
   END TYPE

This type holds a CHR$-encoded representation of the intensity
of each component of the color. The values range from 0-63.

If you are only dealing with a few colors, you may find it more
convenient to use GetVGAColor instead.

   GetVGAPalette DSeg%, DOfs%, Start%, Colors%

DSeg%      segment of the palette array
DOfs%      offset of the palette array
Start%     color number to start with
Colors%    number of colors to get

Name  : GetVidMode           (Get Video Mode)
Class : Display
Level : BIOS

The GetVidMode routine tells you about the current display
status from the BIOS' point of view. Note that the BIOS display
mode is not the same as the BASIC SCREEN mode (a direct
translation between the two is messy, because BASIC
conglomerates several BIOS modes into a single SCREEN mode in
several instances).

   GetVidMode BIOSMode%, ScreenWidth%, ActivePage%

-------
BIOSMode%     BIOS video mode
ScreenWidth%  number of columns per row
ActivePage%   active (visible) display page

Name  : GetXMSm              (Get XMS Memory)
Class : Memory / Equipment
Level : DOS

This routine tells you how much XMS memory is available. If
there is none, or if the XMS driver hasn't been installed, it
returns zeroes. Memory is returned kilobytes.

   GetXMSm LargestFree&, TotalFree&

-------
LargestFree&  largest free block of XMS memory
TotalFree&    total free XMS memory

Name  : GetXMSv              (Get XMS Version)
Class : Memory / Equipment
Level : BIOS

The GetXMSv routine tells you the version of XMS driver that is
being used. The version number is separated into major and minor
parts. For example, an XMS 2.0 driver would return a major
number of 2 and minor number of 0.

   GetXMSv MajorVer%, MinorVer%

-------
MajorVer%  major part of the XMS version number
MinorVer%  minor part of the XMS version number

Name  : GLoad                (Graphics Load)
Class : Disk
Level : DOS

A replacement for the BASIC BLOAD statement, this routine loads
a binary memory image from a file into the area of memory it
formerly occupied. This is most often used to restore a screen
display from a file, although PBClone offers more flexible
alternatives.

   GLoad FileName$

FileName$    name of the file to load into memory

Name  : GQPrint              (Graphics Quick Print)
Class : Display
Level : Clone

This is a simple high-speed replacement for the PRINT statement
which works in CGA graphics mode (SCREEN 2). It does not
interpret control codes, support graphics characters (ASCII
128-255), or update the cursor position, in return for which it
is much faster than PRINT.

The Fast% parameter is ignored at the moment-- top speed is
always used, which may cause flickering on some CGAs.

   GQPrint St$, Row%, Column%, Fast%

St$      string to display
Row%     row (1-25)
Column%  column (1-80)
Fast%    not used

Name  : GrafPrint            (Graphics Print)
Class : Display
Level : Clone

This is a flexible replacement for the PRINT statement which
operates in graphics mode. It allows you to display text at
graphics coordinates instead of text coordinates for better
alignment with graphs and so forth. It also lets you specify the
size of the font-- you can stretch it in either vertical or
horizontal directions, or both, using a font multiplier value.

The disadvantages of this routine are that it is slower than an
ordinary PRINT, only does foreground printing (if you need a
background color, you need to fill that in yourself beforehand),
won't do automatic wrap or scroll, and won't handle control
codes or graphics characters (ASCII 0-31, 127-255). The font is
based on the normal CGA graphics font, which uses an 8x8 grid
for each character.

GrafPrint will work in any graphics mode.

   GrafPrint St$, X%, Y%, High%, Wide%, Colour%

St$       string to display
X%        graphics column to start at
Y%        graphics row to start at
High%     font height multiplier
Wide%     font width multiplier
Colour%   foreground color for string

Name  : GrafRest             (Graphics Restore)
Class : Display
Level : Clone

This routine allows you to restore a SCREEN 1 (CGA, 320x200, 4
color) or SCREEN 2 (CGA, 640x200, 2 color) display that was
saved using GrafSave (see).

   GrafRest DSeg%, DOfs%

DSeg%      segment of storage array, returned by VARSEG
DOfs%      offset  of storage array, returned by VARPTR

Name  : GrafSave             (Graphics Save)
Class : Display
Level : Clone

This routine allows you to save a SCREEN 1 (CGA, 320x200, 4
color) or SCREEN 2 (CGA, 640x200, 2 color) display that can be
restored using GrafRest (see).

The array used to hold the screen must contain 16,000 bytes. For
an integer array, this means that you must create the array by
DIM Array%(1 TO 8000).

   GrafSave DSeg%, DOfs%

DSeg%      segment of storage array, returned by VARSEG
DOfs%      offset  of storage array, returned by VARPTR

Name  : GXQPrint             (Graphics Extended Quick Print)
Class : Display
Level : Clone

This is a simple high-speed replacement for the PRINT statement
which works in CGA graphics mode (SCREEN 1). It does not
interpret control codes, support graphics characters (ASCII
128-255), or update the cursor position, in return for which it
is much faster than PRINT.

This routine can also be used in SCREEN 2, where it will display
the string in shades instead of in color (using 40 columns/row).

The Fast% parameter is ignored at the moment-- top speed is
always used, which may cause flickering on some CGAs.

The results of this routine are not redirectable by DOS.

   GXQPrint St$, Row%, Column%, Fore%, Fast%

St$      string to display
Row%     row (1-25)
Column%  column (1-40)
Fore%    foreground color (0-3)
Fast%    not used

Name  : GXQPrint1            (Graphics Extended Quick Print)
Class : Display
Level : Clone

This is a high-speed replacement for the PRINT statement which
works in CGA graphics mode (SCREEN 1). It does not interpret
control codes or update the cursor position, in return for which
it is much faster than PRINT.

This routine can also be used in SCREEN 2, where it will display
the string in shades instead of in color (using 40 columns/row).

The Fast% parameter is ignored at the moment-- top speed is
always used, which may cause flickering on some CGAs.

The results of this routine are not redirectable by DOS.

   GXQPrint1 St$, Row%, Column%, Fore%, Back%, Fast%

St$      string to display
Row%     row (1-25)
Column%  column (1-40)
Fore%    foreground color (0-3)
Back%    background color (0-3)
Fast%    not used

Name  : HandleInfo           (Handle Information)
Class : Miscellaneous
Level : DOS

HandleInfo tells you whether a file handle refers to a file or
to a device. If the handle does not exist, an error code will be
returned.

This is for file handles as returned by FOpen1 and FCreate. It
can also be used with file numbers associated with OPEN, via a
BASIC function that was introduced with QuickBASIC 4.0:

   Handle% = FILEATTR(FileNumber%, 2)

See FClose1 for a list of predefined handles.

   HandleInfo Handle%, Device%, ErrCode%

Handle%    file handle
-------
Device%    whether the handle refers to a device (0 no)
ErrCode%   whether there was an error (0 no)

Name  : HCls                 (Hercules CLS)
Class : Display
Level : Clone

This routine clears a Hercules graphics screen to the specified
color.

Routines in this series are:
   HCls, HLine, HMode, HPrint, HSetPixel, HTestPixel

   HCls Colour%

Colour%    color (0-1)

Name  : Heads%               (Heads)
Class : Disk
Level : DOS 3.3+

This function returns the number of heads for a given disk
drive. If the drive does not exist or is not a physical drive,
-1 will be returned.

You may use "" to denote the current drive.

   Hds% = Heads% (Drive$)

Drive$    drive for which to return cylinders
-------
Heads%    number of drive heads (-1 if error)

Name  : HiByte%              (High Byte)
Class : Numeric
Level : Any

This function returns the high byte of an integer.

   Byte% = HiByte%(Nr%)

Nr%        integer
-------
Byte%      value of the most significant byte

Name  : HiLite               (Highlight)
Class : Display
Level : Clone

This routine allows you to highlight text on the screen. It
works in text modes only and always displays to the visible
screen page.

See also ReColorArea, which lets you highlight any rectangular
area of the screen.

   HiLite Row%, LCol%, RCol%, VAttr%

Row%       row on which to highlight
LCol%      left column (where highlight starts)
RCol%      right column (where highlight ends)
VAttr%     new color (see CalcAttr)

Name  : HiWord%              (High Word)
Class : Numeric
Level : Any

This function returns the high word of a long integer.

   Word% = HiWord%(Nr&)

Nr&        long integer
-------
Word%      value of the most significant word

Name  : HLine                (Hercules LINE)
Class : Display
Level : Clone

This routine draws a line on a Hercules graphics screen.

Routines in this series are:
   HCls, HLine, HMode, HPrint, HSetPixel, HTestPixel

   HLine X1%, Y1%, X2%, Y2%, Colour%

X1%        starting graphics column (0-719)
Y1%        starting graphics row (0-347)
X2%        ending graphics column (0-719)
Y2%        ending graphics row (0-347)
Colour%    color (0-1)

Name  : HMode                (Hercules Mode)
Class : Display
Level : Clone

This routine switches between text mode and Hercules graphics
mode. Use HInit first to initialize the graphics mode
appropriately.

HMode will clear page 0 when graphics mode is entered. Page 1,
if it exists, is not cleared. PBClone does not support page 1 in
any respect.

Routines in this series are:
   HCls, HLine, HMode, HPrint, HSetPixel, HTestPixel

   HMode Graphics%

Graphics%    display mode to set (0 text, else graphics)

Name  : HPrint               (Hercules Print)
Class : Display
Level : Clone

This routine displays text in Hercules graphics mode. It uses
the full resolution of the screen, so text is 90 columns by 43
rows. This gives you more space than even the largest EGA text
mode, which is only 80x43.

Routines in this series are:
   HCls, HLine, HMode, HPrint, HSetPixel, HTestPixel

   HPrint St$, Row%, Column%

St$        text to display
Row%       row (1-43)
Column%    column (1-90)

Name  : HSetPixel            (Hercules Set Pixel)
Class : Display
Level : Clone

This routine draws a dot on a Hercules graphics screen.

Routines in this series are:
   HCls, HLine, HMode, HPrint, HSetPixel, HTestPixel

   HSetPixel X%, Y%, Colour%

X%         graphics column (0-719)
Y%         graphics row (0-347)
Colour%    color (0-1)

Name  : HTestPixel           (Hercules Test Pixel)
Class : Display
Level : Clone

This routine returns the color of a dot on a Hercules graphics
screen.

Routines in this series are:
   HCls, HLine, HMode, HPrint, HSetPixel, HTestPixel

   Colour% = HTestPixel%(X%, Y%)

X%         graphics column (0-719)
Y%         graphics row (0-347)
-------
Colour%    color (0-1)

Name  : IdentifyFile         (Identify File)
Class : Disk
Level : DOS

Given a file name, this routine attempts to identify what kind
of file it is. Most information is derived from the file
extension, but some files are processed more deeply. For
instance, a file named "UNKNOWN.BAS" will be checked to see if
it is source code (tokenized GWBASIC format, tokenized
QuickBASIC format, or plain ASCII text) or a binary BSAVE/BLOAD
image (which is further categorized as to whether it is a screen
image, and if so, for what kind of display).

   Descript$ = SPACE$(80)
   IdentifyFile FileName$, Descript$, DescrLen%
   Descript$ = LEFT$(Descript$, DescrLen%)

FileName$    name of the file to identify
-------
Descript$    description of the file (init to at least 80 chars)
DescrLen%    length of the description

Name  : InitPtr              (Initialize Pointers)
Class : Array management
Level : Any

This routine initializes an array of pointers for use with the
pointer sort routines (PSortD, et al). It may also be useful for
other purposes. Each element of the array is set equal to its
index (the first element is set to 1, the second to 2, and so
forth). Arrays are expected to begin at element 1. You may
specify the last element to initialize, allowing you to use only
part of an array.

   InitPtr Ptr%(), Elements%

Ptr%()      array to initialize
Elements%   number of elements to initialize
-------
Ptr%()      initialized array

Name  : InsChr               (Insert Character)
Class : Display
Level : Clone

The InsChr routine inserts a space at the specified screen
location.

   InsChr Row%, Column%

Row%      row of character
Column%   column of character

Name  : InsLine              (Insert Line)
Class : Display
Level : BIOS

This routine inserts a blank line at the specified row of the
screen.

   InsLine Row%, VAttr%

Row%      row to insert
VAttr%    color/attribute to use on new row (see CalcAttr)

Name  : Int2Date             (Integer to Date)
Class : Time
Level : Any

This routine undoes the results of the Date2Int routine. It
expands a single integer into month, day, and year values.

The storage format is identical to that used by DOS for file
dates, by the way, so this routine makes an apt companion for
LoadDirAll.


See also Int2DateSt$, a version of this routine which returns a
string instead of numbers.


   Int2Date MonthNr%, DayNr%, YearNr%, IntDate%

IntDate%     date compressed into an integer
-------
MonthNr%     month number (1-12)
DayNr%       day (1-31)
YearNr%      year (1980-2079; see above for two-digit years)

Name  : Int2DateSt$          (Integer to Date String)
Class : Time
Level : Any

This routine undoes the results of the Date2Int routine. It
expands a single integer into a date string with the format
MM-DD-YYYY.

The storage format is identical to that used by DOS for file
dates, by the way, so this routine makes an apt companion for
LoadDirAll.

See also Int2Date, a version of this routine which returns
month, day, and year numbers instead of a string.


   DateSt$ = Int2DateSt$(IntDate%)

IntDate%     date compressed into an integer
-------
DateSt$      uncompressed date in MM-DD-YYYY format.

Name  : Int2Time             (Integer to Time)
Class : Time
Level : Any

This routine undoes the results of the Time2Int routine. It
expands a single integer into hour, minute, and second values.

Note that the seconds will always be even, due to the storage
format. The storage format is identical to that used by DOS for
file times, by the way, so this routine makes an apt companion
for LoadDirAll.

See also Int2TimeSt$, a version of this routine which returns a
string instead of numbers.

   Int2Time HourNr%, MinuteNr%, SecondNr%, IntTime%

IntTime%     time compressed into an integer
-------
HourNr%      hour (0-23)
MinuteNr%    minute
SecondNr%    second

Name  : Int2TimeSt$          (Integer to Time String)
Class : Time
Level : Any

This routine undoes the results of the Time2Int routine. It
expands a single integer into hour, minute, and second values.

Note that the seconds will always be even, due to the storage
format. The storage format is identical to that used by DOS for
file times, by the way, so this routine makes an apt companion
for LoadDirAll.

See also Int2Time, a version of this routine which returns hour,
minute, and second numbers instead of a string.

   TimeSt$ = Int2TimeSt$(IntTime%)

IntTime%     time compressed into an integer
-------
TimeSt$      uncompressed time in HH:MM:SS format

Name  : IntVector            (Interrupt Vector)
Class : Miscellaneous
Level : DOS

The IntVector routine retrieves the address of a specified
interrupt handler. If there is no interrupt handler, the results
will normally be zero, although early DOS versions did not
always have the sense to initialize unused vectors that way.

   IntVector DSeg%, DOfs%, Interrupt%

Interrupt%   interrupt number to examine
-------
DSeg%        segment of the interrupt handler
DOfs%        offset of the interrupt handler

Name  : IRead                (Integer Read)
Class : Disk
Level : DOS

This routine reads an integer (two binary bytes) from a file.
For some applications, you might prefer LIRead, which reads an
integer from a file into a zero-extended long integer-- which
essentially provides support for unsigned integers (0-65535).

The file must have been opened using FCreate or FOpen1.

   IRead Handle%, Value%, ErrCode%

Handle%    file handle
-------
Value%     integer read from file
ErrCode%   DOS error code (0 if no error)

Name  : IsAlNum%             (Is Alphanumeric?)
Class : String
Level : Any

This function returns whether a character is alphabetic or
numeric.

Functions in this family include:
   IsAlNum, IsAlpha, IsASCII, IsCntrl, IsDigit, IsLower,
   IsPrint, IsPunct, IsSpace, IsUpper, IsXDigit

   IsIt% = IsAlNum%(Ch$)

Ch$       character to check
-------
IsIt%     -1 if the character is alphabetic or numeric

Name  : IsAlpha%             (Is Alphabetic?)
Class : String
Level : Any

This function returns whether a character is alphabetic.

Functions in this family include:
   IsAlNum, IsAlpha, IsASCII, IsCntrl, IsDigit, IsLower,
   IsPrint, IsPunct, IsSpace, IsUpper, IsXDigit

   IsIt% = IsAlpha%(Ch$)

Ch$       character to check
-------
IsIt%     -1 if the character is alphabetic

Name  : IsASCII%             (Is ASCII?)
Class : String
Level : Any

This function returns whether a character is ASCII. This is true
if the character ranges from CHR$(0)-CHR$(127).

Functions in this family include:
   IsAlNum, IsAlpha, IsASCII, IsCntrl, IsDigit, IsLower,
   IsPrint, IsPunct, IsSpace, IsUpper, IsXDigit

   IsIt% = IsASCII%(Ch$)

Ch$       character to check
-------
IsIt%     -1 if the character is ASCII

Name  : IsCntrl%             (Is Control?)
Class : String
Level : Any

This function returns whether a character is a control code.
This is true for CHR$(0)-CHR$(32) and CHR$(127).

Functions in this family include:
   IsAlNum, IsAlpha, IsASCII, IsCntrl, IsDigit, IsLower,
   IsPrint, IsPunct, IsSpace, IsUpper, IsXDigit

   IsIt% = IsCntrl%(Ch$)

Ch$       character to check
-------
IsIt%     -1 if the character is a control code

Name  : IsDigit%             (Is Digit?)
Class : String
Level : Any

This function returns whether a character is numeric.

Functions in this family include:
   IsAlNum, IsAlpha, IsASCII, IsCntrl, IsDigit, IsLower,
   IsPrint, IsPunct, IsSpace, IsUpper, IsXDigit

   IsIt% = IsDigit%(Ch$)

Ch$       character to check
-------
IsIt%     -1 if the character is a digit

Name  : IsLower%             (Is Lowercase?)
Class : String
Level : Any

This function returns whether a character is a lowercase letter.

Functions in this family include:
   IsAlNum, IsAlpha, IsASCII, IsCntrl, IsDigit, IsLower,
   IsPrint, IsPunct, IsSpace, IsUpper, IsXDigit

   IsIt% = IsLower%(Ch$)

Ch$       character to check
-------
IsIt%     -1 if the character is a lowercase letter

Name  : IsPrint%             (Is Printable?)
Class : String
Level : Any

This function returns whether a character is printable. This is
true for CHR$(32)-CHR$(126).

Functions in this family include:
   IsAlNum, IsAlpha, IsASCII, IsCntrl, IsDigit, IsLower,
   IsPrint, IsPunct, IsSpace, IsUpper, IsXDigit

   IsIt% = IsPrint%(Ch$)

Ch$       character to check
-------
IsIt%     -1 if the character is printable

Name  : IsPunct%             (Is Punctuation?)
Class : String
Level : Any

This function returns whether a character is punctuation. This
is true for any ASCII character that is not alphabetic, numeric,
or a control code; and for a space.

Functions in this family include:
   IsAlNum, IsAlpha, IsASCII, IsCntrl, IsDigit, IsLower,
   IsPrint, IsPunct, IsSpace, IsUpper, IsXDigit

   IsIt% = IsPunct%(Ch$)

Ch$       character to check
-------
IsIt%     -1 if the character is punctuation

Name  : IsSpace%             (Is Space?)
Class : String
Level : Any

This function returns whether a character is white space. This
includes Space, Carriage Return, Horizontal Tab, Vertical Tab,
LineFeed, and FormFeed characters.

Functions in this family include:
   IsAlNum, IsAlpha, IsASCII, IsCntrl, IsDigit, IsLower,
   IsPrint, IsPunct, IsSpace, IsUpper, IsXDigit

   IsIt% = IsSpace%(Ch$)

Ch$       character to check
-------
IsIt%     -1 if the character is white space

Name  : IStr$                (Integer STR$)
Class : String
Level : Any

This function is identical to the BASIC function STR$, but is
somewhat smaller. It is only for integer values.

If you prefer not to have a leading blank for non-negative
numbers, use the IStrNB$ function instead.

   St$ = IStr$(Number%)

Number%   integer to convert
-------
St$       string form of the number

Name  : IStrNB$              (Integer STR$, No Blank)
Class : String
Level : Any

This function is similar to the BASIC function STR$, but is
somewhat smaller. It is only for integer values. Unlike the STR$
function, this function does not add a leading blank to
non-negative numbers.

If you prefer to have a leading blank for non-negative numbers,
use the IStr$ function instead.

   St$ = IStrNB$(Number%)

Number%   integer to convert
-------
St$       string form of the number

Name  : IsUpper%             (Is Uppercase?)
Class : String
Level : Any

This function returns whether a character is an uppercase
letter.

Functions in this family include:
   IsAlNum, IsAlpha, IsASCII, IsCntrl, IsDigit, IsLower,
   IsPrint, IsPunct, IsSpace, IsUpper, IsXDigit

   IsIt% = IsUpper%(Ch$)

Ch$       character to check
-------
IsIt%     -1 if the character is uppercase

Name  : IsXDigit%            (Is Hex Digit?)
Class : String
Level : Any

This function returns whether a character is a hexadecimal
digit.

Functions in this family include:
   IsAlNum, IsAlpha, IsASCII, IsCntrl, IsDigit, IsLower,
   IsPrint, IsPunct, IsSpace, IsUpper, IsXDigit

   IsIt% = IsXDigit%(Ch$)

Ch$       character to check
-------
IsIt%     -1 if the character is a hex digit

Name  : IVal%                (Integer VAL)
Class : Numeric
Level : Any

This routine is similar to the BASIC function VAL, but is much
faster. If you are not using floating point numbers, this
routine may also decrease the size of your program
significantly, since it won't cause BASIC to pull in its
floating point routines as VAL does.

Unlike VAL, this routine only converts strings to integer
values. It will not handle hex or octal strings. It will not
notify you if there is an overflow error. Finally, although
IVal% will ignore leading blanks, it assumes that a number may
not contain blanks, whereas VAL will ignore blanks in the middle
of a number:

     VAL("  12 34") returns 1234
   IVal%("  12 34") returns 12

Note that, like VAL (but unlike the IVal% function in ProBas),
multiple negation is considered illegal. For example, the result
of IVal%("--1") is zero.

   Number% = IVal%(St$)

St$       string to convert
-------
Number%   integer form of string (0 if there isn't one)

Name  : IWrite               (Integer Write)
Class : Disk
Level : DOS

This routine writes an integer (two binary bytes) to a file.

The file must have been opened using FCreate or FOpen1.

   IWrite Handle%, Value%, ErrCode%

Handle%    file handle
Value%     integer to write to file
-------
ErrCode%   DOS error code (0 if no error)

Name  : JButtonA1%           (Joystick Button A1)
Class : Input
Level : BIOS

This function returns the status of joystick A button 1. The
result will be -1 if the button is pressed, or 0 if not.

If you need information on more than one button, you will find
it substantially faster to use the JButtons routine, which
returns the status of all joystick buttons at once.

Note that this function will not work on the oldest PCs (those
made before 1983 or so).

   Status% = JButtonA1%

-------
Status%      whether joystick A button 1 is pressed (0 no)

Name  : JButtonA2%           (Joystick Button A2)
Class : Input
Level : BIOS

This function returns the status of joystick A button 2. The
result will be -1 if the button is pressed, or 0 if not.

If you need information on more than one button, you will find
it substantially faster to use the JButtons routine, which
returns the status of all joystick buttons at once.

Note that this function will not work on the oldest PCs (those
made before 1983 or so).

   Status% = JButtonA2%

-------
Status%      whether joystick A button 2 is pressed (0 no)

Name  : JButtonB1%           (Joystick Button B1)
Class : Input
Level : BIOS

This function returns the status of joystick B button 1. The
result will be -1 if the button is pressed, or 0 if not.

If you need information on more than one button, you will find
it substantially faster to use the JButtons routine, which
returns the status of all joystick buttons at once.

Note that this function will not work on the oldest PCs (those
made before 1983 or so).

   Status% = JButtonB1%

-------
Status%      whether joystick B button 1 is pressed (0 no)

Name  : JButtonB2%           (Joystick Button B2)
Class : Input
Level : BIOS

This function returns the status of joystick B button 2. The
result will be -1 if the button is pressed, or 0 if not.

If you need information on more than one button, you will find
it substantially faster to use the JButtons routine, which
returns the status of all joystick buttons at once.

Note that this function will not work on the oldest PCs (those
made before 1983 or so).

   Status% = JButtonB2%

-------
Status%      whether joystick B button 2 is pressed (0 no)

Name  : JButtons             (Joystick Buttons)
Class : Input
Level : BIOS

This routine returns the status of all joystick buttons. The
result will be -1 if the button is pressed, or 0 if not.

This routine is ideal if you need to check more than one
joystick button. It is substantially faster than using several
single-button status functions. However, if you only need to
check a single button, or speed is not an issue, you may find it
more convenient to use the functions:
   JButtonA1%, JButtonA2%, JButtonB1%, JButtonB2%

Note that this routine will not work on the oldest PCs (those
made before 1983 or so).

   JButtons A1%, A2%, B1%, B2%

-------
A1%        whether joystick A button 1 is pressed (0 no)
A2%        whether joystick A button 2 is pressed (0 no)
B1%        whether joystick B button 1 is pressed (0 no)
B2%        whether joystick B button 2 is pressed (0 no)

Name  : JPos                 (Joystick Positions)
Class : Input
Level : BIOS

This routine returns the X,Y positions of both joysticks. If
there is only one joystick attached, the results for the second
joystick will usually be meaningless-- except in the case of the
FlightStick, which returns the "throttle" status via the Y
position of an imaginary joystick B.

Note that X represents the horizontal axis and Y the vertical.
I've seen considerable confusion on that topic... I use the
standard mathematical convention here.

The range of values returned depends on the individual joystick
and may drift somewhat. You would be well advised to include a
joystick "calibration" routine in your program to customize your
settings to the particular joystick used. I find a range of
about 5-140 on my FlightStick; your mileage may vary.

Note that this routine will not work on the oldest PCs (those
made before 1983 or so).

   JPos AX%, AY%, BX%, BY%

-------
AX%        X position of joystick A
AY%        Y position of joystick A
BX%        X position of joystick B
BY%        Y position of joystick B (or FlightStick throttle)

Name  : KbdType              (Keyboard Type)
Class : Input / Equipment
Level : Clone

This routine tells you if an enhanced (101-key) keyboard is
available.

If KbdType is not entirely sure that an enhanced keyboard is
available, it plays safe and assumes there isn't one. This
avoids possible disaster on older PCs.

   KbdType Enhanced%

-------
Enhanced%    whether keyboard is of the enhanced type (0 no)

Name  : KbdType2%            (Keyboard Type)
Class : Input / Equipment
Level : Clone

This routine tells you if an enhanced (101-key) keyboard is
available.

If KbdType2% is not entirely sure that an enhanced keyboard is
available, it plays safe and assumes there isn't one. This
avoids possible disaster on older PCs.

   Enhanced% = KbdType2%

-------
Enhanced%    whether keyboard is of the enhanced type (0 no)

Name  : KeyPress             (detect Key Press)
Class : Input
Level : DOS

This routine works like the Turbo/Power BASIC function INSTAT.
It tells you whether there is a key waiting to be processed.

   KeyPress KeyHit%

-------
KeyHit%   whether a key is waiting (0 if no)

Name  : KVal&                (Kilobyte VAL)
Class : Numeric
Level : Any

This routine is similar to the BASIC function VAL, but is much
faster. The number returned is divided by 1024, which is useful
if you're dealing in terms of kilobytes. If you are not using
floating point numbers, this routine may decrease the size of
your program significantly, since it won't cause BASIC to pull
in its floating point routines as VAL does.

Unlike VAL, this routine only converts strings to long integer
values. It will not handle hex or octal strings. It will not
notify you if there is an overflow error. Finally, although
KVal& will ignore leading blanks, it assumes that a number may
not contain blanks, whereas VAL will ignore blanks in the middle
of a number.

Note that, like VAL (but unlike the KVal& function in ProBas),
multiple negation is considered illegal. For example, the result
of KVal&("--10000") is zero.

   Number& = KVal&(St$)

St$       string to convert
-------
Number&   long integer form of string, divided by 1024

Name  : LClickLoc            (Left Click Location)
Class : Mouse
Level : BIOS

This routine returns the position of the mouse cursor at the
last click of the left mouse button. It must be used after one
of the routines which check for mouse clicks, as they maintain
the click position. These routines include GetKey, GetKey3,
MMClick, and MMClick3.

The values returned are in graphics coordinates (virtual
coordinates for SCREEN 0 through SCREEN 2, due to the nature of
the mouse driver).

   LClickLoc X%, Y%

-------
X%         horizontal coordinate at last left click
Y%         vertical coordinate at last left click

Name  : LClose               (L/I/M Close)
Class : Memory
Level : BIOS

This routine closes a block of expanded memory that was opened
for access by LOpen. It is important to close the block when you
are finished with it, to return it to the free memory pool.

Routines in this suite include: LOpen, LGet, LPut, LClose.

   LClose EMSHandle%

EMSHandle%    handle of the expanded memory block

Name  : LGet                 (L/I/M Get)
Class : Memory
Level : BIOS

This routine gets a block of data from expanded memory that was
opened for access by LOpen. The amount of data is specified in
words; one word is the same as two bytes. An integer takes up a
word, long integers and single precision numbers require two
words, and double precision numbers take four.

Routines in this suite include: LOpen, LGet, LPut, LClose.

   LGet EMSHandle%, DSeg%, DOfs%, Words%

EMSHandle%    handle of the expanded memory block
DSeg%         segment of place to store data
DOfs%         offset of place to store data
Words%        words to get from expanded memory

Name  : LIRead               (Long Integer Read)
Class : Disk
Level : DOS

This routine reads an integer from a file into a long integer.
The integer is zero-extended into the long, providing effective
support for unsigned integers (a range of 0-65535).

The file must have been opened using FCreate or FOpen1.

   LIRead Handle%, Value&, ErrCode%

Handle%    file handle
-------
Value&     integer read from file
ErrCode%   DOS error code (0 if no error)

Name  : LIWrite              (Long Integer Write)
Class : Disk
Level : DOS

This routine writes an integer to a file from a long integer.
This makes it easier to support unsigned integers (with a range
of 0-65535).

The file must have been opened using FCreate or FOpen1.

   LIWrite Handle%, Value&, ErrCode%

Handle%    file handle
Value&     integer to write to file
-------
ErrCode%   DOS error code (0 if no error)

Name  : LoadDir              (Load Directory)
Class : Disk
Level : DOS

Given a filespec with wildcards and a file attribute, this
routine loads a list of all matching files into an array. The
array must be of fixed-length string type, with 12 characters
for each filename. You can find out how large to DIM the array
by using the FileCount routine.

The attribute can be any of the usual file attributes:
   1   Read-Only
   2   Hidden
   4   System
  16   Directory

You can combine attributes by adding their values. For instance,
to search for hidden directories, you'd use an attribute of 18.
By default, DOS returns normal files as well as files which have
the specified attributes, so an attribute of 18 would get you
normal files, hidden files, directories, and hidden directories.
However, LoadDir can be made to screen out unwanted files-- just
negate the attribute to force only files of that attribute to be
counted. For example, an attribute of -18 would return only
hidden subdirectories.

NOTE: we use FilAttr%, not FileAttr%, because BASIC has an
internal function named FILEATTR.

   LoadDir FileSpec$, FilAttr%, DSeg%, DOfs%, ErrCode%

FileSpec$    search file specification (may contain wildcards)
FilAttr%     search file attribute
DSeg%        segment of fixed-length-string array (use VARSEG)
DOfs%        offset of fixed-length-string array (use VARPTR)
-------
ErrCode%     error code (0 if no error)

Name  : LoadDirAll           (Load Directory, All info)
Class : Disk
Level : DOS

Given a filespec with wildcards and a file attribute, this
routine loads a list of all matching files into an array. All
available information about the file is included: name, size,
time, date, and attribute. The array must be of the TYPE shown
below. You can find out how large to DIM the array by using the
FileCount routine.

   TYPE DirType
      FilAttr AS STRING * 1
      FilTime AS INTEGER
      FilDate AS INTEGER
      FilSize AS LONG
      FilName AS STRING * 12
   END TYPE

You can change the names if you like, but don't alter the order
of the information. You can decode the file attribute with the
ASC function, then process it with ExplainFAttr$. The file time
and date can be decoded with the Int2Time and Int2Date or
Int2TimeSt$ and Int2DateSt$ routines.

The attribute can be any of the usual file attributes:
   1   Read-Only
   2   Hidden
   4   System
  16   Directory

You can combine attributes by adding their values. For instance,
to search for hidden directories, you'd use an attribute of 18.
By default, DOS returns normal files as well as files which have
the specified attributes, so an attribute of 18 would get you
normal files, hidden files, directories, and hidden directories.
However, LoadDirAll can be made to screen out unwanted files--
just negate the attribute to force only files of that attribute
to be counted. For example, an attribute of -18 would return
only hidden subdirectories.

NOTE: we use FilAttr%, not FileAttr%, because BASIC has an
internal function named FILEATTR.

   LoadDirAll FileSpec$, FilAttr%, DSeg%, DOfs%, ErrCode%

FileSpec$    search file specification (may contain wildcards)
FilAttr%     search file attribute
DSeg%        segment of typed array (use VARSEG)
DOfs%        offset of typed array (use VARPTR)
-------
ErrCode%     error code (0 if no error)

Name  : LoByte%              (Low Byte)
Class : Numeric
Level : Any

This function returns the low byte of an integer.

   Byte% = LoByte%(Nr%)

Nr%        integer
-------
Byte%      value of the least significant byte

Name  : Locase               (Lowercase)
Class : String
Level : Any

This routine, like BASIC's LCASE$ function, converts a string to
lowercase. Since it doesn't have to create a new return string
(a fairly slow process), it's faster than the BASIC equivalent.

See also Locase1.

   Locase St$

St$     string to be put into lowercase
-------
St$     lowercase string

Name  : Locase1              (Lowercase)
Class : String
Level : Any

This routine, like BASIC's LCASE$ function, converts a string to
lowercase. It converts letters in the extended character set as
well as the usual letters, making it well suited for text which
may not be in English.

Note that DOS 5.0 and later versions provide National Language
Support which includes conversion to uppercase (not lowercase,
unfortunately). So, if you merely need the characters in a known
state, rather than lowercase, you would do better to use the
Upcase1 routine. Locase1 assumes the U.S. character set, which
may well not be appropriate.

See also Locase.

   Locase1 St$

St$     string to be put into lowercase
-------
St$     lowercase string

Name  : LogicalDrives%       (Logical Drives)
Class : Disk / Equipment
Level : DOS

This function returns the number of logical drives available.

A logical drive corresponds roughly to a drive letter-- it may
point to zero or more actual devices. For instance, on a
one-floppy system, both A: and B: point to the same drive. On a
partitioned hard drive, both C: and D: may point to different
areas of the same drive. Drive E: may point to a RAMdisk, or
maybe it doesn't point to anything at all.

As you can see, knowing the number of logical drives doesn't
tell you much about what's actually there. However, it does give
you an upper limit on the number of drive letters available,
which is a good place to start.

   Drives% = LogicalDrives%

-------
Drives%    number of logical drives

Name  : LOpen                (L/I/M Open)
Class : Memory
Level : BIOS

This routine opens a block of expanded memory for access. The
size of the block is specified in words; one word is the same as
two bytes. An integer takes up a word, long integers and single
precision numbers require two words, and double precision
numbers take four. This allows you to store up to 64K in each
EMS block that you open.

Note that LOpen expects an EMS driver to be available. If you
are not certain on this point, use GetLIMM beforehand to make
sure.

Routines in this suite include:
   LOpen, LGet, LPut, LClose.

   LOpen Words%, EMSHandle%, ErrCode%

Words%        size of expanded memory block to allocate
-------
EMSHandle%    handle of the expanded memory block
ErrCode%      error code (0 if no error)

Name  : LoWord%              (Low Word)
Class : Numeric
Level : Any

This function returns the low word of a long integer.

   Word% = LoWord%(Nr&)

Nr&        long integer
-------
Word%      value of the least significant word

Name  : LPut                 (L/I/M Put)
Class : Memory
Level : BIOS

This routine puts a block of data into expanded memory that was
opened for access by LOpen. The amount of data is specified in
words; one word is the same as two bytes. An integer takes up a
word, long integers and single precision numbers require two
words, and double precision numbers take four.

Routines in this suite include:
   LOpen, LGet, LPut, LClose.

   LPut EMSHandle%, DSeg%, DOfs%, Words%

EMSHandle%    handle of the expanded memory block
DSeg%         segment of place from which to get data
DOfs%         offset of place from which to get data
Words%        words to put into expanded memory

Name  : LRead                (Long Read)
Class : Disk
Level : DOS

This routine reads a long integer (four binary bytes) from a
file.

The file must have been opened using FCreate or FOpen1.

   LRead Handle%, Value&, ErrCode%

Handle%    file handle
-------
Value&     long integer read from file
ErrCode%   DOS error code (0 if no error)

Name  : LRotate              (Left Rotate string)
Class : String
Level : Any

Many years ago, I wrote one of the first terminal programs for
the PC. It died a horrible death when Qmodem came out... sigh.
This routine comes from that experience. It rotates the
characters in a string left once (e.g., "ABCDE" becomes
"BCDEA"). I used this in my routine to dial a list of BBSes,
skipping to the next one if the current one was busy.

LRotate can also be handy for things like scrolling a long
message across the screen (you just PRINT LEFT$(Message$, 80);
then delay a bit, LRotate and do it again).

See also RRotate.

   LRotate St$

St$     string to be rotated left once
-------
St$     string after being rotated left once

Name  : LScroll              (Left Scroll)
Class : Display
Level : Clone

This routine scrolls any selected part of the display left. You
may scroll as many times as you like, or scroll "zero" times to
totally clear the selected part of the display.

   LScroll TopRow%, LeftCol%, BottomRow%, RightCol%, Times%

TopRow%      top row of the area to scroll
LeftCol%     left column of the area to scroll
BottomRow%   top row of the area to scroll
RightCol%    left column of the area to scroll
Times%       number of times (or rows) to scroll

Name  : LVal&                (Long integer VAL)
Class : Numeric
Level : Any

This routine is similar to the BASIC function VAL, but is much
faster. If you are not using floating point numbers, this
routine may also decrease the size of your program quite a bit,
since it won't cause BASIC to pull in its floating point
routines as VAL does.

Unlike VAL, this routine only converts strings to long integer
values. It will not handle hex or octal strings. It will not
notify you if there is an overflow error. Finally, although
LVal& will ignore leading blanks, it assumes that a number may
not contain blanks, whereas VAL will ignore blanks in the middle
of a number:

     VAL("  12 34") returns 1234
   LVal&("  12 34") returns 12

Note that, like VAL (but unlike the LVal& function in ProBas),
multiple negation is considered illegal. For example, the result
of LVal&("--1") is zero.

   Number& = LVal&(St$)

St$       string to convert
-------
Number&   long integer form of string (0 if there isn't one)

Name  : LWrite               (Long Write)
Class : Disk
Level : DOS

This routine writes a long integer to a file.

The file must have been opened using FCreate or FOpen1.

   LWrite Handle%, Value&, ErrCode%

Handle%    file handle
Value&     long integer to write to file
-------
ErrCode%   DOS error code (0 if no error)

Name  : MakeSub              (Make Subdirectory)
Class : Disk
Level : DOS

Like the DOS MD (or MKDIR) command, this routine creates a new
subdirectory.

   MakeSub SubDir$, ErrCode%

SubDir$    name of new subdirectory
-------
ErrCode%   error code: 0 if none, else DOS Error

Name  : MatchFile            (Match File)
Class : Disk / String
Level : Any

The MatchFile routine tells you whether a given filename matches
a file specification which may contain wildcards. The filename
itself should not contain wildcards. Neither the filename nor
filespec should include drive or subdirectory specifications.

One way of using this is in processing file exclusion lists. The
FindFirstF routine allows you to find files that match a given
filespec; to this, you could add a MatchFile-based routine which
would screen out files that match a different filespec. Such a
routine would allow you to create utilities to do things like
"DIR *.* /EXCEPT=*.BAS".

   MatchFile FileSpec$, FileName$, IsMatch%

FileSpec$   master file pattern (may contain wildcards)
FileName$   name of file to test against the master pattern
-------
IsMatch%    0 if the filename doesn't match the filespec

Name  : MatShuffleD          (Matrix Shuffle Double-prec)
Class : Array
Level : Any

This routine shuffles the elements in a double-precision array,
efficiently randomizing their order. It relies on the RND
function, so you'd be advised to use the RANDOMIZE statement at
the top of your program unless you want the results to be
predictable. A good way of initializing the random number
generator is:

   RANDOMIZE TIMER

You can specify the starting and ending positions in the array
to shuffle, so you don't have to shuffle the entire array.

See also the string shuffle, ShuffleSt, and other array
shuffles: MatShuffleI, MatShuffleL, MatShuffleS, MatShuffleSt

   MatShuffleD Array#(), StartPosn%, EndPosn%

Array#()     array to shuffle
StartPosn%   element at which to begin shuffling
EndPosn%     element at which to stop shuffling
-------
Array#()     shuffled array

Name  : MatShuffleI          (Matrix Shuffle Integer)
Class : Array
Level : Any

This routine shuffles the elements in an integer array,
efficiently randomizing their order. It relies on the RND
function, so you'd be advised to use the RANDOMIZE statement at
the top of your program unless you want the results to be
predictable. A good way of initializing the random number
generator is:

   RANDOMIZE TIMER

You can specify the starting and ending positions in the array
to shuffle, so you don't have to shuffle the entire array.

See also the string shuffle, ShuffleSt, and other array
shuffles: MatShuffleD, MatShuffleL, MatShuffleS, MatShuffleSt

   MatShuffleI Array%(), StartPosn%, EndPosn%

Array%()     array to shuffle
StartPosn%   element at which to begin shuffling
EndPosn%     element at which to stop shuffling
-------
Array%()     shuffled array

Name  : MatShuffleL          (Matrix Shuffle Long integer)
Class : Array
Level : Any

This routine shuffles the elements in a long integer array,
efficiently randomizing their order. It relies on the RND
function, so you'd be advised to use the RANDOMIZE statement at
the top of your program unless you want the results to be
predictable. A good way of initializing the random number
generator is:

   RANDOMIZE TIMER

You can specify the starting and ending positions in the array
to shuffle, so you don't have to shuffle the entire array.

See also the string shuffle, ShuffleSt, and other array
shuffles: MatShuffleD, MatShuffleI, MatShuffleS, MatShuffleSt

   MatShuffleL Array&(), StartPosn%, EndPosn%

Array&()     array to shuffle
StartPosn%   element at which to begin shuffling
EndPosn%     element at which to stop shuffling
-------
Array&()     shuffled array

Name  : MatShuffleS          (Matrix Shuffle Single-prec)
Class : Array
Level : Any

This routine shuffles the elements in a single-precision array,
efficiently randomizing their order. It relies on the RND
function, so you'd be advised to use the RANDOMIZE statement at
the top of your program unless you want the results to be
predictable. A good way of initializing the random number
generator is:

   RANDOMIZE TIMER

You can specify the starting and ending positions in the array
to shuffle, so you don't have to shuffle the entire array.

See also the string shuffle, ShuffleSt, and other array
shuffles: MatShuffleD, MatShuffleI, MatShuffleL, MatShuffleSt

   MatShuffleS Array!(), StartPosn%, EndPosn%

Array!()     array to shuffle
StartPosn%   element at which to begin shuffling
EndPosn%     element at which to stop shuffling
-------
Array!()     shuffled array

Name  : MatShuffleSt         (Matrix Shuffle String)
Class : Array
Level : Any

This routine shuffles the elements in a string array,
efficiently randomizing their order. It relies on the RND
function, so you'd be advised to use the RANDOMIZE statement at
the top of your program unless you want the results to be
predictable. A good way of initializing the random number
generator is:

   RANDOMIZE TIMER

You can specify the starting and ending positions in the array
to shuffle, so you don't have to shuffle the entire array.

See also the string shuffle, ShuffleSt, and other array
shuffles: MatShuffleD, MatShuffleI, MatShuffleL, MatShuffleS

   MatShuffleSt Array$(), StartPosn%, EndPosn%

Array$()     array to shuffle
StartPosn%   element at which to begin shuffling
EndPosn%     element at which to stop shuffling
-------
Array$()     shuffled array

Name  : Max%                 (Maximum)
Class : Numeric
Level : Any

This function returns the larger of two integers. It can be
handy in sorting routines or for keeping a value within a
desired range.

   Larger% = Max%(First%, Second%)

First%     one integer
Second%    another integer
-------
Larger%    larger of the two integers

Name  : MaxD#                (Maximum Double precision)
Class : Numeric
Level : Any

This function returns the larger of two double-precision
numbers. It can be handy in sorting routines or for keeping a
value within a desired range.

   Larger# = MaxD#(First#, Second#)

First#     one number
Second#    another number
-------
Larger#    larger of the two numbers

Name  : MaxL&                (Maximum Long integer)
Class : Numeric
Level : Any

This function returns the larger of two long integers. It can be
handy in sorting routines or for keeping a value within a
desired range.

   Larger& = MaxL&(First&, Second&)

First&     one long integer
Second&    another long integer
-------
Larger&    larger of the two long integers

Name  : MaxS!                (Maximum Single precision)
Class : Numeric
Level : Any

This function returns the larger of two single-precision
numbers. It can be handy in sorting routines or for keeping a
value within a desired range.

   Larger! = MaxS!(First!, Second!)

First!     one number
Second!    another number
-------
Larger!    larger of the two numbers

Name  : MClickLoc            (Middle Click Location)
Class : Mouse
Level : BIOS

This routine returns the position of the mouse cursor at the
last click of the middle mouse button. It must be used after one
of the routines which check for mouse clicks, as they maintain
the click position. These routines include GetKey3 and MMClick3.

The values returned are in graphics coordinates (virtual
coordinates for SCREEN 0 through SCREEN 2, due to the nature of
the mouse driver).

   MClickLoc X%, Y%

-------
X%         horizontal coordinate at last middle click
Y%         vertical coordinate at last middle click

Name  : MeanAverageD         (Mean Average Double precision)
Class : Array management
Level : Any

This routine averages the specified range of elements in an
array of double precision numbers. The form of averaging used is
called the "mean", which is the sum of all of the elements
divided by the number of elements involved. This is the most
common method of averaging a list of numbers.

   MeanAverageD Array#(), First%, Last%, Average#, ErrCode%

Array#()    array to be averaged
First%      array element to start with
Last%       array element to end with
-------
Average#    average value of the specified elements
ErrCode%    0 if there was no error

Name  : MeanAverageI         (Mean Average Integer)
Class : Array management
Level : Any

This routine averages the specified range of elements in an
array of integer numbers. The form of averaging used is called
the "mean", which is the sum of all of the elements divided by
the number of elements involved. This is the most common method
of averaging a list of numbers.

   MeanAverageI Array%(), First%, Last%, Average%, ErrCode%

Array()     array to be averaged
First%      array element to start with
Last%       array element to end with
-------
Average%    average value of the specified elements
ErrCode%    0 if there was no error

Name  : MeanAverageL         (Mean Average Long integer)
Class : Array management
Level : Any

This routine averages the specified range of elements in an
array of long integer numbers. The form of averaging used is
called the "mean", which is the sum of all of the elements
divided by the number of elements involved. This is the most
common method of averaging a list of numbers.

   MeanAverageL Array&(), First%, Last%, Average&, ErrCode%

Array&()    array to be averaged
First%      array element to start with
Last%       array element to end with
-------
Average&    average value of the specified elements
ErrCode%    0 if there was no error

Name  : MeanAverageS         (Mean Average Single precision)
Class : Array management
Level : Any

This routine averages the specified range of elements in an
array of single precision numbers. The form of averaging used is
called the "mean", which is the sum of all of the elements
divided by the number of elements involved. This is the most
common method of averaging a list of numbers.

   MeanAverageS Array!(), First%, Last%, Average!, ErrCode%

Array!()    array to be averaged
First%      array element to start with
Last%       array element to end with
-------
Average!    average value of the specified elements
ErrCode%    0 if no error

Name  : MemSwap              (Memory Swap)
Class : Memory
Level : Any

MemSwap swaps the contents of one area of memory with another.
This can be used for a variety of things, from swapping a saved
screen with the actual screen to exchanging the contents of two
arrays.

   MemSwap DSeg1%, DOfs1%, DSeg2%, DOfs2%, Bytes%

DSeg1%     segment of first memory area
DOfs1%     offset of first memory area
DSeg2%     segment of second memory area
DOfs2%     offset of second memory area
Bytes%     bytes to swap

Name  : Min%                 (Minimum)
Class : Numeric
Level : Any

This function returns the smaller of two integers. It can be
handy in sorting routines or for keeping a value within a
desired range.

   Smaller% = Min%(First%, Second%)

First%     one integer
Second%    another integer
-------
Smaller%   smaller of the two integers

Name  : MinD#                (Minimum Double precision)
Class : Numeric
Level : Any

This function returns the smaller of two double-precision
numbers. It can be handy in sorting routines or for keeping a
value within a desired range.

   Smaller# = MinD#(First#, Second#)

First#     one number
Second#    another number
-------
Smaller#   smaller of the two numbers

Name  : MinL&                (Minimum Long integer)
Class : Numeric
Level : Any

This function returns the smaller of two long integers. It can
be handy in sorting routines or for keeping a value within a
desired range.

   Smaller& = MinL&(First&, Second&)

First&     one long integer
Second&    another long integer
-------
Smaller&   smaller of the two long integers

Name  : MinS!                (Minimum Single precision)
Class : Numeric
Level : Any

This function returns the smaller of two single-precision
numbers. It can be handy in sorting routines or for keeping a
value within a desired range.

   Smaller! = MinS!(First!, Second!)

First!     one number
Second!    another number
-------
Smaller!   smaller of the two numbers

Name  : MMButton             (Mouse Button)
Class : Mouse
Level : BIOS

The MMButton routine allows you to find out which mouse buttons
are pressed. Although it will work with any mouse, it is
designed specifically for a mouse with two buttons (see also
MMButton3). If you want to find out which buttons were pressed
in the past, rather than being pressed now, try MMClick instead.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

   MMButton LeftB%, RightB%

-------
LeftB%     whether the left button is pressed
RightB%    whether the right button is pressed

Name  : MMButton3            (Mouse Button for 3-button mouse)
Class : Mouse
Level : BIOS

The MMButton3 routine allows you to find out which mouse buttons
are pressed. Although it will work with any mouse, it is
designed specifically for a mouse with three buttons (see also
MMButton). If you want to find out which buttons were pressed in
the past, rather than being pressed now, try MMClick3 instead.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

   MMButton3 LeftB%, MiddleB%, RightB%

-------
LeftB%     whether the left button is pressed
MiddleB%   whether the middle button is pressed
RightB%    whether the right button is pressed

Name  : MMCheck              (Mouse Check and initialize)
Class : Mouse
Level : BIOS

This routine does a number of things. Primarily, it is intended
to let you check to see if a mouse is available. It returns a
zero if there is no mouse; if there is a mouse, the number of
mouse buttons is returned. The mouse status is also initialized,
so this is best used once at the beginning of your program.

All of the other mouse routines assume that a mouse is
available, so you should definitely use MMCheck if you're not
sure. Otherwise, results will be unusual at best, and the
computer may even lock up under some DOS versions.

There is also a function version of this routine, MMCheck2%.

   MMCheck Buttons%

-------
Buttons%   number of mouse buttons (0 if no mouse is installed)

Name  : MMCheck2%            (Mouse Check and initialize)
Class : Mouse
Level : BIOS

This function does a number of things. Primarily, it is intended
to let you check to see if a mouse is available. It returns a
zero if there is no mouse; if there is a mouse, the number of
mouse buttons is returned. The mouse status is also initialized,
so this is best used once at the beginning of your program.

All of the other mouse routines assume that a mouse is
available, so you should definitely use MMCheck2% if you're not
sure. Otherwise, results will be unusual at best, and the
computer may even lock up under some DOS versions.

There is also a sub version of this routine, MMCheck.

   Buttons% = MMCheck2%

-------
Buttons%   number of mouse buttons (0 if no mouse is installed)

Name  : MMClick              (Mouse Click)
Class : Mouse
Level : BIOS

The MMClick routine allows you to find out which mouse buttons
have been pressed since you last checked, and how many times
they were pressed. Although it will work with any mouse, it is
designed specifically for a mouse with two buttons (see also
MMClick3). If you want to find out which buttons are currently
being pressed, try MMButton instead.

See also the LClickLoc and RClickLoc routines, which allow you
to determine what the mouse position was at the last click.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

   MMClick LeftB%, RightB%

-------
LeftB%     # of times left button was pressed since last check
RightB%    # of times right button was pressed since last check

Name  : MMClick3             (Mouse Click for 3-button mouse)
Class : Mouse
Level : BIOS

The MMClick3 routine allows you to find out which mouse buttons
have been pressed since you last checked, and how many times
they were pressed. Although it will work with any mouse, it is
designed specifically for a mouse with three buttons (see also
MMClick). If you want to find out which buttons are currently
being pressed, try MMButton3 instead.

See also the LClickLoc, MClickLoc and RClickLoc routines, which
allow you to determine what the mouse position was at the last
click.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

   MMClick3 LeftB%, MiddleB%, RightB%

-------
LeftB%     # of times left button was pressed since last check
MiddleB%   # of times middle button was pressed since last look
RightB%    # of times right button was pressed since last check

Name  : MMCursorOff          (Mouse Cursor Off)
Class : Mouse
Level : BIOS

This routine makes the mouse cursor invisible. The mouse cursor
will still function as a location indicator, in the same way
that the normal cursor still functions when you make it
invisible.

Note that the mouse cursor is somewhat bizarre in that an
"invisibility level" is kept. Every time you use MMCursorOff,
the invisibility depth is increased; subsequent attempts to make
the cursor visible will not actually do so until the
invisibility depth reaches zero. In other words, if you call
MMCursorOff when the cursor is already invisible, the cursor
will not reappear until you've told it to reappear as many times
as you told it to disappear. This is fairly demented, but that's
the way Microsoft made it.

This routine will not work properly if no mouse is installed.
See MMCheck.

   MMCursorOff

Name  : MMCursorOn           (Mouse Cursor On)
Class : Mouse
Level : BIOS

This routine makes the mouse cursor visible, or tries to do
so...

The mouse cursor is somewhat bizarre in that an "invisibility
level" is kept. Every time you use MMCursorOff, the invisibility
depth is increased; subsequent attempts to make the cursor
visible will not actually do so until the invisibility depth
reaches zero. In other words, if you call MMCursorOff when the
cursor is already invisible, the cursor will not reappear until
you've told it to reappear (with MMCursorOn) as many times as
you told it to disappear. This is fairly demented, but that's
the way Microsoft made it.

Note that there is a flaw in BASIC such that a "mouse dropping"
may be left on the screen if your program is invoked at the
bottom of the DOS screen, causing a scroll while the mouse
cursor is visible. To avoid this, use VIEW PRINT at the
beginning of your program to remove the default "status line".
For the standard 80x25 text screen, this would be done like so:

   VIEW PRINT 1 TO 25

This routine will not work properly if no mouse is installed.
See MMCheck or MMCheck2%.

   MMCursorOn

Name  : MMGetLoc             (Mouse Get Location)
Class : Mouse
Level : BIOS

This routine allows you to get the current location of the mouse
cursor. It doesn't matter if the cursor is visible or invisible.

The mouse cursor location is somewhat perverse in CGA and text
modes, due to the sloppy design of Microsoft's original mouse
driver. In text modes and both CGA graphics modes, the cursor is
returned as if the screen is 640x200. To correct this for SCREEN
1, divide the X coordinate by two. To correct this for text
modes, divide each coordinate by eight.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

See also GetMouseLoc, which returns the appropriate coordinates
for text mode.

   MMGetLoc X%, Y%

-------
X%         X coordinate ("column")
Y%         Y coordinate ("row")

Name  : MMSetLoc             (Mouse Set Location)
Class : Mouse
Level : BIOS

This routine allows you to set the current location of the mouse
cursor. It doesn't matter if the cursor is visible or invisible.

The mouse cursor location is somewhat perverse in CGA and text
modes, due to the sloppy design of Microsoft's original mouse
driver. In text modes and both CGA graphics modes, the cursor is
returned as if the screen is 640x200. To correct this for SCREEN
1, double the X coordinate. To correct this for text modes,
multiply each coordinate by eight and add four.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

See also SetMouseLoc, which does the coordinate conversions for
you in text mode.

   MMSetLoc X%, Y%

X%         X coordinate ("column")
Y%         Y coordinate ("row")

Name  : MMSetRange           (Mouse Set Range)
Class : Mouse
Level : BIOS

This routine allows you to set the allowable range of mouse
cursor locations. The mouse cursor will not be permitted to go
outside this range. It doesn't matter if the cursor is visible
or invisible.

The mouse cursor location is somewhat perverse in CGA and text
modes, due to the sloppy design of Microsoft's original mouse
driver. In text modes and both CGA graphics modes, the cursor is
returned as if the screen is 640x200. To correct this for SCREEN
1, double the X coordinate. To correct this for text modes,
multiply each coordinate by eight and add four.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

   MMSetRange X1%, Y1%, X2%, Y2%

X1%       left   X coordinate (upper left "column")
Y1%       top    Y coordinate (upper left "row")
X2%       right  X coordinate (lower right "column")
Y2%       bottom Y coordinate (lower right "row")

Name  : Month0               (Month)
Class : String / Time
Level : Any

Given a month number, this routine tells you the name of the
month.

   MonthName$ = SPACE$(9)
   Month0 MonthName$, NameLen%, MonthNr%
   MonthName$ = LEFT$(MonthName$, NameLen)

MonthNr%    month number (1-12)
-------
MonthName$  name of the month.  Init to at least 9 characters.
NameLen%    length of the month name

Name  : MouseBuffer          (Mouse Buffer size)
Class : Mouse
Level : BIOS

This routine is used before MouseSave in order to find out how
many bytes are needed to save the mouse state.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

   MouseBuffer Bytes%
   St$ = SPACE$(Bytes%)
   MouseSave St$

-------
Bytes%     number of bytes needed to save the state of the mouse

Name  : MouseCursor          (Mouse Cursor type)
Class : Mouse
Level : BIOS

The MouseCursor routine allows you to select one of a number of
graphics mouse cursors. The following types are supported:

    0   hourglass ("please wait" symbol)
    1   standard arrow pointer
    2   pointing hand
    3   crosshair
    4   target (box-in-a-box pointer)
    5   grabbing hand

If you'd like other shapes, please suggest a few! I'll be glad
to add them.

   MouseCursor CursorNr%

CursorNr%    type of mouse graphics cursor to use (see above)

Name  : MousePen             (Mouse light Pen emulation)
Class : Mouse
Level : BIOS

The mouse can be made to emulate a light pen, allowing you to
use BASIC's light pen routines to provide a certain minimal
level of support for both light pens and mice. This emulation is
on by default, but you can turn it off in case there is an
actual light pen attached.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

   MousePen EmulatePen%

EmulatePen%   whether mouse should emulate light pen (0 no)

Name  : MouseRest            (Mouse status Restore)
Class : Mouse
Level : BIOS

This routine is for use in conjunction with MouseSave. It allows
you to restore the mouse settings to a state that was saved in
the past.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

   MouseRest St$

St$        mouse state to restore

Name  : MouseSave            (Mouse status Save)
Class : Mouse
Level : BIOS

This one is handy for use in subprograms or when SHELLing to
other programs that may use the mouse. It allows you to save the
current mouse settings as a string. To find out how long the
string should be, use MouseBuffer.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

   MouseBuffer Bytes%
   St$ = SPACE$(Bytes%)
   MouseSave St$

-------
St$        saved mouse state.  Init as shown above.

Name  : MPrint               (MS-DOS Print)
Class : Display
Level : BIOS

The MPrint routine displays text using mostly DOS services. This
allows it to handle ANSI codes if an ANSI driver is installed.
In addition, the output of MPrint is confined to a region of the
screen that you may select with MWindow. By default, the region
is 1,1 to 25,80: a full 80x25 text screen.

Using MPrint is similar to using PRINT followed by a semicolon.
It does not automatically move to the next line. To do so, you
must MPrint a carriage return and linefeed: CHR$(13) + CHR$(10).

To clear the MWindow region, MPrint a formfeed: CHR$(12).

   MPrint St$

St$         string to display

Name  : MulMatI              (Multiply Matrix by Integer)
Class : Array management
Level : Any

This routine multiplies as many elements of an integer array as
you like by a given number, starting at a specified place in the
array. If there was a numeric overflow at any point in the
operation, an error code will be returned.

   MulMatI DSeg%, DOfs%, Elements%, Value%, ErrCode%

DSeg%      segment of the array element to start at
DOfs%      offset of the array element to start at
Elements%  number of array elements to process
Value%     value to multiply each array element by
-------
ErrCode%   error code: 0 if no error

Name  : MultiAND             (Multiple AND)
Class : String
Level : Any

The MultiAND routine performs an arithmetic "AND" operation on
each character in a string.

Among the varied uses for MultiAND is stripping the high bit
from characters, as you might want to do in telecommunications
or in converting WordStar files. In that case, you would use a
BitMask% of 127.

   MultiAND St$, BitMask%

St$        string to process
BitMask%   bit mask (0-255) with which to AND each character
-------
St$        processed string

Name  : MultiOR              (Multiple OR)
Class : String
Level : Any

The MultiOR routine performs an arithmetic "OR" operation on
each character in a string.

   MultiOR St$, BitMask%

St$        string to process
BitMask%   bit mask (0-255) with which to OR each character
-------
St$        processed string

Name  : MultiXOR             (Multiple XOR)
Class : String
Level : Any

The MultiXOR routine performs an arithmetic "XOR" operation on
each character in a string.

   MultiXOR St$, BitMask%

St$        string to process
BitMask%   bit mask (0-255) with which to XOR each character
-------
St$        processed string

Name  : MWindow              (MS-DOS Window)
Class : Display
Level : Any

The MWindow routine works in conjunction with MPrint. It defines
an area of the screen in which text displayed by MPrint must
stay. The default window is 1,1 to 25,80.

   MWindow TopRow%, LeftCol%, BottomRow%, RightCol%

TopRow%     top row
LeftCol%    left column
BottomRow%  bottom row
RightCol%   right column

Name  : NameCase             (Name Case)
Class : String
Level : Any

This routine provides a specialized uppercase/lowercase
converter designed especially for names. It converts the first
letter in each word in a string to uppercase, with the rest of
the word being converted to lowercase.

See also NameCase2, the FUNCTION version of this routine.

   NameCase St$

St$         string to process
-------
St$         processed string

Name  : NameCase2$           (Name Case)
Class : String
Level : Any

This routine provides a specialized uppercase/lowercase
converter designed especially for names. It converts the first
letter in each word in a string to uppercase, with the rest of
the word being converted to lowercase.

See also NameCase, the SUB version of this routine.

   Result$ = NameCase2$(St$)

St$         string to process
-------
Result$     processed string

Name  : Num2Phone$           (compressed phone# to string)
Class : Numeric String
Level : Any

This function takes a phone number (as encoded by Phone2Num&)
and converts it to unformatted string form. Depending on the
original number, the result may be 4, 7, or 10 characters in
length. An invalid code will result in a null string.

NOTE that this function will handle current US-style phone
numbers. It expects the first three digits of a 10-digit phone
number to represent an area code, where the middle digit of the
area code is always either zero or one. This convention is
expected to change as of 1994 or so, whereupon this function
will no longer be reliable <sigh>.

   Result$ = Num2Phone$(PhoneNumber&)

PhoneNumber&    encoded phone number
-------
Result$         phone number ("" if invalid number)

Name  : NumFormat            (Number Format)
Class : Numeric
Level : DOS

This works just like PRINT USING, but returns the results in a
string rather than sending them to the display or a file.

Note that an interaction between QuickBASIC, DOS and some
networks means that this routine will briefly access the default
drive. Strange but true.

   NumFormat Format$, Number#, Result$

Format$     numeric format
Number#     number to format
-------
Result$     formatted number

Name  : NumProc              (Numeric Processor)
Class : Equipment
Level : Any

NumProc returns the type of numeric coprocessor installed. I
haven't tried it with a 80486, but I would guess an 80486 always
appears to have an 80387 (unless it's one of those brain-damaged
80486SX chips).

Results are returned as follows:

   0    no math chip
   1    8087
   2    80287
   3    80387

If anyone can tell me how to better handle a 486 here, I'd
appreciate it.

   NumProc ProcType%

-------
ProcType%    type of numeric coprocessor (see above)

Name  : NumProc2%            (Numeric Processor)
Class : Equipment
Level : Any

NumProc2% returns the type of numeric coprocessor installed. I
haven't tried it with a 80486, but I would guess an 80486 always
appears to have an 80387 (unless it's one of those brain-damaged
80486SX chips).


Results are returned as follows:

   0    no math chip
   1    8087
   2    80287
   3    80387

If anyone can tell me how to better handle a 486 here, I'd
appreciate it.

   ProcType% = NumProc2%

-------
ProcType%    type of numeric coprocessor (see above)

Name  : ObjScan              (Object file Scan)
Class : Disk
Level : DOS

This routine returns information about a specified .OBJ file. It
returns the module name, public names, and external names. The
module name is generally the name of the original file which was
compiled to produce the .OBJ file. Public names are the names of
routines (and sometimes variables) that can be accessed by
outside programs. External names are the names of routines (and
variables) that the .OBJ file expects to be provided by outside
programs.

External names containing "$", starting with "_" or with
lowercase characters are screened out to avoid returning a huge
list of BASIC internal routines. For the same reason, routines
ending with "QQ" will also be screened out, as will
STRINGADDRESS, STRINGASSIGN, STRINGLENGTH, and STRINGRELEASE.
Y'know, it would be nice if Microsoft followed some sort of
standard for its names.

The public and external names are returned in string arrays.
ObjScan will fail with an error code if there is insufficient
space, so be sure to allow plenty of room. If scanning
subprograms, a DIM to 30 or 40 elements is probably ample. If
scanning large programs, you may need to increase the dimensions
substantially.

The ObjScan routine can be used as the basis for a simple ".OBJ
info" utility or for more complex applications, such as library
management.

   ObjScan ObjFile$, ModName$, Routine$(), External$(), ErrCode%

ObjFile$      name of .OBJ file
-------
ModName$      module name
Routine$()    public names
External$()   external names
ErrCode%      whether there was an error (0 no)

Name  : Odd%                 (Odd integer?)
Class : Numeric
Level : Any

This function returns whether an integer is odd. If so, it
returns -1, otherwise 0.

   Result% = Odd%(Number%)

Number%    number to test
-------
Result%    whether the number is odd

Name  : OddL%                 (Odd Long integer?)
Class : Numeric
Level : Any

This function returns whether a long integer is odd. If so, it
returns -1, otherwise 0.

   Result% = Odd%(Number&)

Number&    number to test
-------
Result%    whether the number is odd

Name  : OrSt                 (OR String)
Class : String
Level : Any

This routine ORs each byte in one string with the corresponding
byte in a second string. The strings must be the same length.

   OrSt St1$, St2$

St1$      string to OR
St2$      string to OR with
-------
St1$      result

Name  : ParseFSpec           (Parse File Specification)
Class : Disk
Level : Any

This routine splits a file specification into a drive,
subdirectory, and filename. You are expected to initialize the
return strings to reasonable values beforehand (1 for drive, 64
for subdirectory, 12 for filename). If the filespec may be
invalid, you may wish to leave additional space to avoid
potentially disastrous overflows. An alternative would be to use
ExtendFSpec beforehand to check and complete the file
specification. This is likely to be a good approach anyway--
these two routines complement each other nicely.

   Drive$ = SPACE$(1)
   Subdir$ = SPACE$(64)
   File$ = SPACE$(12)
   ParseFSpec FileSpec$, Drive$, DLen%, Subdir$, SLen%,
      File$, FLen%
   Drive$ = LEFT$(Drive$, DLen%)
   Subdir$ = LEFT$(Subdir$, SLen%)
   File$ = LEFT$(File$, FLen%)

FileSpec$   file specification
-------
Drive$      drive letter (init to 1+)
DLen%       length of Drive$
SubDir$     subdirectory (init to 64+)
SLen%       length of Subdir$
File$       file name (init to 12+)
FLen%       length of File$

Name  : PatchDone            (Patch Done)
Class : Disk
Level : DOS

This routine closes the file opened by FindPatch. You must use
PatchDone when you are finished patching the file.

Routines in this set include FindPatch, SetPatch, and PatchDone.

   PatchDone

Name  : PCDat$               (PC Date)
Class : Equipment
Level : Clone

The PCDat$ routine tells you the date of the BIOS ROM chip. This
date is not always available on some (mostly older) clones, in
which case "No Date" is returned.

   ROMDate$ = PCDat$

-------
ROMDate$   date of the BIOS ROM (xx/xx/xx).

Name  : PCDate               (PC Date)
Class : Equipment
Level : Clone

The PCDate routine tells you the date of the BIOS ROM chip. This
date is not always available on some (mostly older) clones, in
which case "No Date " is returned. See also PCDat, a function
version of this routine.

   ROMDate$ = SPACE$(8)
   PCDate ROMDate$

-------
ROMDate$   date of the BIOS ROM (xx/xx/xx).  Init to 8+ chars.

Name  : PCType               (PC Type)
Class : Equipment
Level : Clone

This routine returns the machine I.D. code. This code may not be
one of the listed values for some (mostly older) clones, but the
following is usually correct:

   I.D.  ....Machine....
   255   PC or XT
   254   XT
   253   PCjr
   252   PC AT
   251   XT
   250   PS/2 Model 30
   249   PC Convertible
   248   PS/2 Model 70 or 80
   154   Compaq Portable
    45   Compaq Portable

Note that, for identification purposes, a PC and XT are
essentially the same. The XT is simply a PC with an auto-boot
hard drive. New I.D. numbers come out more or less at random
from IBM, although they aren't as capricious about it as they
used to be. It is useful to identify Compaq Portables as
separate from PCs because those machines had an unusual display,
which acts like a CGA but has the resolution (in text modes) of
an MDA. Hence, the cursor size of a Compaq Portable is MDA-sized
in text mode, but CGA-sized in graphics modes, even though
ordinary tests will tell your program that a CGA is attached. If
you intend to alter the cursor size, this is an important
distinction, since the Compaq Portable was a great success and
is still in wide use. Current Compaq machines, like most other
clones, follow the standard IBM I.D. codes.

See also PCType2, a function version of this routine.

   PCType MachineID%

-------
MachineID%   type of computer

Name  : PCType2%             (PC Type)
Class : Equipment
Level : Clone

This routine returns the machine I.D. code. This code may not be
one of the listed values for some (mostly older) clones, but the
following is usually correct:

   I.D.  ....Machine....
   255   PC or XT
   254   XT
   253   PCjr
   252   PC AT
   251   XT
   250   PS/2 Model 30
   249   PC Convertible
   248   PS/2 Model 70 or 80
   154   Compaq Portable
    45   Compaq Portable

Note that, for identification purposes, a PC and XT are
essentially the same. The XT is simply a PC with an auto-boot
hard drive. New I.D. numbers come out more or less at random
from IBM, although they aren't as capricious about it as they
used to be. It is useful to identify Compaq Portables as
separate from PCs because those machines had an unusual display,
which acts like a CGA but has the resolution (in text modes) of
an MDA. Hence, the cursor size of a Compaq Portable is MDA-sized
in text mode, but CGA-sized in graphics modes, even though
ordinary tests will tell your program that a CGA is attached. If
you intend to alter the cursor size, this is an important
distinction, since the Compaq Portable was a great success and
is still in wide use. Current Compaq machines, like most other
clones, follow the standard IBM I.D. codes.

   MachineID% = PCType2%

-------
MachineID%   type of computer

Name  : Phone2Num&           (Phone# to Number)
Class : Numeric String
Level : Any

This function converts a U.S. or Canadian phone number from
string form to a long integer. It accepts phone numbers of 4, 7,
10, or 11 digits. If there are 11 digits, the first digit must
be a 1. Non-numeric characters are ignored so that formatted
phone numbers can be used. If the phone number is of the wrong
length or otherwise does not appear to be valid, -1 is returned;
otherwise, the result is a long integer which represents the
phone number in a format that can be decoded by Num2Phone$.

This function will accept alphabetic phone numbers and convert
them to their numeric equivalents.

Since it only takes 4 bytes to store a long integer, as opposed
to 7 to 10 or more for the usual alphanumeric form, this can be
considered a compression routine as well as a validation
routine. At worst, for 4-digit phone numbers, it is exactly as
efficient as a character representation. For 7 or 10-digit phone
numbers, it roughly doubles your storage space.

A few words on how checking is done: obviously, there is no way
to tell whether a number is in use or is in fact whoever you
wished to call. However, there are certain regularities to
numeric phone numbers which can be used to detect blatantly
false numbers. Alphabetic phone numbers do not include all the
letters of the alphabet, either. This routine will check for any
obvious peculiarities and warn you accordingly.

NOTE that this function will handle current US-style phone
numbers. It expects the first three digits of a 10-digit phone
number to represent an area code, where the middle digit of the
area code is always either zero or one. This convention is
expected to change as of 1994 or so, whereupon this function
will no longer be reliable <sigh>.

   Result& = Phone2Num&(PhoneNumber$)

PhoneNumber$    phone number (may be formatted)
-------
Result&         encoded phone number (-1 if invalid number)

Name  : PrintBox             (Print a Box)
Class : Display
Level : Clone

This routine displays a box, filled with a character or string
of your choice. Only text modes are supported.

   PrintBox St$, TopRow%, LftCol%, BotRow%, RhtCol%, VAttr%, _
     Page%, Fast%

St$        string to fill box with (one or more chars)
TopRow%    top row of box
LftCol%    left column of box
BotRow%    bottom row of box
RhtCol%    right column of box
VAttr%     color/attribute of box (see CalcAttr)
Page%      display page (for color adapters)
Fast%      display speed (-1 fast, 0 slow for old CGAs)

Name  : PrinterInit          (Printer Initialize)
Class : Printer
Level : BIOS

This routine initializes a printer in the same way as if the
computer had been rebooted.

Note that this will not work on serial printers, even if the
MODE command was used to redirect the port. It works at the BIOS
level, so it doesn't know about any fooling around DOS does.

   PrinterInit Port%

Port%         parallel port number (1-3)

Name  : PrinterReady%        (Printer Ready)
Class : Printer
Level : BIOS

This function lets you know if a printer is ready. It checks to
make sure that the specified port exists, then makes sure a
printer is connected, turned on, and has paper in it.

Note that this will not work on serial printers, even if the
MODE command was used to redirect the port. It works at the BIOS
level, so it doesn't know about any fooling around DOS does.

   Ready% = PrinterReady%(Port%)

Port%         parallel port number (1-3)
-------
Ready%        whether there's a printer ready at that port

Name  : PrintFile            (Print File)
Class : Printer
Level : DOS

This routine sends a file to the printer. It does not paginate,
spool, or anything else fancy. The LPT1 or PRN device is used by
default, although you can change this using the PrtSwap routine.

The predefined device handle for stdprn is used, so don't use
FClose1 to free that handle if you expect to use this routine.
The results could be nasty.

   PrintFile FileName$, ErrCode%

FileName$     name of the file to print
-------
ErrCode%      whether there was an error (0 no, else DOS Error)

Name  : PrintScreen          (Print Screen)
Class : Display / Printer
Level : BIOS

Just like pressing the PrtSc/PrintScrn key on the keyboard, this
routine sends the contents of the display to the printer. It is
mostly designed for text modes, but use of the GRAPHICS TSR
provided with DOS will allow it to print out CGA graphics
displays as well. For some reason, the GRAPHICS utility does not
handle Hercules, EGA or VGA displays; however, alternative
utilities which provide such features may be obtained from your
local BBS.

   PrintScreen

Name  : Processor            (Processor)
Class : Equipment
Level : Any

Processor returns the type of processor (CPU) installed.

Results are returned as follows:

   0    NEC V20
   1    8088 or 8086
   2    80186
   3    80286
   4    80386
   5    80486

Note that, for most practical purposes, a NEC V20 works just
like an 80186.

   Processor ProcType%

-------
ProcType%    type of CPU (see above)

Name  : Processor2%          (Processor)
Class : Equipment
Level : Any

Processor returns the type of processor (CPU) installed.

Results are returned as follows:

   0    NEC V20
   1    8088 or 8086
   2    80186
   3    80286
   4    80386
   5    80486

Note that, for most practical purposes, a NEC V20 works just
like an 80186.

   ProcType% = Processor2%

-------
ProcType%    type of CPU (see above)

Name  : PrtSc                (Print Screen key)
Class : Input / Printer
Level : BIOS

This routine allows you to disable the "print screen" key. This
only affects the keyboard, not the PrintScreen routine in
PBClone.

When the print screen key is disabled, you can detect whether it
was pressed using the GetPrtSc% function. This provides a way of
using the key for your own purposes.

If you disable the print screen key, be sure to enable it again
before your program ends. Otherwise, the print screen key will
be left in an undefined state, probably causing the computer to
crash when it is next pressed.

   PrtSc Enable%

Enable%   whether print screen key should be enabled (0 if no)

Name  : PrtSwap              (Printer Swap)
Class : Printer
Level : Clone

It's handy to use LPRINT, but it isn't always practical. LPRINT
only works on the first printer available (PRN or LPT1). With
this routine, it doesn't matter. PrtSwap allows you to swap any
two printer ports.

Note that it's a good idea to swap the ports back to their
original locations before exiting your program. You could cause
major confusion otherwise!

   PrtSwap Port1%, Port2%

Port1%    number of the first port (1-3)
Port2%    number of the second port (1-3)

Name  : PSortD               (Pointer Sort Double precision)
Class : Array management
Level : Any

This routine sorts the elements in a double precision array...
well, actually, it doesn't change the position of anything in
the double precision array. It sorts the array using a set of
pointers to the array. You can then use the pointers to refer to
the array or to re-order the array yourself.

Why bother with pointers? Well, it's a lot faster than sorting
the numbers directly, since less information has to be swapped.
It has another major advantage, though-- it allows you to sort
an array without losing track of how it corresponds to any
related arrays.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to sort only part of an
array if you like.

The pointer array must be initialized so that each element is
equal to its index. Either use InitPtr or do:
   FOR tmp% = 1 TO Elements%
      Ptr%(tmp%) = tmp%
   NEXT

After this routine, you can access the sorted array via the
pointer array. For instance, to print out a sorted double
precision array, you'd use:
   FOR tmp% = 1 TO Elements%
      PRINT Array#(Ptr%(tmp%))
   NEXT

If you would like the results to be last-to-first, rather than
first-to-last, just call ReverseI to reverse the pointer array
(after this routine).

   PSortD Ptr%(), Array#(), Elements%

Ptr%()      pointers to array to be sorted
Array#()    array to be sorted
Elements%   number of elements in array
-------
Ptr%()      pointers which allow accessing array in sorted order

Name  : PSortI               (Pointer Sort Integer)
Class : Array management
Level : Any

This routine sorts the elements in an integer array... well,
actually, it doesn't change the position of anything in the
integer array. It sorts the array using a set of pointers to the
array. You can then use the pointers to refer to the array or to
re-order the array yourself.

Why bother with pointers? It has a major advantage-- it allows
you to sort an array without losing track of how it corresponds
to any related arrays.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to sort only part of an
array if you like.

The pointer array must be initialized so that each element is
equal to its index. Either use InitPtr or do:
   FOR tmp% = 1 TO Elements%
      Ptr%(tmp%) = tmp%
   NEXT

After this routine, you can access the sorted array via the
pointer array. For instance, to print out a sorted integer
array, you'd use:
   FOR tmp% = 1 TO Elements%
      PRINT Array%(Ptr%(tmp%))
   NEXT

If you would like the results to be last-to-first, rather than
first-to-last, just call ReverseI to reverse the pointer array
(after this routine).

   PSortI Ptr%(), Array%(), Elements%

Ptr%()      pointers to array to be sorted
Array%()    array to be sorted
Elements%   number of elements in array
-------
Ptr%()      pointers which allow accessing array in sorted order

Name  : PSortL               (Pointer Sort Long integer)
Class : Array management
Level : Any

This routine sorts the elements in a long integer array... well,
actually, it doesn't change the position of anything in the long
integer array. It sorts the array using a set of pointers to the
array. You can then use the pointers to refer to the array or to
re-order the array yourself.

Why bother with pointers? Well, it's a lot faster than sorting
the numbers directly, since less information has to be swapped.
It has another major advantage, though-- it allows you to sort
an array without losing track of how it corresponds to any
related arrays.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to sort only part of an
array if you like.

The pointer array must be initialized so that each element is
equal to its index. Either use InitPtr or do:
   FOR tmp% = 1 TO Elements%
      Ptr%(tmp%) = tmp%
   NEXT

After this routine, you can access the sorted array via the
pointer array. For instance, to print out a sorted long integer
array, you'd use:
   FOR tmp% = 1 TO Elements%
      PRINT Array&(Ptr%(tmp%))
   NEXT

If you would like the results to be last-to-first, rather than
first-to-last, just call ReverseI to reverse the pointer array
(after this routine).

   PSortL Ptr%(), Array&(), Elements%

Ptr%()      pointers to array to be sorted
Array&()    array to be sorted
Elements%   number of elements in array
-------
Ptr%()      pointers which allow accessing array in sorted order

Name  : PSortS               (Pointer Sort Single precision)
Class : Array management
Level : Any

This routine sorts the elements in a single precision array...
well, actually, it doesn't change the position of anything in
the single precision array. It sorts the array using a set of
pointers to the array. You can then use the pointers to refer to
the array or to re-order the array yourself.

Why bother with pointers? Well, it's a lot faster than sorting
the numbers directly, since less information has to be swapped.
It has another major advantage, though-- it allows you to sort
an array without losing track of how it corresponds to any
related arrays.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to sort only part of an
array if you like.

The pointer array must be initialized so that each element is
equal to its index. Either use InitPtr or do:
   FOR tmp% = 1 TO Elements%
      Ptr%(tmp%) = tmp%
   NEXT

After this routine, you can access the sorted array via the
pointer array. For instance, to print out a sorted single
precision array, you'd use:
   FOR tmp% = 1 TO Elements%
      PRINT Array!(Ptr%(tmp%))
   NEXT

If you would like the results to be last-to-first, rather than
first-to-last, just call ReverseI to reverse the pointer array
(after this routine).

   PSortS Ptr%(), Array!(), Elements%

Ptr%()      pointers to array to be sorted
Array!()    array to be sorted
Elements%   number of elements in array
-------
Ptr%()      pointers which allow accessing array in sorted order

Name  : PSortSt              (Pointer Sort String)
Class : Array management
Level : Any

This routine sorts the elements in a string array... well,
actually, it doesn't change the position of anything in the
string array. It sorts the array using a set of pointers to the
array. You can then use the pointers to refer to the array or to
re-order the array yourself.

Why bother with pointers? Well, it's a lot faster than sorting
the strings directly, since less information has to be swapped.
It has another major advantage, though-- it allows you to sort
an array without losing track of how it corresponds to any
related arrays. For instance, if you have one array holding
names and another holding phone numbers, this allows you to sort
on names without losing track of which phone numbers are which.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to sort only part of an
array if you like. You can also specify whether the
capitalization of letters in a string should matter for sorting
purposes.

The pointer array must be initialized so that each element is
equal to its index. Either use InitPtr or do:
   FOR tmp% = 1 TO Elements%
      Ptr%(tmp%) = tmp%
   NEXT

After this routine, you can access the sorted array via the
pointer array. For instance, to print out a sorted string array,
you'd use:
   FOR tmp% = 1 TO Elements%
      PRINT Array$(Ptr%(tmp%))
   NEXT

If you would like the results to be last-to-first, rather than
first-to-last, just call ReverseI to reverse the pointer array
(after this routine).

   PSortSt Ptr%(), Array$(), Elements%, CapsCount%

Ptr%()      pointers to array to be sorted
Array$()    array to be sorted
CapsCount%  use 0 if uppercase/lowercase distinctions don't matter
Elements%   number of elements in array
-------
Ptr%()      pointers which allow accessing array in sorted order

Name  : PutScreen            (Put Screen)
Class : Display
Level : Clone

This routine restores a portion of the display (which was saved
to an array by DGetScreen or GetScreen) to the screen. Only text
modes are supported. If your program uses multiple display
pages, you can put the image onto any of those pages. A special
"slow" mode is supported for the CGA, to prevent flickering (a
problem only with some CGAs).

If you wish to restore the entire screen, you may find ScrRest
easier (see).

   PutScreen Array%(), TRow%, LCol%, BRow%, RCol%, Page%, Fast%

Array%()   array from which to restore the image
TRow%      top row of the desired screen area
LCol%      left column of the desired screen area
BRow%      bottom row of the desired screen area
RCol%      right column of the desired screen area
Page%      page on which to restore the display
Fast%      whether to use fast mode (0 no)

Name  : QPrint               (Quick Print)
Class : Display
Level : Clone

This is a replacement for the PRINT statement. It is less
flexible in that it does not move the cursor or interpret
control codes, and because it uses the color that is already on
the screen instead of a specified color value. It also works
only in text modes.

In exchange, QPrint gives you much faster display speeds.

See also XQPrint, which is a bit more flexible (and somewhat
slower).

The results of this routine are not redirectable by DOS.

   QPrint St$, Row%, Column%, Page%, Fast%

St$        text to display
Row%       starting row
Column%    starting column
Page%      page on which to display
Fast%      whether to use fast mode (0 no)

Name  : Rand%                (Random number)
Class : Numeric
Level : Clone

This is a pseudo-random number function. It returns a "random"
number in a range you specify (e.g., if you pass it 10, it will
return 0-9). The number is less random than you'd get from the
BASIC function RND, and you can't set a random number seed a la
RANDOMIZE. There is one major advantage to Rand%, however: it
doesn't bring in BASIC's floating point support, which makes it
much faster than RND and may make your program much smaller.

See also RndI%, which is based on RND itself.

   Number% = Rand%(Range%)

Range%      range of desired pseudo-random number
-------
Number%     pseudo-random number from 0 to Range% - 1

Name  : RandFile$            (Random Filename)
Class : File
Level : DOS

This function returns a pseudo-random filename. The returned
string is based on the current time, to hundredths of a second,
and will be a dollar sign followed by up to seven characters and
digits, terminated by a space. This leaves you room to add your
own file extension, if you like.

The anticipated use for this function is creating temporary
files which will be used for a brief time by your program before
being deleted. The filename returned will be rather unlikely to
conflict with any existing files.

   FileName$ = RandFile$

-------
FileName$    pseudo-random filename (e.g., "$P382227.")

Name  : RClickLoc            (Right Click Location)
Class : Mouse
Level : BIOS

This routine returns the position of the mouse cursor at the
last click of the right mouse button. It must be used after one
of the routines which check for mouse clicks, as they maintain
the click position. These routines include GetKey, GetKey3,
MMClick, and MMClick3.

The values returned are in graphics coordinates (virtual
coordinates for SCREEN 0 through SCREEN 2, due to the nature of
the mouse driver).

   RClickLoc X%, Y%

-------
X%         horizontal coordinate at last right click
Y%         vertical coordinate at last right click

Name  : ReadBitF             (Read Bit Field)
Class : Numeric
Level : Any

This routine allows you to get an element of a virtual array.
The actual array can be any numeric type, as it is just being
used as a storage area. The virtual array is composed of numbers
of a bit length that you specify (1-8). This provides efficient
storage for numbers which have a limited range.

See also WriteBitF.

   ReadBitF DSeg%, DOfs%, ElementNr&, BitLen%, Value%

DSeg%        segment of actual array
DOfs%        offset of actual array
ElementNr&   virtual element number (starts at 0)
BitLen%      bits per virtual element (1-8)
-------
Value%       result (0-255 or less, depending on BitLen%)

Name  : ReadScreen           (Read Screen into string)
Class : Display
Level : Clone

This routine reads a string off the screen. The screen must be
in text mode.

See also GetLine, which reads a row of text from a virtual or
saved screen.

   Result$ = SPACE$(10)    ' init to desired length
   ReadScreen Result$, Row%, Column%, Page%

Result$      result string: init to desired length first
Row%         row (1-25, 1-43, etc [depends on screen mode])
Column%      column (1-40, 1-80, etc [depends on mode])
Page%        page (0, 0-3, etc [depends on display and mode])

Name  : Reboot               (Reboot)
Class : Miscellaneous
Level : Clone

This routine restarts the computer, just like typing
Control-Alt-Del at the keyboard.

   Reboot

Name  : Recolor              (Recolor)
Class : Display
Level : Clone

The Recolor routine changes all text in one color to another
color. It works only in text modes. The colors are specified as
attributes (see CalcAttr).

   Recolor OldAttr%, NewAttr%

OldAttr%   color to be changed
NewAttr%   color to which to change

Name  : RecolorArea          (Recolor Area)
Class : Display
Level : Clone

The RecolorArea routine changes a specified area of the screen
to a specified color. It works only in text modes. The color is
specified as an attribute (see CalcAttr).

See also HiLite, which provides an easier way of highlighting
between two columns on a single row.

   RecolorArea TRow%, LCol%, BRow%, RCol%, VAttr%, Page%, Fast%

TRow%       top row of area to recolor
LCol%       left column of area to recolor
BRow%       bottom row of area to recolor
RCol%       right column of area to recolor
VAttr%      desired color
Page%       display page (normally zero)
Fast%       whether to use fast mode (0 no)

Name  : RedirectIn%          (Redirect Input)
Class : Miscellaneous
Level : DOS

The RedirectIn% function allows you to determine whether input
has been redirected. This lets you know whether input is coming
from the keyboard or from a file or device.

Input that is done by BIOS key routines (e.g., BIOSInkey) is not
affected by redirection, so if you want to support redirection
it is best to avoid such routines unless there is something that
must come from the keyboard.

   Redir% = RedirectIn%

-------
Redir%     whether input has been redirected (0 no)

Name  : RedirectOut%         (Redirect Output)
Class : Miscellaneous
Level : DOS

The RedirectOut% function allows you to determine whether output
has been redirected. This lets you know whether output is going
to the display or to a file or device.

Output that is done by direct screen writes (e.g., XQPrint) is
not affected by redirection, so if you want to allow redirection
it is best to avoid such routines unless there is something that
must to go to the screen itself.

   Redir% = RedirectOut%

-------
Redir%     whether output has been redirected (0 no)

Name  : Rename               (Rename file)
Class : Disk
Level : DOS

This routine allows you to rename an ordinary file. See also
RenSub.

   Rename CurrentName$, NewName$, ErrCode%

CurrentName$   current name of the file
NewName$       desired name of the file
-------
ErrCode%       error code: 0 if no error, else DOS Error

Name  : RenSub               (Rename Subdirectory)
Class : Disk
Level : DOS

This routine provides a service that was inexplicably left out
of the DOS command shell. It allows you to rename a
subdirectory.

Note that renaming a subdirectory is only possible using
old-style FCB file handling. This means that the subdirectory
which you specify must be in the current directory (the routine
doesn't really understand subdirectories per se, but treats them
like any other file). In this implementation, no drive
specification is allowed either. Finally, if there is an error,
the error code may be a simple "255" instead of a useful disk
error number.

   RenSub CurrentSub$, NewSub$, ErrCode%

CurrentSub$   current name of the subdirectory
NewSub$       desired name of the subdirectory
-------
ErrCode%      error code: 0 if no error, else DOS Error

Name  : Replace              (Replace character)
Class : String
Level : Any

This routine replaces all occurrences of a given character in a
string with another character.

   Replace St$, CurCh$, NewCh$

St$         string to process
CurCh$      character to be replaced
NewCh$      character to replace with
-------
St$         processed string

Name  : ReplaceString        (Replace String)
Class : String
Level : Any

This routine replaces all occurrences of a given substring
within a string with another substring. The substrings may be of
any length.

An error code will be returned if the string to search for is
null.

   ReplaceString St$, Old$, New$, Found%, ErrCode%

St$         string to process
Old$        substring to be replaced
New$        substring to replace with
-------
Found%      whether a replacement was done (0 if no)
ErrCode%    whether there was an error (0 if no)

Name  : Retries              (Retries)
Class : Disk
Level : DOS 3.1+

This routine allows you to adjust the handling of file-sharing
errors. When such an error occurs, DOS normally retries 3 times,
with a wait of 1 between tries. This allows temporary
conditions, such as someone else using the file you want to
access, to clear up. In many cases, though, you may want to
change this delay. A shorter delay will improve response time,
allowing your program to handle the error more quickly. A longer
delay may be more suited for a busy network, allowing the
request to proceed after a reasonable waiting period.

The delay period between each retry is unfortunately
machine-dependent, i.e., you will need larger delays on faster
machines to achieve the same effect. This can only be considered
a flaw in DOS.

Note that shorter waiting periods will improve response time for
your program, but may adversely affect the network. Normally,
you should use the longest waiting period with which you feel
comfortable.

   Retries Times%, WaitTime%

Times%     # of times to retry if file-sharing violation occurs
WaitTime%  amount of time to delay between retries

Name  : Reverse              (Reverse)
Class : String
Level : Any

This little fellow reverses the order of the characters in a
string. It is one of the vital components of RInstr, but other
than that I see no real use for it. On the other hand, George
Boole thought that Boolean logic was of solely theoretical
interest, and yet without it there would be no computers. I
leave it to you to find the earth-shattering possibilities of
Reverse!

   Reverse St$

St$      string to be reversed
-------
St$      reversed string

Name  : ReverseD             (Reverse Double precision array)
Class : Array management
Level : Any

This routine reverses the elements in an array of
double-precision numbers. This will probably be most useful for
an array sorted by SortD, in case you want the numbers to go
from largest to smallest.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to reverse only part of
an array if you like.

   ReverseD Array#(), Elements%

Array#()    array to be reversed
Elements%   number of elements in array
-------
Array#()    reversed array

Name  : ReverseI             (Reverse Integer array)
Class : Array management
Level : Any

This routine reverses the elements in an array of integers. This
will probably be most useful for an array sorted by SortI, or a
pointer array used in PSortD, PSortI, PSortL, PSortS, or
PSortSt, in case you want the values to go from largest to
smallest.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to reverse only part of
an array if you like.

   ReverseI Array%(), Elements%

Array%()    array to be reversed
Elements%   number of elements in array
-------
Array%()    reversed array

Name  : ReverseL             (Reverse Long integer array)
Class : Array management
Level : Any

This routine reverses the elements in an array of long integers.
This will probably be most useful for an array sorted by SortL,
in case you want the values to go from largest to smallest.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to reverse only part of
an array if you like.

   ReverseL Array&(), Elements%

Array&()    array to be reversed
Elements%   number of elements in array
-------
Array&()    reversed array

Name  : ReverseS             (Reverse Single precision array)
Class : Array management
Level : Any

This routine reverses the elements in an array of
single-precision numbers. This will probably be most useful for
an array sorted by SortS, in case you want the numbers to go
from largest to smallest.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to reverse only part of
an array if you like.

   ReverseS Array!(), Elements%

Array!()    array to be reversed
Elements%   number of elements in array
-------
Array!()    reversed array

Name  : ReverseSt            (Reverse String array)
Class : Array management
Level : Any

This routine reverses the elements in a string array. This will
probably be most useful for an array sorted by SortSt, in case
you want the strings to be in reverse-alphabetical order.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to reverse only part of
an array if you like.

   ReverseSt Array$(), Elements%

Array$()    array to be reversed
Elements%   number of elements in array
-------
Array$()    reversed array

Name  : RInstr               (Reverse INSTR)
Class : String
Level : Any

Like INSTR, this routine tells you the position of a substring
within a string. A "reverse" search is used, however-- whereas
INSTR tells you the first match, RInstr tells you the last
match. Similarly, whereas INSTR will tell you that a null search
string matches the main string at the first position, RInstr
will match on the last position. Of course, most of the time you
won't be searching for a null string!

   RInstr MainSt$, SeekSt$, Posn%

MainSt$    string to search
SeekSt$    string for which to search
-------
Posn%      position of substring within main string (0 no match)

Name  : RndI%                (Random Integer)
Class : Numeric
Level : Any

This function provides a shell around the BASIC function, RND.
It returns a "random" number in a range you specify (e.g., if
you pass it 10, it will return 0-9).

See also Rand%, which is entirely independent of RND.

   Number% = RndI%(Range%)

Range%      range of desired pseudo-random number
-------
Number%     pseudo-random number from 0 to Range% - 1

Name  : RolSt                (Rotate Left String of bits)
Class : String
Level : Any

This routine rotates the bits in a string left by a desired
amount. This may be helpful for manupulating strings containing
bit flags, images, et al.

   RolSt St$, Count%

St$       string to rotate left
Count%    bits by which to rotate
-------
St$       rotated string

Name  : RorSt                (Rotate Right String of bits)
Class : String
Level : Any

This routine rotates the bits in a string right by a desired
amount. This may be helpful for manupulating strings containing
bit flags, images, et al.

   RorSt St$, Count%

St$       string to rotate right
Count%    bits by which to rotate
-------
St$       rotated string

Name  : RotateL              (Rotate Left)
Class : Numeric
Level : Any

This routine rotates the bits in an integer left by a desired
amount.

   RotateL Value%, Count%

Value%    number to rotate left
Count%    bits by which to rotate
-------
Value%    rotated number

Name  : RotateLL             (Rotate Left Long)
Class : Numeric
Level : Any

This routine rotates the bits in a long integer left by a
desired amount.

   RotateLL Value&, Count%

Value&    number to rotate left
Count%    bits by which to rotate
-------
Value&    rotated number

Name  : RotateR              (Rotate Right)
Class : Numeric
Level : Any

This routine rotates the bits in an integer right by a desired
amount.

   RotateR Value%, Count%

Value%    number to rotate right
Count%    bits by which to rotate
-------
Value%    rotated number

Name  : RotateRL             (Rotate Right Long)
Class : Numeric
Level : Any

This routine rotates the bits in a long integer right by a
desired amount.

   RotateRL Value&, Count%

Value&    number to rotate right
Count%    bits by which to rotate
-------
Value&    rotated number

Name  : RRotate              (Right Rotate string)
Class : String
Level : Any

This routine rotates the characters in a string right once. I'll
admit that I haven't found a use for this myself, but people are
always coming up with new uses for things... and it complements
the more useful LRotate routine.

See also LRotate.

   RRotate St$

St$      string to be rotated right once
-------
St$      string after being rotated right once

Name  : RScroll              (Right Scroll)
Class : Display
Level : Clone

This routine scrolls any selected part of the display right. You
may scroll as many times as you like, or scroll "zero" times to
totally clear the selected part of the display.

   RScroll TopRow%, LeftCol%, BottomRow%, RightCol%, Times%

TopRow%      top row of the area to scroll
LeftCol%     left column of the area to scroll
BottomRow%   top row of the area to scroll
RightCol%    left column of the area to scroll
Times%       number of times (or rows) to scroll

Name  : SBFreeHandles%       (SoundBlaster Free Handles)
Class : SoundBlaster
Level : BIOS

This function tells you how many SoundBlaster XMS handles are
available. In order for any such handles to be available, the
SBSIM driver must have been configured to use XMS (with the
SBSIM.CFG file-- see your SoundBlaster manual for details), and
XMS memory must also be available. XMS requires an AT-class
computer (80286 or better) with extended memory and an XMS
driver. XMS drivers are included with current versions of
MS-DOS, Windows, and memory managers such as QEMM and 386Max.

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetBuffer,
   SBGetDrivers, SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile,
   SBInitSrcXMS, SBIsFree, SBLoadXMS, SBMapMIDI, SBPause,
   SBPlay, SBResume, SBSetVolume, SBStatus%, SBStop

   Free% = SBFreeHandles%

-------
Free%      number of free SBSIM XMS handles

Name  : SBFreeXMS            (SoundBlaster Free XMS handle)
Class : SoundBlaster
Level : BIOS

This routine frees an SBSIM XMS handle that you were using. It
returns the associated XMS memory to the system and releases the
handle. You should always free a handle when you're done using
it, as it takes up valuable system resources.

See PLAYVOC.BAS for an example.

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   SBFreeXMS Handle%

Handle%     SBSIM XMS handle to release

Name  : SBGetActive          (SoundBlaster Get Active drivers)
Class : SoundBlaster
Level : BIOS

This routine tells you which SoundBlaster drivers are active.
Active drivers are those involved in playing something, so this
routine tells you when a sound is finished. You can terminate a
sound at any point with SBStop.

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

See PLAYVOC.BAS for an example.

   SBGetActive FM%, DskVoice%, MemVoice%, Auxiliary%, MIDI%

-------
FM%         whether FM driver (.CMF) is active (0 no)
DskVoice%   whether Disk Voice driver (.VOC) is active (0 no)
MemVoice%   whether Memory Voice driver (.VOC in XMS) is active
Auxiliary%  whether Auxiliary driver is active (0 no)
MIDI%       whether MIDI driver (.MID) is active (0 no)

Name  : SBGetDrivers         (SoundBlaster Get Drivers)
Class : SoundBlaster
Level : BIOS

This routine tells you which SoundBlaster drivers are installed.

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   SBGetDrivers FM%, DskVoice%, MemVoice%, Auxiliary%, MIDI%

-------
FM%         whether FM driver (.CMF) is there (0 no)
DskVoice%   whether Disk Voice driver (.VOC) is there (0 no)
MemVoice%   whether Memory Voice driver (.VOC in XMS) is there
Auxiliary%  whether Auxiliary driver is there (0 no)
MIDI%       whether MIDI driver (.MID) is there (0 no)

Name  : SBGetVer             (SoundBlaster Get Version)
Class : SoundBlaster
Level : BIOS

This routine returns the version number of the SBSIM driver.

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   SBGetVer MajorV%, MinorV%

-------
MajorV%     major version number (e.g., 1 for v1.20)
MinorV%     minor version number (e.g., 20 for v1.20)

Name  : SBGetVolume          (SoundBlaster Get Volume level)
Class : SoundBlaster
Level : BIOS

This routine allows you to get the volume level for specified
SBSIM devices. Stereo volume controls are provided for SBPro and
SB-16 adapters, which support stereo. For older mono
SoundBlasters, the "left" speaker is the active one.

You may select from any of the following SBSIM sound sources:

 Source   Description
 ------   ------------
   0      Master
   1      Voice
   2      FM
   3      CD
   4      Line in
   5      Microphone
   6      PC Speaker

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   SBGetVolume Source%, LeftVol%, RightVol%

Source%     sound source
-------
LeftVol%    left volume (0-255)
RightVol%   right volume (0-255)

Name  : SBInitSrcFile        (SoundBlaster Init Source File)
Class : SoundBlaster
Level : BIOS

This routine prepares the SoundBlaster to play from a file. You
must specify which SBSIM driver to prepare. The driver may be
any of the following:

 Driver   File    Description
 ------   ----    ------------
   1      .CMF    FM synthesis
   2      .VOC    Disk voice
   5      .MID    MIDI

Don't forget to include the file extension. Also, be aware that
this routine doesn't start the sound playing-- that is
accomplished with SBPlay. See also SBLoadXMS, which allows you
to initialize from XMS memory instead of from a file.

See PLAYVOC.BAS for an example.

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   SBInitSrcFile DriverNr%, FileName$, ErrCode%

DriverNr%   SoundBlaster driver to initialize
FileName$   file to play
-------
ErrCode%    error code (0 if initialization succeeded)

Name  : SBInitSrcXMS         (SoundBlaster Init Source XMS)
Class : SoundBlaster
Level : BIOS

This routine prepares the SoundBlaster to play from XMS. You
pass it the SBSIM XMS handle which was returned when the sound
file was loaded into XMS by SBLoadXMS. Note that this routine
doesn't start the sound playing-- that is accomplished with
SBPlay.

When you are done with an XMS handle, remember to free it using
SBFreeXMS.

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   SBInitSrcXMS Handle%, ErrCode%

Handle%     SBSIM XMS handle of sound to play
-------
ErrCode%    error code (0 if initialization succeeded)

Name  : SBInt%               (SoundBlaster Interrupt)
Class : SoundBlaster
Level : BIOS

This function returns the software interrupt number used by the
SBSIM driver. Most people won't ever need to know the actual
number. However, this also works as an installation check, as
the function returns 0 if SBSIM is not installed.

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   IntNr% = SBInt%

-------
IntNr%      interrupt number used by SBSIM (0 if no SBSIM)

Name  : SBIsFree%            (SoundBlaster handle Is Free)
Class : SoundBlaster
Level : BIOS

This function tells you whether a specified SBSIM XMS handle is
free.

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   Free% = SBIsFree%(Handle%)

Handle%     SBSIM XMS handle to test
-------
Free%       whether handle is free (0 no, -1 yes)

Name  : SBLoadXMS            (SoundBlaster Load XMS)
Class : SoundBlaster
Level : BIOS

This routine is used to load a .VOC file into XMS. If you just
want to play directly from a file, see SBInitSrcFile instead.

Unlike SBInitSrcFile, you don't have to specify which SBSIM
driver to use. SBLoadXMS implicitly uses the Memory Voice
driver, which handles XMS sound data in .VOC file format.

You must pass this routine the handle of an SBSIM XMS area.
Normally, you will want to set the handle to zero, which tells
the routine to use the first available handle. A non-zero handle
will be returned for you to use with SBInitSrcXMS.

Don't forget to include the file extension. Also, be aware that
this routine doesn't start the sound playing-- that is
accomplished with SBPlay.

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   SBLoadXMS FileName$, Handle%, ErrCode%

FileName$   file to play
Handle%     SBSIM XMS handle to use (set to 0; see above)
-------
Handle%     active SBSIM XMS handle
ErrCode%    error code (0 if initialization succeeded)

Name  : SBMapMIDI            (SoundBlaster Map MIDI)
Class : SoundBlaster
Level : BIOS

This routine sets the MIDI channel mapper. You may choose from
the following:

   0   General mapper
   1   Basic mapper
   2   Extended mapper

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   SBMapMIDI MapNr%

MapNr%      desired MIDI channel mapping

Name  : SBPause              (SoundBlaster Pause)
Class : SoundBlaster
Level : BIOS

This routine pauses a playing driver. You may select from any of
the following SBSIM drivers:

 Driver   File    Description
 ------   ----    ------------
   1      .CMF    FM synthesis
   2      .VOC    Disk voice
   3      <XMS>   Memory voice
   5      .MID    MIDI

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   SBPause Driver%

Driver%     driver to pause

Name  : SBPlay               (SoundBlaster Play)
Class : SoundBlaster
Level : BIOS

This routine plays a specified driver. The driver must have been
initialized beforehand by SBInitSrcFile or SBInitSrcXMS. You may
select from any of the following SBSIM drivers:

 Driver   File    Description
 ------   ----    ------------
   1      .CMF    FM synthesis
   2      .VOC    Disk voice
   3      <XMS>   Memory voice
   5      .MID    MIDI

Play can be paused with SBPause, resumed with SBResume, and
stopped with SBStop. You can tell which drivers are currently
playing with SBGetActive. You can read the status word with
SBStatus%, though most people won't need it.

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

See PLAYVOC.BAS for an example.

   SBPlay Driver%

Driver%     driver to play

Name  : SBResume             (SoundBlaster Resume)
Class : SoundBlaster
Level : BIOS

This routine resumes playing a paused driver. You may select
from any of the following SBSIM drivers:

 Driver   File    Description
 ------   ----    ------------
   1      .CMF    FM synthesis
   2      .VOC    Disk voice
   3      <XMS>   Memory voice
   5      .MID    MIDI

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   SBResume Driver%

Driver%     driver to resume

Name  : SBSetVolume          (SoundBlaster Set Volume level)
Class : SoundBlaster
Level : BIOS

This routine allows you to set the volume level for specified
SBSIM devices. Stereo volume controls are provided for SBPro and
SB-16 adapters, which support stereo. For older mono
SoundBlasters, the "left" speaker is the active one.

You may select from any of the following SBSIM sound sources:

 Source   Description
 ------   ------------
   0      Master
   1      Voice
   2      FM
   3      CD
   4      Line in
   5      Microphone
   6      PC Speaker

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   SBSetVolume Source%, LeftVol%, RightVol%

Source%     sound source
LeftVol%    left volume (0-255)
RightVol%   right volume (0-255)

Name  : SBStatus%            (SoundBlaster Status)
Class : SoundBlaster
Level : BIOS

This function returns the status word for a specified SBSIM
driver. The status generally seems to be -1 while a driver is
playing something and 0 when it isn't, but different status
values can be encoded into sound files. This is typically used
to synchronize video with the sound.

If you just want to know whether or not a specific driver is
busy, use SBGetActive instead.

You may select from any of the following SBSIM drivers:

 Driver   File    Description
 ------   ----    ------------
   1      .CMF    FM synthesis
   2      .VOC    Disk voice
   3      <XMS>   Memory voice
   5      .MID    MIDI

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

   Status% = SBStatus%(Driver%)

Driver%     driver to check

Name  : SBStop               (SoundBlaster Stop)
Class : SoundBlaster
Level : BIOS

This routine stops playing a paused driver. You may select from
any of the following SBSIM drivers:

 Driver   File    Description
 ------   ----    ------------
   1      .CMF    FM synthesis
   2      .VOC    Disk voice
   3      <XMS>   Memory voice
   5      .MID    MIDI

Routines in this set include:
   SBFreeHandles%, SBFreeXMS, SBGetActive, SBGetDrivers,
   SBGetVer, SBGetVolume, SBInt%, SBInitSrcFile, SBInitSrcXMS,
   SBIsFree, SBLoadXMS, SBMapMIDI, SBPause, SBPlay, SBResume,
   SBSetVolume, SBStatus%, SBStop

See PLAYVOC.BAS for an example.

   SBStop Driver%

Driver%     driver to stop

Name  : ScanKey              (Scan Keyboard)
Class : Input
Level : BIOS

This one's like INKEY$, but a little bit more subtle. It will
tell you if there's a key waiting (and if so, what key it is)
without actually getting the key. The key will remain available
for later retrieval.

Among the more common uses for this routine is to handle keys
like Control-S (pause the display) and Control-C (abort). You
can see if these keys have been pressed without disturbing
anything else the user might have typed. DOS uses exactly this
technique for handling these keys. Since BASIC doesn't go
through DOS I/O, though, the only way for you to support such
nice features is to write them into your program with ScanKey.

   ScanKey CharCode%, CharType%

-------
CharType%   key type: 0 none, 1 normal, 2 extended (scan code)
CharCode%   key ASCII or scan code

Name  : Scroll               (Scroll)
Class : Display
Level : BIOS

This routine scrolls any selected part of the display up. You
may scroll as many times as you like, or scroll "zero" times to
totally clear the selected part of the display.

Note that BIOS-level scrolling can cause the screen to flicker
on some CGAs due to a combination of unfortunate design factors.

   Scroll TopRow%, LeftCol%, BottomRow%, RightCol%, Times%

TopRow      top row of the area to scroll
LeftCol%    left column of the area to scroll
BottomRow   top row of the area to scroll
RightCol%   left column of the area to scroll
Times%      number of times (or rows) to scroll

Name  : ScrRest              (Screen Restore)
Class : Display
Level : Clone

The ScrRest routine restores a display that was saved using
ScrSave or a similar routine. It only works in text modes, and
expects an 80x25 screen. See PutScreen or DPutScreen if you need
to work with other screen sizes.

   ScrRest Array%(), Page%, Fast%

Array%()   array holding the display information
Page%      page on which to restore the display
Fast%      whether to use fast mode (0 no)

Name  : ScrSave              (Screen Save)
Class : Display
Level : Clone

The ScrSave routine saves the display to an integer array. Only
text modes are supported. For an 80x25 display, the array must
hold 4,000 bytes, so you would use DIM Array%(1 TO 2000).

ScrSave expects an 80x25 screen. Use GetScreen or DGetScreen if
you need to work with other screen sizes.

   ScrSave Array%(), Page%, Fast%

Page%      display page to get
Fast%      whether to use fast mode (0 no)
-------
Array%()   saved display information

Name  : SCrunch              (Screen Crunch)
Class : Display
Level : Any

This routine is designed to be used in conjunction with ScrSave
and the other routines which store an entire 80x25 text screen
in an array. It performs a "screen crunch", compressing the
original data into a new array. The average result is about 8x
smaller than the original screen, resulting in a vast savings in
memory (4,000 bytes vs 500 or so). The compression algorithm is
very fast and will not take any noticeable amount of time for
most purposes.

Besides saving main memory, this is great for storing screens as
disk files! The compression will not only make the file(s)
smaller, but will make disk access faster since there is less
information to transfer.

If you need to deal with text screen images of other than 80x25
in size, try the SCrunchSS routine instead.

   SCrunch DSeg%, DOfs%, CSeg%, COfs%, Bytes%

DSeg%     segment of the original screen image
DOfs%     offset of the original screen image
CSeg%     segment of array in which to store compressed image
COfs%     offset of array in which to store compressed image
-------
Bytes%    number of bytes in the compressed image

Name  : SCrunchSS            (Screen Crunch, Sized Screen)
Class : Display
Level : Any

This routine is designed to be used in conjunction with ScrSave
and the other routines which store a text screen in an array. It
performs a "screen crunch", compressing the original data into a
new array. The average result is about 8x smaller than the
original screen, resulting in a vast savings in memory. The
compression algorithm is very fast and will not take any
noticeable amount of time for most purposes.

Besides saving main memory, this is great for storing screens as
disk files! The compression will not only make the file(s)
smaller, but will make disk access faster since there is less
information to transfer.

If you only work with 80x25 text screen images, you may find it
more convenient to use the SCrunch routine instead.

   SCrunchSS DSeg%, DOfs%, Rows%, Cols%, CSeg%, COfs%, Bytes%

DSeg%     segment of the original screen image
DOfs%     offset of the original screen image
Rows%     rows in original screen image
Cols%     columns in original screen image
CSeg%     segment of array in which to store compressed image
COfs%     offset of array in which to store compressed image
-------
Bytes%    number of bytes in the compressed image

Name  : SDFlush              (SmartDrive Flush)
Class : Disk
Level : BIOS

This routine flushes SmartDrive disk caches, forcing it to write
any data in memory to the appropriate disk(s).

This routine requires SmartDrive 4.0 or later.

Routines in this set include:
   SDFlush, SDRCached%, SDReset, SDStats, SDVersion, SDWCached%

   SDFlush

Name  : SDVersion           (SmartDrive Version)
Class : Disk Equipment
Level : BIOS

This routine returns the SmartDrive version. It is known to work
with SmartDrive 4.0 and later. It should work with 3.x versions,
but I haven't been able to test it-- if you are using a version
of SmartDrive before 4.0, please let me know which version and
what results you get.

The other PBClone routines which access SmartDrive require
SmartDrive 4.0 or later to function. This is due to a radical
alteration of the SmartDrive interface as of v4.0, making it
incompatible with earlier versions-- more Microsoft craziness.

Routines in this set include:
   SDFlush, SDRCached%, SDReset, SDStats, SDVersion, SDWCached%

   SDVersion MajorV%, MinorV%

-------
MajorV%    major part of version number (e.g., 4 in v4.10)
MinorV%    minor part of version number (e.g., 10 in v4.10)

Name  : SDRCached%           (SmartDrive Read Cached)
Class : Disk
Level : BIOS

This function tells you whether a specified drive is being
read-cached by SmartDrive.

Note that, in the case of a doubled drive (DoubleSpace, Stacker,
etc), the virtual drive letter is not the one cached-- for
instance, my physical hard drive is mapped to H: by DoubleSpace,
leaving C: as a virtual drive. The virtual drive is not cached
as such, but the physical drive is-- for example, on my system,
C: is not cached, but H: is. So, be careful about what
conclusions you draw about the setup based on this routine. It
is useful for information and for helping safeguard against
problems if your program must run without cacheing, but it isn't
a panacea.

This routine requires SmartDrive 4.0 or later.

Routines in this set include:
   SDFlush, SDRCached%, SDReset, SDStats, SDVersion, SDWCached%

   Cached% = SDRCached% (Drive$)

Drive$     drive letter to examine ("" for default drive)
-------
Cached%    whether drive is read cached (0 no, -1 yes)

Name  : SDReset              (SmartDrive Reset)
Class : Disk
Level : BIOS

This routine resets SmartDrive disk caches, clearing them and
starting caching from a blank slate.

This routine requires SmartDrive 4.0 or later.

Routines in this set include:
   SDFlush, SDRCached%, SDReset, SDStats, SDVersion, SDWCached%

   SDReset

Name  : SDStats              (SmartDrive Statistics)
Class : Disk
Level : BIOS

This routine returns the hit/miss statistics for SmartDrive
cacheing. Hits are the number of times a disk request is
satisfied by the cache. Misses are the number of times a disk
request must be read from the disk itself.

This routine requires SmartDrive 4.0 or later.

Routines in this set include:
   SDFlush, SDRCached%, SDReset, SDStats, SDVersion, SDWCached%

   SDStats Hits&, Misses&

-------
Hits&      number of cache hits
Misses&    number of cache misses

Name  : SDWCached%           (SmartDrive Write Cached)
Class : Disk
Level : BIOS

This function tells you whether a specified drive is being
write-cached by SmartDrive.

Note that, in the case of a doubled drive (DoubleSpace, Stacker,
etc), the virtual drive letter is not the one cached-- for
instance, my physical hard drive is mapped to H: by DoubleSpace,
leaving C: as a virtual drive. The virtual drive is not cached
as such, but the physical drive is-- for example, on my system,
C: is not cached, but H: is. So, be careful about what
conclusions you draw about the setup based on this routine. It
is useful for information and for helping safeguard against
problems if your program must run without cacheing, but it isn't
a panacea.

This routine requires SmartDrive 4.0 or later.

Routines in this set include:
   SDFlush, SDRCached%, SDReset, SDStats, SDVersion, SDWCached%

   Cached% = SDWCached% (Drive$)

Drive$     drive letter to examine ("" for default drive)
-------
Cached%    whether drive is write cached (0 no, -1 yes)

Name  : Sec2Time$            (Seconds to Time)
Class : Time
Level : Any

This routine converts the number of seconds past midnight into a
time string.

   TimeSt$ = Sec2Time$(Seconds&)

Seconds&   number of seconds past midnight
-------
TimeSt$    time string (TIME$ format)

Name  : SetBit               (Set Bit)
Class : Numeric
Level : Any

This routine sets a single bit "on" in an integer. Bits are
numbered 0-15, with 0 being the least significant bit.

   SetBit Number%, BitNr%

Number%    number for which to set bit
BitNr%     bit number (0-15) to set
-------
Number%    number with the specified bit set

Name  : SetCGAColor          (Set CGA Color)
Class : Display
Level : Clone

This routine allows you to set certain aspects of CGA colors
which aren't available otherwise. It is very CGA-specific,
however, and may not work on EGA or VGA systems.

The color specified has different meanings in different CGA
modes. In the SCREEN 1 graphics mode, it changes the background
and border color. In SCREEN 2, however, it allows you to change
the foreground color. While you are still stuck with a single
foreground color, you can choose what that color will be.

   SetCGAColor Colour%

Colour%    color to set (see above)

Name  : SetComm              (Set Comm port)
Class : Serial
Level : DOS

Although QuickBASIC has a fair range of communications support,
it doesn't do the capabilities of the PC full justice. It's also
impossible to change the serial parameters "on the fly" without
risking disconnection, if BASIC alone is used. SetComm gets
around those limitations. It should be used -after- the
appropriate comm port is OPENed by BASIC.

Note that the true upper limits of the comm speed are determined
by your program and by the hardware being used. Some PC/XTs may
have trouble with 9,600 bps, for instance. The ability to set
the serial port to a high speed doesn't guarantee that the
hardware can handle it!

   SetComm CommPort%, Bps%, Parity%, WordLength%, StopBits%

CommPort%    serial port (1-4, though BASIC only uses 1-2)
Bps%         bits per second ("baud rate"):
                0 for   300       5 for   9,600
                1 for   600       6 for  19,200
                2 for 1,200       7 for  38,400
                3 for 2,400       8 for  57,600
                4 for 4,800       9 for 115,200
Parity%      parity:
                0  none
                1  odd            3  mark  (always on)
                2  even           4  space (always off)
WordLength%  word length (5-8)
StopBits%    stop bits (1-2; if WordLength=5, "2" means 1 1/2)

Name  : SetCommAddr          (Set Comm Address)
Class : Serial
Level : Clone

This routine allows you to set the base port address of a serial
port.

One use for SetCommAddr is to give QuickBASIC access to the comm
port on those unusual machines which have a COM2 but no COM1.
Use GetCommAddr to get the address of COM2, set the COM1 address
accordingly, and tell QuickBASIC to use COM1.

BASIC will normally handle COM1 and COM2, but not COM3 or COM4.
Although there is no way to use more two ports at once, you can
fool BASIC into using COM3 by swapping it with COM1, or COM4 by
swapping it with COM2.

Don't forget to set the ports back to their original values
before your program ends!

   SetCommAddr PortNr%, PortAddr%

PortNr%     COM port number (1-4)
PortAddr%   port address

Name  : SetDateAT            (Set Date of AT clock)
Class : Time
Level : BIOS (AT)

This routine sets the date of the hardware real-time clock in
AT-class computers. Depending on the DOS version, this date may
be partially or completely independent of the date kept by DOS
in software. DOS always reads the date from the hardware clock
when it starts up. However, use of the DATE command in DOS (and
the DATE$ function in QuickBASIC) may relate only to the
software copy of the date, which is not always guaranteed to be
the same as the date in the hardware clock due to certain
discrepancies in DOS.

You may express the year as either a two-digit or four-digit
number.

The ProBas and PBClone versions of this routine do not work the
same way in regards to the year. ProBas assumed that any
two-digit year was in the 1900s. In contrast, PBClone assumes
that years 80-99 should be converted to 1980-1999 and that 0-79
should be converted to 2000-2079. I consider the PBClone method
more appropriate, with the turn of the century moving closer.
The date format used does not allow dates before 1980 anyway, so
nothing is being lost by this change.

   SetDateAT MonthNr%, DayNr%, YearNr%

MonthNr%    month number (1-12)
DayNr%      day (1-31)
YearNr%     year (1980-2079; see above for two-digit years)

Name  : SetDrv               (Set default Drive)
Class : Disk
Level : DOS

This routine sets the default disk drive.

If the specified drive does not exist, the current default drive
will remain the default.

   SetDrv Drive$

Drive$    drive letter

Name  : SetError             (Set Error code)
Class : Miscellaneous
Level : DOS

The SetError routine allows you to set the "error level" to be
returned by DOS when your program ends. This is particularly
handy for returning information to batch files.

Note that SetError is best used just before your program ENDs,
to avoid complications.

   SetError ErrorLevel%

ErrorLevel%   exit code to be returned by your program

Name  : SetFAttr             (Set File Attribute)
Class : Disk
Level : DOS

This routine allows you to set the attribute of a file or
subdirectory. Any combination of the following may be set:

   Normal          0      (nothing special)
   Read Only       1      file can be read, but not written to
   Hidden          2      file will be "invisible"
   System          4      (for special DOS files-- leave alone)
   Archive        32      (used by some backup utils- leave be)

To set more than one attribute, just add the numbers for the
desired attributes together. The attributes marked "leave alone"
shouldn't be used casually, but if you're sure you know what
you're doing...

   SetFAttr FileName$, FAttr%

FileName$   name of the file (or subdirectory) to manipulate
FAttr%      attribute(s) to set

Name  : SetFTD               (Set File Time and Date)
Class : Disk
Level : DOS

This routine lets you set the time and date of a specified file.
You may give the year either as two digits or four digits.

The ProBas and PBClone versions of this routine do not work the
same way in regards to the year. ProBas assumed that any
two-digit year was in the 1900s. In contrast, PBClone assumes
that years 80-99 should be converted to 1980-1999 and that 0-79
should be converted to 2000-2079. I consider the PBClone method
more appropriate, with the turn of the century moving closer.
The DOS date format does not allow dates before 1980 anyway, so
nothing is being lost by this change.

Note that the Second% value, if odd, will be rounded down to an
even number. This is due to the way DOS compresses the time
format, rather than any limitation in this routine.

   SetFTD File$, MonthNr%, DayNr%, YearNr%, HourNr%, _
     MinuteNr%, SecondNr%

File$        name of file for which to set the time and date
MonthNr%     month number (1-12)
DayNr%       day (1-31)
YearNr%      year (1980-2079; see above for two-digit years)
HourNr%      hour (0-23)
MinuteNr%    minute (0-59)
SecondNr%    second (0-59; if odd, rounded down to even number)
-------
MonthNr%     -1 if there was an error, else unchanged

Name  : SetKbd               (Set Keyboard toggles)
Class : Input
Level : Clone

The SetKbd routine allows you to set the state of any of the
four keyboard toggles: Insert, Caps lock, Num lock, and Scroll
Lock. You can give your input routines a professional touch by
setting this toggles instead of making the user remember to do
so.

It's considered proper to restore the original keyboard toggles
before your program exits, unless of course the purpose of the
program is to leave the toggles in a particular state! The
GetKbd routine can be used in conjunction with SetKbd to do
this.

   SetKbd Insert%, Caps%, Num%, Scrl%

Insert%    whether to turn on "insert" mode (0 if no)
Caps%      whether to turn on "caps lock" (0 if no)
Num%       whether to put the keypad into numeric mode (0 no)
Scrl%      whether to turn on "scroll lock" (0 if no)

Name  : SetLabel             (Set disk volume Label)
Class : Disk
Level : DOS

This routine creates, renames or deletes a disk volume label.

Note that a disk volume label is essentially a file name without
an extension. It can contain any character that can normally be
in a file name, plus spaces and periods.

   SetLabel Drive$, Label$, ErrCode%

Drive$     drive to set label on (use "" for current drive)
Label$     label to install (use "" to delete current label)
-------
ErrCode%   whether there was an error (0 no)

Name  : SetLogiDrive         (Set Logical Drive)
Class : Disk
Level : DOS 3.2+

This routine is useful for systems which only have a single
floppy drive. In such cases, DOS connects both drive letters A:
and B: to the same drive. However, only one drive letter is
active, and when you try to access the "other" drive, DOS
displays the message:

  "Insert diskette for drive x: and press any key when ready."

By setting the active drive yourself, you can bypass this
message, and your program will look much more professional. See
also GetLogiDrive$, which allows you to determine which drive
letter is active for a given drive.

   SetLogiDrive Drive$, ErrCode%

Drive$     drive letter to select (use "" for current drive)
-------
ErrCode%   whether there was an error (0 no)

Name  : SetMatD              (Set Matrix to Double)
Class : Array
Level : Any

This routine sets as many elements of a double-precision array
as you like, starting at a specified place in the array. A good
use for it is to initialize an array (or a portion of it) to a
given value.

   SetMatD DSeg%, DOfs%, Elements%, Value#

DSeg%      segment of the first array element to add
DOfs%      offset of the first array element to add
Elements%  number of array elements to which to add
Value#     value to which to set each array element

Name  : SetMatI              (Set Matrix to Integer)
Class : Array
Level : Any

This routine sets as many elements of an integer array as you
like, starting at a specified place in the array. A good use for
it is to initialize an array (or a portion of it) to a given
value.

   SetMatI DSeg%, DOfs%, Elements%, Value%

DSeg%      segment of the first array element to add
DOfs%      offset of the first array element to add
Elements%  number of array elements to which to add
Value%     value to which to set each array element

Name  : SetMatL              (Set Matrix to Long)
Class : Array
Level : Any

This routine sets as many elements of an long integer array as
you like, starting at a specified place in the array. A good use
for it is to initialize an array (or a portion of it) to a given
value.

   SetMatL DSeg%, DOfs%, Elements%, Value&

DSeg%      segment of the first array element to add
DOfs%      offset of the first array element to add
Elements%  number of array elements to which to add
Value&     value to which to set each array element

Name  : SetMatS              (Set Matrix to Single)
Class : Array
Level : Any

This routine sets as many elements of a single-precision array
as you like, starting at a specified place in the array. A good
use for it is to initialize an array (or a portion of it) to a
given value.

   SetMatS DSeg%, DOfs%, Elements%, Value!

DSeg%      segment of the first array element to add
DOfs%      offset of the first array element to add
Elements%  number of array elements to which to add
Value!     value to which to set each array element

Name  : SetMouseLoc          (Set Mouse Location)
Class : Mouse
Level : BIOS

This routine allows you to set the current location of the mouse
cursor. It doesn't matter if the cursor is visible or invisible.
SetMouseLoc is only for use in text mode.

This routine will not work properly if there is no mouse
available. Use the MMCheck routine if you are not sure.

See also MMSetLoc, which is for use in graphics modes.

   SetMouseLoc Row%, Column%

Row%       mouse cursor row
Column%    mouse cursor column

Name  : SetPatch             (Set Patch information)
Class : Disk
Level : DOS

This routine is used after FindPatch. The FindPatch routine
finds the first DATA statement to be patched. SetPatch places
new information in that DATA statement and moves the file
pointer to the position of the next DATA statement. Note that
there must be only one item per DATA statement; this item must
be a quoted string. The string in the DATA statement and the
patch string must be the same length.

If you need this routine to be able to handle variable-length
strings, don't fret! Make the DATA string one character longer
than the maximum you need, and use the extra character to
indicate the actual string length:

   SetPatch CHR$(LEN(St$)) + St$

Then when you READ St$, decode it like so:

   St$ = MID$(St$, 2, ASC(St$))

Routines in this set include FindPatch, SetPatch, PatchDone.

   SetPatch St$

St$       string to patch into the current DATA statement

Name  : SetPath              (Set default Path)
Class : Disk
Level : DOS

This routine allows you to set the default path. You may specify
a drive and/or subdirectory:

   Path$ = "E:"           ' switch to drive E:
   Path$ = "\DOC\TECH"    ' switch to subdir \DOC\TECH
   Path$ = "C:\GAME"      ' switch to drive C:, subdir \GAME

The "." and ".." directories are not recognized. However, you
may specify either an absolute or relative path, as usual, and
can also use either slashes or backslashes as delimiters.

See also SetDrv, SetSub

   SetPath Path$, ErrCode%

Path$      path specification
-------
ErrCode%   error code: 0 if no error, else a DOS Error number

Name  : SetPrtAddr           (Set Printer Address)
Class : Printer
Level : Clone

This routine allows you to set the base port address of a
parallel port.

One use for this routine is to fool BASIC into using a different
port than LPT1 for LPRINT. See also PRTSWAP.

Note that PS/2 systems only have ports 1-3 available. They use
the fourth port data area for holding other information. It may
be a good idea to restrict yourself to ports 1-3 for
compatibility purposes, although other computers allow ports
1-4.

Don't forget to set the ports back to their original values
before your program ends!

   SetPrtAddr PortNr%, PortAddr%

PortNr%     LPT port number (1-4 or 1-3 [see above])
PortAddr%   port address

Name  : SetSub               (Set default Subdirectory)
Class : Disk
Level : DOS

Just like the DOS CD (or CHDIR) command, this routine allows you
to change the current subdirectory. Unlike the corresponding DOS
command, you may not use a period or double period as shorthand
for a directory. However, you may specify either an absolute or
relative path, as usual, and can also use either slashes or
backslashes as delimiters.

You may specify a drive as part of the directory specification,
in which case the default directory on the specified drive will
be set (but the current default drive will not change).

See also SetPath.

   SetSub SubDir$, ErrCode%

SubDir$    subdirectory name
-------
ErrCode%   error code: 0 if no error, else a DOS Error number

Name  : SetTimeAT            (Set Time of AT clock)
Class : Time
Level : BIOS (AT)

This routine sets the time to the hardware real-time clock in
AT-class computers. Depending on the DOS version, this time may
be partially or completely independent of the time kept by DOS
in software. DOS always reads the time from the hardware clock
when it starts up. However, use of the TIME command in DOS (and
the TIME$ function in QuickBASIC) may relate only to the
software copy of the time, which is not always guaranteed to be
the same as the time in the hardware clock due to certain
discrepancies in DOS.

   SetTimeAT HourNr%, MinuteNr%, SecondNr%

HourNr%      hour (0-23)
MinuteNr%    minute
SecondNr%    second

Name  : SetVerify            (Set Verify state)
Class : Disk
Level : DOS

The SetVerify routine allows you to set the state of the DOS
VERIFY flag. When VERIFY is on, some checking is done to make
sure that writing to the disk works as requested. The checks are
not very good, however, and VERIFY slows down disk handling, so
it is usually better to have VERIFY off.

   SetVerify VerifyOn%

VerifyOn%   whether to turn VERIFY on (0 if no)

Name  : SetVGAColor          (Set VGA Color)
Class : Display
Level : BIOS

This routine sets the color associated with a given color
number. The color is specified as a combination of red, green,
and blue intensities. Each intensity may range from off (0) to
very bright (63).

If you are dealing with more than one color at a time, you may
find SetVGAPalette more appropriate.

   SetVGAColor ColorNr%, Red%, Green%, Blue%

ColorNr%   color number (1-16 or 1-255, depending on VGA mode)
Red%       red intensity (0-63)
Green%     green intensity (0-63)
Blue%      blue intensity (0-63)

Name  : SetVGAPalette        (Set VGA Palette)
Class : Display
Level : BIOS

This routine allows you to set any number of the VGA palette
values from a TYPEd array. The TYPE for the array should be
defined like this:

   TYPE Palet
      IRed AS STRING * 1
      IBlue AS STRING * 1
      IGreen AS STRING * 1
   END TYPE

This type holds a CHR$-encoded representation of the intensity
of each component of the color. The values range from 0-63.

You can change many palette settings at a time, very quickly,
with this routine. This routine is sufficiently faster than the
BASIC PALETTE statement as to make palette animation (and some
stupendous special effects) possible. It may cause flickering on
displays with less well-designed video BIOS chips, however.

If you only need to set a few colors, you may find SetVGAColor
more convenient.

   SetVGAPalette DSeg%, DOfs%, Start%, Colors%

DSeg%      segment of the palette array
DOfs%      offset of the palette array
Start%     color number to start with
Colors%    number of colors to set

Name  : SFRead               (String File Read)
Class : Disk / String
Level : DOS

This routine reads a string from a file that was opened by
FOpen1 or FCreate. The length of the string you provide
determines how many characters should be read. If it wasn't
possible to read all the characters desired, an error code will
be returned and the BytesRead% value will tell you how many
characters were actually retrieved.

   St$ = SPACE$(BytesToRead%)
   SFRead Handle%, St$, BytesRead%, ErrCode%

Handle%     handle of the file from which to read
-------
St$         data read from the file.  Init to # of chars wanted
BytesRead%  number of bytes read from the file (if error)
ErrCode%    error code: 0 if no error, else DOS Error

Name  : SFWrite              (String File Write)
Class : Disk / String
Level : DOS

This routine writes a string to a file that was opened by FOpen1
or FCreate. The length of the string you provide determines how
many characters will be written. If it wasn't possible to write
the entire string to the file, an error code will be returned
and the BytesWrit% value will tell you how many characters were
actually written.

   SFWrite Handle%, St$, BytesWrit%, ErrCode%

Handle%     handle of the file to which to write
St$         data to write to the file.
-------
BytesWrit%  number of bytes written to the file (if error)
ErrCode%    error code: 0 if no error, else DOS Error

Name  : ShiftL               (Shift Left)
Class : Numeric
Level : Any

This routine shifts the bits in an integer left by a desired
amount. The effect of this is similar to multiplying the number
by a power of two, if the number is positive, but is much
faster.

   ShiftL Value%, Count%

Value%    number to shift left
Count%    bits by which to shift
-------
Value%    shifted number

Name  : ShiftLL              (Shift Left Long)
Class : Numeric
Level : Any

This routine shifts the bits in a long integer left by a desired
amount. The effect of this is similar to multiplying the number
by a power of two, if the number is positive, but is much
faster.

   ShiftLL Value&, Count%

Value&    number to shift left
Count%    bits by which to shift
-------
Value&    shifted number

Name  : ShiftR               (Shift Right)
Class : Numeric
Level : Any

This routine shifts the bits in an integer right by a desired
amount. The effect of this is similar to dividing the number by
a power of two, if the number is positive, but is much faster.

   ShiftR Value%, Count%

Value%    number to shift right
Count%    bits by which to shift
-------
Value%    shifted number

Name  : ShiftRL              (Shift Right Long)
Class : Numeric
Level : Any

This routine shifts the bits in a long integer right by a
desired amount. The effect of this is similar to dividing the
number by a power of two, if the number is positive, but is much
faster.

   ShiftRL Value&, Count%

Value&    number to shift right
Count%    bits by which to shift
-------
Value&    shifted number

Name  : ShlSt                (Shift Left String of bits)
Class : String
Level : Any

This routine shifts the bits in a string left by a desired
amount. This may be helpful for manupulating strings containing
bit flags, images, et al.

   ShlSt St$, Count%

St$       string to shift left
Count%    bits by which to shift
-------
St$       shifted string

Name  : ShowBMP              (Show Bitmap)
Class : Display File
Level : BIOS

This routine displays a bitmap file (MS Windows .BMP format) on
the screen. The display must be in SCREEN 13 mode (MCGA or VGA,
320x200, 256 colors). You can specify a starting X,Y coordinate,
or use -1,-1 to scale the image to the screen. Scaling allows
you to display images larger than 320x200.

Only 256-color bitmaps are supported. The palette will be
changed according to the directions in the bitmap file. If
scaling is chosen and the image is larger than 320x200, the
screen coordinates will be altered with WINDOW SCREEN to let the
image fit. Proportional scaling is used to avoid having a
flattened or stretched image.

   ShowBMP FileName$, X%, Y%, ErrCode%

FileName$   name of bitmap file
X%          X coordinate (0-319, or -1 for scaling)
Y%          Y coordinate (0-199, or -1 for scaling)
-------
ErrCode%    error code (0 if none; >0, DOS error; <0, bad .BMP)

Name  : ShowIcon             (Show Icon)
Class : Display File
Level : BIOS

This routine displays an icon file (MS Windows .ICO format) on
the screen. The display mode may be any of the EGA or VGA
graphics modes, and you can specify a starting X,Y coordinate.

Only the standard icon format is supported. These icons are
32x32 pixels and are contained in 766-byte .ICO files. Note that
colors are translated from Windows colors, which are a close
(but not exact) match for BASIC colors.

   ShowIcon FileName$, X%, Y%, ErrCode%

FileName$   name of icon file
X%          X coordinate (0-319 or 0-639 depending on mode)
Y%          Y coordinate (0-199, -349, etc; depends on mode)
-------
ErrCode%    error code (0 if none; >0, DOS error; <0, not .ICO)

Name  : ShrSt                (Shift Right String of bits)
Class : String
Level : Any

This routine shifts the bits in a string right by a desired
amount. This may be helpful for manupulating strings containing
bit flags, images, et al.

   ShrSt St$, Count%

St$       string to shift right
Count%    bits by which to shift
-------
St$       shifted string

Name  : ShuffleSt            (Shuffle String)
Class : String
Level : Any

This routine shuffles the characters in a string, efficiently
randomizing their order. It relies on the RND function, so you'd
be advised to use the RANDOMIZE statement at the top of your
program unless you want the results to be predictable. A good
way of initializing the random number generator is:

   RANDOMIZE TIMER

See also the array shuffles: MatShuffleD, MatShuffleI,
MatShuffleL, MatShuffleS, MatShuffleSt

   ShuffleSt St$

St$       string to shuffle
-------
St$       shuffled string

Name  : SInput               (String Input)
Class : Input
Level : Clone

This is a flexible line input routine which supports WordStar
and DOS-style editing, default entries, key screening, and any
number of other options. To keep SInput manageable, the less
volatile parameters are set with separate routines instead of
being passed directly.

The St$ parameter must be set to the maximum desired input
length. It may also contain a default entry, in which case SLen%
should be set to the length of the default entry (set SLen% to
zero if there is no default entry).

Character screening is done through selection of valid character
types. This may be any combination of the following (add the
desired types together):

    1    letters
    2    digits
    4    symbols
   16    graphics (ASCII 128-255)
   32    spaces

You can use -1 to allow any character. You can also make use of
the NOT operator, e.g. NOT 2 allows everything but digits.

The ExitCode% returns the key used to terminate input. This will
normally be 13 (return) or 27 (esc), but other results may be
returned depending on how you use the various SInputSet
routines. Note that the cursor position is not altered when
SInput exits, to avoid accidentally scrolling your screen. You
are left with full control over the cursor.

The SInput routine is designed with the idea of input forms and
windows in mind. It is not capable of handling more than one
line of text at a time. It also doesn't know how to wrap at the
edge of the screen.

Routines in this series include:
   SInput, SInputSet, SInputSet1, SInputSet2

Since everyone has their own ideas about the perfect input
routine, I have recoded SInput largely in BASIC to allow you to
modify it easily. I've gotten a huge number of requests for
SInput modifications in the past; hopefully this will be the
best solution!

   SInput St$, SLen%, Valid%, MustFill%, VAttr%, ExitCode%

St$         init to max length of input (may hold default)
SLen%       length of default entry (0 if none)
Valid%      valid character types (see above)
MustFill%   whether input field must be totally filled (0 no)
VAttr%      color/attribute for input (see CalcAttr)
-------
St$         entered string
SLen%       length of entered string
ExitCode%   key used to exit (13 for <CR> or 27 for <ESC>)

Name  : SInputSet            (String Input Settings)
Class : Input
Level : Clone

This is one of a number of routines which allow you to modify
the default operation of SInput.

If you allow extended keys (like Alt keys and function keys) to
exit SInput, the ExitCode% parameter will return the negative
scan code of the key.

Routines in this series include:
   SInput, SInputSet, SInputSet1, SInputSet2

   SInputSet FillCh$, ExtExit%, BadBeep%, FullBeep%, Fast%

FillCh$     character used to show field length (default "_")
ExtExit%    extended keys can be used to exit (default 0, no)
BadBeep%    beep on invalid keys (default 0, no)
FullBeep%   beep when input field is full (default 0, no)
Fast%       use fast display, may make CGA flicker (def 0, no)

Name  : SInputSet1           (String Input Settings)
Class : Input
Level : Clone

This is one of a number of routines which allow you to modify
the default operation of SInput.

If you give SInput a default entry, it will normally place the
cursor at the end of that entry when input begins. The CurPosn%
option here allows you to place the cursor where you want it
(1 - LEN(St$), or 0 for end of entry).

Routines in this series include:
   SInput, SInputSet, SInputSet1, SInputSet2

   SInputSet1 CurPosn%, FullExit%

CurPosn%    starting cursor posn within input field (default 0)
FullExit%   auto-exit when input field is full (default 0, no)

Name  : SInputSet2           (String Input Settings)
Class : Input
Level : Clone

This is one of a number of routines which allow you to modify
the default operation of SInput.

If you allow tabs to exit SInput, the ExitCode% may return an
additional value: 9 (tab). A "back tab", by the way, can be
retrieved if you use SInputSet to allow extended keys to exit
(back tab would return -15).

Routines in this series include:
   SInput, SInputSet, SInputSet1, SInputSet2

   SInputSet2 Capitalize%, TabExit%

Capitalize%   whether to capitalize letters (default 0, no)
TabExit%      whether tab key can to exit (default 0, no)

Name  : SortD                (Sort Double precision)
Class : Array management
Level : Any

This routine sorts the elements in an array of double-precision
numbers.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to sort only part of an
array if you like.

If you would like the results to be largest-to-smallest, rather
than smallest-to-largest, just call ReverseD after this routine.

   SortD Array#(), Elements%

Array#()    array to be sorted
Elements%   number of elements in array
-------
Array#()    sorted array

Name  : SortI                (Sort Integer)
Class : Array management
Level : Any

This routine sorts the elements in an array of integers.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to sort only part of an
array if you like.

If you would like the results to be largest-to-smallest, rather
than smallest-to-largest, just call ReverseI after this routine.

   SortI Array%(), Elements%

Array%()    array to be sorted
Elements%   number of elements in array
-------
Array%()    sorted array

Name  : SortL                (Sort Long integer)
Class : Array management
Level : Any

This routine sorts the elements in an array of long integers.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to sort only part of an
array if you like.

If you would like the results to be largest-to-smallest, rather
than smallest-to-largest, just call ReverseL after this routine.

   SortL Array&(), Elements%

Array&()    array to be sorted
Elements%   number of elements in array
-------
Array&()    sorted array

Name  : SortS                (Sort Single precision)
Class : Array management
Level : Any

This routine sorts the elements in an array of single-precision
numbers.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to sort only part of an
array if you like.

If you would like the results to be largest-to-smallest, rather
than smallest-to-largest, just call ReverseS after this routine.

   SortS Array!(), Elements%

Array!()    array to be sorted
Elements%   number of elements in array
-------
Array!()    sorted array

Name  : SortSt               (Sort String)
Class : Array management
Level : Any

This routine sorts the elements in a string array.

The array is assumed to start at element 1. You may specify the
last element in the array, allowing you to sort only part of an
array if you like. You can also specify whether the
capitalization of letters in a string should matter for sorting
purposes.

If you would like the results to be last-to-first, rather than
first-to-last, just call ReverseSt after this routine.

   SortSt Array$(), Elements%, CapsCount%

Array$()    array to be sorted
CapsCount%  use 0 if uppercase/lowercase doesn't matter
Elements%   number of elements in array
-------
Array$()    sorted array

Name  : Soundex              (Soundex code)
Class : String
Level : Any

This is a string comparison routine which returns a code that is
loosely based on the "sound" of a word. It removes the vowels
and repeated characters from a word, then converts it into a
numeric code. Any words with the same code are considered to
sound alike.

While not perfect, this algorithm does a fast and reasonably
good job. It can be helpful in applications like spelling
checkers and phone books, where a search based on exact text may
not be appropriate.

   Code$ = St$
   Soundex St$, Code$, CodeLen%
   Code$ = LEFT$(St$, CodeLen%)

St$       string to be encoded
-------
Code$     result code.  Init to >= length of original string.
CodeLen%  length of the result code

Name  : SpeedKey             (Speed up Keyboard)
Class : Input
Level : BIOS (AT)

This routine provides control over the keyboard repeat rate for
AT-class machines. Increasing the repeat rate can make the
computer seem a lot more responsive and pleasant to deal with.

  RepDelay%   Delay Time
     0        250 milliseconds
     1        500 ms
     2        750 ms
     3        1 second

  RepRate% is the key repeat rate, 0-31 (from around 30 cps to
  around 2 cps)

   SpeedKey RepDelay%, RepRate%

RepDelay%   delay before starting to repeat (0-3, default 1)
RepRate%    rate at which to repeat key (0-31, default 11)

Name  : Split                (Split screen image)
Class : Display
Level : Clone

This provides an elegant way to clear a text-mode screen. It
splits the display into four parts, scrolling each part up or
down until it slides off the screen.

   Split

Name  : Spooler              (check for print Spooler)
Class : Printer
Level : DOS

The Spooler routine allows you to see whether the print spooler
(installed by the DOS PRINT utility) is available.

   Spooler Status%

-------
Status%   spooler status:
             -1   it's installed
              0   it isn't installed, but can be
              1   it isn't installed, and can't be

Name  : SSrch                (String Search)
Class : String
Level : Any

This is a string search routine which tells you whether one
string can be found inside another. Uppercase/lowercase
distinctions are ignored. Leading and trailing spaces in the
string for which to search are also ignored.

Note that the positions of the main string and search string
parameters are in the reverse of the order you might expect.

   SSrch Search$, MainSt$, Found%

Search$   string for which to search
MainSt$   string to be searched
-------
Found%    whether a match was found (0 if no)

Name  : StrDel               (String Delete)
Class : String
Level : Any

StrDel deletes a character from a string. Actually, it doesn't
make the string any shorter, but it acts like a delete. The end
of the string is filled with a space.

   StrDel St$, Posn%

St$       string from which to delete a character
Posn%     position of the character to delete (1-LEN(St$))
-------
St$       processed string

Name  : StrIns               (String Insert)
Class : String
Level : Any

StrIns inserts a space into a string. Actually, it doesn't make
the string any longer, but it acts like an insert. The former
end of the string is discarded.

   StrIns St$, Posn%

St$       string in which to insert a space
Posn%     where to insert the space (1-LEN(St$))
-------
St$       processed string

Name  : Strip                (Strip spaces)
Class : String
Level : Any

This routine strips both leading and trailing white space from a
string. This includes control characters as well as blanks
(anything below CHR$(33)).

   Strip St$

St$      string to process
-------
St$      processed string

Name  : Strip2$              (Strip Spaces)
Class : String
Level : Any

This routine strips both leading and trailing white space from a
string. It works just like Strip, but is a function rather than
a subprogram. White space includes control characters as well as
blanks (anything below CHR$(33)).

   Result$ = Strip2$(St$)

St$       string to process
-------
Result$   processed string

Name  : StripBlanks          (Strip Blanks)
Class : String
Level : Any

This routine strips leading and/or trailing white space from a
string. This includes control characters as well as blanks
(anything below CHR$(33)).

See also StripSpaces.

   StripBlanks St$, Which%, StLen%
   St$ = LEFT$(St$, StLen%)

St$      string to process
Which%   1: strip left, 2: strip right, 3: strip left and right
-------
St$      processed string
StLen    length of processed string

Name  : StripChar            (Strip Characters)
Class : String
Level : Any

This routine strips all occurrences of a given list of
characters out of a string. Among the uses for this are cleaning
up user-entered values. For instance, a strip list of "$," would
remove commas and dollar signs from a number, and "()- " will
remove telephone delimiters.

   StripChar St$, StripList$, StLen%
   St$ = LEFT$(St$, StLen%)

St$         string to process
StripList$  characters to remove from the string
-------
St$         processed string
StLen%      length of processed string

Name  : StripRange           (Strip Range of characters)
Class : String
Level : Any

This routine strips an inclusive range of characters out of a
string. The range is specified as the first and last ASCII codes
to strip. For instance, using a low character of "0" and a high
of "9" would remove all digits from a string.

   StripRange St$, ASC(LowChar$), ASC(HighChar$), StLen%
   St$ = LEFT$(St$, StLen%)

St$         string to process
LowChar$    lowest character to strip
HighChar$   highest character to strip
-------
St$         processed string
StLen%      length of processed string

Name  : StripSpaces          (Strip Spaces)
Class : String
Level : Any

This routine strips leading and/or trailing spaces from a
string.

See also StripBlanks.

   StripSpaces St$, Which%, StLen%
   St$ = LEFT$(St$, StLen%)

St$      string to process
Which%   1: strip left, 2: strip right, 3: strip left and right
-------
St$      processed string
StLen%   length of processed string

Name  : StrSqu$              (String Squish)
Class : String
Level : Any

This is a text compression routine which uses 2-gram and 3-gram
compression to shrink a string. It combines the best of the
StrSqu2 and StrSqu3 routines with additional ease of use. The
one limitation is that only plain text may be compressed; the
text may not contain CHR$(128) through CHR$(255), as these codes
are used by the compression algorithm.

The compressed text can be restored to original form with the
StrUnsq$ function.

   Result$ = StrSqu$(St$)

St$       string to compress
-------
Result$   compressed string

Name  : StrSqu2              (String Squish, 2-gram)
Class : String
Level : Any

This is a text compression routine which uses a 2-gram algorithm
to compress common pairs of characters out of a string. You can
reasonably expect to reduce the text size by about a third with
this routine. Compression is quite fast. The one limitation is
that only plain text may be compressed; the text may not contain
CHR$(128) through CHR$(255), as these codes are used by the
compression algorithm.

You must use StrSquLen2 before this routine to determine the
proper length to which to initialize the result string.

The compressed text can be restored to original form with
StrUnsqu2.

   StrSquLen2 St$, ResultLen%
   Result$ = SPACE$(ResultLen%)
   StrSqu2 St$, Result$

St$       string to compress
-------
Result$   compressed string

Name  : StrSqu3              (String Squish, 3-gram)
Class : String
Level : Any

This is a text compression routine which uses a 3-gram algorithm
to compress common triplets of characters out of a string. You
can reasonably expect to reduce the text size by about a third
with this routine. Compression is quite fast. The one limitation
is that only plain text may be compressed; the text may not
contain CHR$(128) through CHR$(255), as these codes are used by
the compression algorithm.

You must use StrSquLen3 before this routine to determine the
proper length to which to initialize the result string.

The compressed text can be restored to original form with
StrUnsqu3.

   StrSquLen3 St$, ResultLen%
   Result$ = SPACE$(ResultLen%)
   StrSqu3 St$, Result$

St$       string to compress
-------
Result$   compressed string

Name  : StrSquLen2           (String Squished Length, 2-gram)
Class : String
Level : Any

This routine is used in conjunction with the StrSqu2 text
compressor. It tells you what size the resulting text will be.
See StrSqu2 for further information.

   StrSquLen2 St$, ResultLen%
   Result$ = SPACE$(ResultLen%)
   StrSqu2 St$, Result$

St$          string to compress
-------
ResultLen%   length of the compressed string

Name  : StrSquLen3           (String Squished Length, 3-gram)
Class : String
Level : Any

This routine is used in conjunction with the StrSqu3 text
compressor. It tells you what size the resulting text will be.
See StrSqu3 for further information.

   StrSquLen3 St$, ResultLen%
   Result$ = SPACE$(ResultLen%)
   StrSqu3 St$, Result$

St$          string to compress
-------
ResultLen%   length of the compressed string

Name  : StrUnsq$             (String Unsquish)
Class : String
Level : Any

This routine decompresses text which was compressed by the
StrSqu$ function.

   Result$ = StrUnsq$(St$)

St$       string to decompress
-------
Result$   decompressed string

Name  : StrUnsqu2            (String Unsquish, 2-gram)
Class : String
Level : Any

This routine decompresses text which was compressed by StrSqu2.
Text is decompressed at lightning speed, as this routine has no
overhead to speak of.

You must use StrUnsquLen2 before this routine to determine the
proper length to which to initialize the result string.

   StrUnsquLen2 St$, ResultLen%
   Result$ = SPACE$(ResultLen%)
   StrUnsqu2 St$, Result$

St$       string to decompress
-------
Result$   decompressed string

Name  : StrUnsqu3            (String Unsquish, 3-gram)
Class : String
Level : Any

This routine decompresses text which was compressed by StrSqu3.
Text is decompressed at lightning speed, as this routine has no
overhead to speak of.

You must use StrUnsquLen3 before this routine to determine the
proper length to which to initialize the result string.

   StrUnsquLen3 St$, ResultLen%
   Result$ = SPACE$(ResultLen%)
   StrUnsqu3 St$, Result$

St$       string to decompress
-------
Result$   decompressed string

Name  : StrUnsquLen2         (String Unsquished Length, 2-gram)
Class : String
Level : Any

This routine is used in conjunction with the StrUnsqu2 text
decompressor. It tells you what size the resulting text will be.
See StrUnsqu2 for further information.

   StrUnsquLen2 St$, ResultLen%
   Result$ = SPACE$(ResultLen%)
   StrUnsqu2 St$, Result$

St$          string to decompress
-------
ResultLen%   length of the decompressed string

Name  : StrUnsquLen3         (String Unsquished Length, 3-gram)
Class : String
Level : Any

This routine is used in conjunction with the StrUnsqu3 text
decompressor. It tells you what size the resulting text will be.
See StrUnsqu3 for further information.

   StrUnsquLen3 St$, ResultLen%
   Result$ = SPACE$(ResultLen%)
   StrUnsqu3 St$, Result$

St$          string to decompress
-------
ResultLen%   length of the decompressed string

Name  : SubExist             (Subdirectory Existence)
Class : Disk
Level : DOS

This routine lets you see if a given drive and/or subdirectory
actually exists.

See also SubExist2, the FUNCTION version of this routine.

   SubExist SubDir$, Found%

SubDir$   name of the path to check
-------
Found%    whether the path exists (0 if no, -1 if yes)

Name  : SubExist2%           (Subdirectory Existence)
Class : Disk
Level : DOS

This routine lets you see if a given drive and/or subdirectory
actually exists.

See also SubExist, the SUB version of this routine.

   Found% = SubExist2%(SubDir$)

SubDir$   name of the path to check
-------
Found%    whether the path exists (0 if no, -1 if yes)

Name  : Time2Int             (Time to Integer)
Class : Time
Level : Any

This routine compresses a time into a single integer. Note that
this integer is not in a format that lends itself to simple
computation-- you cannot subtract one from another to find out
the length of time between them. If that's what you want, try
the Elapsed routine.

Note that odd numbers of seconds will be rounded down to the
previous even number. This is a result of the storage format
used.

   Time2Int HourNr%, MinuteNr%, SecondNr%, IntTimeNr%

HourNr%      hour (0-23)
MinuteNr%    minute
SecondNr%    second
-------
IntTime%     time compressed into an integer

Name  : Time2Sec&            (Time to Seconds)
Class : Time
Level : Any

This routine converts a time string into the number of seconds
past midnight. This is convenient if you want to find the
difference between two times or to calculate what time it will
be after a given interval.

   Seconds& = Time2Sec&(TimeSt$)

TimeSt$    time string (TIME$ format)
-------
Seconds&   number of seconds past midnight

Name  : TimeN2S              (Time Numbers to String)
Class : Time
Level : Any / DOS

Many of the PBClone routines return the time as a set of
numbers. This routine provides an easy way to convert those
numbers into string form. The time format used (whether seconds
are included) will be based on the length of the string which
you pass to the routine. For instance, a string like "xx:xx"
would return a time like "21:35", whereas "xx:xx:xx" would
return "21:35:08".

   TimeSt$ = "xx:xx:xx"
   TimeN2S HourNr%, MinuteNr%, SecondNr%, TimeSt$

HourNr%     hour (0-23)
MinuteNr%   minute
SecondNr%   second
-------
TimeSt$     time string.  Init to 5 or 8 characters (see above).

Name  : TimeS2N              (Time String to Numbers)
Class : Time
Level : Any

Many of the PBClone routines need to be passed the time as a set
of numbers. This routine provides an easy way to convert a time
from string form into numbers. You may use either "xx:xx:xx" or
"xx:xx" form to specify the time (the string length is
important, but the delimiter and contents of the string are
ignored). If the 5-character short form is used, the Second%
value will be zero.

   TimeS2N HourNr%, MinuteNr%, SecondNr%, TimeSt$

TimeSt$     time string.  Init to 5 or 8 characters (see above).
-------
HourNr%     hour (0-23)
MinuteNr%   minute
SecondNr%   second (0 if 5-char format)

Name  : TInstr               (Typed INSTR)
Class : String
Level : Any

As you might guess from the "Instr" part of the name, this
routine searches a string. Instead of searching for a specific
character or substring, though, it looks for a specific type of
character-- letters, numbers, control codes, or whatever. You
can search for the first of a combination of types, too, which
also allows searching for "anything but" a specific type.

The character type code is specified by adding any of the
following:

    1    alphabetic
    2    numeric
    4    symbolic
    8    control
   16    graphics
   32    space

The TInstr routine is handy for parsing and cleaning up user
input, among other uses.

   TInstr St$, ChrType%, Place%

St$          string to search
ChrType%     type of character(s) to search for
-------
Place%       position of first char of desired type, or 0

Name  : ToPostal$            (To Postal Abbreviation)
Class : String
Level : Any

This function returns the two-letter U.S. postal abbreviation
corresponding to a given place name. It handles all valid
abbreviations, including states (e.g., "AZ" = "Arizona") and a
number of other countries (e.g., "PR" = "Puerto Rico").

A null string ("") is returned if the specified place can't be
abbreviated. Capitalization is not important, but spelling is.
This function is best used with validated input. If you have
control of the input method, consider using a "pick list" menu.
Otherwise, a fuzzy scanner would be appropriate, using perhaps
the Bickel and/or Soundex routines to find the closest match if
a perfect match is not found.

The conversion can also be done the other way around-- see the
FromPostal$ function.

   Abbrev$ = ToPostal$(PlaceName$)

PlaceName$   place name to abbreviate
-------
Abbrev$      two-letter postal abbreviation

Name  : TVIdle               (TopView Idle)
Class : Miscellaneous
Level : BIOS

If your program is running under TopView or a compatible
multitasker, such as DESQview, it can take advantage of this
routine to give up the rest of its time slice. This would
normally done at a point where the program is liable to be idle
for a brief while, such as during user input.

The advantage of giving up part of your program's time when you
can afford it is that any other running programs will be able to
make use of it, hence improving overall system performance.

   TVIdle

Name  : TypeIn               (Type In)
Class : Input
Level : Clone

This is an unusual routine which combines both output and input.
It sends a string to the keyboard buffer, where it acts as if it
had been typed in by someone. The string may be up to 15 key
codes in length (anything past 15 keys will be ignored, due to
the limited length of the keyboard buffer).

Normal keys can be put into the string simply as characters.
Extended keys, like Alt-key combinations, arrow keys, and
function keys, must be encoded as CHR$(0) + CHR$(ScanCode),
where the ScanCode is the key's scan code. You can look up such
scan codes in your BASIC manual or use GetKey to find out what
they are. Extended keys, although apparently taking up two
characters, only take up one space in the keyboard buffer. The
TypeIn routine allows for this fact.

Among other things, this routine can be used to provide default
answers to input routines, or to execute another program once
your program exits.

   TypeIn St$

St$     keys to be "typed" into the keyboard buffer

Name  : TypePrint            (Type Print)
Class : Display
Level : Clone

TypePrint displays a string as if it was being typed. The string
is displayed a character at a time, with a delay between each
character. You may choose one color to highlight the
just-displayed character and another color for the character to
turn after the delay is done.

   TypePrint St$, Row%, Column%, WaitTime%, TmpAttr%, _
      VAttr%, Fast%

St$        string to display
Row%       row at which to display string
Column%    column at which to display string
WaitTime%  delay between chars (milliseconds; 20-60 is decent)
TmpAttr%   color/attribute for just-displayed character
VAttr%     color/attribute for character after the delay is up
Fast%      whether to use fast displays (0 no)

Name  : UnCalcAttr           (Undo Calculated Attribute)
Class : Display
Level : Any

Many of the display routines in this library require an
"attribute" rather than foreground and background colors. An
attribute is a combination of the foreground and background
colors in a format which is used by all types of displays when
in text mode. The UnCalcAttr routine allows you to decode the
original colors given the attribute.

Foreground colors are usually specified as 0-31, with
backgrounds as 0-7. If you turn blinking off (see Blink), it may
be more convenient to express the same thing as foreground 0-15,
background 0-15. The CalcAttr routine will accept either way of
expressing it.

Note, however, that UnCalcAttr will always return the former
pair of results, since it has no way of knowing whether Blink
has been used (foreground 0-31, background 0-15). The below
routine shows how to get around this, if needed.

   UnCalcAttr Foreground%, Background%, VAttr%
   ' the following is optional and may not be desired...
   ' it converts colors to "no blink" equivalents (see above)
   IF Foreground% AND 16 THEN
      Foreground% = Foreground% - 16
      Background% = Background% + 8
   END IF

VAttr%        color "attribute"
-------
Foreground%   foreground color
Background%   background color

Name  : UnSCrunch            (Undo Screen Crunch)
Class : Display
Level : Any

This routine is designed to be used in conjunction with ScrRest
and the other routines which restore an entire 80x25 text screen
from an array. It expands screens that were compressed by
SCrunch to their full original size. The uncompression algorithm
is very fast and will not take any noticeable amount of time for
most purposes.

If your original screen was not 80x25 in size, use the
UnSCrunchSS routine instead.

   REDIM FullScreen%(1 TO 2000)
   DSeg% = VARSEG(FullScreen%(1))
   DOfs% = VARPTR(FullScreen%(1))
   UnSCrunch DSeg%, DOfs%, CSeg%, COfs%

DSeg%     segment of array in which to store expanded image
DOfs%     offset of array in which to store expanded image
CSeg%     segment of the compressed image
COfs%     offset of the compressed image

Name  : UnSCrunchSS          (Undo Screen Crunch Sized Screen)
Class : Display
Level : Any

This routine is designed to be used in conjunction with ScrRest
and the other routines which restore a text screen from an
array. It expands screens that were compressed by SCrunchSS or
SCrunch to their full original size. The uncompression algorithm
is very fast and will not take any noticeable amount of time for
most purposes.

If your original screen was 80x25 in size, you may find it
convenient to use the UnSCrunch routine instead.

   REDIM FullScreen%(1 TO Rows% * Cols%)
   DSeg% = VARSEG(FullScreen%(1))
   DOfs% = VARPTR(FullScreen%(1))
   UnSCrunchSS DSeg%, DOfs%, Rows%, Cols%, CSeg%, COfs%

DSeg%     segment of array in which to store expanded image
DOfs%     offset of array in which to store expanded image
Rows%     rows in image
Cols%     columns in image
CSeg%     segment of the compressed image
COfs%     offset of the compressed image

Name  : UnSplit              (Undo Split)
Class : Display
Level : Clone

This routine does the opposite of Split-- instead of clearing
the screen by scrolling it in different directions, it puts text
on the screen by scrolling it on from different locations. The
effect is quite stunning.

The information to place on the screen comes from an array that
you specify which contains a saved screen. Only 80x25 text modes
are supported. Any of the screen save routines (e.g., ScrSave)
may be used to load the array. In a typical case, you will use
this routine with screens that were created in advance and
stored to disk for use by your program.

   UnSplit Scrn%(), Fast%

Scrn%()   array containing the text to display
Fast%     whether to use fast mode (0 no)

Name  : Upcase               (Uppercase)
Class : String
Level : Any

This routine, like BASIC's UCASE$ function, converts a string to
uppercase. Since it doesn't have to create a new return string
(a fairly slow process), it's faster than the BASIC equivalent.

The Upcase routine is designed for the U.S. character set. If
your program is intended for distribution, you would be well
advised to use Upcase1 instead, as it supports international
character sets.

   Upcase St$

St$     string to be capitalized
-------
St$     capitalized string

Name  : Upcase1              (Uppercase)
Class : String
Level : DOS

This routine, like BASIC's UCASE$ function, converts a string to
uppercase. It converts letters in the extended character set as
well as the usual letters, making it well suited for text which
may not be in English.

Note that DOS 5.0 is required for optimal performance. With
older DOS versions, this routine makes assumptions about the
character set which may not be appropriate.

   Upcase1 St$

St$     string to be capitalized
-------
St$     capitalized string

Name  : UpcaseI%             (Uppercase Integer char)
Class : Numeric
Level : Any

This function converts a character to uppercase. Rather than
taking a string parameter, though, UpcaseI% works on an integer
which contains an ASCII code.

The UpcaseI% function is designed for the U.S. character set. If
your program is intended for distribution, you would be well
advised to use UpcaseI1% instead, as it supports international
character sets.

   CapCh% = UpcaseI%(Ch%)

Ch%      character to be capitalized
-------
CapCh%   capitalized character

Name  : UpcaseI1%            (Uppercase Integer char)
Class : Numeric
Level : DOS

This function converts a character to uppercase. Rather than
taking a string parameter, though, UpcaseI% works on an integer
which contains an ASCII code.

Note that DOS 5.0 is required for optimal performance. With
older DOS versions, this routine makes assumptions about the
character set which may not be appropriate.

   CapCh% = UpcaseI1%(Ch%)

Ch%      character to be capitalized
-------
CapCh%   capitalized character

Name  : UpdTVScreen          (Update TopView Screen)
Class : Display
Level : BIOS

UpdTVScreen tells a TopView-compatible multitasker to update the
screen using a specified screen buffer (use GetTVScreen to get
the buffer location). Some multitaskers will do this
automatically, but some won't. It's safe to use this routine
either way.

See also GetDView, GetTView, GetTVScreen.

   UpdTVScreen DSeg%, DOfs%

DSeg%       segment of screen buffer
DOfs%       offset of screen buffer

Name  : ValidSt%             (Valid String)
Class : String
Level : Any

This function is used for string validation. It lets you make
sure that a string contains only approved characters. If the
string contains any characters that aren't in the approved list,
0 is returned; otherwise, -1 is returned.

   IsValid% = ValidSt%(St$, GoodCh$)

St$          string to validate
GoodCh$      characters which may be in the string
-------
IsValid%     whether the string is valid (0 no, -1 yes)

Name  : VerticalPrint        (Vertical Print)
Class : Display
Level : Clone

This routine displays a string in a column, from top to bottom,
rather than from left to right. Display handling is done in
BASIC, so all SCREEN modes work, and the cursor is updated
appropriately.

   VerticalPrint St$

St$       string to display

Name  : VGARest13            (VGA Restore for SCREEN 13)
Class : Display
Level : Clone

This routine allows you to restore a SCREEN 13 (VGA, 320x200,
256 color) display that was saved using VGASave13 (see).

   VGARest13 DSeg%, DOfs%

DSeg%        segment of storage array, returned by VARSEG
DOfs%        offset  of storage array, returned by VARPTR

Name  : VGASave13            (VGA Save of SCREEN 13)
Class : Display
Level : Clone

This routine allows you to save a SCREEN 13 (VGA, 320x200, 256
color) display that can be restored using VGARest13 (see).

The array used to hold the screen must contain 64,000 bytes. For
an integer array, this means that you must create the array by
DIM Array%(1 TO 32000).

   VGASave13 DSeg%, DOfs%

DSeg%        segment of storage array, returned by VARSEG
DOfs%        offset  of storage array, returned by VARPTR

Name  : Weekday0             (Weekday)
Class : Time
Level : DOS

This routine tells you what the day of the week is, just the
thing for calendar programs and whatnot. The day is returned as
a number from 1-7, which identifies a day from Sunday through
Saturday.

   Weekday0 DayNr%

-------
DayNr%     current day

Name  : Weekday1             (Weekday)
Class : Time
Level : Any

This routine tells you the day of the week for any given date. A
shortcut is available if you just want the day of the week for
today's date-- use zero (or less) for the MonthNr% or DayNr%
values.

   Weekday1 MonthNr%, DayNr%, YearNr%, DayName$

MonthNr%     month number (1-12)
DayNr%       day number (1-31)
YearNr%      year number (1900 on)
-------
DayName$     day of the week (e.g., "Tuesday")

Name  : WinCheck             (Windows Check)
Class : Equipment
Level : BIOS

The WinCheck routine tells you what version of Microsoft Windows
is in use, if any. It returns the results as two integers
containing the major and minor version numbers. For instance,
Windows 3.0 would return a major number of 3, minor 0.
Windows/386 v2.x will be identified as 2.0. If Windows is not
running, 0.0 will be returned. NOTE that this routine is not
able to detect Windows 1.x versions!

   WinCheck MajorV%, MinorV%

-------
MajorV%   major part of the Windows version
MinorV%   minor part of the Windows version

Name  : WindowMan2           (Window Manager)
Class : Display
Level : Clone

This routine is identical to WindowManager but for the fact that
it allows you to design your own custom window frames. Please
see the description of WindowManager for general information.

These are the additional frame types:
    6   custom frame composed of a single character
    7   custom frame composed of the specified 7-character list:
        top left corner, top middle, top right corner,
        left middle, right middle,
        bottom left corner, bottom middle, bottom right corner

 /------------------------------------------------------------\
 | A custom frame like this would be defined as frame type 7, |
 | with a frame string of "/-\||\-/", for instance.           |
 \------------------------------------------------------------/

 *************************************************
 * On the other hand, a frame like this would be *
 * frame type 6, with a frame string of "*".     *
 *************************************************

Note that this routine differs from the ProBas equivalent in
that it supports full frame definitions through frame type 7.
Differences mentioned under WindowManager are also relevant.

   WindowMan2 TRow%, LCol%, BRow%, RCol%, Frame%, FSt$,
      Fore%, Back%, Grow%, Shade%, TFore%, Title$, Page%, Fast%

TRow%       top row of window
LCol%       left column of window
BRow%       bottom row of window
RCol%       right column of window
Frame%      frame type (see above)
FSt$        frame definition string (see above)
Fore%       frame foreground color
Back%       frame background color
Grow%       window growing option (see above)
Shade%      window shadow option (see above)
TFore%      title foreground color
Title$      window title ("" if none)
Page%       display page (normally zero)
Fast%       whether to use fast mode (0 no)

Name  : WindowMan3           (Window Manager)
Class : Display
Level : Clone

This routine is identical in function to WindowManager. The
parameters are mostly passed as an array, however, instead of
one by one. Please see the description of WindowManager for
general information.

   WindowMan3 Parm%(), Title$

Parm%(1)    top row of window
Parm%(2)    left column of window
Parm%(3)    bottom row of window
Parm%(4)    right column of window
Parm%(5)    frame type (see above)
Parm%(6)    frame foreground color
Parm%(7)    frame background color
Parm%(8)    window growing option (see above)
Parm%(9)    window shadow option (see above)
Parm%(10)   title foreground color
Parm%(11)   display page (normally zero)
Parm%(12)   whether to use fast mode (0 no)
Title$      window title ("" if none)

Name  : WindowMan4           (Window Manager)
Class : Display
Level : Clone

This is an extremely cut-down version of WindowManager,
providing no more than a simple frame generator.

These are the available frame types:
    0   no frame
    1   single lines
    2   double lines
    3   single horizontal, double vertical lines
    4   double horizontal, single vertical lines
    5   block graphic lines

   WindowMan4 TRow%, LCol%, BRow%, RCol%, Frame%, VAttr%, _
      Page%, Fast%

TRow%       top row of window
LCol%       left column of window
BRow%       bottom row of window
RCol%       right column of window
Frame%      frame type (see above)
VAttr%      frame color/attribute (use CalcAttr)
Page%       display page (normally zero)
Fast%       whether to use fast mode (0 if no, to avoid snow on CGAs)

Name  : WindowManager        (Window Manager)
Class : Display
Level : Clone

WindowManager displays a pop-up window according to your
specifications. The window may have any of a variety of frames,
a title, or a shadow, and it may appear instantly or "grow" onto
the screen. Only text mode is supported.

These are the available frame types:
    0   no frame
    1   single lines
    2   double lines
    3   single horizontal, double vertical lines
    4   double horizontal, single vertical lines
    5   block graphic lines

These are the available shadows:
   -3   transparent shadow on the right
   -2   transparent shadow on the left
   -1   solid black shadow on the left
    0   no shadow
   1+   shadow attribute (use CalcAttr) for a colored shadow

Options for growing windows are as follows:
   -1   grow as fast as possible
    0   pop onto the screen
   1+   grow with delay given in milliseconds (15 works for me)

Note that this routine is different from its ProBas equivalent
in a number of respects. The grow delay time is different.
Growing is done more smoothly. The shadow and title parameters
are not changed by this routine. A new frame type (5) was added.
If a title is too long, it is truncated instead of being ignored
completely. Using a -1 as the title foreground color will not
turn off the title; instead, use a null title string.

   WindowManager TRow%, LCol%, BRow%, RCol%, Frame%,
      Fore%, Back%, Grow%, Shade%, TFore%, Title$, Page%, Fast%

TRow%       top row of window
LCol%       left column of window
BRow%       bottom row of window
RCol%       right column of window
Frame%      frame type (see above)
Fore%       frame foreground color
Back%       frame background color
Grow%       window growing option (see above)
Shade%      window shadow option (see above)
TFore%      title foreground color
Title$      window title ("" if none)
Page%       display page (normally zero)
Fast%       whether to use fast mode (0 no)

Name  : WriteBitF            (Write Bit Field)
Class : Numeric
Level : Any

This routine allows you to set an element of a virtual array.
The actual array can be any numeric type, as it is just being
used as a storage area. The virtual array is composed of numbers
of a bit length that you specify (1-8). This provides efficient
storage for numbers which have a limited range.

Here's how you DIM the actual array, assuming an integer array
is used:
   DIM Array%(1 TO (VirtElements * VirtBits + 15) \ 16)

"VirtElements" is the number of elements in the virtual array
and "VirtBits" is the number of bits per element.

See also ReadBitF.

   WriteBitF DSeg%, DOfs%, ElementNr&, BitLen%, Value%

DSeg%        segment of actual array
DOfs%        offset of actual array
ElementNr&   virtual element number (starts at 0)
BitLen%      bits per virtual element (1-8)
Value%       value to set element to (range depends on BitLen%)

Name  : Xlate                (Translate)
Class : String
Level : Any

The Xlate routine allows for translating a string, character by
character, very quickly. It uses a translation table that you
provide. This table is 256 bytes long, one byte for each
character in the ASCII table. The translation is done by
position-- for instance, if the original character was "A"
(ASCII 65), the translated character will be whatever is in the
translation table at position 66. Why 66, when "A" is 65?
Because ASCII runs from 0-255, but the translation string is
1-256: everything is one higher in the string than the ASCII
character it represents.

Translation capabilities are handy in communications software.
They can also be used in other things. One simple use would be
to set up a translation table where all lowercase characters
would be converted to uppercase. You might ask why, since BASIC
has a UCASE$ function and PBClone has an Upcase routine. Well,
Upcase is faster than UCASE$, since it doesn't have to create a
return string; but Xlate would be even faster, since it
translates every character directly instead of deciding whether
it's a lowercase letter!

Simple encoding, WordStar file decryption, string reversal,
uppercase / lowercase conversion, and many other things can be
done with Xlate.

Remember to initialize all 256 characters in the translation
table!

   Xlate St$, XlateTable$

St$          string to translate
XlateTable$  translation table
-------
St$          translated string

Name  : XMPrint              (Translate and MS-DOS Print)
Class : Display
Level : DOS

A combination of the Xlate and DMPrint routines, this 'un allows
you to display using DOS services while being able to translate
or screen out characters. Each character of the string to
display is passed through a translation table you provide (256
bytes, where each position corresponds directly to the ASCII
code of the same number [0-255]). If the result is 0, the
character is not displayed. Otherwise, the translated character
is displayed using DOS display services. The new cursor position
is returned so you can inform BASIC about it.

Note that the new cursor position may not be accurate! Some ANSI
drivers do not update the BIOS cursor position info, in which
case the results won't be useful. That's a hazard of using DOS
output.

   XMPrint St$, XlateTable$, Row%, Column%
   LOCATE Row%, Column%

St$          string to display
XlateTable$  translation table
-------
Row%         current row
Column%      current column

Name  : XorSt                (XOR String)
Class : String
Level : Any

This routine XORs each byte in one string with the corresponding
byte in a second string. The strings must be the same length.

   XorSt St1$, St2$

St1$      string to XOR
St2$      string to XOR with
-------
St1$      result

Name  : XQPrint              (Extended Quick Print)
Class : Display
Level : Clone

This routine provides a rather crude, but very fast, display
capability. It works like the PRINT statement in BASIC, except
that it doesn't move the cursor or process control codes. It
works only in text modes.

See also QPrint, a slightly less flexible (but even faster)
routine.

The results of this routine are not redirectable by DOS.

   XQPrint St$, Row%, Column%, VAttr%, Page%, Fast%

St$       string to display
Row%      starting row
Column%   starting column
VAttr%    color/attribute (see CalcAttr)
Page%     display page (unused on MDA/Herc; normally 0)
Fast%     whether to use fast mode (0 no)

Name  : XQPrintOver          (Extended Quick Print Overwrite)
Class : Display
Level : Clone

This routine provides a rather crude, but very fast, display
capability. It works like the PRINT statement in BASIC, except
that it doesn't move the cursor or process control codes. It
works only in text modes.

This is a slightly unusual variant on a print routine. It
displays all characters except spaces. If your string contains a
space, that position on the screen will be skipped. In other
words, it acts kind of like an overlay. This can be handy when
you have text in alternating colors.

I came up with this routine when I designed a program with a
function key display at the bottom of the screen-- the names of
the function keys were one color and the associated definitions
were another color. It was obvious that the easiest way of
handling that would be to use an "overlay" approach. The
function key definitions were laid down with XQPrint. I then
overlaid the line with the function key names in a different
color, using XQPrintOver.

If you need a "solid" space, rather than a "transparent" space,
use CHR$(255) instead of CHR$(32).

The results of this routine are not redirectable by DOS.

   XQPrintOver St$, Row%, Column%, VAttr%, Page%, Fast%

St$       string to display
Row%      starting row
Column%   starting column
VAttr%    color/attribute (see CalcAttr)
Page%     display page (unused on MDA/Herc; normally 0)
Fast%     whether to use fast mode (0 no)

