'   +----------------------------------------------------------------------+
'   |                                                                      |
'   |        PBClone  Copyright (c) 1990-1994  Thomas G. Hanlin III        |
'   |                                                                      |
'   +----------------------------------------------------------------------+

   DECLARE FUNCTION AscM% (St$, BYVAL Posn%)
   DECLARE FUNCTION Exist2% (FileName$)
   DECLARE SUB FGetLoc (BYVAL FileHandle%, Posn&)
   DECLARE SUB FindNextA (ErrCode%)
   DECLARE SUB FOpen1 (FileName$, BYVAL ReadWrite%, BYVAL Sharing%, FileHandle%, ErrCode%)
   DECLARE SUB FSetLoc (BYVAL FileHandle%, Posn&)
   DECLARE SUB GetNameA (FileName$, FileNameLen%)
   DECLARE SUB MatchFile (PatternName$, FileName$, IsMatch%)
   DECLARE SUB ParseFSpec (FileSpec$, Drive$, DLen%, Subdir$, SLen%, File$, FLen%)
   DECLARE SUB SFRead (BYVAL FileHandle%, St$, BytesRead%, ErrCode%)

   DECLARE SUB GetArc00 (Handle%, ArcType%, File$, Header$)
   DECLARE SUB SetArc00 (BYVAL Handle%, BYVAL ArcType%, File$, Header$)



SUB FindFirstA (Archive$, FileName$, ErrCode%)
   ErrCode% = 0
   File$ = LEFT$(FileName$, 12)
   Arc$ = UCASE$(Archive$)

   IF INSTR(Arc$, ".") = 0 THEN
      IF Exist2%(Arc$ + ".ZIP") THEN
         Arc$ = Arc$ + ".ZIP"
      ELSEIF Exist2%(Arc$ + ".LZH") THEN
         Arc$ = Arc$ + ".LZH"
      ELSEIF Exist2%(Arc$ + ".ARC") THEN
         Arc$ = Arc$ + ".ARC"
      ELSEIF Exist2%(Arc$ + ".PAK") THEN
         Arc$ = Arc$ + ".PAK"
      ELSEIF Exist2%(Arc$ + ".ZOO") THEN
         Arc$ = Arc$ + ".ZOO"
      ELSEIF Exist2%(Arc$ + ".ARJ") THEN
         Arc$ = Arc$ + ".ARJ"
      ELSEIF Exist2%(Arc$ + ".EXE") THEN
         Arc$ = Arc$ + ".EXE"
      ELSEIF Exist2%(Arc$ + ".COM") THEN
         Arc$ = Arc$ + ".COM"
      ELSE
         Arc$ = Arc$ + "."
      END IF
   END IF

   SELECT CASE RIGHT$(Arc$, 3)
      CASE "ARC", "PAK"
         ArcType% = 1
      CASE "LZH"
         ArcType% = 2
      CASE "ZIP"
         ArcType% = 3
      CASE "ZOO"
         ArcType% = 4
      CASE "ARJ"
         ArcType% = 5
      CASE "COM", "EXE"
         ArcType% = -1
      CASE ELSE
         ErrCode% = 9999
   END SELECT

   Posn& = 1&

   IF ErrCode% = 0 THEN FOpen1 Arc$, 0, 2, Handle%, ErrCode%
   IF ErrCode% = 0 AND ArcType% = -1 THEN
      Header$ = "xx"
      SFRead Handle%, Header$, BytesRead%, ErrCode%
      IF ErrCode% = 0 THEN IF Header$ <> "MZ" THEN ErrCode% = 9999
      IF ErrCode% = 0 THEN                       ' check for LHARC .EXE
         FSetLoc Handle%, 1637&
         Header$ = SPACE$(8)
         SFRead Handle%, Header$, BytesRead%, ErrCode%
         IF ErrCode% = 0 THEN
            IF MID$(Header$, 3, 3) = "-lh" THEN
               ArcType% = 2
               FSetLoc Handle%, 1637&
               Posn& = 1637&
            END IF
         END IF
      END IF
      IF ErrCode% = 0 AND ArcType% = -1 THEN     ' check for old PKZIP .EXE
         FSetLoc Handle%, 12785&
         Header$ = SPACE$(4)
         SFRead Handle%, Header$, BytesRead%, ErrCode%
         IF ErrCode% = 0 THEN
            IF LEFT$(Header$, 4) = "PK" + CHR$(3) + CHR$(4) THEN
               ArcType% = 3
               Posn& = 12785&
               FSetLoc Handle%, Posn&
            END IF
         END IF
      END IF
      IF ErrCode% = 0 AND ArcType% = -1 THEN     ' check for new PKZIP .EXE
         FSetLoc Handle%, 15771&
         Header$ = SPACE$(4)
         SFRead Handle%, Header$, BytesRead%, ErrCode%
         IF ErrCode% = 0 THEN
            IF LEFT$(Header$, 4) = "PK" + CHR$(3) + CHR$(4) THEN
               ArcType% = 3
               Posn& = 15771&
               FSetLoc Handle%, Posn&
            END IF
         END IF
      END IF
      IF ErrCode% = 0 AND ArcType% = -1 THEN     ' check for ARJ .EXE
         FSetLoc Handle%, 14859&
         Header$ = SPACE$(2)
         SFRead Handle%, Header$, BytesRead%, ErrCode%
         IF ErrCode% = 0 THEN
            IF Header$ = CHR$(&H60) + CHR$(&HEA) THEN
               ArcType% = 5
               FSetLoc Handle%, 14859&
               Posn& = 14859&
            END IF
         END IF
      END IF
      IF ErrCode% = 0 AND ArcType% = -1 THEN     ' ...not an EXE format we know
         ErrCode% = 9999
      END IF
   END IF
   IF ErrCode% = 0 THEN
      Header$ = SPACE$(128)
      SFRead Handle%, Header$, BytesRead%, ErrCode%
      SetArc00 Handle%, ArcType%, File$, Header$
      SELECT CASE ArcType%
         CASE 1
            IF LEFT$(Header$, 1) <> CHR$(26) OR MID$(Header$, 2, 1) = CHR$(0) THEN ErrCode% = 9999
         CASE 2
            IF MID$(Header$, 3, 1) <> "-" THEN ErrCode% = 9999
         CASE 3
            IF LEFT$(Header$, 4) <> "PK" + CHR$(3) + CHR$(4) THEN ErrCode% = 9999
         CASE 4
            IF MID$(Header$, 21, 4) = CHR$(&HDC) + CHR$(&HA7) + CHR$(&HC4) + CHR$(&HFD) THEN
               Posn& = CVL(MID$(Header$, &H19, 4)) + 1&
               FSetLoc Handle%, Posn&
               SFRead Handle%, Header$, BytesRead%, ErrCode%
            ELSE
               ErrCode% = 9999
            END IF
         CASE 5
            IF LEFT$(Header$, 2) <> CHR$(&H60) + CHR$(&HEA) THEN
               ErrCode% = 9999
            ELSE
               Posn& = CLNG(CVI(MID$(Header$, 3, 2))) + 11&
               FSetLoc Handle%, Posn&
               SFRead Handle%, Header$, BytesRead%, ErrCode%
            END IF
      END SELECT
      IF ErrCode% < 0 THEN
         IF BytesRead% THEN
            ErrCode% = 0
            Header$ = LEFT$(Header$, BytesRead%)
         END IF
      END IF
      IF ErrCode% = 0 THEN
         SetArc00 Handle%, ArcType%, File$, Header$
         FSetLoc Handle%, Posn&
         CurFile$ = SPACE$(80)
         GetNameA CurFile$, FLen%
         IF FLen% THEN
            FileSpec$ = LEFT$(CurFile$, FLen%)
            Drive$ = " "
            SubDir$ = SPACE$(64)
            CurFile$ = SPACE$(12)
            ParseFSpec FileSpec$, Drive$, DLen%, SubDir$, SLen%, CurFile$, FLen%
            Drive$ = LEFT$(Drive$, DLen%)
            SubDir$ = LEFT$(SubDir$, SLen%)
            CurFile$ = LEFT$(CurFile$, FLen%)
            MatchFile File$, CurFile$, Found%
         ELSE
            Found% = 0
         END IF
      END IF
      IF ErrCode% OR NOT Found% THEN
         FindNextA ErrCode%
      END IF
   END IF
END SUB



SUB FindNextA (ErrCode%)
   File$ = SPACE$(12)
   Header$ = SPACE$(128)
   GetArc00 Handle%, ArcType%, File$, Header$
   IF Handle% THEN
      File$ = RTRIM$(File$)
   ELSE
      ErrCode% = -1
   END IF
   DO UNTIL ErrCode% OR Found%
      FGetLoc Handle%, Posn&
      SELECT CASE ArcType%
         CASE 1
            IF AscM%(Header$, 2) = 1 THEN
               Posn& = Posn& + 25&
            ELSE
               Posn& = Posn& + 29&
            END IF
            Posn& = Posn& + CVL(MID$(Header$, 16, 4))
         CASE 2
            Posn& = Posn& + (ASC(Header$) + 2) + CVL(MID$(Header$, 8, 4))
         CASE 3
            Posn& = Posn& + 30& + CVI(MID$(Header$, 27, 2))
            Posn& = Posn& + CVI(MID$(Header$, 29, 2))
            Posn& = Posn& + CVL(MID$(Header$, 19, 4))
         CASE 4
            Posn& = CVL(MID$(Header$, 7, 4)) + 1&
         CASE 5
            Posn& = Posn& + CLNG(CVI(MID$(Header$, 3, 2))) + CVL(MID$(Header$, 17, 4)) + 10&
      END SELECT
      IF ErrCode% = 0 THEN
         FSetLoc Handle%, Posn&
         Header$ = SPACE$(128)
         SFRead Handle%, Header$, BytesRead%, ErrCode%
      END IF
      IF ErrCode% < 0 THEN
         IF BytesRead% THEN
            ErrCode% = 0
            Header$ = LEFT$(Header$, BytesRead%)
         END IF
      END IF
      SELECT CASE ArcType%
         CASE 1: IF LEFT$(Header$, 1) <> CHR$(26) OR MID$(Header$, 2, 1) = CHR$(0) THEN ErrCode% = 9999
         CASE 2: IF MID$(Header$, 3, 1) <> "-" OR LEFT$(Header$, 1) = CHR$(0) THEN ErrCode% = 9999
         CASE 3: IF LEFT$(Header$, 4) <> "PK" + CHR$(3) + CHR$(4) THEN ErrCode% = 9999
         CASE 5: IF LEFT$(Header$, 2) <> CHR$(&H60) + CHR$(&HEA) OR CVI(MID$(Header$, 3, 2)) = 0 THEN ErrCode% = 9999
      END SELECT
      IF ErrCode% = 0 THEN
         SetArc00 Handle%, ArcType%, File$, Header$
         FSetLoc Handle%, Posn&
         CurFile$ = SPACE$(12)
         GetNameA CurFile$, FLen%
         IF FLen% THEN
            FileSpec$ = LEFT$(CurFile$, FLen%)
            Drive$ = " "
            SubDir$ = SPACE$(64)
            CurFile$ = SPACE$(12)
            ParseFSpec FileSpec$, Drive$, DLen%, SubDir$, SLen%, CurFile$, FLen%
            Drive$ = LEFT$(Drive$, DLen%)
            SubDir$ = LEFT$(SubDir$, SLen%)
            CurFile$ = LEFT$(CurFile$, FLen%)
            MatchFile File$, CurFile$, Found%
         ELSE
            Found% = 0
         END IF
      END IF
   LOOP
END SUB



SUB GetNameA (FileName$, FLen%)
   File$ = SPACE$(12)
   Header$ = SPACE$(128)
   GetArc00 Handle%, ArcType%, File$, Header$
   SELECT CASE ArcType%
      CASE 1
         St$ = MID$(Header$, 3, 13)
         FLen% = INSTR(St$, CHR$(0))
         IF FLen% THEN
            FLen% = FLen% - 1
         ELSE
            FLen% = 12
         END IF
         MID$(FileName$, 1, FLen%) = St$
      CASE 2
         FLen% = AscM%(Header$, 22)
         MID$(FileName$, 1) = MID$(Header$, 23, FLen%)
      CASE 3
         FLen% = AscM%(Header$, 27)
         MID$(FileName$, 1) = MID$(Header$, 31, FLen%)
      CASE 4
         IF AscM%(Header$, 31) = 1 THEN
            FLen% = 0
         ELSE
            FLen% = INSTR(MID$(Header$, 39, 13), CHR$(0)) - 1
            MID$(FileName$, 1) = MID$(Header$, 39, FLen%)
         END IF
      CASE 5
         IF AscM%(Header$, 11) > 1 THEN
            FLen% = 0
         ELSE
            St$ = MID$(Header$, 35, 80)
            FLen% = INSTR(St$, CHR$(0))
            IF FLen% THEN FLen% = FLen% - 1
            MID$(FileName$, 1, FLen%) = St$
         END IF
   END SELECT
END SUB



SUB GetStoreA (Storage$)
   File$ = SPACE$(12)
   Storage$ = File$
   Header$ = SPACE$(128)
   GetArc00 Handle%, ArcType%, File$, Header$
   SELECT CASE ArcType%
      CASE 1
         SELECT CASE AscM%(Header$, 2)
            CASE 1, 2: Storage$ = "Stored  "
            CASE 3: Storage$ = "Packed  "
            CASE 4: Storage$ = "Squeezed"
            CASE 5, 6: Storage$ = "crunched"
            CASE 7, 8: Storage$ = "Crunched"
            CASE 9: Storage$ = "Squashed"
            CASE 10: Storage$ = "Crushed "
            CASE 11: Storage$ = "Distill "
            CASE ELSE
         END SELECT
      CASE 2
         Storage$ = LEFT$(MID$(Header$, 3, 5) + SPACE$(8), 8)
      CASE 3
         SELECT CASE AscM%(Header$, 9)
            CASE 0: Storage$ = "Stored  "
            CASE 1: Storage$ = "Shrunk  "
            CASE 2: Storage$ = "Reduce-1"
            CASE 3: Storage$ = "Reduce-2"
            CASE 4: Storage$ = "Reduce-3"
            CASE 5: Storage$ = "Reduce-4"
            CASE 6: Storage$ = "Imploded"
            CASE 8: Storage$ = "Deflated"
            CASE ELSE: Storage$ = SPACE$(8)
         END SELECT
      CASE 4
         Storage$ = SPACE$(8)
      CASE 5
         Storage$ = CHR$(AscM%(Header$, 10) + 48) + SPACE$(7)
   END SELECT
END SUB
