; CMCRC.ASM  Public Domain by Celso Minnitti, Jr  Feb-06-94
;
; Version:  1.0
;
; Compile:  TASM /m2 cmcrc
;	    TLINK /t /3 /x cmcrc
;
; CMCRC.ASM is a simple program just to demonstrate how to compute the
; CRC-16 and CRC-32 using the crc16_table and crc32_table that were
; generated by CRCTABLE.
;
; Although I am providing the full assembly source code to compute the CRC-16
; and CRC-32 and the C source code to create the crc16_table and crc32_table,
; I belive that if you don't have any background on CRCs you won't be able to
; fully comprehend this code. If you wish to learn more about CRCs I suggest
; the following references:
;  "C Programmer's Guide to Serial Communications", Joe Campbell SAMS
; publishing ISBN 0-672-30286-1.
;  Dr. Dobb's Journal #188, may 1992. There is a CRC-32 article there that
; will explain how to generate CRC-32 table and how to compute the CRC-32.
; The full C source is provided.
;
; If you have any questions, comments or suggestions regarding CMCRC
; please send me an email via internet to celsomj@world.std.com or
; call me at 617-235-4018 or write to:
;
; Celso Minnitti Jr
; 139 Linden St
; Wellesley, MA 02181
;
; I will be glad to answer all questions.

_TEXT	segment dword public 'CODE'
	assume cs:_TEXT, ds:_TEXT
	org	 100h
.386

start:		cld
		call	whatcpu
		cmp	ax,386h
		jae	l0			 ;386 or better?

		mov	ax,offset makecrc16	 ;
		mov	[amakecrc16],ax 	 ;
		mov	ax,offset makecrc32	 ;if cpu < 386 then use
		mov	[amakecrc32],ax 	 ;16-bit functions
		mov	ax,offset printcrc32	 ;
		mov	[aprintcrc32],ax	 ;
		mov	ax,offset printbytes	 ;
		mov	[aprintbytes],ax	 ;

l0:		mov	si,offset msg0		 ;CMCRC  Public Domain by Celso
		call	prints			 ;print string

		mov	si,81h			 ;address of DOS command line
		mov	di,offset ARGV
l1:		lodsb
		cmp	al,13			 ;is CR?
		jz	l2			 ;yes, then finish
		cmp	al,20h			 ;skip spaces
		je	l1
		stosb				 ;copy cmd line to ARGV
		jmp	l1

l2:		mov	byte ptr [di],0 	 ;put a NULL at end
		cmp	di,offset ARGV		 ;if empty then print Usage:
		jnz	l3			 ;else continue
		mov	si,offset msg1		 ;Usage: cmcrc <filename.ext>
		jmp	exit

l3:		mov	ah,4eh			 ;find first
		mov	cx,6			 ;system and hidden files
		mov	dx,offset ARGV
		int	21h
		jnc	l4			 ;if CF=0 then no errors
		mov	si,offset msg_err0	 ;File not found
		jmp	exit

l4:		mov	si,offset msg2		 ;Filename  Bytes  CRC-32
		call	prints
		call	whatcpu 		 ;
		xor	bx,bx			 ;
		mov	bl,ah			 ;print cpu type
		shl	bx,1			 ;
		mov	si,[bx+cputype] 	 ;
		call	prints			 ;

		mov	si,offset msg3
		call	prints

next_file:      mov     ax,3d00h                 ;open file for read
		mov	dx,9eh			 ;dos return filename.ext,0
		int	21h			 ;at DTA+1EH (80H+1EH) = 9Eh
		jnc	l5
		mov	si,offset msg_err1	 ;Unable to open file
		jmp	exit

l5:		mov	bx,ax			 ;get handle
		mov	[attr],14		 ;set attribute to yellow
		mov	al,0
		mov	cx,13
		mov	di,9eh			 ;dta+1eh = filename.exe
		repnz	scasb			 ;look for a NULL
		mov	al,' '                   ;if filename.ext if less
		dec	di			 ;than 13 characters long
		rep	stosb			 ;then append spaces
		mov	al,0
		stosb

		mov	si,9eh
		call	prints			 ;print filename

		mov	[attr],10		 ;light green
		call	[aprintbytes]		 ;print bytes
                mov     cl,2
		call	printspc		 ;print 2 spaces

read_ag:        mov     ah,3fh                   ;read
		mov	cx,512*120		 ;512*120 (120 sectors)
		mov	dx,offset BUFFER
		int	21h
		jnc	l6
		mov	si,offset msg_err2	 ;Error reading file
		jmp	exit

l6:		mov	si,dx
		mov	cx,ax
		call	[amakecrc16]
                call    [amakecrc32]

		cmp	cx,512*120
		je	read_ag 		 ;read next part of file

		mov	ah,3eh			 ;close file
		int	21h

		mov	[attr],11		 ;light blue
		call	[aprintcrc32]		 ;print CRC-32

		mov	cl,2
		call	printspc
		mov	[attr],12		 ;light red
		mov	ax,[init_crc16]
		call	print6h 		 ;print CRC-16

		mov	si,offset crlf		 ;print CR and LF
		call	prints

		mov	[init_crc16],0
		mov	word ptr [init_crc32],0ffffh
		mov	word ptr [init_crc32+2],0ffffh

		mov	ah,4fh			 ;find next
		int	21h
		jnc	next_file		 ;read next file
		jmp	exit1			 ;done

exit:           call    prints
exit1:		mov	si,offset msg_end	 ;restore cursor color to
		call	prints			 ;gray (color=7)
		int	20h			 ;exit to DOS


emakecrc16:	mov	dx,[init_crc16]
		call	ecrc16
		mov	[init_crc16],dx
		ret

makecrc16:	mov	dx,[init_crc16]
		call	crc16
		mov	[init_crc16],dx
		ret

eprintcrc32:	mov	eax,[init_crc32]
                not     eax                      ;reverse all bits
		call	eprint2h		 ;print CRC-32
		ret

printcrc32:	mov	ax,word ptr [init_crc32]
		mov	dx,word ptr [init_crc32+2]
		not	ax
		not	dx
		call	print2h
		ret

emakecrc32:	mov	edx,[init_crc32]
		call	ecrc32
		mov	[init_crc32],edx
		ret

makecrc32:	mov	ax,word ptr [init_crc32]
		mov	dx,word ptr [init_crc32+2]
		call	crc32
		mov	word ptr [init_crc32],ax
		mov	word ptr [init_crc32+2],dx
		ret

eprintbytes:	mov	eax,dword ptr ds:[9ah]
		call	eprint2d
		ret

printbytes:     mov     ax,word ptr ds:[9ah]
		mov	dx,word ptr ds:[9ch]
		call	print2d
		ret

;**************************************************************************
; ecrc16 - compute CRC-16 of a given buffer using crc16_table
;
; enter:   DS:SI = address of buffer
;	   CX	 = length of buffer
;	   DX	 = initial CRC value
;
; return:  DX	 = CRC-16
;**************************************************************************
ecrc16		proc	near
		push	cx
		push	si

ecrc16_loop:	xor	eax,eax
		mov	al,[si] 		 ;faster than lodsb
		inc	si			 ;
		xor	al,dl
		mov	ax,[eax*2+crc16_table]
		xor	al,dh
		mov	dx,ax
		dec	cx			 ;faster than loop
		jnz	ecrc16_loop		 ;

		pop	si
		pop	cx
		ret
ecrc16		endp

;**************************************************************************
; crc16 - compute CRC-16 of a given buffer using crc16_table
;
; enter:   DS:SI = address of buffer
;	   CX	 = length of buffer
;	   DX	 = initial CRC value
;
; return:  DX	 = CRC-16
;**************************************************************************
crc16		proc	near
		push	cx
		push	bx
		push	si

crc16_loop:	xor	ax,ax
		mov	al,[si] 		 ;faster than lodsb
		inc	si			 ;
		xor	al,dl
                shl     ax,1
                mov     bx,ax
		mov	ax,[bx+crc16_table]
		xor	al,dh
		mov	dx,ax
		dec	cx			 ;faster than loop
		jnz	crc16_loop		 ;

		pop	si
		pop	bx
		pop	cx
		ret
crc16		endp

;**************************************************************************
; ecrc32 - compute CRC-32 of a given buffer using crc32_table
;
; enter:   DS:SI = address of buffer
;	   CX	 = length of buffer
;	   EDX	 = initial CRC-32 value
;
; return:  EDX	 = CRC-32
;**************************************************************************
ecrc32		proc	near
		push	eax
		push	cx
		push	si

ecrc32_loop:	xor	eax,eax
		mov	al,[si] 		 ;faster than lodsb
		inc	si			 ;
		xor	al,dl
		mov	eax,[eax*4+crc32_table]
		shr	edx,8
		xor	edx,eax
		dec	cx			 ;faster than loop
		jnz	ecrc32_loop		 ;

		pop	si
		pop	cx
		pop	eax
		ret
ecrc32		endp

;**************************************************************************
; crc32 - compute CRC-32 of a given buffer using crc32_table
;
; enter:   DS:SI = address of buffer
;	   CX	 = length of buffer
;	   DX:AX = initial CRC-32 value
;
; return:  DX:AX = CRC-32
;**************************************************************************
crc32		proc	near
		push	cx
		push	bx
		push	si
		push	di

		mov	di,cx
crc32_loop:	xor	bx,bx
		mov	bl,[si]
		inc	si
		xor	bl,al
		shl	bx,1
                shl     bx,1
		mov	cx,word ptr [bx+crc32_table]
		mov	al,ah
		mov	ah,dl
		xor	ax,cx
		mov	cx,word ptr [bx+2+crc32_table]
		mov	dl,dh
		mov	dh,0
		xor	dx,cx
		dec	di
		jnz	crc32_loop

		pop	di
		pop	si
		pop	bx
		pop	cx
		ret
crc32		endp

;**************************************************************************
;			       EPRINT2H
; enter:   EAX = # to print in hexadecimal
;**************************************************************************
eprint2h	proc	near
		push	eax
		push	cx
		push	edx
		push	di

		mov	cx,8
		mov	edx,eax
epri21: 	rol	edx,4
		mov	al,dl
		and	al,0fh
		daa
		add	al,0f0h
		adc	al,40h
		call	putchar
		dec	cx
		jnz	epri21

		pop	di
		pop	edx
		pop	cx
		pop	eax
		ret
eprint2h	endp

;**************************************************************************
;			       PRINT2H
; enter:   DX:AX = # to print in hexadecimal
;**************************************************************************
print2h 	proc	near
		push	ax
		push	cx
		push	dx
		push	si
		push	di

		push	ax
		mov	cx,4
		mov	si,cx
pri21:		rol	dx,cl
		mov	al,dl
		and	al,0fh
		daa
		add	al,0f0h
		adc	al,40h
		call	putchar
		dec	si
		jnz	pri21

		pop	dx
		mov	si,4
pri22:		rol	dx,cl
		mov	al,dl
		and	al,0fh
		daa
		add	al,0f0h
		adc	al,40h
		call	putchar
		dec	si
		jnz	pri22

		pop	di
		pop	si
		pop	dx
		pop	cx
		pop	ax
		ret
print2h 	endp

;**************************************************************************
;				PRINT6H
; enter:   AX = # to print in hexadecimal
;**************************************************************************
print6h 	proc	near
		push	ax
		push	cx
		push	dx
		push	di

pri61:		mov	cx,4
		mov	dx,ax
pri62:		rol	dx,4
		mov	al,dl
		and	al,0fh
		daa
		add	al,0f0h
		adc	al,40h
		call	putchar
		dec	cx
		jnz	pri62

		pop	di
		pop	dx
		pop	cx
		pop	ax
		ret
print6h 	endp

;**************************************************************************
;			       EPRINT2D
; enter:   EAX = # to print in decimal
;**************************************************************************
eprint2d	proc	near
		push	eax
                push    cx
                push    edx
		push	ebx
		push	si
		push	di

		xor	cx,cx
		mov	si,offset pbuff
		mov	ebx,10

epri21d:	xor	edx,edx
		div	ebx
		add	dl,30h
		mov	[si],dl
		inc	si
		inc	cx
		or	eax,eax
		jnz	epri21d

epri22d:	mov	ah,cl
		mov	cl,10
		sub	cl,ah
		push	si
		call	printspc
		pop	si
		mov	cl,ah

epri23d:	dec	si
		mov	al,[si]
		call	putchar
		dec	cx
		jnz	epri23d

		pop	di
		pop	si
		pop	ebx
		pop	edx
		pop	cx
		pop	eax
		ret
eprint2d	endp


;**************************************************************************
;				PRINT2D
; enter:   DX:AX = # to print in decimal
;**************************************************************************
print2d 	proc	near
		push	ax
		push	cx
		push	dx
		push	bx
		push	si
		push	di

		xor	cx,cx
		mov	bx,10
                mov     si,offset pbuff
                mov     di,dx

pri21d: 	inc	cx
		xchg	di,ax
		xor	dx,dx
		div	bx
		xchg	di,ax
		div	bx
		add	dl,30h
		mov	[si],dl
		inc	si
		or	di,di
		jnz	pri21d

pri22d: 	or	ax,ax
		jz	pri23d
		inc	cx
		xor	dx,dx
		div	bx
		add	dl,30h
		mov	[si],dl
		inc	si
		jmp	pri22d

pri23d: 	mov	ah,cl
		mov	cl,10
		sub	cl,ah
		call	printspc
		mov	cl,ah

pri24d: 	dec	si
                mov     al,[si]
		call	putchar
                dec     cx
		jnz	pri24d

		pop	di
		pop	si
		pop	bx
		pop	dx
		pop	cx
		pop	ax
		ret
print2d 	endp


;**************************************************************************
;				 PUTCHAR
; enter:   AL = character to send to STDOUT
;**************************************************************************
putchar         proc    near
		push	ax
		push	cx
		push	dx
		push	bx
		mov	dl,al			 ;get character

		cmp	al,13			 ;CR
		je	putchar1
		cmp	al,10			 ;LF
		je	putchar1

		mov	al,' '                   ;print a space
		mov	ah,9			 ;write a character and
						 ;attribute at cursor positon
		mov	cx,1			 ;# of times
		mov	bh,0			 ;page number
		mov	bl,[attr]		 ;color of attribute
		int	10h

putchar1:	mov	ah,2			 ;write a character to STDOUT
		int	21h
		pop	bx
		pop	dx
		pop	cx
		pop	ax
		ret
putchar         endp


;**************************************************************************
;				 WHATCPU
; return:  AX = 0088h for 8088 cpu
;	   AX = 0286h for 80286 cpu
;	   AX = 0386h for 80386 cpu
;	   AX = 0486h for 80486 cpu
;**************************************************************************
whatcpu 	proc	near
		pushf

		xor	ax,ax
		push	ax
		popf
		pushf
		pop	ax
		and	ax,0f000h
		cmp	ax,0f000h
		je	is_8088

		or	ax,0f000h
		push	ax
		popf
		pushf
		pop	ax
		and	ax,0f000h
		jz	is_80286

		pushfd
		pop	eax
		or	eax,40000h
		push	eax
		popfd
		pushfd
		pop	eax
		and	eax,40000h
		jz	is_80386

is_80486:	mov	ax,486h
		jmp	whatcpu_ret
is_80386:	mov	ax,386h
		jmp	whatcpu_ret
is_80286:       mov     ax,286h
		jmp	whatcpu_ret
is_8088:	mov	ax,88h
whatcpu_ret:	popf
		ret
whatcpu         endp

;--------------------------------------------------------------------------
;				 PRINTS
; enter:   DS:SI = address of string
;--------------------------------------------------------------------------
prints: 	lodsb				 ;load character
		test	al,al			 ;is a NULL
		je	prints_ret		 ;Yes, return
		cmp	al,1			 ;change attr
		jne	prints1
		lodsb				 ;next char is attr color
		mov	[attr],al
		jmp	prints
prints1:	call	putchar
		jmp	prints
prints_ret:	ret


;--------------------------------------------------------------------------
;			       PRINTSPC
; enter:   CL = # of spaces to print
;--------------------------------------------------------------------------
printspc:	mov	ch,0
		mov	al,' '
printspc1:	call	putchar
		loop	printspc1
		ret

align 4
; These tables were created by CRCTABLE.C
crc16_table	label	word
	dw 00000h, 0C0C1h, 0C181h, 00140h, 0C301h, 003C0h, 00280h, 0C241h
	dw 0C601h, 006C0h, 00780h, 0C741h, 00500h, 0C5C1h, 0C481h, 00440h
	dw 0CC01h, 00CC0h, 00D80h, 0CD41h, 00F00h, 0CFC1h, 0CE81h, 00E40h
	dw 00A00h, 0CAC1h, 0CB81h, 00B40h, 0C901h, 009C0h, 00880h, 0C841h
; 20h
	dw 0D801h, 018C0h, 01980h, 0D941h, 01B00h, 0DBC1h, 0DA81h, 01A40h
	dw 01E00h, 0DEC1h, 0DF81h, 01F40h, 0DD01h, 01DC0h, 01C80h, 0DC41h
	dw 01400h, 0D4C1h, 0D581h, 01540h, 0D701h, 017C0h, 01680h, 0D641h
	dw 0D201h, 012C0h, 01380h, 0D341h, 01100h, 0D1C1h, 0D081h, 01040h
; 40h
	dw 0F001h, 030C0h, 03180h, 0F141h, 03300h, 0F3C1h, 0F281h, 03240h
	dw 03600h, 0F6C1h, 0F781h, 03740h, 0F501h, 035C0h, 03480h, 0F441h
	dw 03C00h, 0FCC1h, 0FD81h, 03D40h, 0FF01h, 03FC0h, 03E80h, 0FE41h
	dw 0FA01h, 03AC0h, 03B80h, 0FB41h, 03900h, 0F9C1h, 0F881h, 03840h
; 60h
	dw 02800h, 0E8C1h, 0E981h, 02940h, 0EB01h, 02BC0h, 02A80h, 0EA41h
	dw 0EE01h, 02EC0h, 02F80h, 0EF41h, 02D00h, 0EDC1h, 0EC81h, 02C40h
	dw 0E401h, 024C0h, 02580h, 0E541h, 02700h, 0E7C1h, 0E681h, 02640h
	dw 02200h, 0E2C1h, 0E381h, 02340h, 0E101h, 021C0h, 02080h, 0E041h
; 80h
	dw 0A001h, 060C0h, 06180h, 0A141h, 06300h, 0A3C1h, 0A281h, 06240h
	dw 06600h, 0A6C1h, 0A781h, 06740h, 0A501h, 065C0h, 06480h, 0A441h
	dw 06C00h, 0ACC1h, 0AD81h, 06D40h, 0AF01h, 06FC0h, 06E80h, 0AE41h
	dw 0AA01h, 06AC0h, 06B80h, 0AB41h, 06900h, 0A9C1h, 0A881h, 06840h
; A0h
	dw 07800h, 0B8C1h, 0B981h, 07940h, 0BB01h, 07BC0h, 07A80h, 0BA41h
	dw 0BE01h, 07EC0h, 07F80h, 0BF41h, 07D00h, 0BDC1h, 0BC81h, 07C40h
	dw 0B401h, 074C0h, 07580h, 0B541h, 07700h, 0B7C1h, 0B681h, 07640h
	dw 07200h, 0B2C1h, 0B381h, 07340h, 0B101h, 071C0h, 07080h, 0B041h
; C0h
	dw 05000h, 090C1h, 09181h, 05140h, 09301h, 053C0h, 05280h, 09241h
	dw 09601h, 056C0h, 05780h, 09741h, 05500h, 095C1h, 09481h, 05440h
	dw 09C01h, 05CC0h, 05D80h, 09D41h, 05F00h, 09FC1h, 09E81h, 05E40h
	dw 05A00h, 09AC1h, 09B81h, 05B40h, 09901h, 059C0h, 05880h, 09841h
; E0h
	dw 08801h, 048C0h, 04980h, 08941h, 04B00h, 08BC1h, 08A81h, 04A40h
	dw 04E00h, 08EC1h, 08F81h, 04F40h, 08D01h, 04DC0h, 04C80h, 08C41h
	dw 04400h, 084C1h, 08581h, 04540h, 08701h, 047C0h, 04680h, 08641h
	dw 08201h, 042C0h, 04380h, 08341h, 04100h, 081C1h, 08081h, 04040h

crc32_table	label	dword
	dd 000000000h, 077073096h, 0EE0E612Ch, 0990951BAh
	dd 0076DC419h, 0706AF48Fh, 0E963A535h, 09E6495A3h
	dd 00EDB8832h, 079DCB8A4h, 0E0D5E91Eh, 097D2D988h
	dd 009B64C2Bh, 07EB17CBDh, 0E7B82D07h, 090BF1D91h
; 10h
	dd 01DB71064h, 06AB020F2h, 0F3B97148h, 084BE41DEh
	dd 01ADAD47Dh, 06DDDE4EBh, 0F4D4B551h, 083D385C7h
	dd 0136C9856h, 0646BA8C0h, 0FD62F97Ah, 08A65C9ECh
	dd 014015C4Fh, 063066CD9h, 0FA0F3D63h, 08D080DF5h
; 20h
	dd 03B6E20C8h, 04C69105Eh, 0D56041E4h, 0A2677172h
	dd 03C03E4D1h, 04B04D447h, 0D20D85FDh, 0A50AB56Bh
	dd 035B5A8FAh, 042B2986Ch, 0DBBBC9D6h, 0ACBCF940h
	dd 032D86CE3h, 045DF5C75h, 0DCD60DCFh, 0ABD13D59h
; 30h
	dd 026D930ACh, 051DE003Ah, 0C8D75180h, 0BFD06116h
	dd 021B4F4B5h, 056B3C423h, 0CFBA9599h, 0B8BDA50Fh
	dd 02802B89Eh, 05F058808h, 0C60CD9B2h, 0B10BE924h
	dd 02F6F7C87h, 058684C11h, 0C1611DABh, 0B6662D3Dh
; 40h
	dd 076DC4190h, 001DB7106h, 098D220BCh, 0EFD5102Ah
	dd 071B18589h, 006B6B51Fh, 09FBFE4A5h, 0E8B8D433h
	dd 07807C9A2h, 00F00F934h, 09609A88Eh, 0E10E9818h
	dd 07F6A0DBBh, 0086D3D2Dh, 091646C97h, 0E6635C01h
; 50h
	dd 06B6B51F4h, 01C6C6162h, 0856530D8h, 0F262004Eh
	dd 06C0695EDh, 01B01A57Bh, 08208F4C1h, 0F50FC457h
	dd 065B0D9C6h, 012B7E950h, 08BBEB8EAh, 0FCB9887Ch
	dd 062DD1DDFh, 015DA2D49h, 08CD37CF3h, 0FBD44C65h
; 60h
	dd 04DB26158h, 03AB551CEh, 0A3BC0074h, 0D4BB30E2h
	dd 04ADFA541h, 03DD895D7h, 0A4D1C46Dh, 0D3D6F4FBh
	dd 04369E96Ah, 0346ED9FCh, 0AD678846h, 0DA60B8D0h
	dd 044042D73h, 033031DE5h, 0AA0A4C5Fh, 0DD0D7CC9h
; 70h
	dd 05005713Ch, 0270241AAh, 0BE0B1010h, 0C90C2086h
	dd 05768B525h, 0206F85B3h, 0B966D409h, 0CE61E49Fh
	dd 05EDEF90Eh, 029D9C998h, 0B0D09822h, 0C7D7A8B4h
	dd 059B33D17h, 02EB40D81h, 0B7BD5C3Bh, 0C0BA6CADh
; 80h
	dd 0EDB88320h, 09ABFB3B6h, 003B6E20Ch, 074B1D29Ah
	dd 0EAD54739h, 09DD277AFh, 004DB2615h, 073DC1683h
	dd 0E3630B12h, 094643B84h, 00D6D6A3Eh, 07A6A5AA8h
	dd 0E40ECF0Bh, 09309FF9Dh, 00A00AE27h, 07D079EB1h
; 90h
	dd 0F00F9344h, 08708A3D2h, 01E01F268h, 06906C2FEh
	dd 0F762575Dh, 0806567CBh, 0196C3671h, 06E6B06E7h
	dd 0FED41B76h, 089D32BE0h, 010DA7A5Ah, 067DD4ACCh
	dd 0F9B9DF6Fh, 08EBEEFF9h, 017B7BE43h, 060B08ED5h
; A0h
	dd 0D6D6A3E8h, 0A1D1937Eh, 038D8C2C4h, 04FDFF252h
	dd 0D1BB67F1h, 0A6BC5767h, 03FB506DDh, 048B2364Bh
	dd 0D80D2BDAh, 0AF0A1B4Ch, 036034AF6h, 041047A60h
	dd 0DF60EFC3h, 0A867DF55h, 0316E8EEFh, 04669BE79h
; B0h
	dd 0CB61B38Ch, 0BC66831Ah, 0256FD2A0h, 05268E236h
	dd 0CC0C7795h, 0BB0B4703h, 0220216B9h, 05505262Fh
	dd 0C5BA3BBEh, 0B2BD0B28h, 02BB45A92h, 05CB36A04h
	dd 0C2D7FFA7h, 0B5D0CF31h, 02CD99E8Bh, 05BDEAE1Dh
; C0h
	dd 09B64C2B0h, 0EC63F226h, 0756AA39Ch, 0026D930Ah
	dd 09C0906A9h, 0EB0E363Fh, 072076785h, 005005713h
	dd 095BF4A82h, 0E2B87A14h, 07BB12BAEh, 00CB61B38h
	dd 092D28E9Bh, 0E5D5BE0Dh, 07CDCEFB7h, 00BDBDF21h
; D0h
	dd 086D3D2D4h, 0F1D4E242h, 068DDB3F8h, 01FDA836Eh
	dd 081BE16CDh, 0F6B9265Bh, 06FB077E1h, 018B74777h
	dd 088085AE6h, 0FF0F6A70h, 066063BCAh, 011010B5Ch
	dd 08F659EFFh, 0F862AE69h, 0616BFFD3h, 0166CCF45h
; E0h
	dd 0A00AE278h, 0D70DD2EEh, 04E048354h, 03903B3C2h
	dd 0A7672661h, 0D06016F7h, 04969474Dh, 03E6E77DBh
	dd 0AED16A4Ah, 0D9D65ADCh, 040DF0B66h, 037D83BF0h
	dd 0A9BCAE53h, 0DEBB9EC5h, 047B2CF7Fh, 030B5FFE9h
; F0h
	dd 0BDBDF21Ch, 0CABAC28Ah, 053B39330h, 024B4A3A6h
	dd 0BAD03605h, 0CDD70693h, 054DE5729h, 023D967BFh
	dd 0B3667A2Eh, 0C4614AB8h, 05D681B02h, 02A6F2B94h
	dd 0B40BBE37h, 0C30C8EA1h, 05A05DF1Bh, 02D02EF8Dh

msg0		db	1,15,'CMCRC 1.0  Public Domain by Celso'
		db	' Minnitti, Jr  Feb-06-1994',13,10,0
msg1		db	13,10,'Usage:    CMCRC <filename.ext> (* and ? are OK)'
		db	13,10,0
msg2		db	1,14,'Filename       ',1,10,'Bytes    '
		db	1,11,'CRC-32    ',1,12,'CRC-16  ',1,13,'(CPU ',0
msg3		db	13,10,1,14,'  ',1,10,'  '
		db	1,11,'  '
		db	1,12,'',13,10,0
msg_end 	db	1,7,32,0

msg_err0	db	'File not found',13,10,0
msg_err1	db	'Unable to open file',13,10,0
msg_err2	db	'Error reading file',13,10,0
cpu8088 	db	'8088)',0
cpu80286	db	'80286)',0
cpu80386	db	'80386)',0
cpu80486	db	'80486)',0
crlf            db      13,10,0
attr		db	15

init_crc16	dw	0
init_crc32	dd	-1

amakecrc16      dw      offset emakecrc16
amakecrc32	dw	offset emakecrc32
aprintcrc32	dw	offset eprintcrc32
aprintbytes	dw	offset eprintbytes

cputype 	dw	offset cpu8088
		dw	offset cpu8088
		dw	offset cpu80286
		dw	offset cpu80386
		dw	offset cpu80486

ARGV		equ	$
PBUFF		equ	$+20
BUFFER		equ	$+30

_TEXT	ends
end	start
