






/*	Compiled under TurboC 2.0

	The purpose of this code is to demonstrate how to use the DigiBoard
	DOS driver INT 14h interface in a simple manner.

	This program will monitor the DigiBoard for received data using the DOS
	Driver's Character Ready Flags. If any data is present, it will be fetched
	using INT 14h function 2 and printed to the console. If the User types
	data on the console keyboard, it will be sent to the DigiBoard using
	INT 14h function 1. Press ESC to quit.

	Each DigiBoard channel has a Character Ready Flag stored in the driver's
	memory space. When receive data is present on a given channel, it's flag
	is set to hex FF, otherwise, its set to 0. In order for the flag's value
	to be valid, the DigiBoard must	be configured for an IRQ and the Character
	Ready Flag option must be selected using XIDOSCFG.EXE. The flags location
	can be determined using INT 14h function 0D hex.


*/


#include <dos.h>
#include <stdio.h>

#define		ESC		0x1b
#define		TRUE	1
#define		FALSE	0


struct REGPACK  sregs;
union  REGS		regs;



unsigned char far *get_ch_rdy_ptr(chnl)
int	chnl;
{

/*
	This function returns a far pointer to the Character Ready Flag for the
	channel passed to it as an argument.
*/

	struct SREGS    sregs;

	regs.h.ah = 0x0D;					/* set ah = 0Dh */
	regs.x.dx = chnl;              		/* set channel number */
	int86x(0x14,&regs,&regs,&sregs);	/* make INT 14h call */
										/* return far pointer to flag */
	return(MK_FP(sregs.es,regs.x.bx));

}







data_ready(ptr)
unsigned char far * ptr;
{


/*
	This function takes the character ready flag pointer passed to it and
	returns a value based on the state of the character ready flag.

	If the flag's value is 0FFh, then data is present, and 1 is returned.
	Otherwise, there is no receive data present and 0 is returned.

*/



	if(*ptr == 0xff) return(TRUE);
	else return(FALSE);

}



unsigned char get_data(chnl)
int	chnl;
{


/*

	This function returns data from the specified channel.

*/



	regs.h.ah = 0x02;				/* set ah = 02h */
	regs.x.dx = chnl;				/* set channel number */
	int86(0x14,&regs,&regs);		/* make INT 14h call */
	return(regs.h.al);				/* return character from AL */

}



send_data(chnl,ch)
int		chnl;
char	ch;
{


/*

	This function sends a byte of data to the specified channel.

*/


	regs.h.ah = 0x01;				/* set ah = 01h */
	regs.h.al = ch;					/* set al to send character */
	regs.x.dx = chnl;				/* set channel number */
	int86(0x14,&regs,&regs);		/* make INT 14h call */
}








main()
{

	int	x,dx;
    unsigned char	far *chrdy,ch;


	/* Let the user specify the DigiBoard channel to use. */

	printf("\nEnter DX : ");
	scanf("%d",&dx); while(kbhit()) getch();


	/* get pointer to character ready flag */

	chrdy = get_ch_rdy_ptr(dx);



	/* Look for data to send or receive until the user wants to quit */


	while(1)
	{

		/* Print received data, if there is any. */

		if( data_ready(chrdy) )
		{

			printf("%c",get_data(dx));

		}


		/* If the User enters data, Send It */

		if(kbhit())
		{

			if( (ch = getch()) == ESC) break;	/* The User wants to Quit */
			send_data(dx,ch);					/* Send User's Data */

		}
	}
}
