DECLARE SUB Browse(FileName$,Mouse%,TextColor%,TopRow%,LeftColumn%,BottomRow%,RightColumn%,Attr%,Shadow%,Border%)
DECLARE SUB CalcByte(Attr%,LowByte%,HiByte%)
DECLARE SUB Clicked(Rgt%,Lft%,Row%,Col%)
DECLARE SUB HideCursor()
DECLARE SUB ShowCursor()

SUB HorizontalMenu(Choices$(),Infoline$(),BarSave$,Mouse%,HPointer%,Lotus%,HotKey%,HelpTextColor%,HelpAttr%,BarAttr%,HiAttr%,TopRow%,Gap%,Marker%) PUBLIC

CalcByte HiAttr%,HiFG%,HiBG%
CalcByte BarAttr%,BarFG%,BarBG%

'first we initialize these to zero

i% = 0
j% = 0
Maxlength% = 0

'next we count the choices and set the result to count%

DO

INCR i%
INCR j%

IF LEN(Choices$(i%)) = 0 THEN
  DECR i%
ELSE
  Fixedup$ = REMOVE$(Choices$(i%),"@")
  Maxlength% = Maxlength% + LEN(Fixedup$)
END IF

LOOP WHILE i% = j%

Count% = i%

'here we do a bit of checking to see if the menu bar will fit

IF Maxlength% + ((Gap% * Count%) + Gap%) > 80 THEN
  COLOR 0,7
  LOCATE 12,27,0
  PRINT "Horizontal Menu is too big";
  EXIT SUB
END IF

'I am using the variable Marker to talk between horizontal and
'and vertical menus, if Esc is used to cancel the pulldown in
'the vertical menu, then marker is reset to zero, if marker
'contains a value then SelectionMade is preset to 1, so from
'horizontal menu, Marker carries the cursor position for the
'location of the pulled down menu, and either returns with that
'same value or a reset to zero.

IF Marker% = 0 THEN
  SelectionMade% = 0
  HPointer% = 0
ELSE
  IF Marker% = 99 THEN
    Marker% = 0
  END IF
  SelectionMade% = 1
END IF

IF Lotus% = 1 THEN
  SelectionMade% = 0
END IF

'I test the condition of HPointer to see if the vertical menu has
'changed it's position, the vertical menu can increment or decrement
'the variable HPointer and controls the choice when pulldown is active.

IF Marker% > 0 THEN
  IF HPointer% > Count% THEN
    Pointer% = 1
  ELSEIF HPointer% < 1 THEN
    Pointer% = Count%
  ELSE
    Pointer% = HPointer%
  END IF
ELSE
  IF Lotus% = 1 THEN
    Pointer% = 1
  ELSE
    Pointer% = 0
  END IF
END IF

'just paint a back ground for the horizontal menu

IF Marker% = 0 THEN
  LOCATE TopRow%,1,0
  COLOR BarFG%,BarBG%
  PRINT SPACE$(80);
END IF

PrintRoutine:

'here is the printing routine it will hi light the choice
'made and will optionally print a help text directly
'under the menu bar in a left justifide position. It also
'searches each Choice for the @ character and Hilights the
'character to it's right this then becomes the HotKey for
'that Choice.


DO

IF Mouse% THEN HideCursor

FOR k% = 1 TO Count%             'this looks for the pointer
  IF k% = Pointer% THEN          'and calculates the column
    IF k% > 1 THEN               'to start printing the hi lite
      Total% = 0
      FOR l% = 1 TO (k% - 1)
	INCR Total%,(Gap%)
	Fixedup$ = REMOVE$(Choices$(l%),"@")
	Total% = Total% + LEN(Fixedup$)
      NEXT l%
      Colpos% = Total% + (Gap% + 1)
    ELSE
      Colpos% = Gap% + 1
    END IF
    COLOR HiFG%,HiBG%
    LOCATE TopRow%,Colpos%,0
    PRINT REMOVE$(Choices$(k%),"@");
    Marker% = Colpos%
    HPointer% = Pointer%
    IF LEN(Infoline$(k%)) > 0 THEN   'print the infoline if there's any
      IF SelectionMade% = 0 THEN     'Lotus only from HorzMenu
	COLOR BarFG%,BarBG%
	IF Lotus% = 1 THEN
	  LOCATE TopRow% + 1,1,0
	  PRINT SPACE$(80);
	  LOCATE TopRow% + 1,Gap% + 1,0
	  PRINT Infoline$(k%);
	  InfoLinePrinted% = 1
	END IF
      END IF
    END IF
  ELSE
    IF k% > 1 THEN                      'this determines the column
      Total% = 0                        'position for printing the
      FOR l% = 1 TO (k% - 1)            'rest of the menu
	INCR Total%,(Gap%)
	Fixedup$ = REMOVE$(Choices$(l%),"@")
	Total% = Total% + LEN(Fixedup$)
      NEXT l%
      Colpos% = Total% + (Gap% + 1)
    ELSE
      Colpos% = Gap% + 1
    END IF
    LOCATE TopRow%,Colpos%,0
    IF INSTR(Choices$(k%),"@") > 0 THEN
      HotKeyPos% = INSTR(Choices$(k%),"@")
      Fixedup$ = REMOVE$(Choices$(k%),"@")
      COLOR BarFG%,BarBG%
      PRINT Fixedup$;
      LOCATE TopRow%,Colpos% + (HotKeyPos% - 1),0
      COLOR HotKey%,BarBG%
      HotKey$ = MID$(Choices$(k%),(HotKeyPos% + 1),1)
      PRINT HotKey$;
    ELSE
      COLOR BarFG%,BarBG%
      PRINT Choices$(k%);
    END IF
  END IF
NEXT k%


'This block of code saves the MenuBar with no Choices hilighted
'and then passes the string to VertMenu, so that when a Choice is
'made the MenuBar can be restored, It saves only one line of the
'screen and also calculates the position if MenuBar is on a Row
'other than 1, this allows you to do things like putting current
'path or a clock or something on the line above the MenuBar and
'not messing it up every time the Menu's are run :)

IF Pointer% = 0 THEN
  EndAddress% = TopRow% * 160
  StartAddress% = EndAddress% - 160
  DEF SEG = &HB800
  BarSave$ = PEEK$(StartAddress%,EndAddress%)
END IF

'this is so you can switch through menus that are pulled down,
'it bypasses the inkey and select case loop.

IF SelectionMade% = 1 THEN
  COLOR BarFG%,BarBG%
  IF InfoLinePrinted% = 1 THEN
    IF Lotus% = 1 THEN
      LOCATE TopRow% + 1,1,0
      PRINT SPACE$(80);
    END IF
  END IF
  EXIT SUB
END IF

GetAnotherKey:

WHILE NOT INSTAT
  IF Mouse% THEN
    Rgt% = 0:Lft% = 0:MRow% = 0:MCol% = 0
    ShowCursor
    Clicked Rgt%,Lft%,MRow%,MCol%
    IF Lft% AND MRow% = TopRow% THEN
      FOR m% = 1 TO Count%
        IF m% > 1 THEN
	  Total% = 0
          FOR n% = 1 TO (m% - 1)
	    INCR Total%,(Gap%)
	    Fixedup$ = REMOVE$(Choices$(n%),"@")
	    Total% = Total% + LEN(Fixedup$)
	  NEXT n%
	  Colpos% = Total% + (Gap% + 1)
          Endpos% = Colpos% + LEN(REMOVE$(Choices$(m%),"@")) + (Gap% \ 2) - 1
          Startpos% = Colpos% - (Gap% \ 2) - 1
          IF MCol% >= Startpos% AND MCol% <= Endpos% THEN
            Pointer% = m%
            SelectionMade% = 1
            HideCursor
            GOTO PrintRoutine
          END IF
        ELSE
	  Colpos% = Gap% + 1
          Endpos% = Colpos% + LEN(REMOVE$(Choices$(m%),"@")) + (Gap% \ 2) - 1
          Startpos% = Colpos% - (Gap% \ 2) - 1
          IF MCol% >= Startpos% AND MCol% <= Endpos% THEN
            Pointer% = m%
            SelectionMade% = 1
            HideCursor
            GOTO PrintRoutine
          END IF
        END IF
      NEXT m%
    END IF
  END IF
WEND
Ky$ = INKEY$


IF LEN(Ky$) = 1 THEN
  Chose% = ASC(Ky$)
ELSE
  Chose% = -ASC(RIGHT$(Ky$,1))
END IF

SELECT CASE Chose%

	CASE -16
	  TestKey$ = "Q"
	  GOTO AltKeys
	CASE -17
	  TestKey$ = "W"
	  GOTO AltKeys
	CASE -18
	  TestKey$ = "E"
	  GOTO AltKeys
	CASE -19
	  TestKey$ = "R"
	  GOTO AltKeys
	CASE -20
	  TestKey$ = "T"
	  GOTO AltKeys
	CASE -21
	  TestKey$ = "Y"
	  GOTO AltKeys
	CASE -22
	  TestKey$ = "U"
	  GOTO AltKeys
	CASE -23
	  TestKey$ = "I"
	  GOTO AltKeys
	CASE -24
	  TestKey$ = "O"
	  GOTO AltKeys
	CASE -25
	  TestKey$ = "P"
	  GOTO AltKeys
	CASE -30
	  TestKey$ = "A"
	  GOTO AltKeys
	CASE -31
	  TestKey$ = "S"
	  GOTO AltKeys
	CASE -32
	  TestKey$ = "D"
	  GOTO AltKeys
	CASE -33
	  TestKey$ = "F"
	  GOTO AltKeys
	CASE -34
	  TestKey$ = "G"
	  GOTO AltKeys
	CASE -35
	  TestKey$ = "H"
	  GOTO AltKeys
	CASE -36
	  TestKey$ = "J"
	  GOTO AltKeys
	CASE -37
	  TestKey$ = "K"
	  GOTO AltKeys
	CASE -38
	  TestKey$ = "L"
	  GOTO AltKeys
	CASE -44
	  TestKey$ = "Z"
	  GOTO AltKeys
	CASE -45
	  TestKey$ = "X"
	  GOTO AltKeys
	CASE -46
	  TestKey$ = "C"
	  GOTO AltKeys
	CASE -47
	  TestKey$ = "V"
	  GOTO AltKeys
	CASE -48
	  TestKey$ = "B"
	  GOTO AltKeys
	CASE -49
	  TestKey$ = "N"
	  GOTO AltKeys
	CASE -50
	  TestKey$ = "M"
	  GOTO AltKeys
	CASE -59  ' F1 Help key
          IF Pointer% > 0 THEN
            IF LEN(REMOVE$(Choices$(Pointer%),ANY "@ ")) > 8 THEN
              FileName$ = LEFT$(UCASE$(REMOVE$(Choices$(Pointer%),ANY "@ ")),8) + ".HLP"
            ELSE
              FileName$ = UCASE$(REMOVE$(Choices$(Pointer%),ANY "@ ")) + ".HLP"
            END IF
            IF Mouse% THEN HideCursor
            BROWSE FileName$,Mouse%,HelpTextColor%,7,16,18,64,HelpAttr%,Shadow%,Border%
          ELSE
            BEEP
          END IF
	CASE -75 'left arrow        'move through menus and wrap around
	  IF Pointer% > 0 THEN
	    IF Pointer% > 1 THEN      'if Pointer is greater than Count
	      DECR Pointer%
	    ELSE
	      Pointer% = Count%
	    END IF
	  ELSE
	    BEEP
	  END IF
	CASE -77 'right arrow        'move through menus and wrap around
	  IF Pointer% > 0 THEN
	    IF Pointer% < Count% THEN  'if Pointer is greater than Count
	      INCR Pointer%
	    ELSE
	      Pointer% = 1
	    END IF
	  ELSE
	    BEEP
	  END IF
	CASE 13  'enter key           'you can only use integers
	  IF Pointer% = 0 THEN        'on exit from horizontal menu
	    BEEP
	  ELSE
	    SelectionMade% = 1
	  END IF
	CASE 27  'Esc key
	  IF Lotus% = 1 THEN        'you may want to use this to exit
	    SelectionMade% = 1
	  ELSE
	    Pointer% = 0
	    Marker% = 0
	    HPointer% = Pointer%
	    SelectionMade% = 1
	    GOTO PrintRoutine
	  END IF
	CASE ELSE
	  BEEP
END SELECT

LOOP UNTIL SelectionMade% = 1

AltKeys:

FOR m% = 1 TO Count%
  IF INSTR(Choices$(m%),"@") > 0 THEN
    HotKeyPos% = INSTR(Choices$(m%),"@")
    HotKey$ = UCASE$(MID$(Choices$(m%),(HotKeyPos% + 1),1))
    IF HotKey$ = TestKey$ THEN
      Pointer% = m%
      SelectionMade% = 1
      IF m% > 1 THEN
	Total% = 0
	FOR n% = 1 TO (m% - 1)
	  INCR Total%,(Gap%)
	  Fixedup$ = REMOVE$(Choices$(n%),"@")
	  Total% = Total% + LEN(Fixedup$)
	NEXT n%
	Colpos% = Total% + (Gap% + 1)
      ELSE
	Colpos% = Gap% + 1
      END IF
      GOTO PrintRoutine
    END IF
  ELSE
    GOTO GetAnotherKey
  END IF
NEXT m%

COLOR BarFG%,BarBG%

IF InfoLinePrinted% = 1 THEN
  IF Lotus% = 1 THEN
    LOCATE TopRow% + 1,1,0
    PRINT SPACE$(80);
  END IF
END IF

END SUB