DECLARE SUB LineEdit(Allow$,Text$,Mouse%,MouseRow%,MouseCol%,Fill%,Row%,Col%,EditKey%,Attr%)
DECLARE SUB Popwind(Title$,Toprow%,Leftcolumn%,Bottomrow%,Rightcolumn%,Attr%,Shadow%,Border%)
DECLARE SUB Dialog(Choices$(),Title$,Mouse%,Cntr%,TopRow%,LeftColumn%,TxtColor%,Attr%,Shadow%,Border%)
DECLARE SUB RestoreScreen(ScreenID$,TopRow%,LeftColumn%)
DECLARE SUB SaveScreen(ScreenID$,TopRow%,LeftColumn%,BottomRow%,RightColumn%,Shadow%)
DECLARE SUB CalcByte(Attr%,LowByte%,HiByte%)
DECLARE SUB Clicked(Rgt%,Lft%,Row%,Col%)
DECLARE SUB HideCursor()
DECLARE SUB ShowCursor()
DECLARE FUNCTION LeftButtonReleased%()

SUB DirectoryBox(ReturnedFile$,Mouse%,Attr%,BarAttr%,ButtonAttr%,Shadow%,Border%)PUBLIC

DIM Directory$(1:100)
DIM FileName$(1:999)
DIM Message$(2)

ON LOCAL ERROR GOTO ErrorHandle

Allow$ = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890_^$~!{}()@'`*.\:"
FileMask$ = "*.*"

CalcByte Attr%,FGround%,BGround%
CalcByte ButtonAttr%,BtFG%,BtBG%
CalcByte BarAttr%,BarFG%,BarBG%

IF Mouse% THEN HideCursor

SaveScreen DirScreen$,4,9,21,71,1

Popwind Title$,4,9,21,71,Attr%,Shadow%,Border%
Popwind Title$,8,11,17,54,Attr%,0,1
Popwind Title$,8,58,17,69,Attr%,0,1

IF Mouse% THEN
  COLOR FGround%,BGround%
  LOCATE 4,11,0
  PRINT CHR$(91,254,93);
END IF

Row% = 19:Col% = 13

COLOR BtFG%,BGround%
LOCATE 6,11,0
PRINT "File Name:";

COLOR BtFG%,BtBG%
LOCATE Row%, Col%,0
PRINT " Open ";
COLOR 0,BGround%
LOCATE Row%, Col% + 6,0
PRINT "";
COLOR 0,BGround%
LOCATE Row% + 1,Col% + 1,0
PRINT "";

COLOR BtFG%,BtBG%
LOCATE Row%,Col% + 11,0
PRINT " Esc ";
COLOR 0,BGround%
LOCATE Row%,Col% + 16,0
PRINT "";
COLOR 0,BGround%
LOCATE Row% + 1,Col% + 12,0
PRINT ""

IF RIGHT$(CURDIR$,1) = "\" THEN  'make sure there is a back slash
  Current$ = CURDIR$ + "*.*"
ELSE
  Current$ = CURDIR$ + CHR$(92) + "*.*"
END IF

DO

IF DirCount% THEN          'empty out the array
  FOR i% = 1 TO DirCount%
    Directory$(i%) = ""
  NEXT i%
END IF

IF FileCount% THEN         'empty out the array
  FOR i% = 1 TO FileCount%
    FileName$(i%) = ""
  NEXT i%
END IF

FOR i% = 1 TO LEN(Current$)      'get the path, need this when testing ATTRIB
  Test$ = RIGHT$(Current$,i%)
  IF LEFT$(Test$,1) = CHR$(92) THEN
    Path$ = LEFT$(Current$,LEN(Current$) - (i% - 1))
    EXIT FOR
  END IF
NEXT i%

i% = 1

 DirName$ = DIR$(Path$ + "*.*",16)   'get directorys and put them in an array
 x% = ATTRIB(Path$ + DirName$)
 IF x% = 16 THEN Directory$(i%) = DirName$

   DO
     DirName$ = DIR$
     IF LEN(DirName$) THEN
       x% = ATTRIB(Path$ + DirName$)
       IF x% = 16 THEN
         INCR i%
         Directory$(i%) = DirName$
       END IF
     END IF
   LOOP WHILE LEN(DirName$)

IF LEN(Path$) > 3 THEN
  IF LEN(Directory$(i%)) THEN
    INCR i%
    Directory$(i%) = ".."
  ELSE
    Directory$(i%) = ".."
  END IF
END IF

DirCount% = i%      'keep a count of directorys

ARRAY SORT Directory$(1) FOR DirCount%     'sort them A - Z

i% = 1

 TName$ = DIR$(Current$)     'get filenames and put them in an array
 FileName$(i%) = TName$
 DO
   TName$ = DIR$
   INCR i%
   FileName$(i%) = TName$
 LOOP WHILE LEN(TName$)

FileCount% = i% - 1       'keep a count of files

ARRAY SORT FileName$(1) FOR FileCount%    'sort them A - Z

DirStart% = 1:DirFinish% = 8:DirPointer% = 0  'initialize these
FileStart% = 1:FileFinish% = 24

DO

MouseJumpToRepaintLoop:

IF OldFilePointer% THEN       'keep track of pointer
  FilePointer% = OldFilePointer%
ELSE
  FilePointer% = 1
END IF

DO

MouseJumpToFilesLoop:

IF Mouse% THEN HideCursor

GOSUB PrintDirs
GOSUB PrintFiles

Current$ = Path$ + FileMask$     'display the full path and file name
IF LEN(Current$) < 48 THEN       'of the selected item
  Add% = 48 - LEN(Current$)
  Current$ = Current$ + SPACE$(Add%)
END IF

Current$ = UCASE$(Current$)    'force upper case

Editkey% = 255  'this causes LineEdit to print and exit

LineEdit Allow$,Current$,Mouse%,MouseRow%,MouseCol%,176,6,22,EditKey%,Attr%

WHILE NOT INSTAT
  IF Mouse% THEN
    ShowCursor
    Rgt% = 0:Lft% = 0:MRow% = 0:MCol% = 0
    Clicked Rgt%,Lft%,MRow%,MCol%
    IF Lft% AND MRow% > 8 AND MRow% < 17 THEN
      SELECT CASE MCol%
        CASE 13 TO 24  'first row
          IF FilePointer% = FileStart% + MRow% - 9 THEN
            IF LeftButtonReleased% THEN
              Chose% = 13:GOTO MouseJumpToMainKeyBoard
            END IF
          ELSE
            IF FileStart% + MRow% - 9 <= FileCount% THEN
              FilePointer% = FileStart% + MRow% - 9
              GOTO MouseJumpToFilesLoop
            END IF
          END IF
        CASE 27 TO 38  'second row
          IF FilePointer% = FileStart% + 8 + MRow% - 9 THEN
            IF LeftButtonReleased% THEN
              Chose% = 13:GOTO MouseJumpToMainKeyBoard
            END IF
          ELSE
            IF FileStart% + 8 + MRow% - 9 <= FileCount% THEN
              FilePointer% = FileStart% + 8 + MRow% - 9
              GOTO MouseJumpToFilesLoop
            END IF
          END IF
        CASE 41 TO 52  'third row
          IF FilePointer% = FileStart% + 16 + MRow% - 9 THEN
            IF LeftButtonReleased% THEN
              Chose% = 13:GOTO MouseJumpToMainKeyBoard
            END IF
          ELSE
            IF FileStart% + 16 + MRow% - 9 <= FileCount% THEN
              FilePointer% = FileStart% + 16 + MRow% - 9
              GOTO MouseJumpToFilesLoop
            END IF
          END IF
        CASE 59 TO 68  'dirs
          IF DirStart% + MRow% - 9 <= DirCount% THEN
            DirPointer% = DirStart% + MRow% - 9
            OldFilePointer% = FilePointer%
            FilePointer% = 0
            HideCursor
            GOSUB PrintFiles
            GOTO MouseJumpToDirLoop
          END IF
        CASE 69 TO 70  'jump to Dirs mouse scroll bar
          IF LeftButtonReleased% THEN
            OldFilePointer% = FilePointer%
            FilePointer% = 0
            HideCursor
            GOSUB PrintFiles
            GOTO MouseJumpToDirs
          END IF
      END SELECT
    ELSE
      IF Lft% AND MCol% > 11 AND MCol% < 71 THEN
        SELECT CASE MRow%
          CASE 4  'Esc box
            IF MCol% = 12 AND LeftButtonReleased% THEN
              Chose% = 27:GOTO MouseJumpToMainKeyBoard
            END IF
          CASE 6  'line editor
            IF MCol% > 21 AND MCol% < 71 AND LeftButtonReleased% THEN
              OldFilePointer% = FilePointer%
              FilePointer% = 0
              HideCursor
              GOSUB PRINTFILES
              GOTO MouseJumpToEditRoutine
            END IF
          CASE 17  'mouse scroll bars if less than 24 files +/- pointer else pageup/down
            SELECT CASE MCol%
              CASE 28 TO 29   'mouse scroll right
                IF FileCount% < 25 THEN
                  IF LeftButtonReleased% THEN
                    Chose% = -72:GOTO MouseJumpToMainKeyBoard
                  END IF
                ELSE
                  IF LeftButtonReleased% THEN
                    Chose% = -73:GOTO MouseJumpToMainKeyBoard
                  END IF
                END IF
              CASE 52 TO 53  'mouse scroll left
                IF FileCount% < 25 THEN
                  IF LeftButtonReleased% THEN
                    Chose% = -80:GOTO MouseJumpToMainKeyBoard
                  END IF
                ELSE
                  IF LeftButtonReleased% THEN
                    Chose% = -81:GOTO MouseJumpToMainKeyBoard
                  END IF
                END IF
            END SELECT
          CASE 19
            SELECT CASE MCol%
              CASE 13 TO 18  'Open button
                IF LeftButtonReleased% THEN
                  Chose% = 13:GOTO MouseJumpToMainKeyBoard
                END IF
              CASE 24 TO 28  'Esc button
                IF LeftButtonReleased% THEN
                  Chose% = 27:GOTO MouseJumpToMainKeyBoard
                END IF
            END SELECT
        END SELECT
      END IF
    END IF
  END IF
WEND
Ky$ = INKEY$

IF LEN(Ky$) = 1 THEN
  Chose% = ASC(Ky$)
ELSE
  Chose% = -ASC(RIGHT$(Ky$,1))
END IF

MouseJumpToMainKeyBoard:

  SELECT CASE Chose%

       CASE -71 ' home
         IF FileCount% < 24 THEN
           FilePointer% = 1
         ELSE
           FilePointer% = 1
           FileStart% = 1
           FileFinish% = 24
         END IF
       CASE -72 ' up arrow
         IF FilePointer% > 1 THEN
           DECR FilePointer%
           IF FilePointer% < FileStart% THEN
             DECR FileStart%:DECR FileFinish%
           END IF
         END IF
       CASE -73 ' page up
         IF FilePointer% - 24 > 0 THEN
           IF FileStart% - 24 > 0 THEN
             DECR FilePointer%,24
             DECR FileStart%,24
             DECR FileFinish%,24
           ELSE
             DECR FilePointer%,24
             FileStart% = 1
             FileFinish% = 24
           END IF
         ELSE
           FileStart% = 1
           FileFinish% = 24
         END IF
       CASE -75 ' left arrow
         IF FilePointer% - 8 > 0 THEN
           DECR FilePointer%,8
           IF FilePointer% < FileStart% THEN
             IF FileStart% - 8 > 0 THEN
               DECR FileStart%,8:DECR FileFinish%,8
             ELSE
               FileStart% = 1
               FileFinish% = 24
             END IF
           END IF
         ELSE
           IF FileCount% > 24 THEN
             FileStart% = 1
             FileFinish% = 24
           END IF
         END IF
       CASE -77 ' right arrow
         IF FilePointer% + 8 <= FileCount% THEN
           INCR FilePointer%,8
           IF FilePointer% > FileFinish% THEN
             IF FileFinish% + 8 < FileCount% THEN
               INCR FileStart%,8:INCR FileFinish%,8
             ELSE
               FileFinish% = FileCount%
               FileStart% = FileFinish% - 23
             END IF
           END IF
         ELSE
           IF FileCount% > 24 THEN
             FileFinish% = FileCount%
             FileStart% = FileFinish% - 23
           END IF
         END IF
       CASE -79 ' end key
         IF FileCount% < 24 THEN
           FilePointer% = FileCount%
         ELSE
           FilePointer% = FileCount%
           FileStart% = FileCount% - 23
           FileFinish% = FileCount%
         END IF
       CASE -80 ' down arrow
         IF FilePointer% < FileCount% THEN
           INCR FilePointer%
           IF FilePointer% > FileFinish% THEN
             INCR FileStart%:INCR FileFinish%
           END IF
         END IF
       CASE -81 ' page down
         IF FileCount% > 24 THEN
           IF FilePointer% + 24 <= FileCount% THEN
             IF FileFinish% + 24 <= FileCount% THEN
               INCR FilePointer%,24
               INCR FileStart%,24
               INCR FileFinish%,24
             ELSE
               INCR FilePointer%,24
               FileFinish% = FileCount%
               FileStart% = FileFinish% - 23
             END IF
           ELSE
             FileFinish% = FileCount%
             FileStart% = FileFinish% - 23
           END IF
         END IF
       CASE 9   ' tab key
         OldFilePointer% = FilePointer%
         FilePointer% = 0
         GOSUB PrintFiles
         MouseJumpToDirs:
         IF OldDirPointer% THEN
           DirPointer% = OldDirPointer%
         ELSE
           DirPointer% = 1
         END IF
                         DO
                           MouseJumpToDirLoop:
                           IF Mouse% THEN HideCursor
                           GOSUB PrintDirs

                           WHILE NOT INSTAT
                             IF Mouse% THEN
                               ShowCursor
                               Rgt% = 0:Lft% = 0:MRow% = 0:MCol% = 0
                               Clicked Rgt%,Lft%,MRow%,MCol%
                               IF Lft% AND MRow% > 8 AND MRow% < 17 THEN
                                 SELECT CASE MCol%
                                   CASE 13 TO 24  'first row
                                     IF FileStart% + MRow% - 9 <= FileCount% THEN
                                       FilePointer% = FileStart% + MRow% - 9
                                       OldDirPointer% = DirPointer%
                                       DirPointer% = 0
                                       GOTO MouseJumpToFilesLoop
                                     END IF
                                   CASE 27 TO 38  'second row
                                     IF FileStart% + 8 + MRow% - 9 <= FileCount% THEN
                                       FilePointer% = FileStart% + 8 + MRow% - 9
                                       OldDirPointer% = DirPointer%
                                       DirPointer% = 0
                                       GOTO MouseJumpToFilesLoop
                                     END IF
                                   CASE 41 TO 52  'third row
                                     IF FileStart% + 16 + MRow% - 9 <= FileCount% THEN
                                       FilePointer% = FileStart% + 16 + MRow% - 9
                                       OldDirPointer% = DirPointer%
                                       DirPointer% = 0
                                       GOTO MouseJumpToFilesLoop
                                     END IF
                                   CASE 59 TO 68  'dirs
                                     IF DirPointer% = DirStart% + MRow% - 9 THEN
                                       IF LeftButtonReleased% THEN
                                         Chose% = 13:GOTO MouseJumpToSubKeyBoard
                                       END IF
                                     ELSE
                                       IF DirStart% + MRow% - 9 <= DirCount% THEN
                                         DirPointer% = DirStart% + MRow% - 9
                                         GOTO MouseJumpToDirLoop
                                       END IF
                                     END IF
                                   CASE 69  'Dirs mouse scrollbars
                                     SELECT CASE MRow%
                                       CASE 9
                                         IF LeftButtonReleased% THEN
                                           Chose% = -72:GOTO MouseJumpToSubKeyBoard
                                         END IF
                                       CASE 16
                                         IF LeftButtonReleased% THEN
                                           Chose% = -80:GOTO MouseJumpToSubKeyBoard
                                         END IF
                                     END SELECT
                                   END SELECT
                                 ELSE
                                   IF Lft% AND MCol% > 11 AND MCol% < 71 THEN
                                     SELECT CASE MRow%
                                       CASE 4  'Esc box
                                         IF MCol% = 12 AND LeftButtonReleased% THEN
                                           Chose% = 27:GOTO MouseJumpToMainKeyBoard
                                         END IF
                                       CASE 6  'line editor
                                         IF MCol% > 21 AND MCol% < 71 AND LeftButtonReleased% THEN
                                           OldDirPointer% = DirPointer%
                                           DirPointer% = 0
                                           HideCursor
                                           GOSUB PrintDirs
                                           GOTO MouseJumpToEditRoutine
                                         END IF
                                       CASE 17  'jump to files mouse bar
                                         IF MCol% > 28 AND MCol% < 53 THEN
                                           IF LeftButtonReleased% THEN
                                             OldDirPointer% = DirPointer%
                                             DirPointer% = 0
                                             GOTO MouseJumpToRepaintLoop
                                           END IF
                                         END IF
                                       CASE 19
                                         SELECT CASE MCol%
                                           CASE 13 TO 18  'Open button
                                             IF LeftButtonReleased% THEN
                                               Chose% = 13:GOTO MouseJumpToSubKeyBoard
                                             END IF
                                           CASE 24 TO 28  'Esc button
                                             IF LeftButtonReleased% THEN
                                               Chose% = 27:GOTO MouseJumpToMainKeyBoard
                                             END IF
                                         END SELECT
                                     END SELECT
                                   END IF
                                 END IF
                               END IF
                           WEND
                           Ky$ = INKEY$

                           IF LEN(Ky$) = 1 THEN
                             Chose% = ASC(Ky$)
                           ELSE
                             Chose% = -ASC(RIGHT$(Ky$,1))
                           END IF

                           MouseJumpToSubKeyBoard:
                           SELECT CASE Chose%

                             CASE -71 ' home
                               IF DirCount% > 8 THEN
                                 DirPointer% = 1
                                 DirFinish% = 8
                                 DirStart% = 1
                               ELSE
                                 DirPointer% = 1
                               END IF
                             CASE -72 ' up arrow
                               IF DirPointer% > 1 THEN
                                 DECR DirPointer%
                                 IF DirPointer% < DirStart% THEN
                                   DECR DirStart%:DECR DirFinish%
                                 END IF
                               END IF
                             CASE -79 ' end key
                               IF DirCount% > 8 THEN
                                 DirPointer% = DirCount%
                                 DirFinish% = DirCount%
                                 DirStart% = DirFinish% - 7
                               ELSE
                                 DirPointer% = DirCount%
                               END IF
                             CASE -80 ' down arrow
                               IF DirPointer% < DirCount% THEN
                                 INCR DirPointer%
                                 IF DirPointer% > DirFinish% THEN
                                   INCR DirStart%:INCR DirFinish%
                                 END IF
                               END IF
                             CASE 9   ' tab key
                               OldDirPointer% = DirPointer%
                               DirPointer% = 0
                               GOSUB PrintDirs
                               MouseJumpToEditRoutine:
                               EditLoop:
                               Editkey% = 0
                               LineEdit Allow$,Current$,Mouse%,MouseRow%,MouseCol%,176,6,22,EditKey%,BarAttr%
                               SELECT CASE Editkey%
                                 CASE -255  'exit was with mouse
                                   IF MouseRow% > 8 AND MouseRow% < 17 THEN
                                     SELECT CASE MouseCol%
                                       CASE 13 TO 24  'first row
                                         IF FileStart% + MouseRow% - 9 <= FileCount% THEN
                                           FilePointer% = FileStart% + MouseRow% - 9
                                         ELSE
                                           FilePointer% = FileCount%
                                         END IF
                                           GOTO MouseJumpToFilesLoop
                                      CASE 27 TO 38  'second row
                                        IF FileStart% + 8 + MouseRow% - 9 <= FileCount% THEN
                                          FilePointer% = FileStart% + 8 + MouseRow% - 9
                                        ELSE
                                          FilePointer% = FileCount%
                                        END IF
                                          GOTO MouseJumpToFilesLoop
                                      CASE 41 TO 52  'third row
                                        IF FileStart% + 16 + MouseRow% - 9 <= FileCount% THEN
                                          FilePointer% = FileStart% + 16 + MouseRow% - 9
                                        ELSE
                                          FilePointer% = FileCount%
                                        END IF
                                          GOTO MouseJumpToFilesLoop
                                      CASE 59 TO 68  'dirs
                                        IF DirStart% + MouseRow% - 9 <= DirCount% THEN
                                          DirPointer% = DirStart% + MouseRow% - 9
                                        ELSE
                                          DirPointer% = DirCount%
                                        END IF
                                          Current$ = UCASE$(Current$)
                                          Editkey% = 255
                                          LineEdit Allow$,Current$,Mouse%,MouseRow%,MouseCol%,176,6,22,EditKey%,Attr%
                                          GOTO MouseJumpToDirLoop
                                      CASE 69 TO 70  'jump to Dirs mouse scroll bar
                                           Current$ = UCASE$(Current$)
                                           Editkey% = 255
                                           LineEdit Allow$,Current$,Mouse%,MouseRow%,MouseCol%,176,6,22,EditKey%,Attr%
                                           GOTO MouseJumpToDirs
                                      CASE ELSE
                                        GOTO EditLoop
                                     END SELECT
                                   ELSE
                                     IF MouseCol% > 11 AND MouseCol% < 71 THEN
                                       SELECT CASE MouseRow%
                                         CASE 4  'Esc box
                                           IF MouseCol% = 12 THEN
                                             Chose% = 27:GOTO MouseJumpToMainKeyBoard
                                           END IF
                                         CASE 6
                                           ReturnedFile$ = RTRIM$(Current$)
                                           Editkey% = 13
                                           EXIT,EXIT,EXIT,EXIT
                                         CASE 17
                                           IF MouseCol% > 28 AND MouseCol% < 53 THEN
                                               GOTO MouseJumpToRepaintLoop
                                           END IF
                                         CASE 19
                                           SELECT CASE MouseCol%
                                             CASE 13 TO 18  'Open button
                                               Chose% = 13:GOTO MouseJumpToMainKeyBoard
                                             CASE 24 TO 28  'Esc button
                                               Chose% = 27:GOTO MouseJumpToMainKeyBoard
                                           END SELECT
                                       END SELECT
                                     END IF
                                     GOTO EditLoop
                                   END IF
                                 CASE 13
                                   Current$ = RTRIM$(Current$)
                                   OldDirPointer% = 0
                                   OldFilePointer% = 0
                                   EXIT,EXIT,EXIT
                                 CASE 27
                                   ReturnedFile$ = ""
                                   Editkey% = 27
                                   EXIT,EXIT,EXIT,EXIT 'I'm outer here
                                 CASE ELSE
                                   EXIT,EXIT
                               END SELECT
                             CASE 13  ' enter
                               IF Directory$(DirPointer%) = ".." THEN
                                 Path$ = RTRIM$(Path$,CHR$(92))
                                 FOR i% = 1 TO LEN(Path$)
                                   Test$ = RIGHT$(Path$,i%)
                                   IF LEFT$(Test$,1) = CHR$(92) THEN
                                     Current$ = LEFT$(Path$,LEN(Path$) - (i% - 1))
                                     EXIT FOR
                                   END IF
                                 NEXT i%
                               ELSE
                                 Current$ = Path$ + Directory$(DirPointer%) + CHR$(92)
                               END IF
                               OldDirPointer% = 0
                               OldFilePointer% = 0
                               EXIT,EXIT,EXIT
                             CASE 27  ' Esc
                               ReturnedFile$ = ""
                               Editkey% = 27
                               EXIT,EXIT,EXIT,EXIT 'I'm outer here
                             CASE ELSE
                               BEEP
                           END SELECT

                          LOOP


       CASE 13  ' enter
         ReturnedFile$ = RTRIM$(Current$)
         Editkey% = 13
         EXIT,EXIT,EXIT
       CASE 27  ' Esc
         ReturnedFile$ = ""
         Editkey% = 27
         EXIT,EXIT,EXIT
       CASE ELSE
         BEEP

  END SELECT

LOOP

LOOP

LOOP

Row% = 19:Col% = 13

SELECT CASE Editkey%

	CASE 13 'Ok
          IF Mouse% THEN HideCursor
          COLOR FGround%,BGround%
          LOCATE Row%,Col%,0
          PRINT " ";
          LOCATE Row% + 1,Col% + 1,0
          PRINT "      ";
	  COLOR BtFG%,BtBG%
          LOCATE Row%,Col% + 1,0
          PRINT " Open "

	CASE 27 'Esc
          IF Mouse% THEN HideCursor
          COLOR FGround%,BGround%
          LOCATE Row%,Col% + 11,0
          PRINT " ";
          LOCATE Row% + 1,Col% + 12,0
          PRINT "      ";
	  COLOR BtFG%,BtBG%
          LOCATE Row%,Col% + 12,0
          PRINT " Esc "

END SELECT

IF Mouse% THEN ShowCursor
DELAY .5
IF Mouse% THEN HideCursor
RestoreScreen DirScreen$,4,9

EXIT SUB

PrintFiles:
Row% = 9
Col% = 12

FOR a% = FileStart% TO FileFinish%
  IF a% = FileStart% + 8 OR a% = FileStart% + 16 THEN Row% = 9:INCR Col%,14
    IF a% = FilePointer% THEN
      FileMask$ = FileName$(a%)
      COLOR BarFG%,BarBG%
      LOCATE Row%,Col%,0
      PRINT SPACE$(1) + FileName$(a%) + SPACE$(13 - LEN(FileName$(a%)));
    ELSE
      COLOR FGround%,BGround%
      LOCATE Row%,Col%,0
      PRINT SPACE$(1) + FileName$(a%) + SPACE$(13 - LEN(FileName$(a%)));
    END IF
    INCR Row%
  NEXT a%

FileScrollBar% = FileCount% \ 22
IF FileScrollBar% < 1 THEN FileScrollBar% = 1
Bar% = 0
Col% = 29

IF FilePointer% THEN
  ScrollFilePointer% = FilePointer%
ELSEIF OldFilePointer% THEN
  ScrollFilePointer% = OldFilePointer%
ELSE
  ScrollFilePointer% = 1
END IF

COLOR FGround%,BGround%
LOCATE 17,13,0
PRINT "            ";
COLOR BtFG%,BGround%
LOCATE 17,14,0
PRINT ScrollFilePointer%; "of"; FileCount%;

FOR a% = FileStart% TO FileFinish%
  COLOR FGround%,BGround%
  LOCATE 17,Col%,0
  IF a% = FileStart% THEN
    PRINT CHR$(27);
  ELSEIF a% = FileFinish% THEN
    PRINT CHR$(26);
  ELSE
    IF Bar% =  0 THEN
      c% = ScrollFilePointer%
      FOR i% = 1 TO FileScrollBar%
        b% = c% \ FileScrollBar%
        IF a% = b% + FileStart% THEN
          Bar% = 1
          EXIT FOR
        ELSE
          INCR c%
        END IF
      NEXT i%
      IF Bar%  THEN
	PRINT CHR$(219);
      ELSE
        IF Bar% = 0 AND a% = FileFinish% - 1 THEN
          PRINT CHR$(219);
        ELSE
          PRINT CHR$(176);
        END IF
      END IF
    ELSE
      PRINT CHR$(176);
    END IF
  END IF
  INCR Col%
NEXT a%

RETURN

PrintDirs:

DirScrollBar% = DirCount% \ 6
Bar% = 0
Row% = 9
Col% = 59

IF DirPointer% THEN
  ScrollDirPointer% = DirPointer%
ELSEIF OldDirPointer% THEN
  ScrollDirPointer% = OldDirPointer%
ELSE
  ScrollDirPointer% = 1
END IF

FOR a% = DirStart% TO DirFinish%
  IF a% = DirPointer% THEN
    COLOR BarFG%,BarBG%
    LOCATE Row%,Col%,0
    PRINT SPACE$(1) + Directory$(a%) + SPACE$(9 - LEN(Directory$(a%)));
  ELSE
    COLOR FGround%,BGround%
    LOCATE Row%,Col%,0
    PRINT SPACE$(1) + Directory$(a%) + SPACE$(9 - LEN(Directory$(a%)));
  END IF
  COLOR FGround%,BGround%
  LOCATE Row%,69,0
  IF a% = DirStart% THEN
    PRINT CHR$(24);
  ELSEIF a% = DirFinish% THEN
    PRINT CHR$(25);
  ELSE
    IF Bar% =  0 THEN
      c% = ScrollDirPointer%
      FOR i% = 1 TO DirScrollBar%
        b% = c% \ DirScrollBar%
        IF a% = b% + DirStart% THEN
          Bar% = 1
          EXIT FOR
        ELSE
          INCR c%
        END IF
      NEXT i%
      IF Bar%  THEN
	PRINT CHR$(219);
      ELSE
        IF Bar% = 0 AND a% = DirFinish% - 1 THEN
          PRINT CHR$(219);
        ELSE
          PRINT CHR$(176);
        END IF
      END IF
    ELSE
      PRINT CHR$(176);
    END IF
  END IF
  INCR Row%
NEXT a%

RETURN

ErrorHandle:

  SELECT CASE ERR

    CASE 71
      Message$(1) = "  Disk Drive not Ready  "
    CASE 76
      Message$(1) = "  Path or File not Found  "

  END SELECT

  Dialog Message$(),"Error",Mouse%,3,0,0,BarFG%,ButtonAttr%,Shadow%,Border%

RESUME NEXT

END SUB