/*
 * standard jrevdct but I have reversed rows and columns for easier
	changes to follow
 */


/*
 * jrevdct.c
 *
 * Copyright (C) 1991, 1992, Thomas G. Lane.
 * This file is part of the Independent JPEG Group's software.
 * For conditions of distribution and use, see the accompanying README file.
 *
 * This file contains the basic inverse-DCT transformation subroutine.
 *
 * This implementation is based on an algorithm described in
 *   C. Loeffler, A. Ligtenberg and G. Moschytz, "Practical Fast 1-D DCT
 *   Algorithms with 11 Multiplications", Proc. Int'l. Conf. on Acoustics,
 *   Speech, and Signal Processing 1989 (ICASSP '89), pp. 988-991.
 * The primary algorithm described there uses 11 multiplies and 29 adds.
 * We use their alternate method with 12 multiplies and 32 adds.
 * The advantage of this method is that no data path contains more than one
 * multiplication; this allows a very simple and accurate implementation in
 * scaled fixed-point arithmetic, with a minimal number of shifts.
 */

#include "jinclude.h"

/*
 * This routine is specialized to the case DCTSIZE = 8.
 */

#if DCTSIZE != 8
  Sorry, this code only copes with 8x8 DCTs. /* deliberate syntax err */
#endif

int elemptr;
JSAMPLE *range_limit;
JSAMPARRAY srowptr;

/*
 * A 2-D IDCT can be done by 1-D IDCT on each row followed by 1-D IDCT
 * on each column.  Direct algorithms are also available, but they are
 * much more complex and seem not to be any faster when reduced to code.
 *
 * The poop on this scaling stuff is as follows:
 *
 * Each 1-D IDCT step produces outputs which are a factor of sqrt(N)
 * larger than the true IDCT outputs.  The final outputs are therefore
 * a factor of N larger than desired; since N=8 this can be cured by
 * a simple right shift at the end of the algorithm.  The advantage of
 * this arrangement is that we save two multiplications per 1-D IDCT,
 * because the y0 and y4 inputs need not be divided by sqrt(N).
 *
 * We have to do addition and subtraction of the integer inputs, which
 * is no problem, and multiplication by fractional constants, which is
 * a problem to do in integer arithmetic.  We multiply all the constants
 * by CONST_SCALE and convert them to integer constants (thus retaining
 * CONST_BITS bits of precision in the constants).  After doing a
 * multiplication we have to divide the product by CONST_SCALE, with proper
 * rounding, to produce the correct output.  This division can be done
 * cheaply as a right shift of CONST_BITS bits.  We postpone shifting
 * as long as possible so that partial sums can be added together with
 * full fractional precision.
 *
 * The outputs of the first pass are scaled up by PASS1_BITS bits so that
 * they are represented to better-than-integral precision.  These outputs
 * require BITS_IN_JSAMPLE + PASS1_BITS + 3 bits; this fits in a 16-bit word
 * with the recommended scaling.  (To scale up 12-bit sample data further, an
 * intermediate int array would be needed.)
 *
 * To avoid overflow of the 32-bit intermediate results in pass 2, we must
 * have BITS_IN_JSAMPLE + CONST_BITS + PASS1_BITS <= 26.  Error analysis
 * shows that the values given below are the most effective.
 */

#ifdef EIGHT_BIT_SAMPLES
#define CONST_BITS  4	/* was 13 */
#define PASS1_BITS  0	/* was 2 */
#else
#define CONST_BITS  13
junk here
#define PASS1_BITS  1		/* lose a little precision to avoid overflow */
#endif

#define ONE	((int) 1)

#define CONST_SCALE (ONE << CONST_BITS)

/* Convert a positive real constant to an integer scaled by CONST_SCALE. */

#define FIX(x)	((int) ((x) * CONST_SCALE + 0.5))

/* Some C compilers fail to reduce "FIX(constant)" at compile time, thus
 * causing a lot of useless floating-point operations at run time.
 * To get around this we use the following pre-calculated constants.
 * If you change CONST_BITS you may want to add appropriate values.
 * (With a reasonable C compiler, you can just rely on the FIX() macro...)
 */

#if CONST_BITS == 13
#define FIX_0_298631336  ((int)  2446)	/* FIX(0.298631336) */
#define FIX_0_390180644  ((int)  3196)	/* FIX(0.390180644) */
#define FIX_0_541196100  ((int)  4433)	/* FIX(0.541196100) */
#define FIX_0_765366865  ((int)  6270)	/* FIX(0.765366865) */
#define FIX_0_899976223  ((int)  7373)	/* FIX(0.899976223) */
#define FIX_1_175875602  ((int)  9633)	/* FIX(1.175875602) */
#define FIX_1_501321110  ((int)  12299)	/* FIX(1.501321110) */
#define FIX_1_847759065  ((int)  15137)	/* FIX(1.847759065) */
#define FIX_1_961570560  ((int)  16069)	/* FIX(1.961570560) */
#define FIX_2_053119869  ((int)  16819)	/* FIX(2.053119869) */
#define FIX_2_562915447  ((int)  20995)	/* FIX(2.562915447) */
#define FIX_3_072711026  ((int)  25172)	/* FIX(3.072711026) */
#else
#define FIX_0_298631336  FIX(0.298631336)
#define FIX_0_390180644  FIX(0.390180644)
#define FIX_0_541196100  FIX(0.541196100)
#define FIX_0_765366865  FIX(0.765366865)
#define FIX_0_899976223  FIX(0.899976223)
#define FIX_1_175875602  FIX(1.175875602)
#define FIX_1_501321110  FIX(1.501321110)
#define FIX_1_847759065  FIX(1.847759065)
#define FIX_1_961570560  FIX(1.961570560)
#define FIX_2_053119869  FIX(2.053119869)
#define FIX_2_562915447  FIX(2.562915447)
#define FIX_3_072711026  FIX(3.072711026)
#endif


/* Descale and correctly round an int value that's scaled by N bits.
 * We assume RIGHT_SHIFT rounds towards minus infinity, so adding
 * the fudge factor is correct for either sign of X.
 */

#define DESCALE(x,n)  RIGHT_SHIFT((x) + (ONE << ((n)-1)), n)

/* Multiply an int variable by an int constant to yield an int result.
 * For 8-bit samples with the recommended scaling, all the variable
 * and constant values involved are no more than 16 bits wide, so a
 * 16x16->32 bit multiply can be used instead of a full 32x32 multiply;
 * this provides a useful speedup on many machines.
 * There is no way to specify a 16x16->32 multiply in portable C, but
 * some C compilers will do the right thing if you provide the correct
 * combination of casts.
 * NB: for 12-bit samples, a full 32-bit multiplication will be needed.
 */

#ifdef EIGHT_BIT_SAMPLES
#ifdef SHORTxSHORT_32		/* may work if 'int' is 32 bits */
#define MULTIPLY(var,const)  (((INT16) (var)) * ((INT16) (const)))
#endif
#ifdef SHORTxLCONST_32		/* known to work with Microsoft C 6.0 */
#define MULTIPLY(var,const)  (((INT16) (var)) * ((int) (const)))
#endif
#endif

#ifndef MULTIPLY		/* default definition */
#define MULTIPLY(var,const)  ((var) * (const))
#endif


/*
 * Perform the inverse DCT on one block of coefficients.
 */

GLOBAL void near
j_rev_dct (DCTBLOCK data)
{
  int tmp0, tmp1, tmp2, tmp3;
  int	tmp10, tmp11, tmp12, tmp13;
  int z1, z2, z3, z4, z5;
  register DCTELEM *dataptr;
  JSAMPROW data_ptr;
  int rowctr;
  SHIFT_TEMPS

  /* Pass 2: process columns. */
  /* Note that we must descale the results by a factor of 8 == 2**3, */
  /* and also undo the PASS1_BITS scaling. */

  dataptr = data;
  for (rowctr = DCTSIZE-1; rowctr >= 0; rowctr--) {
	 /* Columns of zeroes can be exploited in the same way as we did with rows.
	  * However, the row calculation has created many nonzero AC terms, so the
	  * simplification applies less often (typically 5% to 10% of the time).
	  * On machines with very fast multiplication, it's possible that the
	  * test takes more time than it's worth.  In that case this section
	  * may be commented out.
	  */

#ifndef NO_ZERO_COLUMN_TEST
	 if ((dataptr[DCTSIZE*1] | dataptr[DCTSIZE*2] | dataptr[DCTSIZE*3] |
	 dataptr[DCTSIZE*4] | dataptr[DCTSIZE*5] | dataptr[DCTSIZE*6] |
	 dataptr[DCTSIZE*7]) == 0) {
		/* AC terms all zero */
		DCTELEM dcval = (DCTELEM) (dataptr[0] << PASS1_BITS);
/*		DCTELEM dcval = (DCTELEM) DESCALE((int) dataptr[0], PASS1_BITS);*/

		dataptr[DCTSIZE*0] = dcval;
		dataptr[DCTSIZE*1] = dcval;
		dataptr[DCTSIZE*2] = dcval;
		dataptr[DCTSIZE*3] = dcval;
		dataptr[DCTSIZE*4] = dcval;
		dataptr[DCTSIZE*5] = dcval;
		dataptr[DCTSIZE*6] = dcval;
		dataptr[DCTSIZE*7] = dcval;

		dataptr++;		/* advance pointer to next column */
		continue;
	 }
#endif

	 /* Even part: reverse the even part of the forward DCT. */
	 /* The rotator is sqrt(2)*c(-6). */

	 z2 = (int) dataptr[DCTSIZE*2];
	 z3 = (int) dataptr[DCTSIZE*6];

	 z1 = MULTIPLY(z2 + z3, FIX_0_541196100);
	 tmp2 = z1 + MULTIPLY(z3, - FIX_1_847759065);
	 tmp3 = z1 + MULTIPLY(z2, FIX_0_765366865);

	 tmp1 = ((int) dataptr[DCTSIZE*0] - (int) dataptr[DCTSIZE*4]) << CONST_BITS;
	 tmp0 = ((int) dataptr[DCTSIZE*0] + (int) dataptr[DCTSIZE*4]) << CONST_BITS;

	 tmp10 = tmp0 + tmp3;
	 tmp13 = tmp0 - tmp3;
	 tmp11 = tmp1 + tmp2;
	 tmp12 = tmp1 - tmp2;

	 /* Odd part per figure 8; the matrix is unitary and hence its
	  * transpose is its inverse.  i0..i3 are y7,y5,y3,y1 respectively.
	  */

	 tmp0 = (int) dataptr[DCTSIZE*7];
	 tmp3 = (int) dataptr[DCTSIZE*1];

	 z1 = tmp0 + tmp3;
	 z1 = MULTIPLY(z1, - FIX_0_899976223); /* sqrt(2) * (c7-c3) */
	 tmp1 = (int) dataptr[DCTSIZE*5];
	 tmp2 = (int) dataptr[DCTSIZE*3];
	 z2 = tmp1 + tmp2;
	 z2 = MULTIPLY(z2, - FIX_2_562915447); /* sqrt(2) * (-c1-c3) */
	 z3 = tmp0 + tmp2;
	 z4 = tmp1 + tmp3;
	 z5 = MULTIPLY(z3 + z4, FIX_1_175875602); /* sqrt(2) * c3 */

	 tmp0 = MULTIPLY(tmp0, FIX_0_298631336); /* sqrt(2) * (-c1+c3+c5-c7) */
	 tmp1 = MULTIPLY(tmp1, FIX_2_053119869); /* sqrt(2) * ( c1+c3-c5+c7) */
	 tmp2 = MULTIPLY(tmp2, FIX_3_072711026); /* sqrt(2) * ( c1+c3+c5-c7) */
	 tmp3 = MULTIPLY(tmp3, FIX_1_501321110); /* sqrt(2) * ( c1+c3-c5-c7) */
	 z4 = MULTIPLY(z4, - FIX_0_390180644); /* sqrt(2) * (c5-c3) */
	 z3 = MULTIPLY(z3, - FIX_1_961570560); /* sqrt(2) * (-c3-c5) */

	 z3 += z5;
	 z4 += z5;

	 tmp1 += z2 + z4;
	 tmp3 += z1 + z4;
	 tmp0 += z1 + z3;
	 tmp2 += z2 + z3;

	 /* Final output stage: inputs are tmp10..tmp13, tmp0..tmp3 */

	 dataptr[DCTSIZE*1] = (DCTELEM) DESCALE(tmp11 + tmp2,
						CONST_BITS-PASS1_BITS);
	 dataptr[DCTSIZE*6] = (DCTELEM) DESCALE(tmp11 - tmp2,
						CONST_BITS-PASS1_BITS);
	 dataptr[DCTSIZE*0] = (DCTELEM) DESCALE(tmp10 + tmp3,
						CONST_BITS-PASS1_BITS);
	 dataptr[DCTSIZE*7] = (DCTELEM) DESCALE(tmp10 - tmp3,
						CONST_BITS-PASS1_BITS);
	 dataptr[DCTSIZE*2] = (DCTELEM) DESCALE(tmp12 + tmp1,
						CONST_BITS-PASS1_BITS);
	 dataptr[DCTSIZE*5] = (DCTELEM) DESCALE(tmp12 - tmp1,
						CONST_BITS-PASS1_BITS);
	 dataptr[DCTSIZE*3] = (DCTELEM) DESCALE(tmp13 + tmp0,
						CONST_BITS-PASS1_BITS);
	 dataptr[DCTSIZE*4] = (DCTELEM) DESCALE(tmp13 - tmp0,
						CONST_BITS-PASS1_BITS);

	 dataptr++;			/* advance pointer to next column */
  }

  /* Pass 1: process rows. */
  /* Note results are scaled up by sqrt(8) compared to a true IDCT; */
  /* furthermore, we scale the results by 2**PASS1_BITS. */


  dataptr = data;
  for (rowctr = DCTSIZE-1; rowctr >= 0; rowctr--) {
	data_ptr = elemptr + srowptr[DCTSIZE - rowctr - 1];

	 /* Due to quantization, we will usually find that many of the input
	  * coefficients are zero, especially the AC terms.  We can exploit this
	  * by short-circuiting the IDCT calculation for any row in which all
	  * the AC terms are zero.  In that case each output is equal to the
	  * DC coefficient (with scale factor as needed).
	  * With typical images and quantization tables, half or more of the
	  * row DCT calculations can be simplified this way.
	  */

	 if ((dataptr[1] | dataptr[2] | dataptr[3] | dataptr[4] |
	 dataptr[5] | dataptr[6] | dataptr[7]) == 0) {
		/* AC terms all zero */
		DCTELEM dcval = (DCTELEM) DESCALE((int) dataptr[0], PASS1_BITS+3) - CENTERJSAMPLE;

		data_ptr[0] = dcval;
		data_ptr[1] = dcval;
		data_ptr[2] = dcval;
		data_ptr[3] = dcval;
		data_ptr[4] = dcval;
		data_ptr[5] = dcval;
		data_ptr[6] = dcval;
		data_ptr[7] = dcval;

		dataptr += DCTSIZE;	/* advance pointer to next row */
		continue;
	 }

	 /* Even part: reverse the even part of the forward DCT. */
	 /* The rotator is sqrt(2)*c(-6). */

	 z2 = (int) dataptr[2];
	 z3 = (int) dataptr[6];

	 z1 = MULTIPLY(z2 + z3, FIX_0_541196100);
    tmp2 = z1 + MULTIPLY(z3, - FIX_1_847759065);
    tmp3 = z1 + MULTIPLY(z2, FIX_0_765366865);

	 tmp1 = ((int) dataptr[0] - (int) dataptr[4]) << CONST_BITS;
	 tmp0 = ((int) dataptr[0] + (int) dataptr[4]) << CONST_BITS;

	 tmp10 = tmp0 + tmp3;
	 tmp13 = tmp0 - tmp3;
	 tmp11 = tmp1 + tmp2;
	 tmp12 = tmp1 - tmp2;

	 /* Odd part per figure 8; the matrix is unitary and hence its
	  * transpose is its inverse.  i0..i3 are y7,y5,y3,y1 respectively.
	  */

	 tmp1 = (int) dataptr[5];
	 tmp2 = (int) dataptr[3];
	 tmp0 = (int) dataptr[7];
	 tmp3 = (int) dataptr[1];

	 z1 = tmp0 + tmp3;
	 z2 = tmp1 + tmp2;
	 z3 = tmp0 + tmp2;
	 z4 = tmp1 + tmp3;
	 z5 = MULTIPLY(z3 + z4, FIX_1_175875602); /* sqrt(2) * c3 */

	 tmp0 = MULTIPLY(tmp0, FIX_0_298631336); /* sqrt(2) * (-c1+c3+c5-c7) */
	 tmp1 = MULTIPLY(tmp1, FIX_2_053119869); /* sqrt(2) * ( c1+c3-c5+c7) */
	 tmp2 = MULTIPLY(tmp2, FIX_3_072711026); /* sqrt(2) * ( c1+c3+c5-c7) */
	 tmp3 = MULTIPLY(tmp3, FIX_1_501321110); /* sqrt(2) * ( c1+c3-c5-c7) */
	 z1 = MULTIPLY(z1, - FIX_0_899976223); /* sqrt(2) * (c7-c3) */
	 z2 = MULTIPLY(z2, - FIX_2_562915447); /* sqrt(2) * (-c1-c3) */
	 z4 = MULTIPLY(z4, - FIX_0_390180644); /* sqrt(2) * (c5-c3) */
	 z3 = MULTIPLY(z3, - FIX_1_961570560); /* sqrt(2) * (-c3-c5) */

	 z3 += z5;
	 z4 += z5;

	 tmp1 += z2 + z4;
	 tmp0 += z1 + z3;
	 tmp2 += z2 + z3;
	 tmp3 += z1 + z4;

	 /* Final output stage: inputs are tmp10..tmp13, tmp0..tmp3 */

	 data_ptr[0] = range_limit[(DCTELEM) DESCALE(tmp10 + tmp3, CONST_BITS+PASS1_BITS+3)];
	 data_ptr[7] = range_limit[(DCTELEM) DESCALE(tmp10 - tmp3, CONST_BITS+PASS1_BITS+3)];
	 data_ptr[1] = range_limit[(DCTELEM) DESCALE(tmp11 + tmp2, CONST_BITS+PASS1_BITS+3)];
	 data_ptr[2] = range_limit[(DCTELEM) DESCALE(tmp12 + tmp1, CONST_BITS+PASS1_BITS+3)];
	 data_ptr[3] = range_limit[(DCTELEM) DESCALE(tmp13 + tmp0, CONST_BITS+PASS1_BITS+3)];
	 data_ptr[4] = range_limit[(DCTELEM) DESCALE(tmp13 - tmp0, CONST_BITS+PASS1_BITS+3)];
	 data_ptr[5] = range_limit[(DCTELEM) DESCALE(tmp12 - tmp1, CONST_BITS+PASS1_BITS+3)];
	 data_ptr[6] = range_limit[(DCTELEM) DESCALE(tmp11 - tmp2, CONST_BITS+PASS1_BITS+3)];

	 dataptr += DCTSIZE;		/* advance pointer to next row */
  }

}




/*
 * jdmcu.c
 *
 * Copyright (C) 1991, 1992, 1993, Thomas G. Lane.
 * This file is part of the Independent JPEG Group's software.
 * For conditions of distribution and use, see the accompanying README file.
 *
 * This file contains MCU disassembly and IDCT control routines.
 * These routines are invoked via the disassemble_MCU, reverse_DCT, and
 * disassemble_init/term methods.
 */

/*#include "jinclude.h"*/


/*
 * Fetch one MCU row from entropy_decode, build coefficient array.
 * This version is used for noninterleaved (single-component) scans.
 */

METHODDEF void
disassemble_noninterleaved_MCU (decompress_info_ptr cinfo,
				JBLOCKIMAGE image_data)
{
  JBLOCKROW MCU_data[1];
  long mcuindex;

  /* this is pretty easy since there is one component and one block per MCU */

  /* Pre-zero the target area to speed up entropy decoder */
  /* (we assume wholesale zeroing is faster than retail) */
  jzero_far((void FAR *) image_data[0][0],
	    (size_t) (cinfo->MCUs_per_row * SIZEOF(JBLOCK)));

  for (mcuindex = 0; mcuindex < cinfo->MCUs_per_row; mcuindex++) {
    /* Point to the proper spot in the image array for this MCU */
    MCU_data[0] = image_data[0][0] + mcuindex;
    /* Fetch the coefficient data */
    (*cinfo->methods->entropy_decode) (cinfo, MCU_data);
  }
}


/*
 * Fetch one MCU row from entropy_decode, build coefficient array.
 * This version is used for interleaved (multi-component) scans.
 */

METHODDEF void
disassemble_interleaved_MCU (decompress_info_ptr cinfo,
			     JBLOCKIMAGE image_data)
{
  JBLOCKROW MCU_data[MAX_BLOCKS_IN_MCU];
  long mcuindex;
  short blkn, ci, xpos, ypos;
  jpeg_component_info * compptr;
  JBLOCKROW image_ptr;

  /* Pre-zero the target area to speed up entropy decoder */
  /* (we assume wholesale zeroing is faster than retail) */
  for (ci = 0; ci < cinfo->comps_in_scan; ci++) {
    compptr = cinfo->cur_comp_info[ci];
    for (ypos = 0; ypos < compptr->MCU_height; ypos++) {
      jzero_far((void FAR *) image_data[ci][ypos],
		(size_t) (cinfo->MCUs_per_row * compptr->MCU_width * SIZEOF(JBLOCK)));
    }
  }

  for (mcuindex = 0; mcuindex < cinfo->MCUs_per_row; mcuindex++) {
    /* Point to the proper spots in the image array for this MCU */
    blkn = 0;
	 for (ci = 0; ci < cinfo->comps_in_scan; ci++) {
      compptr = cinfo->cur_comp_info[ci];
      for (ypos = 0; ypos < compptr->MCU_height; ypos++) {
	image_ptr = image_data[ci][ypos] + (mcuindex * compptr->MCU_width);
	for (xpos = 0; xpos < compptr->MCU_width; xpos++) {
	  MCU_data[blkn] = image_ptr;
	  image_ptr++;
	  blkn++;
	}
      }
    }
    /* Fetch the coefficient data */
    (*cinfo->methods->entropy_decode) (cinfo, MCU_data);
  }
}


/*
 * Perform inverse DCT on each block in an MCU row's worth of data;
 * output the results into a sample array starting at row start_row.
 * NB: start_row can only be nonzero when dealing with a single-component
 * scan; otherwise we'd have to pass different offsets for different
 * components, since the heights of interleaved MCU rows can vary.
 * But the pipeline controller logic is such that this is not necessary.
 */

METHODDEF void
reverse_DCT (decompress_info_ptr cinfo,
		  JBLOCKIMAGE coeff_data, JSAMPIMAGE output_data, int start_row)
{
  DCTBLOCK block;
  JBLOCKROW browptr;
  jpeg_component_info * compptr;
  long blocksperrow, bi;
  short numrows, ri;
  short ci;

  for (ci = 0; ci < cinfo->comps_in_scan; ci++) {
    compptr = cinfo->cur_comp_info[ci];
    /* don't bother to IDCT an uninteresting component */
	 if (! compptr->component_needed)
      continue;
    /* calculate size of an MCU row in this component */
	 blocksperrow = compptr->downsampled_width / DCTSIZE;
    numrows = compptr->MCU_height;
    /* iterate through all blocks in MCU row */
    for (ri = 0; ri < numrows; ri++) {
      browptr = coeff_data[ci][ri];
      srowptr = output_data[ci] + (ri * DCTSIZE + start_row);
      for (bi = 0; bi < blocksperrow; bi++) {
	/* copy the data into a local DCTBLOCK.  This allows for change of
	 * representation (if DCTELEM != JCOEF).  On 80x86 machines it also
	 * brings the data back from FAR storage to NEAR storage.
	 */
	{ register JCOEFPTR elemptr = browptr[bi];
	  register DCTELEM *localblkptr = block;
	  register int elem = DCTSIZE2;

	  while (--elem >= 0)
		 *localblkptr++ = (DCTELEM) *elemptr++;
	}

	range_limit = cinfo->sample_range_limit +	CENTERJSAMPLE;
	elemptr = bi * DCTSIZE;
	j_rev_dct(block);	/* perform inverse DCT */

#if pigs_fly
	/* Output the data into the sample array.
	 * Note change from signed to unsigned representation:
	 * DCT calculation works with values +-CENTERJSAMPLE,
	 * but sample arrays always hold 0..MAXJSAMPLE.
	 * We have to do range-limiting because of quantization errors in the
	 * DCT/IDCT phase.  We use the sample_range_limit[] table to do this
	 * quickly; the CENTERJSAMPLE offset is folded into table indexing.
	 */
	{ register JSAMPROW elemptr;
	  register DCTELEM *localblkptr = block;
	  register JSAMPLE *range_limit = cinfo->sample_range_limit +
						CENTERJSAMPLE;
#if DCTSIZE != 8
	  register int elemc;
#endif
	  register int elemr;

	  for (elemr = 0; elemr < DCTSIZE; elemr++) {
#if DCTSIZE == 8		/* unroll the inner loop */
		 *elemptr++ = range_limit[*localblkptr++];
		 *elemptr++ = range_limit[*localblkptr++];
		 *elemptr++ = range_limit[*localblkptr++];
		 *elemptr++ = range_limit[*localblkptr++];
		 *elemptr++ = range_limit[*localblkptr++];
		 *elemptr++ = range_limit[*localblkptr++];
		 *elemptr++ = range_limit[*localblkptr++];
		 *elemptr = range_limit[*localblkptr++];
#else
		 for (elemc = DCTSIZE; elemc > 0; elemc--) {
			*elemptr++ = range_limit[*localblkptr++];
		 }
#endif
	  }
	}
#endif
		}
	 }
  }
}


/*
 * Initialize for processing a scan.
 */

METHODDEF void
disassemble_init (decompress_info_ptr cinfo)
{
  /* no work for now */
}


/*
 * Clean up after a scan.
 */

METHODDEF void
disassemble_term (decompress_info_ptr cinfo)
{
  /* no work for now */
}



/*
 * The method selection routine for MCU disassembly.
 */

GLOBAL void
jseldmcu (decompress_info_ptr cinfo)
{
  if (cinfo->comps_in_scan == 1)
    cinfo->methods->disassemble_MCU = disassemble_noninterleaved_MCU;
  else
    cinfo->methods->disassemble_MCU = disassemble_interleaved_MCU;
  cinfo->methods->reverse_DCT = reverse_DCT;
  cinfo->methods->disassemble_init = disassemble_init;
  cinfo->methods->disassemble_term = disassemble_term;
}
