
/* for this struct.  All items should be in ascending order with 0x00 for the unused mode #'s */
/* custom is for typed in modes.  The actual card # is (ok_mode[].card_ID >> 8 ) % 0x00ff where *.card_ID & 0xff is 18 (ie ptr to custom) */
/*
 * NOTE: the order of the list is the order of the modes in the list for each card in vidsetup.exe
 * Also: the first mode should be 320 * 200 * 256, It will always be assumed to be present (the first mode that is)
 *
 */

struct video_card {
	int card_number;		/* same index as video_card_names and list in .asm video routines */
	int x_size;
	int y_size;
	int resolution;	/* check enum:  0 = 256, 1 = 15 bit, 2 = 24 bit */
	int set_ax;		/* value to force AX, BX */
	int set_bx;
	int x_width;		/* x_width for odd sizes ie 15, 24 bit its the number of bytes per vertical row */
	} video_cards[] = {

/* VGA */
	{19, 320, 200, SVGA, 0x13, 0, 320},		/* this is the only 320 * 200 mode used for all cards */
	{19, 320, 200, VGA, 0x0d, 0, 40},
	{19, 640, 350, VGA, 0x10, 0, 80},
	{19, 640, 480, VGA, 0x12, 0, 80},

/* ahead A */
	{0, 800, 600, VGA, 0x71, 0, 100},
	{0, 1024, 768, VGA, 0x74, 0, 128},
	{0, 640, 400, SVGA, 0x60, 0, 640},
	{0, 640, 480, SVGA, 0x61, 0, 640},
	{0, 800, 600, SVGA, 0x62, 0, 800},

/* ahead B */
	{1, 800, 600, VGA, 0x71, 0, 100},
	{1, 1024, 768, VGA, 0x74, 0, 128},
	{1, 640, 400, SVGA, 0x60, 0, 640},
	{1, 640, 480, SVGA, 0x61, 0, 640},
	{1, 800, 600, SVGA, 0x62, 0, 800},
	{1, 1024, 768, SVGA, 0x63, 0, 1024},

/* ati */
	{2, 640, 480, VGA, 0x12, 0, 80},
	{2, 800, 600, VGA, 0x54, 0, 100},
	{2, 1024, 768, VGA, 0x55, 0, 128},
	{2, 640, 400, SVGA, 0x61, 0, 640},
	{2, 640, 480, SVGA, 0x62, 0, 640},
	{2, 800, 600, SVGA, 0x63, 0, 800},
	{2, 1024, 768, SVGA, 0x64, 0, 1024},
	{2, 640, 480, SVGA_15_bit, 0x72, 0, 1280},
	{2, 800, 600, SVGA_15_bit, 0x73, 0, 1600},
	{2, 640, 480, SVGA_24_bit, 0x75, 0, 2048},

/* chips & tech */
	{3, 800, 600, VGA, 0x70, 0, 100},
	{3, 1024, 768, VGA, 0x72, 0, 128},
	{3, 640, 400, SVGA, 0x78, 0, 640},
	{3, 640, 480, SVGA, 0x79, 0, 640},
	{3, 800, 600, SVGA, 0x7b, 0, 800},

/* everex */
	{4, 800, 600, VGA, 0x02, 0, 100},
	{4, 1024, 768, VGA, 0x20, 0, 128},
	{4, 1280, 1024, VGA, 0x21, 0, 160},
	{4, 640, 400, SVGA, 0x14, 0x30, 640},
	{4, 512, 480, SVGA, 0x15, 0x30, 512},
	{4, 640, 480, SVGA, 0x30, 0x30, 640},
	{4, 800, 600, SVGA, 0x31, 0x30, 800},
/*	{4, 640, 400, SVGA_15_bit, 0x70, 0x71, 1280},
	{4, 640, 480, SVGA_15_bit, 0x5C, 0, 1280},*/

/* oak-tek */
	{5, 800, 600, VGA, 0x52, 0, 100},
	{5, 1024, 768, VGA, 0x56, 0, 128},
	{5, 1280, 1024, VGA, 0x58, 0, 160},
	{5, 640, 480, SVGA, 0x53, 0, 640},
	{5, 800, 600, SVGA, 0x54, 0, 800},
	{5, 1024, 768, SVGA, 0x59, 0, 1024},
	{5, 640, 400, SVGA_15_bit, 0x5B, 0, 1280},
	{5, 640, 480, SVGA_15_bit, 0x5C, 0, 1280},

/* genoa */
	{6, 800, 600, VGA, 0x79, 0, 100},
	{6, 1024, 768, VGA, 0x5f, 0, 128},
	{6, 640, 400, SVGA, 0x7e, 0, 640},
	{6, 640, 480, SVGA, 0x5c, 0, 640},
	{6, 720, 512, SVGA, 0x5d, 0, 720},
	{6, 800, 600, SVGA, 0x5e, 0, 800},

/* NCR */
	{7, 800, 600, VGA, 0x58, 0, 100},
	{7, 1024, 768, VGA, 0x5d, 0, 128},
	{7, 1280, 1024, VGA, 0x67, 0, 160},
	{7, 640, 400, SVGA, 0x5e, 0, 640},
	{7, 640, 480, SVGA, 0x5f, 0, 640},
	{7, 800, 600, SVGA, 0x5c, 0, 800},
	{7, 1024, 768, SVGA, 0x61, 0, 1024},
	{7, 1280, 1024, SVGA, 0x6A, 0, 1280},
	{7, 640, 480, SVGA_15_bit, 0x71, 0, 1280},
	{7, 800, 600, SVGA_15_bit, 0x72, 0, 1600},
	{7, 640, 480, SVGA_16_bit, 0x78, 0, 1280},
	{7, 800, 600, SVGA_16_bit, 0x79, 0, 1600},

/* paradise */
	{8, 800, 600, VGA, 0x58, 0, 100},
	{8, 1024, 768, VGA, 0x5d, 0, 128},
	{8, 1280, 1024, VGA, 0x64, 0, 160},
	{8, 640, 400, SVGA, 0x5e, 0, 640},
	{8, 640, 480, SVGA, 0x5f, 0, 640},
	{8, 800, 600, SVGA, 0x5c, 0, 800},
	{8, 1024, 768, SVGA, 0x60, 0, 1024},
	{8, 320, 200, SVGA_15_bit, 0x68, 0, 640},
	{8, 640, 400, SVGA_15_bit, 0x61, 0, 1280},
	{8, 640, 480, SVGA_15_bit, 0x62, 0, 1280},
	{8, 800, 600, SVGA_15_bit, 0x63, 0, 1600},

/* trident 8900 */
	{9, 800, 600, VGA, 0x5b, 0, 100},
	{9, 1024, 768, VGA, 0x5f, 0, 128},
	{9, 640, 400, SVGA, 0x5c, 0, 640},
	{9, 640, 480, SVGA, 0x5d, 0, 640},
	{9, 800, 600, SVGA, 0x5e, 0, 800},
	{9, 1024, 768, SVGA, 0x62, 0, 1024},
	{9, 640, 480, SVGA_15_bit, 0x74, 0, 1280},
	{9, 800, 600, SVGA_15_bit, 0x76, 0, 1600},
	{9, 640, 480, SVGA_16_bit, 0x75, 0, 1280},
	{9, 800, 600, SVGA_16_bit, 0x77, 0, 1600},

/* tseng */
	{10, 800, 600, VGA, 0x29, 0, 100},
	{10, 1024, 768, VGA, 0x37, 0, 128},
	{10, 1280, 1024, VGA, 0x3d, 0, 160},
	{10, 640, 350, SVGA, 0x2d, 0, 640},
	{10, 640, 480, SVGA, 0x2e, 0, 640},
	{10, 800, 600, SVGA, 0x30, 0, 800},
	{10, 1024, 768, SVGA, 0x38, 0, 1024},

/* tseng 4000 */
	{11, 800, 600, VGA, 0x29, 0, 100},
	{11, 1024, 768, VGA, 0x37, 0, 128},
	{11, 1280, 1024, VGA, 0x3d, 0, 160},
	{11, 640, 350, SVGA, 0x2d, 0, 640},
	{11, 640, 400, SVGA, 0x2f, 0, 640},
	{11, 640, 480, SVGA, 0x2e, 0, 640},
	{11, 800, 600, SVGA, 0x30, 0, 800},
	{11, 1024, 768, SVGA, 0x38, 0, 1024},

/* the AX values have been changed to a unique fffx where x is the DAC type (as per info sheets)
	- the video setting routine will locate this and assume it is a tseng 4000 card and use the right value)
	*/
	{11, 640, 350, SVGA_15_bit, 0xfff1, 0x2d, 1280},
	{11, 640, 400, SVGA_15_bit, 0xfff1, 0x2f, 1280},
	{11, 640, 480, SVGA_15_bit, 0xfff1, 0x2e, 1280},
	{11, 800, 600, SVGA_15_bit, 0xfff1, 0x30, 1600},
	{11, 640, 400, SVGA_16_bit, 0x90f0, 0x2F, 1280},
	{11, 640, 480, SVGA_16_bit, 0x90f0, 0x2E, 1280},
	{11, 800, 600, SVGA_16_bit, 0x90f0, 0x30, 1600},
/*	{11, 640, 400, SVGA_16_bit, 0xfff2, 0x2F, 1280},
	{11, 640, 480, SVGA_16_bit, 0xfff2, 0x2E, 1280},
	{11, 800, 600, SVGA_16_bit, 0xfff2, 0x30, 1600},*/
	{11, 640, 350, SVGA_24_bit, 0xfff3, 0x2dff, 2048},
	{11, 640, 350, SVGA_24_bit, 0x10f0, 0x2dff, 1920},
	{11, 640, 400, SVGA_24_bit, 0x10f0, 0x2fff, 1920},
	{11, 640, 480, SVGA_24_bit, 0x10f0, 0x2eff, 1920},
	{11, 640, 480, SVGA_24_bit, 0x10f0, 0x3e, 2048},
	{11, 640, 480, SVGA_24_bit, 0x10e0, 0x2e, 2048},
/*	{11, 320, 200, SVGA_16_bit, 0xfff2, 0x13, 640},
	{11, 640, 350, SVGA_16_bit, 0xfff2, 0x2D, 1280},
	{11, 640, 400, SVGA_24_bit, 0xfff3, 0x2fff, 2048},*/

/* video 7 */
	{12, 800, 600, VGA, 0x62, 0, 100},
	{12, 1024, 768, VGA, 0x65, 0, 128},
	{12, 640, 400, SVGA, 0x66, 0x67, 640},
	{12, 640, 480, SVGA, 0x67, 0x67, 640},
	{12, 800, 600, SVGA, 0x69, 0x67, 800},
	{12, 1024, 768, SVGA, 0x6a, 0x67, 1024},

/* cirrus */
	{13, 800, 600, VGA, 0x58, 0, 100},
	{13, 1024, 768, VGA, 0x5d, 0, 128},
	{13, 1280, 1024, VGA, 0x6c, 0, 160},
	{13, 640, 480, SVGA, 0x5f, 0, 640},
	{13, 800, 600, SVGA, 0x5c, 0, 800},
	{13, 1024, 768, SVGA, 0x60, 0, 1024},
	{13, 640, 480, SVGA_15_bit, 0x66, 0, 1280},
	{13, 800, 600, SVGA_15_bit, 0x67, 0, 1600},
	{13, 320, 200, SVGA_16_bit, 0x6f, 0, 640},
	{13, 640, 480, SVGA_16_bit, 0x64, 0, 1280},
	{13, 800, 600, SVGA_16_bit, 0x65, 0, 1600},
	{13, 320, 200, SVGA_24_bit, 0x70, 0, 960},
	{13, 640, 480, SVGA_24_bit, 0x71, 0, 2048}, /* 2048 for all 24 bit */

/* compaq */
	{14, 640, 480, SVGA, 0x2e, 0, 1024},

/* vesa */
	{15, 800, 600, VGA, 0x102, 0, 100},
	{15, 1024, 768, VGA, 0x104, 0, 128},
	{15, 1280, 1024, VGA, 0x106, 0, 160},
	{15, 640, 400, SVGA, 0x4f02, 0x100, 640},
	{15, 640, 480, SVGA, 0x4f02, 0x101, 640},
	{15, 800, 600, SVGA, 0x4f02, 0x103, 800},
	{15, 1024, 768, SVGA, 0x4f02, 0x105, 1024},
	{15, 1280, 1024, SVGA, 0x4f02, 0x107, 1240},
	{15, 640, 480, SVGA_15_bit, 0x4f02, 0x110, 1280},
	{15, 800, 600, SVGA_15_bit, 0x4f02, 0x113, 1600},
	{15, 1024, 768, SVGA_15_bit, 0x4f02, 0x116, 2048},
	{15, 1280, 1024, SVGA_15_bit, 0x4f02, 0x119, 2560},
	{15, 640, 480, SVGA_16_bit, 0x4f02, 0x111, 1280},
	{15, 800, 600, SVGA_16_bit, 0x4f02, 0x114, 1600},
	{15, 1024, 768, SVGA_16_bit, 0x4f02, 0x117, 2048},
	{15, 1280, 1024, SVGA_16_bit, 0x4f02, 0x120, 2560},
	{15, 640, 480, SVGA_24_bit, 0x4f02, 0x112, 2048},		/* include both line widths since the video card could be either */
	{15, 800, 600, SVGA_24_bit, 0x4f02, 0x115, 2400},

/* S3 chips ie Orchid Farenheit */
	{16, 800, 600, VGA, 0x102, 0, 100},
	{16, 1024, 768, VGA, 0x104, 0, 128},
	{16, 1280, 1024, VGA, 0x106, 0, 160},
	{16, 640, 480, SVGA, 0x4f02, 0x201, 640},
	{16, 800, 600, SVGA, 0x4f02, 0x203, 800},
	{16, 1024, 768, SVGA, 0x4f02, 0x205, 1024},
	{16, 640, 480, SVGA_15_bit, 0x4f02, 0x301, 1280},
	{16, 640, 480, SVGA_16_bit, 0x4f02, 0x211, 1280},
	{16, 800, 600, SVGA_16_bit, 0x4f02, 0x214, 1600},
	{16, 1280, 1024, SVGA_16_bit, 0x4f02, 0x21A, 2560},
	{16, 640, 480, SVGA_24_bit, 0x4f02, 0x301, 2048},

/* Speedstar 24X */
	{17, 640, 400, SVGA, 0x5e, 0, 640},
	{17, 640, 480, SVGA, 0x5f, 0, 640},
	{17, 800, 600, SVGA, 0x5c, 0, 800},
	{17, 1024, 768, SVGA, 0x60, 0, 1024},
	{17, 640, 480, SVGA_15_bit, 0x62, 0, 1280},
	{17, 800, 600, SVGA_15_bit, 0x63, 0, 1600},
	{17, 640, 480, SVGA_24_bit, 0x72, 0, 1920},

/* XGA adapter */
/*	{18, 640, 480, SVGA, 0xc7, 0x30, 640},
	{18, 800, 600, SVGA, 0x07, 0x31, 800},
	{18, 1024, 768, SVGA, 0x0f, 0x3d, 1024},
	{18, 640, 480, SVGA_15_bit, 0xc7, 0x40, 1280},
	{18, 800, 600, SVGA_15_bit, 0x07, 0x41, 1600},*/

/*RT3106 ie Realtek */
	{18, 640, 400, SVGA, 0x25, 0, 640},
	{18, 640, 480, SVGA, 0x26, 0, 640},
	{18, 800, 600, SVGA, 0x27, 0, 800},
	{18, 1024, 768, SVGA, 0x28, 0, 1024},
	{18, 1280, 1024, SVGA, 0x37, 0, 1280},

/* STB - based on Tseng 4000 ???????????? */
/*	{19, 320, 200, SVGA, 0x13, 0, 320},
	{19, 640, 350, SVGA, 0x2d, 0, 640},
	{19, 640, 400, SVGA, 0x2f, 0, 640},
	{19, 640, 480, SVGA, 0x2e, 0, 640},
	{19, 800, 600, SVGA, 0x30, 0, 800},
	{19, 1024, 768, SVGA, 0x38, 0, 1024},
	{19, 640, 350, SVGA_15_bit, 0x10f0, 0x2d, 1280},
	{19, 640, 400, SVGA_15_bit, 0x10f0, 0x2f, 1280},
	{19, 640, 480, SVGA_15_bit, 0x10f0, 0x2e, 1280},
	{19, 800, 600, SVGA_15_bit, 0x10f0, 0x30, 1600},
	{19, 640, 480, SVGA_24_bit, 0x10e0, 0x2e, 2048},*/


/* empty slots for custom modes */
	{0, 0, SVGA, 0x0, 0, 0},
	{0, 0, SVGA, 0x0, 0, 0},
	{0, 0, SVGA, 0x0, 0, 0},
	{0, 0, SVGA, 0x0, 0, 0},
	{0, 0, SVGA, 0x0, 0, 0},
	{0, 0, SVGA, 0x0, 0, 0},
	{-1, 0, SVGA, 0x0, 0, 0}	/* last entry maked by invalid x_size */
	};


