From rossi@cs.unibo.it Mon Nov 22 12:14 EST 1993
Received: from leporello.cs.unibo.it by maxwell.uwaterloo.ca with SMTP
	(1.37.109.8/15.6) id AA20291; Mon, 22 Nov 1993 12:14:36 -0500
Return-Path: <rossi@cs.unibo.it>
Received: from desdemona.cs.unibo.it (radames.cs.unibo.it) by leporello.cs.unibo.it (5.65c/1.34)
	id AA01968; Mon, 22 Nov 1993 18:14:26 +0100
Received: by desdemona.cs.unibo.it (5.65c/SMI-4.1)
	id AA02099; Mon, 22 Nov 1993 18:14:24 +0100
From: rossi@cs.unibo.it (Davide Rossi)
Message-Id: <199311221714.AA02099@desdemona.cs.unibo.it>
Subject: Re: The new JPEG code...
To: praetzel@maxwell.uwaterloo.ca (Eric Praetzel)
Date: Mon, 22 Nov 93 18:14:22 MET
In-Reply-To: <199311221655.AA01938@leporello.cs.unibo.it>; from "Eric Praetzel" at Nov 22, 93 11:55:24 am
X-Mailer: ELM [version 2.4dev PL32]
Status: RO

Hello again,

>I tried speeding up the Huffman decoding but had no measurable luck.  I
>can speed it up a bit by playing with the assembler; but what is needed
>is probably another method.
Sure... I'll start to play with Huffman decoding when I'll be able to 
print some docs I have about it...

>The grayscale viewing on mine is about as fast as the hi-color viewing
>on QPEG.  That is not bad and I can't help but wonder where the speed
>difference is.  He saves time in his colorspace conversion but I really
>wonder how far behind we are on the IDCT and Huffman.  I can only see
>the LUTs being used for the Huffman.  They would certainly not be usefull
>for the IDCT.
>I think that I will move the colorspace conversion into the IDCT.  That
>will mean that storing of the components is not required.  It will be
>interesting to see what it does.
This was why I was talking about "write brand new code..." :)

>I have an interesting JPEG.  It is 2100 * 1500 (aprox) and was made from a
>slide I took on my bike trip.  I believe that it was Cortina d'ampezo (?)
Close but not right: is Cortina d'Ampezzo... 2 z's ;>

>The original Targa was 10M and the JPEG is only 350k.  It was first 
>compressed to JPEG with Image Alchemy (a 2.2M JPEG) and then recompressed 
>at Q = 75. I have been having some fun comparing that slide and computer 
>image to a slide made from the JPEG file.
I have not such a big image... for testing purpose I use some 1670x1700... 
there is a way for having such image (I mean get it with ftp) ?
Well I know: I can use any, say, 320x200 and change it to, say, 3200x2000 
but it is not as fanny as having such a big image :)


BTW: this is the code... let me know what you think about it!

Davide.
_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-_-

uword far *ord[4][4];

#define MK_HI(R,G,B) \
(((R)&0xf8)<<7|((G)&0xf8)<<2|(((B)&0xf8)>>3))

static void
init_ord(decompress_info_ptr cinfo)
{
  for(int i=0; i<4; i++) {
    for(int j=0; j<4; j++) {
      ord[i][j]=(uword far *)(*cinfo->emethods->alloc_medium)(512);
    }
  }
  static int err[4][4]=
  { { 4, -1,  3, -2},
    {-3,  2, -4,  1},
    { 2, -2,  3, -1},
    {-4,  0, -3,  1},};
  int x,j,idx;
  for(i=0; i<4; i++) {
    for(j=0; j<4; j++) {
      for(idx=0; idx<256; idx++) {
        x=idx+err[i][j];
        if(x<0) x=0;
        if(x>255) x=255;
        ord[i][j][idx]=MK_HI(x, x, x);
      }
    }
  }
}

METHODDEF void
put_hi_ord_pixel_rows (decompress_info_ptr cinfo, int num_rows, JSAMPIMAGE pixel_data)
/* Write some rows of output data */
{
  JSAMPROW ptr0, ptr1, ptr2;
  uword far *ord_ptr0, far *ord_ptr1, far *ord_ptr2, far *ord_ptr3;
  register int row, col;
  register boolean cont=true;

  for (row=0; row<num_rows; row++, line++) {
    uword *ptr=line_ptr;
    ptr0 = pixel_data[0][row];
    ptr1 = pixel_data[1][row];
    ptr2 = pixel_data[2][row];
    ord_ptr0=ord[line%4][0];
    ord_ptr1=ord[line%4][1];
    ord_ptr2=ord[line%4][2];
    ord_ptr3=ord[line%4][3];
//be careful: this code wants 8byte aligned image, else you have to add
//some control
    for(col=0; col<cinfo->image_width; col+=4) {
      *ptr++=(ord_ptr0[*ptr0++]&0x7c00) |
             (ord_ptr0[*ptr1++]&0x03e0) |
             (ord_ptr0[*ptr2++]&0x001f);
      *ptr++=(ord_ptr1[*ptr0++]&0x7c00) |
             (ord_ptr1[*ptr1++]&0x03e0) |
             (ord_ptr1[*ptr2++]&0x001f);
      *ptr++=(ord_ptr2[*ptr0++]&0x7c00) |
             (ord_ptr2[*ptr1++]&0x03e0) |
             (ord_ptr2[*ptr2++]&0x001f);
      *ptr++=(ord_ptr3[*ptr0++]&0x7c00) |
             (ord_ptr3[*ptr1++]&0x03e0) |
             (ord_ptr3[*ptr2++]&0x001f);
    } //instead of 000111222333 you can also try 012301230123... is nice...
    cont&=cinfo->picture->OutLine(global_props, line, (ubyte far *)line_ptr);
  }
  if(!cont) {
    (*emethods->free_all) (); /* clean up memory allocation & temp files */
    longjmp(setjmp_buffer, 1);
  }
}

PS:
uword=unsigned

