;  modified quite a bit by Eric Praetzel
;
; removed the memory bank-switching routines because that is set seperately
; memory tests removed because the code was big enough to cross a bank boundary
; hi_color flag is not being set yet by tseng or ATI
; moved video testing routines to vidtest.asm

	include  model.h

;
;  from VGAKIT Version 4.1
;
;  Copyright 1988,89,90,91 John Bridges
;  Free for use in commercial, shareware or freeware applications
;
;  BANKS.ASM
;
.data

OSEG  equ   DS:      ;segment override for variable access

extrn bankadr:word
;if @Codesize
extrn bankseg:word
;endif

	public retval

extrn curbk:word

extrn vga512:word
extrn vga1024:word


extrn video_resolution:word
extrn cirrus:word
extrn everex:word
extrn paradise:word
extrn tseng:word
extrn trident:word
extrn t8900:word
extrn ativga:word
extrn aheada:word
extrn aheadb:word
extrn oaktech:word
extrn video7:word
extrn chipstech:word
extrn tseng4:word
extrn genoa:word
extrn ncr:word
extrn compaq:word
extrn vesa:word

first    dw ?     ;flag so whichvga() is only called once
retval   dw ?     ;first return value from whichvga()
extrn ati_extended:word  ;ati extended reg. location

vgainfo  label word
vesaid   db 'VESA'      ; 4 signature bytes
vesaver  dw ?     ; VESA version number
oemstr   dd ?     ; Pointer to OEM string
capabil  db 4 dup (?)   ; Capabilities of the video environment
modelst  dd ?     ; Pointer to supported Super VGA modes

extrn vesashift:byte   ; number of bits to shift bank number left

.code

	public   whichvga


nojmp macro
	local lbl
	jmp   lbl
lbl:
	endm



whichvga proc  uses si di
	local vesabuf[256]:byte

	cmp   [first],'FI'
	jnz   gotest
	mov   ax,[retval]
	ret
gotest:
;	mov   [bankadr],offset _nobank
;if @Codesize
;	mov   [bankseg],seg _nobank
;endif
	xor   ax,ax
	mov   [curbk],ax
	mov   [vga512],ax
	mov   [vga1024],ax
	mov   [cirrus],ax
	mov   [everex],ax
	mov   [paradise],ax
	mov   [tseng],ax
	mov   [trident],ax
	mov   [t8900],ax
	mov   [ativga],ax
	mov   [aheada],ax
	mov   [aheadb],ax
	mov   [oaktech],ax
	mov   [video7],ax
	mov   [chipstech],ax
	mov   [tseng4],ax
	mov   [genoa],ax
	mov   [ncr],ax
	mov   [compaq],ax
	mov   [vesa],ax
	mov   [first],'FI'

	mov   ax,ss
	mov   es,ax
	lea   di,vesabuf[0]
	mov   ax,4f00h
	int   10h
	cmp   ax,4fh
	jnz   novesa
	lea   si,vesabuf[0]
	mov   di,offset vgainfo
	mov   ax,ds
	mov   es,ax
	push  ds
	mov   ax,ss
	mov   ds,ax
	mov   cx,7
	cld
	rep   movsw
	pop   ds
mov vesa, 1
;	bkadr vesa
	mov   [vga512],1
;	mov   [vga1024],1
	jmp   fini

novesa:  mov   si,1
	mov   ax,0c000h
	mov   es,ax
	cmp   word ptr es:[40h],'13'  ;ATI Signiture on the Video BIOS
	jnz   noati
mov ativga, 1
;	bkadr ativga

	mov   ax, 0c000h     ; find the location of the ATI extended reg
	mov   es, ax
	mov   bx, 10h
	mov   dx, es:[bx] ; fetch the extended reg value
	mov   [ati_extended], dx

	cli
	mov   dx,1ceh
	mov   al,0bbh
	out   dx,al
	inc   dl
	in    al,dx
	sti
	and   al,20h
	jz    no512
	mov   [vga512],1
no512:
		jmp   fini

noati:   mov   ax,7000h    ;Test for Everex
	xor   bx,bx
	cld
	int   10h
	cmp   al,70h
	jnz   noev
mov everex, 1
;	bkadr everex
	and   ch,11000000b      ;how much memory on board
	jz skp
	mov   [vga512],1
skp:              ;fall through for Everex boards using Trident or Tseng4000

noev: mov   ax,0bf03h      ;Test for Compaq
	xor   bx,bx
	mov   cx,bx
	int   10h
	cmp   ax,0bf03h
	jnz   nocp
	test  cl,40h         ;is 640x480x256 available?
	jz nocp
mov compaq, 1
;	bkadr compaq
	mov   [vga512],1
	jmp   fini

nocp: mov   dx,3c4h        ;Test for NCR 77C22E
	mov   ax,0ff05h
	call  _isport2
	jnz   noncr
	mov   ax,5        ;Disable extended registers
	out   dx,ax
	mov   ax,0ff10h      ;Try to write to extended register 10
	call  _isport2    ;If it writes then not NCR
	jz noncr
	mov   ax,105h        ;Enable extended registers
	out   dx,ax
	mov   ax,0ff10h
	call  _isport2
	jnz   noncr       ;If it does NOT write then not NCR
mov ncr, 1
;	bkadr ncr
	mov   [vga512],1
	jmp   fini

noncr:   mov   dx,3c4h        ;Test for Trident
	mov   al,0bh
	out   dx,al
	inc   dl
	in al,dx
	cmp   al,06h
	ja notri
	cmp   al,2
	jb notri
mov trident, 1
;	bkadr trident
	cmp   al,3
	jb no89
	mov   [t8900],1
	mov   dx,3d5h
	mov   al,1fh
	out   dx,al
	inc   dx
	in al,dx
	and   al,3
	cmp   al,1
	jb notmem
	mov   [vga512],1
	je notmem
;	mov   [vga1024],1			don't assume 1M since the card is probably old
notmem:  jmp   fini

no89:
	mov   [vga512],1
	jmp   fini

notri:   mov   ax,6f00h    ;Test for Video 7
	xor   bx,bx
	cld
	int   10h
	cmp   bx,'V7'
	jnz   nov7
mov video7, 1
;	bkadr video7
	mov   ax,6f07h
	cld
	int   10h
	and   ah,7fh
	cmp   ah,1
	jbe   skp2
	mov   [vga512],1
skp2: cmp   ah,3
	jbe   skp3
	mov   [vga1024],1
skp3: jmp   fini

nov7: mov   dx,3d4h        ;Test for GENOA GVGA
	mov   ax,032eh    ;check for Herchi Register
	call  _isport2
	jnz   nogn
	mov   dx,3c4h        ;check for memory segment register
	mov   ax,3f06h
	call  _isport2
	jnz   nogn
mov genoa, 1
;	bkadr genoa
	mov   [vga512],1
	jmp   fini

nogn: call  _cirrus        ;Test for Cirrus
	cmp   [cirrus],0
	je noci
	jmp   fini

noci: mov   dx,3ceh        ;Test for Paradise
	mov   al,9        ;check Bank switch register
   out   dx,al
   inc   dx
   in al,dx
	dec   dx
   or al,al
   jnz   nopd

   mov   ax,50fh        ;turn off write protect on VGA registers
   out   dx,ax
   mov   dx,offset _pdrsub
   mov   cx,1
   call  _chkbk
	jc nopd        ;if bank 0 and 1 same not paradise
mov paradise, 1
;	bkadr paradise
	mov   dx,3ceh
	mov   al,0bh         ;512k detect from Bob Berry
	out   dx,al
	inc   dx
	in al,dx
	test  al,80h         ;if top bit set then 512k
	jz nop512
	mov   [vga512],1
nop512:  jmp   fini

nopd: mov   ax,5f00h    ;Test for Chips & Tech
	xor   bx,bx
	cld
	int   10h
	cmp   al,5fh
	jnz   noct
mov chipstech, 1
;	bkadr chipstech
	cmp   bh,1
	jb skp4
	mov   [vga512],1
skp4: jmp   fini

noct: mov   ch,0
	mov   dx,3d4h        ;check for Tseng 4000 series
	mov   ax,0f33h
	call  _isport2
	jnz   not4
	mov   ch,1

	mov   dx,3bfh        ;Enable access to extended registers
	mov   al,3
	out   dx,al
	mov   dx,3d8h
	mov   al,0a0h
	out   dx,al
	jmp   short yes4

not4: mov   dx,3d4h        ;Test for Tseng 3000 or 4000
	mov   ax,1f25h    ;is the Overflow High register there?
	call  _isport2
	jnz   nots
	mov   al,03fh        ;bottom six bits only
	jmp   short yes3
yes4: mov   al,0ffh
yes3: mov   dx,3cdh        ;test bank switch register
	call  _isport1
	jnz   nots
mov tseng, 1
;	bkadr tseng
	cmp   ch,0
	jnz   t4mem
	mov   [vga512],1
	jmp   fini

t4mem:   mov   dx,3d4h        ;Tseng 4000 memory detect 1meg
	mov   al,37h
	out   dx,al
	inc   dx
	in al,dx
	test  al,1000b    ;if using 64kx4 RAMs then no more than 256k
	jz nomem
	and   al,3
	cmp   al,1        ;if 8 bit wide bus then only two 256kx4 RAMs
	jbe   nomem
	mov   [vga512],1
	cmp   al,2        ;if 16 bit wide bus then four 256kx4 RAMs
;	je nomem
;	mov   [vga1024],1    ;full meg with eight 256kx4 RAMs
nomem:
mov tseng4, 1
;   bkadr tseng4
	jmp   short fini

nots:
	mov   dx,3ceh        ;Test for Above A or B chipsets
	mov   ax,200fh
	out   dx,ax
	inc   dx
	nojmp
	in al,dx
	cmp   al,21h
	jz verbt
	cmp   al,20h
	jnz   noab
mov aheada, 1
;	bkadr aheada
	mov   [vga512],1
	jmp   short fini

verbt:
mov aheadb, 1
;	bkadr aheadb
	mov   [vga512],1
	jmp   short fini


noab: mov   dx,3deh        ;Test for Oak Technology
	mov   ax,0ff11h      ;look for bank switch register
	call  _isport2
	jnz   nooak
mov oaktech, 1
;   bkadr oaktech
	mov   al,0dh
	out   dx,al
	inc   dx
	nojmp
	in al,dx
	test  al,80h
	jz no4ram
	mov   [vga512],1
no4ram:  jmp   short fini

nooak:   mov   si,0

fini: mov   ax,si
	mov   [retval],ax
	ret
whichvga endp


_cirrus  proc  near
	mov   dx,3d4h     ; assume 3dx addressing
	mov   al,0ch      ; screen a start address hi
	out   dx,al    ; select index
	inc   dx    ; point to data
	mov   ah,al    ; save index in ah
	in al,dx    ; get screen a start address hi
	xchg  ah,al    ; swap index and data
	push  ax    ; save old value
	push  dx    ; save crtc address
	xor   al,al    ; clear crc
	out   dx,al    ; and out to the crtc

	mov   al,1fh      ; Eagle ID register
	dec   dx    ; back to index
	out   dx,al    ; select index
	inc   dx    ; point to data
	in al,dx    ; read the id register
	mov   bh,al    ; and save it in bh

   mov   cl,4     ; nibble swap rotate count
   mov   dx,3c4h     ; sequencer/extensions
   mov   bl,6     ; extensions enable register

   ror   bh,cl    ; compute extensions disable value
   mov   ax,bx    ; extensions disable
   out   dx,ax    ; disable extensions
   inc   dx    ; point to data
   in al,dx    ; read enable flag
   or al,al    ; disabled ?
   jnz   exit     ; nope, not an cirrus

	ror   bh,cl    ; compute extensions enable value
   dec   dx    ; point to index
	mov   ax,bx    ; extensions enable
   out   dx,ax    ; enable extensions
	inc   dx    ; point to data
	in al,dx    ; read enable flag
   cmp   al,1     ; enabled ?
   jne   exit     ; nope, not an cirrus
   mov   [cirrus],1
;	mov   [bankadr],offset _nobank
;if @Codesize
;   mov   [bankseg],seg _nobank
;endif
exit: pop   dx    ; restore crtc address
   dec   dx    ; point to index
   pop   ax    ; recover crc index and data
   out   dx,ax    ; restore crc value
   ret
_cirrus  endp

_chkbk   proc  near     ;bank switch check routine
   mov   di,0b800h
	mov   es,di
	xor   di,di
	mov   bx,1234h
	call  _gochk
	jnz   badchk
	mov   bx,4321h
   call  _gochk
   jnz   badchk
   clc
   ret
badchk:  stc
   ret
_chkbk   endp

_gochk   proc  near
	push  si
   mov   si,bx

	mov   al,cl
	call  dx
   xchg  bl,es:[di]
	mov   al,ch
	call  dx
   xchg  bh,es:[di]

   xchg  si,bx

	mov   al,cl
   call  dx
   xor   bl,es:[di]
   mov   al,ch
   call  dx
   xor   bh,es:[di]

   xchg  si,bx

   mov   al,ch
   call  dx
   mov   es:[di],bh
   mov   al,cl
	call  dx
   mov   es:[di],bl

   mov   al,0
	call  dx
   or si,si
   pop   si
   ret
_gochk   endp


_pdrsub  proc  near     ;Paradise
   push  dx
	mov   ah,al
   mov   dx,3ceh
   mov   al,9
   out   dx,ax
   pop   dx
   ret
_pdrsub  endp


_isport2 proc  near
   push  bx
	mov   bx,ax
   out   dx,al
   mov   ah,al
   inc   dx
   in al,dx
   dec   dx
   xchg  al,ah
	push  ax
   mov   ax,bx
   out   dx,ax
   out   dx,al
   mov   ah,al
   inc   dx
   in al,dx
   dec   dx
   and   al,bh
	cmp   al,bh
   jnz   noport
   mov   al,ah
   mov   ah,0
   out   dx,ax
	out   dx,al
   mov   ah,al
   inc   dx
	in al,dx
   dec   dx
   and   al,bh
   cmp   al,0
noport:  pop   ax
   out   dx,ax
   pop   bx
   ret
_isport2 endp

_isport1 proc  near
   mov   ah,al
   in al,dx
   push  ax
	mov   al,ah
   out   dx,al
   in al,dx
   and   al,ah
   cmp   al,ah
	jnz   noport2
   mov   al,0
   out   dx,al
   in al,dx
   and   al,ah
   cmp   al,0
noport2: pop   ax
   out   dx,al
   ret
_isport1 endp

   end

