/*       These are various definations which are used by the viewing program
 * 	(jvmain.c) and the video setup program (jvsetup.c).
 *
 *
 */


#ifndef jvsetup_used
#define jvsetup_used


#define viewing_defaults_file "dvpeg.vu"	/* file name for the picture defaults as saved */
#define viewing_defaults_temp_file "dvpeg.vuu"	/* file name for the picture defaults temp storage (ie deleting an entry) */

#define line_buffer_bytes 2400		/* maximum number of bytes to buffer 1 line of the screen image ie 800 * 3 bytes/pixel */

#define video_mem_seg 0xA000				/* start of video mem.  This will change when I get to local-bus cards */

/*
 * Window descriptions ie size
 */

#define preview_win_x 60	/* window where you select resolution */
#define preview_win_y 21


#define text_line_x 5				/* position of text in the lower left corner */
#define text_line_y y_max - 20

#define max_shrink 7			/* maximum shrinking size */

/*
 * drawing routine contrast ... controls
 */

#define con_ctrl(value) (((value - 128) * contrast_scale) >> 5)		/* contrast ... controls, >> 5 is divide by 32 */
#define bright_ctrl(value)  ((value * color_scale) >> 6)			/* >> 6 is divide by 64 */

#define new_tint(data, tf_2) ( (((int)data * tint_factor_1) >> 6) + tf_2 )		/* this is a reduced version of the above 2 equations */

#define  cfg_file_marker 01			/* marker at start of config file as a unique signature */

#define	file_name_len 80				/* length of char string to store full file names + drive + path */
#define	string_len 80					/* default string length */
#define	drive_list_length 10			/* the maximum number of drives in the file list ie # of letters shown */
#define	max_files_selected 10		/* the maximum number of files selected for viewing ie slide show */
#define  number_VGA_cards 20        /* the number of VGA cards supported - must be co-ordinated with the list in jvsetup.h */
#define  number_modes_in_list 25    /* the max number of modes in the user selected list */
#define	max_files_in_list 1000		/* absolute maximum number of files info pointers
													currently aprox 20 bytes each */
#define  init_max_file_records 500	/* initial default value of size of file struct */
#define	max_file_masks 8				/* array of file masks (14 char each ie 8.3 format + null), 0 if not used, string otherwise */
#define	default_slide_show_pause 3	/* default pause for slide show in seconds */


enum jpeg_formats{		/* different types of jpegs, to speedup drawing of most common ie h2v2 */
	H1V1,
	H1V2,
	H2V1,
	H2V2
	};


enum image_formats{		/* image formats supported */
	GIF,
	PPM,
	JPG,
	TGA
	};

enum image_row_ordering{	/* different ways a file can be formated -> this is for fixing the munged saving to the buffer */
	NORMAL,
	UPSIDE_DOWN,
	INTERLACED
	};


enum sorting_names{     /* enum for sorting modes */
	NONE,
	FF_NAME,
	FF_DATE,
	FF_SIZE
	};


enum card_resolution{		/* types of video cards */
	VGA,
	SVGA,				/* from here used to be 0, 1, 2, 3 .. */
	SVGA_15_bit,
	SVGA_16_bit,
	SVGA_24_bit,
	};


/*
 * masks for bits in word describing setup flags
 * -> the view_defaults variable
 */
enum bit_locs{
	grey_bit = 1,
	dithering_bit = 2,
	smoothing_bit = 4,
	quantize_bit = 8,
	panning_bit = 16,		/* disable panning completely ? */
	ask_size_bit = 32,	/* show screen with defaults or pass it ?? */
	beep_on = 64,
	only_hi_color = 128,		/* flag to disable SVGA modes if hi_color is available for a jpeg */
	not_less_hi_color = 256,	/* lock out all SVGA modes less than the lowest hi-color mode for non GIF/color mapped images */
	ascending_bit = 512,		/* sort file info in ascending order ? */
	fifty_line_text = 1024,	/* flag to indicate if 50 line mode should be forced */
	always_pan = 2048,		/* fix the panning always on for zooming ... */
	lock_shrink = 4096,		/* lock for shrink at a set ratio */
	clear_during_pan = 8192,	/* flag to enable/disable clear of screen when there will be garbage left behind */
	lock_during_pan = 16384, 	/* flag to lock out switching video modes when zoom/shrinking picture */
	};

/*
 * bit locations of the "defaults" integer in the config file
 */
enum default_bits{
	long_file_format = 3,		/* long file format; 0 = short, 1 = medium, 2 = long */
	use_default_file = 4,
	error_msg_on = 8,		/* flag to enable error msg window */
	show_drives = 16,		/* show drives along with the file list ? */
	show_tree = 32,			/* show the directory tree as well ? */
	slide_show_continous = 64,		/* can make slide-show continous */
	shrink_enable_flag = 128,	/* flag to disable shrink to fit */
	clear_before_draw = 256,		/* flag to clear the screen before drawing */
	rgb_flip = 512,          	/* flag to indicate flipping R,B in R,G,B tripletts */
	no_text = 1024,			/* disables return to text on program exit ie leaves graphics in tact */
	show_text = 2048,		/* show text/file_name on the lower L corner if 1 */
	show_title = 4096,	/* show title at top of screen */
	dont_get_files = 8192,		/* get the file list when the program is first run, if not the it uses a supplied one ie the slide show arguements */
	no_file_list = 16384		/* flag to lock out the file list -> reduce user to Next, Previous, Exit */
	};

/*
 * bit location of even more defaults -> variable: more_defaults
 */
enum more_defaults{
/*	slow_gray = 1,			/* use quantizing for JPEGs at all ?? - used to force 16 & 256 color mode to quantize vs quick linear colormaping */
/*	vga_as_color = 2,*/
	high_jpeg_quality = 1		/* use faster, lower quality methods for JPEGs if not set */
	};


/*    definations for reading keyboard */

#define arrow_left 0x4b00
#define arrow_right 0x4d00
#define arrow_up 0x4800
#define arrow_down 0x5000
#define page_up 0x4900
#define page_down 0x5100
#define escape 27
#define home 0x4700
#define end 0x4f00
#define RTN 13
#define control_s 0x19
#define insert 0x5200
#define delete 0x5300
#define plus 43
#define minus 45
#define back_space 8
#define F1 0x3B00
#define F2 0x3C00
#define F3 0x3D00
#define F4 0x3E00
#define F5 0x3F00
#define F6 0x4000
#define F7 0x4100

#define red_up 55			/* red, green, blue tint adjustments ie shift - keypad */
#define red_down 49
#define red_normal 52
#define green_up 56
#define green_down 50
#define green_normal 53
#define blue_up 57
#define blue_down 51
#define blue_normal 54


#endif   /* end of file and including if it has not been used */