/*	          Written by Eric Praetzel (C)  [usenet: praetzel@sunee.waterloo.edu]
 *   Feel free to change this but if you feel its a usefull addition please
 *    tell me so that I can include it for general distribution.
 *
 *   This allows the user to pick a video card and test any supported mode.
 *
 *   The S/W will default to the dvpeg.cfg file or the autodetected card if
 *     the file does not exist.
 *   The user can set defaults for the viewing program here.  The defaults
 *    can be changed in dvpeg but can not be saved.
 *
 *   last changed:  Feburary 14, 1993
 */

/* text screen is: a title on the top line
						 a video card list (columns 1 to 24)
						 a video mode list in the upper right corner (rows 2 to 12)
						 a selected mode list in the lower right (rows 13 to 24)
		--> if the lists ever exceed the ranges scroll bars will have to be added

  THIS IS NOT UPTO DATE - ie DON'T TRUST ANY COMMENTS THAT ARE HERE

  - added custom video mode setup
  - added default setting/changing thru view_defaults int in the dvpeg.cfg file

  problems
  - can't detect S3 chips & others

  - a bad mode number will lock the card in some wierd mode - I don't know how to reset short of the reset key
  - if print onto last line (ie mode list, user mode list) then last line is doubled
  - plotting border has problems on the last char because it causes a CR/LF !!
  - loading the mask string needs a \n termination but this will be added the next time its
		saved (ie you have 2 then 3 then 4 ...  -> so search the string and clip them out - done during loading
*/

#include <conio.h>
#include <stdio.h>
#include <dos.h>

#include "viewdef.h"		/* defines for the viewer */
#include "jvsetup.h"		/* constants and some vars */
#include "view-var.c"		/* variables for dvpeg, vidsetup */
#include "modes.h"


/* light and dark text colors
 * was MAGENTA, LIGHTMAGENTA
 */

#define text_bright LIGHTRED
#define text_dark RED

extern   unsigned char cirrus, everex, paradise, tseng, trident;
extern   unsigned char t8900, ativga, aheada, aheadb;
extern   unsigned char oaktech, video7, chipstech, tseng4, genoa;
extern   unsigned char ncr, compaq, vesa;
extern   unsigned char vga512, vga1024;
extern int fifty_lines;

int modes_available[number_modes_in_list];		/* list of video modes that match the current card */

int mode_lock,
	was_fifty_used;		/* flag to indicate 50 line mode was used - ie therefore use it for DVPEG */

int		color_out,
			flood_fill = 0,	/* flood fill mode for testing screen */
			flood_r, flood_g, flood_b,		/* flood fill colors */
			be_quiet,		/* if set then don't print any output ie if this program was called by dvpeg */
			avoid_test;		/* if user says so then avoid test ie paradise card */


int load_config_vidsetup(char *forced_name);
void borders(int hi_light, int title_color, char *title);
void test_video(int sel_mode);
void help_msg(int which_screen);
void open_window(int width, int height);
int config_video(void);
void video_fill(int gr_row, unsigned int width, unsigned char data);



void insert_in_user_list(int mode, int only_one)
{
int	i;
int	ins_loc;				/* location to insert a new item into the users list of working modes */

/*
 * if it exists then return without insertion
 */
for (i = 0; i < number_modes_in_list; i++)
	if (ok_mode[i] >= 0){
		if (ok_mode[i] == mode) return;		/* exit if its in the list already */
		/* if the size already exists then do not insert (if requested) */
		if ((video_cards[ok_mode[i]].y_size == video_cards[mode].y_size) &&
		only_one != 0) return;
		}

ins_loc = 0;
/* first find the position of a mode that is non 0 and smaller size than the selected */
for (i = 0; i < number_modes_in_list; i++)
	if (ok_mode[i] >= 0){
		if (video_cards[ok_mode[i]].resolution < video_cards[mode].resolution)
			continue;
		if (video_cards[ok_mode[i]].resolution > video_cards[mode].resolution){
			ins_loc = i;
			break;
			}
		/* case of empty list or first item is bigger than that being inserted */
		if ((video_cards[ok_mode[i]].y_size > video_cards[mode].y_size) &&
				(video_cards[mode].y_size != 0)){
			ins_loc = i;
			break;
			}
		/* keep going thru list until we hit a bigger item */
		if ((video_cards[ok_mode[i]].y_size < video_cards[mode].y_size) &&
				(video_cards[mode].y_size != 0))
			ins_loc = i + 1;
		}

/* inserting to a full list does nothing */
i = number_modes_in_list;
while( --i > ins_loc)
	ok_mode[i] = ok_mode[i-1];

/* now insert it - watchout for inserting at top + 1*/
if (ins_loc < number_modes_in_list)
	ok_mode[ins_loc] = mode;
}



/* raw string fill of video memory but watch out for bank crossings
 *
 * video_mem is the address (in the 1M bank) to start at calculated by gr_col and gr_row the row and column address
 * width is the amount of memory (bytes) to copy
 */

void video_fill(int gr_row, unsigned int width, unsigned char data)
{
unsigned int difference;
unsigned long video_mem;
extern int maxx;

	video_mem = (unsigned long) gr_row * maxx;

/* set memory bank */
	_AX = video_mem >> 16;
	newbank();

/* basic size test to see if it is only one line
 *  also account for offset in the drawing if the image is centered
 */
	if (width > maxx) width = maxx;

/* need to check memory bank crossing */
	if ((unsigned long) (video_mem & 0x0ffff) + width > 0xffff){
		difference = (0xffff - (unsigned int) video_mem) + 1;
		_fmemset((void far *) MK_FP(0xA000, (unsigned) video_mem), data, (size_t) difference);
		_AX = (video_mem >> 16) + 1;
		newbank();
		_fmemset((void far *) MK_FP(0xA000, 0), data, (size_t) width - difference);
		}
	else
		_fmemset((void far *) MK_FP(0xA000, (unsigned) video_mem), data, (size_t) width);
}




/*
 * do an autodetect and setup for video card
 */

int config_video(void)
{
int svga, i, ins_loc, video_resolution;

svga=whichvga();

ins_loc = 0;		/* setup index into structure holding video modes */

	if (svga){
		if (aheada == 1) card_id = 0;
		if (aheadb == 1) card_id = 1;
		if (ativga == 1) card_id = 2;
		if (chipstech == 1) card_id = 3;
		if (everex == 1) card_id = 4;
		if (oaktech == 1) card_id = 5;
		if (genoa == 1) card_id = 6;
		if (ncr == 1) card_id = 7;
		if (paradise == 1) card_id = 8;
		if (trident == 1 || t8900 == 1) card_id = 9;
		if (tseng == 1)
			if (tseng4 == 1) card_id = 11;
			else card_id = 10;
		if (video7 == 1) card_id = 12;
		if (cirrus == 1) card_id = 13;
		if (compaq == 1) card_id = 14;
		if (vesa == 1) card_id = 15;
		if (card_id == 0 && aheada != 1) card_id = 16;		/* S3 chips how detect ??? */
/* how detect Diamond Speedstar 24X ???? */

/* only add the modes if we have enough memory */
/* they are still displayed and can be added by the user if the memory detection fails */
		for (video_resolution = SVGA_24_bit; video_resolution >= VGA; video_resolution--){
			i = -1;
			while (ins_loc < number_modes_in_list && video_cards[++i].card_number >= 0){
				if ((video_cards[i].card_number == card_id) && video_cards[i].x_size > 0 && video_cards[i].resolution == video_resolution)
					if	((vga1024 == 1 && ((long)video_cards[i].x_width * video_cards[i].y_size <= (long)1024 * 1024)) ||
						(vga512 == 1 && ((long)video_cards[i].y_size * video_cards[i].x_width <= (long)512 * 1024)) ||
						(vga1024 == vga512 == 0 && ((long)video_cards[i].y_size * video_cards[i].x_width <= (long)128 * 1024)))
							insert_in_user_list(i, video_resolution == VGA);	/* add all modes but VGA ones that are the same size as an existing mode */
				}
			}
		}
	else{
		if (be_quiet == 0){
			printf("No super VGA video card detected.\n");
			printf("However, this program supports several that that it can't detect.\n");
			printf("Defaulting to VGA modes.\n");
			printf("Hit any key.\n");
			getch();
			}
/* don't fail, VGA modes are assumed and will be added later */
/*		return 0;		return this to fail */
		card_id = 19;	/* rigged for plain VGA */
		}
	i = -1;
	while (ins_loc < number_modes_in_list && video_cards[++i].card_number >= 0){
		if ((video_cards[i].card_number == 19) && video_cards[i].x_size > 0)
			insert_in_user_list(i,video_cards[i].resolution == VGA);
	}
return 1;
}



/* draw the dividers on the screen for the text mode video selection
	 hi_light is the flag to draw a bright border around (active area)
  */

void test_video(int sel_mode)
{
int i,
		range,		/* range of colors ie 5 bits for hi_color, 6 for Super VGA */
		x, y,
		x_size,
		y_size,
		video_resolution,
		shift,
		maximum_index;
union REGS regs;

x_size = video_cards[sel_mode].x_size;
y_size = video_cards[sel_mode].y_size;

forcevga(video_cards[sel_mode].card_number);
svgamode(video_cards[sel_mode].set_ax, video_cards[sel_mode].set_bx, video_cards[sel_mode].x_width, video_cards[sel_mode].card_number);

video_resolution = video_cards[sel_mode].resolution;

shift = 0;
switch(video_resolution){
	case VGA:
		range = 64;
		shift = 2;
		break;
	case SVGA:
		range = 64;
		break;
	case SVGA_24_bit:
		range = 256;
		break;
	case SVGA_16_bit:
	case SVGA_15_bit:
		range = 32;
		break;
	}

maximum_index = 0xff;		/* display 256 colors */

if (flood_fill == 0){
	for (i=0; i<256; i++){
		palbuf[i][0] = ((i << shift) >> 0) % range;
		palbuf[i][1] = ((i << shift) >> 1) % range;
		palbuf[i][2] = ((i << shift) >> 2) % range;
		}
	}
else{
	maximum_index = 0;		/* only display the first color */
	/* reset all other colors to the opposite for a more thorough test */
	switch(video_resolution){
		case VGA:
			shift = 1;
			break;
		case SVGA:
			shift = 1;
			break;
		case SVGA_24_bit:
			shift = 3;
			break;
		case SVGA_16_bit:
		case SVGA_15_bit:
			shift = 0;
			break;
		}
	palbuf[0][0] = flood_r << shift;
	palbuf[0][1] = flood_g << shift;
	palbuf[0][2] = flood_b << shift;
	for (i=1; i<256; i++){
		palbuf[i][0] = (31 - flood_r) << shift;
		palbuf[i][1] = (31 - flood_g) << shift;
		palbuf[i][2] = (31 - flood_b) << shift;
		}
	}

if (video_resolution <= SVGA){
/* If using only VGA then set the EGA pallet to point index properly into the SVGA one */
	if (video_resolution == VGA)
		for (i = 0; i < 16; i++){
			regs.h.bl = i;
			regs.h.bh = i;
			regs.x.ax = 0x1000;
			int86(0x10, &regs, &regs);
			}
	setmany(palbuf,0,256);
	}

for(y=0; y < y_size; y++){
	i = y & maximum_index;		/* ie % 256;*/
		switch(video_resolution){
			case SVGA_24_bit:
				for (x=0; x < x_size; x++)
					point_24(x, y, (palbuf[i][2] << 16) + (palbuf[i][1] << 8) + palbuf[i][0]);
				break;
			case SVGA_16_bit:
				for (x=0; x < x_size; x++)
					point_wide(x,y, palbuf[i][2]+(palbuf[i][1]<<5) + (palbuf[i][0] << 11));
				break;
			case SVGA_15_bit:
				for (x=0; x < x_size; x++)
					point_wide(x,y, palbuf[i][2]+(palbuf[i][1]<<5) + (palbuf[i][0] << 10));
				break;
			case SVGA:
				video_fill(y, x_size, i);
				break;
			case VGA:
				for (x=0; x < x_size; x++)
					put16Pixel(x, y, i % 16);
				break;
			}
	if (kbhit()) break;
	}
	getch();

rtn_video();
}



/*
 * return 1 if the mode or card is in the user list
 *  the card value must be set, the index value can be -1 so that just
 *  the existance of the card in the user list is checked
 *  the index is the index into the list of modes and is independant of
 *   card and mode
 */

int mode_inlist(int card, int index)
{
int i, j;

for (i = 0; i < number_modes_in_list; i++)
	if ((j = ok_mode[i]) >= 0){
		if (j == index) return 1;
		if ((video_cards[j].card_number == card) && (index < 0)) return 1;
		}
return 0;
}



/* put a window up in the center of the screen
 *	- ask about panning, video mode ....
 *	- don't worry what is under it because the image will be drawn
 */

void open_window(int width, int height)
{
char char_is;
struct text_info ti;
int i;

window(12, 4, 12 + width, 4 + height);
clrscr();

 /*  border */

gettextinfo(&ti);

textcolor(WHITE);
char_is = 219;			/* solid block */

for (i=1; i <= (ti.winright-ti.winleft); i++){		/* should go 1 count more */
	gotoxy(i, 1);
	putch(char_is);
	gotoxy(i, ti.winbottom - ti.wintop + 1);
	putch(char_is);
	}
for (i=2; i <= (ti.winbottom-ti.wintop); i++){
	gotoxy(1, i);
	putch(char_is);
	gotoxy(ti.winright - ti.winleft, i);		/* had to sub +1 */
	putch(char_is);
	}
window(14, 6, 10 + width, 2 + height);
}



void help_msg(int which_screen)
{
int length;
char text[80];

window(5, 1, 75, 3);		/* print help stuff */
switch(which_screen){
	case 0:
			strcpy(text, "   test (space), DELete, locK, ESC    ");
			break;
	case 1:
			strcpy(text, "test (space), INSert, DELete, RTN, ESC");
			break;
	case 2:
			strcpy(text, "        choose (RTN), exit (ESC)      ");
			break;
	}
length = strlen(text);
gotoxy(40 - length / 2, 1);
textcolor(LIGHTRED);
cprintf("%s", text);
textcolor(WHITE);
}



/*
 * toss a border around the current window
 */

void borders(int hi_light, int title_color, char *title)
{
int i, text_start, text_end, width, height;
char char_is, char_line[string_len+1];
struct text_info ti;

gettextinfo(&ti);

if (hi_light){
	textcolor(WHITE);
	char_is = 219;			/* solid block */
	}
else{
	textcolor(LIGHTGRAY);
	char_is = 177;			/* 1/2 dense block */
	}

width = ti.winright - ti.winleft;
height = ti.winbottom - ti.wintop;
i = strlen(title);
text_start = (width - i) / 2;
text_end = text_start + i;

for (i=1; i <= width; i++){		/* should go 1 count more */
	if (i < text_start || i > text_end){
		gotoxy(i, 1);
		putch(char_is);
		}
	gotoxy(i, height + 1);
	putch(char_is);
	}
for (i=2; i <= height; i++){
	gotoxy(1, i);
	putch(char_is);
	gotoxy(width, i);		/* had to sub +1 */
	putch(char_is);
	}

textcolor(title_color);
if (text_start > 0 && title != NULL){
	gotoxy(text_start, 1);
	cputs(title);
	}
}



/*
 * draw a list of the video modes for a particular card
 */

void modes_for_a_card(int num_lines, int sel_mode)
{
int i, j, text_color;

cprintf("  X  , Y   ,  mode , #       X   ,  Y  ,  mode , #  \n\r");

i = -1;
while (modes_available[++i] >= 0){
	j = modes_available[i];

	text_color = WHITE;
	if (mode_inlist(-1, j)) text_color = text_bright;

	if (modes_available[sel_mode] == j) textbackground(LIGHTGRAY);
	textcolor(text_color);

	cprintf(" %4i %4i %6i  ",video_cards[j].x_size,video_cards[j].y_size,
		video_cards[j].set_ax);
	switch(video_cards[j].resolution){
		case VGA:
			cprintf(" 16");
			break;
		case SVGA:
			cprintf("256");
			break;
		case SVGA_15_bit:
			cprintf("32k");
			break;
		case SVGA_16_bit:
			cprintf("64k");
			break;
		case SVGA_24_bit:
			cprintf("16M");
			break;
		}
	if ((i % 2) == 0) cprintf("     ");
	else					cprintf("\r\n");
	textcolor(WHITE);
	textbackground(BLACK);
	}
}




/*
 * print the list of video modes in the user list
 */

void print_user_modes(int num_lines, int sel_mode, int sel_mode_list)
{
int i, j, text_color;

cprintf(" Video Card,       X,    Y,    AX,    BX,  res.\n\r");
any_hi_color = 0;

/* print the list to a maximum of 9 lines or modes */


for (i=0; i < number_modes_in_list; i++)
	if (ok_mode[i] >= 0){
/* check for any hi_color modes and set flag */
		if ( video_cards[ok_mode[i]].resolution != SVGA)
			any_hi_color = 1;
	/* temp for card # */
		j = ok_mode[i];
		text_color = WHITE;
		if (video_cards[j].y_size == mode_lock) text_color = YELLOW;
		if (i == sel_mode_list)
			textbackground(LIGHTGRAY);
		textcolor(text_color);

			/* temp for real card / mode # if its custom */
		cprintf(" %14s   %4i  %4i %5i %5i  %8s\r\n",video_card_names[video_cards[j].card_number],
			video_cards[j].x_size,
			video_cards[j].y_size,
			video_cards[j].set_ax,
			video_cards[j].set_bx,
			card_type[video_cards[j].resolution]);
		textcolor(WHITE);
		textbackground(BLACK);
		}
}



/*
 * main program
 */

int main(int argc, char *argv[])
{
static int i,
			text_color,			/* color of text being drawn */
			list_line_length,	/* length in line of the mode lists, 3 if 24 line, 15 if 43 line ie show more of the lists */
			temp,					/* temp var for things */
			erase_screen,		/* flag screen erase before redraw */
			exit_now,			/* exit flag for main loop */
			sel_card,			/* pointer into array for selected video card */
			sel_mode,			/* pointer into array for selected mode */
			sel_mode_list,		/* currently item in selected mode list pointed to */
			some,					/* a check to make sure that the user mode list is not empty - otherwise the prog locs! */
			update_file,		/* flag that cfg info has change */
			card_mode_oklist;		/* flag for oklist (0) or card (2) or mode (1) in selection*/
static int cmd;
static struct text_info ti;
static char temp_char[80];

extern unsigned char _video;
unsigned char *ptr;

FILE *config_file;
unsigned int disk_tmp;
char *forced_config_ptr;

 /* if there is an arguement check to see if it is a config file with path
  * or a -quiet arguement meaning don't print anything
  */
be_quiet = 0;
if (argc > 1){
	if (*argv[1] == '-')
		be_quiet = 1;
	else
		forced_config_ptr = argv[1];
	}
else
	forced_config_ptr = NULL;

if (get_video() != 0){		/* preserve the current video mode for exit */
	was_fifty_used = fifty_line_text;
	}
else{
	was_fifty_used = 0;
	}

/* get the dir that we were booted in
 * if the config file is found here then it will be written back here
 * this solves the problem of having the executable on a read-only media
 */
_dos_getdrive(&disk_tmp);

strcpy(file_path, "C:\\");
file_path[0] = disk_tmp + 'A' - 1;
getcurdir(disk_tmp, file_path + 3);
if (strlen(file_path) > 3)   /* watch out for root because its X:/ already */
strcat(file_path, "\\");
strcpy(original_path, file_path);

max_file_records = init_max_file_records;		/* nice default */

/* get current text mode + info -> not Int 10 function 0xf does not work reliably */
/* this comes out of the BIOS space
/* --- this is not complete.  Borland C code will not recognize 132 column text
/*  modes and will do very strange things with them when you setup the text mode
/*  yourself without going thru the Borland code */

text_width = peek(0x40, 0x4a);
text_height = peekb(0x40, 0x84) + 1;
text_mode_number = peekb(0x40, 0x49);

ptr = &_video;
*(ptr+3) = text_height;
*(ptr+7) = text_height + 1;

if ((list_line_length = text_height - 25) < 3) list_line_length = 0;

for (i = 0; i <= number_modes_in_list; i++)
	ok_mode[i] = -1;					/* set to not filled */

/* set up name for config file (dvpeg.cfg) and assume its in the same dir as vidsetup.exe */
strcpy(config_name, argv[0]);
/* change vidsetup.exe to dvpeg.exe */
for (i=strlen(config_name); i >= 0 && config_name[i] != '\\'; i--);
config_name[i+1] = 0;					/* knock off file and add dvpeg.cfg to path in load_config*/
strcpy(code_path, config_name);		/* save path that the prog was booted in */

/* does the dvpeg.cfg file exist? if not do auto detect*/
if ( !load_config_vidsetup(forced_config_ptr) ){
	if (be_quiet == 0){
		printf("If you have a 1M Paradise (or compatable) card then you will want to\n");
		printf(" avoid the autodetection test\n");
		printf("\nDo you wish to avoid the test (Y / N)\n");
		if (toupper(getch()) == 'Y')
			avoid_test = 1;
		}

	if (avoid_test != 1)
		if ( config_video() )	/* is there super VGA ?? */
			update_file = 1;
	}
sel_card = card_id;
sel_mode = sel_mode_list = 0;			/* default to lowest resolution, card detected */

/* sel_mode points into the list of modes_available[] which is made from
	the list of all modes (ie the selected ones match the current card)
	*/

rtn_video();	/* back to text mode */

gettextinfo(&ti);

card_mode_oklist = 2;		/* start with card menu*/

erase_screen = 0;
clrscr();
textcolor(YELLOW);
gotoxy(1,1);
cprintf("Video Setup (F1 - help)                                             Dvpeg");

/* select a video card and mode then test it or update the user mode list */
/* note right side has to be wider to prevent CR/LF on plotting char 1! */

exit_now = 0;

while (be_quiet == 0 && exit_now == 0){
	_setcursortype(_NOCURSOR);			/* hide the cursor*/
	help_msg(card_mode_oklist);
	window(1, 2, 24, 25);
	if (erase_screen){
		clrscr();
		erase_screen = 0;
		}
/* setup the borders on the screen with video card hi_light */
	borders(card_mode_oklist == 2, YELLOW, "Video cards");
	window(2, 3, 23, 24);
	gotoxy(1,1);
	textcolor(WHITE);
	for (i=0; i < number_VGA_cards; i++){
		text_color = WHITE;
		if (mode_inlist(i, -1)){
			text_color = text_dark;
			if (card_mode_oklist == 2)	text_color = text_bright;
			}
		if (i == sel_card) textbackground(LIGHTGRAY);
		textcolor(text_color);
		cprintf(" %s\r\n", video_card_names[i]);
		textcolor(WHITE);
		textbackground(BLACK);
		}

	i = -1;
	temp = 0;
	while (temp < number_modes_in_list && video_cards[++i].card_number >= 0)
		if (video_cards[i].card_number == sel_card && video_cards[i].x_size > 0)
			modes_available[temp++] = i;
	for (; temp < number_modes_in_list; temp++)	/* clear the rest of the list */
		modes_available[temp] = -1;

/*	window(25, 2, 80, 25);		/* plot video mode available THIS IS THE FULL TEXT SPACE AVAILABLE */

/* print video mode list as a short or full list */

	i = 1;
	switch(card_mode_oklist){
		case 2:
		case 1:
			window(25, 2, 80, 22);
			sprintf(temp_char, "Video Modes for %14s",video_card_names[sel_card]);
			borders(card_mode_oklist == 1, YELLOW, temp_char);
			window(26, 3, 78, 21);	/* full menu */
			break;
		case 0:
			window(25, 2, 80, 4 + list_line_length);
			sprintf(temp_char, "Video Modes for %14s",video_card_names[sel_card]);
			borders(card_mode_oklist == 1, YELLOW, temp_char);
			if (list_line_length)
				window(26, 3, 78, 3 + list_line_length);
			else
				i = 0;
		}
	if (i){
		clrscr();
		gotoxy(1,1);
		textcolor(WHITE);
		modes_for_a_card(17, sel_mode);
		}

	i = 1;
	switch(card_mode_oklist){
		case 2:
		case 1:
			window(25, 23, 80, 25 + list_line_length);
			borders(card_mode_oklist == 0, YELLOW," User Selected Video Modes");
			if (list_line_length)
				window(26, 24, 78, 24 + list_line_length);
			else
				i = 0;
			break;
		case 0:
			window(25, 5 + list_line_length, 80, 25 + list_line_length);
			borders(card_mode_oklist == 0, YELLOW," User Selected Video Modes");
			window(26, 6 + list_line_length, 78, 24 + list_line_length);
		}
	if (i){
		clrscr();
		gotoxy(1,1);
		textcolor(WHITE);
		print_user_modes(20, sel_mode, sel_mode_list);
		}

	cmd = get_key();
	if (cmd == escape){
		if (card_mode_oklist == 2) exit_now = 1;
		else card_mode_oklist++;					/* RTN selects mode and/or exit */
		cmd = 0;
		}
	if (cmd == RTN){
		card_mode_oklist--;		/* ESC hops to card select */
		cmd = 0;						/* only change menu, don't act on cmd */
		}
	if (cmd == 'T' || cmd == 't'){		/* create custom text mode */
		open_window(40,10);
		gotoxy(1,1);
		cprintf("What is the mode number (%i)?",text_mode_number);
		gotoxy(1,2);
		if (get_line(temp_char, 4) <= 1) goto break_1;
		sscanf(temp_char, "%i", &text_mode_number);
		gotoxy(1,3);
		cprintf("What is the text height (%i)?", text_height);
		gotoxy(1,4);
		if (get_line(temp_char, 4) <= 1) goto break_1;
		sscanf(temp_char, "%i", &text_height);
		gotoxy(1,5);
		cprintf("What is the text width (%i)?", text_width);
		if (get_line(temp_char, 4) <= 1) goto break_1;
		sscanf(temp_char, "%i", &text_width);

	break_1:
		update_file = 1;
		erase_screen = 1;
		cmd = 0;
		}
	if (cmd == 'C' || cmd == 'c'){		/* create a special mode using the current card */
		open_window(42,11);

		/* cmd points to the next available spot or the top */
		i = cmd = -1;
		while (video_cards[++i].card_number >= 0)
			if (video_cards[i].x_size == 0 && cmd < 0)
				cmd = i;

		if (cmd < 0) cmd = i - 1;		/* set to top if its full ie you can always overwrite the last entry */
		/* insert at index "cmd" */

		video_cards[cmd].card_number = sel_card;

		gotoxy(1,1);
		cprintf("What is the X size: ");
		if (get_line(temp_char, 4) <= 1) goto break_out;
		sscanf(temp_char, "%i", &video_cards[cmd].x_size);

		gotoxy(1,2);
		cprintf("Y size: ");
		if (get_line(temp_char, 4) <= 1) goto break_out;
		sscanf(temp_char, "%i", &video_cards[cmd].y_size);

		gotoxy(1,3);
		cprintf("0,1,2,3,4 = 4,8,15,16,24 bit): ");
		if (get_line(temp_char, 4) <= 1) goto break_out;
		sscanf(temp_char, "%i", &video_cards[cmd].resolution);

		gotoxy(1,4);
		cprintf("mode number (ax in decimal): ");
		if (get_line(temp_char, 4) <= 1) goto break_out;
		sscanf(temp_char, "%i", &video_cards[cmd].set_ax);

		gotoxy(1,5);
		cprintf("BX in decimal (0 if not used): ");
		if (get_line(temp_char, 4) <= 1) goto break_out;
		sscanf(temp_char, "%i", &video_cards[cmd].set_bx);

		gotoxy(1,6);
		video_cards[cmd].x_width = video_cards[cmd].x_size * (1 + video_cards[cmd].resolution);
		if (video_cards[cmd].resolution >= 2) video_cards[cmd].x_width = video_cards[cmd].x_size * video_cards[cmd].resolution;

		cprintf("Line width in bytes (est. %5i)", video_cards[cmd].x_width);
		gotoxy(1,7);
		if (get_line(temp_char, 4) <= 1) goto break_out;
		sscanf(temp_char, "%i", &video_cards[cmd].x_width);

		insert_in_user_list(cmd, 0);

	break_out:
		update_file = 1;
		erase_screen = 1;
		cmd = 0;
		}
	if (cmd == F1){		/* help screen */
		open_window(55, 15);
		cprintf("Enter - hop in one level\r\n");
		cprintf("ESC - hop out one level\r\n");
		cprintf("arrows - move around (usually up/down)\r\n");
		cprintf("T - custom Text mode\r\n");
		cprintf("C - Custom video using selected mfg. card\r\n");
		cprintf("F - toggle/set color to fill screen with\r\n");
		cprintf("F1 - help screen\r\n");
		cprintf("F3 - change viewing defaults\r\n");
		cprintf("F4 - change file mask\r\n");
		cprintf("F5 - change sort method\r\n");
		cprintf("F6 - change defalt file path\r\n");
		cprintf("F7 - change other defaults\r\n");
		switch (card_mode_oklist){
			case 0:
				cprintf("K - lock a video resolution for viewing\n");
				break;
			case 1:
				cprintf("any other key = test mode\n");
				break;
/*			case 2:*/
			}
		erase_screen = 1;
		cmd = 0;
		getch();
		}
		if (cmd == 'f'|| cmd == 'F'){		/* setup test pattern for a flood-fill of one user defined color */
			flood_fill ^= 1;
			if (flood_fill != 0){
				open_window(45, 9);
				cprintf("Picks the colors for filling the screen\r\n");
				cprintf("Red[0..31] = ");
				scanf("%i", &flood_r);
				cprintf("\rGreen[0..31] = ");
				scanf("%i", &flood_g);
				cprintf("\rBlue[0..31] = ");
				scanf("%i", &flood_b);
				erase_screen = 1;
				}
			cmd = 0;
			}
	if (cmd == F3){		/* lets change the defaults */
		do{
			open_window(46,15);
			show_defaults(1);
			}while (	change_defaults(getch()) );
		cmd = 0;
		update_file = 1;
		erase_screen = 1;
		}
	if (cmd == F4){		/* F4 - change file mask */
		open_window(40, 10);
		if(get_file_masks())
			update_file = 1;
		erase_screen = 1;
		cmd = 0;
		}
	if (cmd == F5){
		open_window(40,10);
		cprintf("Sort order is: ");
			switch (sort_mode){
				case NONE:
								cprintf("unsorted");
								break;
				case FF_NAME:
								cprintf("by name");
								break;
				case FF_SIZE:
								cprintf("by size");
								break;
				case FF_DATE:
								cprintf("by date");
								break;
				}
		cprintf("\r\nchoose: Unsorted, Name, Size, Date\r\n");
		i = getch();
		switch (i){
			case 'N':
			case 'n':   sort_mode = FF_NAME;
							break;
			case 'U':
			case 'u':
							sort_mode = NONE;
							break;
			case 'S':
			case 's':
							sort_mode = FF_SIZE;
							break;
			case 'D':
			case 'd':
							sort_mode = FF_DATE;
							break;
			}
		erase_screen = 1;
		update_file = 1;
		cmd = 0;
		}

	if (cmd == F6){		/* F6 - change default file path */
		open_window(50, 10);
		cprintf("The file path is: %25s\r\n\n", default_path);
		cprintf("What is the new path (rtn = clear)?\r\n");
		if (get_line(&temp_char, 25)){
			if (strlen(temp_char) <= 1)	/* 1 char can mean nothing so assume empty */
				strcpy(default_path, "");
			else
				strcpy(default_path, temp_char);
			update_file = 1;
			}
		erase_screen = 1;
		cmd = 0;
		}

	if (cmd == F7){		/* F7 - change other defaults */
		open_window(40, 21);
		do{
			show_extra_defaults();
			}while (	change_extra_defaults(getch()) );
		cmd = 0;
		update_file = 1;
		erase_screen = 1;
		}

	if (card_mode_oklist < 0) card_mode_oklist = 0;
	switch (card_mode_oklist){
		case 0:			/* ok mode list ie select for delete */
			for (some = 0, i=0; i< number_modes_in_list; i++)		/* check for an empty list which would hang the S/W */
				if (ok_mode[i] >= 0)
					some = 1;

			switch (cmd){
				case arrow_up:
					do{
						if (sel_mode_list > 0) sel_mode_list -=1;
						else sel_mode_list = number_modes_in_list - 1;
						} while (ok_mode[sel_mode_list] < 0 && some);
					break;
				case arrow_down:
					do{
						if (sel_mode_list < number_modes_in_list-1) sel_mode_list += 1;
						else sel_mode_list = 0;
						} while (ok_mode[sel_mode_list] < 0 && some);
					break;
				case delete:
					for (i=sel_mode_list; i < number_modes_in_list; i++)
						ok_mode[i] = ok_mode[i+1];
					update_file = 1;
					if (ok_mode[sel_mode_list] < 0)
						sel_mode_list = 0;		/* reset so point points to something */
					break;
				case 'k':
				case 'K':		/* lock a mode for use */
					if (mode_lock >= 0)
						mode_lock = -1;
					else
						mode_lock = video_cards[ok_mode[sel_mode_list]].y_size;
					update_file = 1;
					break;
				case ' ':
					test_video(ok_mode[sel_mode_list]);
				}
				break;
		case 2:			/* select a video card move up/down */
			switch (cmd){
				case arrow_up:
					if (sel_card > 0) sel_card -=1;
					else sel_card = number_VGA_cards - 1;
					sel_mode = 0;		/* old mode number may be high so reset */
					break;
				case arrow_down:
					if (sel_card < number_VGA_cards - 1) sel_card += 1;
					else sel_card = 0;
					sel_mode = 0;
				}
				break;
		case 1:			/* select a video mode -> test/add/del */
			switch (cmd){
				case arrow_up:
				case arrow_left:
					do{				/* make sure that we get an existing mode */
						if (sel_mode > 0) sel_mode -=1;
						else sel_mode = number_modes_in_list - 1;
						} while (modes_available[sel_mode] < 0);
					break;
				case arrow_down:
				case arrow_right:
					do{
						if (++sel_mode >= number_modes_in_list) sel_mode = 0;
						} while (modes_available[sel_mode] < 0);
					break;
				case insert:
					insert_in_user_list(modes_available[sel_mode], 0);
					update_file = 1;
					break;
				case delete:
					/* first find the same mode in the other list */
					for (i=0; i < number_modes_in_list; i++)
						if (modes_available[sel_mode] == ok_mode[i]) break;
					for (; i < number_modes_in_list; i++)
						ok_mode[i] = ok_mode[i+1];
					update_file = 1;
					break;
				case 0:
					break;		/* make sure return, esc does nothing */
				default:			/* default to testing the mode */
					test_video(modes_available[sel_mode]);
			}
			break;
		}
	}

_AH = 0x0;		/* set current text mode */
_AL = text_mode_number;
geninterrupt(0x10);

gettextinfo(&ti);
window(1, 1, ti.winright, ti.winbottom);


normvideo();
clrscr();
_setcursortype(_NORMALCURSOR);

if (update_file){			/* file was changed - does the user want to save it? */
	if (be_quiet == 0){
		printf("The video information has changed.\n\r");
		printf("Do you want to save it (Y or N)?\n\r");
		cmd = toupper(getch());
		}
	else
		cmd = 'Y';
	if (cmd == 'Y'){
		config_file = fopen(config_name,"wb");
		if (config_file != NULL){						/* load the file mode descriptions */
			putc(cfg_file_marker, config_file);		/* config file marker */

			putw(mode_lock, config_file);
			putw(sort_mode, config_file);
			putw(view_defaults, config_file);
			putw(text_mode_number, config_file);	/* text mode (custom) number for dvpeg */
			putw(text_width, config_file);         /* text width, height for custom mode */
			putw(text_height, config_file);
			putw(slideshow_pause, config_file);
			putw(max_file_records, config_file);
			putw(defaults, config_file);
			putw(lock_shrink_value, config_file);
			putw(buffer_size, config_file);
			putw(twiddle_factor, config_file);		/* for future expansion */
			putw(more_defaults, config_file);
			putw(0, config_file);
			putw(0, config_file);

			i = 0;			/* now the list of file masks, list is terminated by an empty mask */
			do{
				fputs(file_masks[i++], config_file);
				fputs("\n", config_file);
				} while (strlen(file_masks[i]) > 0 && (i < max_file_masks));
			fputs("\n", config_file);		/* signal end of file masks */

			fputs(default_path, config_file);
			fputs("\n", config_file);

/* dump out card, mode #'s for all modes followed by -1,XX */
			for (i = 0; i < number_modes_in_list; i++)
				if (ok_mode[i] >= 0){
					putw(ok_mode[i], config_file);		/* save this to allow reconstruction of the list when loading */
					putw(video_cards[ok_mode[i]].card_number, config_file);
					putw(video_cards[ok_mode[i]].x_size, config_file);
					putw(video_cards[ok_mode[i]].y_size, config_file);
					putw(video_cards[ok_mode[i]].resolution, config_file);
					putw(video_cards[ok_mode[i]].set_ax, config_file);
					putw(video_cards[ok_mode[i]].set_bx, config_file);
					putw(video_cards[ok_mode[i]].x_width, config_file);
					}
			putw(-1, config_file);		/* signal end of modes / file */
			fclose(config_file);
			}
		else
			printf("Error saving the file.\r\n");
		}
	}
rtn_video(0);	/* restore the original video mode */

return(0);
} 	/* main */



/*
 * load_config for vidsetup only  ie it throws away info about the table of usefull modes
 *
 * setup defaults in case this is the first time used
 */

int load_config_vidsetup(char *forced_name)
{
int	i, j,
		card_selected,
		return_code = 1,
		num_custom;		/* index for custom modes */

FILE *config_file;

/* defaults in-case no file exists */

view_defaults = dithering_bit | quantize_bit | panning_bit | ask_size_bit | beep_on | ascending_bit;
defaults = use_default_file | long_file_format | show_tree | show_drives | shrink_enable_flag | error_msg_on;
defaults |= was_fifty_used;		/* also add 50 line mode if that was used */
more_defaults = 0;

buffer_size = 8;                /* default to 16k, should work well with GIFs */
twiddle_factor = 20;
lock_shrink_value = shrink = 1;

mode_lock = -1;
strcpy(file_masks[0], "*.gif");			/* make sure there is one default file mask */
strcpy(file_masks[1], "*.jpg");
strcpy(file_masks[2], "*.p?m");
strcpy(file_masks[3], "*.tga");

slideshow_pause = default_slide_show_pause;

config_file = NULL;
if (forced_name != NULL){		/* has a name been forced? */
	strcpy(config_name, forced_name);
	config_file = fopen(config_name, "rb");
	if (config_file != NULL)
		if (getc(config_file) != cfg_file_marker){		/* if there is a bad marker don't use info */
			fclose(config_file);
			config_file = NULL;
			}
		else{
			rewind(config_file);
			return_code = 2;		/* signal forced file was good and used */
			}
	}

if (config_file == NULL){
	strcpy(config_name, original_path);		/* first try boot path for config file */
	strcat(config_name, config_file_name);
	config_file = fopen(config_name, "rb");
	}
if (config_file == NULL){
	strcpy(config_name, code_path);		/* now try path to the executable */
	strcat(config_name, config_file_name);
	config_file = fopen(config_name, "rb");
	}
if (config_file != NULL){						/* load the file mode descriptions */
	if (getc(config_file) != cfg_file_marker){	/* check the marker to see if it is a good file */
		fclose(config_file);
		return 0;
		}

	mode_lock = getw(config_file);
	sort_mode = getw(config_file);
	view_defaults = getw(config_file);				/* various defaults ie grey ... */
	text_mode_number = getw(config_file);
	text_width = getw(config_file);
	text_height = getw(config_file);
	slideshow_pause = getw(config_file);
	max_file_records = getw(config_file);
	defaults = getw(config_file);
	shrink = lock_shrink_value = getw(config_file);
	buffer_size = getw(config_file);
	twiddle_factor = getw(config_file);
	more_defaults = getw(config_file);
	getw(config_file);		/* for future expansion */
	getw(config_file);

	i = -1;			/* now the list of file masks, list is terminated by an empty mask */
	do{
		fgets(file_masks[++i], 15, config_file);
		for (j=0; j < 15; j++)
			if (file_masks[i][j] == '\n') file_masks[i][j] = 0;		/* remove that \n since it is only needed for loading string in */
		} while (strlen(file_masks[i]) > 0 && i < max_file_masks);

	fgets(default_path, 78, config_file);			/* default path ?? */
	for (i=0; i < 78; i++)
		if (default_path[i] == '\n') default_path[i] = 0;		/* remove that \n since it is only needed for loading string in */
	i = -1;
	while((card_selected = getw(config_file)) != -1){
		ok_mode[++i] = card_selected;		/* strip off vidsetup specific info */
		if (i >= number_modes_in_list) i = number_modes_in_list - 1;
		if (video_cards[ok_mode[i]].x_size == 0){
			video_cards[ok_mode[i]].card_number = getw(config_file);
			video_cards[ok_mode[i]].x_size = getw(config_file);
			video_cards[ok_mode[i]].y_size = getw(config_file);
			video_cards[ok_mode[i]].resolution = getw(config_file);
			video_cards[ok_mode[i]].set_ax = getw(config_file);
			video_cards[ok_mode[i]].set_bx = getw(config_file);
			video_cards[ok_mode[i]].x_width = getw(config_file);
			}
		else{
			getw(config_file);
			getw(config_file);
			getw(config_file);
			getw(config_file);
			getw(config_file);
			getw(config_file);
			getw(config_file);
			}
		}
	fclose(config_file);
	card_id = video_cards[ok_mode[0]].card_number;		/* set default video card */
	return return_code;
	}
else
	return 0;
}
