/*
 *   (C) Eric Praetzel 1992
 *
 *  messy utilities for dvpeg viewer and video setup program
 *
 */

#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <mem.h>
#include <alloc.h>
#include "viewdef.h"
#include "extern.h"




/*
 *  init the video structure to -1 in all elements
 */

void clear_video_struct(void)
{
memset(&video_cards ,-1, sizeof(struct video_card) * number_modes_in_list);
}



/*
 * this is the keyboard checking routine for each image decoding scheme
 * if a key is hit while decoding then set the flag
 * if the ESC key is hit then do an immediate exit to the error trap
 *  with the char E which signals a quick exit from decoding
 *
 * note: an "E" char will exit without messages but may beep (if it is on)
 *       a "" char will exit without messages or beep
 */

void check_keybd(decompress_info_ptr cinfo, char * string)
{
if (kbhit()){
	key_hit = 1;		/* exit slide show if it is not ESC */
	if (getch() == escape)
		ERREXIT(cinfo->emethods, string);
	}
}



/*
 *  Get a line of text but return and signal if ESC is hit
 *    return # char + 1 for return if ok,   0 if ESC hit
 *    that way a null input but not escape has a length of 1
 * returning -1 means delete was hit
 * limit string length to 'max' characters for file name input
 */

int get_line(char * input_line, int max)
{
int i = 0;		/* current character entered ==> limit to 13 char ie 8.3 format */
int new_ch;

_setcursortype(_NORMALCURSOR);
do{
if ( (new_ch = getche()) == 0) new_ch = getche() << 8;
/*	new_ch = getche();*/
	if (new_ch == delete) return -1;
	input_line[i++] = new_ch;
	if (i >= max) i = max;			/* limit size to not overflow array */
	if (new_ch == back_space)
		if ((i -= 2) < 0) i = 0;
	} while ((new_ch != escape) && (new_ch != RTN));
input_line[i-1] = 0;
_setcursortype(_NOCURSOR);
if (new_ch == escape) return 0;
else return i;
}





/* do an insertion into the users list of modes ie the "edited" list
 * handle the special case of inserting a "custom" item
 * mode, card describe what you want to insert
 * if that mode already exists then do not insert
 * insert the resolutions with the lowest at the bottom
 *
 * only_one is a flag indicating that only one of a given resolution should exist
 *   ie if 640 * 480 * 24 bit exists then do not add 640 * 480 * 16 bit
 */

void insert_in_list(int mode, int only_one)
{
int	i;
int	ins_loc;				/* location to insert a new item into the users list of working modes */

ins_loc = 0;
/* first find the position of a mode that is non 0 and lower resolution than the selected */
for (i = 0; i < number_modes_in_list; i++)
	if (ok_mode[i] >= 0){
		if (ok_mode[ins_loc] == mode) return;		/* exit if its in the list already */
		if ((video_cards[ok_mode[i]].y_size < video_cards[mode].y_size) &&
				(video_cards[mode].y_size != 0))
			ins_loc = i + 1;
		}
/* if the resolution already exists then do not insert (if requested) */
if ((video_cards[ok_mode[ins_loc]].y_size == video_cards[mode].y_size) &&
	only_one != 0) return;

/* inserting to a full list does nothing */
i = number_modes_in_list;
while( --i > ins_loc)
	ok_mode[i] = ok_mode[i-1];

/* now insert it - watchout for inserting at top + 1*/
if (ins_loc < number_modes_in_list)
	ok_mode[ins_loc] = mode;
}




/*
 * dump the current defaults into the window
 * only flag is to show it all or partially
 * assume that the window is big enough
 */

#ifndef small_viewer

void show_defaults(int all, int jpeg_detail)
{
if (all){		/* only show this for vidsetup and outer file selection menu */
	cprintf("preview Menu: ");
	if (view_defaults & ask_size_bit)
		cprintf("on ");
	else
		cprintf("off");

	cprintf("\r\nPanning: ");
	if (view_defaults & always_pan)
		cprintf("always on");
	else
		if (view_defaults & panning_bit)
			cprintf("enabled  ");
		else
			cprintf("off      ");
	}
else{
	cprintf("Panning: ");
	if (!(view_defaults & panning_bit))
		cprintf      ("disabled ");
	else
		if (enable_pan)
			if (view_defaults & always_pan)
				cprintf("always on");
			else
				cprintf("on       ");
		else
			cprintf   ("off      ");
	}

	cprintf("   Shrink: ");
	if (defaults & shrink_enable_flag)
		if (view_defaults & lock_shrink)
			cprintf("locked 1/%i", lock_shrink_value);
		else
			if (all)
				cprintf("automatic");
			else
				cprintf("1/%i     ", shrink);
	else
		cprintf("disabled");

	if (jpeg_detail){
		cprintf("\r\nDithering: ");
		if (view_defaults & dithering_bit)
			cprintf("on ");
		else
			cprintf("off");

		cprintf("       Quantize ");
		if (view_defaults & quantize_bit)
			cprintf("two");
		else
			cprintf("one");
		cprintf(" pass\r\n");

		if (more_defaults & high_jpeg_quality)
			cprintf("high quAlity jpeg    ");
		else
			cprintf("medium quAlity jpeg  ");

		if (view_defaults & grey_bit)
			cprintf("show jpeg as Grayscale\r\n");
		else
			cprintf("show jpeG as stored   \r\n");

		if (any_hi_color){
			cprintf("svga Lockout: ");
			if (view_defaults & only_hi_color)
				cprintf("on ");
			else
				cprintf("off");
			cprintf(" & loWer: ");
			if (view_defaults & not_less_hi_color)
				cprintf("on \r\n");
			else
				cprintf("off\r\n");
			}
		}
	else
		cprintf("\r\n");
}



/*
 * change the defaults in view_defaults int if requested
 * returned flag:
 *  0 = unknown key
 *  1 = good key
 *  2 = good key, recalc defaults
 */

int change_defaults(int choice, int all)
{
int flag = 1;
unsigned int mask;

mask = 0;		/* mask out JPEG controls if the file is not JPEG */
if (all || type_of_picture == JPG) mask = 0xffff;

switch(toupper(choice)){
	case 'L':
			flag = 2;
			view_defaults ^= only_hi_color;
			break;
	case 'W':
			flag = 2;
			view_defaults ^= not_less_hi_color;
			break;
	case 'P':	/* cycle panning off -> on -> always -> off -> on .... */
			if (view_defaults & always_pan){
				view_defaults ^= always_pan;	/* if always then toggle always on*/
				view_defaults ^= panning_bit;	/* toggle panning to off */
				break;
				}
			if (view_defaults & panning_bit)
				view_defaults |= always_pan;
			else
				view_defaults ^= panning_bit;
			break;
	case 'A':
			more_defaults ^= high_jpeg_quality;
			break;
	case 'M':
			view_defaults ^= ask_size_bit;
			break;
	case 'Q':
			view_defaults ^= (quantize_bit & mask);
			break;
	case 'D':
			view_defaults ^= (dithering_bit & mask);
			break;
	case 'G':
			flag = 2;
			view_defaults ^= (grey_bit & mask);
			break;
	case 'S':
			if ((defaults & shrink_enable_flag) == 0)
				defaults ^= shrink_enable_flag;
			else{
				if (all) view_defaults |= lock_shrink;
				if (++shrink > max_shrink){
					if (view_defaults & lock_shrink)
						defaults &= (~shrink_enable_flag);
					shrink = 1;
					view_defaults ^= lock_shrink;
					}
				lock_shrink_value = shrink;		/* always update */
				}
			break;
	default:
		return 0;
	}
return flag;		/* signal it was a good key */
}



/*
 * a 2nd screen of settable defaults (user calles this one up)
 * these should not be accessed that often once set
 */
void show_extra_defaults(void)
{
gotoxy(1,1);

#ifndef dvpeg_viewer
	cprintf("Maximum # of files in list (%4i)?\r\n", max_file_records);
#endif

cprintf("file liSt is ");
if (defaults & no_file_list)
	cprintf("off");
else
	cprintf("on ");

cprintf("\r\nshow Drives (");
if (defaults & show_drives)
	cprintf("Y)");
else
	cprintf("N)");

cprintf(" | dir Tree (");
if (defaults & show_tree) cprintf("Y)");
else cprintf("N)");

cprintf("\r\nLong file format? (");
if (defaults & long_file_format) cprintf("Y)");
else cprintf("N)");

cprintf("\r\nfile sort Order is (");
if (view_defaults & ascending_bit) cprintf("ascending) ");
else cprintf("descending)");

cprintf("\r\nuse defaults File (");
if (defaults & use_default_file) cprintf("Y)");
else cprintf("N)");

cprintf("\r\nshow Error messages? (");
if (defaults & error_msg_on) cprintf("Y)");
else cprintf("N)");

cprintf("\r\nend of Pic. beep is ");
if (view_defaults & beep_on)
	cprintf("on ");
else
	cprintf("off");

cprintf("\r\nslideshow Pause (+,-) = %2i sec", slideshow_pause);

cprintf("\r\nClear screen before draw is ");
if (defaults & clear_before_draw)
	cprintf("on ");
else
	cprintf("off");

cprintf("\r\nRgb order is ");
if (defaults & rgb_flip)
	cprintf("bgr");
else
	cprintf("rgb");

cprintf("\r\n50 line teXt mode is ");
if (view_defaults & fifty_line_text)
	cprintf("on ");
else
	cprintf("off");

/*
cprintf("\r\nfile bUffer is %2ik", buffer_size);
*/

cprintf("\r\ntWiddle = %2i pixels", twiddle_factor);

cprintf("\r\nclear during panning is (V) ");
if (view_defaults & clear_during_pan)
	cprintf("on ");
else
	cprintf("off");

cprintf("\r\nlock video mode for shrink (G) ");
if (view_defaults & lock_during_pan)
	cprintf("on ");
else
	cprintf("off");

cprintf("\r\ntext line (Y) ");
if (defaults & show_text)
	cprintf("on ");
else
	cprintf("off");

cprintf(" | title is (Z) ");
if (defaults & show_title)
	cprintf("on ");
else
	cprintf("off");
/*
cprintf("\r\nQuantize 16 color jpeg (");
if (more_defaults & slow_gray)
	cprintf("Y)");
else
	cprintf("N)");

cprintf("\r\n16 color jpeg (U) (");
if (more_defaults & vga_as_color)
	cprintf("Y)");
else
	cprintf("N)");
*/
}



/*
 * check for appropiate key presses to extra_defaults list
 * returned flag:
 *  0 = unknown key
 *  bit 0 = 1 = good key
 *  bit 1 = 2 = good key, reget file list
 *  bit 2 = 4 = good key, redraw screen
 */
int change_extra_defaults(int choice)
{
int flag = 1;

switch(toupper(choice)){
	case 'M':
		#ifndef dvpeg_viewer
		max_file_records += 50;
		if (max_file_records > max_files_in_list) max_file_records = 50;
		#endif
/*		if (file_info_head != NULL) farfree(file_info_head);*/
		break;
	case 'X':	/* toggle 50 line text mode */
		view_defaults ^= fifty_line_text;
		flag = 4;
		break;
	case 'O':
		flag = 2;
		view_defaults ^= ascending_bit;
		break;
	case 'D':
		flag = 2;
		defaults ^= show_drives;
		break;
	case 'S':
		defaults ^= no_file_list;
		break;
	case 'E':
		defaults ^= error_msg_on;
		break;
	case 'T':
		flag = 2;
		defaults ^= show_tree;
		break;
	case 'F':
		defaults ^= use_default_file;
		break;
	case 'L':
		flag = 4;
		defaults ^= long_file_format;
		break;
	case '+':
		slideshow_pause++;
		if (slideshow_pause > 30) slideshow_pause = 0;
		break;
	case '-':
		slideshow_pause--;
		if (slideshow_pause < 0) slideshow_pause = 0;
		break;
/*	case 'B':
		view_defaults ^= smoothing_bit;
		break;
*/
	case 'P':
		view_defaults ^= beep_on;
		break;
	case 'C':
		defaults ^= clear_before_draw;
		break;
	case 'R':
		defaults ^= rgb_flip;
		break;
	case 'W':	/* twiddle factor for image screen selection */
		twiddle_factor += 2;
		if (twiddle_factor > 60) twiddle_factor = 0;
		break;
	case 'V':
		view_defaults ^= clear_during_pan;
		break;
	case 'G':
		view_defaults ^= lock_during_pan;
		break;
/*	case 'U':		/* change file buffer size, 4k min, 32k max */
/*		if (buffer_size < 4) buffer_size = 4;
		else buffer_size <<= 1;
		if (buffer_size > 32) buffer_size = 4;
		break;
*/
/*	case 'U':
		if (more_defaults ^= vga_as_color)
			more_defaults |= slow_gray;	/* also turn on quantizing since it is needed */
/*		break;*/
	case 'Y':
		defaults ^= show_text;
		break;
	case 'Z':
		defaults ^= show_title;
		break;
/*	case 'Q':
		more_defaults ^= slow_gray;
		break;
*/
	default:
		return 0;		/* bad key so exit with 0 */
	}
return flag;		/* good key so return signal */
}

#endif	/* if smaller viewer - ie save memory */


/*
 * short message if there is a problem in the config file
 */

void config_problem(int problem_number)
{
printf("Error %i in dvpeg.cfg file.\r\n", problem_number);
printf("Perhaps the file does not exist or was corrupted.\r\nPlease delete dvpeg.cfg and run vidseteup.\r\n");
exit(-1);
}



/*
 * get a key and strip that pesky 0 if its a usefull {arrow, page, insert, delete ..} key
 */

int get_key(void)
{
int cmd;
if ( (cmd = getch()) == 0) cmd = getch() << 8;
return cmd;
}



/*
 * update the list of file masks from the keyboard
 * on each 'enter' go-to the next entry (null = end) untill one empty one is show (or ESC hit)
 * - each can be retyped, first char as space = delete
 *
 * return 1 if anything was changed (ret_value)
 */

int get_file_masks(void)
{
char new_mask[20];
int exit = 0, index = 0, ret_value = 0;
int result;

do{
	clrscr();
	cprintf("Enter, Del to continue or delete\r\n");
	cprintf("Mask #%i :%13s\r\n", index + 1, file_masks[index]);

	result = get_line(new_mask, 13);		/* if something was entered ie ESC not hit */
	if (result > 0){		/* if something was entered ie ESC not hit */
		if (strlen(new_mask) > 1){
			strcpy(file_masks[index], new_mask);
			ret_value = 1;
			}
		}
	if (result == 0)
		exit = 1;

	if (result < 0){		/* delete an entry ?? */
		ret_value = 1;
		for (result = index; result < max_file_masks - 1; result++){
			strcpy(file_masks[result], file_masks[result + 1]);
			}
		file_masks[max_file_masks - 1][0] = 0;		/* make sure the last is cleared */
		}
	else
		if (++index >= max_file_masks)
			exit = 1;
	} while (!exit);
return ret_value;
}




/****************************************************************************
*
*       originally from SuperVGA Test Library
*
*                   Copyright (C) 1993 Kendall Bennett.
*							All rights reserved.
*/

void writeText(int x,int y,unsigned char *str)
/****************************************************************************
*
* Function:		writeText
* Parameters:	x,y		- Position to begin drawing string at
*				str		- String to draw
*
* Description:	Draws a string using the BIOS 8x16 video font by plotting
*				each pixel in the characters individually. This should
*				work for all video modes.
*
****************************************************************************/
{
	unsigned char			byte;
	unsigned char			FAR *_font;
	int				i,j,k,length,ch, color;
	struct REGPACK	regs;

	regs.r_ax = 0x1130;
	regs.r_bx = 0x0600;
	intr(0x10,&regs);
	_font = MK_FP(regs.r_es,regs.r_bp);

	length = strlen(str);
	for (k = 0; k < length; k++) {
		ch = str[k];
		for (j = 0; j < 16; j++) {
			byte = *(_font + ch * 16 + j);
			for (i = 0; i < 8; i++) {
				switch (video_resolution){
					case VGA:
						if ((byte & 0x80) != 0)
							put16Pixel(x+i, y+j, text_drawing_for);
						else
							put16Pixel(x+i, y+j, text_drawing_bk);
						break;
					case SVGA:
						if ((byte & 0x80) != 0)
							point(x+i, y+j, text_drawing_for);
						else
							point(x+i, y+j, text_drawing_bk);
						break;
					case SVGA_15_bit:
					case SVGA_16_bit:
						if ((byte & 0x80) != 0)
							color = 0xffff;
						else
							color = 0x00;
						point_wide(x+i, y+j, color);
						break;
					case SVGA_24_bit:
						if ((byte & 0x80) != 0)
							point_24(x+i, y+j, 0xffffff);
						else
							point_24(x+i, y+j, 0x000000);
						break;
					}
				byte <<= 1;
				}
			}
		x += 8;
		}
}



