/*
 * declarations for all structs ... in the viewer
 *	  - it is assumed that everything is external
 *   - to find descriptions look in view-var.c
 */

#include "jinclude.h"		/* for some later decl */
#include "viewdef.h"
#include <time.h>

extern unsigned long
near_memory_view, far_memory_view;

extern int twiddle_factor;		/* the amount of "play" in pic size before the image shrinks or pans (X or Y axis)
											ie if the pick is < 640 + twiddle it will not use panning or shirk on a 640 wide screen ... */

extern int type_of_picture;
extern int jpeg_type;

extern int config_found;
extern unsigned char far * line_buffer_ptr;		/* pointer to a buffer for 1 drawn line -> maximum 640 * 3 = 1920 bytes (currently) */

extern int tint_loaded;					/* flag to indicate if tinting adjustments are loaded for a picture */
extern JSAMPARRAY remap;		/* colormap array for remaping 256 color GIF -> 16 grayscale for 16 color modes */
extern JSAMPARRAY tint_table;	/* table to speed up tinting of 15/16/24 bit screens */

extern char picture_description[40];		/* description of picture - read from a 4DOS file DESCRIPT.ION - perhaps add into my info later on */

extern char picture_text[file_name_len];			/* file-name to be put on the screen before and optionally after drawing picture  ie file name or a defined string */
extern char picture_text_arguement[file_name_len];			/* title passed in as an arguement, either len 0 or the string */

extern char picture_title[file_name_len];			/* title to be put on the screen before and optionally after drawing picture  ie file name or a defined string */
extern char picture_title_arguement[file_name_len];			/* title passed in as an arguement, either len 0 or the string - usually the 4DOS description */

extern int video_display_resolution;

extern int lock_shrink_value;

extern struct video_card {
	int card_number;		/* same index as video_card_names and list in .asm video routines */
	int x_size;
	int y_size;
	int resolution;	/* check enum:  0 = 256, 1 = 15 bit, 2 = 24 bit */
	int set_ax;			/* value to force AX, BX */
	int set_bx;
	int x_width;		/* x_width for odd sizes ie 24 bit ... */
	} video_cards[];


extern struct dir_info{			/* struct for file names, size ... */
	char name[13];
	char slide_num;				/* index for slide show */
	unsigned  date;
	long size;
	} far * file_info_head;		/* pointer to start of whole struct */


extern struct view_info {
	char file_name[13];		/* name in the 8.3 format with a terminating char */
	char resolution;			/* resolution (ie SVGA, 15 bit, 24 bit ) */
	char shrink;				/* shrink factor ie 1, 2, 3, 4 */
	char red_tint;
	char green_tint;
	char blue_tint;
	char contrast;
	char bright;
	int offset_x;		/* offset of the image - ie upper right corner to be viewed */
	int offset_y;
	int video_size_x;	/* size of the video screen in pixels */
	int video_size_y;
	} view_setup_info;


/* slideshow delay timer */
extern time_t time_at_start;

/* now the list of working modes as selected by the user*/
/* one extra item at end (always < 0) to simplify deletion */
extern int ok_mode[number_modes_in_list+1];		/* used by drawing routines etc - mode listed as edited for gif, jpeg*/

extern int all_modes[number_modes_in_list+1];		/* the total list of modes as read in */

extern	unsigned char palbuf[256][3];

extern char * video_card_names[];	/* list of video card names */

extern   unsigned char cirrus, everex, paradise, tseng, trident;
extern   unsigned char t8900, ativga, aheada, aheadb;
extern   unsigned char oaktech, video7, chipstech, tseng4, genoa;
extern   unsigned char ncr, compaq, vesa;
extern   unsigned char vga512, vga1024;
extern   int maxx, maxy;			/* video routine max x,y values */
		/* maxx is the width of 1 video line in bytes for calculating the video address of a certain line */

extern int
	view_defaults,		/* viewer defaults as spec'd in viewdef.h */
	defaults,
	more_defaults;

extern int
	text_drawing_for,		/* color to draw the text in the 256 color modes */
	text_drawing_bk,		/* background ie color under the text drawn */
	buffer_ok,
	buffer_size,
	mode_lock,
	current_graphics_mode,
	text_height,
	text_mode_number,
	enable_pan,
	shrink,
	zoom_inc,
	card_id,
	slideshow_pause,
	do_slide_show,		/* flag that the slide show is turned on */
	video_mode_used,	/* index into struct for mode number being used */
	video_resolution,	/* 0 for 8 bit, 1 for 15 bit, 2 for 24 bit */
	x_max,		/* maximums of the screen pixel size */
	y_max,
	row_ordering,		/* enum holding format of picture ie INTERLACED, NORMAL, UPSIDE_DOWN */
	sort_mode,
	text_width,
	any_hi_color,
	max_file_records,
	sort_mode,		/* sort type for file names */
	first_file,
	number_files,
	number_pages,
	per_page,
	num_cols,
	column_width,
	selected_file,
	per_column,			/* the number of files per column on text screen */
	files_per_page,	/* nominal # files per page ie 22 * 6 wide */
	cols_per_page,		/* nominal # columns ie 2 blanks at sides */
	min_col_width,		/* minimum column width currently 13 char (includes spaces) */
	max_col_width,		/* maximum column width - currently 26 */
	key_hit;				/* flag that a non ESC key was hit during decompression */

extern int red_tint, green_tint, blue_tint,	/* red, green, blue tint controls */
	color_scale,		/* factor to scale pallete up or down */
	contrast_scale,	/* factor to scale contrast up or down  0 -> +/-32 */
	tint_factor_1,    /* intermediate variables for tint calculations ie it speeds up the calculations greatly */
	tint_lookup,
	tint_factor_red,
	tint_factor_blue,
	tint_factor_green,
	allow_video_exit;

extern int
	number_pallet_colors,		/* number of colors in the pallet used, usually 16 or 256 */
	image_x_dim,
	image_y_dim,
	image_x_offset,
	image_y_offset,
	image_x_max,
	image_y_max,
	picture_x_offset,
	picture_y_offset,
	picture_x_center,
	picture_y_center,
	picture_x_dim,
	picture_y_dim,
	picture_x_max,
	picture_y_max,
	picture_x_size,		/* image x, y size */
	picture_y_size,
	bytes_per_pixel,
	bytes_per_line,
	visable_bytes_per_line;

extern int
	gr_row,  		/* gr_row,col for pixel plotting*/
	gr_col,
	col_cntr,
	row_cntr,
	read_row;		/* row for indexing into big buffer for reading ie panning */


extern	int hi_color;      /* signals existance of hi color card */
extern	int show_next_file;		/* flag to hop to next file without menu */

/* buffer pointer for panning if needed/possible */
extern big_sarray_ptr raw_pic_ptr;		/* pointer to virt. pic. for panning, 3 used for hi_color mode; 1 otherwise */


/* stuff for file selection */

extern char file_masks[max_file_masks][13];		/* array of file masks (14 char each ie 8.3 format + null), 0 if not used, string otherwise */
extern char file_path[file_name_len];	/* path to files to be viewed */
extern char original_path[file_name_len];
extern char code_path[file_name_len];
extern char default_path[file_name_len];	/* default path to pictures */
extern char config_name[file_name_len]; 		   /* path to configuration file -> assuem its in the same dir as vidsetup.exe */
extern char file_being_viewed[20];	/* current file being viewed */
extern int drive_list[drive_list_length];		/* list of good drives - floppy & hard */
extern unsigned int
	max_drives;			/* the maximum number of drives available */


/*
 * procedure declarations from jvmain.c
 */

void fake_colormap(decompress_info_ptr cinfo, JSAMPARRAY cmap, int num_colors);
int keymatch (char * arg, const char * keyword, int minchars);
int parse_switches (decompress_info_ptr cinfo, int argc, char * argv[], int start_arg);
void quantize_colormap(decompress_info_ptr cinfo);

void read_non_jpeg(decompress_info_ptr cinfo);
void pause_for_slideshow(void);
void check_file_in(decompress_info_ptr cinfo);
void show_it(decompress_info_ptr cinfo, char * file_name);
void clear_list(void);
void init_file_struct(void);
void set_video(int mode_index);
void make_mode_list(decompress_info_ptr cinfo);
void setup_file_info(int file_index, int drawing_index);
int insert_in_place(char * f_name, long f_size, int f_date, int sorting_mode, int start_index, int slide_position);		/* sort, insertion routine for file list */
void autocheck_panning(int mode_used);		/* test to see if panning should be used */
void autocheck_shrinking(int mode_used);	/* set the shrinking to defaults values for mode, pic size */
int pick_screen_mode(void);		/* compare picture size with available modes and select a mode and set the shrink size */
int find_picture_setup(FILE * file_in);		/* check thru the given file for viewing defaults info */
int load_config_viewer(char *forced_name);




/*
 * from jvdraw.c
 */

void reset_video_mode(void);
void setup_image_info(void);		/* setup global vars for tinting */
void setup_pallet(void);
void output_term (decompress_info_ptr cinfo);


/*
 * declerations for functions from jvdrwfst.c
 */

void draw_line(int image_row, unsigned char far * data_ptr, unsigned char far * buffer_ptr);
void clear_video_memory(int num_banks);
/* void video_copy(int gr_row, unsigned char far * data_row); not global */
void near RGB_read_and_tint(void);
void put_pixel_not (decompress_info_ptr cinfo, int num_rows, JSAMPIMAGE pixel_data);
void put_pixel_rows (decompress_info_ptr cinfo, int num_rows, JSAMPIMAGE pixel_data);
void put_hi_pixel (decompress_info_ptr cinfo, int num_rows, JSAMPIMAGE pixel_data);
void pan_image(decompress_info_ptr cinfo);	/* pan the image from buffer -> screen */
void tint_15_image();	/* pan the image from buffer -> screen */
void tint_16_image();		/* tint 16 bit image from buffer -> screen */
void tint_24_image();	/* pan the image from buffer -> screen */


/*
 * from dvutil.c
 */
void clear_video_struct(void);
void check_keybd(decompress_info_ptr cinfo, char * string);
int get_key(void);
void config_problem();
int  change_defaults(int choice, int all);
void show_defaults(int all, int jpeg_detail);
int get_line(char * input_line, int max);
void insert_in_list(int mode, int only_one);
int change_extra_defaults(int choice);
void show_extra_defaults(void);
int get_file_masks(void);
void slide_show(decompress_info_ptr cinfo);
void writeText(int x, int y, unsigned char *str);


/*
 * from file_wrk.c
 */

void save_viewing_info();
int find_picture_setup(FILE * file_in);
void delete_from_setup_file(char * picture_name);
void get_files(void);	/* get list of files that match spec's and figure out how to draw on screen */
void change_drive(char drive);
void try_4_DOS(char *picture_description);


/*
 * txt-util.c
 */

int init_screen();		/* paint simple stuff if text screen is redrawn */
void setup_text_screen(void);
void open_window(int width, int height);		/* open a window for selection of file_mask, sort_mode ... */
void prep_for_exit(void);		/* prepare for exiting - everything exits thru this routine */
void set_screen_info();		/* setup the info describing the number of rows, columns ... on the text screen */


/*
 * from svgamode.asm
 */

void rtn_video(void);
void get_video(void);
