/*
 * jdmain.c  ver 2.1d Feburary 15, 1993
 * written by Eric Praetzel
 *

 May 30, 1992
  - patch ATI driver (hardcoded a changable value that was changed)
  - fixed VESA modes
  - added ATI hi_color (32,768 color) mode as card #17 - actually sets ati_hi_color flag
  - note FORCED VIDEO MODE defaults to 1024 size (now removed) --- big mistake if its a lower resolution
  - ATI hi_color x size is patched to work with range checking and allow proper page selection
  - added Tseng 4000 ramdac hi-color modes
  - added multiple keypress detection to move multiple steps per draw
  - insert mode into the user list of modes sorts by y size (assume x also increases with x)
  - the user can fill the mode list with 10 of 320 * 200 if he wants - ie no checking
  - took out jquant1 in ?.h file since why bother using it?
  - fixed some erratic functioning in forcevga (doing something funny crossing segment boundary ??? - seems fixed

 June 7, 1992

- at version 1B
  - made pallet limit if a color hits 255 --> dark areas still lighten but bright ones don't
  - added file selection from a menu (and mode, shrink)
  - can view one file after another without exiting
  - file name mask can be used
  - files names can be sorted
  - a bit of help at places
  - can select video mode for viewing
  - can adjust panning, shrinking before view
  - added color railing on brightness if a color component is going to go > 64 so colors don't wrap anymore
  - added sort modes (name, date, size)
  - config. file is now assumed to be in same dir as dvpeg.exe
  - path, drive now changable from within program
  - other directories shown with files to allow moving around
  - a file name can be given at the cmd line and it is shown first
  - added ability to change smoothing, dithering

- at version 1C
  - put some common stuff (vidsetup, dvpeg) into dvutil.c and call it in with # include - yech but easy to do

- at version 1e
  - fixed problem with 1 pass quantizing
  - can ESC out of viewing now (still a bit slow at times
  - custom video modes are now possible
  - 1 pass/ 2 pass & quantify colors problems were fixed (whole routine was _after_ jump vectors were set)
  - finally fixed boundary problem on panning
  - attempts at speed were thwarted (tried jquant2)
  - patched problem with switching to a drive that was in root - ie gave a:\\
  - fixed video testing on hi_color - it used to generate color comp's 0 .. 64 not 0 .. 32

- at version 1g
  - hi_color modes work (ATI at least).  I forgot about the 8 bit RGB components haveing to be shifted to 5 bits
  - A new jrevdct routine has been put in.  Its about twice as fast as the old one.  Over a 1 min image its about 2 sec faster
	  The 32 bit assembler version is 4 * faster than the 16 bit C code !
  - revamped default flags and put them into both menus but they are always loaded from dvpeg.cfg
  - added Ahead B card
  - gif viewing added (interlaced problems still & its slow )
  - made special pixel plotting for VGA, streamlined ATI hi_color plotting a bit

- at version 1h
  - patched wierd panning problem (if pic was rect and fit on y but no x panning bombed
  - added default director into vidsetup, changed so dvpeg will autodetect
  - added ability to goto a directory in dvpeg using F6
  - seperated out video drawing to rewrite in assembler
  - any errors are now handled properly without program exit
  - ESC pressing will halt for 1 char press, but if ESC from menu you hop back immediately
  - added beep on error (low freq) , done (higher freq)
  - added code to force VGA not hi_color on GIF (will not work with custom definations)
  - j_copy_block_rows, j_copy_samp_rows was changed to use _fmemcpy which is a lot faster
  - changed jzero_far to _fsetmem()  for Borland C - nice speed improvement
  - changed copying to buffer from inner drawing loop to _fmemcpy on super_vga for speed - can't do on hi_color due to bit packing

-at version 2.0 [beta]
  - converted jvdraw to assembler and doubled the speed
  - speed up gifs, 1 pass quantize by converting jpeg routines to assembler and tuning for 32 bit
  - threw in 24 bit video support for Tseng card
  - fixed panning in 286 version - need to recompile and hand tweak for 386 version

-at version 2.a
  - added patch to vidsetup use vidsetup -X to aviod video testing --> it trashes some computer's CMOS!! (Paradise with 1M)
  - fixed VESA driver
  - revamped so that you have to run vidsetup first
  - only the usable modes are stored in the file (ie dvpeg does not have access to all modes)
  - added 24 bit modes and revamped drivers to make the 24 bit modes standard access to bank-switching
  - put trident "cards" (8900, 8800) together and put hi_color modes under the respective card
  - revamped video setup so that AX, BX is given simplifying a lot of the setup for newer cards
  - video card lists are now of variable length and easy to expand - no more double indexing to get a video cards resolution (X, Y size ...)
  - video mode resolution (8, 15, 24 bit) are now in the video data - it is no longer dependant upon location in the list
  - changed config file load/save format to save all video info required for each mode + info for vidsetup to find custom modes
  - added unix'y passing ie dvpeg e:*.jpg will do just that

- at version 2.b
  - added tint .. for hi-color (hit normal tint controls)
  - added multiplier for tint controls ie F2 = 2* normal tint amount
  - hi-color is saved as 24 bit for better contrast controls ..
  - setup is done for a preference of tint, contrast, bright to effect pic when its first loaded
  - added Diamond Speedstar X24 (S3??) code  --> Can't detect the card though

- at version 2.1
  - fixed up file name, path, drive passing - its now fully UNIXish
  - problem  d:\gifs\new is new a path or a file ??? how tell ??
  - non-256 color modes now have the panning on or off  (need to be able to flag it differently for tint, bright ...
  - finally (?) fixed the Speedstar code
  - fixed the VESA driver again (table was reversed)
  - taking a guess that S3 based cards are VESA compatable  ie AX was same as VESA
  - added N, P for next, previous picture without going thru the text screens
- at version 2.1
  - added Paradise, Ahead B modes
  - custom text mode support ie 50 line, 132 col ...
  - seperated drawing routines so that I can put them to assembler and leave them alone
  - fixed bug in Tseng 3000 detection
  - added Trident hi-color modes  ??????  (did I ????)
  - fixed custom video mode sticking on Ahead A
  - changed 24 bit modes from 1920 bytes/row to 2048 (as per SpeedStar 24X specs
  - added (correct ?) 24 bit vesa mode
  - went to Borland C 3.1
  - dropped all .asm versions of the IJG C modules (only 1% speed loss)
  - went to version 4 of the IJG code
  - tried dynamic memory alloc for file data records - very slow + problems reusing
  - went to a block alloc of fixed size for file data records from far memory (ie possible to make larger, smaller during execution
  - all jpeg warnings are turned off so you will just get a junk file as it tries but no error msg will be printed unless its unrecoverable
  - beep bit now turns off beep when picture is loaded
  - error messages can be turned off but it will still beep on error and pause for a key
  - HOME, END do that for the file list
  - added delete command so can delete files with Del key
  - slide show is added (10 files max), s = show, S = continous loop
  - added F7 function to change extra defaults
  - added a flag to enable or disable hi-color tint ... controls on jpegs (ie on = buffering = panning ... )
  - the code size now exceeds 64k and so I had to move upto a medium memory model
  - problems with the new memory model means I had to combine point.asm and banks.asm to get it to compile (??? why ???)

-at version 2.1b
  - added picture X axis centering when viewing (only if picture is smaller than the screen)
  - speed up drawing by simplifying looping in panning
  - split 256 color panning for better speed
  - tried a S3 driver - may not work (ie don't know if numbers were hex or dec
  - if greyscale then drop to a 256 color mode
  - seperated panning from tint ...  for better speed
  - added support for wider file (ie file size) info packets on text screen with file info

-at version 2.1c
  - if store_hicolor_in_24 is set use 24 bit storage and enable panning on JPEG always
  - if the jpeg is < screen and 24 bit storage is not set then don't buffer image - if its bigger buffer for panning
  - can sort in ascending or descending order
  - new file sort routines useing bisection search for speed
  - new file structure with an extra byte per file to include things like a slide show flag => slide show has unlimited # of files but you can't set an order of viewing
  - 'A' selects all files for slide show
  - 24 bit fixed and working with ATI Wonder XL24
  - use memcpy for copying lines to graphics screen if shrink = 1 (hi-color, 24 bit, vga)
  - to speed up file list generation I went to a memcpy instead of copying the struct element by element
  - changed the contrast, tint controls to remove 1 multiply each - that just leaves 1 divide (each) to slow it down on the 15, 24 bit modes
  - can have multiple file masks (5 currently) - hit 'del' when entering erases the current mask
  - R repaints a picture ie setups up video mode and redraws - when in picture viewing mode - only if panning is on
  - r is like R but does not reset the contrast, bright, tint controls
  - if multiple arguements are given it is assumed that they are file names and will be shown in order (wait for keypress between)
  - if a '-' arguement is given after the file name(s) dvpeg will exit and not go into the menu
  - if you try to enlarge (ie hit ++) when panning is on and zoom is 1 then the you will zoom to the next video mode
  - if try to shrink 5 times and panning is on the video mode will change to the next largest
  - 24 bit tint controls by going thru video memory - ie does not need a buffered copy of the image
  - 15 bit tint controls by working on the video memory directly

- at version 2.1d  Feb 15, 1993
  - fixed problem with dvpeg.cfg file format (file was getting corrupted
  - fixed some tinting problems when working on the memory
  - went to a faster tinting equation

- at version 2.1e  Feb 26, 1993
  - new IJG V4A code (greyscale 35% faster, color 11%, 13% faster for 1 pass, 2 pass)
  - new global vars for drawing routines which are recalculated after mode change ....
	 - this removed calc's from drawing routines & tests since the picture and screen boundaries were defined
	 - this prepares the way for multiple windows with a struct describing each
	 - this also removed if tests from drawing routines => bit faster
  - added a shrink lock-out flag and make the shrink automatic (ie it can't be set anymore)
	 - the shrink to fit only works if panning is off
  - can shrink gifs now (as they are being loaded without the panning turned on)
	 - this will not work on interlaced gifs

- at version 2.2  Feb 22, 1993
  - fixed panning problems on some hi-color modes & 24 bit mode
  - fixed problem of getting a list full of 320 * 200 if you only have 256 color modes
  - reformatted screen info so that the file names are right centered and the file length are left centered and aligned
  - if 24 bit panning is on for hi-color then panning is always on
  - hitting E (instead of enter) will use 'Editing mode' ie all buffering of the picture is on and it is 24 bit for hi-color tint controls
  - partially added viewing defaults file (Save, Delete)
  - fixed problem with 24 bit mode that crosses boundaries (ie don't paint that pixel !)
  - shrink to fit only works if it is enabled and panning is off

- at version 2.3 March 1, 1993
  - fixed quantizing bug

- at version 2.4 March 1, 1993
  - vidsetup compiled incomplete (can't change file buffer array)
  - moved all function declerations to extern.h

- at version 2.5 March 8, 1993
  - fixed some panning problems with shrink (again)
  - prev. version did not have vidsetup compiled properly (could not change size of the file list)
  - delete will delete files in any directory not just startup directory
  - added screen clear option (may not clear last byte of 64k block)
  - shrink can be manually changed again
  - on 2 pass quantizing it does not change to graphics screen till the drawing starts -> improves slideshow
  - if viewing defaults for a file are saved any old defaults are deleted first - stops the file from getting very big
  - menu items only cause recalculation of screen size, directory file list if they effect them (new flag variable)
  - if doing a slide show the the 2nd pic will be have the header read and 1 pass of the 2 pass quantize will be
	  done before the delay for the next pic. starts -> better response on 2 pass video cards
  - added new jrdgif routine (better error handling than the old one I had)

- at version 2.5b June 6, 1993
  - adding R,B flip in R,G,B in 24 bit mode only and flipped it from what it was
  - adding 16 bit code routines + panning ....
  - added Cirrus card support
  - VESA mode needs to be fixed - granuality was added but it still does not work with some drivers

- at version 2.6 June 23, 1993
  - in dvpeg and vidsetup the first arguement is assumed to be the config file
  - the config file format has changed so that the first char is a marker which will seperate it from a gif/jpeg file
  - updated Cirrus driver to enable extended regs (maby this will make it work?) and updated modes from SVGAKIT31.zip
  - slide-show was changed so that the showing order is the same as the order of selection
  - added 15,16 bit mode numbers for S3, Cirrus, Trident, Tseng 4000, NCR

-at version 2.7 June 24, 1993
  - fixed Tseng 4000 support for 15,16,24 bit

- at version 2.8 June 28, 1993
  - fixed mistake I made in the Tseng 4000 support
  - fixed mistake in Cirrus mode list (640 * 480 * 256 only)
  - fixed VESA patch (ie making buffer 260 bytes instead of 256 to give a buffer - the pop 260 bytes was still set to 256)

- at version 2.8a June 29, 1993
  - added ability to lock the view into one Y resolution - also settable in vidsetup (stored in dvpeg.cfg file)
	  This locks the Y size and not a certain mode
  - added ability to force 50 line text mode
  - when dvpeg, vidsetup is run it tests and preserves 50 line text modes
  - Cirrus mode numbers were wrong -fixed 16 bit works!!
  - moved message beeping so warnings will be caught
  - redid the page formatting infomation to better fill pages with file names
  - fixed up video mode detection to save if 8*8 char gen was used (ie 50 line mode)
  - ***** 132 column text modes are not recognized *******
  - a new video mode selection routine to pick the best of 24,16,15,8 bit modes ie it starts at the highest resolution and works down
  - selecting a file for slide-show advances the cursor to the next file
- at version 2.8b, July 5, 1993
  - dvpeg (386) was compiled wrong - something was strange in the JPEG code
  - added a main check_keybd() keyboard test while decoding picutures
  - video_cards[] gets cleared to -1 (solve strange insertion problems)
  - the zoom in/out now uses video_cards and will search for any modes in the list not just the ones in ok_mode
  - fixed possible problem with passing file names in
  - changed most of the readgif code to near functions (no measureable speed boost)
  * compiled a small model version of the jpeg code, 17% faster on 2 pass, 5% faster on 1 pass!
  - put jdmcu.c into jrevdct.c to have j_rev_dct work as a near function
  - put j_rev_dct, decode_mcu, fill_bit_buffer as near functions (changes to jdhuff.c, jrevdct.c, jdmcu.c)
  -> decode_mcu could not be near unless the cinfo->methods->entropy_decode is changed to near in all declarations
  - tried new optimization "common subexpression -> locally"; smaller file but 2 sec slower on a 1 min. 2 pass JPEG
  - tried new optimization "no pointer aliasing"; smaller code; 4 sec faster on a 1 min 2 pass JPEG

- at version 2.9, July 12, 1993
  - modified jjrdgif.c to try to get more speed using flow-thru code ie the
	  rarely used conditions were coded with goto's ==> no measurable speed difference on 12 sec picture
  - added an adjustable buffer for reading the input file (sped up GIF by 15%, no effect on JPEG for my hard drive)
  - changed graphic screen clear routine (it did not clear 1 byte at the end of each 64k block)
  - fixed mode locking to use Y size and not mode numbers
  - moved JPEG_BUF_SIZE from jconfig.h into the F7 buffer size menu to allow different sizing on the JPEG buffers
	 -> GIF buffering is at the file stream while JPEG has its own built in buffer
	 -> default is 16k (was 4k in IJG JPEG code); minimum = 4k; max = 32k
  - a "twiddle factor" was added to the F7 menu.  If the picture is twiddle_factor pixels bigger than the image
	 then the next bigger mode will be chosen.  ie this prevents the shrinking of images that are slightly bigger
	 than the screen resolution
  - changed the Next, Previous picture option so that you will see the menu if it is turned on
  - added 4DOS file description reader (ie DESCRIPT.ION file)
  - added Targa, PBM image formats
  - changed buffering so that file buffering is performed for everything except JPEG
  - changed file reading so that all non-JPEG images use the same reading routine
	  - ie each file format just has to provide a routine to retune 1 line
  - bottom-up targa images will not buffer properly for panning like interlaced gifs because they are drawn from the bottom up
  - fixed sort by date (subtraction was wrong with the year/month/day bit ordering)
- at 2.9a August 26/93
  - added ability to force panning always on
  - updated vidsetup so that you can fill screen with one color
  - when viewing JPEGs sometimes no non SVGA modes would show up due to lack of initialization of cinfo->color_map_present
  - added ability to lock out all SVGA modes smaller than the lowest 15/16/24 bit mode ie if you want > SVGA but also SVGA for very large pics
  - revamped shrinking to work better (ie 1200 * 800 uses 640 * 480 in shrink = 2 instead of 1024 * 768 in shrink = 2)
- at 2.9b Sept 10/93
  - added drawing title on the picture screen or a defined text string
  - increased the number of file masks from 5 to 8
  - increased shrinking from 1/4 max to 1/5
  - changed some vars into #define for simplicity
  - revamped the entire front end to accept parameters to set every option and then some
  - can print title to center top of screen (setable on/off)
  - can use a command line full of response files as arguements
  - modified sections to use the flag  "small_viewer" to lock out the
	  F1 .. F7 options for a smaller viewer exe for the University research group
  - turned off crossblock smoothing in jconfig.h so that it is not compiled
  - removed "edit mode" ie the ability to save 15/16 bit modes as 24 to allow accurate
	  tint/bright/contrast controls to be performed for saving -> reduced complexity for a probably little used feature
	  -> this allows me to simplify the JPEG code so that it tosses out 15/16/24 bit code and does
		  not have the problem of haveing to do the 15/16 to 24 and 24 to 15/16 shuffle
  - grayscale JPEG now uses no quantization for a 25% speed boost
  - QPEG was just released and is 2* faster than my viewer for JPEGs!
  - removing panning, shrinking, tint controls (all on initial loading) speeds up viewing 15%!
  - wrapping output routine (15 bit) into ycc_rgb_convert showed no measureable difference in speed!
  - there are no RGB format files so don't need to use dummy 3 variable copy in JPEG code
  - first JPEG is about 4% faster than viewing the 2nd file!  This is reset by viewing a GIF!
  - added ability to lock the shrink at any ratio
  - removed variable JPEG_BUF_SIZE -> it caused strange performance ie slowing down after first picture,
	  and seemed to be _slower_!!  Plus it can not accomadate much memory out of the near stack
  - fixed JPEG_BUF_SIZE to 8k (16k is probably too large, used to be 4k)
  - updated VESA driver with some code from SVGAkit  (works better now??)
  - tweaked the line ordering of jrevdct.c for smaller (faster?? not measurable) code
  - adjusted pallet writing routine to search for max, min brightness colors -> to use for text drawing
  - merged my JPEG output routines into the jdcolor.c routine ycc_rgb_convert for greater speed
	 - but this means that there is no shrinking upon initial loading of the image (can be done later)
	 - speed: initial 48 sec, remove shrinking 44 sec; merge ycc_rgb_convert & drawing 46 sec, merged & no shrink 44.5
	 -        merged & write to buffer 40 sec! 17% speed boost + only 4 extra sec to buffer the image
	 - * this was only for 15 and 16 bit modes NOT 24 bit (possible but not testable right now)
	 -        removed tinting went from 40.2 to 36 sec, installed tint bypass if its not there for 36s without, 40 sec if it is done
	 ->>>  net 25% increase in 15 and 16 bit speeds!
* VGA is only for JPEG, can be anything on GIF, Targa, PNM but it will be crap
  - added VGA as the last card
  - changed video card resolution to include 16 color, changed to all defines, ie SVGA != 0 any more - check viewdef.h
  - merged 15 & 16 bit drawing routines for everything but JPEG
  - moved 24 bit routine for JPEG in ycc_rgb_convert in jdcolor.c
  - added S/W zoom of *2, *3, *4 for hi-color, 256 color => revamped video calculation causing errors on panning ...
  - redid all panning calculations to use center of the image, ie zooming in/out will stay centered
  - added -quiet option to vidsetup so that it prints nothing and saves everything to the cfg file
  - added remapping function to show interlaced, upsidedown Targas the right way
	 -> does not work for interlaced GIF yet
  - added flag to enable/disable clearing before redraw in panning (ie clean up in cases like shrinking image
  - if no config file exists then vidsetup is automatically run in the -quiet mode
  - added switching so that if hi-color modes exist SVGA will not be chosen
	 and if SVGA modes exist the VGA ones will be ignored -> in autodetection
  - VGA quantizing ie 256 colors -> 16 grayshades is very crude - should use histogram
  - changed VESA granularity once again, according to a guy in France this works on his card
  - tested on a 24 bit video card -> everything works; needed casts to unsigned to make shifting work
  - 16 bit ???  video card died
- at 3.0 Nov 4/93 (finally)
  - redid graphics routines again - centeral line drawing routine to simplify it all
  - images now center vertically if they are > screen
  - added shrinking back to initial loading of JPEGs - but it is 5+% slower than non-shrinking
  - _all_ drawing is now by lines -> ie if zoom/shrink the drawing is to a buffer which is copied to the screen
	 -this saves individual address calculations and allows much faster drawing
	 -the cost of this was an extra line (maximum 800 * 3 = 2400 bytes) of memory used
  - new row-drawing routine solves problem of not drawing pixels at 64k boundaries
  - S/W zooming is greatly sped up with the line-buffering now used
  - added S/W patch from Tom for 2 pass quant to stop strange colors from appearing
  - added ability to quantize grayscale JPEGs to 16 colors or to just use linear mapping (yech but 20% faster)
  - added back in, the ability to simply pass a path and file mask without using the command line options
- at 3.0a Nov 7/93
  - fixed bug in 16 color mode zooms
  - sped up 15/16 bit tint by moving shifting operations into color table (for red)
  - removed 1 pass quantizer from the reduced version of dvpeg (ie use quick and dirty reduction to 16 shades)
  - speedup reverse DCT by using 16 bit math -> 386 on 15 bit display is 11% faster
	 -> 286 is 40% faster!  almost at 386 speed
  -> 16 bit math uses CONST_BITS = 4; PASS1_BITS = 0 for minimum error
  - added flag to allow 16 color on VGA modes instead of grayscale (JPEG only)
  - fixed panning problem on 16 color modes
- at 3.0b Nov 8/93
3.0c ??
3.0d ??
  - converted jrevdct.c to assembler and sped up 3% by editing assembler in reverse_dct
  - replacing multiplies in j_rev_dct with shift & add had no effect
  - changed picture file to use DOS share, so if the file is being used by another application we will (untested) fail on the reading of it
  - changed range limiting to use 1/2 the number of comparisons -> 15/16/24 bit JPEG, tinting speed up
  -> removed VESA patch again to see if it works for a user!
  - added VESA driver (bankswitch and init code) from QPEG 1.0d -> it looks like SVGA code
	 -> it works with newer VESA cards!
  - numerous changes to vidsetup to support ESC to exit from commands, > 24 line modes and variable menu sizes
  - added extended 16 color modes for SVGA cards (ie 800 * 600, 1024 * 768, 1280 * 1024)
  - changed 256 to 16 color pallet remapping to use  bright = 0.3 red + 0.6 green + 0.1 blue instead of R+G+B
  - added shrinking and pannning of interlaced GIFs
	 -> removed it again;  it took hours if it was buffered to disk!!
  - changed far pointers to FAR for GCC compatability
  - change jrevdct.c to do IDCT into far data structure to avoid copying to it later
	  -> there was not speedup because of the complex column pointer arithmatic
  - added fast up_sample code that uses a square filter and not a triangular one -> 15% speedup
	  -> this is switchable with the high/medium quality control
	  -> this can add errors upto 40% on 0.2% of the pixels and the boundary ones may have large errors as well
	  -> most errors (aprox. 94%) will have errors < 3% due to the filtering -> this is on par with the 16 bit math errors
  - changed jdsample column counters to use int not long
  - changed jdcolor green component generation to use 1 table lookup -> 3% speedup, on +/- 2 maximum error on components
	  -> added it to 15/16/24/general colorspace conversion routine
  - tried speeding up jdcolor by editing assembler but not much gain since I only removed inter-register moves ie very fast therefore no gain
  - thinking of merging lookuptables in jdcolor to save pointer generation -> better if pass them in a R,G,B tripplets in one data stream
  - sped up another 3% in jdsample for h2v2 by using a string copy on successive rows
  - removed upsampling of h2v2 image and modified 1 pass, 15 bit to use non-upsampled data for 20% speedup
  - modified buffering so that 2 lines are simultaneously writable to the screen buffer -> speeds up h2v2 color conversion
  -> tint controls for a 800 * 600 JPEG (ie tests to see if tint as load) take 0.5 sec
  - added speedups to 16 bit modes
  - tried to speedup jdcolor.c by compiling to assembler and using fs,gs regs -> no measurable change!
  -> tests {hi/med quality & {untinted, tinted}} = {{28.6, 33.2}, {22.0, 26.6}}
  - modified flood fill video test to set only 1 color and all others to background -> better test
  - fixed svgamode() because DI was trashed by VESA testing
  - redid video modes so that 320 * 200 was only under VGA and mode selection was better (ie 4 bit only added if necessary)
  - redid the interface on vidsetup a bit to show cursor (inverse) and selected modes (as red) as well as all video cards used (in red)
  - changed file selection so that a zero length file is now 1 byte long -> this allows deleting, and it will not appear as a directory
  - fixed minor bug in sizing the F3 window
 -> removed fast drawing of two lines at once -> bugging panning on large images ie picture buffer has some bad lines! ie junk
 -> panning problem, if picture dimension < screen then the panning controls are reversed
- at 3.0e Nov 30/93
  - changed gif decoding pointers to near -> no speedup [ uses aprox 16k of near space ]
  - changed targa input file pointer to global for a bit of speed; also cleaned up static vars by removing unused ones
  - added more VESA 15,16,24 bit modes
  - removed VESA duplicate 640 * 480 mode that had a different line length, VESA length detection works with good VESA drivers
  -> the 16 bit modes work with univbe!  -> first proof that they really work
  - fixed H?V? JPEG detection -> will work as follows: H2V2 is only true for {{1,1},{2,2},{2,2}}
	 H1V1 is only true for {{1,1},{1,1},{1,1}}  -> all else is considered H2V1
  - brightest color selection will not only search first 16 colors for VGA modes (used to search all 256)
  - 16 color modes now use the normal force grayscale and 1/2 pass quantize variables instead of dedicated ones
  - sped up VGA (16 color) panning by a factor of 2 using memory moves (by line) [ still 2* slower than QPEG panning! ]
	 -> It could be sped up a lot if the zoom option was not used; that would explain the 2*
- at 3.0f Dec 4/93


  -  This will be the last vesion as I will be going to SVGAkit for the graphics

  - VGA quantizing ie 256 colors -> 16 grayshades is very crude - should use histogram

To do:
  - fix up reordering of interlaced GIFs during panning
  - need tint for all pans, ie load a prev. tinted image, pan it -> no tints since buffered copy is not tinted
  - 1 pass dithering ??
  - add wrapping of file selection from left to right and vise-versa?
  -15/16/24 bit modes will tint the image if redrawn from the buffer

Problems
 - clearning of VGA screen is done by resetting video mode -> better way??
 - need cleanup of viewing defaults ie removing multiple declerations for one picture
 - can't free and create new file_info structure - ie if you try the system halts with a memory alloc. error
 - 15/16/24 bit does not tint when it redraws



To add
 - add support so that interlaced gifs can be shrunk, panned ....
 - large screen sized buffer for slide show ie decode into buffer while the picture is pausing (how alloc the far memory ??? without getting upset by IJG code?)
 - add selectable colors for file info
 - rotate by 90 deg??
 - still have to figure out Cirrus card
 - problem with Compaq, Cirrus? bank selector ???
 *
 */

#include "viewdef.h"			/* definations for the viewer */
#include "extern.h"		/* external declerations for viewer plus IJG includes */
#include <share.h>

#ifdef INCLUDES_ARE_ANSI
#include <stdlib.h>		/* to declare exit() */
#endif
#ifdef NEED_SIGNAL_CATCHER
#include <signal.h>		/* to declare signal() */
#endif


/* define mode parameters for fopen() */
#define READ_BINARY	"rb"
#define WRITE_BINARY	"wb"

#ifndef EXIT_FAILURE		/* define exit() codes if not provided */
#define EXIT_FAILURE  1
#endif


#include <dir.h>
#include <string.h>
#include <dos.h>
#include <conio.h>
#include <setjmp.h>
#include <alloc.h>
#include <time.h>

void parse_path(char * arg);

extern unsigned _stklen = 7000;

#include "jvsetup.h"			/* constants viewer */


/* Neat little trick to do a jump and clean up stack */
jmp_buf setjmp_buffer;

static external_methods_ptr emethods; /* needed for access to message_parm */


JSAMPARRAY patch_colormap;	/* color map pointer for when I need to create a fake colormap */

int no_warning = 0;		/* flag to indicate that the error message is not a warning but a fatal error */


/*
 * Signal catcher to ensure that temporary files are removed before aborting.
 * NB: for Amiga Manx C this is actually a global routine named _abort();
 * see -Dsignal_catcher=_abort in CFLAGS.  Talk about bogus...
 */

#ifdef NEED_SIGNAL_CATCHER

GLOBAL void
signal_catcher (int signum)
{
  prep_for_exit();
  printf("Severe exit from signal_catcher\n");
  emethods->trace_level = 0;	/* turn off trace output */
  (*emethods->free_all) ();	/* clean up memory allocation & temp files */
  exit(signum);
}

#endif




/* This routine is used for any and all trace, debug, or error printouts
 * from the JPEG code.  The parameter is a printf format string; up to 8
 * integer data values for the format string have been stored in the
 * message_parm[] field of the external_methods struct.

 *  If the message is of 0 length then just clean up and pass thru
 *  If the 1 char message is E then it is an ESCape from viewing a pic
 *  If the message if of 1 char length or > then wait for at least 1 keypress
 *  If it is 1 char and beep is off then don't beep but pause
 * - always beep & only give msg if requested
 */

METHODDEF void
trace_message (const char *msgtext)
{
if ( (strlen(msgtext) > 1) ||
	(strlen(msgtext) == 1 && (view_defaults & beep_on)) && do_slide_show == 0){
	sound(45);
	delay(450);
	nosound();
	}

if (do_slide_show == 0 && no_warning == 1){
	if (strlen(msgtext) >= 1 ) getch();		/* pause if no message requested so that the picture stays on the screen */
	if (defaults & error_msg_on && (strlen(msgtext) > 1) ){
		setup_text_screen();
		init_screen();
		open_window(50, 12);
		cprintf(msgtext,
			emethods->message_parm[0], emethods->message_parm[1],
			emethods->message_parm[2], emethods->message_parm[3],
			emethods->message_parm[4], emethods->message_parm[5],
			emethods->message_parm[6], emethods->message_parm[7]);
		cprintf("\n\r\nMemory left in near heap:\r\n    %lu bytes\r\n",(unsigned long) coreleft());
		cprintf("Bytes above highest block in far heap:\r\n    %lu bytes\r\n",farcoreleft());
		cprintf("Hit any key.\r\n");
		getch();
		}
	}
no_warning = 0;
}



/*
 * The error_exit() routine should not return to its caller.  The default
 * routine calls exit(), but here we assume that we want to return to
 * read_JPEG_data, which has set up a setjmp context for the purpose.
 * You should make sure that the free_all method is called, either within
 * error_exit or after the return to the outer-level routine.
 */

METHODDEF void
error_exit (const char *msgtext)
{
no_warning = 1;		/* signal trace message routine that this is no warning but a fatal message */

trace_message(msgtext);	/* report the error message */
(*emethods->free_all) ();	/* clean up memory allocation & temp files */
longjmp(setjmp_buffer, 1);	/* return control to outer routine */
}



/* Case-insensitive matching of (possibly abbreviated) keyword switches. */
/* keyword is the constant keyword (must be lower case already), */
/* minchars is length of minimum legal abbreviation. */

int keymatch (char * arg, const char * keyword, int minchars)
{
  register int ca, ck;
  register int nmatched = 0;

  while ((ca = *arg++) != '\0') {
	 if ((ck = *keyword++) == '\0')
		return FALSE;		/* arg longer than keyword, no good */
	 if (isupper(ca))		/* force arg to lcase (assume ck is already) */
		ca = tolower(ca);
	 if (ca != ck)
		return FALSE;		/* no good */
	 nmatched++;			/* count matched characters */
  }
  /* reached end of argument; fail if it's too short for unique abbrev */
  if (nmatched < minchars)
	 return FALSE;
  return TRUE;			/* A-OK */
}



/*
 * parses one line of the response file or command line options
 *
 * return the last arguement parsed so that the outer program knows how
 * many extra arguements were read (either 1 or 0)
 *
 * pass in argc which is the maximum number of arguements in the list
 *  and start_arg which is the arguement number to start at
 */

int parse_switches (decompress_info_ptr cinfo, int argc, char * argv[], int start_arg)
{
int argn, c, i, on_flag;
char * arg, * chr;

argn = start_arg;

on_flag = 0;
arg = argv[argn];

if (*arg == ';') return argn;	/* this is a comment line ie do nothing */

/* test if we have a file name for viewing or path & mask (without the -path)
 * as opposed to an option
 */
if (*arg != '-' && *arg != '+'){
	if (strchr(arg, '\\') != NULL){		/* we have a directory if there is a backslash */
		parse_path(arg);
		return argn;
		}
	if (config_found == 0){
		prep_for_exit();
		printf("\nYou must run vidsetup before you can use dvpeg\n");
		exit(-1);
		}
	c = view_defaults;
	view_defaults &= (~ask_size_bit);	/* turn off second menu */
	show_it(cinfo, arg);				/* show and wait for keypress */
	view_defaults = c;
	}
else{
	if (*arg++ == '+') on_flag = 1;  /*	arg++;	/* advance past switch marker character */

	if (keymatch(arg, "clscreen", 3)){
		setup_text_screen();
		init_screen();
		}

	else if (keymatch(arg, "notext", 3)){
		defaults &= (~no_text);
		if (on_flag) defaults |= no_text;
		}

	else if (keymatch(arg, "name", 3)){
		defaults &= (~show_text);
		picture_text_arguement[0] = 0;
		if (on_flag){
			defaults |= show_text;
			if (++argn < argc)
				if (*argv[argn] == '*')
					strcpy(picture_text_arguement, argv[argn] + 1);
				else
					argn--;
			}
		}

	else if (keymatch(arg, "title", 3)){
		defaults &= (~show_title);
		picture_title_arguement[0] = 0;
		if (on_flag){
			defaults |= show_title;
			if (++argn < argc)
				if (*argv[argn] == '*')
					strcpy(picture_title_arguement, argv[argn] + 1);
				else
					argn--;
			}
		}

	else if (keymatch(arg, "tree", 3)){
		if (on_flag)
			defaults |= show_tree;
		else
			defaults &= (~show_tree);
		}

	else if (keymatch(arg, "drives", 3)){
		if (on_flag)
			defaults |= show_drives;
		else
			defaults &= (~show_drives);
		}

	else if (keymatch(arg, "fifty", 3)){
		if (on_flag)
			view_defaults |= fifty_line_text;
		else
			view_defaults &= (~fifty_line_text);
		}

	else if (keymatch(arg, "clgr", 3)){
		if (on_flag)
			defaults |= clear_before_draw;
		else
			defaults &= (~clear_before_draw);
		}

	else if (keymatch(arg, "usefiles", 3)){
		if (on_flag)
			defaults |= dont_get_files;
		else
			defaults &= (~dont_get_files);
		}

/*		view_defaults ^= ascending_bit;
		defaults ^= error_msg_on;
		defaults ^= use_default_file;
		view_defaults ^= only_hi_color;
		view_defaults ^= not_less_hi_color;
	lock_during_pan
	clear_during_pan .....  lots more
*/

	else if (keymatch(arg, "long", 3)){
		if (on_flag)
			defaults |= long_file_format;
		else
			defaults &= (~long_file_format);
		}

	else if (keymatch(arg, "delay", 3)){
		if (++argn < argc)
			sscanf(argv[argn], "%d", &slideshow_pause);
		}

	else if (keymatch(arg, "keypress", 3))
		getch();

	else if (keymatch(arg, "config", 3)){
		if (++argn < argc)	/* advance to next argument & check for error */
			config_found |= load_config_viewer(argv[argn]);
		}

	else if (keymatch(arg, "exit", 3)){
		prep_for_exit();
		exit(0);
		}

	else if (keymatch(arg, "grayscale", 3)){
		view_defaults &= (~grey_bit);
		if (on_flag) view_defaults |= grey_bit;
		}

	else if (keymatch(arg, "quantize", 3)){
		view_defaults &= (~quantize_bit);
		if (on_flag) view_defaults |= quantize_bit;
		}

	else if (keymatch(arg, "dithering", 3)){
		view_defaults &= ~(dithering_bit);
		if (on_flag) view_defaults |= dithering_bit;
		}

	else if (keymatch(arg, "controls", 3)){
		do_slide_show = 0;
		if (on_flag) do_slide_show = 1;
		}

	else if (keymatch(arg, "lock", 3)){
		mode_lock = -1;
		if (on_flag)
			if (++argn < argc){	/* advance to next argument & check for error */
				sscanf(argv[argn], "%d", &c);
				if (c > 0) mode_lock = c;
				}
		}

	else if (keymatch(arg, "menu", 3)){
		view_defaults &= (~ask_size_bit);	/* turn off second menu */
		if (on_flag) view_defaults |= ask_size_bit;
		}

	else if (keymatch(arg, "beep", 3)){
		view_defaults &= (~beep_on);
		if (on_flag) view_defaults ^= beep_on;
		}

	else if (keymatch(arg, "mask", 3)){
		if (on_flag){
			for (c = 0; (c < max_file_masks) && (file_masks[c][0] != 0); c++) {}
			if (c >= max_file_masks) c = 0;
			if (++argn < argc)
				strcpy(file_masks[c], argv[argn]);		/* if wildcard is given use it */
			}
		else
			for (c = 0; c < max_file_masks; c++)
				file_masks[c][0] = 0;		/* clear all other file masks */
		}

	else if (keymatch(arg, "shrink", 3)){
		if (!on_flag)
			defaults &= ~shrink_enable_flag;	/* turn off if set to 0 */
		else{
			defaults |= shrink_enable_flag;
			if (++argn < argc){
				shrink = *argv[argn] - '0';
				if (shrink == 0)
					view_defaults &= (~lock_shrink);
				else
					view_defaults |= lock_shrink;
				if (shrink > max_shrink) shrink = max_shrink;
				if (shrink < 1) shrink = 1;
				if (view_defaults & lock_shrink) lock_shrink_value = shrink;
				}
			}
		}

	else if (keymatch(arg, "panning", 3)){
		view_defaults &= (~panning_bit);
		if (on_flag) view_defaults |= panning_bit;
		}

	else if (keymatch(arg, "slideshow", 3)){
		if (file_info_head != NULL)
			slide_show(cinfo);
			}

	else if (keymatch(arg, "nolist", 3)){
		defaults &= ~show_drives;
		defaults &= ~show_tree;
		defaults |= no_file_list;
		}

	else if (keymatch(arg, "continous", 3))
		defaults |= slide_show_continous;

	else if (keymatch(arg, "initshow", 3))
		init_file_struct();

	else if (keymatch(arg, "addslide", 3)){
		/* first find the highest number in the slideshow by searching the list */
		if (++argn < argc){
			c = 0;
			if (file_info_head != NULL){		/* only do this if the memory has been alloced */
				for (i = max_file_records-1; i >= 0; i--)
					if ((file_info_head + i)->slide_num > c)
						c = (file_info_head +i)->slide_num;

				number_files += insert_in_place(argv[argn], 10, 0, NONE, 0, c+1);
				}
			}
		}
	else if (keymatch(arg, "path", 3))
		if (++argn < argc)
			parse_path(argv[argn]);
	}
return argn;			/* return index of next arg (file name) */
}



/*
 * parse a string which contains the file path
 *  and update the path to the pictures
 * -if there are wildcards at the end; assume that a file mask has
 *  been given and erase the current one & add new mask
 *
 * assume either ..<path> or \\<path> or d:\<path> or path to append
	the path is optional in any of the first 3 options
 */

void parse_path(char * arg)
{
char * chr;
int c;

if (strlen(arg) > 1){
	switch(*(arg+1)){
		case '.':		/* hop back one level in the path */
			arg += 2;		/* get past it */
			chr = file_path + strlen(file_path) - 2;	/* point to last char - don't forget extra \ at the end */
			if (strchr(file_path, '\\') != NULL){
				while (*chr-- != '\\') {}
				*(chr + 1) = 0;		/* lop off the last path leaf */
				}
			break;
		case '\\':		/* hop to root but keep drive letter */
			file_path[3] = 0;
			arg += 2;
			break;
		case ':':		/* a drive has been given */
			strncpy(file_path, arg, 1);	/* assume first letter is the drive */
			file_path[1] = 0;
			strcat(file_path, ":\\");
			arg += 2;
			if (*arg == '\\') arg++;
			break;
		}
	/* now if anything is left it is a file mask or the last of the path without the terminating \ char */
	if (strchr(arg, '?') == NULL && strchr(arg, '*') == NULL)
		strcat(file_path, arg);
	else{		/* we have a path */
		for (c = 1; c < max_file_masks; c++)
			file_masks[c][0] = 0;		/* clear all other file masks */
		strcpy(file_masks[0], arg);		/* if wildcard is given use it */
		}
	}
}



/*
 * do a slideshow from the file list
 * - handle continous show (if flag is set)
 *
 */

void slide_show(decompress_info_ptr cinfo)
{
int current_slide_num;		/* slide show vars */
char temp_char[50];
int c, i;		/* general purpose vars */

current_slide_num = 1;	/* init to showing first selected file */
key_hit = 0;				/* flag for a non ESC key being hit while doing a slide show */
time_at_start = 0;		/* setup delay timer */
do_slide_show = 1;

/* verify that 1 selection exists */
/* i is the slide show index, from the top down */
i = max_file_records-1;
show_next_file = 0;

while(i >= 0 && show_next_file == 0){
	if ((file_info_head + i)->slide_num == 1)	/* find first file */
		show_next_file = 1;
	else
		i--;
	}

c = view_defaults;
view_defaults &= (~ask_size_bit);	/* turn off second menu */
view_defaults &= (~panning_bit);		/* turn off panning */

while (show_next_file != 0 && key_hit == 0){
	if (i >= 0){
		_fstrcpy(temp_char, (file_info_head + i)->name);
		show_it(cinfo, temp_char);
		if (key_hit == 0)		/* only do this if no key was hit - ie an immediate exit requested */
			time_at_start = time(NULL);		/* reset delay timer */
		else
			time_at_start = 0;
		current_slide_num++;				/* inc so that we get the next file the next time */
		}

	/* find next selection */
	for (i = max_file_records-1; (i >= 0) && (file_info_head + i)->slide_num != current_slide_num; i--){}

	/* end the show or do continous loop ??? */
	if (i >= 0)
		show_next_file = 1;
	else
		if (defaults & slide_show_continous){	/* continous show ?? -> find first picture */
			current_slide_num = 1;
			i = max_file_records - 1;
			while((file_info_head + i)->slide_num != 1 && (i >= 0)) i--;
			show_next_file = 1;
			}
		else{
			getch();		/* last pic so delay for keypress */
			show_next_file = 0;
			}
	}

defaults &= ~slide_show_continous;		/* always clear this upon exit */
view_defaults = c;	/* restore ask_size_bit */
do_slide_show = 0;
}




/*
 * clear the (edited) user list of chosen video modes
 */

void clear_list(void)
{
int c;
for (c = 0; c < number_modes_in_list; c++)
	ok_mode[c] = -1;						/* signal as unused to ensure undefined modes are not used */
}





/*
 * check to see if there should be a pause before showing pic
 * if it is > 2 min. then assume something is wrong and return
 */

void pause_for_slideshow(void)
{
unsigned delay_in_sec;

if (do_slide_show){
	delay_in_sec = time(NULL) - time_at_start;
	if (delay_in_sec > 120) return;
	if (delay_in_sec < slideshow_pause)
		delay((slideshow_pause - delay_in_sec) * 1000);
	}
}



/*
 * setup the selected video mode
 */

void set_video(int mode_index)
{
if (current_graphics_mode != mode_index){		/* first check to see if we are still in the graphics mode */
	current_graphics_mode = mode_index;
	forcevga(video_cards[mode_index].card_number);
	svgamode(video_cards[mode_index].set_ax,
			video_cards[mode_index].set_bx,
			video_cards[mode_index].x_width,
			video_cards[mode_index].card_number);

	/* set up screen limits */

	x_max = video_cards[mode_index].x_size;
	y_max = video_cards[mode_index].y_size;
	maxy = video_cards[mode_index].y_size;

	if (defaults & clear_before_draw)		/* clear 16 * 64k banks of memory ie 1M */
		clear_video_memory(16);
	}
else
	clear_video_memory(16);		/* clear 1 Mbyte */

video_resolution = video_cards[mode_index].resolution;		/* update this for everything else */
setup_image_info();		/* setup all panning, tint info */
}



/*
 * To accept the image data from decompression, you must define four routines
 * output_init, put_color_map, put_pixel_rows, and output_term.
 *
 * You must understand the distinction between full color output mode
 * (N independent color components) and colormapped output mode (a single
 * output component representing an index into a color map).  You should use
 * colormapped mode to write to a colormapped display screen or output file.
 * Colormapped mode is also useful for reducing grayscale output to a small
 * number of gray levels: when using the 1-pass quantizer on grayscale data,
 * the colormap entries will be evenly spaced from 0 to MAX_JSAMPLE, so you
 * can regard the indexes are directly representing gray levels at reduced
 * precision.  In any other case, you should not depend on the colormap
 * entries having any particular order.
 * To get colormapped output, set cinfo->quantize_colors to TRUE and set
 * cinfo->desired_number_of_colors to the maximum number of entries in the
 * colormap.  This can be done either in your main routine or in
 * d_ui_method_selection.  For grayscale quantization, also set
 * cinfo->two_pass_quantize to FALSE to ensure the 1-pass quantizer is used
 * (presently this is the default, but it may not be so in the future).
 *
 * The output file writing modules (jwrppm.c, jwrgif.c, jwrtarga.c, etc) may be
 * useful examples of what these routines should actually do, although each of
 * them is encrusted with a lot of specialized code for its own file format.
 */


METHODDEF void
output_init (decompress_info_ptr cinfo)
/* This routine should do any setup required */
{

  /* This routine can initialize for output based on the data passed in cinfo.
	* Useful fields include:
	*	image_width, image_height	Pretty obvious, I hope.
	*	data_precision			bits per pixel value; typically 8.
	*	out_color_space			output colorspace previously requested
	*	color_out_comps			number of color components in same
	*	final_out_comps			number of components actually output
	* final_out_comps is 1 if quantize_colors is true, else it is equal to
	* color_out_comps.
	*
	* If you have requested color quantization, the colormap is NOT yet set.
	* You may wish to defer output initialization until put_color_map is called.
	*/
int i;

check_keybd(cinfo, "");

/* if this then it is a grayscale without quantizing
 * but don't choke if there is no colormap, quantized grayscale (ie 16 color) will get here
 * and not have a colormap made
 */

if (cinfo->colormap != NULL){		/* is there a colormap; only JPEG quantized will not have one at this point */
	if (video_resolution == VGA)		/* only 16 color pallet ?? */
		quantize_colormap(cinfo);

	if (cinfo->out_color_space == CS_GRAYSCALE)
		for (i=0; i < 256; i++)
			palbuf[i][0] = palbuf[i][1] = palbuf[i][2] = GETJSAMPLE(cinfo->colormap[0][i]);
	}

if (cinfo->quantize_colors == FALSE){	/* this is only for non quantized JPEGs */
	pause_for_slideshow();
	set_video(video_mode_used);
	if (video_resolution <= SVGA)		/* if non-quantized JPEG then init the "faked" pallet */
		setup_pallet();
	writeText(text_line_x, text_line_y, picture_text);
	}
}



/*
 * This routine is called if and only if you have set cinfo->quantize_colors
 * to TRUE.  It is given the selected colormap and can complete any required
 * initialization.  This call will occur after output_init and before any
 * calls to put_pixel_rows.  Note that the colormap pointer is also placed
 * in a cinfo field, whence it can be used by put_pixel_rows or output_term.
 * num_colors will be less than or equal to desired_number_of_colors.
 *
 * The colormap data is supplied as a 2-D array of JSAMPLEs, indexed as
 *		JSAMPLE colormap[component][indexvalue]
 * where component runs from 0 to cinfo->color_out_comps-1, and indexvalue
 * runs from 0 to num_colors-1.  Note that this is actually an array of
 * pointers to arrays rather than a true 2D array, since C does not support
 * variable-size multidimensional arrays.
 * JSAMPLE is typically typedef'd as "unsigned char".  If you want your code
 * to be as portable as the JPEG code proper, you should always access JSAMPLE
 * values with the GETJSAMPLE() macro, which will do the right thing if the
 * machine has only signed chars.
 */

METHODDEF void
put_color_map (decompress_info_ptr cinfo, int num_colors, JSAMPARRAY colormap)
{
int i;
/* remember it only gets here if it is 256 color output not for 15 or 24 bit modes */

number_pallet_colors = num_colors;
if (colormap != NULL){
	if (cinfo->quantize_colors == TRUE){		/* removed test for color_space = CS_RGB */
		if (cinfo->out_color_space == CS_RGB)
			for (i = 0; i < num_colors; i++){
				palbuf[i][0] = GETJSAMPLE(colormap[0][i]);
				palbuf[i][1] = GETJSAMPLE(colormap[1][i]);
				palbuf[i][2] = GETJSAMPLE(colormap[2][i]);
				}
		else{
			/* this is quantized grayscale; it is either 256 shades or maps 256 shades to 16; so we must fill all 256
			 *  currently this is only used by quantized to 16 shades
			 */
			if (cinfo->quantize_colors == TRUE)		/* this is only for quantized JPEGs */
				for (i=0; i < num_colors; i++)
					palbuf[i][0] = palbuf[i][1] = palbuf[i][2] = GETJSAMPLE(colormap[0][i]);
			}
		pause_for_slideshow();
		set_video(video_mode_used);
		setup_pallet();
		writeText(text_line_x, text_line_y, picture_text);
		}
	}
else		/* last chance to set the color map - message if we don't have one */
	ERREXIT(cinfo->emethods, "color map pointer is NULL");
}



/*
 * remap the 256 color pallet to a 16 grayscale
 *  or provide a 1 to 1 mapping for 256 to 256 (ie all other picture types)
 *
 * do this by remapping the color map so that it points to the first 16 colors for 16 color modes
 * This is done with the remap[] array with 0..255 input and 0..15 output
 * First generate the mapping function then replace the colormap with a graduated grayscale
 *
 * assume storage is setup (should be) for remap[][]
 */

void quantize_colormap(decompress_info_ptr cinfo)
{
unsigned int i, j;
unsigned long brightness;	/* scaled value 0 .. 15 */
JSAMPARRAY colormap;

colormap = cinfo->colormap;

for (i = 0; i < 256; i++){
	j = i << 4;		/* this fixes the compiler problem -> without it bad code is generated */

	/* is the image single component, ie gray?  This is tested differently for JPEGs and others */

	if ((type_of_picture != JPG && cinfo->num_components == 1) ||
		(type_of_picture == JPG && cinfo->quantize_colors == FALSE))
		brightness = (unsigned long)colormap[0][i] >> 4;
	else
		brightness = ((unsigned long)colormap[0][i] * 30 +
			(unsigned long)colormap[1][i] * 59 +
			(unsigned long)colormap[2][i] * 11) / 1594;
	remap[0][i] = (unsigned char) brightness;
	colormap[0][i] = (unsigned char) j + 8;	/* ie in first 16 colors run 0 .. full brightness */
	}
}



/*
 * if given a 3 component (R,G,B) or 1 componet (greyscale), and >> 256 color image fake a colormap
 *  - set the colormap to a greyscale fade and use the first component (grey or Red) as an index
 *  - if the colormap is only 16 colors then use the colormap to map 256 shades to 16 shades
 *     ie reading in 256 shade Targa and convert to a 16 shade display
 */

void fake_colormap(decompress_info_ptr cinfo, JSAMPARRAY cmap, int num_colors)
{
int i;

/* Allocate space to store the colormap, 256 bytes * 3 rows */
cmap = (*cinfo->emethods->alloc_small_sarray) ((long) 256, 3);
cinfo->colormap = cmap;

for (i = 0; i < 256; i++)
	cmap[0][i] = i;

/* now fake the darn S/W */

cinfo->out_color_space = CS_GRAYSCALE;		/* this forces the color-map writing routine to only use the first component of the colormap to generate greyscale */
cinfo->color_map_present = TRUE;
cinfo->actual_number_of_colors = num_colors;
}




/*
 * This routine gets control after the JPEG file header has been read;
 * at this point the image size and colorspace are known.
 * The routine must determine what output routines are to be used, and make
 * any decompression parameter changes that are desirable.  For example,
 * if it is found that the JPEG file is grayscale, you might want to do
 * things differently than if it is color.  You can also delay setting
 * quantize_colors and associated options until this point.
 *
 * j_d_defaults initializes out_color_space to CS_RGB.  If you want grayscale
 * output you should set out_color_space to CS_GRAYSCALE.  Note that you can
 * force grayscale output from a color JPEG file (though not vice versa).
 */

METHODDEF void
d_ui_method_selection (decompress_info_ptr cinfo)
{
static int
		i, temp,
		repaint,
		video_mode_pointed;	/* the video mode (index into ok_mode[] list currently selected */

/* setup important drawing info */

picture_x_size = cinfo->image_width;
picture_x_center = picture_x_size >> 1;
picture_y_size = cinfo->image_height;
picture_y_center = picture_y_size >> 1;

shrink = 1;

/* now check to see if we have the right H/W for the image
	ie a picture with >> 256 colors can not be displayed on SVGA
	-> if the picture has >> 256 colors fake a greyscale image for quick and dirty viewing
	*/

/* if grayscale input, force grayscale output; */
/* else leave the output colorspace as set by main routine. */
  if (cinfo->jpeg_color_space == CS_GRAYSCALE)
	 cinfo->out_color_space = CS_GRAYSCALE;

#ifdef small_viewer		/* if it is small we only support non quantized grayscale */
cinfo->out_color_space = CS_GRAYSCALE;
#endif

  /* select output routines */
  cinfo->methods->output_init = output_init;
  cinfo->methods->put_color_map = put_color_map;
  cinfo->methods->output_term = output_term;


make_mode_list(cinfo);

/*	- first find good window size */

video_mode_pointed = pick_screen_mode();
video_mode_used = ok_mode[video_mode_pointed];

/* setup enable pan because the user may have the menu turned off */
autocheck_panning(video_mode_used);
autocheck_shrinking(video_mode_used);

video_mode_pointed = pick_screen_mode();
video_mode_used = ok_mode[video_mode_pointed];

repaint = 1;
i = 0;

/*
 * make sure we do this once if asked for
 *
 * this loop is only entered if the menu is being shown
 */


while ( (i != RTN) && (view_defaults & ask_size_bit)){

/* only clear and repaint if absolutely necessary - ie avoid the flicker */
	if (repaint){
		open_window(preview_win_x, preview_win_y);

		gotoxy(1,1);
		textcolor(WHITE);
		cprintf("File: %10s, %4i * %4i, ", file_being_viewed, picture_x_size, picture_y_size);
		repaint = 0;
		if (cinfo->out_color_space == CS_RGB)
			cprintf("color");
		else
			cprintf("greyscale");
		if (type_of_picture == JPG)
			switch (jpeg_type){
				case H2V2:
					cprintf(", h2v2");
					break;
				case H2V1:
					cprintf(", h2v1");
					break;
				case H1V1:
					cprintf(", h1v1");
				}

		if (picture_description[0] != 0){
			textcolor(LIGHTGREEN);
			picture_description[file_name_len - 1] = 0;	/* limit length */
			if ((preview_win_x - 4) < file_name_len)
				picture_description[preview_win_x - 4] = 0;	/* limit length */
			cprintf("\r\n%-s\r\n", picture_description);
			textcolor(WHITE);
			}
		}

	autocheck_panning(video_mode_used);

	gotoxy(1,3);

#ifndef small_viewer
	show_defaults(0, type_of_picture == JPG);
#endif

	cprintf("\r\nVideo modes (K ");
	if (mode_lock >= 0) cprintf("unlocks):\r\n");
	else cprintf("locks):  \r\n");

	for (i=0; i < number_modes_in_list; i++){
		temp = ok_mode[i];
		if (temp >= 0){
			if (temp == video_mode_used && mode_lock < 0)
				textcolor(LIGHTMAGENTA);
			else
				textcolor(LIGHTGRAY);
			if (video_cards[temp].y_size == mode_lock)
				textcolor(LIGHTRED);

			cprintf("     %15s    %4i   %5i %10s\r\n",video_card_names[video_cards[temp].card_number],
				video_cards[temp].x_size, video_cards[temp].y_size,
				card_type[video_cards[temp].resolution]);
			textcolor(WHITE);
			}
		}
	switch( (i = get_key()) ){
		case escape:
				error_exit("");
				break;
#ifndef small_viewer
		case F1:
				clrscr();
				cprintf("up/down arrow - select a video mode\r\n");
				cprintf("enter - check out that picture\r\n");
				cprintf("escape - exit\r\n");
				cprintf("P - Panning\r\n");
				cprintf("S - adjust Shrinking\r\n");
				cprintf("D - Dithering\r\n");
				cprintf("G - Grayscale colorspace\r\n");
				cprintf("Q - one / two pass Quantizer\r\n");
				cprintf("M - this menu on/off\r\n");
				cprintf("E - End of pic. beep\r\n");
				cprintf("K - lock a video mode\r\n");
				if (any_hi_color)
					cprintf("L - Lockout of SVGA modes for jpegs\r\n");
				getch();
				repaint = 1;
				break;
#endif
		case arrow_up:
				do{				/* make sure that we get an existing mode */
					if (video_mode_pointed > 0) video_mode_pointed -=1;
					else video_mode_pointed = number_modes_in_list - 1;
					} while (ok_mode[video_mode_pointed] == -1);
				break;
		case arrow_down:
				do{
					if (video_mode_pointed < number_modes_in_list - 1) video_mode_pointed += 1;
					else video_mode_pointed = 0;
					} while (ok_mode[video_mode_pointed] == -1);
				break;
		case 'K':
		case 'k':		/* lock the video mode that is selected */
				if (mode_lock >= 0)
					mode_lock = -1;	/* reset ie toggle it */
				else
					mode_lock = video_cards[video_mode_used].y_size;
				break;
		case RTN:		/* do nothing */
				break;
		default:

#ifndef small_viewer
				repaint = change_defaults(i, 0);
#endif
				if (repaint > 1){
					repaint = 1;
					if (view_defaults & lock_shrink == 0);
						shrink = 1;
					make_mode_list(cinfo);	/* update list and repaint */
					video_mode_pointed = pick_screen_mode();
					video_mode_used = ok_mode[video_mode_pointed];
					autocheck_shrinking(video_mode_used);
					}
			}
	video_mode_used = ok_mode[video_mode_pointed];
	}		/* finally the close of that while */

if (mode_lock >= 0){
	/* if the mode lock is being used then the Y resolution has been selected and we have to
		find a video mode that matches that resolution.  Ideally there is only one mode of that
		size so we just have to do a single pass of the table and grab the first one */
	for (i=0; i < number_modes_in_list; i++){
		temp = ok_mode[i];
		if (temp >= 0)
			if (video_cards[temp].y_size == mode_lock)
				video_mode_used = temp;
		}
	}

video_display_resolution = 0xff;		/* assume 8 bit display -> this tweaks the IJG JPEG code for grayscale viewing dithering for non 8 bit displays */

/* default conditions */
cinfo -> quantize_colors = FALSE;
cinfo -> two_pass_quantize = FALSE;

cinfo->use_dithering = view_defaults & dithering_bit;
cinfo->do_block_smoothing = view_defaults & smoothing_bit;

if (view_defaults & grey_bit != 0 && type_of_picture == JPG)
	cinfo->out_color_space = CS_GRAYSCALE;

video_resolution = video_cards[video_mode_used].resolution;

setup_image_info();		/* setup all drawing parameters */

if (enable_pan)		/* adjust storage for line or full buffering - only for 15/16 bit modes */
	i = picture_y_size;
else
	i = 1;
raw_pic_ptr = (*cinfo->emethods->request_big_sarray) (picture_x_size * bytes_per_pixel , i, 1L);

/* pick a different putting routine for hi_color vs VGA ie for speed */
switch (video_resolution){
	case VGA:		/* always quantize if JPEG, always grayscale, always rig color map */
		cinfo->methods->put_pixel_rows = put_pixel_rows;
#ifndef small_viewer		/* don't want color for reduced version since there is no quantizer */
#if 0
		if (more_defaults & slow_gray){
			cinfo->quantize_colors = TRUE;
			cinfo->desired_number_of_colors = 16;
			}
		if (type_of_picture == JPG && (more_defaults & vga_as_color)){
			cinfo->out_color_space = CS_RGB;
			cinfo->two_pass_quantize = view_defaults & quantize_bit;
			}
		else
#endif
		if (type_of_picture == JPG && (cinfo->out_color_space != CS_GRAYSCALE)){
			cinfo->out_color_space = CS_RGB;
			cinfo->quantize_colors = TRUE;
			cinfo->desired_number_of_colors = 16;
			cinfo->two_pass_quantize = view_defaults & quantize_bit;
			}
#else
			cinfo->out_color_space = CS_GRAYSCALE;
#endif

		/* storage for remapping color pallet of any images ie 256 color -> 16 grayscale
		 * must be intialized for all pallet drawing */
		remap = (*cinfo->emethods->alloc_small_sarray) ((long) 256, 3);
		for (i = 0; i < 256; i++)		/* default to no remapping */
			remap[0][i] = i;

		/* for JPEG we are going to have it generate the color map
		 * for everything else the colormap maps from 8 bit input to 4 bit color
		 */
		if (cinfo->color_map_present != 1 && cinfo->quantize_colors == FALSE)
			fake_colormap(cinfo, patch_colormap, 16);
		if (view_defaults & ask_size_bit && cinfo->color_map_present != TRUE)
			cprintf("quantizing down to 16 colors\r\n");
		break;
	case SVGA:
/* this was used to dither the 256 color (6 bit) display of grayscale
 * when quantizing - quantizing is no longer used for grayscale
		video_display_resolution = 0xfc;		/* 6 bit display */
		cinfo->methods->put_pixel_rows = put_pixel_rows;
		if (cinfo->out_color_space == CS_GRAYSCALE){
			if (type_of_picture == JPG)
				fake_colormap(cinfo, patch_colormap, 256);
			}
		else{
			cinfo->quantize_colors = TRUE;
			cinfo->two_pass_quantize = view_defaults & quantize_bit;
			cinfo->desired_number_of_colors = 256;
			}

		/* if the image is non JPEG, and has no color map but must be shown on
			a 256 color mode then fake it */
		if (cinfo->color_map_present != 1 && type_of_picture != JPG)
			fake_colormap(cinfo, patch_colormap, 256);

		if (view_defaults & ask_size_bit && cinfo->color_map_present != TRUE)
			cprintf("quantizing down to 256 colors\r\n");
		break;
	case SVGA_15_bit:
	case SVGA_16_bit:
	case SVGA_24_bit:
		tint_table = (*cinfo->emethods->alloc_small_sarray) ((long) 256, 3);  /* table to speed up screen tinting */
		cinfo->methods->put_pixel_rows = put_hi_pixel;
		if (type_of_picture == JPG)
			cinfo->methods->put_pixel_rows = put_pixel_not;
		break;
	}

/* setup the row and column counters for shrinking images */
col_cntr = row_cntr = 1;
}




/*
 * selected the video mode that can hold all dimensions of the image
 * or default to the largest
 * fudge the size calculation by "twiddle_factor" pixels for those pics that are slightly bigger than the mode
 *  - return an index into ok_mode[]
 *
 *  - assume x_size, y_size, shrink are properly defined
 * if we have SVGA don't bother with VGA
 * if we have 15/16/24 bit, don't bother with VGA unless grayscale
 */

int pick_screen_mode(void)
{
int i, mode_picked, temp;
int	have_SVGA,			/* have SVGA modes */
	have_hiclr;			/* have hi-color modes */

have_SVGA = 0;
have_hiclr = 0;
for (i = 0; i < number_modes_in_list; i++)
	if (ok_mode[i] >= 0)		/* only bother if its a valid mode and not flaged as empty */
		switch (video_cards[ok_mode[i]].resolution){
			case SVGA:
				have_SVGA = 1;
				break;
			case SVGA_15_bit:
			case SVGA_16_bit:
			case SVGA_24_bit:
				have_hiclr = 1;
			}

/* first if image is > all modes default to largest mode (not really the largest since the ordering is 4, 8, 15, 16, 24 bit) */
for (i = 0; i < number_modes_in_list; i++)
	if (ok_mode[i] >= 0) mode_picked = i;

for (i = number_modes_in_list - 1; i >=0; i--){
	temp = ok_mode[i];
	if (video_cards[temp].x_size >= picture_x_size / shrink - twiddle_factor
			&& video_cards[temp].y_size >= picture_y_size / shrink - twiddle_factor
			&&	temp >= 0)
		switch(video_cards[temp].resolution){
			case VGA:
				if (have_SVGA & have_hiclr == 0)
					mode_picked = i;
				break;
			case SVGA:
				if (!have_hiclr)	/* case of grayscale JPEG is solved because the mode selection routine will only have picked 4,8 bit */
					mode_picked = i;
				break;
			default:
				mode_picked = i;
			}
	}
return mode_picked;
}




/*
 * setup the enable_pan flag, shrink size
 *
 * only pan if the picture is larger than the screen
 *  unless edit_mode is set so that tint adjustments can be done and saved
 *
 */

void autocheck_panning(int mode_used)
{
enable_pan = 0;

if (view_defaults & always_pan){
	enable_pan = 1;
	return;
	}
enable_pan = view_defaults & panning_bit;

/* removed /shrink from the following calcs */
if (video_cards[mode_used].y_size >= picture_y_size - twiddle_factor
	&& video_cards[mode_used].x_size >= picture_x_size - twiddle_factor)
		enable_pan = 0;
/* if the image is 24 bit full tinting can be done any time (no panning buffer rqd
 * if the image is 256 color the pallet is easily changed any time
 */
}




/*
 * setup the shrink size
 *
 * only pan if the picture is larger than the screen
 *  unless edit_mode is set so that tint adjustments can be done and saved
 *
 */

void autocheck_shrinking(int mode_used)
{
int i;

shrink = 1;		/* default to none */

if (view_defaults & lock_shrink){
	shrink =	lock_shrink_value;
	return;
	}

if (defaults & shrink_enable_flag){
	shrink = picture_y_size / video_cards[mode_used].y_size;
	if (picture_y_size % video_cards[mode_used].y_size > twiddle_factor) shrink++;

	i = picture_x_size / video_cards[mode_used].x_size;
	if (picture_x_size % video_cards[mode_used].x_size > twiddle_factor) i++;

	if (i > shrink) shrink = i;
	if (shrink > max_shrink) shrink = max_shrink;
	if (shrink < 1) shrink = 1;
	}
}




/*
 * 1) The video mode list is sorted in order of Y size
 * 2) pick the appropiate modes and sort them into order (ie low to hi)
 *  - only keep SVGA modes for GIF and hi_color for JPEGs
 *  - bomb if GIF and only hi_color modes and check to make sure that some
 *     hi_color modes exist for jpeg or else use SVGA for JPEG as a last resort
 */

void make_mode_list(decompress_info_ptr cinfo)
{
int i, mode_type,		/* index for loops */
	condition,
	lowest,				/* lowest resolution 15/16/24 bit mode */
	minimum;				/* include SVGA modes for color JPEG (ie mighty fast machine) */

clear_list();

/*
 * first check if we have a GIF (ie color_map present), If so keep only the SVGA modes
 * at this point we can also check to see if the image is grayscale
 *   -> if so color registers are better than everything but 24 bit
 * also keep all SVGA if there is nothing better (ie any_hi_color == 0
 */
if ( ((view_defaults & grey_bit) != 0 && type_of_picture == JPG) ||
		cinfo->color_map_present != 0 ||
		cinfo->out_color_space == CS_GRAYSCALE || any_hi_color == 0)
	{
	for (mode_type = SVGA; mode_type >= VGA; mode_type--)
		for (i = 0; i < number_modes_in_list; i++)
			if (all_modes[i] >= 0)		/* only bother if its a valid mode and not flaged as empty */
				if (video_cards[all_modes[i]].resolution == mode_type)
					insert_in_list(all_modes[i], 1);

	if (ok_mode[0] < 0)		/* if its gif and there are no SVGA modes bomb */
		ERREXIT(cinfo->emethods, "Need SVGA modes for GIFs");
	}
else{
	lowest = 9999;		/* nice high default larger than any video mode */
	condition = 0;		/* set if we want to lock out all SVGA modes less than the lowest hi-color mode */
	minimum = VGA;
	if (view_defaults & only_hi_color) minimum = SVGA + 1;
	if (view_defaults & not_less_hi_color) condition = 1;

	/* ok we can use non-pallet modes ==> keep everything but SVGA */
	for (mode_type = SVGA_24_bit; mode_type >= minimum; mode_type--)
		for (i = 0; i < number_modes_in_list; i++)
			if (all_modes[i] >= 0)		/* only bother if its a valid mode and not flaged as empty */
				if (video_cards[all_modes[i]].resolution == mode_type){
					if (mode_type > SVGA && video_cards[all_modes[i]].y_size < lowest) lowest = video_cards[all_modes[i]].y_size;
					if (condition == 0 || video_cards[all_modes[i]].y_size > lowest || mode_type >> SVGA)
						insert_in_list(all_modes[i], 1);
					}
	}
}



/*
 * clear the file data record
 *
 * - alloc the memory if it is not setup, if still not enough memory start
 *   cutting down on the struct size
 * - 0 name (first byte) signifies empty
 * - 0 size indicates drive or directory tree
 */

void init_file_struct()
{
int i;

while ((file_info_head == NULL) && (max_file_records > 1)){
	file_info_head = (struct dir_info FAR *) farmalloc(sizeof(struct dir_info) * max_file_records);
	if (file_info_head == NULL){
		max_file_records >>= 1;
		if (max_file_records < 1) max_file_records = 1;
		}
	}

if (file_info_head != NULL)
	for (i = 0; i < max_file_records; i++){
		(file_info_head + i)->name[0] = 0;
		(file_info_head + i)->date = 0;
		(file_info_head + i)->size = 0;
		(file_info_head + i)->slide_num = 0;
		}
}



int test_position(char * f_name, long f_size, int f_date, int sorting_mode, struct dir_info FAR * info_ptr)
{
long difference;

		switch (sorting_mode){
			case FF_NAME:				/* case 0 sort by name */
				difference = _fstricmp(f_name, (info_ptr)->name);
				break;
			case FF_SIZE:				/* sort by file size */
				difference = f_size - (info_ptr)->size;
				break;
			case FF_DATE:				/* sort by date; year, month, then day; check for < 0 at each stage */
				difference = (f_date & 0xfe) - ((info_ptr)->date & 0xfe);
				if (difference != 0) break;

				difference = (f_date & 0x1e) - ((info_ptr)->date & 0x1e);
				if (difference != 0) break;

				difference = (f_date & 0x1f) - ((info_ptr)->date & 0x1f);
				break;
			case NONE:				/* in this case do nothing till the start of the list is found */
				difference = 1;		/* one should find bottom of the list */
				break;
			}

if (view_defaults & ascending_bit)
		difference = - difference;

/* if trying to move a directory entry then go up in the list */
if ((info_ptr)->size == 0){
	if (f_size != 0)
		difference = -1;		/* move up since we don't add onto a directory */
	}

if (difference > 0) return 1;
if (difference < 0) return -1;
else return 0;
}



/*
 * bisection search and insertion routine for list of files
 *
 * ffblk holds the value to be inserted
 *
 * usually you insert the directories first and sort by name
 * then add the other directory with any sort spec and the directories are fixed because:
 * if a size is 0 the object is fixed in place unless the new object is also 0 size - ie adding directories

 * start_index : lowest position to insert at (ie to stop the insert from disturbing the first items put in
 * return 1 if addition was done 0 if the list was full
 */

int insert_in_place(char * f_name, long f_size, int f_date, int sorting_mode, int start_index, int slide_position)
{
int top, bottom, delta, offset, index, difference;
struct dir_info FAR * info_ptr;

if (file_info_head == NULL) return 0;		/* no memory alloced for struct ! */

/* test to see if we are overwriting the last value ie inserting over the last item */
if ((file_info_head + max_file_records - 1)->name[0] != 0)
	return 0;		/* indicate nothing added */


top = max_file_records;
bottom = start_index;
delta = (top - bottom) >> 1;
offset = delta;
info_ptr = file_info_head + offset;
do{
	if ((info_ptr)->name[0] != 0){		/* its there is data */
		difference = test_position(f_name, f_size, f_date, sorting_mode, info_ptr);
		}
	else
		difference = 1;		/* move down the list since we are off the top.  ie no data is here */

	if (difference > 0)
		top -= delta;
	if (difference < 0)
		bottom += delta;
	delta = (top - bottom + 1) >> 1;
	offset = bottom + delta;
	info_ptr = file_info_head + offset;
	} while (delta > 0 && difference != 0);

/* now handle special case
 *  ie it went to the top of the list but backed down one because it was empty (ie odd number of searchs used)
 *     in this case we can just test where it is and see if its greater
 * - also special case: inserting the first item (check for 0 in info_ptr name
 */

if (test_position(f_name, f_size, f_date, sorting_mode, info_ptr) < 0 &&
		(info_ptr)->name[0] != 0){
	offset++;
	if (offset >= max_file_records) offset = max_file_records - 1;
	info_ptr = file_info_head + offset;
	}


_fmemmove(file_info_head + offset + 1, file_info_head + offset, (max_file_records - offset - 1) * sizeof(struct dir_info));

/*for (index = max_file_records - 1; index > offset; index--){
	_fstrcpy((file_info_head + index)->name, (file_info_head + index - 1)->name);
	(file_info_head + index)->size = (file_info_head + index - 1)->size;
	(file_info_head + index)->date = (file_info_head + index - 1)->date;
	}*/
_fstrcpy((info_ptr)->name, f_name);
(info_ptr)->size = f_size;
(info_ptr)->date = f_date;
(info_ptr)->slide_num = slide_position;

return 1;		/* indicate good addition to list */
}





/*
 * open the picture file,  check if its gif or jpeg
 *   setup the appropiate stuff for decoding each
 */

void check_file_in(decompress_info_ptr cinfo)
{
int c;

type_of_picture = JPG;	/* default */

if ((c = getc(cinfo->input_file)) == EOF)
	ERREXIT(cinfo->emethods, "Empty input file");

switch (c) {
#ifdef GIF_SUPPORTED
	case 'G':
		selrgif(cinfo);
		type_of_picture = GIF;
		break;
#endif

#ifdef PPM_SUPPORTED
	case 'P':
		j_sel_r_ppm(cinfo);
		type_of_picture = PPM;
		break;
#endif

#ifdef TARGA_SUPPORTED
	case 0x00:
		type_of_picture = TGA;
		j_sel_r_targa(cinfo);
		break;
#endif
	default:			/* assume default is jpeg type picture */

#ifdef JFIF_SUPPORTED
		jselrjfif(cinfo);
#else
		You shoulda defined JFIF_SUPPORTED.   /* deliberate syntax error */
#endif
		break;
	}

if (ungetc(c, cinfo->input_file) == EOF)
	 ERREXIT(cinfo->emethods, "ungetc failed");
}



/*
 * file to read all non-jpeg images once the pointers have been setup
 */

void read_non_jpeg(decompress_info_ptr cinfo)
{
JSAMPIMAGE row_ptr;		/* storage for 1 row */
int i, row;

	(*cinfo->methods->read_file_header) (cinfo);

	(*cinfo->methods->d_ui_method_selection) (cinfo);
	(*cinfo->methods->output_init) (cinfo);

	if (cinfo->color_map_present)		/* put out color map */
		(*cinfo->methods->put_color_map) (cinfo, cinfo->actual_number_of_colors, cinfo->colormap);

	/* alloc pointers & data */

	row_ptr = (JSAMPIMAGE) (*cinfo->emethods->alloc_small)
		(SIZEOF(JSAMPARRAY) * 3);		/* always 3 unless it is color map; but do three */
	for (i = 0; i < cinfo->num_components; i++)
		row_ptr[i] = (*cinfo->emethods->alloc_small_sarray)
			(cinfo->image_width + 1, 1 );

	/* if only 1 component ie greyscale, color map point all components to first
		 -> this makes a greyscale picture out of one component if non colormap */
	if (cinfo->num_components < 3){
		row_ptr[2] = row_ptr[0];
		row_ptr[1] = row_ptr[0];
		}

  /* alloc all of the large storage - ie panning buffer if needed */
  (*cinfo->emethods->alloc_big_arrays)
	((long) 0,				/* no more small sarrays */
	 (long) 0,				/* no more small barrays */
	 (long) 0);				/* no more "medium" objects */

	for (row = cinfo->image_height; row > 0; row--){
		check_keybd(cinfo, "E");
		(*cinfo->methods->get_input_row) (cinfo, row_ptr);
		(*cinfo->methods->put_pixel_rows) (cinfo, 1, row_ptr);
		}

	(*cinfo->methods->output_term) (cinfo);

	(*cinfo->emethods->free_all) ();
}




/*
 * do everything to show the file
 *
 */

void show_it(decompress_info_ptr cinfo, char * file_name)
{
static char path_file_name[file_name_len];	/* path + name to file to view */
int test_it;
char pic_file_path[file_name_len];
FILE *file_in;

static struct Decompress_methods_struct dc_methods;
static struct External_methods_struct e_methods;

/*
 * do all of the initialization of the JPEG data structure
 * and set to default values
 */

/* Initialize the system-dependent method pointers. */
cinfo->methods = &dc_methods;
cinfo->emethods = &e_methods;

/* Here we supply our own error handler; compare to use of standard error
 * handler in the previous write_JPEG_file example.
 */

emethods = &e_methods;	/* save struct addr for possible access */
e_methods.error_exit = error_exit; /* supply error-exit routine */
e_methods.trace_message = trace_message; /* supply trace-message routine */
e_methods.trace_level = 0;	/* default = no tracing */
e_methods.num_warnings = 0;	/* no warnings emitted yet */
e_methods.first_warning_level = 0; /* display first corrupt-data warning */
e_methods.more_warning_level = 3; /* but suppress additional ones */

jselmemmgr(&e_methods);	/* memory allocation routines */
dc_methods.d_ui_method_selection = d_ui_method_selection;

/* Now OK to enable signal catcher. */
#ifdef NEED_SIGNAL_CATCHER
	emethods = &e_methods;
	signal(SIGINT, signal_catcher);
	#ifdef SIGTERM			/* not all systems have SIGTERM */
		signal(SIGTERM, signal_catcher);
	#endif
#endif

/* Set up default JPEG parameters. */
j_d_defaults(cinfo, TRUE);

cinfo->colormap = FALSE;		/* default is non colormap picture */
cinfo->color_map_present = 0;	/* this is not a part of the original JPEG so clear it to be sure */
zoom_inc = 4;			/* default to no software zoom in */
row_ordering = NORMAL;	/* for handling bottom up targa's and interlaced gifs when panning */

/* setup text on the screen ie file name or the defined string from the list of arguements */
if (picture_text_arguement[0] != 0) strcpy(picture_text, picture_text_arguement);
else strcpy(picture_text, file_name);

/*
 * now setup the offsets for tints, contrasts, brightness
 */
red_tint = green_tint = blue_tint = color_scale = contrast_scale = 0;

strcpy(file_being_viewed, file_name);

try_4_DOS(picture_description);

/* setup title on the screen ie file name or the defined string from the list of arguements */
if (picture_title_arguement[0] != 0) strcpy(picture_title, picture_title_arguement);
else strcpy(picture_title, picture_description);

/* load default viewing file if it exists
 * try local directory first then original directory
 */
tint_loaded = 0;		/* flag the graphics routines to speed up if there are no tint offsets loaded from the file */
if (defaults & use_default_file){
	strcpy(pic_file_path, file_path);
	strcat(pic_file_path, viewing_defaults_file);
	file_in = fopen(pic_file_path, "rb");
	if (file_in == NULL){
		strcpy(pic_file_path, original_path);
		strcat(pic_file_path, viewing_defaults_file);
		file_in = fopen(pic_file_path, "rb");
		}
	if (file_in != NULL){
		tint_loaded = find_picture_setup(file_in);
		fclose(file_in);
		}
	}

strcpy(path_file_name, file_path);
strcat(path_file_name, file_name);

if ((cinfo->input_file = _fsopen(path_file_name, READ_BINARY, SH_COMPAT)) != NULL) {
	if (type_of_picture != JPG)
		buffer_ok = setvbuf(cinfo->input_file, NULL, _IOFBF, buffer_size << 10);	/* buffer for input stream */
	else
		buffer_ok = 1;	/* JPEG buffer is always good or we get a memory alloc error */

	check_file_in(cinfo);
	key_hit = 0;			/* clear key check flag */
	gr_row = 0;				/* one shot stuff for pixel drawing routine */
	read_row = 0;
	col_cntr=1, row_cntr=1;
	test_it = setjmp(setjmp_buffer);
	if (test_it == 0)			/* hop to here if there was a tragic error */
		if (type_of_picture != JPG)
			read_non_jpeg(cinfo);
		else
			jpeg_decompress(cinfo);

	fclose(cinfo->input_file);
	}
}




/*
 * load_config for viewer only
 *	ie it throws away info about the table of usefull modes
 *
 * try may directories for the file
 * - first a forced path-name can be used
 * - then try the current path followed the directory that holds the executable
 * if the forced file name was used then return a 2 instead of a one
 */

int load_config_viewer(char *forced_name)
{
int	i, j,
		return_flag = 1,	/* 1 = dvpeg.cfg found, 2 = forced file found and ok */
		num_custom;		/* index for custom modes */

FILE *config_file;

/* clear the list of modes to -1, ie -1 indicates no data, if it is 0 .. XX it is a valid mode */
for (i=0; i < number_modes_in_list; i++)
	ok_mode[i] = -1;

clear_video_struct();

/* defaults in-case no file exists THESE DEFAULTS ARE BOGUS ==> NO FILE == NO VIEWER */
shrink = 1;						/* set default for shrink */
view_defaults = dithering_bit | smoothing_bit | quantize_bit | panning_bit | ask_size_bit | beep_on;
any_hi_color  = 0;
mode_lock = -1;		/* set to no video mode being locked in */

config_file = NULL;
if (forced_name != NULL){		/* has a name been forced? */
	strcpy(config_name, forced_name);
	config_file = fopen(config_name, "rb");
	if (config_file != NULL)
		if (getc(config_file) != cfg_file_marker){		/* if there is a bad marker don't use info */
			fclose(config_file);
			config_file = NULL;
			}
		else{
			rewind(config_file);
			return_flag = 2;		/* return that the config file was used */
			}
	}

if (config_file == NULL){
	strcpy(config_name, original_path);		/* try boot path for config file */
	strcat(config_name, config_file_name);
	config_file = fopen(config_name, "rb");
	}

if (config_file == NULL){
	strcpy(config_name, code_path);		/* try executable dir for config file */
	strcat(config_name, config_file_name);
	config_file = fopen(config_name, "rb");
	}

if (config_file != NULL){						/* load the file mode descriptions */
	if (getc(config_file) != cfg_file_marker){		/* if there is a bad marker don't use info */
		fclose(config_file);
		return 0;
		}
	mode_lock = getw(config_file);
	sort_mode = getw(config_file);
	view_defaults = getw(config_file);				/* various defaults ie grey ... */
	text_mode_number = getw(config_file);
	text_width = getw(config_file);
	text_height = getw(config_file);
	slideshow_pause = getw(config_file);
	max_file_records = getw(config_file);
	defaults = getw(config_file);
	lock_shrink_value = getw(config_file);
	buffer_size = getw(config_file);
	twiddle_factor = getw(config_file);
	more_defaults = getw(config_file);
	getw(config_file);		/* for future expansion */
	getw(config_file);

	i = -1;			/* now the list of file masks, list is terminated by an empty mask */
	do{
		fgets(file_masks[++i], 15, config_file);
		for (j=0; j < 14; j++)
			if (file_masks[i][j] == '\n') file_masks[i][j] = 0;		/* remove that \n since it is only needed for loading string in */
		} while (strlen(file_masks[i]) > 0 && i < max_file_masks - 1);

	fgets(default_path, file_name_len - 1, config_file);			/* default path ?? */
	for (i=0; i < file_name_len - 1; i++)
		if (default_path[i] == '\n') default_path[i] = 0;		/* remove that \n since it is only needed for loading string in */
	i = -1;
	while((getw(config_file)) != -1){		/* striped off vidsetup specific info */
		if (++i >= number_modes_in_list) i--;
		ok_mode[i] = i;
		card_id = video_cards[i].card_number = getw(config_file);		/* card_id is the menu default */
		video_cards[i].x_size = getw(config_file);
		video_cards[i].y_size = getw(config_file);
		if ((video_cards[i].resolution = getw(config_file)) > SVGA)
				any_hi_color = 1;
		video_cards[i].set_ax = getw(config_file);
		video_cards[i].set_bx = getw(config_file);
		video_cards[i].x_width = getw(config_file);
		}
	fclose(config_file);

	/* copy default directory to the file path */
	if (strlen(default_path) > 0){
		strcpy(file_path, default_path);
		strcat(file_path, "\\");
		}

	/* now setup the permenant list of modes as the user has chosen them --> ok_modes
	 *  - the list in ok_mode[] is edited so that hi_color is used for JPEG and SVGA for GIF
	 */
	for (i = 0; i < number_modes_in_list; i++)
		all_modes[i] = ok_mode[i];
#ifdef small_viewer
	view_defaults |= clear_during_pan;
/*	more_defaults &= ~slow_gray;		/* default to no quantizing _ever_ */
	view_defaults &= ~quantize_bit;
	view_defaults |= grey_bit;
	buffer_size = 8;		/* smaller buffer to reduce memory usage */
#endif
	return return_flag;
	}
else
	return 0;
}




/*
 * setup the info for one file to be printed on the screen
 * select the color (if its a directory, in the file_list, currently selected ...
 * move the cursor to the selected spot
 * cprintf the result
 * assume that it is on the text screen
 *
 * file_index is the index in the dir_info struct
 * drawing_index is the index for drawing on the screen
 */

void setup_file_info(int file_index, int drawing_index)
{
char result[60];
char temp_string[20];
int i, x_pos, y_pos;
struct dir_info FAR * temp_info_ptr;	/* generic pointer for tempary use */

temp_info_ptr = file_info_head + file_index;

_fstrcpy(temp_string, temp_info_ptr->name);

sprintf(result, "%13s", temp_string);

if (defaults & long_file_format && temp_info_ptr->size > 0){
	i = ((temp_info_ptr->size >> 9) + 1) >> 1;		/* file size in k bytes - rounded up */
	if (i < 1) i = 1;
	itoa(i, temp_string, 10);
	strcat(result, " (");
	strcat(result, temp_string);
	strcat(result, "k)");
	}
result[column_width] = 0;		/* limit the length if it just happens to be too big for some reason */

if (file_index == selected_file)
	textcolor(YELLOW);
else{
	if (temp_info_ptr->size == 0)
		textcolor(LIGHTBLUE);
	else
		textcolor(LIGHTGRAY);
	if (temp_info_ptr->slide_num != 0)	/* red for a selected file */
		textcolor(LIGHTRED);
	}
x_pos = column_width * (drawing_index / per_column) + 1;
y_pos = ( drawing_index % per_column) + 3;
gotoxy(x_pos, y_pos);
cprintf("%s", result);
}




/*
 * The main program.
 */

GLOBAL int
main (int argc, char *argv[])
{
int old_selected_file, exit_prog, draw_all;
int num_slide_show;		/* slide show vars */
struct Decompress_info_struct cinfo;
int c, i;
unsigned int disk_tmp, disk_test;
char *chr_ptr, *char_index;
char temp_char[81];
FILE *config_file, *response_file;
struct dir_info FAR * old_file_info;		/* pointer to old file data */
char *input_arg[3];		/* arguements parsed from the response file or a mirror of argv[] */

current_graphics_mode = -1;		/* set to indicate that we are not in a graphics screen */
if ((line_buffer_ptr = farmalloc(line_buffer_bytes)) == NULL){
	prep_for_exit();
	printf("Could not allocate enough far memory\n");
	exit(-1);
	}

/* memory usage (during viewing) variables */
near_memory_view = far_memory_view = 0;

picture_title_arguement[0] = 0;		/* null the string init */
picture_text_arguement[0] = 0;		/* null the text string */

get_video();		/* save the current text video mode */


/* clear the list of file masks */
for (i=0; i < max_file_masks; i++)
	file_masks[i][0] = 0;

/* find the maximum number of drives in the system */
_dos_getdrive(&disk_tmp);

i = 0;
c = 1;
do{
	_dos_setdrive(c, &max_drives);
	_dos_getdrive(&disk_test);
	if (disk_test == c)		/* we found a good one */
		drive_list[i++] = c + 'A' - 1;
	}while (++c <= max_drives && c < drive_list_length);

_dos_setdrive(disk_tmp, &max_drives);	/* restore drive */

strcpy(file_path, "C:\\");
file_path[0] = disk_tmp + 'A' - 1;
getcurdir(disk_tmp, file_path + 3);
if (strlen(file_path) > 3)   /* watch out for root because its X:/ already */
	strcat(file_path, "\\");
strcpy(original_path, file_path);

/* Select the input and output files */

cinfo.output_file = stdout;	/* always the output file */

/* does the dvpeg.cfg file exist? change .exe to .cfg and fetch from same dir as executable */
/* set up name for config file (dvpeg.cfg) and assume its in the same dir as vidsetup.exe */
strcpy(config_name, argv[0]);

/* knock off file and add dvpeg.cfg to path */
for (c=strlen(config_name); c >= 0 && config_name[c] != '\\'; c--);
config_name[c+1] = 0;		/* add dvpeg.cfg in load_config */
strcpy(code_path, config_name);	/* save the path to the executable */

config_found = load_config_viewer(NULL);	/* first attempt at finding/loading */

/* check and parse the arguements 1 at a time,
 * we could do them all at once but each line can be a response file so check them each
 */
c = 1;		/* current arguement ie test for @file as an arguement */
while (c < argc){
	if (*argv[c] == '@'){
		if ((response_file = fopen(argv[c] + 1, "rt")) != NULL)
			do{
				fgets(temp_char, 81, response_file);
				temp_char[strlen(temp_char) - 1] = 0;	/* remove \n at the end of the line */
				input_arg[1] = temp_char;	/* first arg is always easy and always ends at the first space */

				/* everything after the first (if there) space is assumed to be the 2nd arguement */

				i = 2;
				if ((input_arg[2] = strchr(temp_char, ' ')) != NULL){
					i = 3;
					*input_arg[2] = 0;	/* set end of string for first arg */
					input_arg[2] += 1;
					}
				parse_switches(&cinfo, i, input_arg, 1);
				} while (!feof(response_file));
			fclose(response_file);
		}
	else
		c = parse_switches(&cinfo, argc, argv, c);
	c++;
	}

/* now check for the existance of files in the file list structure
 * if they are there clear the slide show flags
 */
if (file_info_head != NULL)
	for (i = max_file_records-1; i >= 0; i--)
		(file_info_head + i)->slide_num = 0;

/* ok put up the list of files and let the user pick one */
if (config_found == 0){
	printf("Dvpeg configuration file has not been found\n");
	printf("If you have a Paradise video card please hit ESC now\n and then run vidsetup\n");
	printf("To continue press any key but ESC\n");
	if (getch() == escape){
		prep_for_exit();
		exit(-1);
		}
	strcpy(temp_char, code_path);	/* the path to the executable */
	strcat(temp_char, "vidsetup -quiet");		/* run it and hope that the config file is made */
	system(temp_char);
	config_found = load_config_viewer(NULL);	/* first attempt at finding/loading */
	}
if (config_found == 0){
	prep_for_exit();
	printf("\nYou must run vidsetup before you can use dvpeg\n");
	exit(-1);
	}

	do_slide_show = 0;
	num_slide_show = 0;
	exit_prog = 0;
	selected_file = 0;
	old_selected_file = 0;
	setup_text_screen();			/* setup the right video mode */
	draw_all = init_screen();		/* signal whole screen redraw */
	if ((defaults & dont_get_files) == 0)
		get_files();

	do{
		if ((defaults & no_file_list) == 0)
		if (draw_all){
						/* now print the names */
			for (c = 0; c < per_page && (first_file + c < number_files) && c < max_file_records && file_info_head != NULL; c++)
				setup_file_info(c + first_file, c);
			draw_all = 0;
			}
		else		/* only redraw current line & old selection */
			{
			setup_file_info(old_selected_file, old_selected_file - first_file);

			setup_file_info(selected_file, selected_file - first_file);
			}
		old_selected_file = selected_file;

		if (defaults & no_file_list){
			i = RTN;
			if (kbhit())
				if (get_key() == escape) i = escape;
			}
		else
			i = get_key();
		switch (i){
			case escape:
				exit_prog = 1;
				break;
			case 'a':
			case 'A':	/* select all for slide show */
				num_slide_show = 0;
				for (i = 0;	i < max_file_records; i++)
					if ((file_info_head + i)->size > 0)
						(file_info_head + i)->slide_num = ++num_slide_show;
				draw_all = init_screen();
				break;
			case 'S':		/* slide show trigger for continous */
				defaults |= slide_show_continous;
			case 's':		/* trigger for one shot slide show */
				slide_show(&cinfo);
				setup_text_screen();			/* setup the right video mode */
				draw_all = init_screen();
				break;
			case delete:		/* delete a file */
				if ((file_info_head + selected_file)->size > 0){	/* ie only for files not directories or drives */
					strcpy(temp_char, "del ");
					strcat(temp_char, file_path);
					_fstrcat(temp_char, (file_info_head + selected_file)->name);
					system(temp_char);
					get_files();
					draw_all = init_screen();
					}
				break;
			case ' ':		/* slide show list ie add or delete */
				if ((file_info_head + selected_file)->size > 0){		/* is it a file or directory/drive ? */
					if ((file_info_head + selected_file)->slide_num > 0)
						{	/* delete an item */
						c = (file_info_head + selected_file)->slide_num;

						/* deleting is done by setting the current files' flag to 0 and subtracting 1 from any one that has a value greater than it */

						(file_info_head + selected_file)->slide_num = 0;
						for (i = max_file_records-1; i >= 0; i--)
							if ((file_info_head + i)->slide_num > c)
								(file_info_head + i)->slide_num--;
						num_slide_show--;
						}
					else	/* add it */
						(file_info_head + selected_file)->slide_num = ++num_slide_show;
					}
				selected_file++;
				break;
			case RTN:		/* change directory ?? */
				if ((file_info_head + selected_file)->size == 0){
					if ((file_info_head + selected_file)->name[0] == '[')
						change_drive((file_info_head + selected_file)->name[1]);
					else
						if ((file_info_head + selected_file)->name[0] == '.'){
							/* do nothing on a . but move up in tree on .. */
							if ((file_info_head + selected_file)->name[1] == '.'){
								for (c=strlen(file_path)-2; c >= 0 && file_path[c] != '\\'; c--);
								file_path[c+1] = 0;
								}
							}
						else{				/* its a directory down - add it to list */
						_fstrcat(file_path, (file_info_head + selected_file)->name);
							strcat(file_path, "\\");
							}
					get_files();
					draw_all = init_screen();
					}
				else		/* if the menu is turned off, do not exit here until ESC is hit */
					{
					show_next_file = 0;
					time_at_start = 0;
					do{
						c = view_defaults;	/* save default ie it may have changed */
						i = show_next_file;		/* preserve status to determine if we restore view_defaults or not */
						if (show_next_file != 0)
							view_defaults &= (~ask_size_bit);	/* turn off second menu */
						show_next_file = 0;	/* zero it to see if it was changed again */

						_fstrcpy(temp_char, (file_info_head + selected_file)->name);
						show_it(&cinfo, temp_char);

						if (i != 0)		/* if the menu was hidden then restore view_defaults */
							view_defaults= c;
						if (show_next_file == 1 && selected_file < number_files)
							selected_file++;
						if (show_next_file == -1 && selected_file > 0)
							selected_file--;

						/* if the menu is turned off just cycle thru the files again and again until ESC */

						if (defaults & no_file_list){
							if (show_next_file == 0) exit_prog = 1;
							if (show_next_file == 1 && selected_file >= number_files)
								selected_file = 0;
							if (show_next_file == -1 && selected_file <= 0)
								selected_file = number_files - 1;
							}
						}
					while (show_next_file != 0);

					if ((defaults & no_file_list) == 0){
						setup_text_screen();			/* setup the right video mode */
						draw_all = init_screen();
						}
					}
				break;
			case arrow_up:
				selected_file--;
				break;
			case arrow_down:
				selected_file++;
				break;
			case arrow_left:
				if (selected_file - per_column >= first_file)
					selected_file -= per_column;
				break;
			case arrow_right:			/* stop going off right edge */
				if (selected_file + per_column < first_file + per_page)
					selected_file += per_column;
				break;
			case page_up:
				selected_file -= per_page;
				break;
			case page_down:
				selected_file += per_page;
				break;
			case home:
				selected_file = 0;
				break;
			case end:
				selected_file = number_files;
				break;

#ifndef small_viewer		/* reduced viewer without ability to change options */
			case F1:
					open_window(40, 14);
					cprintf("up/down arrow - select a file\r\n");
					cprintf("enter - check out that picture\r\n");
					cprintf("space - select for slideshow\r\n");
					cprintf("S, s - slide show (S = continous)\r\n");
					cprintf("F2 - change drive\r\n");
					cprintf("F3, F7 - change defaults\r\n");
					cprintf("F4 - change mask for files\r\n");
					cprintf("F5 - change sorting criteria\r\n");
					cprintf("F6 - change file path\r\n");
					cprintf("\nMemory: %lu + %lu bytes",(unsigned long) coreleft(), (unsigned long)farcoreleft());
					cprintf("\r\nDuring pic: %lu + %lu bytes",(unsigned long) near_memory_view, (unsigned long)far_memory_view);
					getch();
					draw_all = init_screen();
					break;
			case F2:		/* change directory and default to the current path on that drive */
				open_window(40,10);
				cprintf("Current drive is %c\r\n",file_path[0]);
				cprintf("What is the new drive?\r\n");
				change_drive(toupper(getch()));
				draw_all = init_screen();
				break;
			case F3:		/* see if user wants to turn off next window */
				do{
					open_window(46,18);
					show_defaults(1, 1);
					} while ( change_defaults(getch(), 1));

				draw_all = init_screen();
				break;
			case F4:				/* get the file mask */
				open_window(40,10);
				if (get_file_masks())	/* if anything was changed */
					get_files();
				draw_all = init_screen();
				break;
			case F5:				/* change the sort order */
				open_window(40,10);
				cprintf("Sort order is: ");
				switch (sort_mode){
					case NONE:
									cprintf("unsorted");
									break;
					case FF_NAME:
									cprintf("by name");
									break;
					case FF_SIZE:
									cprintf("by size");
									break;
					case FF_DATE:
									cprintf("by date");
									break;
					}
				cprintf("\r\nchoose: Unsorted, Name, Size, Date\r\n");
				c = getch();
				switch (c){
					case 'N':
					case 'n':   sort_mode = FF_NAME;
									break;
					case 'U':
					case 'u':
									sort_mode = NONE;
									break;
					case 'S':
					case 's':
									sort_mode = FF_SIZE;
									break;
					case 'D':
					case 'd':
									sort_mode = FF_DATE;
									break;
					}
				get_files();
				draw_all = init_screen();
				break;
			case F6:
				open_window(50, 10);
				cprintf("The file path is: %25s\r\n\n", file_path);
				cprintf("What is the new path (ie d:\\gifs)?\r\n");
				if (get_line(config_name, 25) > 0){
					strcpy(file_path, config_name);
					strcat(file_path, "\\");
					get_files();
					}
				draw_all = init_screen();
				break;
			case F7:
				i = c = 0;		/* use i, c to check for any change that indicates a new file list is needed */
				open_window(40, 20);
				do{
					i |= c;
					show_extra_defaults();
					}while (	(c = change_extra_defaults(getch())) != 0 );
				if ((i & 0x4) != 0) setup_text_screen();			/* setup the right video mode */
				if ((i & 0x2) != 0) get_files();
				draw_all = init_screen();
				break;
#endif
			}
		if ((defaults & no_file_list) == 0){
			if (selected_file < 0) selected_file = 0;
			if (selected_file >= number_files) selected_file = number_files - 1;

			if (selected_file >= first_file + per_page){	/* went off bottom of page - center on chosen file */
				first_file = selected_file - (per_page >> 1);
				if (first_file >= number_files - per_page)
					first_file = number_files - per_page;
				draw_all = init_screen();
				}
			if (selected_file < first_file){		/* went off top of screen - try to center on chosen file */
				first_file = selected_file - (per_page >> 1);
				if (first_file < 0)
					first_file = 0;
				draw_all = init_screen();
				}
			}
	}while (!exit_prog);

prep_for_exit();

return 1;			/* indicate success */
}
