	-- "walk" through a directory structure

-- example: 
--	ex walkdir c:\
-- will examine your whole C: hard disk

-- This program recursively searches a directory and all of its subdirectories.
-- For now we just make a sorted list of the biggest files encountered in 
-- the search. This shows how to use the dir() built-in function.
-- You might want to modify the look_at() routine below to report other 
-- information. 

-- usage:  ex walkdir [path-name]  -- defaults to current directory

-- Note that you can cd into any directory and say "ex walkdir" since 
-- c:\euphoria\bin should be on your search path.

constant YES = 1, NO = 0

-------- Select the information you want to see ------------------------------
constant FILE_INFO = YES,          -- display info on each file
	 BIGGEST = YES,	           -- print a list of the biggest files
	 BIG_NUM = 20,		   -- number of big files to display
	 RUNNING_FILE_COUNT = YES  -- display running count of files
------------------------------------------------------------------------------

include file.e
include sort.e

constant SCREEN = 1, ERR = 2
sequence cmd

sequence big_list
big_list = {{-1, "dummy"}}

constant INDENT_AMOUNT = 4

integer indent
indent = 0

integer nfiles
nfiles = 0

procedure show_biggest_files()
-- print list of biggest files

    if big_list[length(big_list)][1] = -1 then
	-- delete dummy entry
	big_list = big_list[1..length(big_list)-1]
	if length(big_list) = 0 then
	    return
	end if
    end if
    printf(SCREEN, "\nThe Top %d\n\n", length(big_list))
    for i = 1 to length(big_list) do
	printf(SCREEN, "%7d %-14s\n", big_list[i])
    end for
end procedure

procedure look_at(sequence path_name, sequence entry)
-- "look at" a file or directory entry

    if FILE_INFO then
        puts(SCREEN, repeat(' ', indent))
        printf(SCREEN, "%-14s%3s %6d  %4d/%02d/%02d  %02d:%02d:%02d\n", entry)
    end if
    if find('d', entry[D_ATTRIBUTES]) then
	return
    end if
    nfiles = nfiles + 1
    if not FILE_INFO and RUNNING_FILE_COUNT then
	printf(SCREEN, "%d \r", nfiles)
    end if

    -- should it be added to the big files list?
    for i = 1 to length(big_list) do
	if entry[D_SIZE] > big_list[i][1] then
    	    -- insert new big file
    	    big_list = append(big_list[1..i-1], 
		          {entry[D_SIZE], path_name & '\\' & entry[D_NAME]}) &
		           big_list[i..length(big_list)]
	    if length(big_list) > BIG_NUM then
		-- drop the smallest file
		big_list = big_list[1..length(big_list)-1]
	    end if
	    exit
	end if
    end for
end procedure

procedure walk_dir(sequence path_name)
-- walk through a directory and its subdirectories 
-- in alphabetical order, "looking" at each file
    object d

    d = dir(path_name)
    while find(path_name[length(path_name)], " \\") do
	path_name = path_name[1..length(path_name)-1]
    end while
    if atom(d) then
	puts(ERR, "Couldn't open " & path_name)
    end if
    d = sort(d)
    for i = 1 to length(d) do
	if not find(d[i][D_NAME], {".", ".."}) then
	    look_at(path_name, d[i])
	    if find('d', d[i][D_ATTRIBUTES]) then
		indent = indent + INDENT_AMOUNT
	        walk_dir(path_name & '\\' & d[i][D_NAME])
		indent = indent - INDENT_AMOUNT
	    end if
	end if
    end for
end procedure

cmd = command_line()
if length(cmd) = 2 then
    cmd = append(cmd, ".") -- default to current directory
elsif length(cmd) != 3 then
    puts(ERR, "usage: ex walkdir path-name\n")
    abort(1)
end if

walk_dir(cmd[3])

if BIGGEST and length(dir(cmd[3])) > 1 then
    show_biggest_files()
end if
printf(SCREEN, "%d files scanned\n", nfiles)
without warning

