#include <fastgraf.h>
#include <string.h>
#include <ctype.h>

/***************************************************************************\
         ENUMS
\***************************************************************************/

#ifndef __COLORS
#define __COLORS
enum COLORS {

   TRANSPARENT,
   BLACK=0,       /* dark colors */
   BLUE,
   GREEN,
   CYAN,
   RED,
   MAGENTA,
   BROWN,
   LIGHTGRAY,
   DARKGRAY,      /* light colors */
   LIGHTBLUE,
   LIGHTGREEN,
   LIGHTCYAN,
   LIGHTRED,
   LIGHTMAGENTA,
   YELLOW,
   WHITE,

};
#endif

/* Return codes for input routines */
enum INPUT {

   IN_ESCAPE=-1,
   IN_SUCCESS,
   IN_MASK_TOO_LONG,
   IN_NOT_SUPPORTED,
   IN_NOT_DEFINED,
   IN_BOX_TOO_BIG,
   IN_BUFFER_TOO_LONG,
   IN_TAB,
   IN_SHIFT_TAB,
   IN_DARROW,
   IN_UARROW

};


/***************************************************************************\
         FUNCTION DECLARATIONS
\***************************************************************************/

#ifdef __cplusplus
extern "C" {
#endif

/* Fginput functions */
int define_parameters(void);
int restore_default_colors(void);
int display_line(char *, const char *);
int input_line(char *, const char *);

int wait_key_masked(char);

/* Keyboard functions */
void clear_key(void);
int  delay_key(int);
int  check_key(void);
int  wait_key(void);
int  bios_key(int);

#ifdef __cplusplus
}
#endif


/***************************************************************************\
         GLOBALS
\***************************************************************************/

/* Colors */
extern int BorderLcolor;
extern int BorderRcolor;
extern int BorderTcolor;
extern int BorderBcolor;
extern int Backcolor;
extern int BackHighlightcolor;
extern int TextNormalcolor;
extern int TextHighlightcolor;
extern int Cursorcolor;

extern int TextSize;
extern int Polled_Mode;


/***************************************************************************\
         DEFINES
\***************************************************************************/

/*****************************************\
      These macro functions are self-
   explanatory.  They return 1 if true and
   0 if false
\*****************************************/
/* Standard/All keyboards */
#define shift_pressed()       (bios_key(0x02)&0x0003)
#define left_shift_pressed()  (bios_key(0x02)&0x0002)
#define right_shift_pressed() (bios_key(0x02)&0x0001)
#define ctrl_pressed()        (bios_key(0x02)&0x0004)
#define alt_pressed()         (bios_key(0x02)&0x0008)
#define scroll_lock_on()      (bios_key(0x02)&0x0010)
#define num_lock_on()         (bios_key(0x02)&0x0020)
#define caps_lock_on()        (bios_key(0x02)&0x0040)
#define insert_on()           (bios_key(0x02)&0x0080)

/* Enhanced keyboards */
#define left_ctrl_pressed()   (bios_key(0x12)&0x0100)
#define right_crtl_pressed()  (bios_key(0x12)&0x0400)
#define left_alt_pressed()    (bios_key(0x12)&0x0200)
#define right_alt_pressed()   (bios_key(0x12)&0x0800)
#define scroll_lock_pressed() (bios_key(0x12)&0x1000)
#define num_lock_pressed()    (bios_key(0x12)&0x2000)
#define caps_lock_pressed()   (bios_key(0x12)&0x4000)
#define sys_rq_pressed()      (bios_key(0x12)&0x8000)


/***************************************************************************\

         KEY RETURN MACROS

   These values are returned by wait_key(), check_key(), and delay_key()

\***************************************************************************/

#ifndef _KEYMACROS
#define _KEYMACROS

#define F1              0x013B
#define F2              0x013C
#define F3              0x013D
#define F4              0x013E
#define F5              0x013F
#define F6              0x0140
#define F7              0x0141
#define F8              0x0142
#define F9              0x0143
#define F10             0x0144
#define F11             0x0185
#define F12             0x0186
#define HOME            0x0147
#define UARROW          0x0148
#define PGUP            0x0149
#define LARROW          0x014B
#define RARROW          0x014D
#define END             0x014F
#define DARROW          0x0150
#define PGDN            0x0151
#define INS             0x0152
#define DEL             0x0153
#define BS              0x0008
#define LF              0x000A
#define CR              0x000D
#define TAB             0x0009
#define ESC             0x001B
#define _A              0x0061
#define _B              0x0062
#define _C              0x0063
#define _D              0x0064
#define _E              0x0065
#define _F              0x0066
#define _G              0x0067
#define _H              0x0068
#define _I              0x0069
#define _J              0x006A
#define _K              0x006B
#define _L              0x006C
#define _M              0x006D
#define _N              0x006E
#define _O              0x006F
#define _P              0x0070
#define _Q              0x0071
#define _R              0x0072
#define _S              0x0073
#define _T              0x0074
#define _U              0x0075
#define _V              0x0076
#define _W              0x0077
#define _X              0x0078
#define _Y              0x0079
#define _Z              0x007A
#define _1              0x0031
#define _2              0x0032
#define _3              0x0033
#define _4              0x0034
#define _5              0x0035
#define _6              0x0036
#define _7              0x0037
#define _8              0x0038
#define _9              0x0039
#define _0              0x0030
#define DASH            0x002D
#define EQUAL           0x003D
#define OPENBRACKET     0x005B
#define CLOSEBRACKET    0x005D
#define BACKSLASH       0x005C
#define SEMICOLON       0x003B
#define APOSTROPHY      0x0027
#define COMMA           0x002C
#define PERIOD          0x002E
#define FORESLASH       0x002F
#define SINGLEOPENQUOTE 0x0060


#define SHIFT_F1              0x0154
#define SHIFT_F2              0x0155
#define SHIFT_F3              0x0156
#define SHIFT_F4              0x0157
#define SHIFT_F5              0x0158
#define SHIFT_F6              0x0159
#define SHIFT_F7              0x015A
#define SHIFT_F8              0x015B
#define SHIFT_F9              0x015C
#define SHIFT_F10             0x015D
#define SHIFT_F11             0x0187
#define SHIFT_F12             0x0186
#define SHIFT_HOME            0x0037
#define SHIFT_UARROW          0x0038
#define SHIFT_PGUP            0x0039
#define SHIFT_LARROW          0x0034
#define SHIFT_RARROW          0x0036
#define SHIFT_END             0x0031
#define SHIFT_DARROW          0x0032
#define SHIFT_PGDN            0x0033
#define SHIFT_INS             0x0030
#define SHIFT_DEL             0x002E
#define SHIFT_BS              0x0008
#define SHIFT_TAB             0x010F
#define SHIFT_A               0x0041
#define SHIFT_B               0x0042
#define SHIFT_C               0x0043
#define SHIFT_D               0x0044
#define SHIFT_E               0x0045
#define SHIFT_F               0x0046
#define SHIFT_G               0x0047
#define SHIFT_H               0x0048
#define SHIFT_I               0x0049
#define SHIFT_J               0x004A
#define SHIFT_K               0x004B
#define SHIFT_L               0x004C
#define SHIFT_M               0x004D
#define SHIFT_N               0x004E
#define SHIFT_O               0x004F
#define SHIFT_P               0x0050
#define SHIFT_Q               0x0051
#define SHIFT_R               0x0052
#define SHIFT_S               0x0053
#define SHIFT_T               0x0054
#define SHIFT_U               0x0055
#define SHIFT_V               0x0056
#define SHIFT_W               0x0057
#define SHIFT_X               0x0058
#define SHIFT_Y               0x0059
#define SHIFT_Z               0x005A
#define SHIFT_1               0x0021
#define SHIFT_2               0x0040
#define SHIFT_3               0x0023
#define SHIFT_4               0x0024
#define SHIFT_5               0x0025
#define SHIFT_6               0x005E
#define SHIFT_7               0x0026
#define SHIFT_8               0x002A
#define SHIFT_9               0x0028
#define SHIFT_0               0x0029
#define SHIFT_DASH            0x005F
#define SHIFT_EQUAL           0x002B
#define SHIFT_OPENBRACKET     0x007B
#define SHIFT_CLOSEBRACKET    0x007D
#define SHIFT_BACKSLASH       0x007C
#define SHIFT_SEMICOLON       0x003A
#define SHIFT_APOSTROPHY      0x0022
#define SHIFT_COMMA           0x003C
#define SHIFT_PERIOD          0x003E
#define SHIFT_FORESLASH       0x003D
#define SHIFT_SINGLEOPENQUOTE 0x007E


#define CTRL_F1               0x015E
#define CTRL_F2               0x015F
#define CTRL_F3               0x0160
#define CTRL_F4               0x0161
#define CTRL_F5               0x0162
#define CTRL_F6               0x0163
#define CTRL_F7               0x0164
#define CTRL_F8               0x0165
#define CTRL_F9               0x0166
#define CTRL_F10              0x0167
#define CTRL_F11              0x0189
#define CTRL_F12              0x018A
#define CTRL_HOME             0x0177
#define CTRL_UARROW           0x018D
#define CTRL_PGUP             0x0184
#define CTRL_LARROW           0x0173
#define CTRL_RARROW           0x0174
#define CTRL_END              0x0175
#define CTRL_DARROW           0x0191
#define CTRL_PGDN             0x0176
#define CTRL_INS              0x0192
#define CTRL_DEL              0x0193
#define CTRL_BS               0x007F
#define CTRL_CR               0x000A
#define CTRL_TAB              0x0094
#define CTRL_A                0x0001
#define CTRL_B                0x0002
#define CTRL_C                0x0003
#define CTRL_D                0x0004
#define CTRL_E                0x0005
#define CTRL_F                0x0006
#define CTRL_G                0x0007
#define CTRL_H                0x0008
#define CTRL_I                0x0009
#define CTRL_J                0x000A
#define CTRL_K                0x000B
#define CTRL_L                0x000C
#define CTRL_M                0x000D
#define CTRL_N                0x000E
#define CTRL_O                0x000F
#define CTRL_P                0x0010
#define CTRL_Q                0x0011
#define CTRL_R                0x0012
#define CTRL_S                0x0013
#define CTRL_T                0x0014
#define CTRL_U                0x0015
#define CTRL_V                0x0016
#define CTRL_W                0x0017
#define CTRL_X                0x0018
#define CTRL_Y                0x0019
#define CTRL_Z                0x001A
#define CTRL_2                0x0103
#define CTRL_6                0x001E
#define CTRL_DASH             0x001F
#define CTRL_OPENBRACKET      0x001B
#define CTRL_CLOSEBRACKET     0x001D
#define CTRL_BACKSLASH        0x001C


#define ALT_F1                0x0168
#define ALT_F2                0x0169
#define ALT_F3                0x016A
#define ALT_F4                0x016B
#define ALT_F5                0x016C
#define ALT_F6                0x016D
#define ALT_F7                0x016E
#define ALT_F8                0x016F
#define ALT_F9                0x0170
#define ALT_F10               0x0171
#define ALT_F11               0x0186
#define ALT_F12               0x0187
#define ALT_CR                0x011C
#define ALT_TAB               0x01A5
#define ALT_A                 0x011E
#define ALT_B                 0x0130
#define ALT_C                 0x012E
#define ALT_D                 0x0120
#define ALT_E                 0x0112
#define ALT_F                 0x0121
#define ALT_G                 0x0122
#define ALT_H                 0x0123
#define ALT_I                 0x0117
#define ALT_J                 0x0124
#define ALT_K                 0x0125
#define ALT_L                 0x0126
#define ALT_M                 0x0132
#define ALT_N                 0x0131
#define ALT_O                 0x0118
#define ALT_P                 0x0119
#define ALT_Q                 0x0110
#define ALT_R                 0x0113
#define ALT_S                 0x011F
#define ALT_T                 0x0114
#define ALT_U                 0x0116
#define ALT_V                 0x012F
#define ALT_W                 0x0111
#define ALT_X                 0x012D
#define ALT_Y                 0x0115
#define ALT_Z                 0x012C
#define ALT_1                 0x0178
#define ALT_2                 0x0179
#define ALT_3                 0x017A
#define ALT_4                 0x017B
#define ALT_5                 0x017C
#define ALT_6                 0x017D
#define ALT_7                 0x017E
#define ALT_8                 0x017F
#define ALT_9                 0x0180
#define ALT_0                 0x0181
#define ALT_DASH              0x0182
#define ALT_EQUAL             0x0183
#define ALT_OPENBRACKET       0x011A
#define ALT_CLOSEBRACKET      0x011B
#define ALT_BACKSLASH         0x012B
#define ALT_SEMICOLON         0x0127
#define ALT_APOSTROPHY        0x0128
#define ALT_COMMA             0x0133
#define ALT_PERIOD            0x0134
#define ALT_FORESLASH         0x0135

#endif


