/*
	Copyright (c) 1993, BioPhotonics Corporation
				7300 West Huron River Drive
				Dexter, MI 48130
				(313)-426-8299

				ALL RIGHTS RESERVED

	filename:	editini.cpp

	purpose:	edit any *.ini file.
				Used as part of many install procedures

	instructions for building:
		compile:
		link:
		other:

	change log:
		When		Version	Who			Why
*/

/*
		PRAGMAS
*/

/*
		INCLUDE FILES
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys\stat.h>		/* for S_IREAD and S_IWRITE */
#include <fcntl.h>
#include <io.h>
#include <dos.h>
#include <dir.h>

#include "inifile.h"

/*
		LOCAL DEFINES AND MACROS
*/

/*
		LOCAL STRUCTURES AND TYPEDEFS
*/

/*
		FORWARD REFERENCES TO FUNCTIONS DEFINED IN THIS SOURCE FILE
*/

/*
		EXTERN FUNCTION AND DATA REFERENCES
*/

/*
		LOCAL DATA  (MAY BE GLOBAL OR STATIC)
*/

char cwdString[256];
char inBuf[256];

/*
	performs editing of a *.ini file.
	does some fancy recognition of a string like '$CWD' as a value
	and substitutes the current working directory
*/

int main ( int argc, char *argv[] )
{
	int rc;

	// you need an exefile name, an ini file name, a section name, and
	// at least a key name.  If that's all, the value will be reported.
	// If more is included on the command line, it will all be passed as
	// parameters to the write call
	if ( argc < 4 ) {
	  printf (
		"usage: editini inifilename sectionname keyname [new values...]\n" );
	  exit ( 30 );
	}

	FILE *pIniFile = fopen ( argv[1], "rt" );
	if ( !pIniFile ) {
		printf ( "editini: couldn't open ini file '%s'\n", argv[1] );
	  printf (
		"usage: editini inifilename sectionname keyname [new values...]\n" );
	  exit ( 30 );
	  printf (
		"usage: editini inifilename sectionname keyname [new values...]\n" );
	  exit ( 30 );
	}
	fclose ( pIniFile );

	char *pRC;
	int	cwdLen;

	// get the current working directory
	pRC = getcwd ( cwdString, sizeof ( cwdString ) );
	if ( !pRC ) {
		// couldn't get a current working directory
		cwdString[0] = '\0';
	}

	// count its length
	cwdLen = strlen ( cwdString );

	// if the cwd string is not null, then make sure it has a backslash
	// at the end
	if ( cwdLen  && cwdString[ cwdLen ] != '\\' ) {
		strcat ( cwdString, "\\" );
	}

	char rb[256];
	GetPrivateProfileString ( argv[2], argv[3], "not found", rb, 256, argv[1]);
	printf ( "INI file %s, section [%s]:\n", argv[1], argv[2] );
	printf ( "Current value for key '%s' is '%s'\n", argv[3], rb );
	
	// are there new values to write???
	if ( argc > 4 ) {
		// first, concat all the args after 4 together
		int	numArgs = 4;
		char otherArgs[256];
		otherArgs[0] = '\0';
		while (numArgs < argc) {
			// this is where numArgs is incremented
			if ( numArgs > 4 ) {
				strcat ( otherArgs, " " );
			}
			if ( !stricmp(argv[numArgs],"$CWD") ) {
				strcat ( otherArgs, cwdString );
			}
			else {
				strcat ( otherArgs, argv[numArgs++] );
			}
		}
		rc = WritePrivateProfileString(argv[2], argv[3], otherArgs, argv[1]);
	}
	// all done, exit
	return 0;
}
