#include <windows.h>
#include <memory.h>
#include "resource.h"
#include "itemlist.h"

#define APPL_NAME		"ItemTest\0"
#define APPL_CAPTION	"Item List Test\0"

HINSTANCE	hInst;
HWND		hWndMain;
HFONT		hFont=NULL;

void TestIt (VOID);
BOOL _export CALLBACK TestProc (HWND hDlg,UINT msg,WPARAM wParam,LPARAM lParam);

BOOL InitApplication(HINSTANCE hInstance);
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow);
void UnRegisterClasses(void);

int PASCAL WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nCmdShow)
{
    MSG msg;

    if (!hPrevInstance)			 
		if (!InitApplication(hInstance)) 
		    return (FALSE);
		    
    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);
    
	ItemListInit("",6,0);
    while ( GetMessage(&msg,NULL,NULL, NULL))
	{
		TranslateMessage(&msg);
		DispatchMessage(&msg);
    }
    
    UnRegisterClasses();

    return (msg.wParam);	  
}

LRESULT __export CALLBACK MainWndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
    switch (message) 
    {
		case WM_COMMAND:
		    switch (wParam)
		    {              
        		case ID_FILE_TEST:
        		{
        			FARPROC		lproc;
        			int			iret;
        				
        			lproc = MakeProcInstance((FARPROC)TestProc,hInst);
        			iret  = DialogBox (hInst,"TESTDLG",hWnd,lproc);
        			FreeProcInstance(lproc);
        			break;
        		}
        		case ID_FILE_EXIT:
        			PostMessage(hWnd,WM_CLOSE,0,0L);
        			break;
				default:
					return (DefWindowProc(hWnd, message, wParam, lParam));
	        }
			break;        
		case WM_DESTROY:		  
		    PostQuitMessage(0);
		    break;
		case WM_CLOSE:
			if (hFont)
				DeleteObject(hFont);     
			ItemListCleanup();
			DestroyWindow(hWnd);
			if (hWnd == hWndMain)
				PostQuitMessage(0);
		default:			 
		    return (DefWindowProc(hWnd, message, wParam, lParam));
    }

    return (NULL);
    
}

BOOL InitApplication(HINSTANCE hInstance)
{
    WNDCLASS  wc;

    wc.style = NULL; 
    wc.lpfnWndProc = MainWndProc; 
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
    wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH);
    wc.lpszMenuName =  "GENMENU";
    wc.lpszClassName = APPL_NAME;

    return (RegisterClass(&wc));

}
BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
    HWND            hWnd;

    hInst = hInstance;

    if ((hWnd = CreateWindow(
	        APPL_NAME,
	        APPL_CAPTION,
	        WS_OVERLAPPEDWINDOW,
	        CW_USEDEFAULT,      
	        CW_USEDEFAULT,      
	        CW_USEDEFAULT,      
	        CW_USEDEFAULT,      
	        NULL,               
	        NULL,               
	        hInstance,          
	        NULL                
    	))==NULL)
        return (FALSE);

	hWndMain = hWnd;
    ShowWindow(hWnd, nCmdShow);
    UpdateWindow(hWnd);
    return (TRUE);

}

void UnRegisterClasses(void)
{
	WNDCLASS   wndclass;   
	memset(&wndclass, 0x00, sizeof(WNDCLASS));
	UnregisterClass(APPL_NAME, hInst);
}
BOOL _export CALLBACK TestProc (HWND hDlg,UINT msg,WPARAM wParam,LPARAM lParam)
{
                                          
	char	szBuffer[128];
	
	switch (msg) {
		case WM_INITDIALOG:
			SetFocus(GetDlgItem(hDlg,IDC_ADDITEM));
			break;
		case WM_COMMAND:
			if (wParam==IDOK)
			{
				GetDlgItemText ( hDlg, IDC_ADDITEM, szBuffer,sizeof(szBuffer));
				ItemListAdd (GetMenu(hWndMain),szBuffer);
				EndDialog(hDlg,TRUE);
				return TRUE;
            }                                                        
            else
           		if (wParam==IDCANCEL)
                {
					GetDlgItemText ( hDlg, IDC_ADDITEM, szBuffer,sizeof(szBuffer));
					ItemListRemove ( GetMenu(hWndMain),szBuffer);
					EndDialog(hDlg,FALSE);
					return TRUE;
				}   
	}
	
	return FALSE;
}