/*
	VGAKIT Version 6.0

	Copyright 1988,89,90,91,92,93,94 John Bridges
	Free for use in commercial, shareware or freeware applications

	GRAV.C
*/

extern long atol();

extern int maxx,maxy;

#define TICKS  (*(unsigned int far *)0x0040006cl)
#define KBHEAD (*(unsigned int far *)0x0040001al)
#define KBTAIL (*(unsigned int far *)0x0040001cl)

#define MAXOBJS (256)

double topspeed=100000000.;

long steps=1000000l;

long speed=1000;

#define XSIZE maxx
#define YSIZE maxy

int MOVOBJS=7;
int FIXOBJS=1;

#define OBJS (MOVOBJS+FIXOBJS)

extern double sqrt(double v);

double xpos[MAXOBJS];
double ypos[MAXOBJS];
double mass[MAXOBJS];

double speeddiv=1000000.;

int massbase=40;
int massrnd=50;

int charge[MAXOBJS];	/* Can be 1 or -1, or 0 (always) or 2 (never) */

int ox[MAXOBJS];
int oy[MAXOBJS];

double deltax[MAXOBJS];
double deltay[MAXOBJS];

double scale=1.;

unsigned char cols[]={9,10,11,12,13,14,1,2,3,4,5,6,7,15};

#define MAX (10000.)

void repos(int i,int ia)
{
	double dx;
	double dy;
	double d;
	double addx,addy;
	double v,mm;

	if(ia>=OBJS) ia-=OBJS;
	dx=xpos[ia]-xpos[i];
	dy=ypos[ia]-ypos[i];
	d=sqrt(dx*dx+dy*dy);
	if(d<MAX)
	{
		mm=((MAX*MAX-d*d)*mass[ia])/(MAX*MAX*speeddiv);
		addx=mm*dx;
		addy=mm*dy;
		if((charge[ia] && charge[i]==charge[ia]) || charge[ia]==2)
		{
			deltax[i]-=addx;
			deltay[i]-=addy;
		}
		else
		{
			deltax[i]+=addx;
			deltay[i]+=addy;
		}
	}
}

static int midx,midy;

blob(int i)
{
	int xx,yy;
	int col;

	if(i<sizeof(cols))
		col=cols[i];
	else
		col=(i-sizeof(cols))+32;
	xx=ox[i];
	yy=oy[i];
	xx+=midx;
	yy+=midy;
	xpoint(xx+4,yy+3,col);
	xpoint(xx+3,yy+3,col);
	xpoint(xx+2,yy+3,col);
	xpoint(xx+1,yy+3,col);
	xpoint(xx,yy+3,col);
	xpoint(xx-1,yy+3,col);
	xpoint(xx-2,yy+3,col);
	xpoint(xx-3,yy+3,col);
	xpoint(xx-4,yy+3,col);

	xpoint(xx+3,yy+2,col);
	xpoint(xx+2,yy+2,col);
	xpoint(xx+1,yy+2,col);
	xpoint(xx,yy+2,col);
	xpoint(xx-1,yy+2,col);
	xpoint(xx-2,yy+2,col);
	xpoint(xx-3,yy+2,col);

	xpoint(xx+2,yy+1,col);
	xpoint(xx+1,yy+1,col);
	xpoint(xx,yy+1,col);
	xpoint(xx-1,yy+1,col);
	xpoint(xx-2,yy+1,col);

	xpoint(xx+1,yy,col);
	xpoint(xx,yy,col);
	xpoint(xx-1,yy,col);
	
	xpoint(xx,yy-1,col);
}

extern unsigned int rand(void);

randomize()
{
	srand(TICKS);
}

#define rchoose(i) (rand()%(i))


main(argc,argv)
int argc;
char **argv;
{
	int n;
	int i;
	int key;
	int svga;
	int chand;
	int first;
	unsigned long oticks;
	long frames;
	long clocks;
	long count;
	int xx,yy;

	if(--argc)
	{
		MOVOBJS=atol(*++argv);
		if(--argc)
		{
			FIXOBJS=atol(*++argv);
			if(--argc)
			{
				speed=atol(*++argv);
				if(--argc)
				{
					massbase=atol(*++argv);
					if(--argc)
					{
						massrnd=atol(*++argv);
						if(--argc)
						{
							steps=atol(*++argv);
						}
					}
				}
			}
		}
	}
	speeddiv=topspeed/speed;
	chand=1;
	if(MOVOBJS<0)
	{
		chand=0;
		MOVOBJS=-MOVOBJS;
	}
	if(!FIXOBJS)
		scale=100;
	svga=whichvga();	
	if(svga)
	{
		svga640();
	}
	else
	{
		mode13x();
	}
	midx=XSIZE/2;
	midy=YSIZE/2;
	first=1;
	frames=0;
redo:	key=0;
	for(i=0;i<OBJS;i++)
	{
		deltax[i]=0;
		deltay[i]=0;
	}
	count=steps;
	for(i=0;i<MOVOBJS;i++)
	{
		xx=rchoose(XSIZE)-midx;
		yy=rchoose(YSIZE)-midy;
		xpos[i]=xx;
		ypos[i]=yy;
		xx=xpos[i]/scale;
		yy=ypos[i]/scale;
		ox[i]=xx;
		oy[i]=yy;
		mass[i]=(rchoose(massrnd)+massbase)/100.;
		charge[i]=0;
		if(chand)
		{
			if(i&1)
				charge[i]=1;
			else
				charge[i]=-1;
		}
		blob(i);
	}
	if(FIXOBJS)
	{
		xpos[MOVOBJS]=0;
		ypos[MOVOBJS]=0;
		mass[MOVOBJS]=2.;
		charge[MOVOBJS]=0;
	}
	for(i=MOVOBJS+1;i<OBJS;i++)
	{
		xpos[i]=rchoose(XSIZE)-midx;
		ypos[i]=rchoose(YSIZE)-midy;
		mass[i]=2.;
		charge[i]=0;
		++i;
	}
	oticks=TICKS;
	while(oticks==TICKS)
		;
	while(key!=27 && key!=13 && count)
	{
		--count;
		for(i=0;i<MOVOBJS;i++)
		{
			xx=xpos[i]/scale;
			yy=ypos[i]/scale;
			if(xx!=ox[i] || yy!=oy[i])
			{
				blob(i);
				ox[i]=xx;
				oy[i]=yy;
				blob(i);
			}
			for(n=1;n<OBJS;n++)
				repos(i,i+n);
			xpos[i]+=deltax[i];
			ypos[i]+=deltay[i];
		}
		if(first)
		{
			++frames;
			clocks=TICKS-oticks;
			if(clocks<0)
				clocks+=0x001800b0l;
			if(clocks>50)
			{
				speed=(speed*1238.)/frames;
				speeddiv=topspeed/speed;
				first=0;
				randomize();
				count=0;
				break;
			}
		}
		else
		{
			if(KBHEAD!=KBTAIL)
			{
				key=getch();
			}
			if(key)	switch(key)
			{
				case 13:
					break;
				case 27:
					break;
				case '+':
					scale=scale/1.414213562;
					key=0;
					break;
				case '-':
					scale=scale*1.414213562;
					key=0;
					break;
				case '[':
					scale=scale*1.001;
					break;
				case ']':
					scale=scale/1.001;
					break;
				default:
					key=0;
			}
		}
	}
	for(i=0;i<MOVOBJS;i++)
	{
		blob(i);
	}
	if(!count || key!=27)
		goto redo;
	txtmode();
}



