;This program is the TASM version of the MASM pogram in Example 1 of the XLIB
;documentation.  TASM programs must resize the DOS memory block in which they
;are contained so that there will be some free memory for allocation by
;INITXLIB.  The initialization code for the program below determines the size
;of the program from the facts that at startup, ES:0000 will equal the address
;of the program segment prefix, and SS:SP will equal the terminal address of
;the program.

               MASM51                        ;Use MASM 5.1 compatibility mode
               QUIRKS                        ;Allow MASM 5.1 quirks
               NOSMART                       ;No optimization on MASM 5.1

PUSHW          MACRO IMMEDIATE16             ;Macro to PUSH 16-bit contant
               IF (@WordSize EQ 4)
               DB             66H
               ENDIF
               DB             68H
               DW             IMMEDIATE16
               ENDM

PUSHD          MACRO IMMEDIATE32             ;Macro to PUSH 32-bit constant
               IF (@WordSize EQ 2)
               DB             66H
               ENDIF
               DB             68H
               DD             IMMEDIATE32
               ENDM

               .MODEL        LARGE,PASCAL
               .386P
               DOSSEG                        ;Place stack at highest address

               INCLUDE        XLIBB.INC      ;Include XLIBB public symbols
               INCLUDELIB     XLIBB.LIB      ;Link with XLIBB.LIB

               .STACK         1024
               .CODE
               .STARTUP
               MOV            AX,SP          ;Resize program memory block
               SHR            AX,4
               MOV            BX,SS
               ADD            BX,AX
               INC            BX             ;BX = first para. beyond program
               MOV            AX,ES
               SUB            BX,AX          ;BX = program size in paragraphs
               MOV            AH,4AH         ;Resize memory block at ES:0000
               INT            21H
               JC             MAINEXIT       ;Failed to resize

               CALL           INITXLIB       ;Initialize XLIB
               OR             EAX,EAX        ;EAX = 0 if successful
               JNZ            MAINEXIT

INITDONE:      PUSHD          <OFFSET DEMOPROC>
               CALL           CALLPM         ;Execute DEMOPROC in protected
MAINEXIT:      MOV            AX,4C00H       ;DOS termination function
               INT            21H

;Protected-mode routines must be placed in following segment:
TSEG           SEGMENT PARA PUBLIC USE32 'CODE'
               ASSUME CS:TSEG, SS:TSEG, DS:TSEG, ES:TSEG, FS:DSEG, GS:DGROUP

;Protected-mode routine to print message to the screen using DOS function.
DEMOPROC       PROC NEAR
               MOV            EBX,OFFSET PMMSG
               MOV            AH,02H
MSGLOOP:       MOV            DL,CS:[EBX]    ;32-bit offset!!!!!
               OR             DL,DL
               JZ             EXIT
               INT            21H            ;Print character with DOS
               INC            EBX
               JMP            MSGLOOP
EXIT:          RET                           ;Go back to real or V86 mode
PMMSG          DB  "In 32-bit protected mode!!!  "
               DB  "Returning to real mode.",10,13,0
DEMOPROC       ENDP

TSEG           ENDS
               END
