
// EMS Class - test case
// Copyright 1993 Scott Diorio
// All rights reserved


#include <process.h>
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>
#include <fcntl.h>
#include <io.h>

#include "emsclass.hpp"

#define CHUNK 4096
#define ON 1
#define OK 0

int test1(void);
int test2(void);
int test3(void);

EmsKernel EMS(ON);

void main(void)
{
	int pages;
	if(( pages=EMS.SystemPagesFree() ) ==-1)
		exit(-1);

	cout << "System EMS Pages Free: " << pages << endl;
	cout << "EMS Pages Free:  " << EMS.PagesFree() << endl;;

	EMS.Alloc(50); // Alloc 50 - 16K pages
	cout << "EMS Pages Free:  " << EMS.PagesFree() << endl;;

	// test 1
	if(test1())
		{
			cout << "test 1 failed\n";
			exit(-1);
		}
	cout << "test 1 passed\n";
	cout << "\n" << farcoreleft() << endl;

	// test 2
	if(test2())
		{
			cout << "test 2 failed\n";
			exit(-1);
		}
	cout << "test 2 passed\n";
	cout << "\n" << farcoreleft() << endl;

	// test 3
	if(test3())
		{
			cout << "test 3 failed\n";
			exit(-1);
		}
	cout << "test 3 passed\n";
	cout << "\n" << farcoreleft() << endl;

}


/////////////////////////////////////////////////////////////////////////
// Test Creation and destruction of EMS buffers
int test1(void)
{
	long mem=farcoreleft();
	EMSbuf *A;
	A=new EMSbuf(100000);

	EMSbuf *B;
	B=new EMSbuf(100000);

	EMSbuf *C;
	C=new EMSbuf(100000);

	delete(B);
	delete(A);
	delete(C);
	if(farcoreleft() != mem)
		return(-1);
	else
		return(0);
}

/////////////////////////////////////////////////////////////////////////
// Test single character manipulation in EMS buffer
int test2(void)
{
	// create two EMS buffers
	EMSbuf A(131072);
	EMSbuf B(131072);

	unsigned long t;

	// assign random values to first buffer
	for(t=0;t<=100000;t++)
		{
			A[t]=random(255);
		}

	memset(A,'c',100000);

	// copy buffer A to buffer B one character at a time
	for(t=0;t<=100000;t++)
		{
			B[t]=A[t];
		}

	// loop through and test buffers A and B for equivilance
	for(t=0;t<100000;t++)
		{
			if( B[t] != A[t])
				{
					cout << t << "  " << t << endl;
					cout << (int)A[t] << endl;
					cout << (int)B[t] << endl;
				}
		}

	// create two character buffers
	static unsigned char *a=new char[CHUNK];
	static unsigned char *b=new char[CHUNK];

	// loop through and test buffers A and B for equivilance
	for(unsigned long q=0;q<100000;q+=CHUNK)
		{
			memcpy(a,A+q,CHUNK);
			memcpy(b,B+q,CHUNK);
			for(t=0;t<CHUNK;t++)
				{
					if(a[t]!=b[t])
						{
							cout << q << "  " << t << endl;
							cout << (int)a[t] << endl;
							cout << (int)b[t] << endl;
							return(-1);
						}
				}
		}
	delete(a);
	delete(b);
	return(OK);
}

/////////////////////////////////////////////////////////////////////////
// Tests 1) Setting EMS buffers
//       2) Copying between character buffers and EMS buffers
//
// The results are displayed on screen
//
// Set breakpoints to follow example

#define TESTSIZE 40000

int test3(void)
{
	unsigned t;
	char ch;

	EMSbuf *A;
	A=new EMSbuf(TESTSIZE);
	memset( A, '1', TESTSIZE);     // friend function to EMSbuf

	// display results of memset
	cout << "Press <spacebar> to see results, any other key to skip\n";
	cout << "Be patient, it takes a few seconds to display " << TESTSIZE << " characters\n\n";
	ch=getch();
	if(ch==32)
		cout << A << endl;

	char *tmp;
	tmp=new unsigned char[TESTSIZE];
	memset(tmp,'2',TESTSIZE);      // normal memset

	memcpy( A,tmp,TESTSIZE);
	// display results of memcpy
	cout << "Press <spacebar> to see results, any other key to skip\n";
	cout << "Be patient, it takes a few seconds to display " << TESTSIZE << " characters\n\n";
	ch=getch();
	if(ch==32)
		cout << A << endl;

	delete(A);

////////////////////////////////////////////////////////////////////
//
// This example show how you can access an EMS buffer like a char
// array using the overloaded operator '+'
//

	EMSbuf B(TESTSIZE);

	memset(B,'*',TESTSIZE);
	memset(tmp,'!',TESTSIZE);

	// Copy 10,000 characters from character buffer 'tmp'
	// starting 20 characters into EMS buffer B
	//
	//
	//         overloaded operator
	//        /
	memcpy( B+20, tmp, 10000);

	cout << "Press <spacebar> to see results, any other key to skip\n";
	cout << "Be patient, it takes a few seconds to display " << TESTSIZE << " characters\n\n";
	ch=getch();
	if(ch==32)
		cout << B << endl;

	delete(tmp);
	return(OK);
}

/*
	int FH,FH2;
	unsigned long got,put;

	FH=_open("e:\\c\\vid\\skull.tga", O_RDONLY);
	got=read(FH,tmp,800000);
	_close(FH);

	FH2=_creat("skull.tga",0);
	put=write(FH2,tmp,got);
	_close(FH2);
*/
