
// EMS Class headers
// Copyright 1993 Scott Diorio
// All rights reserved
//
// Version 1.0
//
// This code is copyrighted and may not be modified without the prior
// written consent of the author.
//
//
//
// EMS Kernel Object and EMS buffer object
//
//

#ifndef _EMSKERNEL.HPP_
#define _EMSKERNEL.HPP_

#include <iostream.h>

#define MAX_EMS_HANDLES 32768
#define EMSPAGESIZE 0x4000

#define EMS_INSTALL 0
#define EMS_ALLOC 1

struct EMS_handle
{
	int id;
	int pagecnt;
	unsigned long size;
	int *pages;
};

struct EMSoffset
{
	int page;
	int offset;
};

class EMSbuf;
class EmsKernel
{
	protected:
		static int EmsClassHandle;
		static char maplist[256];
		static char active[4];
		static int ErrNum;
		static int Allocated;
		static int searchfree;
		static unsigned *systempageinfo;
		static unsigned systemfreepages;
		static int _EmsKernelInstansiation_;
		static int classcnt;
		static int debugstate;
		static int nextactive;

		inline int SingleMap(int,int);

		int Free(void);
		int FirstFree(void);
		int NextFree(void);
		int Installed(void);
		int SetEnvironmentEMShandle(int);
		int Map(int,int,int,int);
		int FreeHandleOnDisk(void);
		EMS_handle GetSpace(unsigned long);
		void FreeSpace(EMS_handle &);
		int Version(void);
	public:
		EmsKernel(int debug=0);
		~EmsKernel(void);
		int SystemPagesFree(void);
		int PagesFree(void) { return(systemfreepages); };
		int Alloc(int);

//		int Save(void);      // next Version
//		int Restore(void);
//		char *ErrMsg(void);

};

class EMSbuf : public EmsKernel
{
	protected:
		EMS_handle handle;
		unsigned long offset;
		int lastmap;

	public:
		EMSbuf(void);

		EMSbuf(unsigned long);
		~EMSbuf(void);
		unsigned long Size(void);

		// overloaded operators ------------------------------------------

		inline char& operator[](unsigned long index);
		inline EMSbuf& operator+(unsigned long);

		operator const char*();
		operator const unsigned char*();
		operator const int*();
		operator const unsigned int*();
		operator const void*();

		//----------------------------------------------------------------

		friend ostream& operator << ( ostream&, EMSbuf &);
		friend ostream& operator << ( ostream&, EMSbuf *);

		friend unsigned long read(int, EMSbuf &, unsigned long);
		friend unsigned long read(int, EMSbuf *, unsigned long);

		friend unsigned long write(int, EMSbuf &, unsigned long);
		friend unsigned long write(int, EMSbuf *, unsigned long);

		friend EMSbuf& memset(EMSbuf &, int, unsigned long);
		friend EMSbuf& memset(EMSbuf *, int, unsigned long);

		friend EMSbuf& memcpy(EMSbuf &, void *, size_t);
		friend EMSbuf& memcpy(EMSbuf *, void *, size_t);
		friend void *  memcpy(void *, EMSbuf &, size_t);
		friend void *  memcpy(void *, EMSbuf *, size_t);

		friend EMSbuf& memcpy(EMSbuf &, EMSbuf &, unsigned long);
		friend EMSbuf& memcpy(EMSbuf *, EMSbuf *, unsigned long);
		friend EMSbuf& memcpy(EMSbuf &, EMSbuf *, unsigned long);
		friend EMSbuf& memcpy(EMSbuf *, EMSbuf &, unsigned long);
};


// function prototypes

inline EMSoffset GetPageOffsetLocation(unsigned long);

unsigned long read(int, EMSbuf &, unsigned long);
unsigned long read(int, EMSbuf *, unsigned long);

unsigned long write(int, EMSbuf &, unsigned long);
unsigned long write(int, EMSbuf *, unsigned long);

EMSbuf& memset(EMSbuf &, int, unsigned long);
EMSbuf& memset(EMSbuf *, int, unsigned long);

EMSbuf& memcpy(EMSbuf &, void *, size_t);
EMSbuf& memcpy(EMSbuf *, void *, size_t);
void *  memcpy(void *, EMSbuf &, size_t);
void *  memcpy(void *, EMSbuf *, size_t);
EMSbuf& memcpy(EMSbuf &, EMSbuf &, unsigned long);
EMSbuf& memcpy(EMSbuf *, EMSbuf *, unsigned long);
EMSbuf& memcpy(EMSbuf &, EMSbuf *, unsigned long);
EMSbuf& memcpy(EMSbuf *, EMSbuf &, unsigned long);

extern char* PageFrame;

#endif
